# 스타일 일관성 분석 예시

이 문서는 `inconsistent.md`에서 `consistent.md`로 교정하는 과정에서 감지된 스타일 불일치와 교정 근거를 설명합니다.

---

## 문서 타입 분석

- **판단**: 비즈니스 문서 (제품 소개서)
- **근거**: 고객 대상, 공식적 톤, 제품 정보 포함
- **권장 스타일**: 격식체 경어 (~합니다), 표준 용어, 일관된 날짜 형식

---

## 발견된 불일치 (총 23개)

### 1. 어조 및 격식 (3개)

#### 불일치 #1: 경어체 혼용
- 🔄 "~합니다": 8회 사용
- 🔄 "~해요": 2회 사용 ("제공해요", "보호해요")
- ✅ **제안**: 비즈니스 문서이므로 "~합니다" 격식체로 통일
- 📚 **근거**: 국립국어원 공문서 작성 지침 - 대외 문서는 격식체 사용

**교정**:
- "제공해요" → "제공합니다"
- "보호해요" → "보호합니다"

#### 불일치 #2: 주어 불일치
- 🔄 "우리 회사": 1회 (문서 끝)
- 🔄 "저희 회사": 1회 (문서 시작)
- ✅ **제안**: 고객 대상 문서이므로 "저희"로 통일 (겸양 표현)
- 📚 **근거**: 실무 관행 - 대외 문서는 겸손한 표현 사용

**교정**:
- "© 2026 우리 회사" → "© 2026 저희 회사"

#### 불일치 #3: 문장 종결 불완전
- 🔄 "개발자는 SDK를 사용하여 기능 확장" (종결어미 없음)
- ✅ **제안**: 완전한 문장으로 종결
- 📚 **근거**: 문법 규칙 - 문장은 종결어미로 끝나야 함

**교정**:
- "기능 확장" → "기능을 확장할 수 있습니다"

---

### 2. 용어 통일 (5개)

#### 불일치 #4: 동일 개념 다른 표현
- 🔄 "사용자": 4회
- 🔄 "유저": 1회
- ✅ **제안**: "사용자"로 통일 (다수결 + 공식 문서 표준)
- 📚 **근거**: 국립국어원 표준 용어

**교정**:
- "유저는 여러 기기에서..." → "사용자는 여러 기기에서..."

#### 불일치 #5: 외래어 표기 - 띄어쓰기
- 🔄 "데이터 베이스": 1회 (띄어쓰기)
- 🔄 "웹사이트": 1회 (붙여쓰기)
- ✅ **제안**: "데이터베이스", "웹사이트" 붙여쓰기로 통일
- 📚 **근거**: 국립국어원 외래어 표기법

**교정**:
- "데이터 베이스" → "데이터베이스"

#### 불일치 #6: 띄어쓰기 오류 (의존명사)
- 🔄 "접근할수있습니다" (붙여쓰기 오류)
- ✅ **제안**: "접근할 수 있습니다" (의존명사 "수" 띄어쓰기)
- 📚 **근거**: 국립국어원 띄어쓰기 규정

**교정**:
- "접근할수있습니다" → "접근할 수 있습니다"

#### 불일치 #7: 외래어 약어
- 🔄 "Android OS" (공식 표기)
- 🔄 "Android" (축약)
- ✅ **제안**: "Android"로 통일 (공식 제품명, OS 생략 가능)
- 📚 **근거**: Kakao Enterprise 가이드 - "AOS"는 비공식, "Android" 사용

**교정**:
- "Android OS" → "Android"

#### 불일치 #8: 따옴표 혼용
- 🔄 큰따옴표 ("사용자"): 1회
- 🔄 작은따옴표 ('보안'): 1회
- ✅ **제안**: 강조 표기는 **굵게**로 통일 (용어 강조에 따옴표 불필요)
- 📚 **근거**: 테크니컬 라이팅 가이드 - 강조는 굵게 또는 기울임

**교정**:
- "사용자" → 사용자 (따옴표 제거)
- '보안' → **보안** (굵게 처리)

---

### 3. 숫자 및 단위 (4개)

#### 불일치 #9: 단위 띄어쓰기
- 🔄 "4 GB" (띄어쓰기): 1회
- 🔄 "500MB" (붙여쓰기): 1회
- ✅ **제안**: SI 표기법에 따라 "4 GB", "500 MB" 띄어쓰기로 통일
- 📚 **근거**: 국제단위계(SI) 표기법

**교정**:
- "500MB" → "500 MB"

#### 불일치 #10: 화폐 단위 띄어쓰기
- 🔄 "10,000 원" (띄어쓰기): 1회
- 🔄 "5만원" (붙여쓰기): 1회
- ✅ **제안**: "10,000원", "50,000원"으로 통일 (아라비아 숫자 + 붙여쓰기)
- 📚 **근거**: 실무 관행

**교정**:
- "10,000 원" → "10,000원"
- "5만원" → "50,000원" (표기 형식 통일)

#### 불일치 #11: 숫자 표기 혼용
- 🔄 "20%" (아라비아 숫자): 기본
- 🔄 "1년" (아라비아 + 한글): 관용 표현 허용
- ✅ **판단**: 혼용 허용 (구체적 수치는 아라비아, 기간은 혼용 가능)
- 📚 **근거**: 실무 관행

**교정 불필요**

#### 불일치 #12: 퍼센트 띄어쓰기
- 🔄 모두 "20%" (올바름)
- ✅ **판단**: 일관적, 교정 불필요

---

### 4. 목록 구조 (2개)

#### 불일치 #13: 목록 부호 혼용
- 🔄 "1. 2. 3.": 2개 목록
- 🔄 "1. - 3)": 1개 목록 (혼용)
- ✅ **제안**: 모두 "1. 2. 3." 형식으로 통일
- 📚 **근거**: Markdown 관행 + 다수결

**교정**:
```
1. 빠른 처리 속도
- 메모리 효율성 개선  →  2. 메모리 효율성 개선
3) 직관적인 UI  →  3. 직관적인 UI
```

#### 불일치 #14: 목록 종결어미 혼용
- 🔄 완전 문장 ("~합니다"): 2개 항목
- 🔄 명사형 ("계정 생성", "기능 확장"): 2개 항목
- 🔄 명령형 ("~하세요"): 1개 항목
- ✅ **제안**: "~합니다" 완전 문장으로 통일
- 📚 **근거**: 문서의 격식적 톤 + 다수결

**교정**:
```
2. 계정 생성  →  2. 계정을 생성합니다.
3) 로그인하세요  →  3. 로그인합니다.
- 설정 메뉴에서 환경 설정  →  4. 설정 메뉴에서 환경을 설정합니다.
```

---

### 5. 인용 및 강조 (3개)

#### 불일치 #15: 강조 표기 혼용
- 🔄 **굵게**: 2회 ("혁신적인", "API")
- 🔄 *기울임*: 1회 ("데이터 베이스")
- 🔄 따옴표: 2회 ("사용자", '보안')
- 🔄 백틱: 1회 (`SDK`)
- ✅ **제안**: 일반 강조는 **굵게**, 코드/명령어는 백틱(`)으로 구분
- 📚 **근거**: 테크니컬 라이팅 가이드

**교정**:
- *데이터 베이스* → **데이터베이스** (굵게 + 띄어쓰기 수정)
- "사용자" → 사용자 (따옴표 제거, 강조 불필요)
- '보안' → **보안** (굵게)

#### 불일치 #16: 백틱 사용 불일치
- 🔄 **API** (굵게): 1회
- 🔄 `SDK` (백틱): 1회
- ✅ **제안**: 기술 용어는 **굵게**, 코드 관련은 백틱 유지
- 📚 **근거**: API/SDK는 기술 용어이지 코드가 아님

**교정**:
- 일관성을 위해 둘 다 **굵게** 또는 둘 다 일반 텍스트
- 이 예시에서는 둘 다 **굵게** 처리

#### 불일치 #17: 특수 강조 (하이라이트)
- 🔄 ==기밀== (하이라이트): 1회
- 🔄 ⚠️ (이모지): 1회
- ✅ **제안**: 공식 문서이므로 **굵게**로 통일, 이모지 제거
- 📚 **근거**: 비즈니스 문서는 전문적 톤 유지

**교정**:
- "==기밀==입니다. ⚠️ 외부 유출 금지!" → "**기밀**입니다. **외부 유출을 금지합니다.**"

---

### 6. 날짜 및 시간 (3개)

#### 불일치 #18: 날짜 형식 혼용
- 🔄 "YYYY년 MM월 DD일": 1회
- 🔄 "YYYY.MM.DD": 1회
- 🔄 "YYYY-MM-DD": 1회
- 🔄 "M월 D일" (연도 생략): 1회
- ✅ **제안**: "YYYY년 MM월 DD일" 한글 형식으로 통일
- 📚 **근거**: 비즈니스 문서 관행 + 가독성

**교정**:
- "2026.02.15" → "2026년 2월 15일"
- "2026-03-01" → "2026년 3월 1일"
- "4월 1일" → "2026년 4월 1일" (문맥상 2026년 추가)

#### 불일치 #19: 시간 형식 혼용
- 🔄 12시간제 ("오전 9시"): 1회
- 🔄 24시간제 ("18:00"): 1회
- 🔄 영어 ("10 AM ~ 3 PM"): 1회
- ✅ **제안**: 12시간제 한글로 통일 (대중 독자 대상)
- 📚 **근거**: 가독성 + 한국 일상 관행

**교정**:
- "18:00" → "오후 6시"
- "10 AM ~ 3 PM" → "오전 10시부터 오후 3시"

#### 불일치 #20: 시간 범위 표기
- 🔄 "~부터 ~까지": 1회
- 🔄 "~": 1회 (틸드)
- 🔄 "~": 1회 (물결표)
- ✅ **제안**: 명확성을 위해 "~부터 ~까지" 사용
- 📚 **근거**: 명확한 의사소통

**교정**:
- "2026년 1월 15일 ~ 2026년 2월 15일" → "2026년 1월 15일부터 2026년 2월 15일까지"

---

### 7. 링크 및 참조 (3개)

#### 불일치 #21: 링크 텍스트 혼용
- 🔄 설명적 텍스트: 0회
- 🔄 "여기": 1회
- 🔄 URL 직접 노출: 1회
- ✅ **제안**: 모두 설명적 텍스트로 교체
- 📚 **근거**: 웹 접근성 가이드 - 스크린 리더 사용자 고려

**교정**:
- "[여기](https://example.com/docs)" → "[사용자 가이드](https://example.com/docs)"
- "https://example.com/faq" → "[FAQ 페이지](https://example.com/faq)"

#### 불일치 #22: 참조 번호 형식 혼용
- 🔄 상첨자 (¹): 1회
- 🔄 대괄호 ([2]): 1회
- ✅ **제안**: 대괄호 [1], [2] 형식으로 통일
- 📚 **근거**: 기술 문서 관행 (IEEE 스타일)

**교정**:
- "연구¹를" → "연구[1]를"
- 참고문헌 번호도 "[1]", "[2]"로 통일

#### 불일치 #23: 참고문헌 표기 형식
- 🔄 한글 저자: 1개
- 🔄 영어 저자: 1개
- ✅ **제안**: 형식 통일 (저자, 연도, 제목, 출판사)
- 📚 **근거**: 일관된 인용 형식

**교정**:
- 한글/영어 관계없이 동일한 형식 적용
- 따옴표 제거 (제목에 따옴표 불필요)

---

## 교정 요약

### 카테고리별 통계

| 카테고리 | 불일치 개수 | 주요 문제 |
|---------|-----------|---------|
| 어조 및 격식 | 3개 | 경어체 혼용, 주어 불일치 |
| 용어 통일 | 5개 | 사용자/유저, 외래어 띄어쓰기 |
| 숫자 및 단위 | 4개 | 단위 띄어쓰기, 화폐 표기 |
| 목록 구조 | 2개 | 부호 혼용, 종결어미 불일치 |
| 인용 및 강조 | 3개 | 강조 방법 혼용, 이모지 |
| 날짜 및 시간 | 3개 | 날짜 형식 혼용, 시간 형식 |
| 링크 및 참조 | 3개 | "여기" 사용, 참조 번호 혼용 |
| **합계** | **23개** | |

### 교정 우선순위

1. **높음 (즉시 수정)**: 경어체 혼용, 목록 부호, 날짜 형식, 참조 번호
2. **중간 (권장 수정)**: 용어 통일, 단위 띄어쓰기, 링크 텍스트
3. **낮음 (선택 수정)**: 강조 표기 세부사항, 시간 범위 표현

---

## 스타일 가이드 권장사항

이 문서를 위한 프로젝트 스타일 가이드:

### 어조
- [x] 경어체: "~합니다" 사용
- [x] 주어: "저희" (고객 대상 문서)

### 용어
- [x] "사용자" (not "유저")
- [x] "데이터베이스" (붙여쓰기)
- [x] "웹사이트" (붙여쓰기)
- [x] "Android" (not "Android OS")

### 숫자 및 단위
- [x] 단위 띄어쓰기: "4 GB", "500 MB"
- [x] 화폐: "10,000원" (붙여쓰기)
- [x] 퍼센트: "20%" (붙여쓰기)

### 목록
- [x] 부호: "1. 2. 3."
- [x] 종결: "~합니다" 완전 문장

### 강조
- [x] 일반 강조: **굵게**
- [x] 코드/명령어: `백틱`
- [x] 이모지: 사용 자제

### 날짜 및 시간
- [x] 날짜: "YYYY년 MM월 DD일"
- [x] 시간: 12시간제 ("오전/오후")

### 링크
- [x] 설명적 텍스트 사용 (not "여기")

### 참조
- [x] 대괄호 번호: [1], [2]

---

이 가이드를 프로젝트 전체에 적용하면 문서의 일관성과 전문성이 크게 향상됩니다.
