# 날짜, 시간 및 참조 형식

이 문서는 한국어 문서에서 날짜, 시간, 참조를 일관되게 표기하기 위한 패턴과 기준을 설명합니다.

## 패턴 16: 날짜 형식

**메타데이터**:
- 출처: 국제 표준(ISO 8601), 한국 공문서 관행
- 권위: 🏛️ 국제 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

날짜 표기 방식이 일관적이지 않으면 독자가 혼란을 느끼고, 특히 국제 문서에서는 오해의 소지가 있습니다.

### 주요 날짜 형식

#### 1. 한글 표기 (YYYY년 MM월 DD일)

**사용처**: 공문서, 비즈니스 문서, 일반 한국어 문서

```
✅ 올바른 예시:
2026년 1월 27일
2026년 1월 1일
2026년 12월 31일
```

**변형**:
```
✅ 연도 생략 (같은 해):
1월 27일

✅ 요일 추가:
2026년 1월 27일(월요일)
2026년 1월 27일 월요일
```

#### 2. 점(.) 구분 (YYYY.MM.DD)

**사용처**: 간결한 표기, 양식, 로그

```
✅ 올바른 예시:
2026.01.27
2026.1.27 (월 자릿수 가변)
```

#### 3. 하이픈(-) 구분 (YYYY-MM-DD)

**사용처**: ISO 8601 국제 표준, 기술 문서, 데이터베이스

```
✅ 올바른 예시:
2026-01-27
```

**장점**:
- 국제 표준이므로 다국어 문서에 적합
- 정렬 시 시간순 자동 정렬
- 프로그래밍에서 표준 형식

#### 4. 슬래시(/) 구분

**주의**: 국가별로 순서가 다름
- 미국: MM/DD/YYYY (01/27/2026)
- 유럽: DD/MM/YYYY (27/01/2026)
- 혼란 방지를 위해 한국 문서에서는 비권장

```
⚠️ 혼란 가능:
01/27/2026 (미국식)
27/01/2026 (유럽식)
2026/01/27 (동아시아식)
```

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"프로젝트는 2026년 1월 27일에 시작하여 2026.02.15에 종료됩니다.
중간 점검은 2026-03-10입니다."
→ 세 가지 형식 혼용

✅ 교정 (한글 표기):
"프로젝트는 2026년 1월 27일에 시작하여 2026년 2월 15일에 종료됩니다.
중간 점검은 2026년 3월 10일입니다."

✅ 교정 (ISO 8601):
"프로젝트는 2026-01-27에 시작하여 2026-02-15에 종료됩니다.
중간 점검은 2026-03-10입니다."
```

### 문서 타입별 권장 형식

| 문서 타입 | 권장 형식 | 예시 | 근거 |
|----------|---------|------|------|
| 공문서 | YYYY년 MM월 DD일 | 2026년 1월 27일 | 한국 공문서 관행 |
| 비즈니스 문서 | YYYY년 MM월 DD일 | 2026년 1월 27일 | 가독성 |
| 기술 문서 | YYYY-MM-DD | 2026-01-27 | ISO 8601 |
| 학술 논문 | YYYY년 MM월 DD일 | 2026년 1월 27일 | 학술 관행 |
| 로그/데이터 | YYYY-MM-DD | 2026-01-27 | 국제 표준 |

### 교정 전략

1. **문서 타입 확인**: 공문서/비즈니스는 한글, 기술 문서는 ISO 8601
2. **다수결 원칙**: 문서에서 가장 많이 사용된 형식으로 통일
3. **국제 표준 고려**: 다국어 문서는 ISO 8601 (YYYY-MM-DD) 권장
4. **일관성**: 한 문서 내에서 하나의 형식만 사용

---

## 패턴 17: 시간 형식

**메타데이터**:
- 출처: 국제 표준(ISO 8601), 한국 일상 관행
- 권위: 🏛️ 국제 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

시간 표기 방식이 일관적이지 않으면 특히 12시간제/24시간제 혼용 시 오해의 소지가 있습니다.

### 주요 시간 형식

#### 1. 12시간제 (오전/오후)

**사용처**: 일상 대화, 일반 문서

```
✅ 올바른 예시:
오전 9시
오후 3시 30분
오전 11시 45분

변형:
오전 9:00
오후 3:30
```

**주의**:
```
❌ 혼란 가능:
AM 9시, PM 3시 (한글과 영어 혼용)

✅ 교정:
오전 9시, 오후 3시
또는 9 AM, 3 PM (영어 문서)
```

#### 2. 24시간제

**사용처**: 공식 문서, 기술 문서, 국제 표준

```
✅ 올바른 예시:
09:00
15:30
23:45

ISO 8601 형식:
15:30:00 (초 포함)
15:30:00+09:00 (시간대 포함)
```

#### 3. 한글 표기

**사용처**: 격식 있는 문서

```
✅ 올바른 예시:
오전 9시 30분
오후 3시
저녁 6시 45분
```

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"회의는 오전 9시에 시작하여 15:30에 종료됩니다.
점심은 12:00pm입니다."
→ 12시간제, 24시간제, AM/PM 혼용

✅ 교정 (12시간제):
"회의는 오전 9시에 시작하여 오후 3시 30분에 종료됩니다.
점심은 오후 12시입니다."

✅ 교정 (24시간제):
"회의는 09:00에 시작하여 15:30에 종료됩니다.
점심은 12:00입니다."
```

### 시간대 표기

**한국 표준시**:
```
✅ 올바른 예시:
2026-01-27 15:30 KST
2026-01-27T15:30:00+09:00 (ISO 8601)
```

**국제 문서**:
```
✅ 올바른 예시:
15:30 UTC
15:30 GMT
15:30 EST
```

### 문서 타입별 권장 형식

| 문서 타입 | 권장 형식 | 예시 | 근거 |
|----------|---------|------|------|
| 공문서 | 오전/오후 | 오전 9시 30분 | 한국 관행 |
| 비즈니스 일정 | 오전/오후 또는 24시간 | 오후 3시 또는 15:00 | 명확성 |
| 기술 문서/로그 | 24시간제 | 15:30:00 | ISO 8601 |
| 국제 문서 | 24시간제 + 시간대 | 15:30 KST | 국제 표준 |

### 교정 전략

1. **대상 독자**: 일반 대중은 12시간제, 기술 문서는 24시간제
2. **다수결 원칙**: 문서에서 더 많이 사용된 형식으로 통일
3. **명확성**: 오후 12시(정오)는 "12:00" 또는 "정오"로 명시
4. **국제 표준**: 다국어 문서는 24시간제 + 시간대 표기

---

## 패턴 18: 링크 및 URL 표기

**메타데이터**:
- 출처: Markdown 스타일 가이드, 웹 접근성 가이드
- 권위: 💼 실무 표준
- 버전: 1.0.0

### 설명

링크 텍스트가 일관적이지 않으면 독자 경험이 저하되고, 웹 접근성도 떨어집니다.

### 주요 링크 스타일

#### 1. 설명적 링크 텍스트 (권장)

**Markdown**: `[설명 텍스트](URL)`

```
✅ 올바른 예시:
자세한 내용은 [국립국어원 공식 사이트](https://www.korean.go.kr/)를 참조하세요.
[기술 문서 작성 가이드](https://tech.kakaoenterprise.com/105)에서 확인할 수 있습니다.
```

**장점**:
- 링크 대상이 명확
- 스크린 리더 사용자에게 도움
- SEO 최적화

#### 2. URL 직접 노출 (비권장)

```
❌ 잘못된 예시:
자세한 내용은 https://www.korean.go.kr/를 참조하세요.
```

**예외 (허용)**:
- 인쇄물이나 URL을 명시해야 하는 경우
- 짧고 의미 있는 URL (예: example.com)

#### 3. "여기", "클릭" 같은 모호한 텍스트 (비권장)

```
❌ 잘못된 예시:
자세한 내용은 [여기](https://www.korean.go.kr/)를 클릭하세요.
더 알아보려면 [이곳](https://example.com)을 참조하세요.
```

**문제점**:
- 링크 대상 불명확
- 스크린 리더 사용자에게 무의미
- 웹 접근성 저하

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"자세한 내용은 [여기](URL1)를 참조하세요.
추가 정보는 URL2에 있습니다.
[기술 문서](URL3)도 확인하세요."
→ "여기", URL 직접, 설명 텍스트 혼용

✅ 교정:
"자세한 내용은 [공식 가이드](URL1)를 참조하세요.
추가 정보는 [FAQ 페이지](URL2)에 있습니다.
[기술 문서](URL3)도 확인하세요."
```

### 교정 전략

1. **설명적 텍스트**: 링크 대상이 명확하도록 설명 포함
2. **동작 동사 피하기**: "클릭", "여기" 같은 모호한 표현 자제
3. **일관성**: 같은 종류의 링크는 같은 스타일 사용
4. **접근성**: 스크린 리더 사용자를 고려

---

## 패턴 19: 각주 및 참조 번호

**메타데이터**:
- 출처: 학술 논문 작성 지침, 인용 형식 가이드 (APA, MLA)
- 권위: 📚 학술 표준
- 버전: 1.0.0

### 설명

각주나 참조 번호 형식이 일관적이지 않으면 학술적 신뢰도가 떨어집니다.

### 주요 참조 형식

#### 1. 상첨자 번호 [¹, ², ³]

**사용처**: 학술 논문, 출판물

```
✅ 올바른 예시:
본 연구는 선행 연구¹를 기반으로 한다.
결과는 유의미했다.²

참고문헌:
1. 김철수 (2025). 연구 제목. 출판사.
2. 이영희 (2024). 논문 제목. 학술지, 10(2), 123-145.
```

#### 2. 대괄호 번호 [1], [2], [3]

**사용처**: 기술 문서, 학술 논문

```
✅ 올바른 예시:
본 연구는 선행 연구[1]를 기반으로 한다.
결과는 유의미했다[2].

참고문헌:
[1] 김철수 (2025). 연구 제목. 출판사.
[2] 이영희 (2024). 논문 제목. 학술지, 10(2), 123-145.
```

#### 3. 괄호 번호 (1), (2), (3)

**사용처**: 일반 문서, 보고서

```
✅ 올바른 예시:
본 보고서는 다음을 참고했다(1).

참고문헌:
(1) 김철수 (2025). 연구 제목. 출판사.
```

#### 4. 저자-연도 (APA 스타일)

**사용처**: 심리학, 교육학, 사회과학

```
✅ 올바른 예시:
선행 연구(김철수, 2025)에 따르면...
이영희(2024)는 다음과 같이 주장했다.

참고문헌:
김철수. (2025). 연구 제목. 출판사.
이영희. (2024). 논문 제목. 학술지, 10(2), 123-145.
```

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"선행 연구¹에 따르면 중요하다. 다른 연구[2]도 이를 뒷받침한다.
또 다른 연구(Kim, 2024)도 동의한다."
→ 상첨자, 대괄호, 저자-연도 혼용

✅ 교정 (대괄호 번호):
"선행 연구[1]에 따르면 중요하다. 다른 연구[2]도 이를 뒷받침한다.
또 다른 연구[3]도 동의한다."
```

### 문서 타입별 권장 형식

| 문서 타입 | 권장 형식 | 예시 | 근거 |
|----------|---------|------|------|
| 인문학 논문 | 상첨자 또는 각주 | ¹, ² | MLA, Chicago |
| 사회과학 논문 | 저자-연도 | (김철수, 2025) | APA |
| 자연과학 논문 | 대괄호 번호 | [1], [2] | Vancouver |
| 기술 문서 | 대괄호 번호 | [1], [2] | IEEE |

### 교정 전략

1. **학문 분야**: 분야별 표준 인용 형식 따르기
2. **일관성**: 문서 전체에서 하나의 형식만 사용
3. **순서**: 등장 순서대로 번호 매기기
4. **완전성**: 모든 참조에 대응하는 참고문헌 항목 확인

---

## 실전 적용

### 검사 순서

1. 날짜 형식 전수 조사 (YYYY년 MM월 DD일, YYYY-MM-DD 등)
2. 시간 형식 확인 (12시간제/24시간제)
3. 링크 스타일 확인 (설명 텍스트/"여기"/URL 노출)
4. 참조 번호 형식 확인 (상첨자/대괄호/저자-연도)
5. 빈도 계산 및 다수결 적용
6. 통일안 제시

### 보고 형식

```markdown
## 날짜, 시간 및 참조 불일치

**불일치 #16: 날짜 형식 혼용**
- 🔄 "YYYY년 MM월 DD일": 8회
- 🔄 "YYYY.MM.DD": 3회
- 🔄 "YYYY-MM-DD": 2회
- ✅ 제안: "YYYY년 MM월 DD일" 한글 표기로 통일
- 📚 근거: 비즈니스 문서 관행 + 다수결

**불일치 #17: 시간 형식 혼용**
- 🔄 12시간제 (오전/오후): 6회
- 🔄 24시간제: 4회
- ✅ 제안: 12시간제로 통일 (대중 독자 대상)
- 📚 근거: 가독성 + 다수결

**불일치 #18: 링크 텍스트**
- 🔄 설명적 텍스트: 5개
- 🔄 "여기"/"클릭": 3개
- ✅ 제안: 모두 설명적 텍스트로 교체
- 📚 근거: 웹 접근성 가이드
```

---

## 참고 자료

- [ISO 8601 날짜/시간 표준](https://www.iso.org/iso-8601-date-and-time-format.html)
- [APA 인용 형식](https://apastyle.apa.org/)
- [MLA 인용 형식](https://style.mla.org/)
- [웹 접근성 가이드](https://www.w3.org/WAI/)
- [Markdown 스타일 가이드](https://www.markdownguide.org/)
