# 목록 및 구조 스타일

이 문서는 한국어 문서에서 목록과 구조적 요소를 일관되게 표기하기 위한 패턴과 기준을 설명합니다.

## 패턴 10: 목록 부호 일관성

**메타데이터**:
- 출처: 대학 학위논문 작성 지침, 테크니컬 라이팅 가이드
- 권위: 📚 학술 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

목록을 나타내는 부호가 일관적이지 않으면 문서의 구조가 명확하지 않아 보입니다.

### 주요 목록 부호

#### 1. 순서 있는 목록

**아라비아 숫자 + 마침표**:
```
✅ 올바른 예시:
1. 첫 번째 항목
2. 두 번째 항목
3. 세 번째 항목
```

**아라비아 숫자 + 닫는 괄호**:
```
✅ 올바른 예시:
1) 첫 번째 항목
2) 두 번째 항목
3) 세 번째 항목
```

**한글 숫자 (드물게 사용)**:
```
✅ 올바른 예시:
가. 첫 번째 항목
나. 두 번째 항목
다. 세 번째 항목
```

#### 2. 순서 없는 목록

**하이픈 (-)**:
```
✅ 올바른 예시:
- 첫 번째 항목
- 두 번째 항목
- 세 번째 항목
```

**불릿 (•)**:
```
✅ 올바른 예시:
• 첫 번째 항목
• 두 번째 항목
• 세 번째 항목
```

**별표 (*)**:
```
✅ 올바른 예시:
* 첫 번째 항목
* 두 번째 항목
* 세 번째 항목
```

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"다음 단계를 따르세요:
1. 로그인합니다
- 설정을 확인합니다
3) 변경 사항을 저장합니다"
→ "1.", "-", "3)" 혼용

✅ 교정:
"다음 단계를 따르세요:
1. 로그인합니다
2. 설정을 확인합니다
3. 변경 사항을 저장합니다"
```

**계층 구조 (혼용 허용)**:
```
✅ 허용되는 예시:
1. 첫 번째 대분류
   - 세부 항목 1
   - 세부 항목 2
2. 두 번째 대분류
   - 세부 항목 1
   - 세부 항목 2
```

### 문서 타입별 권장 부호

| 문서 타입 | 순서 있음 | 순서 없음 | 근거 |
|----------|---------|---------|------|
| 학술 논문 | 1., 2., 3. | - | 대학 작성 지침 |
| 공문서 | 가., 나., 다. 또는 1., 2., 3. | - | 행정 관행 |
| 기술 문서 | 1., 2., 3. | - 또는 • | Markdown 관행 |
| 마케팅/프레젠테이션 | 1, 2, 3 또는 • | • | 시각적 효과 |

### 교정 전략

1. **다수결 원칙**: 문서에서 가장 많이 사용된 부호로 통일
2. **일관성 최우선**: 같은 수준의 목록은 같은 부호 사용
3. **계층 구분**: 상위/하위 수준은 다른 부호 사용 가능
4. **단순함**: 복잡한 계층보다 단순한 구조 선호

---

## 패턴 11: 목록 항목 종결어미

**메타데이터**:
- 출처: 테크니컬 라이팅 가이드, 대학 작성 지침
- 권위: 📚 학술 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

목록 항목의 문장 종결 방식이 일관적이지 않으면 독자가 혼란을 느낍니다.

### 주요 종결 패턴

#### 1. 완전한 문장 (종결어미 포함)

**"-습니다/-ㅂ니다" 체**:
```
✅ 올바른 예시:
1. 시스템에 로그인합니다.
2. 설정 메뉴를 엽니다.
3. 변경 사항을 저장합니다.
```

**"-한다" 체**:
```
✅ 올바른 예시:
1. 시스템에 로그인한다.
2. 설정 메뉴를 연다.
3. 변경 사항을 저장한다.
```

**"-해요" 체**:
```
✅ 올바른 예시:
1. 시스템에 로그인해요.
2. 설정 메뉴를 열어요.
3. 변경 사항을 저장해요.
```

#### 2. 명사형 종결 (어미 생략)

**명사로 끝나기**:
```
✅ 올바른 예시:
1. 시스템 로그인
2. 설정 메뉴 열기
3. 변경 사항 저장
```

**"-하기/-되기" 형태**:
```
✅ 올바른 예시:
1. 로그인하기
2. 설정 메뉴 열기
3. 변경 사항 저장하기
```

#### 3. 명령형

**"-세요" 형태**:
```
✅ 올바른 예시:
1. 시스템에 로그인하세요.
2. 설정 메뉴를 여세요.
3. 변경 사항을 저장하세요.
```

**"-하라/-하시오" 형태 (공문서)**:
```
✅ 올바른 예시:
1. 시스템에 로그인하라.
2. 설정 메뉴를 열어라.
3. 변경 사항을 저장하라.
```

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"다음 단계를 따르세요:
1. 로그인합니다
2. 설정 메뉴 열기
3. 변경 사항을 저장하세요"
→ "~합니다", "명사형", "~하세요" 혼용

✅ 교정 (완전 문장):
"다음 단계를 따르세요:
1. 로그인합니다.
2. 설정 메뉴를 엽니다.
3. 변경 사항을 저장합니다."

✅ 교정 (명사형):
"다음 단계를 따르세요:
1. 로그인
2. 설정 메뉴 열기
3. 변경 사항 저장"

✅ 교정 (명령형):
"다음 단계를 따르세요:
1. 로그인하세요.
2. 설정 메뉴를 여세요.
3. 변경 사항을 저장하세요."
```

### 문서 타입별 권장 종결

| 문서 타입 | 권장 종결 | 예시 | 근거 |
|----------|---------|------|------|
| 공문서 | -한다/-하라 | "제출한다", "확인하라" | 공식 문서 관행 |
| 학술 논문 | -한다/-이다 | "분석한다", "결과이다" | 학술 작성 지침 |
| 사용자 매뉴얼 | -세요/-하기 | "클릭하세요", "저장하기" | 사용자 친화성 |
| 기술 문서 | 명사형 또는 -한다 | "실행", "설정한다" | 간결성 |
| 프레젠테이션 | 명사형 | "매출 증가", "비용 절감" | 시각적 효과 |

### 교정 전략

1. **도입문 확인**: "다음을 수행하세요" → 명령형 목록 예상
2. **다수결 원칙**: 문서에서 가장 많이 사용된 종결 방식으로 통일
3. **문서 타입**: 위 표를 참조하여 적절한 종결 선택
4. **일관성**: 모든 목록 항목을 동일한 방식으로 종결

---

## 패턴 12: 단락 제목 스타일

**메타데이터**:
- 출처: Markdown 스타일 가이드, 테크니컬 라이팅 가이드
- 권위: 💼 실무 표준
- 버전: 1.0.0

### 설명

제목의 계층 구조와 표기 방식이 일관적이지 않으면 문서의 구조를 파악하기 어렵습니다.

### 제목 계층

**Markdown 스타일**:
```
✅ 올바른 예시:
# 1단계 제목 (가장 큰 제목)
## 2단계 제목
### 3단계 제목
#### 4단계 제목
```

**숫자 계층**:
```
✅ 올바른 예시:
1. 대제목
  1.1. 중제목
    1.1.1. 소제목
```

### 제목 종결어미

**명사형 (권장)**:
```
✅ 올바른 예시:
## 시스템 개요
## 설치 방법
## 사용 가이드
```

**완전 문장 (비권장)**:
```
❌ 잘못된 예시:
## 시스템 개요를 소개합니다
## 설치 방법을 설명합니다
→ 제목은 간결하게 명사형으로
```

### 혼용 사례

```
❌ 잘못된 예시:
"# 시스템 개요
## 설치 방법을 설명합니다
### 설정
## 사용"
→ 종결 방식 혼용, 계층 순서 문제

✅ 교정:
"# 시스템 개요
## 설치 방법
### 기본 설정
## 사용 가이드"
```

### 교정 전략

1. **명사형 우선**: 제목은 간결하게 명사형으로
2. **계층 준수**: 1단계 → 2단계 → 3단계 순서 유지
3. **일관성**: 같은 수준의 제목은 같은 스타일 사용

---

## 실전 적용

### 검사 순서

1. 목록 부호 전수 조사 (1., -, •, * 등)
2. 목록 항목 종결어미 확인 (~합니다, 명사형, ~하세요)
3. 제목 계층 및 스타일 확인
4. 빈도 계산 및 다수결 적용
5. 통일안 제시

### 보고 형식

```markdown
## 목록 및 구조 불일치

**불일치 #10: 목록 부호 혼용**
- 🔄 "1., 2., 3.": 5개 목록
- 🔄 "-, -, -": 3개 목록
- ✅ 제안: "1., 2., 3." 스타일로 통일 (다수결)
- 📚 근거: 기술 문서 관행

**불일치 #11: 목록 종결어미 혼용**
- 🔄 "~합니다": 10개 항목
- 🔄 명사형: 5개 항목
- 🔄 "~하세요": 2개 항목
- ✅ 제안: "~합니다" 완전 문장으로 통일
- 📚 근거: 다수결 + 문서의 격식적 톤
```

---

## 참고 자료

- [세종대학교 학위논문 작성 형식](https://sejong-kr.libguides.com/c.php?g=930661&p=6770589)
- [Kakao Enterprise 기술문서 작성 가이드](https://tech.kakaoenterprise.com/65)
- [테크니컬 라이팅 문서 작성 가이드](https://velog.io/@ailab/%ED%85%8C%ED%81%AC%EB%8B%88%EC%BB%AC-%EB%9D%BC%EC%9D%B4%ED%8C%85-%EB%AC%B8%EC%84%9C-%EC%9E%91%EC%84%B1-%EA%B0%80%EC%9D%B4%EB%93%9C)
