# 숫자 및 단위 표기

이 문서는 한국어 문서에서 숫자와 단위를 일관되게 표기하기 위한 패턴과 기준을 설명합니다.

## 패턴 7: 아라비아 숫자 vs 한글 숫자

**메타데이터**:
- 출처: 국립국어원 표기 지침, 대학 학위논문 작성 지침
- 권위: 🏛️ 정부 표준 + 📚 학술 표준
- 버전: 1.0.0

### 설명

한국어에서 숫자는 아라비아 숫자(1, 2, 3)와 한글 숫자(하나, 둘, 셋 또는 일, 이, 삼)로 표기할 수 있습니다. 동일 문서 내에서 혼용하면 일관성이 떨어집니다.

### 숫자 표기 원칙

#### 1. 아라비아 숫자를 쓰는 경우

**통계, 수치 데이터**:
```
✅ 올바른 예시:
"실험 결과 3명의 참가자가 5개 항목에서 평균 4.2점을 받았습니다."
```

**날짜, 시간**:
```
✅ 올바른 예시:
"2026년 1월 27일 오후 3시 30분"
```

**측정값, 단위**:
```
✅ 올바른 예시:
"길이는 15cm, 무게는 2.5kg입니다."
```

**금액**:
```
✅ 올바른 예시:
"가격은 10,000원입니다."
```

**순서가 있는 목록**:
```
✅ 올바른 예시:
"1. 첫 번째 단계"
"2. 두 번째 단계"
```

#### 2. 한글 숫자를 쓰는 경우

**관용적 표현**:
```
✅ 올바른 예시:
"한두 번", "두세 개", "서너 명"
(×: "1~2번", "2~3개", "3~4명")
```

**강조나 문학적 표현**:
```
✅ 올바른 예시:
"하나밖에 없는 기회"
"첫 번째이자 마지막 기회"
```

**추상적 개념**:
```
✅ 올바른 예시:
"하나의 목표", "두 가지 선택"
```

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"참가자는 3명이었고, 각자 두 개의 과제를 완료했습니다.
총 6개 과제 중 다섯 개가 성공했습니다."
→ "3명/두 개/6개/다섯 개" 혼용

✅ 교정 (아라비아 숫자):
"참가자는 3명이었고, 각자 2개의 과제를 완료했습니다.
총 6개 과제 중 5개가 성공했습니다."

✅ 교정 (한글 숫자, 덜 일반적):
"참가자는 세 명이었고, 각자 두 개의 과제를 완료했습니다.
총 여섯 개 과제 중 다섯 개가 성공했습니다."
```

**관용 표현은 예외 (혼용 허용)**:
```
✅ 허용되는 예시:
"5명의 참가자 중 한두 명이 실패했습니다."
→ "5명"(구체적 수치)과 "한두 명"(관용 표현)은 구분
```

### 문서 타입별 권장 표기

| 문서 타입 | 권장 표기 | 근거 |
|----------|---------|------|
| 기술 문서, 보고서 | 아라비아 숫자 | 정확성, 가독성 |
| 공문서 | 아라비아 숫자 (중요 금액은 한글 병기) | 행정업무 운영 규정 |
| 학술 논문 | 아라비아 숫자 | 학위논문 작성 지침 |
| 마케팅, 문학 | 문맥에 따라 혼용 가능 | 표현의 자유 |

### 교정 전략

1. **문서 타입 확인**: 기술/학술 문서는 아라비아 숫자 우선
2. **다수결 원칙**: 문서에서 더 많이 사용된 방식으로 통일
3. **관용 표현 보존**: "한두 번", "두세 개" 같은 관용구는 그대로 유지
4. **일관성**: 같은 종류의 수치는 같은 방식으로 표기

---

## 패턴 8: 단위 띄어쓰기

**메타데이터**:
- 출처: 국립국어원 띄어쓰기 규정, 국제단위계(SI) 표기법
- 권위: 🏛️ 정부 표준 + 📚 국제 표준
- 버전: 1.0.0

### 설명

숫자와 단위 사이의 띄어쓰기가 일관적이지 않으면 전문성이 떨어집니다.

### 단위 띄어쓰기 원칙

#### 1. 띄어쓰는 단위

**물리량 단위 (SI 단위계)**:
```
✅ 올바른 예시:
"10 km", "5 kg", "3 L", "20 °C", "100 W"

❌ 잘못된 예시:
"10km", "5kg", "3L"
```

**화폐 단위**:
```
✅ 올바른 예시:
"10,000 원", "100 달러"

❌ 잘못된 예시:
"10,000원", "100달러"
```

**시간 단위 (시, 분, 초)**:
```
✅ 올바른 예시:
"3 시간", "30 분", "45 초"

❌ 잘못된 예시:
"3시간", "30분", "45초"
```

#### 2. 붙여쓰는 단위

**의존명사 단위**:
```
✅ 올바른 예시:
"3개", "5명", "10권", "2번"

❌ 잘못된 예시:
"3 개", "5 명", "10 권", "2 번"
```

**퍼센트 (%)**:
```
✅ 올바른 예시:
"50%", "3.5%"

❌ 잘못된 예시:
"50 %", "3.5 %"
```

**도 (각도, 온도의 ℃)**:
```
✅ 올바른 예시:
"90°", "25℃"

참고: SI 표기법은 "25 °C" (띄어쓰기)를 권장하지만,
한국에서는 "25℃" (붙여쓰기)도 널리 통용됨
```

### 혼용 사례

**명백한 불일치**:
```
❌ 잘못된 예시:
"무게는 5 kg이고, 길이는 3m입니다."
→ "5 kg"(띄어쓰기)과 "3m"(붙여쓰기) 혼용

✅ 교정:
"무게는 5 kg이고, 길이는 3 m입니다."
```

**의존명사 혼용**:
```
❌ 잘못된 예시:
"참가자는 3명이고, 과제는 5 개입니다."
→ "3명"(붙여쓰기)과 "5 개"(띄어쓰기) 혼용

✅ 교정:
"참가자는 3명이고, 과제는 5개입니다."
```

### 특수 사례

#### 복합 단위

**곱셈 단위**:
```
✅ 올바른 예시:
"면적은 10 m²입니다."
"속도는 60 km/h입니다."
```

**범위 표현**:
```
✅ 올바른 예시:
"온도는 20~25 °C입니다."
"3~5개월"
```

#### 한글 단위

**한글로 쓴 단위는 띄어쓰기**:
```
✅ 올바른 예시:
"3 시간", "5 미터", "10 킬로그램"

❌ 잘못된 예시:
"3시간", "5미터", "10킬로그램"
```

### 문서 타입별 권장 표기

| 문서 타입 | 권장 표기 | 근거 |
|----------|---------|------|
| 과학/기술 논문 | SI 표기법 (띄어쓰기) | 국제 표준 |
| 일반 문서 | 한국 관행 (℃ 붙여쓰기 등 허용) | 실무 통용 |
| 공문서 | 국립국어원 띄어쓰기 규정 | 정부 표준 |

### 교정 전략

1. **SI 단위**: 원칙적으로 띄어쓰기 ("5 kg", "20 °C")
2. **의존명사**: 붙여쓰기 ("3개", "5명")
3. **일관성**: 문서 내에서 같은 방식 유지
4. **실용성**: 지나치게 엄격한 적용보다 통용되는 방식 인정

---

## 패턴 9: 숫자 표기 형식

**메타데이터**:
- 출처: 실무 관행, 국제 표준
- 권위: 💼 실무 표준
- 버전: 1.0.0

### 설명

큰 숫자의 자릿수 표기, 소수점 표기 등이 일관적이지 않으면 가독성이 떨어집니다.

### 천 단위 구분

**쉼표 사용**:
```
✅ 올바른 예시:
"1,000", "10,000", "1,000,000"

❌ 잘못된 예시:
"1000", "10000", "1000000"
```

**한글 단위 (선택적)**:
```
✅ 올바른 예시:
"1만", "10만", "100만"

혼용 피하기:
❌ "가격은 10,000원에서 5만 원 사이입니다."
✅ "가격은 1만 원에서 5만 원 사이입니다."
또는 "가격은 10,000원에서 50,000원 사이입니다."
```

### 소수점 표기

**점(.) 사용**:
```
✅ 올바른 예시:
"3.14", "2.5 kg", "0.5%"

❌ 잘못된 예시:
"3,14" (유럽 스타일, 한국에서는 비표준)
```

---

## 실전 적용

### 검사 순서

1. 숫자 표기 방식 전수 조사 (아라비아/한글)
2. 단위 띄어쓰기 확인 (SI 단위/의존명사)
3. 빈도 계산 및 다수결 적용
4. 문서 타입에 맞는 표준 확인
5. 통일안 제시

### 보고 형식

```markdown
## 숫자 및 단위 표기 불일치

**불일치 #7: 숫자 표기 혼용**
- 🔄 아라비아 숫자: 15회
- 🔄 한글 숫자: 3회
- ✅ 제안: 기술 문서이므로 아라비아 숫자로 통일
- 📚 근거: 학술/기술 문서 작성 지침

**불일치 #8: 단위 띄어쓰기**
- 🔄 "5 kg"(띄어쓰기): 8회
- 🔄 "3kg"(붙여쓰기): 2회
- ✅ 제안: SI 표기법에 따라 띄어쓰기로 통일
- 📚 근거: 국제단위계(SI) 표기법
```

---

## 참고 자료

- [국립국어원 띄어쓰기 규정](https://www.korean.go.kr/)
- [국제단위계(SI) 표기법](https://www.bipm.org/en/measurement-units/)
- [세종대학교 학위논문 작성 형식](https://sejong-kr.libguides.com/c.php?g=930661&p=6770589)
