# 인용 및 강조 표기

이 문서는 한국어 문서에서 인용 부호와 강조 표기를 일관되게 사용하기 위한 패턴과 기준을 설명합니다.

## 패턴 13: 따옴표 스타일

**메타데이터**:
- 출처: 국립국어원 문장부호 규정, 출판 실무 관행
- 권위: 🏛️ 정부 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

한국어는 다양한 따옴표 스타일을 사용할 수 있습니다. 동일 문서 내에서 여러 스타일을 혼용하면 일관성이 떨어집니다.

### 주요 따옴표 종류

#### 1. 큰따옴표 (" ")

**사용처**:
- 직접 인용
- 말이나 생각
- 강조

```
✅ 올바른 예시:
그는 "괜찮아요"라고 말했다.
"혁신"이라는 단어가 자주 등장한다.
```

#### 2. 작은따옴표 (' ')

**사용처**:
- 따옴표 안의 따옴표 (이중 인용)
- 특정 용어 강조 (대안)

```
✅ 올바른 예시:
그는 "선생님이 '공부하라'고 하셨어요"라고 전했다.
'혁신'이라는 개념은 중요하다.
```

#### 3. 겹낫표 (『 』)와 홑낫표 (「 」)

**사용처**:
- 책 제목, 신문 이름, 작품명
- 출판물에서 전통적으로 사용

```
✅ 올바른 예시:
『해리 포터』를 읽었다.
「조선일보」 기사에 따르면...
```

#### 4. 백틱 (` `)

**사용처**:
- 코드나 명령어 (기술 문서)
- Markdown 문서

```
✅ 올바른 예시:
`git commit` 명령어를 실행하세요.
변수 `userName`을 선언합니다.
```

### 국립국어원 문장부호 규정

**큰따옴표 우선 원칙**:
- 직접 인용이나 강조는 큰따옴표(" ")를 기본으로 사용
- 따옴표 안에 또 다른 인용이 있을 때는 작은따옴표(' ') 사용

```
✅ 규정에 따른 예시:
"선생님이 '열심히 하라'고 하셨어요."
```

**겹낫표/홑낫표**:
- 책 제목, 신문 이름, 예술 작품 등에는 겹낫표(『 』)
- 소제목, 편명, 그림이나 노래 제목 등에는 홑낫표(「 」)

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"혁신"이라는 단어는 중요하다. 또한 '창의성'도 필수적이다.
제품명은 `SuperApp`이고, 기능은 "빠른 검색"이다.
→ " ", ' ', ` ` 혼용

✅ 교정 (큰따옴표 통일):
"혁신"이라는 단어는 중요하다. 또한 "창의성"도 필수적이다.
제품명은 "SuperApp"이고, 기능은 "빠른 검색"이다.

✅ 교정 (기술 문서, 코드는 백틱):
"혁신"이라는 단어는 중요하다. 또한 "창의성"도 필수적이다.
제품명은 `SuperApp`이고, 기능은 "빠른 검색"이다.
```

**이중 인용 (혼용 허용)**:
```
✅ 허용되는 예시:
"선생님이 '공부하라'고 하셨어요."
→ 큰따옴표 안에 작은따옴표는 규정에 맞음
```

### 문서 타입별 권장 따옴표

| 문서 타입 | 일반 인용/강조 | 코드/명령어 | 책/작품명 | 근거 |
|----------|-------------|----------|---------|------|
| 공문서 | " " | (없음) | 『 』, 「 」 | 국립국어원 규정 |
| 학술 논문 | " " | " " 또는 *기울임* | 『 』, 「 」 | 학술 관행 |
| 기술 문서 | " " | ` ` | " " | Markdown 관행 |
| 마케팅 | " " 또는 **굵게** | (없음) | " " | 시각적 효과 |
| 출판물 | " " | - | 『 』, 「 」 | 출판 전통 |

### 교정 전략

1. **문서 타입 확인**: 공문서/출판물은 겹낫표, 기술 문서는 백틱 허용
2. **다수결 원칙**: 같은 용도(인용/강조)에는 가장 많이 사용된 따옴표로 통일
3. **코드 구분**: 기술 문서에서 코드는 백틱(` `), 일반 텍스트는 큰따옴표(" ")
4. **이중 인용**: 큰따옴표 안에 작은따옴표는 허용

---

## 패턴 14: 강조 표기

**메타데이터**:
- 출처: Markdown 스타일 가이드, 테크니컬 라이팅 가이드
- 권위: 💼 실무 표준
- 버전: 1.0.0

### 설명

텍스트를 강조하는 방법이 일관적이지 않으면 독자가 중요한 내용을 파악하기 어렵습니다.

### 주요 강조 방법

#### 1. 굵게 (Bold)

**Markdown**: `**텍스트**` 또는 `__텍스트__`
**용도**: 강한 강조, 키워드

```
✅ 올바른 예시:
이 기능은 **매우 중요합니다**.
**주의**: 다음 사항을 확인하세요.
```

#### 2. 기울임 (Italic)

**Markdown**: `*텍스트*` 또는 `_텍스트_`
**용도**: 약한 강조, 외국어, 책 제목 (학술 문서)

```
✅ 올바른 예시:
이 부분은 *주목할 필요가* 있습니다.
*de facto* 표준으로 자리잡았다.
```

#### 3. 밑줄

**HTML**: `<u>텍스트</u>`
**용도**: 하이퍼링크 이외에는 사용 자제 (혼란 방지)

```
⚠️ 주의:
웹 문서에서 <u>밑줄</u>은 링크로 오해받을 수 있음
```

#### 4. 하이라이트/배경색

**Markdown 확장**: `==텍스트==` (일부 편집기)
**HTML**: `<mark>텍스트</mark>`
**용도**: 매우 강한 강조, 주의 사항

```
✅ 올바른 예시:
==경고==: 이 작업은 되돌릴 수 없습니다.
```

#### 5. 따옴표

**용도**: 특정 용어나 개념 강조 (위 패턴 9 참조)

```
✅ 올바른 예시:
"혁신"이라는 단어의 의미는...
```

### 혼용 사례

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
이것은 **중요한** 내용입니다. 또한 _필수적인_ 요소이기도 합니다.
"핵심" 개념을 이해해야 합니다.
→ **, _, " " 모두 같은 용도(강조)로 사용

✅ 교정 (굵게 통일):
이것은 **중요한** 내용입니다. 또한 **필수적인** 요소이기도 합니다.
**핵심** 개념을 이해해야 합니다.
```

**의미 구분 (혼용 허용)**:
```
✅ 허용되는 예시:
이것은 **매우 중요한** 내용이며, *주의 깊게* 읽어야 합니다.
→ **굵게**(강한 강조)와 *기울임*(약한 강조)을 의도적으로 구분
```

### 강조 수준별 권장 방법

| 강조 수준 | 권장 방법 | 용도 | 예시 |
|---------|---------|------|------|
| 매우 강함 | ==하이라이트== 또는 ⚠️/🔴 | 경고, 위험 | ==주의== 또는 ⚠️ 주의 |
| 강함 | **굵게** | 키워드, 중요 개념 | **핵심** |
| 중간 | "따옴표" | 특정 용어 | "혁신" |
| 약함 | *기울임* | 부수적 강조 | *참고* |

### 문서 타입별 권장 강조

| 문서 타입 | 권장 방법 | 근거 |
|----------|---------|------|
| 공문서 | 밑줄, 굵게 | 전통적 공문서 스타일 |
| 학술 논문 | *기울임* (외국어), **굵게** (키워드) | 학술 관행 |
| 기술 문서 | **굵게**, ` ` (코드) | Markdown 관행 |
| 마케팅 | **굵게**, ==하이라이트==, 색상 | 시각적 효과 |

### 과도한 강조 피하기

```
❌ 잘못된 예시:
**이 제품은** **매우** **중요한** **기능을** **제공합니다**.
→ 모든 단어가 굵게 = 강조 효과 없음

✅ 교정:
이 제품은 **중요한 기능**을 제공합니다.
→ 진짜 중요한 부분만 강조
```

### 교정 전략

1. **용도 구분**: 강한 강조(굵게), 약한 강조(기울임), 용어(따옴표)를 구분
2. **일관성**: 같은 용도에는 같은 방법 사용
3. **절제**: 강조는 정말 중요한 부분만
4. **가독성**: 지나친 강조는 오히려 가독성 저해

---

## 패턴 15: 특수 문자 및 이모지

**메타데이터**:
- 출처: 실무 관행
- 권위: 💼 실무 표준
- 버전: 1.0.0

### 설명

이모지나 특수 문자 사용이 일관적이지 않으면 문서의 전문성이 떨어질 수 있습니다.

### 이모지 사용

**적절한 사용 (Markdown/캐주얼 문서)**:
```
✅ 올바른 예시:
✅ 완료
❌ 오류
⚠️ 주의
📝 참고
```

**부적절한 사용 (공식 문서)**:
```
❌ 잘못된 예시:
본 보고서는 매우 중요합니다. 😊
→ 공식 문서에 이모지 부적절
```

### 특수 기호

**화살표**:
```
혼용 피하기:
❌ "A → B, C => D, E ➡️ F"
✅ "A → B, C → D, E → F"
```

**체크 마크**:
```
일관성 유지:
✅ "✓ 완료, ✓ 확인"
또는 "✅ 완료, ✅ 확인"
```

### 교정 전략

1. **문서 타입**: 공식 문서는 이모지 자제, 기술/마케팅 문서는 허용
2. **일관성**: 같은 의미는 같은 기호/이모지 사용
3. **절제**: 과도한 이모지는 가독성 저해

---

## 실전 적용

### 검사 순서

1. 따옴표 종류 전수 조사 (" ", ' ', 『 』, ` ` 등)
2. 강조 방법 확인 (**, *, __, _, 따옴표)
3. 이모지 및 특수 문자 확인
4. 용도별 빈도 계산
5. 통일안 제시

### 보고 형식

```markdown
## 인용 및 강조 불일치

**불일치 #13: 따옴표 스타일 혼용**
- 🔄 큰따옴표 (" "): 15회
- 🔄 작은따옴표 (' '): 5회
- 🔄 백틱 (` `): 3회 (코드 용도)
- ✅ 제안: 일반 텍스트는 큰따옴표(" "), 코드는 백틱(` `)으로 구분
- 📚 근거: 국립국어원 문장부호 규정 + Markdown 관행

**불일치 #14: 강조 표기 혼용**
- 🔄 **굵게**: 12회
- 🔄 *기울임*: 3회
- 🔄 "따옴표": 8회
- ✅ 제안: 강한 강조는 **굵게**, 특정 용어는 "따옴표"로 구분
- 📚 근거: 테크니컬 라이팅 가이드
```

---

## 참고 자료

- [국립국어원 문장부호 규정](https://www.korean.go.kr/)
- [Markdown 가이드](https://www.markdownguide.org/)
- [테크니컬 라이팅 문서 작성 가이드](https://velog.io/@ailab/%ED%85%8C%ED%81%AC%EB%8B%88%EC%BB%AC-%EB%9D%BC%EC%9D%B4%ED%8C%85-%EB%AC%B8%EC%84%9C-%EC%9E%91%EC%84%B1-%EA%B0%80%EC%9D%B4%EB%93%9C)
