# 용어 통일

이 문서는 한국어 문서에서 동일한 개념을 나타내는 용어를 일관되게 사용하기 위한 패턴과 기준을 설명합니다.

## 패턴 4: 동일 개념의 다른 표현

**메타데이터**:
- 출처: 한국공공언어진흥원 전문용어 표준화 프로세스, 정보통신기술용어해설
- 권위: 🏛️ 정부 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

한국어는 같은 개념을 표현하는 여러 단어가 존재합니다 (순우리말, 한자어, 외래어 혼재). 동일 문서 내에서 이들을 혼용하면 독자가 혼란을 느낄 수 있습니다.

### 흔한 혼용 사례

#### IT/기술 분야

| 개념 | 표현 A | 표현 B | 표현 C | 권장 |
|------|-------|-------|-------|------|
| 사용자 | 사용자 | 유저 | 이용자 | 문서 타입에 따라 선택 |
| 화면 | 화면 | 페이지 | UI | 문맥에 따라 구분 |
| 저장 | 저장 | 세이브 | 보관 | 저장 (기술문서 표준) |
| 설정 | 설정 | 세팅 | 구성 | 설정 (국립국어원 표준) |
| 업데이트 | 업데이트 | 갱신 | 최신화 | 업데이트 (통용) |
| 다운로드 | 다운로드 | 내려받기 | 받기 | 문서 타입에 따라 |

#### 비즈니스 분야

| 개념 | 표현 A | 표현 B | 표현 C | 권장 |
|------|-------|-------|-------|------|
| 회사 | 회사 | 기업 | 업체 | 문맥에 따라 구분 |
| 고객 | 고객 | 손님 | 클라이언트 | 고객 (공식 문서) |
| 직원 | 직원 | 임직원 | 구성원 | 문서 정책에 따라 |
| 계약 | 계약 | 약정 | 컨트랙트 | 계약 (법률 표준) |

#### 교육/학술 분야

| 개념 | 표현 A | 표현 B | 표현 C | 권장 |
|------|-------|-------|-------|------|
| 학생 | 학생 | 수강생 | 학습자 | 문맥에 따라 |
| 교사 | 교사 | 선생님 | 강사 | 공식성에 따라 |
| 과제 | 과제 | 숙제 | 과업 | 과제 (학술 표준) |

### 검출 기준

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"사용자는 로그인 후 페이지를 확인할 수 있습니다.
유저가 설정을 변경하려면 화면 오른쪽 버튼을 클릭하세요."
→ "사용자/유저" 혼용, "페이지/화면" 혼용

✅ 교정:
"사용자는 로그인 후 페이지를 확인할 수 있습니다.
사용자가 설정을 변경하려면 페이지 오른쪽 버튼을 클릭하세요."
```

**의미 구분이 있는 경우 (혼용 허용)**:
```
✅ 허용되는 예시:
"사용자는 웹 페이지에서 UI 요소를 클릭합니다."
→ "페이지"(전체 화면)와 "UI"(인터페이스 요소)는 다른 개념
```

### 문서 타입별 권장 용어

#### 공문서/공식 비즈니스
- **권장**: 순우리말 > 한자어 > 외래어
- **근거**: 국어기본법 제14조 "일반 국민이 이해하기 쉬운 용어"
- **예시**: "사용자", "화면", "설정", "저장"

#### 기술 문서
- **권장**: 업계 표준 용어 우선
- **근거**: Kakao Enterprise 기술문서 가이드, 정보통신기술용어해설
- **예시**: "API", "SDK", "라이브러리" (외래어도 허용)

#### 마케팅/소비자 대상
- **권장**: 친숙한 표현 우선
- **근거**: 독자 친화성
- **예시**: "유저", "클릭", "다운로드"

### 교정 전략

1. **다수결 원칙**: 문서에서 가장 많이 사용된 용어를 기준으로 통일
2. **표준 우선**: 정부/학술/업계 표준이 있으면 그것을 따름
3. **의미 구분**: 진짜로 다른 의미라면 혼용 허용
4. **일관성**: 한 번 선택하면 문서 끝까지 유지

---

## 패턴 5: 외래어 표기 일관성

**메타데이터**:
- 출처: 국립국어원 외래어 표기법, Kakao Enterprise 기술문서 가이드
- 권위: 🏛️ 정부 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

외래어를 한글로 표기할 때, 띄어쓰기나 표기 방법이 일관적이지 않으면 전문성이 떨어집니다.

### 흔한 외래어 표기 불일치

#### 띄어쓰기 혼용

| 외래어 | 표기 A | 표기 B | 국립국어원 표준 | 실무 통용 |
|--------|-------|-------|----------------|----------|
| 웹사이트 | 웹사이트 | 웹 사이트 | 웹사이트 (붙여쓰기) | 웹사이트 |
| 데이터베이스 | 데이터베이스 | 데이터 베이스 | 데이터베이스 | 데이터베이스 또는 DB |
| 프로그래밍 | 프로그래밍 | 프로그램밍 | 프로그래밍 | 프로그래밍 |
| 서비스 | 서비스 | 서비스 | 서비스 | 서비스 |

#### 약어 혼용

| 개념 | 풀어쓰기 | 약어 | 권장 |
|------|---------|------|------|
| 운영체제 | Android OS | AOS | Android (또는 Android OS) |
| 데이터베이스 | 데이터베이스 | DB | 문서 타입에 따라 |
| 응용 프로그램 인터페이스 | Application Programming Interface | API | API (업계 표준) |
| 소프트웨어 개발 키트 | Software Development Kit | SDK | SDK (업계 표준) |

**중요 원칙**:
- **공식 표기 우선**: "Android OS"는 공식 표기, "AOS"는 비공식
- **업계 표준**: API, SDK 같은 약어는 풀어쓰기보다 약어가 더 통용됨
- **일관성**: 한 문서 내에서 풀어쓰기와 약어를 혼용하지 않음

### 검출 기준

**명백한 불일치**:
```
❌ 잘못된 예시:
"이 웹사이트는 데이터 베이스를 사용합니다.
웹 사이트 관리자는 DB를 정기적으로 백업합니다."
→ "웹사이트/웹 사이트" 혼용, "데이터 베이스/DB" 혼용

✅ 교정:
"이 웹사이트는 데이터베이스를 사용합니다.
웹사이트 관리자는 데이터베이스를 정기적으로 백업합니다."
```

**약어 사용 (문서 타입에 따라)**:
```
✅ 기술 문서:
"API를 통해 DB에 접근합니다."

✅ 일반 문서:
"프로그래밍 인터페이스를 통해 데이터베이스에 접근합니다."
```

### 문서 타입별 권장 표기

#### 공문서/일반 대중
- **권장**: 풀어쓰기, 순화된 표현
- **근거**: 국립국어원 공공언어 개선 가이드
- **예시**: "응용 프로그램" (not "앱"), "누리집" (not "웹사이트")

#### 기술 문서
- **권장**: 업계 표준 약어
- **근거**: Kakao Enterprise 가이드 "공식 표기법이 아닌 약어는 피함"
- **예시**: "API", "SDK" (OK), "AOS" (NG, "Android" 사용)

#### 비즈니스 문서
- **권장**: 독자의 이해도에 맞춤
- **예시**: IT 업계 문서는 약어 허용, 일반 고객 대상은 풀어쓰기

### 교정 전략

1. **국립국어원 표준 확인**: [외래어 표기법](https://www.korean.go.kr/) 참조
2. **업계 관행 고려**: 기술 문서는 통용되는 약어 허용
3. **일관성 최우선**: 문서 내에서 한 가지 표기만 사용
4. **첫 등장 시 설명**: "API(Application Programming Interface)"처럼 첫 등장 시 풀어쓰기 제공 (선택)

---

## 패턴 6: 한자어 vs 순우리말

**메타데이터**:
- 출처: 국립국어원 쉬운 공공언어 쓰기 지침
- 권위: 🏛️ 정부 표준
- 버전: 1.0.0

### 설명

같은 의미를 한자어와 순우리말로 모두 표현할 수 있을 때, 둘을 혼용하면 일관성이 떨어집니다.

### 흔한 혼용 사례

| 한자어 | 순우리말 | 권장 (공문서) | 권장 (일반) |
|--------|---------|-------------|----------|
| 사용 | 쓰임, 씀 | 사용 | 사용 |
| 변경 | 바꿈 | 변경 또는 바꿈 | 바꿈 |
| 확인 | 살펴봄 | 확인 | 확인 |
| 추가 | 더함 | 추가 | 추가 |
| 제거 | 없앰 | 제거 또는 삭제 | 없앰 |
| 종료 | 끝냄 | 종료 | 끝 |

**원칙**:
- 공문서는 일반 국민이 이해하기 쉬운 표현 우선
- 하지만 과도한 순화는 오히려 어색할 수 있음
- 문맥에 맞게 선택

### 검출 기준

```
❌ 잘못된 예시:
"파일을 추가하려면 버튼을 클릭하세요.
파일을 더하는 과정은 간단합니다."
→ "추가/더하는" 혼용

✅ 교정:
"파일을 추가하려면 버튼을 클릭하세요.
파일을 추가하는 과정은 간단합니다."
```

### 교정 전략

1. **독자 고려**: 일반 대중은 쉬운 표현, 전문가는 전문 용어
2. **자연스러움**: 지나친 순화보다 통용되는 표현 우선
3. **일관성**: 한 번 선택하면 끝까지 유지

---

## 실전 적용

### 검사 순서

1. 문서에서 동일 개념을 나타내는 용어 추출
2. 각 용어의 사용 빈도 계산
3. 문서 타입에 맞는 표준 용어 확인
4. 다수결 + 표준 기준으로 통일안 제시

### 보고 형식

```markdown
## 용어 통일 불일치

**불일치 #4: 동일 개념 다른 표현**
- 🔄 "사용자": 10회
- 🔄 "유저": 3회
- 🔄 "이용자": 1회
- ✅ 제안: "사용자"로 통일 (다수결 + 공식 문서 표준)
- 📚 근거: 국립국어원 표준 용어

**불일치 #5: 외래어 표기**
- 🔄 "웹사이트": 5회
- 🔄 "웹 사이트": 2회
- ✅ 제안: "웹사이트"로 통일 (붙여쓰기)
- 📚 근거: 국립국어원 외래어 표기법
```

---

## 참고 자료

- [국립국어원 외래어 표기법](https://www.korean.go.kr/)
- [한국공공언어진흥원 전문용어 표준화](https://www.pikpl.or.kr/)
- [정보통신기술용어해설](http://www.ktword.co.kr/)
- [Kakao Enterprise 기술문서 가이드](https://tech.kakaoenterprise.com/105)
