# 어조 및 격식 일관성

이 문서는 한국어 문서에서 어조와 격식 수준의 일관성을 유지하기 위한 패턴과 기준을 설명합니다.

## 패턴 1: 경어체 혼용

**메타데이터**:
- 출처: 국립국어원 공문서 작성 지침, 대학 논문 작성 지침
- 권위: 🏛️ 법적 표준 + 📚 학술 표준
- 버전: 1.0.0

### 설명

한국어는 격식 수준에 따라 다양한 종결어미를 가지고 있습니다. 동일 문서 내에서 종결어미가 혼용되면 독자에게 일관성 없는 인상을 줍니다.

### 주요 경어체 분류

#### 1. 격식체 (하십시오체)
- **사용**: 공식 문서, 비즈니스 문서, 발표
- **종결어미**: -습니다/-습니까, -ㅂ니다/-ㅂ니까
- **예**: "회의는 오후 3시에 시작합니다."

#### 2. 격식체 (하오체)
- **사용**: 학술 논문, 보고서
- **종결어미**: -이다/-인가, -하다/-한가
- **예**: "이 연구는 세 가지 가설을 검증한다."

#### 3. 비격식체 (해요체)
- **사용**: 블로그, 일반 설명, 친근한 비즈니스
- **종결어미**: -이에요/-예요, -해요/-되요
- **예**: "회의는 오후 3시에 시작해요."

#### 4. 비격식체 (해체)
- **사용**: 친구 간, 매우 캐주얼한 글
- **종결어미**: -이야/-야, -해/-돼
- **예**: "회의는 오후 3시에 시작해."

### 검출 기준

**명백한 혼용 (반드시 지적)**:
```
❌ 잘못된 예시:
"이 제품은 고객 만족도를 높입니다. 또한 사용이 편리해요."
→ "~입니다"(격식)와 "~해요"(비격식) 혼용

✅ 교정 (격식체):
"이 제품은 고객 만족도를 높입니다. 또한 사용이 편리합니다."

✅ 교정 (비격식체):
"이 제품은 고객 만족도를 높여요. 또한 사용이 편리해요."
```

**미묘한 혼용 (문맥 고려)**:
```
예시: 학술 논문에서
"본 연구는 세 가지 가설을 검증한다. 결과는 다음과 같습니다."
→ "~한다"(하다체)와 "~습니다"(하십시오체) 혼용

판단: 학술 논문은 일반적으로 "~한다" 체로 통일하지만,
       일부 대학에서는 혼용을 허용하기도 함
```

### 문서 타입별 권장 어조

| 문서 타입 | 권장 격식 | 근거 |
|----------|---------|------|
| 공문서, 공식 보고서 | -습니다/-ㅂ니다 | 국어기본법 제14조, 행정업무 운영 규정 |
| 학술 논문 | -이다/-하다 | 대학 학위논문 작성 지침 (세종대, 경희대 등) |
| 비즈니스 프레젠테이션 | -습니다/-ㅂ니다 | 실무 관행 |
| 기술 문서 | -합니다/-입니다 또는 -한다 | Kakao Enterprise 가이드 |
| 블로그, 마케팅 | -해요/-이에요 | 독자 친화성 우선 |
| 소셜 미디어 | -해/-이야 | 캐주얼한 톤 |

### 교정 전략

1. **다수결 원칙**: 문서에서 가장 많이 사용된 어미를 기준으로 통일
2. **문서 타입**: 위 표를 참조하여 문서 타입에 맞는 어조 제안
3. **전체 통일**: 예외 없이 일관되게 적용 (강조를 위한 의도적 변화 제외)

---

## 패턴 2: 주어 불일치

**메타데이터**:
- 출처: 국립국어원 쉬운 공문서 쓰기 길잡이, 실무 관행
- 권위: 🏛️ 정부 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

한국어에서 1인칭 복수 주어는 "우리", "저희", "우리나라" 등 여러 표현이 있습니다. 동일 문서 내에서 이들을 혼용하면 화자의 태도가 일관적이지 않은 것처럼 보입니다.

### 주요 주어 선택

#### 1. 우리 vs 저희
- **우리**: 겸양의 의미가 약함, 동등한 관계
- **저희**: 겸양의 의미가 강함, 상대를 높임
- **예시**:
  - "우리 회사는..." (동료에게)
  - "저희 회사는..." (고객에게)

#### 2. 본인 vs 저
- **본인**: 공식적, 객관적
- **저**: 겸손함, 주관적
- **예시**:
  - "본인은 다음과 같이 제안합니다." (공문서)
  - "저는 다음과 같이 생각합니다." (의견서)

### 검출 기준

**명백한 불일치**:
```
❌ 잘못된 예시:
"저희 회사는 고객 만족을 최우선으로 합니다. 우리는 항상 노력하고 있습니다."
→ "저희"와 "우리" 혼용

✅ 교정:
"저희 회사는 고객 만족을 최우선으로 합니다. 저희는 항상 노력하고 있습니다."
```

### 문서 타입별 권장 주어

| 문서 타입 | 권장 주어 | 근거 |
|----------|---------|------|
| 대외 비즈니스 문서 | 저희, 저 | 고객에 대한 겸양 |
| 내부 문서 | 우리, 본인 | 동료 간 동등 관계 |
| 학술 논문 | 본 연구, 필자, 저자 | 객관성 유지 |
| 공문서 | 본인, 당 기관 | 공식성 |

### 교정 전략

1. **대상 파악**: 독자가 누구인지 확인 (고객/동료/일반 대중)
2. **일관성**: 한 번 선택한 주어를 끝까지 유지
3. **문맥**: 문장에 따라 주어를 바꾸는 것은 허용하되, 같은 개념에 대해서는 통일

---

## 패턴 3: 문체 충돌

**메타데이터**:
- 출처: 학술 글쓰기 가이드, 테크니컬 라이팅 실무
- 권위: 📚 학술 표준 + 💼 실무 표준
- 버전: 1.0.0

### 설명

격식 있는 표현과 구어체 표현이 혼재되면 문서의 전문성이 떨어집니다.

### 주요 충돌 패턴

#### 1. 축약형 혼용
```
❌ 잘못된 예시:
"이 방법은 효과적이지 않습니다. 그래서 안 돼요."
→ "않습니다"(격식)와 "안 돼요"(구어) 혼용

✅ 교정:
"이 방법은 효과적이지 않습니다. 그래서 적합하지 않습니다."
```

#### 2. 간투사/감탄사 사용
```
❌ 잘못된 예시:
"본 연구의 결과는 매우 흥미롭습니다. 와, 정말 놀라운 발견이에요!"
→ 격식 문서에 "와", "정말" 같은 감탄사 부적절

✅ 교정:
"본 연구의 결과는 매우 흥미롭습니다. 이는 주목할 만한 발견입니다."
```

#### 3. 속어/은어 사용
```
❌ 잘못된 예시:
"이 기능은 완전 대박입니다. 성능이 크게 향상되었습니다."
→ "완전 대박"은 격식 문서에 부적절

✅ 교정:
"이 기능은 매우 우수합니다. 성능이 크게 향상되었습니다."
```

### 교정 전략

1. **문서 전체의 톤**: 처음부터 끝까지 일관된 격식 수준 유지
2. **대체 표현**: 구어체 표현을 격식 있는 표현으로 변환
3. **예외 허용**: 인용문이나 캐릭터 묘사는 예외

---

## 실전 적용

### 검사 순서

1. 문서 타입 파악 (비즈니스/학술/기술/마케팅)
2. 종결어미 전수 조사 (-습니다/-해요/-한다 등)
3. 빈도 계산 및 다수결 적용
4. 주어 일관성 확인
5. 구어체 표현 탐색
6. 통일안 제시

### 보고 형식

```markdown
## 어조 및 격식 불일치

**불일치 #1: 경어체 혼용**
- 🔄 "-습니다" 체: 12회 사용
- 🔄 "-해요" 체: 3회 사용
- ✅ 제안: 비즈니스 문서이므로 "-습니다" 체로 통일
- 📚 근거: 국립국어원 공문서 작성 지침

**불일치 #2: 주어 불일치**
- 🔄 "저희": 5회
- 🔄 "우리": 2회
- ✅ 제안: 대외 문서이므로 "저희"로 통일
- 📚 근거: 실무 관행 (고객 대상 문서는 겸양 표현 사용)
```

---

## 참고 자료

- [국립국어원 쉬운 공문서 쓰기 길잡이](https://www.data.go.kr/data/15118448/fileData.do)
- [세종대학교 학위논문 작성 형식](https://sejong-kr.libguides.com/c.php?g=930661&p=6770589)
- [Kakao Enterprise 기술문서 작성 가이드](https://tech.kakaoenterprise.com/105)
