# Legal Information
The System Reference Document 5.2.1 (“SRD 5.2.1”) is provided to you free of charge by Wizards of the Coast LLC ("Wizards") under the terms of the Creative Commons Attribution 4.0 International License ("CC-BY-4.0"). You are free to use the content in this document in any manner permitted under CC-BY-4.0, provided that you include the following attribution statement in any of your work:

This work includes material from the System Reference Document 5.2.1 ("SRD 5.2.1") by Wizards of the Coast LLC, available at https://www.dndbeyond.com/srd. The SRD 5.2.1 is licensed under the Creative Commons Attribution 4.0 International License, available at https://creativecommons.org/licenses/by/4.0/legalcode.

Please do not include any other attribution to Wizards or its parent or affiliates other than that provided above. You may, however, include a statement on your work indicating that it is "compatible with fifth edition" or "5E compatible."

Section 5 of CC-BY-4.0 includes a Disclaimer of Warranties and Limitation of Liability that limits our liability to you.

I System Reference Document 5.2.1
***
# Contents

*   **Legal Information**
*   **Playing the Game**
    *   Rhythm of Play
    *   The Six Abilities
    *   D20 Tests
        *   Ability Checks
        *   Saving Throws
        *   Attack Rolls
    *   Advantage/Disadvantage
    *   Proficiency
*   **Actions**
    *   Bonus Actions
    *   Reactions
    *   Social Interaction
*   **Exploration**
    *   Vision and Light
    *   Hiding
    *   Interacting with Objects
    *   Hazards
    *   Travel
*   **Combat**
    *   The Order of Combat
    *   Movement and Position
    *   Making an Attack
    *   Ranged Attacks
    *   Melee Attacks
    *   Mounted Combat
    *   Underwater Combat
*   **Damage and Healing**
    *   Hit Points
    *   Damage Rolls
    *   Critical Hits
    *   Saving Throws and Damage
    *   Damage Types
    *   Resistance and Vulnerability
    *   Immunity
    *   Healing
    *   Dropping to 0 Hit Points
    *   Temporary Hit Points
*   **Character Creation**
    *   Choose a Character Sheet
    *   Create Your Character
    *   Level Advancement
    *   Starting at Higher Levels
    *   Multiclassing
    *   Trinkets
*   **Classes**
    *   Barbarian
        *   Barbarian Subclass: Path of the Berserker
    *   Bard
        *   Bard Spell List
        *   Bard Subclass: College of Lore
    *   Cleric
        *   Cleric Spell List
        *   Cleric Subclass: Life Domain
    *   Druid
        *   Druid Spell List
        *   Druid Subclass: Circle of the Land
    *   Fighter
        *   Fighter Subclass: Champion
    *   Monk
        *   Monk Subclass: Warrior of the Open Hand
    *   Paladin
        *   Paladin Spell List
        *   Paladin Subclass: Oath of Devotion
    *   Ranger
        *   Ranger Spell List
        *   Ranger Subclass: Hunter
    *   Rogue
        *   Rogue Subclass: Thief
    *   Sorcerer
        *   Metamagic Options
        *   Sorcerer Spell List
        *   Sorcerer Subclass: Draconic Sorcery
    *   Warlock
        *   Eldritch Invocation Options
        *   Warlock Spell List
        *   Warlock Subclass: Fiend Patron
    *   Wizard
        *   Wizard Spell List
        *   Wizard Subclass: Evoker
*   **Character Origins**
    *   Character Backgrounds
        *   Acolyte
        *   Criminal
        *   Sage
        *   Soldier
    *   Character Species
        *   Dragonborn
        *   Dwarf
        *   Elf
        *   Gnome
        *   Goliath
        *   Halfling
        *   Human
        *   Orc
        *   Tiefling
*   **Feats**
    *   Feat Descriptions
    *   Origin Feats
    *   General Feats
    *   Fighting Style Feats
    *   Epic Boon Feats
*   **Equipment**
    *   Coins
    *   Weapons
        *   Properties
        *   Mastery Properties
    *   Armor
    *   Tools
    *   Adventuring Gear
    *   Mounts and Vehicles
    *   Lifestyle Expenses
    *   Food, Drink, and Lodging
    *   Hirelings
    *   Spellcasting
    *   Magic Items
    *   Crafting Nonmagical Items
    *   Brewing Potions of Healing
    *   Scribing Spell Scrolls
*   **Spells**
    *   Gaining Spells
    *   Casting Spells
    *   Spell Descriptions
*   **Rules Glossary**
*   **Gameplay Toolbox**
    *   Travel Pace
    *   Creating a Background
    *   Curses and Magical Contagions
    *   Environmental Effects
    *   Fear and Mental Stress
    *   Poison
    *   Traps
    *   Combat Encounters
*   **Magic Items**
    *   Magic Item Categories
    *   Magic Item Rarity
    *   Activating a Magic Item
    *   "The Next Dawn"
    *   Cursed Items
    *   Magic Item Resilience
    *   Crafting Magic Items
    *   Sentient Magic Items
    *   Magic Items A–Z
*   **Monsters**
    *   Stat Block Overview
    *   Parts of a Stat Block
    *   Running a Monster
*   **Monsters A–Z**
*   **Animals**

## Index of Stat Blocks
*   Aboleth
*   Adult Black Dragon
*   Adult Blue Dragon
*   Adult Brass Dragon
*   Adult Bronze Dragon
*   Adult Copper Dragon
*   Adult Gold Dragon
*   Adult Green Dragon
*   Adult Red Dragon
*   Adult Silver Dragon
*   Adult White Dragon
*   Air Elemental
*   Allosaurus
*   Ancient Black Dragon
*   Ancient Blue Dragon
*   Ancient Brass Dragon
*   Ancient Bronze Dragon
*   Ancient Copper Dragon
*   Ancient Gold Dragon
*   Ancient Green Dragon
*   Ancient Red Dragon
*   Ancient Silver Dragon
*   Ancient White Dragon
*   Animated Armor
*   Animated Flying Sword
*   Animated Rug of Smothering
*   Ankheg
*   Ankylosaurus
*   Ape
*   Archelon
*   Archmage
*   Assassin
*   Awakened Shrub
*   Awakened Tree
*   Axe Beak
*   Azer Sentinel
*   Baboon
*   Badger
*   Balor
*   Bandit
*   Bandit Captain
*   Barbed Devil
*   Basilisk
*   Bat
*   Bearded Devil
*   Behir
*   Berserker
*   Black Bear
*   Black Dragon Wyrmling
*   Black Pudding
*   Blink Dog
*   Blood Hawk
*   Blue Dragon Wyrmling
*   Boar
*   Bone Devil
*   Brass Dragon Wyrmling
*   Bronze Dragon Wyrmling
*   Brown Bear
*   Bugbear Stalker
*   Bugbear Warrior
*   Bulette
*   Camel
*   Cat
*   Centaur Trooper
*   Chain Devil
*   Chimera
*   Chuul
*   Clay Golem
*   Cloaker
*   Cloud Giant
*   Cockatrice
*   Commoner
*   Constrictor Snake
*   Copper Dragon Wyrmling
*   Couatl
*   Crab
*   Crocodile
*   Cultist
*   Cultist Fanatic
*   Darkmantle
*   Death Dog
*   Deer
*   Deva
*   Dire Wolf
*   Djinni
*   Doppelganger
*   Draft Horse
*   Dragon Turtle
*   Dretch
*   Drider
*   Druid
*   Dryad
*   Dust Mephit
*   Eagle
*   Earth Elemental
*   Efreeti
*   Elephant
*   Elk
*   Erinyes
*   Ettercap
*   Ettin
*   Fire Elemental
*   Fire Giant
*   Flesh Golem
*   Flying Snake
*   Frog
*   Frost Giant
*   Gargoyle
*   Gelatinous Cube
*   Ghast
*   Ghost
*   Ghoul
*   Giant Ape
*   Giant Badger
*   Giant Bat
*   Giant Boar
*   Giant Centipede
*   Giant Constrictor Snake
*   Giant Crab
*   Giant Crocodile
*   Giant Eagle
*   Giant Elk
*   Giant Fire Beetle
*   Giant Frog
*   Giant Goat
*   Giant Hyena
*   Giant Lizard
*   Giant Octopus
*   Giant Owl
*   Giant Rat
*   Giant Scorpion
*   Giant Seahorse
*   Giant Shark
*   Giant Spider
*   Giant Toad
*   Giant Venomous Snake
*   Giant Vulture
*   Giant Wasp
*   Giant Weasel
*   Giant Wolf Spider
*   Gibbering Mouther
*   Glabrezu
*   Gladiator
*   Gnoll Warrior
*   Goat
*   Goblin Boss
*   Goblin Minion
*   Goblin Warrior
*   Gold Dragon Wyrmling
*   Gorgon
*   Gray Ooze
*   Green Dragon Wyrmling
*   Green Hag
*   Grick
*   Griffon
*   Grimlock
*   Guard
*   Guard Captain
*   Guardian Naga
*   Half-Dragon
*   Harpy
*   Hawk
*   Hell Hound
*   Hezrou
*   Hill Giant
*   Hippogriff
*   Hippopotamus
*   Hobgoblin Captain
*   Hobgoblin Warrior
*   Homunculus
*   Horned Devil
*   Hunter Shark
*   Hydra
*   Hyena
*   Ice Devil
*   Ice Mephit
*   Imp
*   Incubus
*   Invisible Stalker
*   Iron Golem
*   Jackal
*   Killer Whale
*   Knight
*   Kobold Warrior
*   Kraken
*   Lamia
*   Lemure
*   Lich
*   Lion
*   Lizard
*   Mage
*   Magma Mephit
*   Magmin
*   Mammoth
*   Manticore
*   Marilith
*   Mastiff
*   Medusa
*   Merfolk Skirmisher
*   Merrow
*   Mimic
*   Minotaur of Baphomet
*   Minotaur Skeleton
*   Mule
*   Mummy
*   Mummy Lord
*   Nalfeshnee
*   Night Hag
*   Nightmare
*   Noble
*   Ochre Jelly
*   Octopus
*   Ogre
*   Ogre Zombie
*   Oni
*   Otyugh
*   Owl
*   Owlbear
*   Panther
*   Pegasus
*   Phase Spider
*   Piranha
*   Pirate
*   Pirate Captain
*   Pit Fiend
*   Planetar
*   Plesiosaurus
*   Polar Bear
*   Pony
*   Priest
*   Priest Acolyte
*   Pseudodragon
*   Pteranodon
*   Purple Worm
*   Quasit
*   Rakshasa
*   Rat
*   Raven
*   Red Dragon Wyrmling
*   Reef Shark
*   Remorhaz
*   Rhinoceros
*   Riding Horse
*   Roc
*   Roper
*   Rust Monster
*   Saber-Toothed Tiger
*   Sahuagin Warrior
*   Salamander
*   Satyr
*   Scorpion
*   Scout
*   Sea Hag
*   Seahorse
*   Shadow
*   Shambling Mound
*   Shield Guardian
*   Shrieker Fungus
*   Silver Dragon Wyrmling
*   Skeleton
*   Solar
*   Specter
*   Sphinx of Lore
*   Sphinx of Valor
*   Sphinx of Wonder
*   Spider
*   Spirit Naga
*   Sprite
*   Spy
*   Steam Mephit
*   Stirge
*   Stone Giant
*   Stone Golem
*   Storm Giant
*   Succubus
*   Swarm of Bats
*   Swarm of Crawling Claws
*   Swarm of Insects
*   Swarm of Piranhas
*   Swarm of Rats
*   Swarm of Ravens
*   Swarm of Venomous Snakes
*   Tarrasque
*   Tiger
*   Tough
*   Tough Boss
*   Treant
*   Triceratops
*   Troll
*   Troll Limb
*   Tyrannosaurus Rex
*   Unicorn
*   Vampire
*   Vampire Familiar
*   Vampire Spawn
*   Venomous Snake
*   Violet Fungus
*   Vrock
*   Vulture
*   Warhorse
*   Warhorse Skeleton
*   Warrior Infantry
*   Warrior Veteran
*   Water Elemental
*   Weasel
*   Werebear
*   Wereboar
*   Wererat
*   Weretiger
*   Werewolf
*   White Dragon Wyrmling
*   Wight
*   Will-o'-Wisp
*   Winter Wolf
*   Wolf
*   Worg
*   Wraith
*   Wyvern
*   Xorn
*   Young Black Dragon
*   Young Blue Dragon
*   Young Brass Dragon
*   Young Bronze Dragon
*   Young Copper Dragon
*   Young Gold Dragon
*   Young Green Dragon
*   Young Red Dragon
*   Young Silver Dragon
*   Young White Dragon
*   Zombie
***
# Playing the Game

## Rhythm of Play
The three main pillars of D&D play are social interaction, exploration, and combat. Whichever one you're experiencing, the game unfolds according to this basic pattern:

1.  **The Game Master Describes a Scene.** The GM tells the players where their adventurers are and what's around them (how many doors lead out of a room, what's on a table, and so on).
2.  **The Players Describe What Their Characters Do.** Typically, the characters stick together as they travel through a dungeon or another environment. Sometimes different adventurers do different things: one adventurer might search a treasure chest while a second examines a mysterious symbol engraved on a wall and a third keeps watch for monsters. Outside combat, the GM ensures that every character has a chance to act and decides how to resolve their activity. In combat, the characters take turns.
3.  **The GM Narrates the Results of the Adventurers' Actions.** Sometimes resolving a task is easy. If an adventurer walks across a room and tries to open a door, the GM might say the door opens and describe what lies beyond. But the door might be locked, the floor might hide a trap, or some other circumstance might make it challenging for an adventurer to complete a task. In those cases, the GM might ask the player to roll a die to help determine what happens. Describing the results often leads to another decision point, which brings the game back to step 1.

This pattern holds during every game session (each time you sit down to play D&D), whether the adventurers are talking to a noble, exploring a ruin, or fighting a dragon. In certain situations—particularly combat—the action is more structured, and everyone takes turns.

> **EXCEPTIONS SUPERSEDE GENERAL RULES**
> General rules govern each part of the game. For example, the combat rules tell you that melee attacks use Strength and ranged attacks use Dexterity. That's a general rule, and a general rule is in effect as long as something in the game doesn't explicitly say otherwise.
> The game also includes elements—class features, feats, weapon properties, spells, magic items, monster abilities, and the like—that sometimes contradict a general rule. When an exception and a general rule disagree, the exception wins. For example, if a feature says you can make melee attacks using your Charisma, you can do so, even though that statement disagrees with the general rule.

## The Six Abilities
All creatures—characters and monsters—have six abilities that measure physical and mental characteristics, as shown on the Ability Descriptions table.

**Ability Descriptions**
| Ability | Score Measures ... |
| :--- | :--- |
| **Strength** | Physical might |
| **Dexterity** | Agility, reflexes, and balance |
| **Constitution** | Health and stamina |
| **Intelligence** | Reasoning and memory |
| **Wisdom** | Perceptiveness and mental fortitude |
| **Charisma** | Confidence, poise, and charm |

### Ability Scores
Each ability has a score from 1 to 20, although some monsters have a score as high as 30. The score represents the magnitude of an ability. The Ability Scores table summarizes what the scores mean.

**Ability Scores**
| Score | Meaning |
| :--- | :--- |
| 1 | This is the lowest a score can normally go. If an effect reduces a score to 0, that effect explains what happens. |
| 2–9 | This represents a weak capability. |
| 10–11 | This represents the human average. |
| 12–19 | This represents a strong capability. |
| 20 | This is the highest an adventurer's score can go unless a feature says otherwise. |
| 21–29 | This represents an extraordinary capability. |
| 30 | This is the highest a score can go. |

### Ability Modifiers
Each ability has a modifier that you apply whenever you make a D20 Test with that ability (explained in "D20 Tests"). An ability modifier is derived from its score, as shown in the Ability Modifiers table.

> **ROUND DOWN**
> Whenever you divide or multiply a number in the game, round down if you end up with a fraction, even if the fraction is one-half or greater. Some rules make an exception and tell you to round up.
***
**Ability Modifiers**
| Score | Modifier | Score | Modifier |
| :--- | :--- | :--- | :--- |
| 1 | −5 | 16–17 | +3 |
| 2–3 | −4 | 18–19 | +4 |
| 4–5 | −3 | 20–21 | +5 |
| 6–7 | −2 | 22–23 | +6 |
| 8–9 | −1 | 24–25 | +7 |
| 10–11 | +0 | 26–27 | +8 |
| 12–13 | +1 | 28–29 | +9 |
| 14–15 | +2 | 30 | +10 |

## D20 Tests
When the outcome of an action is uncertain, the game uses a d20 roll to determine success or failure. These rolls are called D20 Tests, and they come in three kinds: ability checks, saving throws, and attack rolls. They follow these steps:

**4: Roll 1d20.** You always want to roll high. If the roll has Advantage or Disadvantage (described later in “Playing the Game”), you roll two d20s, but you use the number from only one of them— the higher one if you have Advantage or the lower one if you have Disadvantage.
**5: Add Modifiers.** Add these modifiers to the number rolled on the d20:
*   **The Relevant Ability Modifier.** “Playing the Game” and “Rules Glossary” explain which ability modifiers to use for various D20 Tests.
*   **Your Proficiency Bonus If Relevant.** Each creature has a Proficiency Bonus, a number added when making a D20 Test that uses something, such as a skill, in which the creature has proficiency. See “Proficiency” later in “Playing the Game.”
*   **Circumstantial Bonuses and Penalties.** A class feature, a spell, or another rule might give a bonus or penalty to the die roll.

**6: Compare the Total to a Target Number.** If the total of the d20 and its modifiers equals or exceeds the target number, the D20 Test succeeds. Otherwise, it fails. The Game Master determines target numbers and tells players whether their rolls are successful. The target number for an ability check or a saving throw is called a Difficulty Class (DC). The target number for an attack roll is called an Armor Class (AC), which appears on a character sheet or in a stat block (see “Rules Glossary”).

## Ability Checks
An ability check represents a creature using talent and training to try to overcome a challenge, such as forcing open a stuck door, picking a lock, entertaining a crowd, or deciphering a cipher. The GM and the rules often call for an ability check when a creature attempts something other than an attack that has a chance of meaningful failure. When the outcome is uncertain and narratively interesting, the dice determine the result.

### Ability Modifier
An ability check is named for the ability modifier it uses: a Strength check, an Intelligence check, and so on. Different ability checks are called for in different situations, depending on which ability is most relevant. See the Ability Check Examples table for examples of each check’s use.

**Ability Check Examples**
| Ability | Make a Check To ... |
| :--- | :--- |
| **Strength** | Lift, push, pull, or break something |
| **Dexterity** | Move nimbly, quickly, or quietly |
| **Constitution** | Push your body beyond normal limits |
| **Intelligence** | Reason or remember |
| **Wisdom** | Notice things in the environment or in creatures’ behavior |
| **Charisma** | Influence, entertain, or deceive |

### Proficiency Bonus
Add your Proficiency Bonus to an ability check when the GM determines that a skill or tool proficiency is relevant to the check and you have that proficiency. For example, if a rule refers to a Strength (Acrobatics or Athletics) check, you can add your Proficiency Bonus to the check if you have proficiency in the Acrobatics or Athletics skill. See “Proficiency” later in “Playing the Game” for more information about skill and tool proficiencies.

### Difficulty Class
The Difficulty Class of an ability check represents the task’s difficulty. The more difficult the task, the higher its DC. The rules provide DCs for certain checks, but the GM ultimately sets them. The Typical Difficulty Classes table presents a range of possible DCs for ability checks.

**Typical Difficulty Classes**
| Task Difficulty | DC | Task Difficulty | DC |
| :--- | :- | :--- | :- |
| Very easy | 5 | Very hard | 25 |
| Easy | 10 | Nearly impossible | 30 |
| Medium | 15 | | |
| Hard | 20 | | |
***
## Saving Throws
A saving throw—also called a save—represents an attempt to evade or resist a threat, such as a fiery explosion, a blast of poisonous gas, or a spell trying to invade your mind. You don't normally choose to make a save; you must make one because your character or a monster (if you're the GM) is at risk. A save's result is detailed in the effect that caused it.
If you don't want to resist the effect, you can choose to fail the save without rolling.

### Ability Modifier
Saving throws are named for the ability modifiers they use: a Constitution saving throw, a Wisdom saving throw, and so on. Different saving throws are used to resist different kinds of effects, as shown on the Saving Throw Examples table.

**Saving Throw Examples**
| Ability | Make a Save To ... |
| :--- | :--- |
| **Strength** | Physically resist direct force |
| **Dexterity** | Dodge out of harm's way |
| **Constitution** | Endure a toxic hazard |
| **Intelligence** | Recognize an illusion as fake |
| **Wisdom** | Resist a mental assault |
| **Charisma** | Assert your identity |

### Proficiency Bonus
You add your Proficiency Bonus to your saving throw if you have proficiency in that kind of save. See “Proficiency” later in “Playing the Game.”

### Difficulty Class
The Difficulty Class for a saving throw is determined by the effect that causes it or by the GM. For example, if a spell forces you to make a save, the DC is determined by the caster's spellcasting ability and Proficiency Bonus. Monster abilities that call for saves specify the DC.

## Attack Rolls
An attack roll determines whether an attack hits a target. An attack roll hits if the roll equals or exceeds the target's Armor Class. Attack rolls usually occur in battle, described in "Combat" later in "Playing the Game," but the GM might also ask for an attack roll in other situations, such as an archery competition.

### Ability Modifier
The Attack Roll Abilities table shows which ability modifier to use for different types of attack rolls.

**Attack Roll Abilities**
| Ability | Attack Type |
| :--- | :--- |
| **Strength** | Melee attack with a weapon or an Unarmed Strike (see “Rules Glossary”) |
| **Dexterity** | Ranged attack with a weapon |
| **Varies** | Spell attack (the ability used is determined by the spellcaster’s spellcasting feature, as explained in “Spells”) |

Some features let you use different ability modifiers from those listed. For example, the Finesse property (see "Equipment") lets you use Strength or Dexterity with a weapon that has that property.

### Proficiency Bonus
You add your Proficiency Bonus to your attack roll when you attack using a weapon you have proficiency with, as well as when you attack with a spell. See “Proficiency” later in “Playing the Game” for more information about weapon proficiencies.

### Armor Class
A creature's Armor Class represents how well the creature avoids being wounded in combat. The AC of a character is determined at character creation (see “Character Creation”), whereas the AC of a monster appears in its stat block.
**Calculating AC.** All creatures start with the same base AC calculation:
Base AC = 10 + the creature’s Dexterity modifier
A creature’s AC can then be modified by armor, magic items, spells, and more.
**Only One Base AC.** Some spells and class features give characters a different way to calculate their AC. A character with multiple features that give different ways to calculate AC must choose which one to use; only one base calculation can be in effect for a creature.

### Rolling 20 or 1
If you roll a 20 on the d20 (called a “natural 20”) for an attack roll, the attack hits regardless of any modifiers or the target’s AC. This is called a Critical Hit (see “Combat” later in “Playing the Game”).
If you roll a 1 on the d20 (a “natural 1”) for an attack roll, the attack misses regardless of any modifiers or the target’s AC.

## Advantage/Disadvantage
Sometimes a D20 Test is modified by Advantage or Disadvantage. Advantage reflects the positive circumstances surrounding a d20 roll, while Disadvantage reflects negative circumstances.
You usually acquire Advantage or Disadvantage through the use of special abilities and actions. The GM can also decide that circumstances grant Advantage or impose Disadvantage.
***
> **HEROIC INSPIRATION**
> Sometimes the GM or a rule gives you Heroic Inspiration. If you have Heroic Inspiration, you can expend it to reroll any die immediately after rolling it, and you must use the new roll.
> **Only One at a Time.** You can never have more than one instance of Heroic Inspiration. If something gives you Heroic Inspiration and you already have it, you can give it to a player character in your group who lacks it.
> **Gaining Heroic Inspiration.** Your GM can give you Heroic Inspiration for a variety of reasons. Typically, GMs award it when you do something particularly heroic, in character, or entertaining. It’s a reward for making the game more fun for everyone playing.
> Other rules might allow your character to gain Heroic Inspiration independent of the GM’s decision. For example, Human characters start each day with Heroic Inspiration.

### Roll Two D20s
When a roll has either Advantage or Disadvantage, roll a second d20 when you make the roll. Use the higher of the two rolls if you have Advantage, and use the lower roll if you have Disadvantage. For example, if you have Disadvantage and roll an 18 and a 3, use the 3. If you instead have Advantage and roll those numbers, use the 18.

### They Don't Stack
If multiple situations affect a roll and they all grant Advantage on it, you still roll only two d20s. Similarly, if multiple situations impose Disadvantage on a roll, you roll only two d20s.
If circumstances cause a roll to have both Advantage and Disadvantage, the roll has neither of them, and you roll one d20. This is true even if multiple circumstances impose Disadvantage and only one grants Advantage or vice versa. In such a situation, you have neither Advantage nor Disadvantage.

### Interactions with Rerolls
When you have Advantage or Disadvantage and something in the game lets you reroll or replace the d20, you can reroll or replace only one die, not both. You choose which one.
For example, if you have Heroic Inspiration (see the sidebar below) and roll a 3 and an 18 on an ability check that has Advantage or Disadvantage, you could expend your Heroic Inspiration to reroll one of those dice, not both of them.

## Proficiency
Characters and monsters are good at various things. Some are skilled with many weapons, while others can use only a few. Some are better at understanding people’s motives, and others are better at unlocking the secrets of the multiverse. All creatures have a Proficiency Bonus, which reflects the impact that training has on the creature’s capabilities. A character’s Proficiency Bonus increases as the character gains levels (described in “Character Creation”). A monster’s Proficiency Bonus is based on its Challenge Rating (see “Rules Glossary”). The Proficiency Bonus table shows how the bonus is determined.
This bonus is applied to a D20 Test when the creature has proficiency in a skill, in a saving throw, or with an item that the creature uses to make the D20 Test. The bonus is also used for spell attacks and for calculating the DC of saving throws for spells.

**Proficiency Bonus**
| Level or CR | Bonus | Level or CR | Bonus |
| :--- | :--- | :--- | :--- |
| Up to 4 | +2 | 17–20 | +6 |
| 5–8 | +3 | 21–24 | +7 |
| 9–12 | +4 | 25–28 | +8 |
| 13–16 | +5 | 29–30 | +9 |

### The Bonus Doesn't Stack
Your Proficiency Bonus can’t be added to a die roll or another number more than once. For example, if a rule allows you to make a Charisma (Deception or Persuasion) check, you add your Proficiency Bonus if you’re proficient in either skill, but you don’t add it twice if you’re proficient in both skills.
Occasionally, a Proficiency Bonus might be multiplied or divided (doubled or halved, for example) before being added. For example, the Expertise feature (see “Rules Glossary”) doubles the Proficiency Bonus for certain ability checks. Whenever the bonus is used, it can be multiplied only once and divided only once.

### Skill Proficiencies
Most ability checks involve using a skill, which represents a category of things creatures try to do with an ability check. The descriptions of the actions you take (see “Actions” later in "Playing the Game") specify which skill applies if you make an ability check for that action, and many other rules note when a skill is relevant. The GM has the ultimate say on whether a skill is relevant in a situation.
If a creature is proficient in a skill, the creature applies its Proficiency Bonus to ability checks involving that skill. Without proficiency in a skill, a creature can still make ability checks involving that skill but doesn't add its Proficiency Bonus. For example, if a character tries to climb a cliff, the GM might ask for a Strength (Athletics) check. If the character has Athletics proficiency, the character adds their Proficiency Bonus to the Strength check. If the character lacks that proficiency, they make the check without adding their Proficiency Bonus.
***
## Skills

| Skill | Ability | Example Uses |
| :--- | :--- | :--- |
| **Acrobatics** | Dexterity | Stay on your feet in a tricky situation, or perform an acrobatic stunt. |
| **Animal Handling** | Wisdom | Calm or train an animal, or get an animal to behave in a certain way. |
| **Arcana** | Intelligence | Recall lore about spells, magic items, and the planes of existence. |
| **Athletics** | Strength | Jump farther than normal, stay afloat in rough water, or break something. |
| **Deception** | Charisma | Tell a convincing lie, or wear a disguise convincingly. |
| **History** | Intelligence | Recall lore about historical events, people, nations, and cultures. |
| **Insight** | Wisdom | Discern a person's mood and intentions. |
| **Intimidation** | Charisma | Awe or threaten someone into doing what you want. |
| **Investigation** | Intelligence | Find obscure information in books, or deduce how something works. |
| **Medicine** | Wisdom | Diagnose an illness, or determine what killed the recently slain. |
| **Nature** | Intelligence | Recall lore about terrain, plants, animals, and weather. |
| **Perception** | Wisdom | Using a combination of senses, notice something that's easy to miss. |
| **Performance** | Charisma | Act, tell a story, perform music, or dance. |
| **Persuasion** | Charisma | Honestly and graciously convince someone of something. |
| **Religion** | Intelligence | Recall lore about gods, religious rituals, and holy symbols. |
| **Sleight of Hand** | Dexterity | Pick a pocket, conceal a handheld object, or perform legerdemain. |
| **Stealth** | Dexterity | Escape notice by moving quietly and hiding behind things. |
| **Survival** | Wisdom | Follow tracks, forage, find a trail, or avoid natural hazards. |

### Skill List
The skills are shown on the Skills table, which notes example uses for each skill proficiency as well as the ability check the skill most often applies to.

### Determining Skills
A character’s starting skill proficiencies are determined at character creation, and a monster’s skill proficiencies appear in its stat block.

## Saving Throw Proficiencies
Proficiency in a saving throw lets a character add their Proficiency Bonus to saves that use a particular ability. For example, proficiency in Wisdom saves lets you add your Proficiency Bonus to your Wisdom saves. Some monsters also have saving throw proficiencies, as noted in their stat blocks.
Each class gives proficiency in at least two saving throws, representing that class’s training in evading or resisting certain threats. Wizards, for example, are proficient in Intelligence and Wisdom saves; they train to resist mental assault.

## Equipment Proficiencies
A character gains proficiency with various weapons and tools from their class and background. There are two categories of equipment proficiency:

**Weapons.** Anyone can wield a weapon, but proficiency makes you better at wielding it. If you have proficiency with a weapon, you add your Proficiency Bonus to attack rolls you make with it.
**Tools.** If you have proficiency with a tool, you can add your Proficiency Bonus to any ability check you make that uses the tool. If you have proficiency in the skill that’s also used with that check, you have Advantage on the check too. This means you can benefit from both skill proficiency and tool proficiency on the same ability check.

## Actions
When you do something other than moving or communicating, you typically take an action. The Action table lists the game’s main actions, which are defined in more detail in “Rules Glossary.”

**Actions**
| Action | Summary |
| :--- | :--- |
| **Attack** | Attack with a weapon or an Unarmed Strike. |
| **Dash** | For the rest of the turn, give yourself extra movement equal to your Speed. |
| **Disengage** | Your movement doesn't provoke Opportunity Attacks for the rest of the turn. |
| **Dodge** | Until the start of your next turn, attack rolls against you have Disadvantage, and you make Dexterity saving throws with Advantage. You lose this benefit if you have the Incapacitated condition or if your Speed is 0. |
| **Help** | Help another creature's ability check or attack roll, or administer first aid. |
| **Hide** | Make a Dexterity (Stealth) check. |
| **Influence** | Make a Charisma (Deception, Intimidation, Performance, or Persuasion) or Wisdom (Animal Handling) check to alter a creature's attitude. |
| **Magic** | Cast a spell, use a magic item, or use a magical feature. |
| **Ready** | Prepare to take an action in response to a trigger you define. |
| **Search** | Make a Wisdom (Insight, Medicine, Perception, or Survival) check. |
| **Study** | Make an Intelligence (Arcana, History, Investigation, Nature, or Religion) check. |
| **Utilize** | Use a nonmagical object. |

Player characters and monsters can also do things not covered by these actions. Many class features and other abilities provide additional action options, and you can improvise other actions. When you describe an action not detailed elsewhere in the rules, the Game Master tells you whether that action is possible and what kind of D20 Test you need to make, if any.
***
### One Thing at a Time
The game uses actions to govern how much you can do at one time. You can take only one action at a time. This principle is most important in combat, as explained in “Combat” later in “Playing the Game.”
Actions can come up in other situations, too: in a social interaction, you can try to Influence a creature or use the Search action to read the creature’s body language, but you can’t do both at the same time. And when you’re exploring a dungeon, you can’t simultaneously use the Search action to look for traps and use the Help action to aid another character who’s trying to open a stuck door (with the Utilize action).

### Bonus Actions
Various class features, spells, and other abilities let you take an additional action on your turn called a Bonus Action. The Cunning Action feature, for example, allows a Rogue to take a Bonus Action. You can take a Bonus Action only when a special ability, a spell, or another feature of the game states that you can do something as a Bonus Action. You otherwise don't have a Bonus Action to take.
You can take only one Bonus Action on your turn, so you must choose which Bonus Action to use if you have more than one available.
You choose when to take a Bonus Action during your turn unless the Bonus Action's timing is specified. Anything that deprives you of your ability to take actions also prevents you from taking a Bonus Action.

## Reactions
Certain special abilities, spells, and situations allow you to take a special action called a Reaction. A Reaction is an instant response to a trigger of some kind, which can occur on your turn or on someone else’s. The Opportunity Attack, described later in "Playing the Game," is the most common type of Reaction.
When you take a Reaction, you can't take another one until the start of your next turn. If the reaction interrupts another creature's turn, that creature can continue its turn right after the Reaction.
In terms of timing, a Reaction takes place immediately after its trigger unless the Reaction's description says otherwise.

## Social Interaction
During their adventures, player characters meet many different people and face some monsters that would rather talk than fight. In those situations, it's time for social interaction, which takes many forms. For example, you might try to convince a burglar to confess to wrongdoing or try to flatter a guard. The Game Master assumes the roles of any nonplayer characters who are participating.
An NPC's attitude toward your character is Friendly, Indifferent, or Hostile, as defined in "Rules Glossary." Friendly NPCs are predisposed to help, and Hostile ones are inclined to hinder.
Social interactions progress in two ways: through roleplaying and ability checks.

### Roleplaying
Roleplaying is, literally, the act of playing out a role. In this case, it's you as a player determining how your character thinks, acts, and talks. Roleplaying is part of every aspect of the game, and it comes to the fore during social interactions.
As you roleplay, consider whether you prefer an active approach or a descriptive approach.
The GM uses an NPC's personality and your character's actions and attitudes to determine how an NPC reacts. A cowardly bandit might buckle under threats of imprisonment. A stubborn merchant refuses to help if the characters badger her. A vain dragon laps up flattery.
When interacting with an NPC, pay attention to the GM's portrayal of the NPC's personality. You might be able to learn an NPC's goals and then use that information to influence the NPC.
If you offer NPCs something they want or play on their sympathies, fears, or goals, you can form friendships, ward off violence, or learn a key piece of information. On the other hand, if you insult a proud warrior or speak ill of a noble's allies, your efforts to convince or deceive will likely fail.
***
### Ability Checks
Ability checks can be key in determining the outcome of a social interaction. Your roleplaying efforts can alter an NPC's attitude, but there might still be an element of chance if the GM wants dice to play a role in determining an NPC's response to you. In such situations, the GM will typically ask you to take the Influence action.
Pay attention to your skill proficiencies when thinking of how you will interact with an NPC; use an approach that relies on your group's skill proficiencies. For example, if the group needs to trick a guard into letting them into a castle, the Rogue who is proficient in Deception should lead the discussion.

## Exploration
Exploration involves delving into places that are dangerous and full of mystery. The rules in this section detail some of the ways adventurers interact with the environment in such places.

### Adventuring Equipment
As adventurers explore, their equipment can help them in many ways. For example, they can reach out-of-the-way places with a Ladder, perceive things they wouldn't otherwise notice with a Torch or another light source, bypass locked doors and containers with Thieves' Tools, and create obstacles for pursuers with Caltrops.
See "Equipment” for rules on many items that are useful on adventures. The items in the "Tools" and "Adventuring Gear" sections are especially useful. The weapons in "Equipment" can also be used for more than battle; you could use a Quarterstaff, for example, to push a sinister-looking button that you're reluctant to touch.

## Vision and Light
Some adventuring tasks—such as noticing danger, hitting an enemy, and targeting certain spells—are affected by sight, so effects that obscure vision can hinder you, as explained below.

### Obscured Areas
An area might be Lightly or Heavily Obscured. In a Lightly Obscured area—such as an area with Dim Light, patchy fog, or moderate foliage—you have Disadvantage on Wisdom (Perception) checks that rely on sight.
A Heavily Obscured area—such as an area with Darkness, heavy fog, or dense foliage—is opaque. You have the Blinded condition (see "Rules Glossary") when trying to see something there.

### Light
The presence or absence of light determines the category of illumination in an area, as defined below.
**Bright Light.** Bright Light lets most creatures see normally. Even gloomy days provide Bright Light, as do torches, lanterns, fires, and other sources of illumination within a specific radius.
**Dim Light.** Dim Light, also called shadows, creates a Lightly Obscured area. An area of Dim Light is usually a boundary between Bright Light and surrounding Darkness. The soft light of twilight and dawn also counts as Dim Light. A full moon might bathe the land in Dim Light.
**Darkness.** Darkness creates a Heavily Obscured area. Characters face Darkness outdoors at night (even most moonlit nights), within the confines of an unlit dungeon, or in an area of magical Darkness.

### Special Senses
Some creatures have special senses that help them perceive things in certain situations. "Rules Glossary" defines the following special senses:

*   Blindsight
*   Darkvision
*   Tremorsense
*   Truesight

### Hiding
Adventurers and monsters often hide, whether to spy on one another, sneak past a guardian, or set an ambush. The Game Master decides when circumstances are appropriate for hiding. When you try to hide, you take the Hide action.

### Interacting with Objects
Interacting with objects is often simple to resolve. The player tells the GM that their character is doing something, such as moving a lever or opening a door, and the GM describes what happens. Sometimes, however, rules govern what you can do with an object, as detailed in the following sections.
***
### What Is an Object?
For the purpose of the rules, an object is a discrete, inanimate item like a window, door, sword, book, table, chair, or stone. It isn't a building or a vehicle, which are composed of many objects.

### Time-Limited Object Interactions
When time is short, such as in combat, interactions with objects are limited: one free interaction per turn. That interaction must occur during a creature's movement or action. Any additional interactions require the Utilize action, as explained in "Combat" later in "Playing the Game."

### Finding Hidden Objects
When your character searches for hidden things, such as a secret door or a trap, the GM typically asks you to make a Wisdom (Perception) check, provided you describe the character searching in the hidden object's vicinity. On a success, you find the object, other important details, or both.
If you describe your character searching nowhere near a hidden object, a Wisdom (Perception) check won't reveal the object, no matter the check's total.

### Carrying Objects
You can usually carry your gear and treasure without worrying about the weight of those objects. If you try to haul an unusually heavy object or a massive number of lighter objects, the GM might require you to abide by the rules for carrying capacity in "Rules Glossary."

### Breaking Objects
As an action, you can automatically break or otherwise destroy a fragile, nonmagical object, such as a glass container or a piece of paper. If you try to damage something more resilient, the GM might use the rules on breaking objects in "Rules Glossary."

> **MARCHING ORDER**
> The adventurers should establish a marching order while they travel, whether indoors or outdoors. A marching order makes it easier to determine which characters are affected by traps, which ones can spot hidden enemies, and which ones are the closest to those enemies if a fight breaks out. You can change your marching order outside combat and record the order any way you like: write it down, for example, or arrange miniatures to show it.

## Hazards
Monsters are the main perils characters face, but other dangers await. “Rules Glossary" defines the following hazards:

| | |
| :-- | :-- |
| Burning | Falling |
| Dehydration | Malnutrition |
| | Suffocation |

## Travel
During an adventure, the characters might travel long distances on trips that could take hours or days. The GM can summarize this travel without calculating exact distances or travel times, or the GM might have you use the travel pace rules below.
If you need to know how fast you can move when every second matters, see the movement rules in "Combat" later in "Playing the Game."

### Travel Pace
While traveling outside combat, a group can move at a Fast, Normal, or Slow pace, as shown on the Travel Pace table. The table states how far the party can move in a period of time; if riding horses or other mounts, the group can move twice that distance for 1 hour, after which the mounts need a Short or Long Rest before they can move at that increased pace again (see "Equipment" for a selection of mounts for sale). "Gameplay Toolbox" has rules that affect which pace you can choose in certain types of terrain.

**Travel Pace**
| Pace | Distance Traveled Per ... | | |
| :--- | :--- | :--- | :--- |
| | **Minute** | **Hour** | **Day** |
| Fast | 400 feet | 4 miles | 30 miles |
| Normal | 300 feet | 3 miles | 24 miles |
| Slow | 200 feet | 2 miles | 18 miles |

Each travel pace has a game effect, as defined below.
**Fast.** Traveling at a Fast pace imposes Disadvantage on a traveler's Wisdom (Perception or Survival) and Dexterity (Stealth) checks.
**Normal.** Traveling at a Normal pace imposes Disadvantage on Dexterity (Stealth) checks.
**Slow.** Traveling at a Slow pace grants Advantage on Wisdom (Perception or Survival) checks.

### Vehicles
Travelers in wagons, carriages, or other land vehicles choose a pace as normal. Characters in a waterborne vessel are limited to the speed of the vessel, and they don't choose a travel pace. Depending on the vessel and the size of the crew, ships might be able to travel for up to 24 hours per day. "Equipment" includes vehicles for sale.
***
# Combat
Adventurers encounter many dangerous monsters and nefarious villains. In those moments, combat often breaks out.

## The Order of Combat
A typical combat encounter is a clash between two sides: a flurry of weapon swings, feints, parries, footwork, and spellcasting. The game organizes combat into a cycle of rounds and turns. A round represents about 6 seconds in the game world. During a round, each participant in a battle takes a turn. The order of turns is determined at the beginning of combat when everyone rolls Initiative. Once everyone has taken a turn, the fight continues to the next round if neither side is defeated.

### Combat Step by Step
Combat unfolds in these steps:

**1: Establish Positions.** The Game Master determines where all the characters and monsters are located. Given the adventurers' marching order or their stated positions in the room or other location, the GM figures out where the adversaries are—how far away and in what direction.
**2: Roll Initiative.** Everyone involved in the combat encounter rolls Initiative, determining the order of combatants' turns.
**3: Take Turns.** Each participant in the battle takes a turn in Initiative order. When everyone involved in the combat has had a turn, the round ends. Repeat this step until the fighting stops.

### Initiative
Initiative determines the order of turns during combat. When combat starts, every participant rolls Initiative; they make a Dexterity check that determines their place in the Initiative order. The GM rolls for monsters. For a group of identical creatures, the GM makes a single roll, so each member of the group has the same Initiative.
**Surprise.** If a combatant is surprised by combat starting, that combatant has Disadvantage on their Initiative roll. For example, if an ambusher starts combat while hidden from a foe who is unaware that combat is starting, that foe is surprised.
**Initiative Order.** A combatant's check total is called their Initiative count, or Initiative for short. The GM ranks the combatants, from highest to lowest Initiative. This is the order in which they act during each round. The Initiative order remains the same from round to round.
**Ties.** If a tie occurs, the GM decides the order among tied monsters, and the players decide the order among tied characters. The GM decides the order if the tie is between a monster and a player character.

### Your Turn
On your turn, you can move a distance up to your Speed and take one action. You decide whether to move first or take your action first.
The main actions you can take are listed in "Actions" earlier in "Playing the Game.” A character's features and a monster's stat block also provide action options. "Movement and Position" later in "Playing the Game" gives the rules for movement.
**Communicating.** You can communicate however you are able—through brief utterances and gestures—as you take your turn. Doing so uses neither your action nor your move.
Extended communication, such as a detailed explanation of something or an attempt to persuade a foe, requires an action. The Influence action is the main way you try to influence a monster.
**Interacting with Things.** You can interact with one object or feature of the environment for free, during either your move or action. For example, you could open a door during your move as you stride toward a foe.
If you want to interact with a second object, you need to take the Utilize action. Some magic items and other special objects always require an action to use, as stated in their descriptions.

> **PLAYING ON A GRID**
> If you play using a square grid and miniatures or other tokens, follow these rules.
> **Squares.** Each square represents 5 feet.
> **Speed.** Rather than moving foot by foot, move square by square on the grid, using your Speed in 5-foot segments. You can translate your Speed into squares by dividing it by 5. For example, a Speed of 30 feet translates into 6 squares. If you use a grid often, consider writing your Speed in squares on your character sheet.
> **Entering a Square.** To enter a square, you must have enough movement left to pay for entering. It costs 1 square of movement to enter an unoccupied square that's adjacent to your space (orthogonally or diagonally adjacent). A square of Difficult Terrain costs 2 squares to enter. Other effects might make a square cost even more.
> **Corners.** Diagonal movement can't cross the corner of a wall, a large tree, or another terrain feature that fills its space.
> **Ranges.** To determine the range on a grid between two things—whether creatures or objects— count squares from a square adjacent to one of them and stop counting in the space of the other one. Count by the shortest route.

The GM might require you to use an action for any of these activities when it needs special care or when it presents an unusual obstacle. For instance, the GM might require you to take the Utilize action to open a stuck door or turn a crank to lower a drawbridge.
**Doing Nothing on Your Turn.** You can forgo moving, taking an action, or doing anything at all on your turn. If you can't decide what to do, consider taking the defensive Dodge action or the Ready action to delay acting.
***
### Ending Combat
Combat ends when one side or the other is defeated, which can mean the creatures are killed or knocked out or have surrendered or fled. Combat can also end when both sides agree to end it.

## Movement and Position
On your turn, you can move a distance equal to your Speed or less. Or you can decide not to move.
Your movement can include climbing, crawling, jumping, and swimming (each explained in "Rules Glossary"). These different modes of movement can be combined with your regular movement, or they can constitute your entire move.
However you're moving with your Speed, you deduct the distance of each part of your move from it until it is used up or until you are done moving, whichever comes first.
A character's Speed is determined during character creation. A monster's Speed is noted in the monster's stat block. See "Rules Glossary” for more about Speed as well as about special speeds, such as a Climb Speed, Fly Speed, or Swim Speed.

### Difficult Terrain
Combatants are often slowed down by Difficult Terrain. Low furniture, rubble, undergrowth, steep stairs, snow, and shallow bogs are examples of Difficult Terrain.
Every foot of movement in Difficult Terrain costs 1 extra foot, even if multiple things in a space count as Difficult Terrain.

### Breaking Up Your Move
You can break up your move, using some of its movement before and after any action, Bonus Action, or Reaction you take on the same turn. For example, if you have a Speed of 30 feet, you could go 10 feet, take an action, and then go 20 feet.

### Dropping Prone
On your turn, you can give yourself the Prone condition (see "Rules Glossary") without using an action or any of your Speed, but you can't do so if your Speed is 0.

## Creature Size
A creature belongs to a size category, which determines the width of the square space the creature occupies on a map, as shown on the Creature Size and Space table. That table lists the sizes from smallest (Tiny) to largest (Gargantuan). A creature's space is the area that it effectively controls in combat and the area it needs to fight effectively.
A character's size is determined by species, and a monster's size is specified in the monster's stat block.

**Creature Size and Space**
| Size | Space (Feet) | Space (Squares) |
| :--- | :--- | :--- |
| Tiny | 2½ by 2½ feet | 4 per square |
| Small | 5 by 5 feet | 1 square |
| Medium | 5 by 5 feet | 1 square |
| Large | 10 by 10 feet | 4 squares (2 by 2) |
| Huge | 15 by 15 feet | 9 squares (3 by 3) |
| Gargantuan | 20 by 20 feet | 16 squares (4 by 4) |

### Moving around Other Creatures
During your move, you can pass through the space of an ally, a creature that has the Incapacitated condition (see "Rules Glossary"), a Tiny creature, or a creature that is two sizes larger or smaller than you.
Another creature's space is Difficult Terrain for you unless that creature is Tiny or your ally.
You can't willingly end a move in a space occupied by another creature. If you somehow end a turn in a space with another creature, you have the Prone condition (see "Rules Glossary") unless you are Tiny or are of a larger size than the other creature.

## Making an Attack
When you take the Attack action, you make an attack. Some other actions, Bonus Actions, and Reactions also let you make an attack. Whether you strike with a Melee weapon, fire a Ranged weapon, or make an attack roll as part of a spell, an attack has the following structure:

> **UNSEEN ATTACKERS AND TARGETS**
> When you make an attack roll against a target you can't see, you have Disadvantage on the roll. This is true whether you're guessing the target's location or targeting a creature you can hear but not see. If the target isn't in the location you targeted, you miss.
> When a creature can't see you, you have Advantage on attack rolls against it.
> If you are hidden when you make an attack roll, you give away your location when the attack hits or misses.
***
**1: Choose a Target.** Pick a target within your attack's range: a creature, an object, or a location.
**2: Determine Modifiers.** The GM determines whether the target has Cover (see the next section) and whether you have Advantage or Disadvantage against the target. In addition, spells, special abilities, and other effects can apply penalties or bonuses to your attack roll.
**3: Resolve the Attack.** Make the attack roll, as detailed earlier in "Playing the Game." On a hit, you roll damage unless the particular attack has rules that specify otherwise. Some attacks cause special effects in addition to or instead of damage.

## Cover
Walls, trees, creatures, and other obstacles can provide cover, making a target more difficult to harm. As detailed in the Cover table, there are three degrees of cover, each of which gives a different benefit to a target.
A target can benefit from cover only when an attack or other effect originates on the opposite side of the cover. If a target is behind multiple sources of cover, only the most protective degree of cover applies; the degrees aren't added together. For example, if a target is behind a creature that gives Half Cover and a tree trunk that gives Three-Quarters Cover, the target has Three-Quarters Cover.

**Cover**
| Degree | Benefit to Target | Offered By ... |
| :--- | :--- | :--- |
| **Half** | +2 bonus to AC and Dexterity saving throws | Another creature or an object that covers at least half of the target |
| **Three-Quarters** | +5 bonus to AC and Dexterity saving throws | An object that covers at least three-quarters of the target |
| **Total** | Can't be targeted directly | An object that covers the whole target |

## Ranged Attacks
When you make a ranged attack, you fire a bow, hurl an axe, or otherwise send projectiles to strike a foe at a distance. Many spells also involve making a ranged attack.

### Range
You can make ranged attacks only against targets within a specified range. If a ranged attack, such as one made with a spell, has a single range, you can't attack a target beyond this range.
Some ranged attacks, such as those made with a Longbow, have two ranges. The smaller number is the normal range, and the larger number is the long range. Your attack roll has Disadvantage when your target is beyond normal range, and you can't attack a target beyond long range.

### Ranged Attacks in Close Combat
Aiming a ranged attack is more difficult when a foe is next to you. When you make a ranged attack roll with a weapon, a spell, or some other means, you have Disadvantage on the roll if you are within 5 feet of an enemy who can see you and doesn't have the Incapacitated condition (see "Rules Glossary").

## Melee Attacks
A melee attack allows you to attack a target within your reach. A melee attack typically uses a handheld weapon or an Unarmed Strike. Many monsters make melee attacks with claws, teeth, or other body parts. A few spells also involve melee attacks.

### Reach
A creature has a 5-foot reach and can thus attack targets within 5 feet when making a melee attack. Certain creatures have melee attacks with a reach greater than 5 feet, as noted in their descriptions.

## Opportunity Attacks
Combatants watch for enemies to drop their guard. If you move heedlessly past your foes, you put yourself in danger by provoking an Opportunity Attack.
**Avoiding Opportunity Attacks.** You can avoid provoking an Opportunity Attack by taking the Disengage action. You also don't provoke an Opportunity Attack when you Teleport or when you are moved without using your movement, action, Bonus Action, or Reaction. For example, you don't provoke an Opportunity Attack if an explosion hurls you out of a foe's reach or if you fall past an enemy.
**Making an Opportunity Attack.** You can make an Opportunity Attack when a creature that you can see leaves your reach. To make the attack, take a Reaction to make one melee attack with a weapon or an Unarmed Strike against that creature. The attack occurs right before it leaves your reach.

## Mounted Combat
A willing creature that is at least one size larger than a rider and that has an appropriate anatomy can serve as a mount, using the following rules.

### Mounting and Dismounting
During your move, you can mount a creature that is within 5 feet of you or dismount. Doing so costs an amount of movement equal to half your Speed (round down). For example, if your Speed is 30 feet, you spend 15 feet of movement to mount a horse.
***
### Controlling a Mount
You can control a mount only if it has been trained to accept a rider. Domesticated horses, mules, and similar creatures have such training.
The Initiative of a controlled mount changes to match yours when you mount it. It moves on your turn as you direct it, and it has only three action options during that turn: Dash, Disengage, and Dodge. A controlled mount can move and act even on the turn that you mount it.
In contrast, an independent mount—one that lets you ride but ignores your control—retains its place in the Initiative order and moves and acts as it likes.

### Falling Off
If an effect is about to move your mount against its will while you're on it, you must succeed on a DC 10 Dexterity saving throw or fall off, landing with the Prone condition (see "Rules Glossary") in an unoccupied space within 5 feet of the mount.
While mounted, you must make the same save if you're knocked Prone or the mount is.

## Underwater Combat
A fight underwater follows these rules.

### Impeded Weapons
When making a melee attack roll with a weapon underwater, a creature that lacks a Swim Speed has Disadvantage on the attack roll unless the weapon deals Piercing damage.
A ranged attack roll with a weapon underwater automatically misses a target beyond the weapon's normal range, and the attack roll has Disadvantage against a target within normal range.

### Fire Resistance
Anything underwater has Resistance to Fire damage (explained in “Damage and Healing").

## Damage and Healing
Injury and death are frequent threats, as detailed in the following rules.

### Hit Points
Hit Points represent durability and the will to live. Creatures with more Hit Points are more difficult to kill. Your Hit Point maximum is the number of Hit Points you have when uninjured. Your current Hit Points can be any number from that maximum down to 0, which is the lowest Hit Points can go.
Whenever you take damage, subtract it from your Hit Points. Hit Point loss has no effect on your capabilities until you reach 0 Hit Points.
If you have half your Hit Points or fewer, you're Bloodied, which has no game effect on its own but which might trigger other game effects.

> **RESTING**
> Adventurers can't spend every hour adventuring. They need rest. Any creature can take hour-long Short Rests in the midst of a day and an 8-hour Long Rest to end it. Regaining Hit Points is one of the main benefits of a rest. "Rules Glossary" provides the rules for Short and Long Rests.

### Damage Rolls
Each weapon, spell, and damaging monster ability specifies the damage it deals. You roll the damage dice, add any modifiers, and deal the damage to your target. If there's a penalty to the damage, it's possible to deal 0 damage but not negative damage.
When attacking with a weapon, you add your ability modifier—the same modifier used for the attack roll—to the damage roll. A spell tells you which dice to roll for damage and whether to add any modifiers. Unless a rule says otherwise, you don't add your ability modifier to a fixed damage amount that doesn't use a roll, such as the damage of a Blowgun. See "Equipment” for weapons' damage dice and "Spells" for spells' damage dice.

### Critical Hits
When you score a Critical Hit, you deal extra damage. Roll the attack's damage dice twice, add them together, and add any relevant modifiers as normal. For example, if you score a Critical Hit with a Dagger, roll 2d4 for the damage rather than 1d4, and add your relevant ability modifier. If the attack involves other damage dice, such as from the Rogue's Sneak Attack feature, you also roll those dice twice.

### Saving Throws and Damage
Damage dealt via saving throws uses these rules.

#### Damage against Multiple Targets
When you create a damaging effect that forces two or more targets to make saving throws against it at the same time, roll the damage once for all the targets. For example, when a wizard casts *Fireball*, the spell's damage is rolled once for all creatures caught in the blast.

#### Half Damage
Many saving throw effects deal half damage (round down) to a target when the target succeeds on the saving throw. The halved damage is equal to half the damage that would be dealt on a failed save.

### Damage Types
Each instance of damage has a type, like Fire or Slashing. Damage types are listed in "Rules Glossary" and have no rules of their own, but other rules, such as Resistance, rely on damage types.
***
### Resistance and Vulnerability
Some creatures and objects have Resistance or Vulnerability to certain damage types. If you have Resistance to a damage type, damage of that type is halved against you (round down). If you have Vulnerability to a damage type, damage of that type is doubled against you. For example, if you have Resistance to Cold damage, such damage is halved against you, and if you have Vulnerability to Fire damage, such damage is doubled against you.

#### No Stacking
Multiple instances of Resistance or Vulnerability that affect the same damage type count as only one instance. For example, if you have Resistance to Necrotic damage as well as Resistance to all damage, Necrotic damage is reduced by half against you.

#### Order of Application
Modifiers to damage are applied in the following order: adjustments such as bonuses, penalties, or multipliers are applied first; Resistance is applied second; and Vulnerability is applied third.
For example, a creature has Resistance to all damage and Vulnerability to Fire damage, and it's within a magical aura that reduces all damage by 5. If it takes 28 Fire damage, the damage is first reduced by 5 (to 23), then halved for the creature's Resistance (and rounded down to 11), then doubled for its Vulnerability (to 22).

### Immunity
Some creatures and objects have Immunity to certain damage types and conditions. Immunity to a damage type means you don't take damage of that type, and Immunity to a condition means you aren't affected by it.

### Healing
Hit Points can be restored by magic, such as the *Cure Wounds* spell or a *Potion of Healing*, or by a Short or Long Rest (see "Rules Glossary").
When you receive healing, add the restored Hit Points to your current Hit Points. Your Hit Points can't exceed your Hit Point maximum, so any Hit Points regained in excess of the maximum are lost. For example, if you receive 8 Hit Points of healing and have 14 Hit Points and a Hit Point maximum of 20, you regain 6 Hit Points, not 8.

> **KNOCKING OUT A CREATURE**
> When you would reduce a creature to 0 Hit Points with a melee attack, you can instead reduce the creature to 1 Hit Point and give it the Unconscious condition. It then starts a Short Rest, at the end of which that condition ends on it. The condition ends early if the creature regains any Hit Points or if someone takes an action to administer first aid to it, making a successful DC 10 Wisdom (Medicine) check.

## Dropping to 0 Hit Points
When a creature drops to 0 Hit Points, it either dies outright or falls unconscious, as explained below.

### Instant Death
Here are the main ways a creature can die instantly.
**Monster Death.** A monster dies the instant it drops to 0 Hit Points, although a Game Master can ignore this rule for an individual monster and treat it like a character.
**Hit Point Maximum of 0.** A creature dies if its Hit Point maximum reaches 0. Certain effects drain life energy, reducing a creature's Hit Point maximum.
**Massive Damage.** When damage reduces a character to 0 Hit Points and damage remains, the character dies if the remainder equals or exceeds their Hit Point maximum. For example, if your character has a Hit Point maximum of 12, currently has 6 Hit Points, and takes 18 damage, the character drops to 0 Hit Points, but 12 damage remains. The character then dies, since 12 equals their Hit Point maximum.

### Character Demise
If your character dies, others might find a magical way to revive your character, such as with the *Raise Dead* spell. Or talk with the GM about making a new character to join the group. "Rules Glossary" has more information on being dead.

### Falling Unconscious
If you reach 0 Hit Points and don't die instantly, you have the Unconscious condition (see "Rules Glossary") until you regain any Hit Points, and you now face making Death Saving Throws (see below).

### Death Saving Throws
Whenever you start your turn with 0 Hit Points, you must make a Death Saving Throw to determine whether you creep closer to death or hang on to life. Unlike other saving throws, this one isn't tied to an ability score. You're in the hands of fate now.
**Three Successes/Failures.** Roll 1d20. If the roll is 10 or higher, you succeed. Otherwise, you fail. A success or failure has no effect by itself. On your third success, you become Stable (see "Stabilizing a Character" below). On your third failure, you die.
The successes and failures don't need to be consecutive; keep track of both until you collect three of a kind. The number of both is reset to zero when you regain any Hit Points or become Stable.
***
**Rolling a 1 or 20.** When you roll a 1 on the d20 for a Death Saving Throw, you suffer two failures. If you roll a 20 on the d20, you regain 1 Hit Point.
**Damage at 0 Hit Points.** If you take any damage while you have 0 Hit Points, you suffer a Death Saving Throw failure. If the damage is from a Critical Hit, you suffer two failures instead. If the damage equals or exceeds your Hit Point maximum, you die.

### Stabilizing a Character
You can take the Help action to try to stabilize a creature with 0 Hit Points, which requires a successful DC 10 Wisdom (Medicine) check.
A Stable creature doesn't make Death Saving Throws even though it has 0 Hit Points, but it still has the Unconscious condition. If the creature takes damage, it stops being Stable and starts making Death Saving Throws again. A Stable creature that isn't healed regains 1 Hit Point after 1d4 hours.

## Temporary Hit Points
Some spells and other effects confer Temporary Hit Points, which are a buffer against losing actual Hit Points, as explained below.

### Lose Temporary Hit Points First
If you have Temporary Hit Points and take damage, those points are lost first, and any leftover damage carries over to your Hit Points. For example, if you have 5 Temporary Hit Points and take 7 damage, you lose those points and then lose 2 Hit Points.

### Duration
Temporary Hit Points last until they're depleted or you finish a Long Rest (see "Rules Glossary").

### They Don't Stack
Temporary Hit Points can't be added together. If you have Temporary Hit Points and receive more of them, you decide whether to keep the ones you have or to gain the new ones. For example, if a spell grants you 12 Temporary Hit Points when you already have 10, you can have 12 or 10, not 22.

### They're Not Hit Points or Healing
Temporary Hit Points can't be added to your Hit Points, healing can't restore them, and receiving Temporary Hit Points doesn't count as healing. Because Temporary Hit Points aren't Hit Points, a creature can be at full Hit Points and receive Temporary Hit Points.
If you have 0 Hit Points, receiving Temporary Hit Points doesn't restore you to consciousness. Only true healing can save you.