19

# Character Creation

## Choose a Character Sheet
You'll record the main details of your character on a character sheet. Throughout this chapter, we use the term "character sheet" to mean whatever you use to track your character's details, whether it's a printed character sheet, a digital character sheet, or plain paper. Choose whichever style of sheet works for you, and then embark on creating a character!

## Create Your Character
Here are the steps to make a character; each step is explored in detail:

1.  **Choose a Class.** Every adventurer is a member of a class. A class broadly describes a character's vocation, special talents, and favored tactics.
2.  **Determine Origin.** A character's origin includes two elements: background and species. How did the character spend the years leading up to a life of adventure? Who are the character's ancestors? You can also choose your character's languages.
3.  **Determine Ability Scores.** Much of what your character does in the game depends on the character's six abilities.
4.  **Choose an Alignment.** Alignment is a shorthand for your character's moral compass.
5.  **Fill in Details.** Using the choices you've made, fill in the remaining details on your character sheet.

## Step 1: Choose Class
Choose a class, and write it on your character sheet. The Class Overview table summarizes the classes. See "Classes" for the classes' details.

### Class Overview
| Class | Likes ... | Primary Ability | Complexity |
| :--- | :--- | :--- | :--- |
| Barbarian | Battle | Strength | Average |
| Bard | Performing | Charisma | High |
| Cleric | Gods | Wisdom | Average |
| Druid | Nature | Wisdom | High |
| Fighter | Weapons | Strength or Dexterity | Low |
| Monk | Unarmed combat | Dexterity and Wisdom | High |
| Paladin | Defense | Strength and Charisma | Average |
| Ranger | Survival | Dexterity and Wisdom | Average |
| Rogue | Stealth | Dexterity | Low |
| Sorcerer | Power | Charisma | High |
| Warlock | Occult lore | Charisma | High |
| Wizard | Spellbooks | Intelligence | Average |

### Write Your Level
Write your character's level on your character sheet. Typically, a character starts at level 1 and advances in level by adventuring and gaining Experience Points (XP).

**Write Your XP.** Also record your Experience Points. A level 1 character has 0 XP.

**Starting at a Higher Level.** Your GM might start you at a higher level. If you start at level 3 or higher, write your chosen subclass on your character sheet. See the "Starting at Higher Levels" section later in "Character Creation" for more information.

### Note Armor Training
Your class might give you training with certain categories of armor. Note your armor training on your character sheet. Armor training with a kind of armor means you can wear that armor effectively, gaining defensive bonuses from it. The categories of armor are described in "Equipment."

## Step 2: Character Origin
Determining your character's origin involves choosing a background, a species, and two languages.

A character's background represents the place and occupation that were most formative for the character. The combination of background, species, and languages provides fertile soil for your imagination as you ponder your character's earliest days.

### Choose a Background
Choose your character's background, and write it on your character sheet. You can choose any of the backgrounds detailed in "Character Origins," and your GM might offer additional backgrounds as options.

The background you choose influences step 3, when you determine your character's ability scores. If you're having trouble choosing, the Ability Scores and Backgrounds table shows which backgrounds benefit which ability scores. Look for your class's primary ability there.

### Ability Scores and Backgrounds
| Ability | Background |
| :--- | :--- |
| **Strength** | Soldier |
| **Dexterity** | Soldier |
| **Constitution** | Soldier |
| **Intelligence** | Acolyte |
---
20

| Ability | Background |
| :--- | :--- |
| **Wisdom** | Acolyte |
| **Charisma** | Acolyte |

**Record Your Feat.** A background gives you a feat, which grants your character particular capabilities. Feats are detailed in "Feats." Write the feat on your character sheet.

**Note Proficiencies.** Your background gives proficiency in two skills and with one tool. Record this information on your character sheet.

Your class also gives proficiencies. Check your class description in "Classes" and note the proficiencies on your character sheet.

The features table in your class description shows your Proficiency Bonus (described in "Playing the Game"), which is +2 for a level 1 character. Note this number on your character sheet. You'll fill in other numbers connected to these proficiencies in step 5.

### Choose Starting Equipment
Your background and class both provide starting equipment. Any coins that you gain at this step can be immediately spent on equipment from "Equipment."

Record your chosen equipment on your character sheet. Equipment is described in "Equipment," but for now you can just write it all down and look up the specifics in "Equipment" later. Note any coins you have left after purchasing your equipment.

### Choose a Species
Choose a species for your character. The following species options are detailed in "Character Origins": Dragonborn, Dwarf, Elf, Gnome, Goliath, Halfling, Human, Orc, and Tiefling. Once you've chosen a species, write it on your character sheet. Then record your species' traits.

Your character's size and Speed are determined by the character's species; record these in the appropriate places on your character sheet as well (you may write just the first letter of your size).

### Imagine Your Past and Present
Let your character's background and species inspire how you imagine their past. That past fed into the character's present. With that in mind, consider answers to the following questions as your character:

*   Who raised you?
*   Who was your dearest childhood friend?
*   Did you grow up with a pet?
*   Have you fallen in love? If so, with whom?
*   Did you join an organization, such as a guild or religion? If so, are you still a member of it?
*   What elements of your past inspire you to go on adventures now?

### Choose Languages
Your character knows at least three languages: Common plus two languages you roll or choose from the Standard Languages table. Knowledge of a language means your character can communicate in it, read it, and write it. Your class and other features might also give you languages.

The Standard Languages table lists languages that are widespread in the setting. Every player character knows Common. The other standard languages originated with the first members of the most prominent species in the setting and have since spread widely.

#### Standard Languages
| 1d12 | Language |
| :--- | :--- |
| — | Common |
| 1 | Common Sign Language |
| 2 | Draconic |
| 3–4 | Dwarvish |
| 5–6 | Elvish |
| 7 | Giant |
| 8 | Gnomish |
| 9 | Goblin |
| 10–11 | Halfling |
| 12 | Orc |

The Rare Languages table lists languages that are either secret or derived from other planes of existence and thus less widespread in the worlds of the Material Plane. Some features let a character learn a rare language.

#### Rare Languages
| Language | Language |
| :--- | :--- |
| Abyssal | Primordial\* |
| Celestial | Sylvan |
| Deep Speech | Thieves' Cant |
| Druidic | Undercommon |
| Infernal | |

\*Primordial includes the Aquan, Auran, Ignan, and Terran dialects. Creatures that know one of these dialects can communicate with those that know a different one.

## Step 3: Ability Scores
To determine your character's ability scores, you first generate a set of six numbers using the instructions below and then assign them to your six abilities. "Playing the Game" explains what each ability means.
---
21

### Generate Your Scores
Determine your ability scores by using one of the following three methods. Your GM might prefer you to use a particular one.

**Standard Array.** Use the following six scores for your abilities: 15, 14, 13, 12, 10, 8.

**Random Generation.** Roll four d6s and record the total of the highest three dice. Do this five more times, so you have six numbers.

**Point Cost.** You have 27 points to spend on your ability scores. The cost of each score is shown on the Ability Score Point Costs table. For example, a score of 14 costs 7 of your 27 points.

#### Ability Score Point Costs
| Score | Cost | Score | Cost |
| :--- | :--- | :--- | :--- |
| 8 | 0 | 12 | 4 |
| 9 | 1 | 13 | 5 |
| 10 | 2 | 14 | 7 |
| 11 | 3 | 15 | 9 |

### Assign Ability Scores
Once you've generated six scores, assign them to Strength, Dexterity, Constitution, Intelligence, Wisdom, and Charisma, keeping in mind your class's primary ability. Fill in the ability modifiers as well.

If you're using the Standard Array option, consult the Standard Array by Class table for suggestions on where to assign scores for your character's class. The table puts the highest scores in a class's main abilities. If you used a different method to generate the scores, you may still use this table to guide where you place your highest and lowest scores.

#### Standard Array by Class
| Class | Str. | Dex. | Con. | Int. | Wis. | Cha. |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Barbarian | 15 | 13 | 14 | 10 | 12 | 8 |
| Bard | 8 | 14 | 12 | 13 | 10 | 15 |
| Cleric | 14 | 8 | 13 | 10 | 15 | 12 |
| Druid | 8 | 12 | 14 | 13 | 15 | 10 |
| Fighter | 15 | 14 | 13 | 8 | 10 | 12 |
| Monk | 12 | 15 | 13 | 10 | 14 | 8 |
| Paladin | 15 | 10 | 13 | 8 | 12 | 14 |
| Ranger | 12 | 15 | 13 | 8 | 14 | 10 |
| Rogue | 12 | 15 | 13 | 14 | 10 | 8 |
| Sorcerer | 10 | 13 | 14 | 8 | 12 | 15 |
| Warlock | 8 | 14 | 13 | 12 | 10 | 15 |
| Wizard | 8 | 12 | 13 | 15 | 14 | 10 |

### Adjust Ability Scores
After assigning your ability scores, adjust them according to your background. Your background lists three abilities; increase one of those scores by 2 and a different one by 1, or increase all three by 1. None of these increases can raise a score above 20.

Some players like to increase their class's primary ability, while others prefer to increase a low score.

### Determine Ability Modifiers
Finally, determine your ability modifiers using the Ability Scores and Modifiers table. Write the modifier next to each of your scores.

#### Ability Scores and Modifiers
| Score | Modifier | Score | Modifier |
| :--- | :--- | :--- | :--- |
| 3 | −4 | 12–13 | +1 |
| 4–5 | −3 | 14–15 | +2 |
| 6–7 | −2 | 16–17 | +3 |
| 8–9 | −1 | 18–19 | +4 |
| 10–11 | +0 | 20 | +5 |

## Step 4: Alignment
Choose your character's alignment from the options below, and note it on your character sheet.

The game assumes that player characters aren't of an evil alignment. Check with your GM before making an evil character.

### The Nine Alignments
A creature's alignment broadly describes its ethical attitudes and ideals. Alignment is a combination of two factors: one identifies morality (good, evil, or neutral), and the other describes attitudes toward order (lawful, chaotic, or neutral).

The summaries of the alignments below describe the typical behavior of a creature with that alignment; individuals can vary from that behavior.

**Lawful Good (LG).** Lawful Good creatures endeavor to do the right thing as expected by society. Someone who fights injustice and protects the innocent without hesitation is probably Lawful Good.

**Neutral Good (NG).** Neutral Good creatures do the best they can, working within rules but not feeling bound by them. A kindly person who helps others according to their needs is probably Neutral Good.

**Chaotic Good (CG).** Chaotic Good creatures act as their conscience directs with little regard for what others expect. A rebel who waylays a cruel baron's tax collectors and uses the stolen money to help the poor is probably Chaotic Good.

**Lawful Neutral (LN).** Lawful Neutral individuals act in accordance with law, tradition, or personal codes. Someone who follows a disciplined rule of life—and isn't swayed either by the demands of those in need or by the temptations of evil—is probably Lawful Neutral.

**Neutral (N).** Neutral is the alignment of those who prefer to avoid moral questions and don't take sides,
---
22

> **UNALIGNED CREATURES**
> Most creatures that lack the capacity for rational thought don't have alignments; they are unaligned. Sharks are savage predators, for example, but they aren't evil; they are unaligned.

doing what seems best at the time. Someone who's bored by moral debate is probably Neutral.

**Chaotic Neutral (CN).** Chaotic Neutral creatures follow their whims, valuing their personal freedom above all else. A scoundrel who wanders the land living by their wits is probably Chaotic Neutral.

**Lawful Evil (LE).** Lawful Evil creatures methodically take what they want within the limits of a code of tradition, loyalty, or order. An aristocrat exploiting citizens while scheming for power is probably Lawful Evil.

**Neutral Evil (NE).** Neutral Evil is the alignment of those who are untroubled by the harm they cause as they pursue their desires. A criminal who robs and murders as they please is probably Neutral Evil.

**Chaotic Evil (CE).** Chaotic Evil creatures act with arbitrary violence, spurred by their hatred or bloodlust. A villain pursuing schemes of vengeance and havoc is probably Chaotic Evil.

## Step 5: Character Creation Details
Now fill in the rest of your character sheet.

### Record Class Features
Look at your class's feature table in "Classes," and write down the level 1 features. The class features are detailed there too.

Some class features offer choices. Make sure to read all your features and make any offered choices.

### Fill In Numbers
Note these numbers on your character sheet.

**Saving Throws.** For the saving throws you have proficiency in, add your Proficiency Bonus to the appropriate ability modifier and note the total. Some players also like to note the modifier for saving throws they're not proficient in, which is just the relevant ability modifier.

**Skills.** For skills you have proficiency in, add your Proficiency Bonus to the ability modifier associated with that skill, and note the total. You might also wish to note the modifier for skills you're not proficient in, which is just the relevant ability modifier.

**Passive Perception.** Sometimes your GM will determine whether your character notices something without asking you to make a Wisdom (Perception) check; the GM uses your Passive Perception instead. Passive Perception is a score that reflects a general awareness of your surroundings when you're not actively looking for something. Use this formula to determine your Passive Perception score:

> Passive Perception = 10 + Wisdom (Perception) check modifier

Include all modifiers that apply to your Wisdom (Perception) checks. For example, if your character has a Wisdom of 15 and proficiency in the Perception skill, you have a Passive Perception of 14 (10 + 2 for your Wisdom modifier + 2 for proficiency).

**Hit Points.** Your class and Constitution modifier determine your Hit Point maximum at level 1, as shown on the Level 1 Hit Points by Class table.

#### Level 1 Hit Points by Class
| Class | Hit Point Maximum |
| :--- | :--- |
| Barbarian | 12 + Con. modifier |
| Fighter, Paladin, or Ranger | 10 + Con. modifier |
| Bard, Cleric, Druid, Monk, Rogue, or Warlock | 8 + Con. modifier |
| Sorcerer or Wizard | 6 + Con. modifier |

The character sheet includes room to note your current Hit Points when you take damage, as well as any Temporary Hit Points you might gain. There's also space to track Death Saving Throws.

**Hit Point Dice.** Your class's description tells you the die type of your character's Hit Point Dice (or Hit Dice for short); write this on your character sheet. At level 1, your character has 1 Hit Die. You can spend Hit Dice during a Short Rest to recover Hit Points. Your character sheet also includes space to note how many Hit Dice you've spent.

**Initiative.** Write your Dexterity modifier in the space for Initiative on your character sheet.

**Armor Class.** Without armor or a shield, your base Armor Class is 10 plus your Dexterity modifier. If your starting equipment includes armor or a Shield (or both), calculate your AC using the rules in "Equipment." A class feature might give you a different way to calculate your AC.

**Attacks.** In the Weapons & Damage Cantrips section of the character sheet, write your starting weapons. The attack roll bonus for a weapon with which you have proficiency is one of the following unless a weapon's property says otherwise:

> Melee attack bonus = Strength modifier + Proficiency Bonus
>
> Ranged attack bonus = Dexterity modifier + Proficiency Bonus

Look up the damage and properties of your weapons in "Equipment.” You add the same ability modifier you use for attacks with a weapon to your damage rolls with that weapon.

**Spellcasting.** Note both the saving throw DC for your spells and the attack bonus for attacks you make with them, using these formulas:
---
> Spell save DC = 8 + spellcasting ability modifier + Proficiency Bonus
>
> Spell attack bonus = spellcasting ability modifier + Proficiency Bonus

Your spellcasting ability modifier for a spell is determined by whatever feature gives you the ability to cast the spell.

**Spell Slots, Cantrips, and Prepared Spells.** If your class gives you the Spellcasting or Pact Magic feature, your class features table shows the number of spell slots you have available, how many cantrips you know, and how many spells you can prepare. Choose your cantrips and prepared spells, and note them—along with your number of spell slots—on your character sheet.

## Level Advancement
While going on adventures, your character gains experience, represented by Experience Points (XP). A character who reaches a specified Experience Point total advances in capability. This advancement is called gaining a level.

The Character Advancement table lists the XP you need to advance to a level and the Proficiency Bonus for a character of that level. When your XP total equals or exceeds a number in the Experience Points column, you reach the corresponding level.

### Character Advancement
| Level | Experience Points | Proficiency Bonus |
| :--- | :--- | :--- |
| 1 | 0 | +2 |
| 2 | 300 | +2 |
| 3 | 900 | +2 |
| 4 | 2,700 | +2 |
| 5 | 6,500 | +3 |
| 6 | 14,000 | +3 |
| 7 | 23,000 | +3 |
| 8 | 34,000 | +3 |
| 9 | 48,000 | +4 |
| 10 | 64,000 | +4 |
| 11 | 85,000 | +4 |
| 12 | 100,000 | +4 |
| 13 | 120,000 | +5 |
| 14 | 140,000 | +5 |
| 15 | 165,000 | +5 |
| 16 | 195,000 | +5 |
| 17 | 225,000 | +6 |
| 18 | 265,000 | +6 |
| 19 | 305,000 | +6 |
| 20 | 355,000 | +6 |

## Gaining a Level
When you gain a level, follow these steps:

1.  **Choose a Class.** Most characters advance in the same class. However, you might decide to gain a level in another class using the rules in the "Multiclassing" section.
2.  **Adjust Hit Points and Hit Point Dice.** Each time you gain a level, you gain an additional Hit Die. Roll that die, add your Constitution modifier to the roll, and add the total (minimum of 1) to your Hit Point maximum. Instead of rolling, you can use the fixed value shown in the Fixed Hit Points by Class table.

### Fixed Hit Points by Class
| Class | Hit Points per Level |
| :--- | :--- |
| Barbarian | 7 + Con. modifier |
| Fighter, Paladin, or Ranger | 6 + Con. modifier |
| Bard, Cleric, Druid, Monk, Rogue, or Warlock | 5 + Con. modifier |
| Sorcerer or Wizard | 4 + Con. modifier |

3.  **Record New Class Features.** Look at your class features table in "Classes," and note the features you gain at your new level in that class. Make any choices offered by a new feature.
4.  **Adjust Proficiency Bonus.** A character's Proficiency Bonus increases at certain levels, as shown in the Character Advancement table and your class features table in “Classes.” When your Proficiency Bonus increases, increase all the numbers on your character sheet that include your Proficiency Bonus.
5.  **Adjust Ability Modifiers.** If you choose a feat that increases one or more of your ability scores, your ability modifier also changes if the new score is an even number. When that happens, adjust all the numbers on your character sheet that use that ability modifier. When your Constitution modifier increases by 1, your Hit Point maximum increases by 1 for each level you have attained. For example, if a character reaches level 8 and increases their Constitution score from 17 to 18, the Constitution modifier increases to +4. The character's Hit Point maximum then increases by 8, in addition to the Hit Points gained for reaching level 8.

## Tiers of Play
With each new level, characters acquire new capabilities that equip them to handle greater challenges. As characters advance in level, the tone of the game also changes, and the stakes of the campaign get higher. It's helpful to think of a character's (and a campaign's) arc in terms of four tiers of play,
---
24
describing the journey from a level 1 character just beginning an adventuring career to the epic heights of level 20. These tiers don't have any rules associated with them; they point to the fact that the play experience evolves as characters gain levels.

### Tier 1 (Levels 1–4)
In tier 1, characters are apprentice adventurers, though they are already set apart from the broader populace by virtue of their extraordinary abilities. They learn their starting class features and choose a subclass. The threats they face usually pose a danger to local farmsteads or villages.

### Tier 2 (Levels 5–10)
In tier 2, characters are full-fledged adventurers. Spellcasters gain iconic spells such as *Fireball*, *Lightning Bolt*, and *Raise Dead*. Most weapon-focused classes gain the ability to make multiple attacks in a round. The characters now face dangers that threaten cities and kingdoms.

### Tier 3 (Levels 11–16)
In tier 3, characters have reached a level of power that makes them special among adventurers. At level 11, many spellcasters learn reality-altering spells. Other characters gain features that allow them to make more attacks or to do more impressive things with those attacks. These adventurers often confront threats to whole regions.

### Tier 4 (Levels 17–20)
At tier 4, characters achieve the pinnacle of their class features, becoming heroic archetypes. The fate of the world or even the order of the multiverse might hang in the balance during their adventures.

## Starting at Higher Levels
Your GM might start your group's characters at a level higher than 1. It is particularly recommended to start at level 3 if your group is composed of seasoned D&D players.

### Creating Your Character
Creating a higher-level character uses the same character-creation steps outlined in this chapter and the rules for advancing beyond level 1 provided

> **BONUS FEATS AT LEVEL 20**
> A GM can use feats as a form of advancement after characters reach level 20 to provide greater power to characters who have no more levels to gain. With this approach, each character gains one feat of their choice for every 30,000 XP the character earns above 355,000 XP. Epic Boon feats are especially appropriate for these bonus feats, but a player can choose any feat for which their level 20 character qualifies.

in the "Level Advancement" section. You begin with the minimum amount of XP required to reach your starting level. For example, if the GM starts you at level 10, you have 64,000 XP.

### Starting Equipment
The GM decides whether your character starts with more than the standard equipment for a level 1 character, possibly even one or more magic items. The Starting Equipment at Higher Levels table is a guide for the GM.

Also, check with your GM about what equipment is available for you to buy with your starting money. For example, the firearms described in “Equipment" are too expensive for level 1 characters, but they might be available for purchase if your GM allows them.

## Multiclassing
Multiclassing allows you to gain levels in multiple classes. With this rule, you have the option of gaining a level in a new class whenever you advance in level instead of gaining a level in your current class. Doing so lets you mix the abilities of those classes to realize a character concept that might not be reflected in a single class.

### Prerequisites
To qualify for a new class, you must have a score of at least 13 in the primary ability of the new class and your current classes. For example, a Barbarian who decides to multiclass into the Druid class must have Strength and Wisdom scores of 13 or higher,

#### Starting Equipment at Higher Levels
| Starting Level | Equipment and Money | Magic Items |
| :--- | :--- | :--- |
| 2–4 | Normal starting equipment | 1 Common |
| 5–10 | 500 GP plus 1d10 × 25 GP plus normal starting equipment | 1 Common, 1 Uncommon |
| 11–16 | 5,000 GP plus 1d10 × 250 GP plus normal starting equipment | 2 Common, 3 Uncommon, 1 Rare |
| 17–20 | 20,000 GP plus 1d10 × 250 GP plus normal starting equipment | 2 Common, 4 Uncommon, 3 Rare, 1 Very Rare |
---
25
since Strength is the primary ability for Barbarians and Wisdom is the primary ability for Druids.

### Experience Points
The Experience Point cost to gain a level is based on your total character level, not your level in a particular class, as shown in the Character Advancement table in "Character Creation." For example, if you are a level 6 Cleric / level 1 Fighter, you must gain enough XP to reach level 8 before you can take your second level as a Fighter or your seventh level as a Cleric.

### Hit Points and Hit Point Dice
You gain the Hit Points from your new class as described for levels after 1. You gain the level 1 Hit Points for a class only when your total character level is 1.

Add together the Hit Dice granted by all your classes to form your pool of Hit Dice. If these dice are the same die type, you can pool them together. For example, both the Fighter and the Paladin have a d10 Hit Die, so if you are a level 5 Fighter / level 5 Paladin, you have ten d10 Hit Dice. If your classes give you Hit Dice of different types, track them separately. If you are a level 5 Cleric / level 5 Paladin, for example, you have five d8 Hit Dice and five d10 Hit Dice.

### Proficiency Bonus
Your Proficiency Bonus is based on your total character level, not your level in a particular class, as shown in the Character Advancement table. For example, if you are a level 3 Fighter / level 2 Rogue, you have the Proficiency Bonus of a level 5 character, which is +3.

### Proficiencies
When you gain your first level in a class other than your initial class, you gain only some of the new class's starting proficiencies, as detailed in each class's description in "Classes."

### Class Features
When you gain a new level in a class, you get its features for that level. A few features have additional rules when you're multiclassing. Check the information about multiclassing included in each of your classes' descriptions.

Special rules apply to Extra Attack, Spellcasting, and features (such as Unarmored Defense) that give you alternative ways to calculate your Armor Class.

**Armor Class**
If you have multiple ways to calculate your Armor Class, you can benefit from only one at a time. For example, a Monk/Sorcerer with a Monk's Unarmored Defense feature and a Sorcerer's Draconic Resilience feature must choose only one of those features as a way to calculate Armor Class.

**Extra Attack**
If you gain the Extra Attack feature from more than one class, the features don't stack. You can't make more than two attacks with this feature unless you have a feature that says you can (such as the Fighter's Two Extra Attacks feature).

Similarly, the Warlock's Thirsting Blade invocation, which grants you the Extra Attack feature with your pact weapon, doesn't give you additional attacks if you also have Extra Attack.

**Spellcasting**
Your capacity for spellcasting depends partly on your combined levels in all your spellcasting classes and partly on your individual levels in those classes. Once you have the Spellcasting feature from more than one class, use the rules below. If you multiclass but have the Spellcasting feature from only one class, follow the rules for that class.

**Spells Prepared.** You determine what spells you can prepare for each class individually, as if you were a single-classed member of that class. If you are a level 4 Ranger / level 3 Sorcerer, for example, you can prepare five level 1 Ranger spells, and you can prepare six Sorcerer spells of level 1 or 2 (as well as four Sorcerer cantrips).

Each spell you prepare is associated with one of your classes, and you use the spellcasting ability of that class when you cast the spell.

**Cantrips.** If a cantrip of yours increases in power at higher levels, the increase is based on your total character level, not your level in a particular class, unless the spell says otherwise.

**Spell Slots.** You determine your available spell slots by adding together the following:

*   All your levels in the Bard, Cleric, Druid, Sorcerer, and Wizard classes
*   Half your levels (round up) in the Paladin and Ranger classes

Then look up this total level in the Level column of the Multiclass Spellcaster table. You use the slots for that level to cast spells of an appropriate level from any class whose Spellcasting feature you have.

This table might give you spell slots of a higher level than the spells you prepare. You can use those slots but only to cast your lower-level spells. If a lower-level spell that you cast, like *Burning Hands*, has an enhanced effect when cast at a higher level, you can use the enhanced effect as normal.

For example, if you are a level 4 Ranger / level 3 Sorcerer, you count as a level 5 character when determining your spell slots, counting all your levels as a Sorcerer and half your Ranger levels. As shown
---
26
in the Multiclass Spellcaster table, you have four level 1 spell slots, three level 2 slots, and two level 3 slots. However, you can't prepare any level 3 spells, nor can you prepare any level 2 Ranger spells. You can use the spell slots of those levels to cast the spells you do prepare—and potentially enhance their effects.

**Pact Magic.** If you have the Pact Magic feature from the Warlock class and the Spellcasting feature, you can use the spell slots you gain from Pact Magic to cast spells you have prepared from classes with the Spellcasting feature, and you can use the spell slots you gain from the Spellcasting feature to cast Warlock spells you have prepared.

#### Multiclass Spellcaster: Spell Slots per Spell Level
| Level | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| 1 | 2 | — | — | — | — | — | — | — | — |
| 2 | 3 | — | — | — | — | — | — | — | — |
| 3 | 4 | 2 | — | — | — | — | — | — | — |
| 4 | 4 | 3 | — | — | — | — | — | — | — |
| 5 | 4 | 3 | 2 | — | — | — | — | — | — |
| 6 | 4 | 3 | 3 | — | — | — | — | — | — |
| 7 | 4 | 3 | 3 | 1 | — | — | — | — | — |
| 8 | 4 | 3 | 3 | 2 | — | — | — | — | — |
| 9 | 4 | 3 | 3 | 3 | 1 | — | — | — | — |
| 10 | 4 | 3 | 3 | 3 | 2 | — | — | — | — |
| 11 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 12 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 13 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 14 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 15 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 16 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | 1 |
| 18 | 4 | 3 | 3 | 3 | 3 | 1 | 1 | 1 | 1 |
| 19 | 4 | 3 | 3 | 3 | 3 | 2 | 1 | 1 | 1 |
| 20 | 4 | 3 | 3 | 3 | 3 | 2 | 2 | 1 | 1 |

## Trinkets
When you make your character, you can roll once on the Trinkets table to gain a Tiny trinket, a simple item lightly touched by mystery. The GM might also use this table. It can help stock a room in a dungeon or fill a creature's pockets.

| 1d100 | Trinket |
| :--- | :--- |
| 01 | A mummified goblin hand |
| 02 | A crystal that faintly glows in moonlight |
| 03 | A gold coin minted in an unknown land |
| 04 | A diary written in a language you don't know |
| 05 | A brass ring that never tarnishes |
| 06 | An old chess piece made from glass |
| 07 | A pair of knucklebone dice, each with a skull symbol on the side that would normally show six pips |
| 08 | A small idol depicting a nightmarish creature that gives you unsettling dreams when you sleep near it |
| 09 | A lock of someone's hair |
| 10 | The deed for a parcel of land in a realm unknown to you |
| 11 | A 1-ounce block made from an unknown material |
| 12 | A small cloth doll skewered with needles |
| 13 | A tooth from an unknown beast |
| 14 | An enormous scale, perhaps from a dragon |
| 15 | A bright-green feather |
| 16 | An old divination card bearing your likeness |
| 17 | A glass orb filled with moving smoke |
| 18 | A 1-pound egg with a bright-red shell |
| 19 | A pipe that blows bubbles |
| 20 | A glass jar containing a bit of flesh floating in pickling fluid |
| 21 | A gnome-crafted music box that plays a song you dimly remember from your childhood |
| 22 | A wooden statuette of a smug halfling |
| 23 | A brass orb etched with strange runes |
| 24 | A multicolored stone disk |
| 25 | A silver icon of a raven |
| 26 | A bag containing forty-seven teeth, one of which is rotten |
| 27 | A shard of obsidian that always feels warm to the touch |
| 28 | A dragon's talon strung on a leather necklace |
| 29 | A pair of old socks |
| 30 | A blank book whose pages refuse to hold ink, chalk, graphite, or any other marking |
| 31 | A silver badge that is a five-pointed star |
| 32 | A knife that belonged to a relative |
| 33 | A glass vial filled with nail clippings |
| 34 | A rectangular metal device with two tiny metal cups on one end that throws sparks when wet |
---
27

| 1d100 | Trinket |
| :--- | :--- |
| 35 | A white, sequined glove sized for a human |
| 36 | A vest with one hundred tiny pockets |
| 37 | A weightless stone |
| 38 | A sketch of a goblin |
| 39 | An empty glass vial that smells of perfume |
| 40 | A gemstone that looks like a lump of coal when examined by anyone but you |
| 41 | A scrap of cloth from an old banner |
| 42 | A rank insignia from a lost legionnaire |
| 43 | A silver bell without a clapper |
| 44 | A mechanical canary inside a lamp |
| 45 | A miniature chest carved to look like it has numerous feet on the bottom |
| 46 | A dead sprite inside a clear glass bottle |
| 47 | A metal can that has no opening but sounds as if it is filled with liquid, sand, spiders, or broken glass (your choice) |
| 48 | A glass orb filled with water, in which swims a clockwork goldfish |
| 49 | A silver spoon with an M engraved on the handle |
| 50 | A whistle made from gold-colored wood |
| 51 | A dead scarab beetle the size of your hand |
| 52 | Two toy soldiers, one missing a head |
| 53 | A small box filled with different-sized buttons |
| 54 | A candle that can't be lit |
| 55 | A miniature cage with no door |
| 56 | An old key |
| 57 | An indecipherable treasure map |
| 58 | A hilt from a broken sword |
| 59 | A rabbit's foot |
| 60 | A glass eye |
| 61 | A cameo of a hideous person |
| 62 | A silver skull the size of a coin |
| 63 | An alabaster mask |
| 64 | A cone of sticky black incense that stinks |
| 65 | A nightcap that gives you pleasant dreams when you wear it |
| 66 | A single caltrop made from bone |
| 67 | A gold monocle frame without the lens |
| 68 | A 1-inch cube, each side a different color |
| 69 | A crystal doorknob |
| 70 | A packet filled with pink dust |
| 71 | A fragment of a beautiful song, written as musical notes on two pieces of parchment |
| 72 | A silver teardrop earring containing a real teardrop |
| 73 | An eggshell painted with scenes of misery in disturbing detail |
| 74 | A fan that, when unfolded, shows a sleepy cat |
| 75 | A set of bone pipes |
| 76 | A four-leaf clover pressed inside a book discussing manners and etiquette |
| 77 | A sheet of parchment upon which is drawn a mechanical contraption |
| 78 | An ornate scabbard that fits no blade you have found |
| 79 | An invitation to a party where a murder happened |
| 80 | A bronze pentacle with an etching of a rat's head in its center |
| 81 | A purple handkerchief embroidered with the name of an archmage |
| 82 | Half a floor plan for a temple, a castle, or another structure |
| 83 | A bit of folded cloth that, when unfolded, turns into a stylish cap |
| 84 | A receipt of deposit at a bank in a far-off city |
| 85 | A diary with seven missing pages |
| 86 | An empty silver snuffbox bearing the inscription "dreams" on its lid |
| 87 | An iron holy symbol devoted to an unknown god |
| 88 | A book about a legendary hero's rise and fall, with the last chapter missing |
| 89 | A vial of dragon blood |
| 90 | An ancient arrow of elven design |
| 91 | A needle that never bends |
| 92 | An ornate brooch of dwarven design |
| 93 | An empty wine bottle bearing a pretty label that says, "The Wizard of Wines Winery, Red Dragon Crush, 331422-W" |
| 94 | A mosaic tile with a multicolored, glazed surface |
| 95 | A petrified mouse |
| 96 | A black pirate flag adorned with a dragon's skull and crossbones |
| 97 | A tiny mechanical crab or spider that moves about when it's not being observed |
| 98 | A glass jar containing lard with a label that reads, "Griffon Grease" |
| 99 | A wooden box with a ceramic bottom that holds a living worm with a head on each end of its body |
| 00 | A metal urn containing the ashes of a hero |
---
28

# Classes
## Barbarian

> **Core Barbarian Traits**
> **Primary Ability**
> Strength
>
> **Hit Point Die**
> D12 per Barbarian level
>
> **Saving Throw Proficiencies**
> Strength and Constitution
>
> **Skill Proficiencies**
> Choose 2: Animal Handling, Athletics, Intimidation, Nature, Perception, or Survival
>
> **Weapon Proficiencies**
> Simple and Martial weapons
>
> **Armor Training**
> Light and Medium armor and Shields
>
> **Starting Equipment**
> Choose A or B: (A) Greataxe, 4 Handaxes, Explorer's Pack, and 15 GP; or (B) 75 GP

### Becoming a Barbarian ...
**As a Level 1 Character**
*   Gain all the traits in the Core Barbarian Traits table.
*   Gain the Barbarian's level 1 features, which are listed in the Barbarian Features table.

**As a Multiclass Character**
*   Gain the following traits from the Core Barbarian Traits table: Hit Point Die, proficiency with Martial weapons, and training with Shields.
*   Gain the Barbarian's level 1 features, which are listed in the Barbarian Features table.

### Barbarian Class Features
As a Barbarian, you gain the following class features when you reach the specified Barbarian levels. These features are listed in the Barbarian Features table.

#### Level 1: Rage
You can imbue yourself with a primal power called Rage, a force that grants you extraordinary might and resilience. You can enter it as a Bonus Action if you aren't wearing Heavy armor.

You can enter your Rage the number of times shown for your Barbarian level in the Rages column of the Barbarian Features table. You regain one expended use when you finish a Short Rest, and you regain all expended uses when you finish a Long Rest.

#### Barbarian Features
| Level | Proficiency Bonus | Class Features | Rages | Rage Damage | Weapon Mastery |
| :--- | :--- | :--- | :--- | :--- | :--- |
| 1 | +2 | Rage, Unarmored Defense, Weapon Mastery | 2 | +2 | 2 |
| 2 | +2 | Danger Sense, Reckless Attack | 2 | +2 | 2 |
| 3 | +2 | Barbarian Subclass, Primal Knowledge | 3 | +2 | 2 |
| 4 | +2 | Ability Score Improvement | 3 | +2 | 3 |
| 5 | +3 | Extra Attack, Fast Movement | 3 | +2 | 3 |
| 6 | +3 | Subclass feature | 4 | +2 | 3 |
| 7 | +3 | Feral Instinct, Instinctive Pounce | 4 | +2 | 3 |
| 8 | +3 | Ability Score Improvement | 4 | +2 | 3 |
| 9 | +4 | Brutal Strike | 4 | +3 | 3 |
| 10 | +4 | Subclass feature | 4 | +3 | 4 |
| 11 | +4 | Relentless Rage | 4 | +3 | 4 |
| 12 | +4 | Ability Score Improvement | 5 | +3 | 4 |
| 13 | +5 | Improved Brutal Strike | 5 | +3 | 4 |
| 14 | +5 | Subclass feature | 5 | +3 | 4 |
| 15 | +5 | Persistent Rage | 5 | +3 | 4 |
| 16 | +5 | Ability Score Improvement | 5 | +4 | 4 |
| 17 | +6 | Improved Brutal Strike | 6 | +4 | 4 |
| 18 | +6 | Indomitable Might | 6 | +4 | 4 |
| 19 | +6 | Epic Boon | 6 | +4 | 4 |
| 20 | +6 | Primal Champion | 6 | +4 | 4 |
---
29
While active, your Rage follows the rules below.

**Damage Resistance.** You have Resistance to Bludgeoning, Piercing, and Slashing damage.

**Rage Damage.** When you make an attack using Strength—with either a weapon or an Unarmed Strike—and deal damage to the target, you gain a bonus to the damage that increases as you gain levels as a Barbarian, as shown in the Rage Damage column of the Barbarian Features table.

**Strength Advantage.** You have Advantage on Strength checks and Strength saving throws.

**No Concentration or Spells.** You can't maintain Concentration, and you can't cast spells.

**Duration.** The Rage lasts until the end of your next turn, and it ends early if you don Heavy armor or have the Incapacitated condition. If your Rage is still active on your next turn, you can extend the Rage for another round by doing one of the following:

*   Make an attack roll against an enemy.
*   Force an enemy to make a saving throw.
*   Take a Bonus Action to extend your Rage.

Each time the Rage is extended, it lasts until the end of your next turn. You can maintain a Rage for up to 10 minutes.

#### Level 1: Unarmored Defense
While you aren't wearing any armor, your base Armor Class equals 10 plus your Dexterity and Constitution modifiers. You can use a Shield and still gain this benefit.

#### Level 1: Weapon Mastery
Your training with weapons allows you to use the mastery properties of two kinds of Simple or Martial Melee weapons of your choice, such as Greataxes and Handaxes. Whenever you finish a Long Rest, you can practice weapon drills and change one of those weapon choices.

When you reach certain Barbarian levels, you gain the ability to use the mastery properties of more kinds of weapons, as shown in the Weapon Mastery column of the Barbarian Features table.

#### Level 2: Danger Sense
You gain an uncanny sense of when things aren't as they should be, giving you an edge when you dodge perils. You have Advantage on Dexterity saving throws unless you have the Incapacitated condition.

#### Level 2: Reckless Attack
You can throw aside all concern for defense to attack with increased ferocity. When you make your first attack roll on your turn, you can decide to attack recklessly. Doing so gives you Advantage on attack rolls using Strength until the start of your next turn, but attack rolls against you have Advantage during that time.

#### Level 3: Barbarian Subclass
You gain a Barbarian subclass of your choice. The Path of the Berserker subclass is detailed after this class's description. A subclass is a specialization that grants you features at certain Barbarian levels. For the rest of your career, you gain each of your subclass's features that are of your Barbarian level or lower.

#### Level 3: Primal Knowledge
You gain proficiency in another skill of your choice from the skill list available to Barbarians at level 1.

In addition, while your Rage is active, you can channel primal power when you attempt certain tasks; whenever you make an ability check using one of the following skills, you can make it as a Strength check even if it normally uses a different ability: Acrobatics, Intimidation, Perception, Stealth, or Survival. When you use this ability, your Strength represents primal power coursing through you, honing your agility, bearing, and senses.

#### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see "Feats") or another feat of your choice for which you qualify. You gain this feature again at Barbarian levels 8, 12, and 16.

#### Level 5: Extra Attack
You can attack twice instead of once whenever you take the Attack action on your turn.

#### Level 5: Fast Movement
Your speed increases by 10 feet while you aren't wearing Heavy armor.

#### Level 7: Feral Instinct
Your instincts are so honed that you have Advantage on Initiative rolls.

#### Level 7: Instinctive Pounce
As part of the Bonus Action you take to enter your Rage, you can move up to half your Speed.

#### Level 9: Brutal Strike
If you use Reckless Attack, you can forgo any Advantage on one Strength-based attack roll of your choice on your turn. The chosen attack roll mustn't have Disadvantage. If the chosen attack roll hits, the target takes an extra 1d10 damage of the same type dealt by the weapon or Unarmed Strike, and you can cause one Brutal Strike effect of your choice. You have the following effect options.

**Forceful Blow.** The target is pushed 15 feet straight away from you. You can then move up to half your Speed straight toward the target without provoking Opportunity Attacks.
---
30
**Hamstring Blow.** The target's Speed is reduced by 15 feet until the start of your next turn. A target can be affected by only one Hamstring Blow at a time— the most recent one.

#### Level 11: Relentless Rage
Your Rage can keep you fighting despite grievous wounds. If you drop to 0 Hit Points while your Rage is active and don't die outright, you can make a DC 10 Constitution saving throw. If you succeed, your Hit Points instead change to a number equal to twice your Barbarian level.

Each time you use this feature after the first, the DC increases by 5. When you finish a Short or Long Rest, the DC resets to 10.

#### Level 13: Improved Brutal Strike
You have honed new ways to attack furiously. The following effects are now among your Brutal Strike options.

**Staggering Blow.** The target has Disadvantage on the next saving throw it makes, and it can't make Opportunity Attacks until the start of your next turn.

**Sundering Blow.** Before the start of your next turn, the next attack roll made by another creature against the target gains a +5 bonus to the roll. An attack roll can gain only one Sundering Blow bonus.

#### Level 15: Persistent Rage
When you roll Initiative, you can regain all expended uses of Rage. After you regain uses of Rage in this way, you can't do so again until you finish a Long Rest.

In addition, your Rage is so fierce that it now lasts for 10 minutes without you needing to do anything to extend it from round to round. Your Rage ends early if you have the Unconscious condition (not just the Incapacitated condition) or don Heavy armor.

#### Level 17: Improved Brutal Strike
The extra damage of your Brutal Strike increases to 2d10. In addition, you can use two different Brutal Strike effects whenever you use your Brutal Strike feature.

#### Level 18: Indomitable Might
If your total for a Strength check or Strength saving throw is less than your Strength score, you can use that score in place of the total.

#### Level 19: Epic Boon
You gain an Epic Boon feat (see "Feats") or another feat of your choice for which you qualify. Boon of Irresistible Offense is recommended.

#### Level 20: Primal Champion
You embody primal power. Your Strength and Constitution scores increase by 4, to a maximum of 25.

### Barbarian Subclass: Path of the Berserker
*Channel Rage into Violent Fury*

Barbarians who walk the Path of the Berserker direct their Rage primarily toward violence. Their path is one of untrammeled fury, and they thrill in the chaos of battle as they allow their Rage to seize and empower them.

#### Level 3: Frenzy
If you use Reckless Attack while your Rage is active, you deal extra damage to the first target you hit on your turn with a Strength-based attack. To determine the extra damage, roll a number of d6s equal to your Rage Damage bonus, and add them together. The damage has the same type as the weapon or Unarmed Strike used for the attack.

#### Level 6: Mindless Rage
You have Immunity to the Charmed and Frightened conditions while your Rage is active. If you're Charmed or Frightened when you enter your Rage, the condition ends on you.

#### Level 10: Retaliation
When you take damage from a creature that is within 5 feet of you, you can take a Reaction to make one melee attack against that creature, using a weapon or an Unarmed Strike.

#### Level 14: Intimidating Presence
As a Bonus Action, you can strike terror into others with your menacing presence and primal power. When you do so, each creature of your choice in a 30-foot Emanation originating from you must make a Wisdom saving throw (DC 8 plus your Strength modifier and Proficiency Bonus). On a failed save, a creature has the Frightened condition for 1 minute. At the end of each of the Frightened creature's turns, the creature repeats the save, ending the effect on itself on a success.

Once you use this feature, you can't use it again until you finish a Long Rest unless you expend a use of your Rage (no action required) to restore your use of it.
---
31

## Bard

> **Core Bard Traits**
> **Primary Ability**
> Charisma
>
> **Hit Point Die**
> D8 per Bard level
>
> **Saving Throw Proficiencies**
> Dexterity and Charisma
>
> **Skill Proficiencies**
> Choose any 3 skills (see "Playing the Game")
>
> **Weapon Proficiencies**
> Simple weapons
>
> **Tool Proficiencies**
> Choose 3 Musical Instruments (see "Equipment")
>
> **Armor Training**
> Light armor
>
> **Starting Equipment**
> Choose A or B: (A) Leather Armor, 2 Daggers, Musical Instrument of your choice, Entertainer's Pack, and 19 GP; or (B) 90 GP

### Becoming a Bard ...
**As a Level 1 Character**
*   Gain all the traits in the Core Bard Traits table.
*   Gain the Bard's level 1 features, which are listed in the Bard Features table.

**As a Multiclass Character**
*   Gain the following traits from the Core Bard Traits table: Hit Point Die, proficiency in one skill of your choice, proficiency with one Musical Instrument of your choice, and training with Light armor.
*   Gain the Bard's level 1 features, which are listed in the Bard Features table. See the multiclassing rules in "Character Creation" to determine your available spell slots.

### Bard Class Features
As a Bard, you gain the following class features when you reach the specified Bard levels. These features are listed in the Bard Features table.

#### Level 1: Bardic Inspiration
You can supernaturally inspire others through words, music, or dance. This inspiration is represented by your Bardic Inspiration die, which is a d6.

**Using Bardic Inspiration.** As a Bonus Action, you can inspire another creature within 60 feet of yourself who can see or hear you. That creature gains

#### Bard Features
| Level | Proficiency Bonus | Class Features | Bardic Die | Cantrips | Prepared Spells | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 |
| :--- | :--- | :--- | :--- | :--- | :--- | :- | :- | :- | :- | :- | :- | :- | :- | :- |
| 1 | +2 | Bardic Inspiration, Spellcasting | D6 | 2 | 4 | 2 | — | — | — | — | — | — | — | — |
| 2 | +2 | Expertise, Jack of All Trades | D6 | 2 | 5 | 3 | — | — | — | — | — | — | — | — |
| 3 | +2 | Bard Subclass | D6 | 2 | 6 | 4 | 2 | — | — | — | — | — | — | — |
| 4 | +2 | Ability Score Improvement | D6 | 3 | 7 | 4 | 3 | — | — | — | — | — | — | — |
| 5 | +3 | Font of Inspiration | D8 | 3 | 9 | 4 | 3 | 2 | — | — | — | — | — | — |
| 6 | +3 | Subclass feature | D8 | 3 | 10 | 4 | 3 | 3 | — | — | — | — | — | — |
| 7 | +3 | Countercharm | D8 | 3 | 11 | 4 | 3 | 3 | 1 | — | — | — | — | — |
| 8 | +3 | Ability Score Improvement | D8 | 3 | 12 | 4 | 3 | 3 | 2 | — | — | — | — | — |
| 9 | +4 | Expertise | D8 | 3 | 14 | 4 | 3 | 3 | 3 | 1 | — | — | — | — |
| 10 | +4 | Magical Secrets | D10 | 4 | 15 | 4 | 3 | 3 | 3 | 2 | — | — | — | — |
| 11 | +4 | — | D10 | 4 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 12 | +4 | Ability Score Improvement | D10 | 4 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 13 | +5 | — | D10 | 4 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 14 | +5 | Subclass feature | D10 | 4 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 15 | +5 | — | D12 | 4 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 16 | +5 | Ability Score Improvement | D12 | 4 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 17 | +6 | — | D12 | 4 | 19 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | 1 |
| 18 | +6 | Superior Inspiration | D12 | 4 | 20 | 4 | 3 | 3 | 3 | 3 | 1 | 1 | 1 | 1 |
| 19 | +6 | Epic Boon | D12 | 4 | 21 | 4 | 3 | 3 | 3 | 3 | 2 | 1 | 1 | 1 |
| 20 | +6 | Words of Creation | D12 | 4 | 22 | 4 | 3 | 3 | 3 | 3 | 2 | 2 | 1 | 1 |
---
32
one of your Bardic Inspiration dice. A creature can have only one Bardic Inspiration die at a time.

Once within the next hour when the creature fails a D20 Test, the creature can roll the Bardic Inspiration die and add the number rolled to the d20, potentially turning the failure into a success. A Bardic Inspiration die is expended when it's rolled.

**Number of Uses.** You can confer a Bardic Inspiration die a number of times equal to your Charisma modifier (minimum of once), and you regain all expended uses when you finish a Long Rest.

**At Higher Levels.** Your Bardic Inspiration die changes when you reach certain Bard levels, as shown in the Bardic Die column of the Bard Features table. The die becomes a d8 at level 5, a d10 at level 10, and a d12 at level 15.

#### Level 1: Spellcasting
You have learned to cast spells through your bardic arts. See "Spells” for the rules on spellcasting. The information below details how you use those rules with Bard spells, which appear in the Bard spell list later in the class's description.

**Cantrips.** You know two cantrips of your choice from the Bard spell list. *Dancing Lights* and *Vicious Mockery* are recommended.

Whenever you gain a Bard level, you can replace one of your cantrips with another cantrip of your choice from the Bard spell list.

When you reach Bard levels 4 and 10, you learn another cantrip of your choice from the Bard spell list, as shown in the Cantrips column of the Bard Features table.

**Spell Slots.** The Bard Features table shows how many spell slots you have to cast your level 1+ spells. You regain all expended slots when you finish a Long Rest.

**Prepared Spells of Level 1+.** You prepare the list of level 1+ spells that are available for you to cast with this feature. To start, choose four level 1 spells from the Bard spell list. *Charm Person*, *Color Spray*, *Dissonant Whispers*, and *Healing Word* are recommended.

The number of spells on your list increases as you gain Bard levels, as shown in the Prepared Spells column of the Bard Features table. Whenever that number increases, choose additional spells from the Bard spell list until the number of spells on your list matches the number on the table. The chosen spells must be of a level for which you have spell slots.

For example, if you're a level 3 Bard, your list of prepared spells can include six spells of levels 1 and 2 in any combination.

If another Bard feature gives you spells that you always have prepared, those spells don't count against the number of spells you can prepare with this feature, but those spells otherwise count as Bard spells for you.

**Changing Your Prepared Spells.** Whenever you gain a Bard level, you can replace one spell on your list with another Bard spell for which you have spell slots.

**Spellcasting Ability.** Charisma is your spellcasting ability for your Bard spells.

**Spellcasting Focus.** You can use a Musical Instrument as a Spellcasting Focus for your Bard spells.

#### Level 2: Expertise
You gain Expertise (see "Rules Glossary") in two of your skill proficiencies of your choice. Performance and Persuasion are recommended if you have proficiency in them.

At Bard level 9, you gain Expertise in two more of your skill proficiencies of your choice.

#### Level 2: Jack of All Trades
You can add half your Proficiency Bonus (round down) to any ability check you make that uses a skill proficiency you lack and that doesn't otherwise use your Proficiency Bonus.

For example, if you make a Strength (Athletics) check and lack Athletics proficiency, you can add half your Proficiency Bonus to the check.

#### Level 3: Bard Subclass
You gain a Bard subclass of your choice. The College of Lore subclass is detailed after this class's description. A subclass is a specialization that grants you features at certain Bard levels. For the rest of your career, you gain each of your subclass's features that are of your Bard level or lower.

#### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see "Feats") or another feat of your choice for which you qualify. You gain this feature again at Bard levels 8, 12, and 16.

#### Level 5: Font of Inspiration
You now regain all your expended uses of Bardic Inspiration when you finish a Short or Long Rest.

In addition, you can expend a spell slot (no action required) to regain one expended use of Bardic Inspiration.
---
33

#### Level 7: Countercharm
You can use musical notes or words of power to disrupt mind-influencing effects. If you or a creature within 30 feet of you fails a saving throw against an effect that applies the Charmed or Frightened condition, you can take a Reaction to cause the save to be rerolled, and the new roll has Advantage.

#### Level 10: Magical Secrets
You've learned secrets from various magical traditions. Whenever you reach a Bard level (including this level) and the Prepared Spells number in the Bard Features table increases, you can choose any of your new prepared spells from the Bard, Cleric, Druid, and Wizard spell lists, and the chosen spells count as Bard spells for you (see a class's section for its spell list). In addition, whenever you replace a spell prepared for this class, you can replace it with a spell from those lists.

#### Level 18: Superior Inspiration
When you roll Initiative, you regain expended uses of Bardic Inspiration until you have two if you have fewer than that.

#### Level 19: Epic Boon
You gain an Epic Boon feat (see "Feats") or another feat of your choice for which you qualify. Boon of Spell Recall is recommended.

#### Level 20: Words of Creation
You have mastered two of the Words of Creation: the words of life and death. You therefore always have the *Power Word Heal* and *Power Word Kill* spells prepared. When you cast either spell, you can target a second creature with it if that creature is within 10 feet of the first target.

### Bard Spell List
This section presents the Bard spell list. The spells are organized by spell level and then alphabetized, and each spell's school of magic is listed. In the Special column, **C** means the spell requires Concentration, **R** means it's a Ritual, and **M** means it requires a specific Material component.

#### Cantrips (Level 0 Bard Spells)
| Spell | School | Special |
| :--- | :--- | :--- |
| Dancing Lights | Illusion | C |
| Light | Evocation | — |
| Mage Hand | Conjuration | — |
| Mending | Transmutation | — |
| Message | Transmutation | — |
| Minor Illusion | Illusion | — |
| Prestidigitation | Transmutation | — |
| Starry Wisp | Evocation | — |
| True Strike | Divination | — |
| Vicious Mockery | Enchantment | — |

#### Level 1 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Animal Friendship | Enchantment | — |
| Bane | Enchantment | C |
| Charm Person | Enchantment | — |
| Color Spray | Illusion | — |
| Command | Enchantment | — |
| Comprehend Languages | Divination | R |
| Cure Wounds | Abjuration | — |
| Detect Magic | Divination | C, R |
| Disguise Self | Illusion | — |
| Dissonant Whispers | Enchantment | — |
| Faerie Fire | Evocation | C |
| Feather Fall | Transmutation | — |
| Healing Word | Abjuration | — |
| Heroism | Enchantment | C |
| Hideous Laughter | Enchantment | C |
| Identify | Divination | R, M |
| Illusory Script | Illusion | R, M |
| Longstrider | Transmutation | — |
| Silent Image | Illusion | C |
| Sleep | Enchantment | C |
| Speak with Animals | Divination | R |
| Thunderwave | Evocation | — |
| Unseen Servant | Conjuration | R |

#### Level 2 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Aid | Abjuration | — |
| Animal Messenger | Enchantment | R |
| Blindness/Deafness | Transmutation | — |
| Calm Emotions | Enchantment | C |
| Detect Thoughts | Divination | C |
| Enhance Ability | Transmutation | C |
| Enlarge/Reduce | Transmutation | C |
| Enthrall | Enchantment | C |
| Heat Metal | Transmutation | C |
| Hold Person | Enchantment | C |
---
34

| Spell | School | Special |
| :--- | :--- | :--- |
| Invisibility | Illusion | C |
| Knock | Transmutation | — |
| Lesser Restoration | Abjuration | — |
| Locate Animals or Plants | Divination | R |
| Locate Object | Divination | C |
| Magic Mouth | Illusion | R, M |
| Mirror Image | Illusion | — |
| See Invisibility | Divination | — |
| Shatter | Evocation | — |
| Silence | Illusion | C, R |
| Suggestion | Enchantment | C |
| Zone of Truth | Enchantment | — |

#### Level 3 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Bestow Curse | Necromancy | C |
| Clairvoyance | Divination | C, M |
| Dispel Magic | Abjuration | — |
| Fear | Illusion | C |
| Glyph of Warding | Abjuration | M |
| Hypnotic Pattern | Illusion | C |
| Major Image | Illusion | C |
| Mass Healing Word | Abjuration | — |
| Nondetection | Abjuration | M |
| Plant Growth | Transmutation | — |
| Sending | Divination | — |
| Slow | Transmutation | C |
| Speak with Dead | Necromancy | — |
| Speak with Plants | Transmutation | — |
| Stinking Cloud | Conjuration | C |
| Tiny Hut | Evocation | R |
| Tongues | Divination | — |

#### Level 4 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Charm Monster | Enchantment | — |
| Compulsion | Enchantment | C |
| Confusion | Enchantment | C |
| Dimension Door | Conjuration | — |
| Freedom of Movement | Abjuration | — |
| Greater Invisibility | Illusion | C |
| Hallucinatory Terrain | Illusion | — |
| Locate Creature | Divination | C |
| Phantasmal Killer | Illusion | C |
| Polymorph | Transmutation | C |

#### Level 5 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Animate Objects | Transmutation | C |
| Awaken | Transmutation | M |
| Dominate Person | Enchantment | C |
| Dream | Illusion | — |
| Geas | Enchantment | — |
| Greater Restoration | Abjuration | M |
| Hold Monster | Enchantment | C |
| Legend Lore | Divination | M |
| Mass Cure Wounds | Abjuration | — |
| Mislead | Illusion | C |
| Modify Memory | Enchantment | C |
| Planar Binding | Abjuration | M |
| Raise Dead | Necromancy | M |
| Scrying | Divination | C, M |
| Seeming | Illusion | — |
| Telepathic Bond | Divination | R |
| Teleportation Circle | Conjuration | M |

#### Level 6 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Eyebite | Necromancy | C |
| Find the Path | Divination | C, M |
| Guards and Wards | Abjuration | M |
| Heroes' Feast | Conjuration | M |
| Irresistible Dance | Enchantment | C |
| Mass Suggestion | Enchantment | — |
| Programmed Illusion | Illusion | M |
| True Seeing | Divination | M |

#### Level 7 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Arcane Sword | Evocation | C, M |
| Etherealness | Conjuration | — |
| Forcecage | Evocation | C, M |
| Magnificent Mansion | Conjuration | M |
| Mirage Arcane | Illusion | — |
| Prismatic Spray | Evocation | — |
| Project Image | Illusion | C, M |
| Regenerate | Transmutation | — |
| Resurrection | Necromancy | M |
| Symbol | Abjuration | M |
| Teleport | Conjuration | — |
---
35

#### Level 8 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Antipathy/Sympathy | Enchantment | — |
| Befuddlement | Enchantment | — |
| Dominate Monster | Enchantment | C |
| Glibness | Enchantment | — |
| Mind Blank | Abjuration | — |
| Power Word Stun | Enchantment | — |

#### Level 9 Bard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Foresight | Divination | — |
| Power Word Heal | Enchantment | — |
| Power Word Kill | Enchantment | — |
| Prismatic Wall | Abjuration | — |
| True Polymorph | Transmutation | C |

### Bard Subclass: College of Lore
*Plumb the Depths of Magical Knowledge*

Bards of the College of Lore collect spells and secrets from diverse sources, such as scholarly tomes, mystical rites, and peasant tales. The college's members gather in libraries and universities to share their lore with one another. They also meet at festivals or affairs of state, where they can expose corruption, unravel lies, and poke fun at self-important figures of authority.

#### Level 3: Bonus Proficiencies
You gain proficiency with three skills of your choice.

#### Level 3: Cutting Words
You learn to use your wit to supernaturally distract, confuse, and otherwise sap the confidence and competence of others. When a creature that you can see within 60 feet of yourself makes a damage roll or succeeds on an ability check or attack roll, you can take a Reaction to expend one use of your Bardic Inspiration; roll your Bardic Inspiration die, and subtract the number rolled from the creature's roll, reducing the damage or potentially turning the success into a failure.

#### Level 6: Magical Discoveries
You learn two spells of your choice. These spells can come from the Cleric, Druid, or Wizard spell list or any combination thereof (see a class's section for its spell list). A spell you choose must be a cantrip or a spell for which you have spell slots, as shown in the Bard Features table.

You always have the chosen spells prepared, and whenever you gain a Bard level, you can replace one of the spells with another spell that meets these requirements.

#### Level 14: Peerless Skill
When you make an ability check or attack roll and fail, you can expend one use of Bardic Inspiration; roll the Bardic Inspiration die, and add the number rolled to the d20, potentially turning a failure into a success. On a failure, the Bardic Inspiration isn't expended.