# Cleric

| Core Cleric Traits | |
| :--- | :--- |
| **Primary Ability** | Wisdom |
| **Hit Point Die** | D8 per Cleric level |
| **Saving Throw Proficiencies** | Wisdom and Charisma |
| **Skill Proficiencies** | Choose 2: History, Insight, Medicine, Persuasion, or Religion |
| **Weapon Proficiencies** | Simple weapons |
| **Armor Training** | Light and Medium armor and Shields |
| **Starting Equipment** | Choose A or B: (A) Chain Shirt, Shield, Mace, Holy Symbol, Priest's Pack, and 7 GP; or (B) 110 GP |

> ### Becoming a Cleric ...
> **As a Level 1 Character**
> * Gain all the traits in the Core Cleric Traits table.
> * Gain the Cleric's level 1 features, which are listed in the Cleric Features table.

> ### As a Multiclass Character
> * Gain the following traits from the Core Cleric Traits table: Hit Point Die and training with Light and Medium armor and Shields.
> * Gain the Cleric's level 1 features, which are listed in the Cleric Features table. See the multiclassing rules in "Character Creation" to determine your available spell slots.

## Cleric Class Features
As a Cleric, you gain the following class features when you reach the specified Cleric levels. These features are listed in the Cleric Features table.

### Level 1: Spellcasting
You have learned to cast spells through prayer and meditation. See "Spells" for the rules on spellcasting. The information below details how you use those rules with Cleric spells, which appear on the Cleric spell list later in the class's description.
**Cantrips.** You know three cantrips of your choice from the Cleric spell list. *Guidance*, *Sacred Flame*, and *Thaumaturgy* are recommended.
Whenever you gain a Cleric level, you can replace one of your cantrips with another cantrip of your choice from the Cleric spell list.

| | **Proficiency** | | **Channel** | | **Prepared** | <center>—Spell Slots per Spell Level—</center> | | | | | | | | |
| :-: | :---: | :--- | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| **Level** | **Bonus** | **Class Features** | **Divinity** | **Cantrips** | **Spells** | **1** | **2** | **3** | **4** | **5** | **6** | **7** | **8** | **9** |
| 1 | +2 | Spellcasting, Divine Order | — | 3 | 4 | 2 | — | — | — | — | — | — | — | — |
| 2 | +2 | Channel Divinity | 2 | 3 | 5 | 3 | — | — | — | — | — | — | — | — |
| 3 | +2 | Cleric Subclass | 2 | 3 | 6 | 4 | 2 | — | — | — | — | — | — | — |
| 4 | +2 | Ability Score Improvement | 2 | 4 | 7 | 4 | 3 | — | — | — | — | — | — | — |
| 5 | +3 | Sear Undead | 2 | 4 | 9 | 4 | 3 | 2 | — | — | — | — | — | — |
| 6 | +3 | Subclass feature | 3 | 4 | 10 | 4 | 3 | 3 | — | — | — | — | — | — |
| 7 | +3 | Blessed Strikes | 3 | 4 | 11 | 4 | 3 | 3 | 1 | — | — | — | — | — |
| 8 | +3 | Ability Score Improvement | 3 | 4 | 12 | 4 | 3 | 3 | 2 | — | — | — | — | — |
| 9 | +4 | — | 3 | 4 | 14 | 4 | 3 | 3 | 3 | 1 | — | — | — | — |
| 10 | +4 | Divine Intervention | 3 | 5 | 15 | 4 | 3 | 3 | 3 | 2 | — | — | — | — |
| 11 | +4 | — | 3 | 5 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 12 | +4 | Ability Score Improvement | 3 | 5 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 13 | +5 | — | 3 | 5 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 14 | +5 | Improved Blessed Strikes | 3 | 5 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 15 | +5 | — | 3 | 5 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 16 | +5 | Ability Score Improvement | 3 | 5 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 17 | +6 | Subclass feature | 3 | 5 | 19 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | 1 |
| 18 | +6 | — | 4 | 5 | 20 | 4 | 3 | 3 | 3 | 3 | 1 | 1 | 1 | 1 |
| 19 | +6 | Epic Boon | 4 | 5 | 21 | 4 | 3 | 3 | 3 | 3 | 2 | 1 | 1 | 1 |
| 20 | +6 | Greater Divine Intervention | 4 | 5 | 22 | 4 | 3 | 3 | 3 | 3 | 2 | 2 | 1 | 1 |

<br>
36
System Reference Document 5.2.1

---
When you reach Cleric levels 4 and 10, you learn another cantrip of your choice from the Cleric spell list, as shown in the Cantrips column of the Cleric Features table.
**Spell Slots.** The Cleric Features table shows how many spell slots you have to cast your level 1+ spells. You regain all expended slots when you finish a Long Rest.
**Prepared Spells of Level 1+.** You prepare the list of level 1+ spells that are available for you to cast with this feature. To start, choose four level 1 spells from the Cleric spell list. *Bless*, *Cure Wounds*, *Guiding Bolt*, and *Shield of Faith* are recommended.
The number of spells on your list increases as you gain Cleric levels, as shown in the Prepared Spells column of the Cleric Features table. Whenever that number increases, choose additional spells from the Cleric spell list until the number of spells on your list matches the number on the table. The chosen spells must be of a level for which you have spell slots. For example, if you're a level 3 Cleric, your list of prepared spells can include six spells of levels 1 and 2 in any combination.
If another Cleric feature gives you spells that you always have prepared, those spells don't count against the number of spells you can prepare with this feature, but those spells otherwise count as Cleric spells for you.
**Changing Your Prepared Spells.** Whenever you finish a Long Rest, you can change your list of prepared spells, replacing any of the spells there with other Cleric spells for which you have spell slots.
**Spellcasting Ability.** Wisdom is your spellcasting ability for your Cleric spells.
**Spellcasting Focus.** You can use a Holy Symbol as a Spellcasting Focus for your Cleric spells.

### Level 1: Divine Order
You have dedicated yourself to one of the following sacred roles of your choice.
**Protector.** Trained for battle, you gain proficiency with Martial weapons and training with Heavy armor.
**Thaumaturge.** You know one extra cantrip from the Cleric spell list. In addition, your mystical connection to the divine gives you a bonus to your Intelligence (Arcana or Religion) checks. The bonus equals your Wisdom modifier (minimum of +1).

### Level 2: Channel Divinity
You can channel divine energy directly from the Outer Planes to fuel magical effects. You start with two such effects: Divine Spark and Turn Undead, each of which is described below. Each time you use this class's Channel Divinity, choose which Channel Divinity effect from this class to create. You gain additional effect options at higher Cleric levels.
You can use this class's Channel Divinity twice. You regain one of its expended uses when you finish a Short Rest, and you regain all expended uses when you finish a Long Rest. You gain additional uses when you reach certain Cleric levels, as shown in the Channel Divinity column of the Cleric Features table.
If a Channel Divinity effect requires a saving throw, the DC equals the spell save DC from this class's Spellcasting feature.
**Divine Spark.** As a Magic action, you point your Holy Symbol at another creature you can see within 30 feet of yourself and focus divine energy at it. Roll 1d8 and add your Wisdom modifier. You either restore Hit Points to the creature equal to that total or force the creature to make a Constitution saving throw. On a failed save, the creature takes Necrotic or Radiant damage (your choice) equal to that total. On a successful save, the creature takes half as much damage (round down).
You roll an additional d8 when you reach Cleric levels 7 (2d8), 13 (3d8), and 18 (4d8).
**Turn Undead.** As a Magic action, you present your Holy Symbol and censure Undead creatures. Each Undead of your choice within 30 feet of you must make a Wisdom saving throw. If the creature fails its save, it has the Frightened and Incapacitated conditions for 1 minute. For that duration, it tries to move as far from you as it can on its turns. This effect ends early on the creature if it takes any damage, if you have the Incapacitated condition, or if you die.

### Level 3: Cleric Subclass
You gain a Cleric subclass of your choice. The Life Domain subclass is detailed after this class's description. A subclass is a specialization that grants you features at certain Cleric levels. For the rest of your career, you gain each of your subclass's features that are of your Cleric level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see "Feats") or another feat of your choice for which you qualify. You gain this feature again at Cleric levels 8, 12, and 16.

### Level 5: Sear Undead
Whenever you use Turn Undead, you can roll a number of d8s equal to your Wisdom modifier (minimum of 1d8) and add the rolls together. Each Undead that fails its saving throw against that use of Turn Undead takes Radiant damage equal to the roll's total. This damage doesn't end the turn effect.

37
System Reference Document 5.2.1

---
### Level 7: Blessed Strikes
Divine power infuses you in battle. You gain one of the following options of your choice (if you get either option from a Cleric subclass in an older book, use only the option you choose for this feature).
**Divine Strike.** Once on each of your turns when you hit a creature with an attack roll using a weapon, you can cause the target to take an extra 1d8 Necrotic or Radiant damage (your choice).
**Potent Spellcasting.** Add your Wisdom modifier to the damage you deal with any Cleric cantrip.

### Level 10: Divine Intervention
You can call on your deity or pantheon to intervene on your behalf. As a Magic action, choose any Cleric spell of level 5 or lower that doesn't require a Reaction to cast. As part of the same action, you cast that spell without expending a spell slot or needing Material components. You can't use this feature again until you finish a Long Rest.

### Level 14: Improved Blessed Strikes
The option you chose for Blessed Strikes grows more powerful.
**Divine Strike.** The extra damage of your Divine Strike increases to 2d8.
**Potent Spellcasting.** When you cast a Cleric cantrip and deal damage to a creature with it, you can give vitality to yourself or another creature within 60 feet of yourself, granting a number of Temporary Hit Points equal to twice your Wisdom modifier.

### Level 19: Epic Boon
You gain an Epic Boon feat (see "Feats") or another feat of your choice for which you qualify. Boon of Fate is recommended.

### Level 20: Greater Divine Intervention
You can call on even more powerful divine intervention. When you use your Divine Intervention feature, you can choose *Wish* when you select a spell. If you do so, you can't use Divine Intervention again until you finish 2d4 Long Rests.

## Cleric Spell List
This section presents the Cleric spell list. The spells are organized by spell level and then alphabetized, and each spell's school of magic is listed. In the Special column, C means the spell requires Concentration, R means it's a Ritual, and M means it requires a specific Material component.

### Cantrips (Level 0 Cleric Spells)
| Spell | School | Special |
| :--- | :--- | :---: |
| Guidance | Divination | C |
| Light | Evocation | — |
| Mending | Transmutation | — |
| Resistance | Abjuration | C |
| Sacred Flame | Evocation | — |
| Spare the Dying | Necromancy | — |
| Thaumaturgy | Transmutation | — |

### Level 1 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Bane | Enchantment | C |
| Bless | Enchantment | C, M |
| Command | Enchantment | — |
| Create or Destroy Water | Transmutation | — |
| Cure Wounds | Abjuration | — |
| Detect Evil and Good | Divination | C |
| Detect Magic | Divination | C, R |
| Detect Poison and Disease | Divination | C, R |
| Guiding Bolt | Evocation | — |
| Healing Word | Abjuration | — |
| Inflict Wounds | Necromancy | — |
| Protection from Evil and Good | Abjuration | C, M |
| Purify Food and Drink | Transmutation | R |
| Sanctuary | Abjuration | — |
| Shield of Faith | Abjuration | C |

### Level 2 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Aid | Abjuration | — |
| Augury | Divination | R, M |
| Blindness/Deafness | Transmutation | — |
| Calm Emotions | Enchantment | C |
| Continual Flame | Evocation | M |
| Enhance Ability | Transmutation | C |
| Find Traps | Divination | — |
| Gentle Repose | Necromancy | R, M |
| Hold Person | Enchantment | C |
| Lesser Restoration | Abjuration | — |
| Locate Object | Divination | C |
| Prayer of Healing | Abjuration | — |

38
System Reference Document 5.2.1

---
| Spell | School | Special |
| :--- | :--- | :---: |
| Protection from Poison | Abjuration | — |
| Silence | Illusion | C, R |
| Spiritual Weapon | Evocation | C |
| Warding Bond | Abjuration | M |
| Zone of Truth | Enchantment | — |

### Level 3 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Animate Dead | Necromancy | — |
| Beacon of Hope | Abjuration | C |
| Bestow Curse | Necromancy | C |
| Clairvoyance | Divination | C, M |
| Create Food and Water | Conjuration | — |
| Daylight | Evocation | — |
| Dispel Magic | Abjuration | — |
| Glyph of Warding | Abjuration | M |
| Magic Circle | Abjuration | M |
| Mass Healing Word | Abjuration | — |
| Meld into Stone | Transmutation | R |
| Protection from Energy | Abjuration | C |
| Remove Curse | Abjuration | — |
| Revivify | Necromancy | M |
| Sending | Divination | — |
| Speak with Dead | Necromancy | — |
| Spirit Guardians | Conjuration | C |
| Tongues | Divination | — |
| Water Walk | Transmutation | R |

### Level 4 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Aura of Life | Abjuration | C |
| Banishment | Abjuration | C |
| Control Water | Transmutation | C |
| Death Ward | Abjuration | — |
| Divination | Divination | R, M |
| Freedom of Movement | Abjuration | — |
| Guardian of Faith | Conjuration | — |
| Locate Creature | Divination | C |
| Stone Shape | Transmutation | — |

### Level 5 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Commune | Divination | R |
| Contagion | Necromancy | — |
| Dispel Evil and Good | Abjuration | C |
| Flame Strike | Evocation | — |
| Geas | Enchantment | — |
| Greater Restoration | Abjuration | M |
| Hallow | Abjuration | M |
| Insect Plague | Conjuration | C |
| Legend Lore | Divination | M |
| Mass Cure Wounds | Abjuration | — |
| Planar Binding | Abjuration | M |
| Raise Dead | Necromancy | M |
| Scrying | Divination | C, M |

### Level 6 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Blade Barrier | Evocation | C |
| Create Undead | Necromancy | M |
| Find the Path | Divination | C, M |
| Forbiddance | Abjuration | R, M |
| Harm | Necromancy | — |
| Heal | Abjuration | — |
| Heroes' Feast | Conjuration | M |
| Planar Ally | Conjuration | — |
| Sunbeam | Evocation | C |
| True Seeing | Divination | M |
| Word of Recall | Conjuration | — |

### Level 7 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Conjure Celestial | Conjuration | C |
| Divine Word | Evocation | — |
| Etherealness | Conjuration | — |
| Fire Storm | Evocation | — |
| Plane Shift | Conjuration | M |
| Regenerate | Transmutation | — |
| Resurrection | Necromancy | M |
| Symbol | Abjuration | M |

39
System Reference Document 5.2.1

---
### Level 8 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Antimagic Field | Abjuration | C |
| Control Weather | Transmutation | C |
| Earthquake | Transmutation | C |
| Holy Aura | Abjuration | C, M |
| Sunburst | Evocation | — |

### Level 9 Cleric Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Astral Projection | Necromancy | M |
| Gate | Conjuration | C, M |
| Mass Heal | Abjuration | — |
| Power Word Heal | Enchantment | — |
| True Resurrection | Necromancy | M |

## Cleric Subclass: Life Domain
*Soothe the Hurts of the World*

The Life Domain focuses on the positive energy that helps sustain all life in the multiverse. Clerics who tap into this domain are masters of healing, using that life force to cure many hurts.
Existence itself relies on the positive energy associated with this domain, so a Cleric of almost any religious tradition might choose it. This domain is particularly associated with agricultural deities, gods of healing or endurance, and gods of home and community. Religious orders of healing also seek the magic of this domain.

### Level 3: Disciple of Life
When a spell you cast with a spell slot restores Hit Points to a creature, that creature regains additional Hit Points on the turn you cast the spell. The additional Hit Points equal 2 plus the spell slot's level.

### Level 3: Life Domain Spells
Your connection to this divine domain ensures you always have certain spells ready. When you reach a Cleric level specified in the Life Domain Spells table, you thereafter always have the listed spells prepared.

| Life Domain Spells | |
| :--- | :--- |
| **Cleric Level** | **Prepared Spells** |
| 3 | Aid, Bless, Cure Wounds, Lesser Restoration |
| 5 | Mass Healing Word, Revivify |
| 7 | Aura of Life, Death Ward |
| 9 | Greater Restoration, Mass Cure Wounds |

### Level 3: Preserve Life
As a Magic action, you present your Holy Symbol and expend a use of your Channel Divinity to evoke healing energy that can restore a number of Hit Points equal to five times your Cleric level. Choose Bloodied creatures within 30 feet of yourself (which can include you), and divide those Hit Points among them. This feature can restore a creature to no more than half its Hit Point maximum.

### Level 6: Blessed Healer
The healing spells you cast on others heal you as well. Immediately after you cast a spell with a spell slot that restores Hit Points to one or more creatures other than yourself, you regain Hit Points equal to 2 plus the spell slot's level.

### Level 17: Supreme Healing
When you would normally roll one or more dice to restore Hit Points to a creature with a spell or Channel Divinity, don't roll those dice for the healing; instead use the highest number possible for each die. For example, instead of restoring 2d6 Hit Points to a creature with a spell, you restore 12.

40
System Reference Document 5.2.1

---
# Druid

| Core Druid Traits | |
| :--- | :--- |
| **Primary Ability** | Wisdom |
| **Hit Point Die** | D8 per Druid level |
| **Saving Throw Proficiencies** | Intelligence and Wisdom |
| **Skill Proficiencies** | Choose 2: Animal Handling, Arcana, Insight, Medicine, Nature, Perception, Religion, or Survival |
| **Weapon Proficiencies** | Simple weapons |
| **Tool Proficiencies** | Herbalism Kit |
| **Armor Training** | Light armor and Shields |
| **Starting Equipment** | Choose A or B: (A) Leather Armor, Shield, Sickle, Druidic Focus (Quarterstaff), Explorer's Pack, Herbalism Kit, and 9 GP; or (B) 50 GP |

> ### Becoming a Druid ...
> **As a Level 1 Character**
> * Gain all the traits in the Core Druid Traits table.
> * Gain the Druid's level 1 features, which are listed in the Druid Features table.

> ### As a Multiclass Character
> * Gain the following traits from the Core Druid Traits table: Hit Point Die and training with Light armor and Shields.
> * Gain the Druid's level 1 features, which are listed in the Druid Features table. See the multiclassing rules in "Character Creation" to determine your available spell slots.

## Druid Class Features
As a Druid, you gain the following class features when you reach the specified Druid levels. These features are listed in the Druid Features table.

### Level 1: Spellcasting
You have learned to cast spells through studying the mystical forces of nature. See "Spells" for the rules on spellcasting. The information below details

| | **Proficiency** | | **Wild** | | **Prepared** | <center>—Spell Slots per Spell Level—</center> | | | | | | | | |
| :-: | :---: | :--- | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| **Level** | **Bonus** | **Class Features** | **Shape** | **Cantrips** | **Spells** | **1** | **2** | **3** | **4** | **5** | **6** | **7** | **8** | **9** |
| 1 | +2 | Spellcasting, Druidic, Primal Order | — | 2 | 4 | 2 | — | — | — | — | — | — | — | — |
| 2 | +2 | Wild Shape, Wild Companion | 2 | 2 | 5 | 3 | — | — | — | — | — | — | — | — |
| 3 | +2 | Druid Subclass | 2 | 2 | 6 | 4 | 2 | — | — | — | — | — | — | — |
| 4 | +2 | Ability Score Improvement | 2 | 3 | 7 | 4 | 3 | — | — | — | — | — | — | — |
| 5 | +3 | Wild Resurgence | 2 | 3 | 9 | 4 | 3 | 2 | — | — | — | — | — | — |
| 6 | +3 | Subclass feature | 3 | 3 | 10 | 4 | 3 | 3 | — | — | — | — | — | — |
| 7 | +3 | Elemental Fury | 3 | 3 | 11 | 4 | 3 | 3 | 1 | — | — | — | — | — |
| 8 | +3 | Ability Score Improvement | 3 | 3 | 12 | 4 | 3 | 3 | 2 | — | — | — | — | — |
| 9 | +4 | — | 3 | 3 | 14 | 4 | 3 | 3 | 3 | 1 | — | — | — | — |
| 10 | +4 | Subclass feature | 3 | 4 | 15 | 4 | 3 | 3 | 3 | 2 | — | — | — | — |
| 11 | +4 | — | 3 | 4 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 12 | +4 | Ability Score Improvement | 3 | 4 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 13 | +5 | — | 3 | 4 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 14 | +5 | Subclass feature | 3 | 4 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 15 | +5 | Improved Elemental Fury | 3 | 4 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 16 | +5 | Ability Score Improvement | 3 | 4 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 17 | +6 | — | 4 | 4 | 19 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | 1 |
| 18 | +6 | Beast Spells | 4 | 4 | 20 | 4 | 3 | 3 | 3 | 3 | 1 | 1 | 1 | 1 |
| 19 | +6 | Epic Boon | 4 | 4 | 21 | 4 | 3 | 3 | 3 | 3 | 2 | 1 | 1 | 1 |
| 20 | +6 | Archdruid | 4 | 4 | 22 | 4 | 3 | 3 | 3 | 3 | 2 | 2 | 1 | 1 |

41
System Reference Document 5.2.1

---
how you use those rules with Druid spells, which appear on the Druid spell list later in the class's description.
**Cantrips.** You know two cantrips of your choice from the Druid spell list. *Druidcraft* and *Produce Flame* are recommended.
Whenever you gain a Druid level, you can replace one of your cantrips with another cantrip of your choice from the Druid spell list.
When you reach Druid levels 4 and 10, you learn another cantrip of your choice from the Druid spell list, as shown in the Cantrips column of the Druid Features table.
**Spell Slots.** The Druid Features table shows how many spell slots you have to cast your level 1+ spells. You regain all expended slots when you finish a Long Rest.
**Prepared Spells of Level 1+.** You prepare the list of level 1+ spells that are available for you to cast with this feature. To start, choose four level 1 spells from the Druid spell list. *Animal Friendship*, *Cure Wounds*, *Faerie Fire*, and *Thunderwave* are recommended.
The number of spells on your list increases as you gain Druid levels, as shown in the Prepared Spells column of the Druid Features table. Whenever that number increases, choose additional spells from the Druid spell list until the number of spells on your list matches the number on the table. The chosen spells must be of a level for which you have spell slots. For example, if you're a level 3 Druid, your list of prepared spells can include six spells of levels 1 and 2 in any combination.
If another Druid feature gives you spells that you always have prepared, those spells don't count against the number of spells you can prepare with this feature, but those spells otherwise count as Druid spells for you.
**Changing Your Prepared Spells.** Whenever you finish a Long Rest, you can change your list of prepared spells, replacing any of the spells with other Druid spells for which you have spell slots.
**Spellcasting Ability.** Wisdom is your spellcasting ability for your Druid spells.
**Spellcasting Focus.** You can use a Druidic Focus as a Spellcasting Focus for your Druid spells.

### Level 1: Druidic
You know Druidic, the secret language of Druids. While learning this ancient tongue, you also unlocked the magic of communicating with animals; you always have the *Speak with Animals* spell prepared.
You can use Druidic to leave hidden messages. You and others who know Druidic automatically spot such a message. Others spot the message's presence with a successful DC 15 Intelligence (Investigation) check but can't decipher it without magic.

### Level 1: Primal Order
You have dedicated yourself to one of the following sacred roles of your choice.
**Magician.** You know one extra cantrip from the Druid spell list. In addition, your mystical connection to nature gives you a bonus to your Intelligence (Arcana or Nature) checks. The bonus equals your Wisdom modifier (minimum bonus of +1).
**Warden.** Trained for battle, you gain proficiency with Martial weapons and training with Medium armor.

### Level 2: Wild Shape
The power of nature allows you to assume the form of an animal. As a Bonus Action, you shape-shift into a Beast form that you have learned for this feature (see "Known Forms" below). You stay in that form for a number of hours equal to half your Druid level or until you use Wild Shape again, have the Incapacitated condition, or die. You can also leave the form early as a Bonus Action.
**Number of Uses.** You can use Wild Shape twice. You regain one expended use when you finish a Short Rest, and you regain all expended uses when you finish a Long Rest.
You gain additional uses when you reach certain Druid levels, as shown in the Wild Shape column of the Druid Features table.
**Known Forms.** You know four Beast forms for this feature, chosen from among Beast stat blocks that have a maximum Challenge Rating of 1/4 and that lack a Fly Speed (see "Animals" in "Monsters" for stat block options). The Rat, Riding Horse, Spider, and Wolf are recommended. Whenever you finish a Long Rest, you can replace one of your known forms with another eligible form.
When you reach certain Druid levels, your number of known forms and the maximum Challenge Rating for those forms increases, as shown in the Beast Shapes table. In addition, starting at level 8, you can adopt a form that has a Fly Speed.
When choosing known forms, you may look in other sources for eligible Beasts if the Game Master permits you to do so.

| Beast Shapes | | | |
| :--- | :--- | :--- | :--- |
| **Druid Level** | **Known Forms** | **Max CR** | **Fly Speed** |
| 2 | 4 | 1/4 | No |
| 4 | 6 | 1/2 | No |
| 8 | 8 | 1 | Yes |

42
System Reference Document 5.2.1

---
**Rules While Shape-Shifted.** While in a form, you retain your personality, memories, and ability to speak, and the following rules apply:
**Temporary Hit Points.** When you assume a Wild Shape form, you gain a number of Temporary Hit Points equal to your Druid level.
**Game Statistics.** Your game statistics are replaced by the Beast's stat block, but you retain your creature type; Hit Points; Hit Point Dice; Intelligence, Wisdom, and Charisma scores; class features; languages; and feats. You also retain your skill and saving throw proficiencies and use your Proficiency Bonus for them, in addition to gaining the proficiencies of the creature. If a skill or saving throw modifier in the Beast's stat block is higher than yours, use the one in the stat block.
**No Spellcasting.** You can't cast spells, but shape-shifting doesn't break your Concentration or otherwise interfere with a spell you've already cast.
**Objects.** Your ability to handle objects is determined by the form's limbs rather than your own. In addition, you choose whether your equipment falls in your space, merges into your new form, or is worn by it. Worn equipment functions as normal, but the GM decides whether it's practical for the new form to wear a piece of equipment based on the creature's size and shape. Your equipment doesn't change size or shape to match the new form, and any equipment that the new form can't wear must either fall to the ground or merge with the form. Equipment that merges with the form has no effect while you're in that form.

### Level 2: Wild Companion
You can summon a nature spirit that assumes an animal form to aid you. As a Magic action, you can expend a spell slot or a use of Wild Shape to cast the *Find Familiar* spell without Material components.
When you cast the spell in this way, the familiar is Fey and disappears when you finish a Long Rest.

### Level 3: Druid Subclass
You gain a Druid subclass of your choice. The Circle of the Land subclass is detailed after this class's description. A subclass is a specialization that grants you features at certain Druid levels. For the rest of your career, you gain each of your subclass's features that are of your Druid level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see "Feats") or another feat of your choice for which you qualify. You gain this feature again at Druid levels 8, 12, and 16.

### Level 5: Wild Resurgence
Once on each of your turns, if you have no uses of Wild Shape left, you can give yourself one use by expending a spell slot (no action required).
In addition, you can expend one use of Wild Shape (no action required) to give yourself a level 1 spell slot, but you can't do so again until you finish a Long Rest.

### Level 7: Elemental Fury
The might of the elements flows through you. You gain one of the following options of your choice.
**Potent Spellcasting.** Add your Wisdom modifier to the damage you deal with any Druid cantrip.
**Primal Strike.** Once on each of your turns when you hit a creature with an attack roll using a weapon or a Beast form's attack in Wild Shape, you can cause the target to take an extra 1d8 Cold, Fire, Lightning, or Thunder damage (choose when you hit).

### Level 15: Improved Elemental Fury
The option you chose for Elemental Fury grows more powerful, as detailed below.
**Potent Spellcasting.** When you cast a Druid cantrip with a range of 10 feet or greater, the spell's range increases by 300 feet.
**Primal Strike.** The extra damage of your Primal Strike increases to 2d8.

### Level 18: Beast Spells
While using Wild Shape, you can cast spells in Beast form, except for any spell that has a Material component with a cost specified or that consumes its Material component.

### Level 19: Epic Boon
You gain an Epic Boon feat (see "Feats") or another feat of your choice for which you qualify. Boon of Dimensional Travel is recommended.

### Level 20: Archdruid
The vitality of nature constantly blooms within you, granting you the following benefits.
**Evergreen Wild Shape.** Whenever you roll Initiative and have no uses of Wild Shape left, you regain one expended use of it.
**Nature Magician.** You can convert uses of Wild Shape into a spell slot (no action required). Choose a number of your unexpended uses of Wild Shape and convert them into a single spell slot, with each use contributing 2 spell levels. For example, if you convert two uses of Wild Shape, you produce a level 4 spell slot. Once you use this benefit, you can't do so again until you finish a Long Rest.
**Longevity.** The primal magic that you wield causes you to age more slowly. For every ten years that pass, your body ages only one year.

43
System Reference Document 5.2.1

---
## Druid Spell List
This section presents the Druid spell list. The spells are organized by spell level and then alphabetized, and each spell's school of magic is listed. In the Special column, C means the spell requires Concentration, R means it's a Ritual, and M means it requires a specific Material component.

### Cantrips (Level 0 Druid Spells)
| Spell | School | Special |
| :--- | :--- | :---: |
| Druidcraft | Transmutation | — |
| Elementalism | Transmutation | — |
| Guidance | Divination | C |
| Mending | Transmutation | — |
| Message | Transmutation | — |
| Poison Spray | Necromancy | — |
| Produce Flame | Conjuration | — |
| Resistance | Abjuration | C |
| Shillelagh | Transmutation | — |
| Spare the Dying | Necromancy | — |
| Starry Wisp | Evocation | — |

### Level 1 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Animal Friendship | Enchantment | — |
| Charm Person | Enchantment | — |
| Create or Destroy Water | Transmutation | — |
| Cure Wounds | Abjuration | — |
| Detect Magic | Divination | C, R |
| Detect Poison and Disease | Divination | C, R |
| Entangle | Conjuration | C |
| Faerie Fire | Evocation | C |
| Fog Cloud | Conjuration | C |
| Goodberry | Conjuration | — |
| Healing Word | Abjuration | — |
| Ice Knife | Conjuration | — |
| Jump | Transmutation | — |
| Longstrider | Transmutation | — |
| Protection from Evil and Good | Abjuration | C, M |
| Purify Food and Drink | Transmutation | R |
| Speak with Animals | Divination | R |
| Thunderwave | Evocation | — |

### Level 2 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Aid | Abjuration | — |
| Animal Messenger | Enchantment | R |
| Augury | Divination | R, M |
| Barkskin | Transmutation | — |
| Continual Flame | Evocation | M |
| Darkvision | Transmutation | — |
| Enhance Ability | Transmutation | C |
| Enlarge/Reduce | Transmutation | C |
| Find Traps | Divination | — |
| Flame Blade | Evocation | C |
| Flaming Sphere | Evocation | C |
| Gust of Wind | Evocation | C |
| Heat Metal | Transmutation | C |
| Hold Person | Enchantment | C |
| Lesser Restoration | Abjuration | — |
| Locate Animals or Plants | Divination | R |
| Locate Object | Divination | C |
| Moonbeam | Evocation | C |
| Pass without Trace | Abjuration | C |
| Protection from Poison | Abjuration | — |
| Spike Growth | Transmutation | C |

### Level 3 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Call Lightning | Conjuration | C |
| Conjure Animals | Conjuration | C |
| Daylight | Evocation | — |
| Dispel Magic | Abjuration | — |
| Meld into Stone | Transmutation | R |
| Plant Growth | Transmutation | — |
| Protection from Energy | Abjuration | C |
| Revivify | Necromancy | M |
| Sleet Storm | Conjuration | C |
| Speak with Plants | Transmutation | — |
| Water Breathing | Transmutation | R |
| Water Walk | Transmutation | R |
| Wind Wall | Evocation | C |

44
System Reference Document 5.2.1

---
### Level 4 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Blight | Necromancy | — |
| Charm Monster | Enchantment | — |
| Confusion | Enchantment | C |
| Conjure Minor Elementals | Conjuration | C |
| Conjure Woodland Beings | Conjuration | C |
| Control Water | Transmutation | C |
| Divination | Divination | R, M |
| Dominate Beast | Enchantment | C |
| Fire Shield | Evocation | — |
| Freedom of Movement | Abjuration | — |
| Giant Insect | Conjuration | C |
| Hallucinatory Terrain | Illusion | — |
| Ice Storm | Evocation | — |
| Locate Creature | Divination | C |
| Polymorph | Transmutation | C |
| Stone Shape | Transmutation | — |
| Stoneskin | Transmutation | C, M |
| Wall of Fire | Evocation | C |

### Level 5 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Antilife Shell | Abjuration | C |
| Awaken | Transmutation | M |
| Commune with Nature | Divination | R |
| Cone of Cold | Evocation | — |
| Conjure Elemental | Conjuration | C |
| Contagion | Necromancy | — |
| Geas | Enchantment | — |
| Greater Restoration | Abjuration | M |
| Insect Plague | Conjuration | C |
| Mass Cure Wounds | Abjuration | — |
| Planar Binding | Abjuration | M |
| Reincarnate | Necromancy | M |
| Scrying | Divination | C, M |
| Tree Stride | Conjuration | C |
| Wall of Stone | Evocation | C |

### Level 6 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Conjure Fey | Conjuration | C |
| Find the Path | Divination | C, M |
| Flesh to Stone | Transmutation | C |
| Heal | Abjuration | — |
| Heroes' Feast | Conjuration | M |
| Move Earth | Transmutation | C |
| Sunbeam | Evocation | C |
| Transport via Plants | Conjuration | — |
| Wall of Thorns | Conjuration | C |
| Wind Walk | Transmutation | — |

### Level 7 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Fire Storm | Evocation | — |
| Mirage Arcane | Illusion | — |
| Plane Shift | Conjuration | M |
| Regenerate | Transmutation | — |
| Reverse Gravity | Transmutation | C |
| Symbol | Abjuration | M |

### Level 8 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Animal Shapes | Transmutation | — |
| Antipathy/Sympathy | Enchantment | — |
| Befuddlement | Enchantment | — |
| Control Weather | Transmutation | C |
| Earthquake | Transmutation | C |
| Incendiary Cloud | Conjuration | C |
| Sunburst | Evocation | — |
| Tsunami | Conjuration | C |

### Level 9 Druid Spells
| Spell | School | Special |
| :--- | :--- | :---: |
| Foresight | Divination | — |
| Shapechange | Transmutation | C, M |
| Storm of Vengeance | Conjuration | C |
| True Resurrection | Necromancy | M |

45
System Reference Document 5.2.1

---
## Druid Subclass: Circle of the Land
*Celebrate Connection to the Natural World*

The Circle of the Land comprises mystics and sages who safeguard ancient knowledge and rites. These Druids meet within sacred circles of trees or standing stones to whisper primal secrets in Druidic. The circle's wisest members preside as the chief priests of their communities.

### Level 3: Circle of the Land Spells
Whenever you finish a Long Rest, choose one type of land: arid, polar, temperate, or tropical. Consult the table below that corresponds to the chosen type; you have the spells listed for your Druid level and lower prepared.

| Arid Land | |
| :--- | :--- |
| **Druid Level** | **Circle Spells** |
| 3 | *Blur*, *Burning Hands*, *Fire Bolt* |
| 5 | *Fireball* |
| 7 | *Blight* |
| 9 | *Wall of Stone* |

| Polar Land | |
| :--- | :--- |
| **Druid Level** | **Circle Spells** |
| 3 | *Fog Cloud*, *Hold Person*, *Ray of Frost* |
| 5 | *Sleet Storm* |
| 7 | *Ice Storm* |
| 9 | *Cone of Cold* |

| Temperate Land | |
| :--- | :--- |
| **Druid Level** | **Circle Spells** |
| 3 | *Misty Step*, *Shocking Grasp*, *Sleep* |
| 5 | *Lightning Bolt* |
| 7 | *Freedom of Movement* |
| 9 | *Tree Stride* |

| Tropical Land | |
| :--- | :--- |
| **Druid Level** | **Circle Spells** |
| 3 | *Acid Splash*, *Ray of Sickness*, *Web* |
| 5 | *Stinking Cloud* |
| 7 | *Polymorph* |
| 9 | *Insect Plague* |

### Level 3: Land's Aid
As a Magic action, you can expend a use of your Wild Shape and choose a point within 60 feet of yourself. Vitality-giving flowers and life-draining thorns appear for a moment in a 10-foot-radius Sphere centered on that point. Each creature of your choice in the Sphere must make a Constitution saving throw against your spell save DC, taking 2d6 Necrotic damage on a failed save or half as much damage on a successful one. One creature of your choice in that area regains 2d6 Hit Points.
The damage and healing increase by 1d6 when you reach Druid levels 10 (3d6) and 14 (4d6).

### Level 6: Natural Recovery
You can cast one of the level 1+ spells that you have prepared from your Circle Spells feature without expending a spell slot, and you must finish a Long Rest before you do so again.
In addition, when you finish a Short Rest, you can choose expended spell slots to recover. The spell slots can have a combined level that is equal to or less than half your Druid level (round up), and none of them can be level 6+. For example, if you're a level 6 Druid, you can recover up to three levels' worth of spell slots. You can recover a level 3 spell slot, a level 2 and a level 1 spell slot, or three level 1 spell slots. Once you recover spell slots with this feature, you can't do so again until you finish a Long Rest.

### Level 10: Nature's Ward
You are immune to the Poisoned condition, and you have Resistance to a damage type associated with your current land choice in the Circle Spells feature, as shown in the Nature's Ward table.

| Nature's Ward | | | |
| :--- | :--- | :--- | :--- |
| **Land Type** | **Resistance** | **Land Type** | **Resistance** |
| Arid | Fire | Temperate | Lightning |
| Polar | Cold | Tropical | Poison |

### Level 14: Nature's Sanctuary
As a Magic action, you can expend a use of your Wild Shape and cause spectral trees and vines to appear in a 15-foot Cube on the ground within 120 feet of yourself. They last there for 1 minute or until you have the Incapacitated condition or die. You and your allies have Half Cover while in that area, and your allies gain the current Resistance of your Nature's Ward while there.
As a Bonus Action, you can move the Cube up to 60 feet to ground within 120 feet of yourself.

46
System Reference Document 5.2.1