# Fighter

## Core Fighter Traits

| | |
| :--- | :--- |
| **Primary Ability** | Strength or Dexterity |
| **Hit Point Die** | D10 per Fighter level |
| **Saving Throw Proficiencies** | Strength and Constitution |
| **Skill Proficiencies** | Choose 2: Acrobatics, Animal Handling, Athletics, History, Insight, Intimidation, Persuasion, Perception, or Survival |
| **Weapon Proficiencies** | Simple and Martial weapons |
| **Armor Training** | Light, Medium, and Heavy armor and Shields |
| **Starting Equipment** | Choose A, B, or C: (A) Chain Mail, Greatsword, Flail, 8 Javelins, Dungeoneer's Pack, and 4 GP; (B) Studded Leather Armor, Scimitar, Shortsword, Longbow, 20 Arrows, Quiver, Dungeoneer's Pack, and 11 GP; or (C) 155 GP |

## Becoming a Fighter ...

### As a Level 1 Character
*   Gain all the traits in the Core Fighter Traits table.
*   Gain the Fighter's level 1 features, which are listed in the Fighter Features table.

### As a Multiclass Character
*   Gain the following traits from the Core Fighter Traits table: Hit Point Die, proficiency with Martial weapons, and training with Light and Medium armor and Shields.
*   Gain the Fighter's level 1 features, which are listed in the Fighter Features table.

## Fighter Class Features
As a Fighter, you gain the following class features when you reach the specified Fighter levels. These features are listed on the Fighter Features table.

### Level 1: Fighting Style
You have honed your martial prowess and gain a Fighting Style feat of your choice (see "Feats"). Defense is recommended.

Whenever you gain a Fighter level, you can replace the feat you chose with a different Fighting Style feat.

## Fighter Features

| Level | Proficiency Bonus | Class Features | Second Wind | Weapon Mastery |
| :---: | :---: | :--- | :---: | :---: |
| 1 | +2 | Fighting Style, Second Wind, Weapon Mastery | 2 | 3 |
| 2 | +2 | Action Surge (one use), Tactical Mind | 2 | 3 |
| 3 | +2 | Fighter Subclass | 2 | 3 |
| 4 | +2 | Ability Score Improvement | 3 | 4 |
| 5 | +3 | Extra Attack, Tactical Shift | 3 | 4 |
| 6 | +3 | Ability Score Improvement | 3 | 4 |
| 7 | +3 | Subclass feature | 3 | 4 |
| 8 | +3 | Ability Score Improvement | 3 | 4 |
| 9 | +4 | Indomitable (one use), Tactical Master | 3 | 4 |
| 10 | +4 | Subclass feature | 4 | 5 |
| 11 | +4 | Two Extra Attacks | 4 | 5 |
| 12 | +4 | Ability Score Improvement | 4 | 5 |
| 13 | +5 | Indomitable (two uses), Studied Attacks | 4 | 5 |
| 14 | +5 | Ability Score Improvement | 4 | 5 |
| 15 | +5 | Subclass feature | 4 | 5 |
| 16 | +5 | Ability Score Improvement | 4 | 6 |
| 17 | +6 | Action Surge (two uses), Indomitable (three uses) | 4 | 6 |
| 18 | +6 | Subclass feature | 4 | 6 |
| 19 | +6 | Epic Boon | 4 | 6 |
| 20 | +6 | Three Extra Attacks | 4 | 6 |

---
47 System Reference Document 5.2.1
---
### Level 1: Second Wind
You have a limited well of physical and mental stamina that you can draw on. As a Bonus Action, you can use it to regain Hit Points equal to 1d10 plus your Fighter level.

You can use this feature twice. You regain one expended use when you finish a Short Rest, and you regain all expended uses when you finish a Long Rest.

When you reach certain Fighter levels, you gain more uses of this feature, as shown in the Second Wind column of the Fighter Features table.

### Level 1: Weapon Mastery
Your training with weapons allows you to use the mastery properties of three kinds of Simple or Martial weapons of your choice. Whenever you finish a Long Rest, you can practice weapon drills and change one of those weapon choices.

When you reach certain Fighter levels, you gain the ability to use the mastery properties of more kinds of weapons, as shown in the Weapon Mastery column of the Fighter Features table.

### Level 2: Action Surge
You can push yourself beyond your normal limits for a moment. On your turn, you can take one additional action, except the Magic action.

Once you use this feature, you can’t do so again until you finish a Short or Long Rest. Starting at level 17, you can use it twice before a rest but only once on a turn.

### Level 2: Tactical Mind
You have a mind for tactics on and off the battlefield. When you fail an ability check, you can expend a use of your Second Wind to push yourself toward success. Rather than regaining Hit Points, you roll 1d10 and add the number rolled to the ability check, potentially turning it into a success. If the check still fails, this use of Second Wind isn’t expended.

### Level 3: Fighter Subclass
You gain a Fighter subclass of your choice. The Champion subclass is detailed after this class’s description. A subclass is a specialization that grants you features at certain Fighter levels. For the rest of your career, you gain each of your subclass’s features that are of your Fighter level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see "Feats") or another feat of your choice for which you qualify. You gain this feature again at Fighter levels 6, 8, 12, 14, and 16.

### Level 5: Extra Attack
You can attack twice instead of once whenever you take the Attack action on your turn.

### Level 5: Tactical Shift
Whenever you activate your Second Wind with a Bonus Action, you can move up to half your Speed without provoking Opportunity Attacks.

### Level 9: Indomitable
If you fail a saving throw, you can reroll it with a bonus equal to your Fighter level. You must use the new roll, and you can’t use this feature again until you finish a Long Rest.

You can use this feature twice before a Long Rest starting at level 13 and three times before a Long Rest starting at level 17.

### Level 9: Tactical Master
When you attack with a weapon whose mastery property you can use, you can replace that property with the Push, Sap, or Slow property for that attack.

### Level 11: Two Extra Attacks
You can attack three times instead of once whenever you take the Attack action on your turn.

### Level 13: Studied Attacks
You study your opponents and learn from each attack you make. If you make an attack roll against a creature and miss, you have Advantage on your next attack roll against that creature before the end of your next turn.

### Level 19: Epic Boon
You gain an Epic Boon feat (see "Feats") or another feat of your choice for which you qualify. Boon of Combat Prowess is recommended.

### Level 20: Three Extra Attacks
You can attack four times instead of once whenever you take the Attack action on your turn.

---
48 System Reference Document 5.2.1
---
# Fighter Subclass: Champion
*Pursue Physical Excellence in Combat*

A Champion focuses on the development of martial prowess in a relentless pursuit of victory. Champions combine rigorous training with physical excellence to deal devastating blows, withstand peril, and garner glory. Whether in athletic contests or bloody battle, Champions strive for the crown of the victor.

### Level 3: Improved Critical
Your attack rolls with weapons and Unarmed Strikes can score a Critical Hit on a roll of 19 or 20 on the d20.

### Level 3: Remarkable Athlete
Thanks to your athleticism, you have Advantage on Initiative rolls and Strength (Athletics) checks.

In addition, immediately after you score a Critical Hit, you can move up to half your Speed without provoking Opportunity Attacks.

### Level 7: Additional Fighting Style
You gain another Fighting Style feat of your choice.

### Level 10: Heroic Warrior
The thrill of battle drives you toward victory. During combat, you can give yourself Heroic Inspiration whenever you start your turn without it.

### Level 15: Superior Critical
Your attack rolls with weapons and Unarmed Strikes can now score a Critical Hit on a roll of 18–20 on the d20.

### Level 18: Survivor
You attain the pinnacle of resilience in battle, giving you these benefits.

**Defy Death.** You have Advantage on Death Saving Throws. Moreover, when you roll 18–20 on a Death Saving Throw, you gain the benefit of rolling a 20 on it.

**Heroic Rally.** At the start of each of your turns, you regain Hit Points equal to 5 plus your Constitution modifier if you are Bloodied and have at least 1 Hit Point.

# Monk

## Core Monk Traits

| | |
| :--- | :--- |
| **Primary Ability** | Dexterity and Wisdom |
| **Hit Point Die** | D8 per Monk level |
| **Saving Throw Proficiencies** | Strength and Dexterity |
| **Skill Proficiencies** | Choose 2: Acrobatics, Athletics, History, Insight, Religion, or Stealth |
| **Weapon Proficiencies** | Simple weapons and Martial weapons that have the Light property |
| **Tool Proficiencies** | Choose one type of Artisan's Tools or Musical Instrument (see "Equipment") |
| **Armor Training** | None |
| **Starting Equipment** | Choose A or B: (A) Spear, 5 Daggers, Artisan's Tools or Musical Instrument chosen for the tool proficiency above, Explorer's Pack, and 11 GP; or (B) 50 GP |

## Becoming a Monk ...

### As a Level 1 Character
*   Gain all the traits in the Core Monk Traits table.
*   Gain the Monk's level 1 features, which are listed in the Monk Features table.

### As a Multiclass Character
*   Gain the Hit Point Die trait from the Core Monk Traits table.
*   Gain the Monk's level 1 features, which are listed in the Monk Features table.

## Monk Class Features
As a Monk, you gain the following class features when you reach the specified Monk levels. These features are listed in the Monk Features table.

---
49 System Reference Document 5.2.1
---
## Monk Features

| Level | Proficiency Bonus | Class Features | Martial Arts | Focus Points | Unarmored Movement |
| :---: | :---: | :--- | :---: | :---: | :---: |
| 1 | +2 | Martial Arts, Unarmed Defense | 1d6 | — | — |
| 2 | +2 | Monk's Focus, Unarmored Movement, Uncanny Metabolism | 1d6 | 2 | +10 ft. |
| 3 | +2 | Deflect Attacks, Monk Subclass | 1d6 | 3 | +10 ft. |
| 4 | +2 | Ability Score Improvement, Slow Fall | 1d6 | 4 | +10 ft. |
| 5 | +3 | Extra Attack, Stunning Strike | 1d8 | 5 | +10 ft. |
| 6 | +3 | Empowered Strikes, Subclass feature | 1d8 | 6 | +15 ft. |
| 7 | +3 | Evasion | 1d8 | 7 | +15 ft. |
| 8 | +3 | Ability Score Improvement | 1d8 | 8 | +15 ft. |
| 9 | +4 | Acrobatic Movement | 1d8 | 9 | +15 ft. |
| 10 | +4 | Heightened Focus, Self-Restoration | 1d8 | 10 | +20 ft. |
| 11 | +4 | Subclass feature | 1d10 | 11 | +20 ft. |
| 12 | +4 | Ability Score Improvement | 1d10 | 12 | +20 ft. |
| 13 | +5 | Deflect Energy | 1d10 | 13 | +20 ft. |
| 14 | +5 | Disciplined Survivor | 1d10 | 14 | +25 ft. |
| 15 | +5 | Perfect Focus | 1d10 | 15 | +25 ft. |
| 16 | +5 | Ability Score Improvement | 1d10 | 16 | +25 ft. |
| 17 | +6 | Subclass feature | 1d12 | 17 | +25 ft. |
| 18 | +6 | Superior Defense | 1d12 | 18 | +30 ft. |
| 19 | +6 | Epic Boon | 1d12 | 19 | +30 ft. |
| 20 | +6 | Body and Mind | 1d12 | 20 | +30 ft. |

### Level 1: Martial Arts
Your practice of martial arts gives you mastery of combat styles that use your Unarmed Strike and Monk weapons, which are the following:

*   Simple Melee weapons
*   Martial Melee weapons that have the Light property

You gain the following benefits while you are unarmed or wielding only Monk weapons and you aren't wearing armor or wielding a Shield.

**Bonus Unarmed Strike.** You can make an Unarmed Strike as a Bonus Action.

**Martial Arts Die.** You can roll 1d6 in place of the normal damage of your Unarmed Strike or Monk weapons. This die changes as you gain Monk levels, as shown in the Martial Arts column of the Monk Features table.

**Dexterous Attacks.** You can use your Dexterity modifier instead of your Strength modifier for the attack and damage rolls of your Unarmed Strikes and Monk weapons. In addition, when you use the Grapple or Shove option of your Unarmed Strike, you can use your Dexterity modifier instead of your Strength modifier to determine the save DC.

### Level 1: Unarmed Defense
While you aren't wearing armor or wielding a Shield, your base Armor Class equals 10 plus your Dexterity and Wisdom modifiers.

### Level 2: Monk's Focus
Your focus and martial training allow you to harness a well of extraordinary energy within yourself. This energy is represented by Focus Points. Your Monk level determines the number of points you have, as shown in the Focus Points column of the Monk Features table.

You can expend these points to enhance or fuel certain Monk features. You start knowing three such features: Flurry of Blows, Patient Defense, and Step of the Wind, each of which is detailed below.

When you expend a Focus Point, it is unavailable until you finish a Short or Long Rest, at the end of which you regain all your expended points.

Some features that use Focus Points require your target to make a saving throw. The save DC equals 8 plus your Wisdom modifier and Proficiency Bonus.

**Flurry of Blows.** You can expend 1 Focus Point to make two Unarmed Strikes as a Bonus Action.

**Patient Defense.** You can take the Disengage action as a Bonus Action. Alternatively, you can expend 1 Focus Point to take both the Disengage and the Dodge actions as a Bonus Action.

---
50 System Reference Document 5.2.1
---
**Step of the Wind.** You can take the Dash action as a Bonus Action. Alternatively, you can expend 1 Focus Point to take both the Disengage and Dash actions as a Bonus Action, and your jump distance is doubled for the turn.

### Level 2: Unarmored Movement
Your speed increases by 10 feet while you aren't wearing armor or wielding a Shield. This bonus increases when you reach certain Monk levels, as shown on the Monk Features table.

### Level 2: Uncanny Metabolism
When you roll Initiative, you can regain all expended Focus Points. When you do so, roll your Martial Arts die, and regain a number of Hit Points equal to your Monk level plus the number rolled.

Once you use this feature, you can’t use it again until you finish a Long Rest.

### Level 3: Deflect Attacks
When an attack roll hits you and its damage includes Bludgeoning, Piercing, or Slashing damage, you can take a Reaction to reduce the attack’s total damage against you. The reduction equals 1d10 plus your Dexterity modifier and Monk level.

If you reduce the damage to 0, you can expend 1 Focus Point to redirect some of the attack’s force. If you do so, choose a creature you can see within 5 feet of yourself if the attack was a melee attack or a creature you can see within 60 feet of yourself that isn’t behind Total Cover if the attack was a ranged attack. That creature must succeed on a Dexterity saving throw or take damage equal to two rolls of your Martial Arts die plus your Dexterity modifier. The damage is the same type dealt by the attack.

### Level 3: Monk Subclass
You gain a Monk subclass of your choice. The Warrior of the Open Hand subclass is detailed after this class’s description. A subclass is a specialization that grants you features at certain Monk levels. For the rest of your career, you gain each of your subclass’s features that are of your Monk level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see “Feats”) or another feat of your choice for which you qualify. You gain this feature again at Monk levels 8, 12, and 16.

### Level 4: Slow Fall
You can take a Reaction when you fall to reduce any damage you take from the fall by an amount equal to five times your Monk level.

### Level 5: Extra Attack
You can attack twice instead of once whenever you take the Attack action on your turn.

### Level 5: Stunning Strike
Once per turn when you hit a creature with a Monk weapon or an Unarmed Strike, you can expend 1 Focus Point to attempt a stunning strike. The target must make a Constitution saving throw. On a failed save, the target has the Stunned condition until the start of your next turn. On a successful save, the target’s Speed is halved until the start of your next turn, and the next attack roll made against the target before then has Advantage.

### Level 6: Empowered Strikes
Whenever you deal damage with your Unarmed Strike, it can deal your choice of Force damage or its normal damage type.

### Level 7: Evasion
When you’re subjected to an effect that allows you to make a Dexterity saving throw to take only half damage, you instead take no damage if you succeed on the saving throw and only half damage if you fail. You don’t benefit from this feature if you have the Incapacitated condition.

### Level 9: Acrobatic Movement
While you aren't wearing armor or wielding a Shield, you gain the ability to move along vertical surfaces and across liquids on your turn without falling during the movement.

### Level 10: Heightened Focus
Your Flurry of Blows, Patient Defense, and Step of the Wind gain the following benefits.

**Flurry of Blows.** You can expend 1 Focus Point to use Flurry of Blows and make three Unarmed Strikes with it instead of two.

---
51 System Reference Document 5.2.1
---
**Patient Defense.** When you expend a Focus Point to use Patient Defense, you gain a number of Temporary Hit Points equal to two rolls of your Martial Arts die.

**Step of the Wind.** When you expend a Focus Point to use Step of the Wind, you can choose a willing creature within 5 feet of yourself that is Large or smaller. You move the creature with you until the end of your turn. The creature’s movement doesn’t provoke Opportunity Attacks.

### Level 10: Self-Restoration
Through sheer force of will, you can remove one of the following conditions from yourself at the end of each of your turns: Charmed, Frightened, or Poisoned.

In addition, forgoing food and drink doesn’t give you levels of Exhaustion.

### Level 13: Deflect Energy
You can now use your Deflect Attacks feature against attacks that deal any damage type, not just Bludgeoning, Piercing, or Slashing.

### Level 14: Disciplined Survivor
Your physical and mental discipline grant you proficiency in all saving throws.

Additionally, whenever you make a saving throw and fail, you can expend 1 Focus Point to reroll it, and you must use the new roll.

### Level 15: Perfect Focus
When you roll Initiative and don’t use Uncanny Metabolism, you regain expended Focus Points until you have 4 if you have 3 or fewer.

### Level 18: Superior Defense
At the start of your turn, you can expend 3 Focus Points to bolster yourself against harm for 1 minute or until you have the Incapacitated condition. During that time, you have Resistance to all damage except Force damage.

### Level 19: Epic Boon
You gain an Epic Boon feat (see “Feats”) or another feat of your choice for which you qualify. Boon of Irresistible Offense is recommended.

### Level 20: Body and Mind
You have developed your body and mind to new heights. Your Dexterity and Wisdom scores increase by 4, to a maximum of 25.

## Monk Subclass: Warrior of the Open Hand
*Master Unarmed Combat Techniques*

Warriors of the Open Hand are masters of unarmed combat. They learn techniques to push and trip their opponents and manipulate their own energy to protect themselves from harm.

### Level 3: Open Hand Technique
Whenever you hit a creature with an attack granted by your Flurry of Blows, you can impose one of the following effects on that target.

**Addle.** The target can’t make Opportunity Attacks until the start of its next turn.

**Push.** The target must succeed on a Strength saving throw or be pushed up to 15 feet away from you.

**Topple.** The target must succeed on a Dexterity saving throw or have the Prone condition.

### Level 6: Wholeness of Body
You gain the ability to heal yourself. As a Bonus Action, you can roll your Martial Arts die. You regain a number of Hit Points equal to the number rolled plus your Wisdom modifier (minimum of 1 Hit Point regained).

You can use this feature a number of times equal to your Wisdom modifier (minimum of once), and you regain all expended uses when you finish a Long Rest.

### Level 11: Fleet Step
When you take a Bonus Action other than Step of the Wind, you can also use Step of the Wind immediately after that Bonus Action.

### Level 17: Quivering Palm
You gain the ability to set up lethal vibrations in someone’s body. When you hit a creature with an Unarmed Strike, you can expend 4 Focus Points to start these imperceptible vibrations, which last for a number of days equal to your Monk level. The vibrations are harmless unless you take an action to end them. Alternatively, when you take the Attack action on your turn, you can forgo one of the attacks to end the vibrations. To end them, you and the target must be on the same plane of existence. When you end them, the target must make a Constitution saving throw, taking 10d12 Force damage on a failed save or half as much damage on a successful one.

You can have only one creature under the effect of this feature at a time. You can end the vibrations harmlessly (no action required).

---
52 System Reference Document 5.2.1
---
# Paladin

## Core Paladin Traits

| | |
| :--- | :--- |
| **Primary Ability** | Strength and Charisma |
| **Hit Point Die** | D10 per Paladin level |
| **Saving Throw Proficiencies** | Wisdom and Charisma |
| **Skill Proficiencies** | Choose 2: Athletics, Insight, Intimidation, Medicine, Persuasion, or Religion |
| **Weapon Proficiencies** | Simple and Martial weapons |
| **Armor Training** | Light, Medium, and Heavy armor and Shields |
| **Starting Equipment** | Choose A or B: (A) Chain Mail, Shield, Longsword, 6 Javelins, Holy Symbol, Priest's Pack, and 9 GP; or (B) 150 GP |

## Becoming a Paladin ...

### As a Level 1 Character
*   Gain all the traits in the Core Paladin Traits table.
*   Gain the Paladin's level 1 features, which are listed in the Paladin Features table.

### As a Multiclass Character
*   Gain the following traits from the Core Paladin Traits table: Hit Point Die, proficiency with Martial weapons, and training with Light and Medium armor and Shields.
*   Gain the Paladin's level 1 features, which are listed in the Paladin Features table. See the multiclassing rules in “Character Creation” to determine your available spell slots.

## Paladin Class Features
As a Paladin, you gain the following class features when you reach the specified Paladin levels. These features are listed in the Paladin Features table.

### Level 1: Lay On Hands
Your blessed touch can heal wounds. You have a pool of healing power that replenishes when you finish a Long Rest. With that pool, you can restore a total number of Hit Points equal to five times your Paladin level.

## Paladin Features

| Level | Proficiency Bonus | Class Features | Channel Divinity | Prepared Spells | Spell Level 1 | Spell Level 2 | Spell Level 3 | Spell Level 4 | Spell Level 5 |
| :---: | :---: | :--- | :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | +2 | Lay On Hands, Spellcasting, Weapon Mastery | — | 2 | 2 | — | — | — | — |
| 2 | +2 | Fighting Style, Paladin's Smite | — | 3 | 2 | — | — | — | — |
| 3 | +2 | Channel Divinity, Paladin Subclass | 2 | 4 | 3 | — | — | — | — |
| 4 | +2 | Ability Score Improvement | 2 | 5 | 3 | — | — | — | — |
| 5 | +3 | Extra Attack, Faithful Steed | 2 | 6 | 4 | 2 | — | — | — |
| 6 | +3 | Aura of Protection | 2 | 6 | 4 | 2 | — | — | — |
| 7 | +3 | Subclass feature | 2 | 7 | 4 | 3 | — | — | — |
| 8 | +3 | Ability Score Improvement | 2 | 7 | 4 | 3 | — | — | — |
| 9 | +4 | Abjure Foes | 2 | 9 | 4 | 3 | 2 | — | — |
| 10 | +4 | Aura of Courage | 2 | 9 | 4 | 3 | 2 | — | — |
| 11 | +4 | Radiant Strikes | 3 | 10 | 4 | 3 | 3 | — | — |
| 12 | +4 | Ability Score Improvement | 3 | 10 | 4 | 3 | 3 | — | — |
| 13 | +5 | — | 3 | 11 | 4 | 3 | 3 | 1 | — |
| 14 | +5 | Restoring Touch | 3 | 11 | 4 | 3 | 3 | 1 | — |
| 15 | +5 | Subclass feature | 3 | 12 | 4 | 3 | 3 | 2 | — |
| 16 | +5 | Ability Score Improvement | 3 | 12 | 4 | 3 | 3 | 2 | — |
| 17 | +6 | — | 3 | 14 | 4 | 3 | 3 | 3 | 1 |
| 18 | +6 | Aura Expansion | 3 | 14 | 4 | 3 | 3 | 3 | 1 |
| 19 | +6 | Epic Boon | 3 | 15 | 4 | 3 | 3 | 3 | 2 |
| 20 | +6 | Subclass feature | 3 | 15 | 4 | 3 | 3 | 3 | 2 |

---
53 System Reference Document 5.2.1
---
As a Bonus Action, you can touch a creature (which could be yourself) and draw power from the pool of healing to restore a number of Hit Points to that creature, up to the maximum amount remaining in the pool.

You can also expend 5 Hit Points from the pool of healing power to remove the Poisoned condition from the creature; those points don’t also restore Hit Points to the creature.

### Level 1: Spellcasting
You have learned to cast spells through prayer and meditation. See “Spells” for the rules on spellcasting. The information below details how you use those rules with Paladin spells, which appear in the Paladin spell list later in the class’s description.

**Spell Slots.** The Paladin Features table shows how many spell slots you have to cast your level 1+ spells. You regain all expended slots when you finish a Long Rest.

**Prepared Spells of Level 1+.** You prepare the list of level 1+ spells that are available for you to cast with this feature. To start, choose two level 1 Paladin spells. *Heroism* and *Searing Smite* are recommended.

The number of spells on your list increases as you gain Paladin levels, as shown in the Prepared Spells column of the Paladin Features table. Whenever that number increases, choose additional Paladin spells until the number of spells on your list matches the number in the Paladin Features table. The chosen spells must be of a level for which you have spell slots. For example, if you’re a level 5 Paladin, your list of prepared spells can include six Paladin spells of level 1 or 2 in any combination.

If another Paladin feature gives you spells that you always have prepared, those spells don’t count against the number of spells you can prepare with this feature, but those spells otherwise count as Paladin spells for you.

**Changing Your Prepared Spells.** Whenever you finish a Long Rest, you can replace one spell on your list with another Paladin spell for which you have spell slots.

**Spellcasting Ability.** Charisma is your spellcasting ability for your Paladin spells.

**Spellcasting Focus.** You can use a Holy Symbol as a Spellcasting Focus for your Paladin spells.

### Level 1: Weapon Mastery
Your training with weapons allows you to use the mastery properties of two kinds of weapons of your choice with which you have proficiency, such as Longswords and Javelins.

Whenever you finish a Long Rest, you can change the kinds of weapons you chose. For example, you could switch to using the mastery properties of Halberds and Flails.

### Level 2: Fighting Style
You gain a Fighting Style feat of your choice (see "Feats" for feats). Instead of choosing one of those feats, you can choose the option below.

**Blessed Warrior.** You learn two Cleric cantrips of your choice (see the Cleric class’s section for a list of Cleric spells). *Guidance* and *Sacred Flame* are recommended. The chosen cantrips count as Paladin spells for you, and Charisma is your spellcasting ability for them. Whenever you gain a Paladin level, you can replace one of these cantrips with another Cleric cantrip.

### Level 2: Paladin's Smite
You always have the *Divine Smite* spell prepared. In addition, you can cast it without expending a spell slot, but you must finish a Long Rest before you can cast it in this way again.

### Level 3: Channel Divinity
You can channel divine energy directly from the Outer Planes, using it to fuel magical effects. You start with one such effect: Divine Sense, which is described below. Other Paladin features give additional Channel Divinity effect options. Each time you use this class’s Channel Divinity, you choose which effect from this class to create.

You can use this class’s Channel Divinity twice. You regain one of its expended uses when you finish a Short Rest, and you regain all expended uses when you finish a Long Rest. You gain an additional use when you reach Paladin level 11.

> **BREAKING YOUR OATH**
> A Paladin tries to hold to the highest standards of conduct, but even the most dedicated are fallible. Sometimes a Paladin transgresses their oath.
>
> A Paladin who has broken a vow typically seeks absolution, spending an all-night vigil as a sign of penitence or undertaking a fast. After a rite of forgiveness, the Paladin starts fresh.
>
> If your Paladin unrepentantly violates their oath, talk to your GM. Your Paladin should probably take a more appropriate subclass or even abandon the class and adopt another one.

---
54 System Reference Document 5.2.1
---
If a Channel Divinity effect requires a saving throw, the DC equals the spell save DC from this class’s Spellcasting feature.

**Divine Sense.** As a Bonus Action, you can open your awareness to detect Celestials, Fiends, and Undead. For the next 10 minutes or until you have the Incapacitated condition, you know the location of any creature of those types within 60 feet of yourself, and you know its creature type. Within the same radius, you also detect the presence of any place or object that has been consecrated or desecrated, as with the *Hallow* spell.

### Level 3: Paladin Subclass
You gain a Paladin subclass of your choice. The Oath of Devotion subclass is detailed after this class’s description. A subclass is a specialization that grants you features at certain Paladin levels. For the rest of your career, you gain each of your subclass’s features that are of your Paladin level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see “Feats”) or another feat of your choice for which you qualify. You gain this feature again at Paladin levels 8, 12, and 16.

### Level 5: Extra Attack
You can attack twice instead of once whenever you take the Attack action on your turn.

### Level 5: Faithful Steed
You can call on the aid of an otherworldly steed. You always have the *Find Steed* spell prepared.

You can also cast the spell once without expending a spell slot, and you regain the ability to do so when you finish a Long Rest.

### Level 6: Aura of Protection
You radiate a protective, unseeable aura in a 10-foot Emanation that originates from you. The aura is inactive while you have the Incapacitated condition.

You and your allies in the aura gain a bonus to saving throws equal to your Charisma modifier (minimum bonus of +1).

If another Paladin is present, a creature can benefit from only one Aura of Protection at a time; the creature chooses which aura while in them.

### Level 9: Abjure Foes
As a Magic action, you can expend one use of this class’s Channel Divinity to overwhelm foes with awe. As you present your Holy Symbol or weapon, you can target a number of creatures equal to your Charisma modifier (minimum of one creature) that you can see within 60 feet of yourself. Each target must succeed on a Wisdom saving throw or have the Frightened condition for 1 minute or until it takes any damage. While Frightened in this way, a target can do only one of the following on its turns: move, take an action, or take a Bonus Action.

### Level 10: Aura of Courage
You and your allies have Immunity to the Frightened condition while in your Aura of Protection. If a Frightened ally enters the aura, that condition has no effect on that ally while there.

### Level 11: Radiant Strikes
Your strikes now carry supernatural power. When you hit a target with an attack roll using a Melee weapon or an Unarmed Strike, the target takes an extra 1d8 Radiant damage.

### Level 14: Restoring Touch
When you use Lay On Hands on a creature, you can also remove one or more of the following conditions from the creature: Blinded, Charmed, Deafened, Frightened, Paralyzed, or Stunned. You must expend 5 Hit Points from the healing pool of Lay On Hands for each of these conditions you remove; those points don’t also restore Hit Points to the creature.

### Level 18: Aura Expansion
Your Aura of Protection is now a 30-foot Emanation.

### Level 19: Epic Boon
You gain an Epic Boon feat (see “Feats”) or another feat of your choice for which you qualify. Boon of Truesight is recommended.

## Paladin Spell List
This section presents the Paladin spell list. The spells are organized by spell level and then alphabetized, and each spell’s school of magic is listed. In the Special column, C means the spell requires Concentration, R means it’s a Ritual, and M means it requires a specific Material component.

### Level 1 Paladin Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Bless | Enchantment | C, M |
| Command | Enchantment | — |
| Cure Wounds | Abjuration | — |
| Detect Evil and Good | Divination | C |
| Detect Magic | Divination | C, R |
| Detect Poison and Disease | Divination | C, R |

---
55 System Reference Document 5.2.1
---
| Spell | School | Special |
| :--- | :--- | :--- |
| Divine Favor | Transmutation | C |
| Divine Smite | Evocation | — |
| Heroism | Enchantment | C |
| Protection from Evil and Good | Abjuration | C, M |
| Purify Food and Drink | Transmutation | R |
| Searing Smite | Evocation | — |
| Shield of Faith | Abjuration | C |

### Level 2 Paladin Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Aid | Abjuration | — |
| Find Steed | Conjuration | — |
| Gentle Repose | Necromancy | R, M |
| Lesser Restoration | Abjuration | — |
| Locate Object | Divination | C |
| Magic Weapon | Transmutation | — |
| Prayer of Healing | Abjuration | — |
| Protection from Poison | Abjuration | — |
| Shining Smite | Transmutation | C |
| Warding Bond | Abjuration | M |
| Zone of Truth | Enchantment | — |

### Level 3 Paladin Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Create Food and Water | Conjuration | — |
| Daylight | Evocation | — |
| Dispel Magic | Abjuration | — |
| Magic Circle | Abjuration | M |
| Remove Curse | Abjuration | — |
| Revivify | Necromancy | M |

### Level 4 Paladin Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Aura of Life | Abjuration | C |
| Banishment | Abjuration | C |
| Death Ward | Abjuration | — |
| Locate Creature | Divination | C |

### Level 5 Paladin Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Dispel Evil and Good | Abjuration | C |
| Geas | Enchantment | — |
| Greater Restoration | Abjuration | M |
| Raise Dead | Necromancy | M |

## Paladin Subclass: Oath of Devotion
*Uphold the Ideals of Justice and Order*

The Oath of Devotion binds Paladins to the ideals of justice and order. These Paladins meet the archetype of the knight in shining armor. They hold themselves to the highest standards of conduct, and some—for better or worse—hold the rest of the world to the same standards.

Many who swear this oath are devoted to gods of law and good and use their gods’ tenets as the measure of personal devotion. Others hold angels as their ideals and incorporate images of angelic wings into their helmets or coats of arms.

These paladins share the following tenets:
*   Let your word be your promise.
*   Protect the weak and never fear to act.
*   Let your honorable deeds be an example.

### Level 3: Oath of Devotion Spells
The magic of your oath ensures you always have certain spells ready; when you reach a Paladin level specified in the Oath of Devotion Spells table, you thereafter always have the listed spells prepared.

**Oath of Devotion Spells**
| Paladin Level | Spells |
| :---: | :--- |
| 3 | *Protection from Evil and Good*, *Shield of Faith* |
| 5 | *Aid*, *Zone of Truth* |
| 9 | *Beacon of Hope*, *Dispel Magic* |
| 13 | *Freedom of Movement*, *Guardian of Faith* |
| 17 | *Commune*, *Flame Strike* |

### Level 3: Sacred Weapon
When you take the Attack action, you can expend one use of your Channel Divinity to imbue one Melee weapon that you are holding with positive energy. For 10 minutes or until you use this feature again, you add your Charisma modifier to attack rolls you make with that weapon (minimum bonus of +1), and each time you hit with it, you cause it to deal its normal damage type or Radiant damage.

The weapon also emits Bright Light in a 20-foot radius and Dim Light 20 feet beyond that.

You can end this effect early (no action required). This effect also ends if you aren’t carrying the weapon.

### Level 7: Aura of Devotion
You and your allies have Immunity to the Charmed condition while in your Aura of Protection. If a Charmed ally enters the aura, that condition has no effect on that ally while there.

---
56 System Reference Document 5.2.1
---
### Level 15: Smite of Protection
Your magical smite now radiates protective energy. Whenever you cast *Divine Smite*, you and your allies have Half Cover while in your Aura of Protection. The aura has this benefit until the start of your next turn.

### Level 20: Holy Nimbus
As a Bonus Action, you can imbue your Aura of Protection with holy power, granting the benefits below for 10 minutes or until you end them (no action required). Once you use this feature, you can’t use it again until you finish a Long Rest. You can also restore your use of it by expending a level 5 spell slot (no action required).

**Holy Ward.** You have Advantage on any saving throw you are forced to make by a Fiend or an Undead.

**Radiant Damage.** Whenever an enemy starts its turn in the aura, that creature takes Radiant damage equal to your Charisma modifier plus your Proficiency Bonus.

**Sunlight.** The aura is filled with Bright Light that is sunlight.

# Ranger

## Core Ranger Traits

| | |
| :--- | :--- |
| **Primary Ability** | Dexterity and Wisdom |
| **Hit Point Die** | D10 per Ranger level |
| **Saving Throw Proficiencies** | Strength and Dexterity |
| **Skill Proficiencies** | Choose 3: Animal Handling, Athletics, Insight, Investigation, Nature, Perception, Stealth, or Survival |
| **Weapon Proficiencies** | Simple and Martial weapons |
| **Armor Training** | Light and Medium armor and Shields |
| **Starting Equipment** | Choose A or B: (A) Studded Leather Armor, Scimitar, Shortsword, Longbow, 20 Arrows, Quiver, Druidic Focus (sprig of mistletoe), Explorer’s Pack, and 7 GP; or (B) 150 GP |

## Becoming a Ranger ...

### As a Level 1 Character
*   Gain all the traits in the Core Ranger Traits table.
*   Gain the Ranger's level 1 features, which are listed in the Ranger Features table.

### As a Multiclass Character
*   Gain the following traits from the Core Ranger Traits table: Hit Point Die, proficiency with Martial weapons, proficiency in one skill of your choice from the Ranger's skill list, and training with Light and Medium armor and Shields.
*   Gain the Ranger's level 1 features, which are listed in the Ranger Features table. See the multiclassing rules in "Character Creation" to determine your available spell slots.

## Ranger Class Features
As a Ranger, you gain the following class features when you reach the specified Ranger levels. These features are listed in the Ranger Features table.

### Level 1: Spellcasting
You have learned to channel the magical essence of nature to cast spells. See "Spells" for the rules on spellcasting. The information below details how you use those rules with Ranger spells, which appear in the Ranger spell list later in the class’s description.

**Spell Slots.** The Ranger Features table shows how many spell slots you have to cast your level 1+ spells. You regain all expended slots when you finish a Long Rest.

---
57 System Reference Document 5.2.1
---
## Ranger Features

| Level | Proficiency Bonus | Class Features | Favored Enemy | Prepared Spells | Spell Level 1 | Spell Level 2 | Spell Level 3 | Spell Level 4 | Spell Level 5 |
| :---: | :---: | :--- | :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | +2 | Spellcasting, Favored Enemy, Weapon Mastery | 2 | 2 | 2 | — | — | — | — |
| 2 | +2 | Deft Explorer, Fighting Style | 2 | 3 | 2 | — | — | — | — |
| 3 | +2 | Ranger Subclass | 2 | 4 | 3 | — | — | — | — |
| 4 | +2 | Ability Score Improvement | 2 | 5 | 3 | — | — | — | — |
| 5 | +3 | Extra Attack | 3 | 6 | 4 | 2 | — | — | — |
| 6 | +3 | Roving | 3 | 6 | 4 | 2 | — | — | — |
| 7 | +3 | Subclass feature | 3 | 7 | 4 | 3 | — | — | — |
| 8 | +3 | Ability Score Improvement | 3 | 7 | 4 | 3 | — | — | — |
| 9 | +4 | Expertise | 4 | 9 | 4 | 3 | 2 | — | — |
| 10 | +4 | Tireless | 4 | 9 | 4 | 3 | 2 | — | — |
| 11 | +4 | Subclass feature | 4 | 10 | 4 | 3 | 3 | — | — |
| 12 | +4 | Ability Score Improvement | 4 | 10 | 4 | 3 | 3 | — | — |
| 13 | +5 | Relentless Hunter | 5 | 11 | 4 | 3 | 3 | 1 | — |
| 14 | +5 | Nature's Veil | 5 | 11 | 4 | 3 | 3 | 1 | — |
| 15 | +5 | Subclass feature | 5 | 12 | 4 | 3 | 3 | 2 | — |
| 16 | +5 | Ability Score Improvement | 5 | 12 | 4 | 3 | 3 | 2 | — |
| 17 | +6 | Precise Hunter | 6 | 14 | 4 | 3 | 3 | 3 | 1 |
| 18 | +6 | Feral Senses | 6 | 14 | 4 | 3 | 3 | 3 | 1 |
| 19 | +6 | Epic Boon | 6 | 15 | 4 | 3 | 3 | 3 | 2 |
| 20 | +6 | Foe Slayer | 6 | 15 | 4 | 3 | 3 | 3 | 2 |

**Prepared Spells of Level 1+.** You prepare the list of level 1+ spells that are available for you to cast with this feature. To start, choose two level 1 Ranger spells. *Cure Wounds* and *Ensnaring Strike* are recommended.

The number of spells on your list increases as you gain Ranger levels, as shown in the Prepared Spells column of the Ranger Features table. Whenever that number increases, choose additional Ranger spells until the number of spells on your list matches the number in the Ranger Features table. The chosen spells must be of a level for which you have spell slots. For example, if you’re a level 5 Ranger, your list of prepared spells can include six Ranger spells of level 1 or 2 in any combination.

If another Ranger feature gives you spells that you always have prepared, those spells don’t count against the number of spells you can prepare with this feature, but those spells otherwise count as Ranger spells for you.

**Changing Your Prepared Spells.** Whenever you finish a Long Rest, you can replace one spell on your list with another Ranger spell for which you have spell slots.

**Spellcasting Ability.** Wisdom is your spellcasting ability for your Ranger spells.

**Spellcasting Focus.** You can use a Druidic Focus as a Spellcasting Focus for your Ranger spells.

### Level 1: Favored Enemy
You always have the *Hunter's Mark* spell prepared. You can cast it twice without expending a spell slot, and you regain all expended uses of this ability when you finish a Long Rest.

The number of times you can cast the spell without a spell slot increases when you reach certain Ranger levels, as shown in the Favored Enemy column of the Ranger Features table.

### Level 1: Weapon Mastery
Your training with weapons allows you to use the mastery properties of two kinds of weapons of your

---
58 System Reference Document 5.2.1
---
choice with which you have proficiency, such as Longbows and Shortswords.

Whenever you finish a Long Rest, you can change the kinds of weapons you chose. For example, you could switch to using the mastery properties of Scimitars and Longswords.

### Level 2: Deft Explorer
Thanks to your travels, you gain the following benefits.

**Expertise.** Choose one of your skill proficiencies with which you lack Expertise. You gain Expertise in that skill.

**Languages.** You know two languages of your choice from the language tables in "Character Creation."

### Level 2: Fighting Style
You gain a Fighting Style feat of your choice (see “Feats”). Instead of choosing one of those feats, you can choose the option below.

**Druidic Warrior.** You learn two Druid cantrips of your choice (see the Druid class’s section for a list of Druid spells). *Guidance* and *Starry Wisp* are recommended. The chosen cantrips count as Ranger spells for you, and Wisdom is your spellcasting ability for them. Whenever you gain a Ranger level, you can replace one of these cantrips with another Druid cantrip.

### Level 3: Ranger Subclass
You gain a Ranger subclass of your choice. The Hunter subclass is detailed after this class’s description. A subclass is a specialization that grants you features at certain Ranger levels. For the rest of your career, you gain each of your subclass’s features that are of your Ranger level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see “Feats”) or another feat of your choice for which you qualify. You gain this feature again at Ranger levels 8, 12, and 16.

### Level 5: Extra Attack
You can attack twice instead of once whenever you take the Attack action on your turn.

### Level 6: Roving
Your Speed increases by 10 feet while you aren’t wearing Heavy armor. You also have a Climb Speed and a Swim Speed equal to your Speed.

### Level 9: Expertise
Choose two of your skill proficiencies with which you lack Expertise. You gain Expertise in those skills.

### Level 10: Tireless
Primal forces now help fuel you on your journeys, granting you the following benefits.

**Temporary Hit Points.** As a Magic action, you can give yourself a number of Temporary Hit Points equal to 1d8 plus your Wisdom modifier (minimum of 1). You can use this action a number of times equal to your Wisdom modifier (minimum of once), and you regain all expended uses when you finish a Long Rest.

**Decrease Exhaustion.** Whenever you finish a Short Rest, your Exhaustion level, if any, decreases by 1.

### Level 13: Relentless Hunter
Taking damage can’t break your Concentration on *Hunter's Mark*.

### Level 14: Nature's Veil
You invoke spirits of nature to magically hide yourself. As a Bonus Action, you can give yourself the Invisible condition until the end of your next turn.

You can use this feature a number of times equal to your Wisdom modifier (minimum of once), and you regain all expended uses when you finish a Long Rest.

### Level 17: Precise Hunter
You have Advantage on attack rolls against the creature currently marked by your *Hunter's Mark*.

### Level 18: Feral Senses
Your connection to the forces of nature grants you Blindsight with a range of 30 feet.

### Level 19: Epic Boon
You gain an Epic Boon feat (see “Feats”) or another feat of your choice for which you qualify. Boon of Dimensional Travel is recommended.

### Level 20: Foe Slayer
The damage die of your *Hunter's Mark* is a d10 rather than a d6.

---
59 System Reference Document 5.2.1
---
# Ranger Spell List
This section presents the Ranger spell list. The spells are organized by spell level and then alphabetized, and each spell’s school of magic is listed. In the Special column, C means the spell requires Concentration, R means it’s a Ritual, and M means it requires a specific Material component.

## Level 1 Ranger Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Alarm | Abjuration | R |
| Animal Friendship | Enchantment | — |
| Cure Wounds | Abjuration | — |
| Detect Magic | Divination | C, R |
| Detect Poison and Disease | Divination | C, R |
| Ensnaring Strike | Conjuration | C |
| Entangle | Conjuration | C |
| Fog Cloud | Conjuration | C |
| Goodberry | Conjuration | — |
| Hunter's Mark | Divination | C |
| Jump | Transmutation | — |
| Longstrider | Transmutation | — |
| Speak with Animals | Divination | R |

## Level 2 Ranger Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Aid | Abjuration | — |
| Animal Messenger | Enchantment | R |
| Barkskin | Transmutation | — |
| Darkvision | Transmutation | — |
| Enhance Ability | Transmutation | C |
| Find Traps | Divination | — |
| Gust of Wind | Evocation | C |
| Lesser Restoration | Abjuration | — |
| Locate Animals or Plants | Divination | R |
| Locate Object | Divination | C |
| Magic Weapon | Transmutation | — |
| Pass without Trace | Abjuration | C |
| Protection from Poison | Abjuration | — |
| Silence | Illusion | C, R |
| Spike Growth | Transmutation | C |

## Level 3 Ranger Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Conjure Animals | Conjuration | C |
| Daylight | Evocation | — |
| Dispel Magic | Abjuration | — |
| Meld into Stone | Transmutation | R |
| Nondetection | Abjuration | M |
| Plant Growth | Transmutation | — |
| Protection from Energy | Abjuration | C |
| Revivify | Necromancy | M |
| Speak with Plants | Transmutation | — |
| Water Breathing | Transmutation | R |
| Water Walk | Transmutation | R |
| Wind Wall | Evocation | C |

## Level 4 Ranger Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Conjure Woodland Beings | Conjuration | C |
| Dominate Beast | Enchantment | C |
| Freedom of Movement | Abjuration | — |
| Locate Creature | Divination | C |
| Stoneskin | Transmutation | C, M |

## Level 5 Ranger Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Commune with Nature | Divination | R |
| Greater Restoration | Abjuration | M |
| Tree Stride | Conjuration | C |

---
60 System Reference Document 5.2.1
---
## Ranger Subclass: Hunter
*Protect Nature and People from Destruction*

You stalk prey in the wilds and elsewhere, using your abilities as a Hunter to protect nature and people everywhere from forces that would destroy them.

### Level 3: Hunter's Lore
You can call on the forces of nature to reveal certain strengths and weaknesses of your prey. While a creature is marked by your *Hunter's Mark*, you know whether that creature has any Immunities, Resistances, or Vulnerabilities, and if the creature has any, you know what they are.

### Level 3: Hunter's Prey
You gain one of the following feature options of your choice. Whenever you finish a Short or Long Rest, you can replace the chosen option with the other one.

**Colossus Slayer.** Your tenacity can wear down even the most resilient foes. When you hit a creature with a weapon, the weapon deals an extra 1d8 damage to the target if it’s missing any of its Hit Points. You can deal this extra damage only once per turn.

**Horde Breaker.** Once on each of your turns when you make an attack with a weapon, you can make another attack with the same weapon against a different creature that is within 5 feet of the original target, that is within the weapon’s range, and that you haven’t attacked this turn.

### Level 7: Defensive Tactics
You gain one of the following feature options of your choice. Whenever you finish a Short or Long Rest, you can replace the chosen option with the other one.

**Escape the Horde.** Opportunity Attacks have Disadvantage against you.

**Multiattack Defense.** When a creature hits you with an attack roll, that creature has Disadvantage on all other attack rolls against you this turn.

### Level 11: Superior Hunter's Prey
Once per turn when you deal damage to a creature marked by your *Hunter's Mark*, you can also deal that spell’s extra damage to a different creature that you can see within 30 feet of the first creature.

### Level 15: Superior Hunter's Defense
When you take damage, you can take a Reaction to give yourself Resistance to that damage and any other damage of the same type until the end of the current turn.

# Rogue

## Core Rogue Traits
| | |
| :--- | :--- |
| **Primary Ability** | Dexterity |
| **Hit Point Die** | D8 per Rogue level |
| **Saving Throw Proficiencies** | Dexterity and Intelligence |
| **Skill Proficiencies** | Choose 4: Acrobatics, Athletics, Deception, Insight, Intimidation, Investigation, Perception, Persuasion, Sleight of Hand, or Stealth |
| **Weapon Proficiencies** | Simple weapons and Martial weapons that have the Finesse or Light property |
| **Tool Proficiencies** | Thieves' Tools |
| **Armor Training** | Light armor |
| **Starting Equipment** | Choose A or B: (A) Leather Armor, 2 Daggers, Shortsword, Shortbow, 20 Arrows, Quiver, Thieves' Tools, Burglar's Pack, and 8 GP; or (B) 100 GP |

## Becoming a Rogue ...

### As a Level 1 Character
*   Gain all the traits in the Core Rogue Traits table.
*   Gain the Rogue's level 1 features, which are listed in the Rogue Features table.

### As a Multiclass Character
*   Gain the following traits from the Core Rogue Traits table: Hit Point Die, proficiency in one skill of your choice from the Rogue’s skill list, proficiency with Thieves’ Tools, and training with Light armor.
*   Gain the Rogue's level 1 features, which are listed in the Rogue Features table.

## Rogue Class Features
As a Rogue, you gain the following class features when you reach the specified Rogue levels. These features are listed in the Rogue Features table.

### Level 1: Expertise
You gain Expertise in two of your skill proficiencies of your choice. Sleight of Hand and Stealth are recommended if you have proficiency in them.

At Rogue level 6, you gain Expertise in two more of your skill proficiencies of your choice.

### Level 1: Sneak Attack
You know how to strike subtly and exploit a foe’s distraction. Once per turn, you can deal an extra 1d6 damage to one creature you hit with an attack

---
61 System Reference Document 5.2.1
---
## Rogue Features

| Level | Proficiency Bonus | Class Features | Sneak Attack |
| :---: | :---: | :--- | :---: |
| 1 | +2 | Expertise, Sneak Attack, Thieves' Cant, Weapon Mastery | 1d6 |
| 2 | +2 | Cunning Action | 1d6 |
| 3 | +2 | Rogue Subclass, Steady Aim | 2d6 |
| 4 | +2 | Ability Score Improvement | 2d6 |
| 5 | +3 | Cunning Strike, Uncanny Dodge | 3d6 |
| 6 | +3 | Expertise | 3d6 |
| 7 | +3 | Evasion, Reliable Talent | 4d6 |
| 8 | +3 | Ability Score Improvement | 4d6 |
| 9 | +4 | Subclass feature | 5d6 |
| 10 | +4 | Ability Score Improvement | 5d6 |
| 11 | +4 | Improved Cunning Strike | 6d6 |
| 12 | +4 | Ability Score Improvement | 6d6 |
| 13 | +5 | Subclass feature | 7d6 |
| 14 | +5 | Devious Strikes | 7d6 |
| 15 | +5 | Slippery Mind | 8d6 |
| 16 | +5 | Ability Score Improvement | 8d6 |
| 17 | +6 | Subclass feature | 9d6 |
| 18 | +6 | Elusive | 9d6 |
| 19 | +6 | Epic Boon | 10d6 |
| 20 | +6 | Stroke of Luck | 10d6 |

roll if you have Advantage on the roll and the attack uses a Finesse or a Ranged weapon. The extra damage’s type is the same as the weapon’s type.

You don’t need Advantage on the attack roll if at least one of your allies is within 5 feet of the target, the ally doesn’t have the Incapacitated condition, and you don’t have Disadvantage on the attack roll.

The extra damage increases as you gain Rogue levels, as shown in the Sneak Attack column of the Rogue Features table.

### Level 1: Thieves' Cant
You picked up various languages in the communities where you plied your roguish talents. You know Thieves’ Cant and one other language of your choice, which you choose from the language tables in “Character Creation.”

### Level 1: Weapon Mastery
Your training with weapons allows you to use the mastery properties of two kinds of weapons of your choice with which you have proficiency, such as Daggers and Shortbows.

Whenever you finish a Long Rest, you can change the kinds of weapons you chose. For example, you could switch to using the mastery properties of Scimitars and Shortswords.

### Level 2: Cunning Action
Your quick thinking and agility allow you to move and act quickly. On your turn, you can take one of the following actions as a Bonus Action: Dash, Disengage, or Hide.

### Level 3: Rogue Subclass
You gain a Rogue subclass of your choice. The Thief subclass is detailed after this class’s description. A subclass is a specialization that grants you features at certain Rogue levels. For the rest of your career, you gain each of your subclass’s features that are of your Rogue level or lower.

### Level 3: Steady Aim
As a Bonus Action, you give yourself Advantage on your next attack roll on the current turn. You can use this feature only if you haven’t moved during this turn, and after you use it, your Speed is 0 until the end of the current turn.

---
62 System Reference Document 5.2.1
---
### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see “Feats”) or another feat of your choice for which you qualify. You gain this feature again at Rogue levels 8, 10, 12, and 16.

### Level 5: Cunning Strike
You’ve developed cunning ways to use your Sneak Attack. When you deal Sneak Attack damage, you can add one of the following Cunning Strike effects. Each effect has a die cost, which is the number of Sneak Attack damage dice you must forgo to add the effect. You remove the die before rolling, and the effect occurs immediately after the attack’s damage is dealt. For example, if you add the Poison effect, remove 1d6 from the Sneak Attack’s damage before rolling.

If a Cunning Strike effect requires a saving throw, the DC equals 8 plus your Dexterity modifier and Proficiency Bonus.

**Poison (Cost: 1d6).** You add a toxin to your strike, forcing the target to make a Constitution saving throw. On a failed save, the target has the Poisoned condition for 1 minute. At the end of each of its turns, the Poisoned target repeats the save, ending the effect on itself on a success.

To use this effect, you must have a Poisoner’s Kit on your person.

**Trip (Cost: 1d6).** If the target is Large or smaller, it must succeed on a Dexterity saving throw or have the Prone condition.

**Withdraw (Cost: 1d6).** Immediately after the attack, you move up to half your Speed without provoking Opportunity Attacks.

### Level 5: Uncanny Dodge
When an attacker that you can see hits you with an attack roll, you can take a Reaction to halve the attack’s damage against you (round down).

### Level 7: Evasion
You can nimbly dodge out of the way of certain dangers. When you’re subjected to an effect that allows you to make a Dexterity saving throw to take only half damage, you instead take no damage if you succeed on the saving throw and only half damage if you fail. You can’t use this feature if you have the Incapacitated condition.

### Level 7: Reliable Talent
Whenever you make an ability check that uses one of your skill or tool proficiencies, you can treat a d20 roll of 9 or lower as a 10.

### Level 11: Improved Cunning Strike
You can use up to two Cunning Strike effects when you deal Sneak Attack damage, paying the die cost for each effect.

### Level 14: Devious Strikes
You’ve practiced new ways to use your Sneak Attack deviously. The following effects are now among your Cunning Strike options.

**Daze (Cost: 2d6).** The target must succeed on a Constitution saving throw, or on its next turn, it can do only one of the following: move or take an action or a Bonus Action.

**Knock Out (Cost: 6d6).** The target must succeed on a Constitution saving throw, or it has the Unconscious condition for 1 minute or until it takes any damage. The Unconscious target repeats the save at the end of each of its turns, ending the effect on itself on a success.

**Obscure (Cost: 3d6).** The target must succeed on a Dexterity saving throw, or it has the Blinded condition until the end of its next turn.

### Level 15: Slippery Mind
Your cunning mind is exceptionally difficult to control. You gain proficiency in Wisdom and Charisma saving throws.

### Level 18: Elusive
You’re so evasive that attackers rarely gain the upper hand against you. No attack roll can have Advantage against you unless you have the Incapacitated condition.

### Level 19: Epic Boon
You gain an Epic Boon feat (see “Feats”) or another feat of your choice for which you qualify. Boon of the Night Spirit is recommended.

### Level 20: Stroke of Luck
You have a marvelous knack for succeeding when you need to. If you fail a D20 Test, you can turn the roll into a 20.

Once you use this feature, you can’t use it again until you finish a Short or Long Rest.

---
63 System Reference Document 5.2.1