This document is a multi-page transcription.

---
### Page 1

## Rogue Subclass: Thief
*Hunt for Treasure as a Classic Adventurer*

A mix of burglar, treasure hunter, and explorer, you are the epitome of an adventurer. In addition to improving your agility and stealth, you gain abilities useful for delving into ruins and getting maximum benefit from the magic items you find there.

### Level 3: Fast Hands
As a Bonus Action, you can do one of the following.
**Sleight of Hand.** Make a Dexterity (Sleight of Hand) check to pick a lock or disarm a trap with Thieves’ Tools or to pick a pocket.
**Use an Object.** Take the Utilize action, or take the Magic action to use a magic item that requires that action.

### Level 3: Second-Story Work
You’ve trained to get into especially hard-to-reach places, granting you these benefits.
**Climber.** You gain a Climb Speed equal to your Speed.
**Jumper.** You can determine your jump distance using your Dexterity rather than your Strength.

### Level 9: Supreme Sneak
You gain the following Cunning Strike option.
**Stealth Attack (Cost: 1d6).** If you have the Hide action’s Invisible condition, this attack doesn’t end that condition on you if you end the turn behind Three-Quarters Cover or Total Cover.

### Level 13: Use Magic Device
You’ve learned how to maximize use of magic items, granting you the following benefits.
**Attunement.** You can attune to up to four magic items at once.
**Charges.** Whenever you use a magic item property that expends charges, roll 1d6. On a roll of 6, you use the property without expending the charges.
**Scrolls.** You can use any *Spell Scroll*, using Intelligence as your spellcasting ability for the spell. If the spell is a cantrip or a level 1 spell, you can cast it reliably. If the scroll contains a higher-level spell, you must first succeed on an Intelligence (Arcana) check (DC 10 plus the spell’s level). On a successful check, you cast the spell from the scroll. On a failed check, the scroll disintegrates.

### Level 17: Thief’s Reflexes
You are adept at laying ambushes and quickly escaping danger. You can take two turns during the first round of any combat. You take your first turn at your normal Initiative and your second turn at your Initiative minus 10.

***

# Sorcerer

| Core Sorcerer Traits | |
| :--- | :--- |
| **Primary Ability** | Charisma |
| **Hit Point Die** | D6 per Sorcerer level |
| **Saving Throw Proficiencies** | Constitution and Charisma |
| **Skill Proficiencies** | Choose 2: Arcana, Deception, Insight, Intimidation, Persuasion, or Religion |
| **Weapon Proficiencies** | Simple weapons |
| **Armor Training** | None |
| **Starting Equipment** | Choose A or B: (A) Spear, 2 Daggers, Arcane Focus (crystal), Dungeoneer's Pack, and 28 GP; or (B) 50 GP |

## Becoming a Sorcerer ...
### As a Level 1 Character
* Gain all the traits in the Core Sorcerer Traits table.
* Gain the Sorcerer’s level 1 features, which are listed in the Sorcerer Features table.

### As a Multiclass Character
* Gain the Hit Point Die from the Core Sorcerer Traits table.
* Gain the Sorcerer’s level 1 features, which are listed in the Sorcerer Features table. See the multiclassing rules in "Character Creation" to determine your available spell slots.

## Sorcerer Class Features
As a Sorcerer, you gain the following class features when you reach the specified Sorcerer levels. These features are listed in the Sorcerer Features table.

### Level 1: Spellcasting
Drawing from your innate magic, you can cast spells. See "Spells" for the rules on spellcasting. The information below details how you use those rules with Sorcerer spells, which appear in the Sorcerer spell list later in the class’s description.

**Cantrips.** You know four Sorcerer cantrips of your choice. *Light, Prestidigitation, Shocking Grasp*, and *Sorcerous Burst* are recommended. Whenever you gain a Sorcerer level, you can replace one of your cantrips from this feature with another Sorcerer cantrip of your choice.
When you reach Sorcerer levels 4 and 10, you learn another Sorcerer cantrip of your choice, as shown in the Cantrips column of the Sorcerer Features table.

**Spell Slots.** The Sorcerer Features table shows how many spell slots you have to cast your level 1+

<br>
64
<br>
System Reference Document 5.2.1

---
### Page 2

## Sorcerer Features

| | Proficiency | | Sorcery | | Prepared | \multicolumn{9}{c}{———Spell Slots per Spell Level———} |
| :---: | :---: | :--- | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| **Level** | **Bonus** | **Class Features** | **Points** | **Cantrips** | **Spells** | **1** | **2** | **3** | **4** | **5** | **6** | **7** | **8** | **9** |
| 1 | +2 | Spellcasting, Innate Sorcery | — | 4 | 2 | 2 | — | — | — | — | — | — | — | — |
| 2 | +2 | Font of Magic, Metamagic | 2 | 4 | 4 | 3 | — | — | — | — | — | — | — | — |
| 3 | +2 | Sorcerer Subclass | 3 | 4 | 6 | 4 | 2 | — | — | — | — | — | — | — |
| 4 | +2 | Ability Score Improvement | 4 | 5 | 7 | 4 | 3 | — | — | — | — | — | — | — |
| 5 | +3 | Sorcerous Restoration | 5 | 5 | 9 | 4 | 3 | 2 | — | — | — | — | — | — |
| 6 | +3 | Subclass feature | 6 | 5 | 10 | 4 | 3 | 3 | — | — | — | — | — | — |
| 7 | +3 | Sorcery Incarnate | 7 | 5 | 11 | 4 | 3 | 3 | 1 | — | — | — | — | — |
| 8 | +3 | Ability Score Improvement | 8 | 5 | 12 | 4 | 3 | 3 | 2 | — | — | — | — | — |
| 9 | +4 | — | 9 | 5 | 14 | 4 | 3 | 3 | 3 | 1 | — | — | — | — |
| 10 | +4 | Metamagic | 10 | 6 | 15 | 4 | 3 | 3 | 3 | 2 | — | — | — | — |
| 11 | +4 | — | 11 | 6 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 12 | +4 | Ability Score Improvement | 12 | 6 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 13 | +5 | — | 13 | 6 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 14 | +5 | Subclass feature | 14 | 6 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 15 | +5 | — | 15 | 6 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 16 | +5 | Ability Score Improvement | 16 | 6 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 17 | +6 | Metamagic | 17 | 6 | 19 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | 1 |
| 18 | +6 | Subclass feature | 18 | 6 | 20 | 4 | 3 | 3 | 3 | 3 | 1 | 1 | 1 | 1 |
| 19 | +6 | Epic Boon | 19 | 6 | 21 | 4 | 3 | 3 | 3 | 3 | 2 | 1 | 1 | 1 |
| 20 | +6 | Arcane Apotheosis | 20 | 6 | 22 | 4 | 3 | 3 | 3 | 3 | 2 | 2 | 1 | 1 |

spells. You regain all expended slots when you finish a Long Rest.

**Prepared Spells of Level 1+**. You prepare the list of level 1+ spells that are available for you to cast with this feature. To start, choose two level 1 Sorcerer spells. *Burning Hands* and *Detect Magic* are recommended.
The number of spells on your list increases as you gain Sorcerer levels, as shown in the Prepared Spells column of the Sorcerer Features table. Whenever that number increases, choose additional Sorcerer spells until the number of spells on your list matches the number in the Sorcerer Features table. The chosen spells must be of a level for which you have spell slots. For example, if you’re a level 3 Sorcerer, your list of prepared spells can include six Sorcerer spells of level 1 or 2 in any combination.
If another Sorcerer feature gives you spells that you always have prepared, those spells don’t count against the number of spells you can prepare with this feature, but those spells otherwise count as Sorcerer spells for you.

**Changing Your Prepared Spells.** Whenever you gain a Sorcerer level, you can replace one spell on your list with another Sorcerer spell for which you have spell slots.

**Spellcasting Ability.** Charisma is your spellcasting ability for your Sorcerer spells.

**Spellcasting Focus.** You can use an Arcane Focus as a Spellcasting Focus for your Sorcerer spells.

### Level 1: Innate Sorcery
An event in your past left an indelible mark on you, infusing you with simmering magic. As a Bonus Action, you can unleash that magic for 1 minute, during which you gain the following benefits:

<br>
65
<br>
System Reference Document 5.2.1

---
### Page 3

* The spell save DC of your Sorcerer spells increases by 1.
* You have Advantage on the attack rolls of Sorcerer spells you cast.

You can use this feature twice, and you regain all expended uses of it when you finish a Long Rest.

### Level 2: Font of Magic
You can tap into the wellspring of magic within yourself. This wellspring is represented by Sorcery Points, which allow you to create a variety of magical effects.
You have 2 Sorcery Points, and you gain more as you reach higher levels, as shown in the Sorcery Points column of the Sorcerer Features table. You can’t have more Sorcery Points than the number shown in the table for your level. You regain all expended Sorcery Points when you finish a Long Rest.
You can use your Sorcery Points to fuel the options below, along with other features, such as Metamagic, that use those points.
**Converting Spell Slots to Sorcery Points.** You can expend a spell slot to gain a number of Sorcery Points equal to the slot’s level (no action required).
**Creating Spell Slots.** As a Bonus Action, you can transform unexpended Sorcery Points into one spell slot. The Creating Spell Slots table shows the cost of creating a spell slot of a given level, and it lists the minimum Sorcerer level you must be to create a slot. You can create a spell slot no higher than level 5.
Any spell slot you create with this feature vanishes when you finish a Long Rest.

| Creating Spell Slots | | |
| :--- | :--- | :--- |
| **Spell Slot Level** | **Sorcery Point Cost** | **Min. Sorcerer Level** |
| 1 | 2 | 2 |
| 2 | 3 | 3 |
| 3 | 5 | 5 |
| 4 | 6 | 7 |
| 5 | 7 | 9 |

### Level 2: Metamagic
Because your magic flows from within, you can alter your spells to suit your needs; you gain two Metamagic options of your choice from "Metamagic Options" later in this class’s description. You use the chosen options to temporarily modify spells you cast. To use an option, you must spend the number of Sorcery Points that it costs.
You can use only one Metamagic option on a spell when you cast it unless otherwise noted in one of those options.
Whenever you gain a Sorcerer level, you can replace one of your Metamagic options with one you don’t know. You gain two more options at Sorcerer level 10 and two more at Sorcerer level 17.

### Level 3: Sorcerer Subclass
You gain a Sorcerer subclass of your choice. The Draconic Sorcery subclass is detailed after this class’s description. A subclass is a specialization that grants you features at certain Sorcerer levels. For the rest of your career, you gain each of your subclass’s features that are of your Sorcerer level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see "Feats") or another feat of your choice for which you qualify. You gain this feature again at Sorcerer levels 8, 12, and 16.

### Level 5: Sorcerous Restoration
When you finish a Short Rest, you can regain expended Sorcery Points, but no more than a number equal to half your Sorcerer level (round down). Once you use this feature, you can’t do so again until you finish a Long Rest.

### Level 7: Sorcery Incarnate
If you have no uses of Innate Sorcery left, you can use it if you spend 2 Sorcery Points when you take the Bonus Action to activate it.
In addition, while your Innate Sorcery feature is active, you can use up to two of your Metamagic options on each spell you cast.

### Level 19: Epic Boon
You gain an Epic Boon feat (see "Feats") or another feat of your choice for which you qualify. Boon of Dimensional Travel is recommended.

### Level 20: Arcane Apotheosis
While your Innate Sorcery feature is active, you can use one Metamagic option on each of your turns without spending Sorcery Points on it.

## Metamagic Options
The following options are available to your Metamagic feature. The options are presented in alphabetical order.

### Careful Spell
*Cost: 1 Sorcery Point*

When you cast a spell that forces other creatures to make a saving throw, you can protect some of those creatures from the spell’s full force. To do so, spend 1 Sorcery Point and choose a number of those creatures up to your Charisma modifier (minimum of one creature). A chosen creature automatically succeeds on its saving throw against the spell, and

<br>
66
<br>
System Reference Document 5.2.1

---
### Page 4

it takes no damage if it would normally take half damage on a successful save.

### Distant Spell
*Cost: 1 Sorcery Point*

When you cast a spell that has a range of at least 5 feet, you can spend 1 Sorcery Point to double the spell’s range. Or when you cast a spell that has a range of Touch, you can spend 1 Sorcery Point to make the spell’s range 30 feet.

### Empowered Spell
*Cost: 1 Sorcery Point*

When you roll damage for a spell, you can spend 1 Sorcery Point to reroll a number of the damage dice up to your Charisma modifier (minimum of one), and you must use the new rolls.
You can use Empowered Spell even if you’ve already used a different Metamagic option during the casting of the spell.

### Extended Spell
*Cost: 1 Sorcery Point*

When you cast a spell that has a duration of 1 minute or longer, you can spend 1 Sorcery Point to double its duration to a maximum duration of 24 hours.
If the affected spell requires Concentration, you have Advantage on any saving throw you make to maintain that Concentration.

### Heightened Spell
*Cost: 2 Sorcery Points*

When you cast a spell that forces a creature to make a saving throw, you can spend 2 Sorcery Points to give one target of the spell Disadvantage on saves against the spell.

### Quickened Spell
*Cost: 2 Sorcery Points*

When you cast a spell that has a casting time of an action, you can spend 2 Sorcery Points to change the casting time to a Bonus Action for this casting. You can’t modify a spell in this way if you’ve already cast a level 1+ spell on the current turn, nor can you cast a level 1+ spell on this turn after modifying a spell in this way.

### Seeking Spell
*Cost: 1 Sorcery Point*

If you make an attack roll for a spell and miss, you can spend 1 Sorcery Point to reroll the d20, and you must use the new roll.
You can use Seeking Spell even if you’ve already used a different Metamagic option during the casting of the spell.

### Subtle Spell
*Cost: 1 Sorcery Point*

When you cast a spell, you can spend 1 Sorcery Point to cast it without any Verbal, Somatic, or Material components, except Material components that are consumed by the spell or that have a cost specified in the spell.

### Transmuted Spell
*Cost: 1 Sorcery Point*

When you cast a spell that deals a type of damage from the following list, you can spend 1 Sorcery Point to change that damage type to one of the other listed types: Acid, Cold, Fire, Lightning, Poison, Thunder.

### Twinned Spell
*Cost: 1 Sorcery Point*

When you cast a spell, such as *Charm Person*, that can be cast with a higher-level spell slot to target an additional creature, you can spend 1 Sorcery Point to increase the spell’s effective level by 1.

## Sorcerer Spell List
This section presents the Sorcerer spell list. The spells are organized by spell level and then alphabetized, and each spell’s school of magic is listed. In the Special column, C means the spell requires Concentration, R means it’s a Ritual, and M means it requires a specific Material component.

### Cantrips (Level 0 Sorcerer Spells)
| Spell | School | Special |
| :--- | :--- | :--- |
| Acid Splash | Evocation | — |
| Chill Touch | Necromancy | — |
| Dancing Lights | Illusion | C |
| Elementalism | Transmutation | — |
| Fire Bolt | Evocation | — |
| Light | Evocation | — |
| Mage Hand | Conjuration | — |
| Mending | Transmutation | — |
| Message | Transmutation | — |
| Minor Illusion | Illusion | — |
| Poison Spray | Necromancy | — |
| Prestidigitation | Transmutation | — |
| Ray of Frost | Evocation | — |
| Shocking Grasp | Evocation | — |
| Sorcerous Burst | Evocation | — |
| True Strike | Divination | — |

<br>
67
<br>
System Reference Document 5.2.1

---
### Page 5

### Level 1 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Burning Hands | Evocation | — |
| Charm Person | Enchantment | — |
| Chromatic Orb | Evocation | M |
| Color Spray | Illusion | — |
| Comprehend Languages | Divination | R |
| Detect Magic | Divination | C, R |
| Disguise Self | Illusion | — |
| Expeditious Retreat | Transmutation | C |
| False Life | Necromancy | — |
| Feather Fall | Transmutation | — |
| Fog Cloud | Conjuration | C |
| Grease | Conjuration | — |
| Ice Knife | Conjuration | — |
| Jump | Transmutation | — |
| Mage Armor | Abjuration | — |
| Magic Missile | Evocation | — |
| Ray of Sickness | Necromancy | — |
| Shield | Abjuration | — |
| Silent Image | Illusion | C |
| Sleep | Enchantment | C |
| Thunderwave | Evocation | — |
| Hold Person | Enchantment | C |
| Invisibility | Illusion | C |
| Knock | Transmutation | — |
| Levitate | Transmutation | C |
| Magic Weapon | Transmutation | — |
| Mirror Image | Illusion | — |
| Misty Step | Conjuration | — |
| Scorching Ray | Evocation | — |
| See Invisibility | Divination | — |
| Shatter | Evocation | — |
| Spider Climb | Transmutation | C |
| Suggestion | Enchantment | C |
| Web | Conjuration | C |

### Level 2 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Alter Self | Transmutation | C |
| Blindness/Deafness | Transmutation | — |
| Blur | Illusion | C |
| Darkness | Evocation | C |
| Darkvision | Transmutation | — |
| Detect Thoughts | Divination | C |
| Dragon's Breath | Transmutation | C |
| Enhance Ability | Transmutation | C |
| Enlarge/Reduce | Transmutation | C |
| Flame Blade | Evocation | C |
| Flaming Sphere | Evocation | C |
| Gust of Wind | Evocation | C |

### Level 3 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Blink | Transmutation | — |
| Clairvoyance | Divination | C, M |
| Counterspell | Abjuration | — |
| Daylight | Evocation | — |
| Dispel Magic | Abjuration | — |
| Fear | Illusion | C |
| Fireball | Evocation | — |
| Fly | Transmutation | C |
| Gaseous Form | Transmutation | C |
| Haste | Transmutation | C |
| Hypnotic Pattern | Illusion | C |
| Lightning Bolt | Evocation | — |
| Major Image | Illusion | C |
| Protection from Energy | Abjuration | C |
| Sleet Storm | Conjuration | C |
| Slow | Transmutation | C |
| Stinking Cloud | Conjuration | C |
| Tongues | Divination | — |
| Vampiric Touch | Necromancy | C |
| Water Breathing | Transmutation | R |
| Water Walk | Transmutation | R |

<br>
68
<br>
System Reference Document 5.2.1

---
### Page 6

### Level 4 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Banishment | Abjuration | C |
| Blight | Necromancy | — |
| Charm Monster | Enchantment | — |
| Confusion | Enchantment | C |
| Dimension Door | Conjuration | — |
| Dominate Beast | Enchantment | C |
| Fire Shield | Evocation | — |
| Greater Invisibility | Illusion | C |
| Ice Storm | Evocation | — |
| Polymorph | Transmutation | C |
| Stoneskin | Transmutation | C, M |
| Vitriolic Sphere | Evocation | — |
| Wall of Fire | Evocation | C |

### Level 5 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Animate Objects | Transmutation | C |
| Arcane Hand | Evocation | C |
| Cloudkill | Conjuration | C |
| Cone of Cold | Evocation | — |
| Creation | Illusion | — |
| Dominate Person | Enchantment | C |
| Hold Monster | Enchantment | C |
| Insect Plague | Conjuration | C |
| Seeming | Illusion | — |
| Telekinesis | Transmutation | C |
| Teleportation Circle | Conjuration | M |
| Wall of Stone | Evocation | C |

### Level 6 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Chain Lightning | Evocation | — |
| Circle of Death | Necromancy | M |
| Disintegrate | Transmutation | — |
| Eyebite | Necromancy | C |
| Flesh to Stone | Transmutation | C |
| Freezing Sphere | Evocation | — |
| Globe of Invulnerability | Abjuration | C |
| Mass Suggestion | Enchantment | — |
| Move Earth | Transmutation | C |
| Sunbeam | Evocation | C |
| True Seeing | Divination | M |

### Level 7 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Delayed Blast Fireball | Evocation | C |
| Etherealness | Conjuration | — |
| Finger of Death | Necromancy | — |
| Fire Storm | Evocation | — |
| Plane Shift | Conjuration | M |
| Prismatic Spray | Evocation | — |
| Reverse Gravity | Transmutation | C |
| Teleport | Conjuration | — |

### Level 8 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Demiplane | Conjuration | — |
| Dominate Monster | Enchantment | C |
| Earthquake | Transmutation | C |
| Incendiary Cloud | Conjuration | C |
| Power Word Stun | Enchantment | — |
| Sunburst | Evocation | — |

### Level 9 Sorcerer Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Gate | Conjuration | C, M |
| Meteor Swarm | Evocation | — |
| Power Word Kill | Enchantment | — |
| Time Stop | Transmutation | — |
| Wish | Conjuration | — |

## Sorcerer Subclass: Draconic Sorcery
*Breathe the Magic of Dragons*

Your innate magic comes from the gift of a dragon. Perhaps an ancient dragon facing death bequeathed some of its magical power to you or your ancestor. You might have absorbed magic from a site infused with dragons’ power. Or perhaps you handled a treasure taken from a dragon’s hoard that was steeped in draconic power. Or you might have a dragon for an ancestor.

### Level 3: Draconic Resilience
The magic in your body manifests physical traits of your draconic gift. Your Hit Point maximum increases by 3, and it increases by 1 whenever you gain another Sorcerer level.
Parts of you are also covered by dragon-like scales. While you aren’t wearing armor, your base Armor Class equals 10 plus your Dexterity and Charisma modifiers.

<br>
69
<br>
System Reference Document 5.2.1

---
### Page 7

### Level 3: Draconic Spells
When you reach a Sorcerer level specified in the Draconic Spells table, you thereafter always have the listed spells prepared.

| Draconic Spells | |
| :--- | :--- |
| **Sorcerer Level** | **Spells** |
| 3 | *Alter Self, Chromatic Orb, Command, Dragon's Breath* |
| 5 | *Fear, Fly* |
| 7 | *Arcane Eye, Charm Monster* |
| 9 | *Legend Lore, Summon Dragon* |

### Level 6: Elemental Affinity
Your draconic magic has an affinity with a damage type associated with dragons. Choose one of those types: Acid, Cold, Fire, Lightning, or Poison.
You have Resistance to that damage type, and when you cast a spell that deals damage of that type, you can add your Charisma modifier to one damage roll of that spell.

### Level 14: Dragon Wings
As a Bonus Action, you can cause draconic wings to appear on your back. The wings last for 1 hour or until you dismiss them (no action required). For the duration, you have a Fly Speed of 60 feet.
Once you use this feature, you can’t use it again until you finish a Long Rest unless you spend 3 Sorcery Points (no action required) to restore your use of it.

### Level 18: Dragon Companion
You can cast *Summon Dragon* without a Material component. You can also cast it once without a spell slot, and you regain the ability to cast it in this way when you finish a Long Rest.
Whenever you start casting the spell, you can modify it so that it doesn’t require Concentration. If you do so, the spell’s duration becomes 1 minute for that casting.

***

# Warlock

| Core Warlock Traits | |
| :--- | :--- |
| **Primary Ability** | Charisma |
| **Hit Point Die** | D8 per Warlock level |
| **Saving Throw Proficiencies** | Wisdom and Charisma |
| **Skill Proficiencies** | Choose 2: Arcana, Deception, History, Intimidation, Investigation, Nature, or Religion |
| **Weapon Proficiencies** | Simple weapons |
| **Armor Training** | Light armor |
| **Starting Equipment** | Choose A or B: (A) Leather Armor, Sickle, 2 Daggers, Arcane Focus (orb), Book (occult lore), Scholar's Pack, and 15 GP; or (B) 100 GP |

## Becoming a Warlock ...
### As a Level 1 Character
* Gain all the traits in the Core Warlock Traits table.
* Gain the Warlock's level 1 features, which are listed in the Warlock Features table.

### As a Multiclass Character
* Gain the following traits from the Core Warlock Traits table: Hit Point Die and training with Light armor.
* Gain the Warlock's level 1 features, which are listed in the Warlock Features table. See the multiclassing rules in "Character Creation" to determine your available spell slots.

## Warlock Class Features
As a Warlock, you gain the following class features when you reach the specified Warlock levels. These features are listed in the Warlock Features table.

### Level 1: Eldritch Invocations
You have unearthed Eldritch Invocations, pieces of forbidden knowledge that imbue you with an abiding magical ability or other lessons. You gain one invocation of your choice, such as Pact of the Tome. Invocations are described in the "Eldritch Invocation Options" section later in this class's description.
**Prerequisites.** If an invocation has a prerequisite, you must meet it to learn that invocation. For example, if an invocation requires you to be a level 5+ Warlock, you can select the invocation once you reach Warlock level 5.
**Replacing and Gaining Invocations.** Whenever you gain a Warlock level, you can replace one of your invocations with another one for which you

<br>
70
<br>
System Reference Document 5.2.1

---
### Page 8

## Warlock Features

| | Proficiency | | Eldritch | | Prepared | Spell | Slot |
| :---: | :---: | :--- | :---: | :---: | :---: | :---: | :---: |
| **Level** | **Bonus** | **Class Features** | **Invocations** | **Cantrips** | **Spells** | **Slots** | **Level** |
| 1 | +2 | Eldritch Invocations, Pact Magic | 1 | 2 | 2 | 1 | 1 |
| 2 | +2 | Magical Cunning | 3 | 2 | 3 | 2 | 1 |
| 3 | +2 | Warlock Subclass | 3 | 2 | 4 | 2 | 2 |
| 4 | +2 | Ability Score Improvement | 3 | 3 | 5 | 2 | 2 |
| 5 | +3 | — | 5 | 3 | 6 | 2 | 3 |
| 6 | +3 | Subclass feature | 5 | 3 | 7 | 2 | 3 |
| 7 | +3 | — | 6 | 3 | 8 | 2 | 4 |
| 8 | +3 | Ability Score Improvement | 6 | 3 | 9 | 2 | 4 |
| 9 | +4 | Contact Patron | 7 | 3 | 10 | 2 | 5 |
| 10 | +4 | Subclass feature | 7 | 4 | 10 | 2 | 5 |
| 11 | +4 | Mystic Arcanum (level 6 spell) | 7 | 4 | 11 | 3 | 5 |
| 12 | +4 | Ability Score Improvement | 8 | 4 | 11 | 3 | 5 |
| 13 | +5 | Mystic Arcanum (level 7 spell) | 8 | 4 | 12 | 3 | 5 |
| 14 | +5 | Subclass feature | 8 | 4 | 12 | 3 | 5 |
| 15 | +5 | Mystic Arcanum (level 8 spell) | 9 | 4 | 13 | 3 | 5 |
| 16 | +5 | Ability Score Improvement | 9 | 4 | 13 | 3 | 5 |
| 17 | +6 | Mystic Arcanum (level 9 spell) | 9 | 4 | 14 | 4 | 5 |
| 18 | +6 | — | 10 | 4 | 14 | 4 | 5 |
| 19 | +6 | Epic Boon | 10 | 4 | 15 | 4 | 5 |
| 20 | +6 | Eldritch Master | 10 | 4 | 15 | 4 | 5 |

qualify. You can’t replace an invocation if it’s a prerequisite for another invocation that you have.
When you gain certain Warlock levels, you gain more invocations of your choice, as shown in the Invocations column of the Warlock Features table.
You can’t pick the same invocation more than once unless its description says otherwise.

### Level 1: Pact Magic
Through occult ceremony, you have formed a pact with a mysterious entity to gain magical powers. The entity is a voice in the shadows—its identity unclear—but its boon to you is concrete: the ability to cast spells. See "Spells” for the rules on spellcasting. The information below details how you use those rules with Warlock spells, which appear in the Warlock spell list later in the class’s description.
**Cantrips.** You know two Warlock cantrips of your choice. *Eldritch Blast* and *Prestidigitation* are recommended. Whenever you gain a Warlock level, you can replace one of your cantrips from this feature with another Warlock cantrip of your choice.
When you reach Warlock levels 4 and 10, you learn another Warlock cantrip of your choice, as shown in the Cantrips column of the Warlock Features table.
**Spell Slots.** The Warlock Features table shows how many spell slots you have to cast your Warlock spells of levels 1–5. The table also shows the level of those slots, all of which are the same level. You regain all expended Pact Magic spell slots when you finish a Short or Long Rest.
For example, when you’re a level 5 Warlock, you have two level 3 spell slots. To cast the level 1 spell *Charm Person*, you must spend one of those slots, and you cast it as a level 3 spell.
**Prepared Spells of Level 1+.** You prepare the list of level 1+ spells that are available for you to cast with this feature. To start, choose two level 1 Warlock spells. *Charm Person* and *Hex* are recommended.
The number of spells on your list increases as you gain Warlock levels, as shown in the Prepared Spells column of the Warlock Features table. Whenever that number increases, choose additional Warlock spells until the number of spells on your list matches the number in the table. The chosen spells must be of a level no higher than what’s shown in the table’s Slot Level column for your level. When you reach level 6, for example, you learn a new Warlock spell, which can be of levels 1–3.
If another Warlock feature gives you spells that you always have prepared, those spells don’t count

<br>
71
<br>
System Reference Document 5.2.1

---
### Page 9

against the number of spells you can prepare with this feature, but those spells otherwise count as Warlock spells for you.
**Changing Your Prepared Spells.** Whenever you gain a Warlock level, you can replace one spell on your list with another Warlock spell of an eligible level.
**Spellcasting Ability.** Charisma is the spellcasting ability for your Warlock spells.
**Spellcasting Focus.** You can use an Arcane Focus as a Spellcasting Focus for your Warlock spells.

### Level 2: Magical Cunning
You can perform an esoteric rite for 1 minute. At the end of it, you regain expended Pact Magic spell slots but no more than a number equal to half your maximum (round up). Once you use this feature, you can’t do so again until you finish a Long Rest.

### Level 3: Warlock Subclass
You gain a Warlock subclass of your choice. The Fiend Patron subclass is detailed after this class’s description. A subclass is a specialization that grants you features at certain Warlock levels. For the rest of your career, you gain each of your subclass’s features that are of your Warlock level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see "Feats") or another feat of your choice for which you qualify. You gain this feature again at Warlock levels 8, 12, and 16.

### Level 9: Contact Patron
In the past, you usually contacted your patron through intermediaries. Now you can communicate directly; you always have the *Contact Other Plane* spell prepared. With this feature, you can cast the spell without expending a spell slot to contact your patron, and you automatically succeed on the spell’s saving throw.
Once you cast the spell with this feature, you can’t do so in this way again until you finish a Long Rest.

### Level 11: Mystic Arcanum
Your patron grants you a magical secret called an arcanum. Choose one level 6 Warlock spell as this arcanum.
You can cast your arcanum spell once without expending a spell slot, and you must finish a Long Rest before you can cast it in this way again.
As shown in the Warlock Features table, you gain another Warlock spell of your choice that can be cast in this way when you reach Warlock levels 13 (level 7 spell), 15 (level 8 spell), and 17 (level 9 spell). You regain all uses of your Mystic Arcanum when you finish a Long Rest.
Whenever you gain a Warlock level, you can replace one of your arcanum spells with another Warlock spell of the same level.

### Level 19: Epic Boon
You gain an Epic Boon feat (see "Feats") or another feat of your choice for which you qualify. Boon of Fate is recommended.

### Level 20: Eldritch Master
When you use your Magical Cunning feature, you regain all your expended Pact Magic spell slots.

## Eldritch Invocation Options
Eldritch Invocation options appear in alphabetical order.

### Agonizing Blast
*Prerequisite: Level 2+ Warlock, a Warlock Cantrip That Deals Damage*
Choose one of your known Warlock cantrips that deals damage. You can add your Charisma modifier to that spell’s damage rolls.
**Repeatable.** You can gain this invocation more than once. Each time you do so, choose a different eligible cantrip.

### Armor of Shadows
You can cast *Mage Armor* on yourself without expending a spell slot.

### Ascendant Step
*Prerequisite: Level 5+ Warlock*
You can cast *Levitate* on yourself without expending a spell slot.

### Devil's Sight
*Prerequisite: Level 2+ Warlock*
You can see normally in Dim Light and Darkness— both magical and nonmagical—within 120 feet of yourself.

### Devouring Blade
*Prerequisite: Level 12+ Warlock, Thirsting Blade Invocation*
The Extra Attack of your Thirsting Blade invocation confers two extra attacks rather than one.

### Eldritch Mind
You have Advantage on Constitution saving throws that you make to maintain Concentration.

### Eldritch Smite
*Prerequisite: Level 5+ Warlock, Pact of the Blade Invocation*
Once per turn when you hit a creature with your pact weapon, you can expend a Pact Magic spell slot to deal an extra 1d8 Force damage to the target,

<br>
72
<br>
System Reference Document 5.2.1

---
### Page 10

plus another 1d8 per level of the spell slot, and you can give the target the Prone condition if it is Huge or smaller.

### Eldritch Spear
*Prerequisite: Level 2+ Warlock, a Warlock Cantrip That Deals Damage*
Choose one of your known Warlock cantrips that deals damage and has a range of 10+ feet. When you cast that spell, its range increases by a number of feet equal to 30 times your Warlock level.
**Repeatable.** You can gain this invocation more than once. Each time you do so, choose a different eligible cantrip.

### Fiendish Vigor
*Prerequisite: Level 2+ Warlock*
You can cast *False Life* on yourself without expending a spell slot. When you cast the spell with this feature, you don’t roll the die for the Temporary Hit Points; you automatically get the highest number on the die.

### Gaze of Two Minds
*Prerequisite: Level 5+ Warlock*
You can use a Bonus Action to touch a willing creature and perceive through its senses until the end of your next turn. As long as the creature is on the same plane of existence as you, you can take a Bonus Action on subsequent turns to maintain this connection, extending the duration until the end of your next turn. The connection ends if you don’t maintain it in this way.
While perceiving through the other creature’s senses, you benefit from any special senses possessed by that creature, and you can cast spells as if you were in your space or the other creature’s space if the two of you are within 60 feet of each other.

### Gift of the Depths
*Prerequisite: Level 5+ Warlock*
You can breathe underwater, and you gain a Swim Speed equal to your Speed.
You can also cast *Water Breathing* once without expending a spell slot. You regain the ability to cast it in this way again when you finish a Long Rest.

### Gift of the Protectors
*Prerequisite: Level 9+ Warlock, Pact of the Tome Invocation*
A new page appears in your Book of Shadows when you conjure it. With your permission, a creature can take an action to write its name on that page, which can contain a number of names equal to your Charisma modifier (minimum of one name).
When any creature whose name is on the page is reduced to 0 Hit Points but not killed outright, the creature magically drops to 1 Hit Point instead.
Once this magic is triggered, no creature can benefit from it until you finish a Long Rest.
As a Magic action, you can erase a name on the page by touching it.

### Investment of the Chain Master
*Prerequisite: Level 5+ Warlock, Pact of the Chain Invocation*
When you cast *Find Familiar*, you infuse the summoned familiar with a measure of your eldritch power, granting the creature the following benefits.
**Aerial or Aquatic.** The familiar gains either a Fly Speed or a Swim Speed (your choice) of 40 feet.
**Quick Attack.** As a Bonus Action, you can command the familiar to take the Attack action.
**Necrotic or Radiant Damage.** Whenever the familiar deals Bludgeoning, Piercing, or Slashing damage, you can make it deal Necrotic or Radiant damage instead.
**Your Save DC.** If the familiar forces a creature to make a saving throw, it uses your spell save DC.
**Resistance.** When the familiar takes damage, you can take a Reaction to grant it Resistance against that damage.

### Lessons of the First Ones
*Prerequisite: Level 2+ Warlock*
You have received knowledge from an elder entity of the multiverse, allowing you to gain one Origin feat of your choice (see "Feats").
**Repeatable.** You can gain this invocation more than once. Each time you do so, choose a different Origin feat.

### Lifedrinker
*Prerequisite: Level 9+ Warlock, Pact of the Blade Invocation*
Once per turn when you hit a creature with your pact weapon, you can deal an extra 1d6 Necrotic, Psychic, or Radiant damage (your choice) to the creature, and you can expend one of your Hit Point Dice to roll it and regain a number of Hit Points equal to the roll plus your Constitution modifier (minimum of 1 Hit Point).

### Mask of Many Faces
*Prerequisite: Level 2+ Warlock*
You can cast *Disguise Self* without expending a spell slot.

### Master of Myriad Forms
*Prerequisite: Level 5+ Warlock*
You can cast *Alter Self* without expending a spell slot.

<br>
73
<br>
System Reference Document 5.2.1

---
### Page 11

### Misty Visions
*Prerequisite: Level 2+ Warlock*
You can cast *Silent Image* without expending a spell slot.

### One with Shadows
*Prerequisite: Level 5+ Warlock*
While you’re in an area of Dim Light or Darkness, you can cast *Invisibility* on yourself without expending a spell slot.

### Otherworldly Leap
*Prerequisite: Level 2+ Warlock*
You can cast *Jump* on yourself without expending a spell slot.

### Pact of the Blade
As a Bonus Action, you can conjure a pact weapon in your hand—a Simple or Martial Melee weapon of your choice with which you bond—or create a bond with a magic weapon you touch; you can’t bond with a magic weapon if someone else is attuned to it or another Warlock is bonded with it. Until the bond ends, you have proficiency with the weapon, and you can use it as a Spellcasting Focus.
Whenever you attack with the bonded weapon, you can use your Charisma modifier for the attack and damage rolls instead of using Strength or Dexterity; and you can cause the weapon to deal Necrotic, Psychic, or Radiant damage or its normal damage type.
Your bond with the weapon ends if you use this feature’s Bonus Action again, if the weapon is more than 5 feet away from you for 1 minute or more, or if you die. A conjured weapon disappears when the bond ends.

### Pact of the Chain
You learn the *Find Familiar* spell and can cast it as a Magic action without expending a spell slot.
When you cast the spell, you choose one of the normal forms for your familiar or one of the following special forms: **Imp, Pseudodragon, Quasit, Skeleton, Sphinx of Wonder, Sprite, or Venomous Snake** (see "Monsters” for the familiar’s stat block).
Additionally, when you take the Attack action, you can forgo one of your own attacks to allow your familiar to make one attack of its own with its Reaction.

### Pact of the Tome
Stitching together strands of shadow, you conjure forth a book in your hand at the end of a Short or Long Rest. This *Book of Shadows* (you determine its appearance) contains eldritch magic that only you can access, granting you the benefits below. The book disappears if you conjure another book with this feature or if you die.
**Cantrips and Rituals.** When the book appears, choose three cantrips, and choose two level 1 spells that have the Ritual tag. The spells can be from any class’s spell list, and they must be spells you don’t already have prepared. While the book is on your person, you have the chosen spells prepared, and they function as Warlock spells for you.
**Spellcasting Focus.** You can use the book as a Spellcasting Focus.

### Repelling Blast
*Prerequisite: Level 2+ Warlock, a Warlock Cantrip That Deals Damage via an Attack Roll*
Choose one of your known Warlock cantrips that requires an attack roll. When you hit a Large or smaller creature with that cantrip, you can push the creature up to 10 feet straight away from you.
**Repeatable.** You can gain this invocation more than once. Each time you do so, choose a different eligible cantrip.

### Thirsting Blade
*Prerequisite: Level 5+ Warlock, Pact of the Blade Invocation*
You gain the Extra Attack feature for your pact weapon only. With that feature, you can attack twice with the weapon instead of once when you take the Attack action on your turn.

### Visions of Distant Realms
*Prerequisite: Level 9+ Warlock*
You can cast *Arcane Eye* without expending a spell slot.

### Whispers of the Grave
*Prerequisite: Level 7+ Warlock*
You can cast *Speak with Dead* without expending a spell slot.

### Witch Sight
*Prerequisite: Level 15+ Warlock*
You have Truesight with a range of 30 feet.

## Warlock Spell List
This section presents the Warlock spell list. The spells are organized by spell level and then alphabetized, and each spell’s school of magic is listed. In the Special column, C means the spell requires Concentration, R means it’s a Ritual, and M means it requires a specific Material component.

<br>
74
<br>
System Reference Document 5.2.1

---
### Page 12

### Cantrips (Level 0 Warlock Spells)
| Spell | School | Special |
| :--- | :--- | :--- |
| Chill Touch | Necromancy | — |
| Eldritch Blast | Evocation | — |
| Mage Hand | Conjuration | — |
| Minor Illusion | Illusion | — |
| Poison Spray | Necromancy | — |
| Prestidigitation | Transmutation | — |
| True Strike | Divination | — |

### Level 1 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Bane | Enchantment | C |
| Charm Person | Enchantment | — |
| Comprehend Languages | Divination | R |
| Detect Magic | Divination | C, R |
| Expeditious Retreat | Transmutation | C |
| Hellish Rebuke | Evocation | — |
| Hex | Enchantment | C |
| Hideous Laughter | Enchantment | C |
| Illusory Script | Illusion | R, M |
| Protection from Evil and Good | Abjuration | C, M |
| Speak with Animals | Divination | R |
| Unseen Servant | Conjuration | R |

### Level 2 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Darkness | Evocation | C |
| Enthrall | Enchantment | C |
| Hold Person | Enchantment | C |
| Invisibility | Illusion | C |
| Mind Spike | Divination | C |
| Mirror Image | Illusion | — |
| Misty Step | Conjuration | — |
| Ray of Enfeeblement | Necromancy | C |
| Spider Climb | Transmutation | C |
| Suggestion | Enchantment | C |

### Level 3 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Counterspell | Abjuration | — |
| Dispel Magic | Abjuration | — |
| Fear | Illusion | C |
| Fly | Transmutation | C |
| Gaseous Form | Transmutation | C |
| Hypnotic Pattern | Illusion | C |
| Magic Circle | Abjuration | M |
| Major Image | Illusion | C |
| Remove Curse | Abjuration | — |
| Tongues | Divination | — |
| Vampiric Touch | Necromancy | C |

### Level 4 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Banishment | Abjuration | C |
| Blight | Necromancy | — |
| Charm Monster | Enchantment | — |
| Dimension Door | Conjuration | — |
| Hallucinatory Terrain | Illusion | — |

### Level 5 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Contact Other Plane | Divination | R |
| Dream | Illusion | — |
| Hold Monster | Enchantment | C |
| Mislead | Illusion | C |
| Planar Binding | Abjuration | M |
| Scrying | Divination | C, M |
| Teleportation Circle | Conjuration | M |

### Level 6 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Circle of Death | Necromancy | M |
| Create Undead | Necromancy | M |
| Eyebite | Necromancy | C |
| True Seeing | Divination | M |

### Level 7 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Etherealness | Conjuration | — |
| Finger of Death | Necromancy | — |
| Forcecage | Evocation | C, M |
| Plane Shift | Conjuration | M |

<br>
75
<br>
System Reference Document 5.2.1

---
### Page 13

### Level 8 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Befuddlement | Enchantment | — |
| Demiplane | Conjuration | — |
| Dominate Monster | Enchantment | C |
| Glibness | Enchantment | — |
| Power Word Stun | Enchantment | — |

### Level 9 Warlock Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Astral Projection | Necromancy | M |
| Foresight | Divination | — |
| Gate | Conjuration | C, M |
| Imprisonment | Abjuration | M |
| Power Word Kill | Enchantment | — |
| True Polymorph | Transmutation | C |
| Weird | Illusion | C |

## Warlock Subclass: Fiend Patron
*Make a Deal with the Lower Planes*

Your pact draws on the Lower Planes, the realms of perdition. You might forge a bargain with a demon lord, an archdevil, or another fiend that is especially mighty. That patron’s aims are evil—the corruption or destruction of all things, ultimately including you—and your path is defined by the extent to which you strive against those aims.

### Level 3: Dark One’s Blessing
When you reduce an enemy to 0 Hit Points, you gain Temporary Hit Points equal to your Charisma modifier plus your Warlock level (minimum of 1 Temporary Hit Point). You also gain this benefit if someone else reduces an enemy within 10 feet of you to 0 Hit Points.

### Level 3: Fiend Spells
The magic of your patron ensures you always have certain spells ready; when you reach a Warlock level specified in the Fiend Spells table, you thereafter always have the listed spells prepared.

| Fiend Spells | |
| :--- | :--- |
| **Warlock Level** | **Spells** |
| 3 | *Burning Hands, Command, Scorching Ray, Suggestion* |
| 5 | *Fireball, Stinking Cloud* |
| 7 | *Fire Shield, Wall of Fire* |
| 9 | *Geas, Insect Plague* |

### Level 6: Dark One's Own Luck
You can call on your fiendish patron to alter fate in your favor. When you make an ability check or a saving throw, you can use this feature to add 1d10 to your roll. You can do so after seeing the roll but before any of the roll’s effects occur.
You can use this feature a number of times equal to your Charisma modifier (minimum of once), but you can use it no more than once per roll. You regain all expended uses when you finish a Long Rest.

### Level 10: Fiendish Resilience
Choose one damage type, other than Force, whenever you finish a Short or Long Rest. You have Resistance to that damage type until you choose a different one with this feature.

### Level 14: Hurl Through Hell
Once per turn when you hit a creature with an attack roll, you can try to instantly transport the target through the Lower Planes. The target must succeed on a Charisma saving throw against your spell save DC, or the target disappears and hurtles through a nightmare landscape. The target takes 8d10 Psychic damage if it isn’t a Fiend, and it has the Incapacitated condition until the end of your next turn, when it returns to the space it previously occupied or the nearest unoccupied space.
Once you use this feature, you can’t use it again until you finish a Long Rest unless you expend a Pact Magic spell slot (no action required) to restore your use of it.

<br>
76
<br>
System Reference Document 5.2.1