# Wizard

## Core Wizard Traits

| Trait | Description |
| :--- | :--- |
| **Primary Ability** | Intelligence |
| **Hit Point Die** | D6 per Wizard level |
| **Saving Throw Proficiencies** | Intelligence and Wisdom |
| **Skill Proficiencies** | Choose 2: Arcana, History, Insight, Investigation, Medicine, Nature, or Religion |
| **Weapon Proficiencies** | Simple weapons |
| **Armor Training** | None |
| **Starting Equipment** | Choose A or B: (A) 2 Daggers, Arcane Focus (Quarterstaff), Robe, Spellbook, Scholar's Pack, and 5 GP; or (B) 55 GP |

## Becoming a Wizard

### As a Level 1 Character
* Gain all the traits in the Core Wizard Traits table.
* Gain the Wizard's level 1 features, which are listed in the Wizard Features table.

### As a Multiclass Character
* Gain the Hit Point Die from the Core Wizard Traits table.
* Gain the Wizard's level 1 features, which are listed in the Wizard Features table. See the multiclassing rules in "Character Creation” to determine your available spell slots.

## Wizard Class Features
As a Wizard, you gain the following class features when you reach the specified Wizard levels. These features are listed in the Wizard Features table.

### Level 1: Spellcasting
As a student of arcane magic, you have learned to cast spells. See "Spells” for the rules on spellcasting. The information below details how you use those rules with Wizard spells, which appear in the Wizard spell list later in the class's description.

**Cantrips.** You know three Wizard cantrips of your choice. Light, Mage Hand, and Ray of Frost are recommended. Whenever you finish a Long Rest, you can replace one of your cantrips from this feature with another Wizard cantrip of your choice.

## Wizard Features

| Level | Proficiency Bonus | Class Features | Cantrips | Prepared Spells | ———Spell Slots per Spell Level——— | | | | | | | | |
| :---: | :---: | :--- | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| | | | | | **1** | **2** | **3** | **4** | **5** | **6** | **7** | **8** | **9** |
| 1 | +2 | Spellcasting, Ritual Adept, Arcane Recovery | 3 | 4 | 2 | — | — | — | — | — | — | — | — |
| 2 | +2 | Scholar | 3 | 5 | 3 | — | — | — | — | — | — | — | — |
| 3 | +2 | Wizard Subclass | 3 | 6 | 4 | 2 | — | — | — | — | — | — | — |
| 4 | +2 | Ability Score Improvement | 4 | 7 | 4 | 3 | — | — | — | — | — | — | — |
| 5 | +3 | Memorize Spell | 4 | 9 | 4 | 3 | 2 | — | — | — | — | — | — |
| 6 | +3 | Subclass feature | 4 | 10 | 4 | 3 | 3 | — | — | — | — | — | — |
| 7 | +3 | — | 4 | 11 | 4 | 3 | 3 | 1 | — | — | — | — | — |
| 8 | +3 | Ability Score Improvement | 4 | 12 | 4 | 3 | 3 | 2 | — | — | — | — | — |
| 9 | +4 | — | 4 | 14 | 4 | 3 | 3 | 3 | 1 | — | — | — | — |
| 10 | +4 | Subclass feature | 5 | 15 | 4 | 3 | 3 | 3 | 2 | — | — | — | — |
| 11 | +4 | — | 5 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 12 | +4 | Ability Score Improvement | 5 | 16 | 4 | 3 | 3 | 3 | 2 | 1 | — | — | — |
| 13 | +5 | — | 5 | 17 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 14 | +5 | Subclass feature | 5 | 18 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | — | — |
| 15 | +5 | — | 5 | 19 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 16 | +5 | Ability Score Improvement | 5 | 21 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | — |
| 17 | +6 | — | 5 | 22 | 4 | 3 | 3 | 3 | 2 | 1 | 1 | 1 | 1 |
| 18 | +6 | Spell Mastery | 5 | 23 | 4 | 3 | 3 | 3 | 3 | 1 | 1 | 1 | 1 |
| 19 | +6 | Epic Boon | 5 | 24 | 4 | 3 | 3 | 3 | 3 | 2 | 1 | 1 | 1 |
| 20 | +6 | Signature Spells | 5 | 25 | 4 | 3 | 3 | 3 | 3 | 2 | 2 | 1 | 1 |

<br>
77
<br>
System Reference Document 5.2.1

---
<!-- Page 78 -->

When you reach Wizard levels 4 and 10, you learn another Wizard cantrip of your choice, as shown in the Cantrips column of the Wizard Features table.

**Spellbook.** Your wizardly apprenticeship culminated in the creation of a unique book: your spellbook. It is a Tiny object that weighs 3 pounds, contains 100 pages, and can be read only by you or someone casting Identify. You determine the book's appearance and materials, such as a gilt-edged tome or a collection of vellum bound with twine.

The book contains the level 1+ spells you know. It starts with six level 1 Wizard spells of your choice. Detect Magic, Feather Fall, Mage Armor, Magic Missile, Sleep, and Thunderwave are recommended.

Whenever you gain a Wizard level after 1, add two Wizard spells of your choice to your spellbook. Each of these spells must be of a level for which you have spell slots, as shown in the Wizard Features table. The spells are the culmination of arcane research you do regularly.

**Spell Slots.** The Wizard Features table shows how many spell slots you have to cast your level 1+ spells. You regain all expended slots when you finish a Long Rest.

**Prepared Spells of Level 1+.** You prepare the list of level 1+ spells that are available for you to cast with this feature. To do so, choose four spells from your spellbook. The chosen spells must be of a level for which you have spell slots.

The number of spells on your list increases as you gain Wizard levels, as shown in the Prepared Spells column of the Wizard Features table. Whenever that number increases, choose additional Wizard spells until the number of spells on your list matches the number in the table. The chosen spells must be of a level for which you have spell slots. For example, if you're a level 3 Wizard, your list of prepared spells can include six spells of levels 1 and 2 in any combination, chosen from your spellbook.

If another Wizard feature gives you spells that you always have prepared, those spells don't count against the number of spells you can prepare with this feature, but those spells otherwise count as Wizard spells for you.

**Changing Your Prepared Spells.** Whenever you finish a Long Rest, you can change your list of prepared spells, replacing any of the spells there with spells from your spellbook.

**Spellcasting Ability.** Intelligence is your spellcasting ability for your Wizard spells.

**Spellcasting Focus.** You can use an Arcane Focus or your spellbook as a Spellcasting Focus for your Wizard spells.

### Level 1: Ritual Adept
You can cast any spell as a Ritual if that spell has the Ritual tag and the spell is in your spellbook. You needn't have the spell prepared, but you must read from the book to cast a spell in this way.

### Level 1: Arcane Recovery
You can regain some of your magical energy by studying your spellbook. When you finish a Short Rest, you can choose expended spell slots to recover. The spell slots can have a combined level equal to no more than half your Wizard level (round up), and none of the slots can be level 6 or higher. For example, if you're a level 4 Wizard, you can recover up to two levels' worth of spell slots, regaining either one level 2 spell slot or two level 1 spell slots.

Once you use this feature, you can't do so again until you finish a Long Rest.

### Level 2: Scholar
While studying magic, you also specialized in another field of study. Choose one of the following skills in which you have proficiency: Arcana, History, Investigation, Medicine, Nature, or Religion. You have Expertise in the chosen skill.

### Level 3: Wizard Subclass
You gain a Wizard subclass of your choice. The Evoker subclass is detailed after this class's description. A subclass is a specialization that grants you features at certain Wizard levels. For the rest

> **EXPANDING AND REPLACING A SPELLBOOK**
> The spells you add to your spellbook as you gain levels reflect your ongoing magical research, but you might find other spells during your adventures that you can add to the book. You could discover a Wizard spell on a Spell Scroll, for example, and then copy it into your spellbook.
>
> **Copying a Spell into the Book.** When you find a level 1+ Wizard spell, you can copy it into your spellbook if it's of a level you can prepare and if you have time to copy it. For each level of the spell, the transcription takes 2 hours and costs 50 GP. Afterward you can prepare the spell like the other spells in your spellbook.
>
> **Copying the Book.** You can copy a spell from your spellbook into another book. This is like copying a new spell into your spellbook but faster, since you already know how to cast the spell. You need spend only 1 hour and 10 GP for each level of the copied spell.
>
> If you lose your spellbook, you can use the same procedure to transcribe the Wizard spells that you have prepared into a new spellbook. Filling out the remainder of the new book requires you to find new spells to do so. For this reason, many wizards keep a backup spellbook.

<br>
78
<br>
System Reference Document 5.2.1

---
<!-- Page 79 -->

of your career, you gain each of your subclass's features that are of your Wizard level or lower.

### Level 4: Ability Score Improvement
You gain the Ability Score Improvement feat (see "Feats") or another feat of your choice for which you qualify. You gain this feature again at Wizard levels 8, 12, and 16.

### Level 5: Memorize Spell
Whenever you finish a Short Rest, you can study your spellbook and replace one of the level 1+ Wizard spells you have prepared for your Spellcasting feature with another level 1+ spell from the book.

### Level 18: Spell Mastery
You have achieved such mastery over certain spells that you can cast them at will. Choose a level 1 and a level 2 spell in your spellbook that have a casting time of an action. You always have those spells prepared, and you can cast them at their lowest level without expending a spell slot. To cast either spell at a higher level, you must expend a spell slot.

Whenever you finish a Long Rest, you can study your spellbook and replace one of those spells with an eligible spell of the same level from the book.

### Level 19: Epic Boon
You gain an Epic Boon feat (see "Feats") or another feat of your choice for which you qualify. Boon of Spell Recall is recommended.

### Level 20: Signature Spells
Choose two level 3 spells in your spellbook as your signature spells. You always have these spells prepared, and you can cast each of them once at level 3 without expending a spell slot. When you do so, you can't cast them in this way again until you finish a Short or Long Rest. To cast either spell at a higher level, you must expend a spell slot.

## Wizard Spell List
This section presents the Wizard spell list. The spells are organized by spell level and then alphabetized, and each spell's school of magic is listed. In the Special column, C means the spell requires Concentration, R means it's a Ritual, and M means it requires a specific Material component.

### Cantrips (Level 0 Wizard Spells)
| Spell | School | Special |
| :--- | :--- | :--- |
| Acid Splash | Evocation | — |
| Chill Touch | Necromancy | — |
| Dancing Lights | Illusion | C |
| Elementalism | Transmutation | — |
| Fire Bolt | Evocation | — |
| Light | Evocation | — |
| Mage Hand | Conjuration | — |
| Mending | Transmutation | — |
| Message | Transmutation | — |
| Minor Illusion | Illusion | — |
| Poison Spray | Necromancy | — |
| Prestidigitation | Transmutation | — |
| Ray of Frost | Evocation | — |
| Shocking Grasp | Evocation | — |
| True Strike | Divination | — |

### Level 1 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Alarm | Abjuration | R |
| Burning Hands | Evocation | — |
| Charm Person | Enchantment | — |
| Chromatic Orb | Evocation | M |
| Color Spray | Illusion | — |
| Comprehend Languages | Divination | R |
| Detect Magic | Divination | C, R |
| Disguise Self | Illusion | — |
| Expeditious Retreat | Transmutation | C |
| False Life | Necromancy | — |
| Feather Fall | Transmutation | — |
| Find Familiar | Conjuration | R, M |
| Floating Disk | Conjuration | R |
| Fog Cloud | Conjuration | C |
| Grease | Conjuration | — |
| Hideous Laughter | Enchantment | C |
| Ice Knife | Conjuration | — |
| Identify | Divination | R, M |
| Illusory Script | Illusion | R, M |
| Jump | Transmutation | — |
| Longstrider | Transmutation | — |
| Mage Armor | Abjuration | — |
| Magic Missile | Evocation | — |
| Protection from Evil and Good | Abjuration | C, M |
| Ray of Sickness | Necromancy | — |
| Shield | Abjuration | — |
| Silent Image | Illusion | C |
| Sleep | Enchantment | C |
| Thunderwave | Evocation | — |
| Unseen Servant | Conjuration | R |

<br>
79
<br>
System Reference Document 5.2.1

---
<!-- Page 80 -->

### Level 2 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Acid Arrow | Evocation | — |
| Alter Self | Transmutation | C |
| Arcane Lock | Abjuration | M |
| Arcanist's Magic Aura | Illusion | — |
| Augury | Divination | R, M |
| Blindness/Deafness | Transmutation | — |
| Blur | Illusion | C |
| Continual Flame | Evocation | M |
| Darkness | Evocation | C |
| Darkvision | Transmutation | — |
| Detect Thoughts | Divination | C |
| Dragon's Breath | Transmutation | C |
| Enhance Ability | Transmutation | C |
| Enlarge/Reduce | Transmutation | C |
| Flaming Sphere | Evocation | C |
| Gentle Repose | Necromancy | R, M |
| Gust of Wind | Evocation | C |
| Hold Person | Enchantment | C |
| Invisibility | Illusion | C |
| Knock | Transmutation | — |
| Levitate | Transmutation | C |
| Locate Object | Divination | C |
| Magic Mouth | Illusion | R, M |
| Magic Weapon | Transmutation | — |
| Mind Spike | Divination | C |
| Mirror Image | Illusion | — |
| Misty Step | Conjuration | — |
| Ray of Enfeeblement | Necromancy | C |
| Rope Trick | Transmutation | — |
| Scorching Ray | Evocation | — |
| See Invisibility | Divination | — |
| Shatter | Evocation | — |
| Spider Climb | Transmutation | C |
| Suggestion | Enchantment | C |
| Web | Conjuration | C |

### Level 3 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Animate Dead | Necromancy | — |
| Bestow Curse | Necromancy | C |
| Blink | Transmutation | — |
| Clairvoyance | Divination | C, M |
| Counterspell | Abjuration | — |
| Dispel Magic | Abjuration | — |
| Fear | Illusion | C |
| Fireball | Evocation | — |
| Fly | Transmutation | C |
| Gaseous Form | Transmutation | C |
| Glyph of Warding | Abjuration | M |
| Haste | Transmutation | C |
| Hypnotic Pattern | Illusion | C |
| Lightning Bolt | Evocation | — |
| Magic Circle | Abjuration | M |
| Major Image | Illusion | C |
| Nondetection | Abjuration | M |
| Phantom Steed | Illusion | R |
| Protection from Energy | Abjuration | C |
| Remove Curse | Abjuration | — |
| Sending | Divination | — |
| Sleet Storm | Conjuration | C |
| Slow | Transmutation | C |
| Speak with Dead | Necromancy | — |
| Stinking Cloud | Conjuration | C |
| Tiny Hut | Evocation | R |
| Tongues | Divination | — |
| Vampiric Touch | Necromancy | C |
| Water Breathing | Transmutation | R |

### Level 4 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Arcane Eye | Divination | C |
| Banishment | Abjuration | C |
| Black Tentacles | Conjuration | C |
| Blight | Necromancy | — |
| Charm Monster | Enchantment | — |
| Confusion | Enchantment | C |
| Conjure Minor Elementals | Conjuration | C |
| Control Water | Transmutation | C |
| Dimension Door | Conjuration | — |
| Divination | Divination | R, M |
| Fabricate | Transmutation | — |
| Faithful Hound | Conjuration | — |
| Fire Shield | Evocation | — |
| Greater Invisibility | Illusion | C |
| Hallucinatory Terrain | Illusion | — |
| Ice Storm | Evocation | — |
| Locate Creature | Divination | C |
| Phantasmal Killer | Illusion | C |

<br>
80
<br>
System Reference Document 5.2.1

---
<!-- Page 81 -->

| Spell | School | Special |
| :--- | :--- | :--- |
| Polymorph | Transmutation | C |
| Private Sanctum | Abjuration | — |
| Resilient Sphere | Abjuration | C |
| Secret Chest | Conjuration | M |
| Stone Shape | Transmutation | — |
| Stoneskin | Transmutation | C, M |
| Vitriolic Sphere | Evocation | — |
| Wall of Fire | Evocation | C |

### Level 5 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Animate Objects | Transmutation | C |
| Arcane Hand | Evocation | C |
| Cloudkill | Conjuration | C |
| Cone of Cold | Evocation | — |
| Conjure Elemental | Conjuration | C |
| Contact Other Plane | Divination | R |
| Creation | Illusion | — |
| Dominate Person | Enchantment | C |
| Dream | Illusion | — |
| Geas | Enchantment | — |
| Hold Monster | Enchantment | C |
| Legend Lore | Divination | M |
| Mislead | Illusion | C |
| Modify Memory | Enchantment | C |
| Passwall | Transmutation | — |
| Planar Binding | Abjuration | M |
| Scrying | Divination | C, M |
| Seeming | Illusion | — |
| Summon Dragon | Conjuration | C, M |
| Telekinesis | Transmutation | C |
| Telepathic Bond | Divination | R |
| Teleportation Circle | Conjuration | M |
| Wall of Force | Evocation | C |
| Wall of Stone | Evocation | C |

### Level 6 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Chain Lightning | Evocation | — |
| Circle of Death | Necromancy | M |
| Contingency | Abjuration | M |
| Create Undead | Necromancy | M |
| Disintegrate | Transmutation | — |
| Eyebite | Necromancy | C |
| Flesh to Stone | Transmutation | C |
| Freezing Sphere | Evocation | — |
| Globe of Invulnerability | Abjuration | C |
| Guards and Wards | Abjuration | M |
| Instant Summons | Conjuration | R, M |
| Irresistible Dance | Enchantment | C |
| Magic Jar | Necromancy | M |
| Mass Suggestion | Enchantment | — |
| Move Earth | Transmutation | C |
| Programmed Illusion | Illusion | M |
| Sunbeam | Evocation | C |
| True Seeing | Divination | M |
| Wall of Ice | Evocation | C |

### Level 7 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Arcane Sword | Evocation | C, M |
| Delayed Blast Fireball | Evocation | C |
| Etherealness | Conjuration | — |
| Finger of Death | Necromancy | — |
| Forcecage | Evocation | C, M |
| Magnificent Mansion | Conjuration | M |
| Mirage Arcane | Illusion | — |
| Plane Shift | Conjuration | M |
| Prismatic Spray | Evocation | — |
| Project Image | Illusion | C, M |
| Reverse Gravity | Transmutation | C |
| Sequester | Transmutation | M |
| Simulacrum | Illusion | M |
| Symbol | Abjuration | M |
| Teleport | Conjuration | — |

<br>
81
<br>
System Reference Document 5.2.1

---
<!-- Page 82 -->

### Level 8 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Antimagic Field | Abjuration | C |
| Antipathy/Sympathy | Enchantment | — |
| Befuddlement | Enchantment | — |
| Clone | Necromancy | M |
| Control Weather | Transmutation | C |
| Demiplane | Conjuration | — |
| Dominate Monster | Enchantment | C |
| Incendiary Cloud | Conjuration | C |
| Maze | Conjuration | C |
| Mind Blank | Abjuration | — |
| Power Word Stun | Enchantment | — |
| Sunburst | Evocation | — |

### Level 9 Wizard Spells
| Spell | School | Special |
| :--- | :--- | :--- |
| Astral Projection | Necromancy | M |
| Foresight | Divination | — |
| Gate | Conjuration | C, M |
| Imprisonment | Abjuration | M |
| Meteor Swarm | Evocation | — |
| Power Word Kill | Enchantment | — |
| Prismatic Wall | Abjuration | — |
| Shapechange | Transmutation | C, M |
| Time Stop | Transmutation | — |
| True Polymorph | Transmutation | C |
| Weird | Illusion | C |
| Wish | Conjuration | — |

## Wizard Subclass: Evoker
*Create Explosive Elemental Effects*

Your studies focus on magic that creates powerful elemental effects such as bitter cold, searing flame, rolling thunder, crackling lightning, and burning acid. Some Evokers find employment in military forces, serving as artillery to blast armies from afar. Others use their power to protect others, while some seek their own gain.

### Level 3: Evocation Savant
Choose two Wizard spells from the Evocation school, each of which must be no higher than level 2, and add them to your spellbook for free.

In addition, whenever you gain access to a new level of spell slots in this class, you can add one Wizard spell from the Evocation school to your spellbook for free. The chosen spell must be of a level for which you have spell slots.

### Level 3: Potent Cantrip
Your damaging cantrips affect even creatures that avoid the brunt of the effect. When you cast a cantrip at a creature and you miss with the attack roll or the target succeeds on a saving throw against the cantrip, the target takes half the cantrip's damage (if any) but suffers no additional effect from the cantrip.

### Level 6: Sculpt Spells
You can create pockets of relative safety within the effects of your evocations. When you cast an Evocation spell that affects other creatures that you can see, you can choose a number of them equal to 1 plus the spell's level. The chosen creatures automatically succeed on their saving throws against the spell, and they take no damage if they would normally take half damage on a successful save.

### Level 10: Empowered Evocation
Whenever you cast a Wizard spell from the Evocation school, you can add your Intelligence modifier to one damage roll of that spell.

### Level 14: Overchannel
You can increase the power of your spells. When you cast a Wizard spell with a spell slot of levels 1–5 that deals damage, you can deal maximum damage with that spell on the turn you cast it.

The first time you do so, you suffer no adverse effect. If you use this feature again before you finish a Long Rest, you take 2d12 Necrotic damage for each level of the spell slot immediately after you cast it. This damage ignores Resistance and Immunity.

Each time you use this feature again before finishing a Long Rest, the Necrotic damage per spell level increases by 1d12.

<br>
82
<br>
System Reference Document 5.2.1

---
<!-- Page 83 -->

# Character Origins
## Character Backgrounds
Your character's background is a collection of characteristics that represent the place and occupation that were most formative before your character embarked on a life of adventure.

### Parts of a Background
A background includes the following parts.

#### Ability Scores
A background lists three of your character's ability scores. Increase one by 2 and another one by 1, or increase all three by 1. None of these increases can raise a score above 20.

#### Feat
A background gives your character a specified Origin feat (described in "Feats").

#### Skill Proficiencies
A background gives your character proficiency in two specified skills.

#### Tool Proficiency
Each background gives a character proficiency with one tool—either a specific tool or one chosen from the Artisan's Tools category. Tools are detailed in "Equipment."

#### Equipment
Each background offers a choice between a package of equipment and 50 GP.

### Background Descriptions
#### Acolyte
**Ability Scores:** Intelligence, Wisdom, Charisma
**Feat:** Magic Initiate (Cleric) (see "Feats")
**Skill Proficiencies:** Insight and Religion
**Tool Proficiency:** Calligrapher's Supplies
**Equipment:** Choose A or B: (A) Calligrapher's Supplies, Book (prayers), Holy Symbol, Parchment (10 sheets), Robe, 8 GP; or (B) 50 GP

#### Criminal
**Ability Scores:** Dexterity, Constitution, Intelligence
**Feat:** Alert (see "Feats")
**Skill Proficiencies:** Sleight of Hand and Stealth
**Tool Proficiency:** Thieves' Tools
**Equipment:** Choose A or B: (A) 2 Daggers, Thieves' Tools, Crowbar, 2 Pouches, Traveler's Clothes, 16 GP; or (B) 50 GP

#### Sage
**Ability Scores:** Constitution, Intelligence, Wisdom
**Feat:** Magic Initiate (Wizard) (see "Feats")
**Skill Proficiencies:** Arcana and History
**Tool Proficiency:** Calligrapher's Supplies
**Equipment:** Choose A or B: (A) Quarterstaff, Calligrapher's Supplies, Book (history), Parchment (8 sheets), Robe, 8 GP; or (B) 50 GP

#### Soldier
**Ability Scores:** Strength, Dexterity, Constitution
**Feat:** Savage Attacker (see "Feats")
**Skill Proficiencies:** Athletics and Intimidation
**Tool Proficiency:** Choose one kind of Gaming Set (see "Equipment")
**Equipment:** Choose A or B: (A) Spear, Shortbow, 20 Arrows, Gaming Set (same as above), Healer's Kit, Quiver, Traveler's Clothes, 14 GP; or (B) 50 GP

## Character Species
When you choose your character's species, you determine whether your character is a human or a member of a fantastical species, such as dragonborn or gnome.

The peoples of the multiverse hail from different worlds and include many kinds of sapient life forms. A player character's species is the set of game traits that an adventurer gains from being one of those life forms.

Some species can trace their origin to a single world, plane of existence, or god, while other species first appeared in multiple realms at once. Whatever a species' genesis, its members have spread across the multiverse and contribute to many different cultures.

Members of most species live for about 80 years, with exceptions noted in the text about the species in "Character Origins." Regardless of life span, members of all species reach physical maturity at about the same age. Your character can be any age that isn't beyond their species' normal life span.

### Parts of a Species
A species includes the following parts.

#### Creature Type
A character's species determines the character's creature type, which is described in "Rules Glossary." Every species in "Character Origins" is Humanoid; playable non-Humanoid species appear in other books.

#### Size
Your character's species determines the character's size. Individuals within a species cover a wide range of heights, and some species include such diversity

<br>
83
<br>
System Reference Document 5.2.1

---
<!-- Page 84 -->

of size that you can choose whether your character is Small or Medium.

#### Speed
Your character's species determines the character's Speed.

#### Special Traits
Each species gives a character special traits— unique characteristics based on the species' physiology or magical nature. When you choose a species, your character gets all the special traits listed for it. Some traits involve making a choice from a handful of options.

### Species Descriptions
#### Dragonborn
**Creature Type:** Humanoid
**Size:** Medium (about 5–7 feet tall)
**Speed:** 30 feet

As a Dragonborn, you have these special traits.

**Draconic Ancestry.** Your lineage stems from a dragon progenitor. Choose the kind of dragon from the Draconic Ancestors table. Your choice affects your Breath Weapon and Damage Resistance traits as well as your appearance.

##### Draconic Ancestors
| Dragon | Damage Type | Dragon | Damage Type |
| :--- | :--- | :--- | :--- |
| Black | Acid | Gold | Fire |
| Blue | Lightning | Green | Poison |
| Brass | Fire | Red | Fire |
| Bronze | Lightning | Silver | Cold |
| Copper | Acid | White | Cold |

**Breath Weapon.** When you take the Attack action on your turn, you can replace one of your attacks with an exhalation of magical energy in either a 15-foot Cone or a 30-foot Line that is 5 feet wide (choose the shape each time). Each creature in that area must make a Dexterity saving throw (DC 8 plus your Constitution modifier and Proficiency Bonus). On a failed save, a creature takes 1d10 damage of the type determined by your Draconic Ancestry trait. On a successful save, a creature takes half as much damage. This damage increases by 1d10 when you reach character levels 5 (2d10), 11 (3d10), and 17 (4d10).

You can use this Breath Weapon a number of times equal to your Proficiency Bonus, and you regain all expended uses when you finish a Long Rest.

**Damage Resistance.** You have Resistance to the damage type determined by your Draconic Ancestry trait.

**Darkvision.** You have Darkvision with a range of 60 feet.

**Draconic Flight.** When you reach character level 5, you can channel draconic magic to give yourself temporary flight. As a Bonus Action, you sprout spectral wings on your back that last for 10 minutes or until you retract the wings (no action required) or have the Incapacitated condition. During that time, you have a Fly Speed equal to your Speed. Your wings appear to be made of the same energy as your Breath Weapon. Once you use this trait, you can't use it again until you finish a Long Rest.

#### Dwarf
**Creature Type:** Humanoid
**Size:** Medium (about 4–5 feet tall)
**Speed:** 30 feet

As a Dwarf, you have these special traits.

**Darkvision.** You have Darkvision with a range of 120 feet.

**Dwarven Resilience.** You have Resistance to Poison damage. You also have Advantage on saving throws you make to avoid or end the Poisoned condition.

**Dwarven Toughness.** Your Hit Point maximum increases by 1, and it increases by 1 again whenever you gain a level.

**Stonecunning.** As a Bonus Action, you gain Tremorsense with a range of 60 feet for 10 minutes. You must be on a stone surface or touching a stone surface to use this Tremorsense. The stone can be natural or worked.

You can use this Bonus Action a number of times equal to your Proficiency Bonus, and you regain all expended uses when you finish a Long Rest.

#### Elf
**Creature Type:** Humanoid
**Size:** Medium (about 5–6 feet tall)
**Speed:** 30 feet

As an Elf, you have these special traits.

**Darkvision.** You have Darkvision with a range of 60 feet.

**Elven Lineage.** You are part of a lineage that grants you supernatural abilities. Choose a lineage from the Elven Lineages table. You gain the level 1 benefit of that lineage.

When you reach character levels 3 and 5, you learn a higher-level spell, as shown on the table. You always have that spell prepared. You can cast it once without a spell slot, and you regain the ability to cast it in that way when you finish a Long Rest. You can also cast the spell using any spell slots you have of the appropriate level.

<br>
84
<br>
System Reference Document 5.2.1

---
<!-- Page 85 -->

##### Elven Lineages
| Lineage | Level 1 | Level 3 | Level 5 |
| :--- | :--- | :--- | :--- |
| Drow | The range of your Darkvision increases to 120 feet. You also know the Dancing Lights cantrip. | Faerie Fire | Darkness |
| High Elf | You know the Prestidigitation cantrip. Whenever you finish a Long Rest, you can replace that cantrip with a different cantrip from the Wizard spell list. | Detect Magic | Misty Step |
| Wood Elf | Your Speed increases to 35 feet. You also know the Druidcraft cantrip. | Longstrider | Pass without Trace |

Intelligence, Wisdom, or Charisma is your spellcasting ability for the spells you cast with this trait (choose the ability when you select the lineage).

**Fey Ancestry.** You have Advantage on saving throws you make to avoid or end the Charmed condition.

**Keen Senses.** You have proficiency in the Insight, Perception, or Survival skill.

**Trance.** You don't need to sleep, and magic can't put you to sleep. You can finish a Long Rest in 4 hours if you spend those hours in a trancelike meditation, during which you retain consciousness.

#### Gnome
**Creature Type:** Humanoid
**Size:** Small (about 3–4 feet tall)
**Speed:** 30 feet

As a Gnome, you have these special traits.

**Darkvision.** You have Darkvision with a range of 60 feet.

**Gnomish Cunning.** You have Advantage on Intelligence, Wisdom, and Charisma saving throws.

**Gnomish Lineage.** You are part of a lineage that grants you supernatural abilities. Choose one of the following options; whichever one you choose, Intelligence, Wisdom, or Charisma is your spellcasting ability for the spells you cast with this trait (choose the ability when you select the lineage):

**Forest Gnome.** You know the Minor Illusion cantrip. You also always have the Speak with Animals spell prepared. You can cast it without a spell slot a number of times equal to your Proficiency Bonus, and you regain all expended uses when you finish a Long Rest. You can also use any spell slots you have to cast the spell.

**Rock Gnome.** You know the Mending and Prestidigitation cantrips. In addition, you can spend 10 minutes casting Prestidigitation to create a Tiny clockwork device (AC 5, 1 HP), such as a toy, fire starter, or music box. When you create the device, you determine its function by choosing one effect from Prestidigitation; the device produces that effect whenever you or another creature takes a Bonus Action to activate it with a touch. If the chosen effect has options within it, you choose one of those options for the device when you create it. For example, if you choose the spell's ignite-extinguish effect, you determine whether the device ignites or extinguishes fire; the device doesn't do both. You can have three such devices in existence at a time, and each falls apart 8 hours after its creation or when you dismantle it with a touch as a Utilize action.

#### Goliath
**Creature Type:** Humanoid
**Size:** Medium (about 7–8 feet tall)
**Speed:** 35 feet

As a Goliath, you have these special traits.

**Giant Ancestry.** You are descended from Giants. Choose one of the following benefits—a supernatural boon from your ancestry; you can use the chosen benefit a number of times equal to your Proficiency Bonus, and you regain all expended uses when you finish a Long Rest:

**Cloud's Jaunt (Cloud Giant).** As a Bonus Action, you magically teleport up to 30 feet to an unoccupied space you can see.

**Fire's Burn (Fire Giant).** When you hit a target with an attack roll and deal damage to it, you can also deal 1d10 Fire damage to that target.

**Frost's Chill (Frost Giant).** When you hit a target with an attack roll and deal damage to it, you can also deal 1d6 Cold damage to that target and reduce its Speed by 10 feet until the start of your next turn.

**Hill's Tumble (Hill Giant).** When you hit a Large or smaller creature with an attack roll and deal damage to it, you can give that target the Prone condition.

**Stone's Endurance (Stone Giant).** When you take damage, you can take a Reaction to roll 1d12. Add your Constitution modifier to the number rolled and reduce the damage by that total.

<br>
85
<br>
System Reference Document 5.2.1

---
<!-- Page 86 -->

**Storm's Thunder (Storm Giant).** When you take damage from a creature within 60 feet of you, you can take a Reaction to deal 1d8 Thunder damage to that creature.

**Large Form.** Starting at character level 5, you can change your size to Large as a Bonus Action if you're in a big enough space. This transformation lasts for 10 minutes or until you end it (no action required). For that duration, you have Advantage on Strength checks, and your Speed increases by 10 feet. Once you use this trait, you can't use it again until you finish a Long Rest.

**Powerful Build.** You have Advantage on any ability check you make to end the Grappled condition. You also count as one size larger when determining your carrying capacity.

#### Halfling
**Creature Type:** Humanoid
**Size:** Small (about 2–3 feet tall)
**Speed:** 30 feet

As a Halfling, you have these special traits.

**Brave.** You have Advantage on saving throws you make to avoid or end the Frightened condition.

**Halfling Nimbleness.** You can move through the space of any creature that is a size larger than you, but you can't stop in the same space.

**Luck.** When you roll a 1 on the d20 of a D20 Test, you can reroll the die, and you must use the new roll.

**Naturally Stealthy.** You can take the Hide action even when you are obscured only by a creature that is at least one size larger than you.

#### Human
**Creature Type:** Humanoid
**Size:** Medium (about 4–7 feet tall) or Small (about 2–4 feet tall), chosen when you select this species
**Speed:** 30 feet

As a Human, you have these special traits.

**Resourceful.** You gain Heroic Inspiration whenever you finish a Long Rest.

**Skillful.** You gain proficiency in one skill of your choice.

**Versatile.** You gain an Origin feat of your choice (see "Feats"). Skilled is recommended.

#### Orc
**Creature Type:** Humanoid
**Size:** Medium (about 6–7 feet tall)
**Speed:** 30 feet

As an Orc, you have these special traits.

**Adrenaline Rush.** You can take the Dash action as a Bonus Action. When you do so, you gain a number of Temporary Hit Points equal to your Proficiency Bonus.
You can use this trait a number of times equal to your Proficiency Bonus, and you regain all expended uses when you finish a Short or Long Rest.

**Darkvision.** You have Darkvision with a range of 120 feet.

**Relentless Endurance.** When you are reduced to 0 Hit Points but not killed outright, you can drop to 1 Hit Point instead. Once you use this trait, you can't do so again until you finish a Long Rest.

#### Tiefling
**Creature Type:** Humanoid
**Size:** Medium (about 4–7 feet tall) or Small (about 3–4 feet tall), chosen when you select this species
**Speed:** 30 feet

As a Tiefling, you have the following special traits.

**Darkvision.** You have Darkvision with a range of 60 feet.

**Fiendish Legacy.** You are the recipient of a legacy that grants you supernatural abilities. Choose a legacy from the Fiendish Legacies table. You gain the level 1 benefit of the chosen legacy.

When you reach character levels 3 and 5, you learn a higher-level spell, as shown on the table. You always have that spell prepared. You can cast it once without a spell slot, and you regain the ability to cast it in that way when you finish a Long Rest. You can also cast the spell using any spell slots you have of the appropriate level.

Intelligence, Wisdom, or Charisma is your spellcasting ability for the spells you cast with this trait (choose the ability when you select the legacy).

**Otherworldly Presence.** You know the Thaumaturgy cantrip. When you cast it with this trait, the spell uses the same spellcasting ability you use for your Fiendish Legacy trait.

##### Fiendish Legacies
| Legacy | Level 1 | Level 3 | Level 5 |
| :--- | :--- | :--- | :--- |
| Abyssal | You have Resistance to Poison damage. You also know the Poison Spray cantrip. | Ray of Sickness | Hold Person |
| Chthonic | You have Resistance to Necrotic damage. You also know the Chill Touch cantrip. | False Life | Ray of Enfeeblement |
| Infernal | You have Resistance to Fire damage. You also know the Fire Bolt cantrip. | Hellish Rebuke | Darkness |

<br>
86
<br>
System Reference Document 5.2.1