# Feats

## Feat Descriptions
The feats that follow are organized by category—Origin, General, Fighting Style, or Epic Boon—and alphabetized in each category.

## Parts of a Feat
The description of a feat contains the following parts, which are presented after the feat's name.

**Category.** A feat is a member of a category, which is noted in the feat. If you're instructed to choose a feat from a specific category, such as the Origin category, that category must appear under the feat's name. If you're instructed to choose a feat and no category is specified, you can choose from any category.

**Prerequisite.** To take a feat, you must meet any prerequisite in its description unless a feature allows you to take the feat without the prerequisite. If a prerequisite includes a class, you must have at least 1 level in that class to take the feat.

**Benefit.** The benefits of a feat are detailed after any prerequisites are listed. If you have a feat, you gain its benefits.

**Repeatable.** A feat can be taken only once unless its description states otherwise in a “Repeatable” subsection.

## Origin Feats

### Alert
*Origin Feat*

You gain the following benefits.

**Initiative Proficiency.** When you roll Initiative, you can add your Proficiency Bonus to the roll.

**Initiative Swap.** Immediately after you roll Initiative, you can swap your Initiative with the Initiative of one willing ally in the same combat. You can't make this swap if you or the ally has the Incapacitated condition.

### Magic Initiate
*Origin Feat*

You gain the following benefits.

**Two Cantrips.** You learn two cantrips of your choice from the Cleric, Druid, or Wizard spell list. Intelligence, Wisdom, or Charisma is your spellcasting ability for this feat's spells (choose when you select this feat).

**Level 1 Spell.** Choose a level 1 spell from the same list you selected for this feat's cantrips. You always have that spell prepared. You can cast it once without a spell slot, and you regain the ability to cast it in that way when you finish a Long Rest. You can also cast the spell using any spell slots you have.

**Spell Change.** Whenever you gain a new level, you can replace one of the spells you chose for this feat with a different spell of the same level from the chosen spell list.

**Repeatable.** You can take this feat more than once, but you must choose a different spell list each time.

### Savage Attacker
*Origin Feat*

You've trained to deal particularly damaging strikes. Once per turn when you hit a target with a weapon, you can roll the weapon's damage dice twice and use either roll against the target.

### Skilled
*Origin Feat*

You gain proficiency in any combination of three skills or tools of your choice.

**Repeatable.** You can take this feat more than once.

## General Feats

### Ability Score Improvement
*General Feat (Prerequisite: Level 4+)*

Increase one ability score of your choice by 2, or increase two ability scores of your choice by 1. This feat can't increase an ability score above 20.

**Repeatable.** You can take this feat more than once.

### Grappler
*General Feat (Prerequisite: Level 4+, Strength or Dexterity 13+)*

You gain the following benefits.

**Ability Score Increase.** Increase your Strength or Dexterity score by 1, to a maximum of 20.

**Punch and Grab.** When you hit a creature with an Unarmed Strike as part of the Attack action on your turn, you can use both the Damage and the Grapple option. You can use this benefit only once per turn.

**Attack Advantage.** You have Advantage on attack rolls against a creature Grappled by you.

**Fast Wrestler.** You don't have to spend extra movement to move a creature Grappled by you if the creature is your size or smaller.

## Fighting Style Feats

### Archery
*Fighting Style Feat (Prerequisite: Fighting Style Feature)*

You gain a +2 bonus to attack rolls you make with Ranged weapons.

### Defense
*Fighting Style Feat (Prerequisite: Fighting Style Feature)*

While you're wearing Light, Medium, or Heavy armor, you gain a +1 bonus to Armor Class.

### Great Weapon Fighting
*Fighting Style Feat (Prerequisite: Fighting Style Feature)*

When you roll damage for an attack you make with a Melee weapon that you are holding with two hands, you can treat any 1 or 2 on a damage die as a 3. The weapon must have the Two-Handed or Versatile property to gain this benefit.

### Two-Weapon Fighting
*Fighting Style Feat (Prerequisite: Fighting Style Feature)*

When you make an extra attack as a result of using a weapon that has the Light property, you can add your ability modifier to the damage of that attack if you aren't already adding it to the damage.

## Epic Boon Feats

### Boon of Combat Prowess
*Epic Boon Feat (Prerequisite: Level 19+)*

You gain the following benefits.

**Ability Score Increase.** Increase one ability score of your choice by 1, to a maximum of 30.

**Peerless Aim.** When you miss with an attack roll, you can hit instead. Once you use this benefit, you can't use it again until the start of your next turn.

### Boon of Dimensional Travel
*Epic Boon Feat (Prerequisite: Level 19+)*

You gain the following benefits.

**Ability Score Increase.** Increase one ability score of your choice by 1, to a maximum of 30.

**Blink Steps.** Immediately after you take the Attack action or the Magic action, you can teleport up to 30 feet to an unoccupied space you can see.

### Boon of Fate
*Epic Boon Feat (Prerequisite: Level 19+)*

You gain the following benefits.

**Ability Score Increase.** Increase one ability score of your choice by 1, to a maximum of 30.

**Improve Fate.** When you or another creature within 60 feet of you succeeds on or fails a D20 Test, you can roll 2d4 and apply the total rolled as a bonus or penalty to the d20 roll. Once you use this benefit, you can't use it again until you roll Initiative or finish a Short or Long Rest.

### Boon of Irresistible Offense
*Epic Boon Feat (Prerequisite: Level 19+)*

You gain the following benefits.

**Ability Score Increase.** Increase your Strength or Dexterity score by 1, to a maximum of 30.

**Overcome Defenses.** The Bludgeoning, Piercing, and Slashing damage you deal always ignores Resistance.

**Overwhelming Strike.** When you roll a 20 on the d20 for an attack roll, you can deal extra damage to the target equal to the ability score increased by this feat. The extra damage's type is the same as the attack's type.

### Boon of Spell Recall
*Epic Boon Feat (Prerequisite: Level 19+, Spellcasting Feature)*

You gain the following benefits.

**Ability Score Increase.** Increase your Intelligence, Wisdom, or Charisma score by 1, to a maximum of 30.

**Free Casting.** Whenever you cast a spell with a level 1–4 spell slot, roll 1d4. If the number you roll is the same as the slot's level, the slot isn't expended.

### Boon of the Night Spirit
*Epic Boon Feat (Prerequisite: Level 19+)*

You gain the following benefits.

**Ability Score Increase.** Increase one ability score of your choice by 1, to a maximum of 30.

**Merge with Shadows.** While within Dim Light or Darkness, you can give yourself the Invisible condition as a Bonus Action. The condition ends on you immediately after you take an action, a Bonus Action, or a Reaction.

**Shadowy Form.** While within Dim Light or Darkness, you have Resistance to all damage except Psychic and Radiant.

### Boon of Truesight
*Epic Boon Feat (Prerequisite: Level 19+)*

You gain the following benefits.

**Ability Score Increase.** Increase one ability score of your choice by 1, to a maximum of 30.

**Truesight.** You have Truesight with a range of 60 feet.

# Equipment

## Coins
Characters often find coins on their adventures and can spend those coins in shops, inns, and other businesses. Coins come in different denominations based on the relative worth of their material. The Coin Values table lists coins and how much they’re worth relative to the Gold Piece, which is the game’s main coin. For example, 100 Copper Pieces are worth 1 Gold Piece.

A coin weighs about a third of an ounce, so fifty coins weigh a pound.

### Coin Values
| Coin | Value in GP |
| :--- | :--- |
| Copper Piece (CP) | 1/100 |
| Silver Piece (SP) | 1/10 |
| Electrum Piece (EP) | 1/2 |
| Gold Piece (GP) | 1 |
| Platinum Piece (PP) | 10 |

## Weapons
The Weapons table in this section shows the game’s main weapons. The table lists the cost and weight of each weapon, as well as the following details:

**Category.** Every weapon falls into a category: Simple or Martial. Weapon proficiencies are usually tied to one of these categories. For example, you might have proficiency with Simple weapons.

**Melee or Ranged.** A weapon is classified as either Melee or Ranged. A Melee weapon is used to attack a target within 5 feet, whereas a Ranged weapon is used to attack at a greater distance.

**Damage.** The table lists the amount of damage a weapon deals when an attacker hits with it as well as the type of that damage.

**Properties.** Any properties a weapon has are listed in the Properties column. Each property is defined in the “Properties” section.

**Mastery.** Each weapon has a mastery property, which is defined in the “Mastery Properties” section. To use that property, you must have a feature that lets you use it.

> **SELLING EQUIPMENT**
> Equipment fetches half its cost when sold. In contrast, trade goods and valuables—like gems and art objects—retain their full value in the marketplace. “Magic Items” has prices for magic items.

### Weapon Proficiency
Anyone can wield a weapon, but you must have proficiency with it to add your Proficiency Bonus to an attack roll you make with it. A player character’s features can provide weapon proficiencies. A monster is proficient with any weapon in its stat block.

### Properties
Here are definitions of the properties in the Properties column of the Weapons table.

#### Ammunition
You can use a weapon that has the Ammunition property to make a ranged attack only if you have ammunition to fire from it. The type of ammunition required is specified with the weapon’s range. Each attack expends one piece of ammunition. Drawing the ammunition is part of the attack (you need a free hand to load a one-handed weapon). After a fight, you can spend 1 minute to recover half the ammunition (round down) you used in the fight; the rest is lost.

#### Finesse
When making an attack with a Finesse weapon, use your choice of your Strength or Dexterity modifier for the attack and damage rolls. You must use the same modifier for both rolls.

#### Heavy
You have Disadvantage on attack rolls with a Heavy weapon if it’s a Melee weapon and your Strength score isn’t at least 13 or if it’s a Ranged weapon and your Dexterity score isn’t at least 13.

#### Light
When you take the Attack action on your turn and attack with a Light weapon, you can make one extra attack as a Bonus Action later on the same turn. That extra attack must be made with a different Light weapon, and you don’t add your ability modifier to the extra attack’s damage unless that modifier is negative. For example, you can attack with a Shortsword in one hand and a Dagger in the other using the Attack action and a Bonus Action, but you don’t add your Strength or Dexterity modifier to the damage roll of the Bonus Action unless that modifier is negative.

#### Loading
You can fire only one piece of ammunition from a Loading weapon when you use an action, a Bonus Action, or a Reaction to fire it, regardless of the number of attacks you can normally make.

#### Range
A Range weapon has a range in parentheses after the Ammunition or Thrown property. The range lists two numbers. The first is the weapon’s normal range in feet, and the second is the weapon’s long range. When attacking a target beyond normal range, you have Disadvantage on the attack roll. You can’t attack a target beyond the long range.

#### Reach
A Reach weapon adds 5 feet to your reach when you attack with it, as well as when determining your reach for Opportunity Attacks with it.

#### Thrown
If a weapon has the Thrown property, you can throw the weapon to make a ranged attack, and you can draw that weapon as part of the attack. If the weapon is a Melee weapon, use the same ability modifier for the attack and damage rolls that you use for a melee attack with that weapon.

#### Two-Handed
A Two-Handed weapon requires two hands when you attack with it.

#### Versatile
A Versatile weapon can be used with one or two hands. A damage value in parentheses appears with the property. The weapon deals that damage when used with two hands to make a melee attack.

## Mastery Properties
Each weapon has a mastery property, which is usable only by a character who has a feature, such as Weapon Mastery, that unlocks the property for the character. The properties are defined below.

> **IMPROVISED WEAPONS**
> If you use an object—such as a table leg, frying pan, or bottle—as a makeshift weapon, see “Improvised Weapons” in “Rules Glossary.” Also see those rules if you wield a weapon in an unusual way, such as using a Ranged weapon to make a melee attack.

#### Cleave
If you hit a creature with a melee attack roll using this weapon, you can make a melee attack roll with the weapon against a second creature within 5 feet of the first that is also within your reach. On a hit, the second creature takes the weapon’s damage, but don’t add your ability modifier to that damage unless that modifier is negative. You can make this extra attack only once per turn.

#### Graze
If your attack roll with this weapon misses a creature, you can deal damage to that creature equal to the ability modifier you used to make the attack roll. This damage is the same type dealt by the weapon, and the damage can be increased only by increasing the ability modifier.

#### Nick
When you make the extra attack of the Light property, you can make it as part of the Attack action instead of as a Bonus Action. You can make this extra attack only once per turn.

#### Push
If you hit a creature with this weapon, you can push the creature up to 10 feet straight away from yourself if it is Large or smaller.

#### Sap
If you hit a creature with this weapon, that creature has Disadvantage on its next attack roll before the start of your next turn.

#### Slow
If you hit a creature with this weapon and deal damage to it, you can reduce its Speed by 10 feet until the start of your next turn. If the creature is hit more than once by weapons that have this property, the Speed reduction doesn’t exceed 10 feet.

#### Topple
If you hit a creature with this weapon, you can force the creature to make a Constitution saving throw (DC 8 plus the ability modifier used to make the attack roll and your Proficiency Bonus). On a failed save, the creature has the Prone condition.

#### Vex
If you hit a creature with this weapon and deal damage to the creature, you have Advantage on your next attack roll against that creature before the end of your next turn.

## Weapons Table

### Simple Melee Weapons
| Name | Damage | Properties | Mastery | Weight | Cost |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Club | 1d4 Bludgeoning | Light | Slow | 2 lb. | 1 SP |
| Dagger | 1d4 Piercing | Finesse, Light, Thrown (Range 20/60) | Nick | 1 lb. | 2 GP |
| Greatclub | 1d8 Bludgeoning | Two-Handed | Push | 10 lb. | 2 SP |
| Handaxe | 1d6 Slashing | Light, Thrown (Range 20/60) | Vex | 2 lb. | 5 GP |
| Javelin | 1d6 Piercing | Thrown (Range 30/120) | Slow | 2 lb. | 5 SP |
| Light Hammer | 1d4 Bludgeoning | Light, Thrown (Range 20/60) | Nick | 2 lb. | 2 GP |
| Mace | 1d6 Bludgeoning | — | Sap | 4 lb. | 5 GP |
| Quarterstaff | 1d6 Bludgeoning | Versatile (1d8) | Topple | 4 lb. | 2 SP |
| Sickle | 1d4 Slashing | Light | Nick | 2 lb. | 1 GP |
| Spear | 1d6 Piercing | Thrown (Range 20/60), Versatile (1d8) | Sap | 3 lb. | 1 GP |

### Simple Ranged Weapons
| Name | Damage | Properties | Mastery | Weight | Cost |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Dart | 1d4 Piercing | Finesse, Thrown (Range 20/60) | Vex | 1/4 lb. | 5 CP |
| Light Crossbow | 1d8 Piercing | Ammunition (Range 80/320; Bolt), Loading, Two-Handed | Slow | 5 lb. | 25 GP |
| Shortbow | 1d6 Piercing | Ammunition (Range 80/320; Arrow), Two-Handed | Vex | 2 lb. | 25 GP |
| Sling | 1d4 Bludgeoning | Ammunition (Range 30/120; Bullet) | Slow | — | 1 SP |

### Martial Melee Weapons
| Name | Damage | Properties | Mastery | Weight | Cost |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Battleaxe | 1d8 Slashing | Versatile (1d10) | Topple | 4 lb. | 10 GP |
| Flail | 1d8 Bludgeoning | — | Sap | 2 lb. | 10 GP |
| Glaive | 1d10 Slashing | Heavy, Reach, Two-Handed | Graze | 6 lb. | 20 GP |
| Greataxe | 1d12 Slashing | Heavy, Two-Handed | Cleave | 7 lb. | 30 GP |
| Greatsword | 2d6 Slashing | Heavy, Two-Handed | Graze | 6 lb. | 50 GP |
| Halberd | 1d10 Slashing | Heavy, Reach, Two-Handed | Cleave | 6 lb. | 20 GP |
| Lance | 1d10 Piercing | Heavy, Reach, Two-Handed (unless mounted) | Topple | 6 lb. | 10 GP |
| Longsword | 1d8 Slashing | Versatile (1d10) | Sap | 3 lb. | 15 GP |
| Maul | 2d6 Bludgeoning | Heavy, Two-Handed | Topple | 10 lb. | 10 GP |
| Morningstar | 1d8 Piercing | — | Sap | 4 lb. | 15 GP |
| Pike | 1d10 Piercing | Heavy, Reach, Two-Handed | Push | 18 lb. | 5 GP |
| Rapier | 1d8 Piercing | Finesse | Vex | 2 lb. | 25 GP |
| Scimitar | 1d6 Slashing | Finesse, Light | Nick | 3 lb. | 25 GP |
| Shortsword | 1d6 Piercing | Finesse, Light | Vex | 2 lb. | 10 GP |
| Trident | 1d8 Piercing | Thrown (Range 20/60), Versatile (1d10) | Topple | 4 lb. | 5 GP |
| Warhammer | 1d8 Bludgeoning | Versatile (1d10) | Push | 5 lb. | 15 GP |
| War Pick | 1d8 Piercing | Versatile (1d10) | Sap | 2 lb. | 5 GP |
| Whip | 1d4 Slashing | Finesse, Reach | Slow | 3 lb. | 2 GP |

### Martial Ranged Weapons
| Name | Damage | Properties | Mastery | Weight | Cost |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Blowgun | 1 Piercing | Ammunition (Range 25/100; Needle), Loading | Vex | 1 lb. | 10 GP |
| Hand Crossbow | 1d6 Piercing | Ammunition (Range 30/120; Bolt), Light, Loading | Vex | 3 lb. | 75 GP |
| Heavy Crossbow | 1d10 Piercing | Ammunition (Range 100/400; Bolt), Heavy, Loading, Two-Handed | Push | 18 lb. | 50 GP |
| Longbow | 1d8 Piercing | Ammunition (Range 150/600; Arrow), Heavy, Two-Handed | Slow | 2 lb. | 50 GP |
| Musket | 1d12 Piercing | Ammunition (Range 40/120; Bullet), Loading, Two-Handed | Slow | 10 lb. | 500 GP |
| Pistol | 1d10 Piercing | Ammunition (Range 30/90; Bullet), Loading | Vex | 3 lb. | 250 GP |

## Armor
The Armor table lists the game’s main armor. The table includes the cost and weight of armor, as well as the following details:

**Category.** Every type of armor falls into a category: Light, Medium, or Heavy. The category determines how long it takes to don or doff the armor (as shown in the table).

**Armor Class (AC).** The table’s Armor Class column tells you what your base AC is when you wear a type of armor. For example, if you wear Leather Armor, your base AC is 11 plus your Dexterity modifier, whereas your AC is 16 in Chain Mail.

**Strength.** If the table shows a Strength score in the Strength column for an armor type, that armor reduces the wearer’s speed by 10 feet unless the wearer has a Strength score equal to or higher than the listed score.

**Stealth.** If the table shows “Disadvantage” in the Stealth column for an armor type, the wearer has Disadvantage on Dexterity (Stealth) checks.

### Armor Training
Anyone can don armor or hold a Shield, but only those with training can use them effectively, as explained below. A character’s class and other features determine the character’s armor training. A monster has training with any armor in its stat block.

#### Light, Medium, or Heavy Armor
If you wear Light, Medium, or Heavy armor and lack training with it, you have Disadvantage on any D20 Test that involves Strength or Dexterity, and you can’t cast spells.

#### Shield
You gain the Armor Class benefit of a Shield only if you have training with it.

#### One at a Time
A creature can wear only one suit of armor at a time and wield only one Shield at a time.

### Armor
| Armor | Armor Class (AC) | Strength | Stealth | Weight | Cost |
| :--- | :--- | :--- | :--- | :--- | :--- |
| **Light Armor (1 Minute to Don or Doff)** | | | | | |
| Padded Armor | 11 + Dex modifier | — | Disadvantage | 8 lb. | 5 GP |
| Leather Armor | 11 + Dex modifier | — | — | 10 lb. | 10 GP |
| Studded Leather Armor | 12 + Dex modifier | — | — | 13 lb. | 45 GP |
| **Medium Armor (5 Minutes to Don and 1 Minute to Doff)** | | | | | |
| Hide Armor | 12 + Dex modifier (max 2) | — | — | 12 lb. | 10 GP |
| Chain Shirt | 13 + Dex modifier (max 2) | — | — | 20 lb. | 50 GP |
| Scale Mail | 14 + Dex modifier (max 2) | — | Disadvantage | 45 lb. | 50 GP |
| Breastplate | 14 + Dex modifier (max 2) | — | — | 20 lb. | 400 GP |
| Half Plate Armor | 15 + Dex modifier (max 2) | — | Disadvantage | 40 lb. | 750 GP |
| **Heavy Armor (10 Minutes to Don and 5 Minutes to Doff)** | | | | | |
| Ring Mail | 14 | — | Disadvantage | 40 lb. | 30 GP |
| Chain Mail | 16 | Str 13 | Disadvantage | 55 lb. | 75 GP |
| Splint Armor | 17 | Str 15 | Disadvantage | 60 lb. | 200 GP |
| Plate Armor | 18 | Str 15 | Disadvantage | 65 lb. | 1,500 GP |
| **Shield (Utilize Action to Don or Doff)** | | | | | |
| Shield | +2 | — | — | 6 lb. | 10 GP |

## Tools
A tool helps you make specialized ability checks, craft certain items, or both. A tool’s description includes the tool’s cost and weight, as well as the following entries:

**Ability.** This entry lists the ability to use when making an ability check with the tool.

**Utilize.** This entry lists things you can do with the tool when you take the Utilize action. You can do one of those things each time you take the action. This entry also provides the DC for the action.

**Craft.** This entry lists what, if anything, you can craft with the tool. For crafting rules, see “Crafting Nonmagical Items,” “Brewing Potions of Healing,” and “Scribing Spell Scrolls” later in “Equipment.”

**Variants.** This entry appears if the tool has variants, which are listed. Each requires a separate proficiency.

### Tool Proficiency
If you have proficiency with a tool, add your Proficiency Bonus to any ability check you make that uses the tool. If you have proficiency in a skill that’s used with that check, you have Advantage on the check too.

Your features might give you proficiency with a tool. A monster has proficiency with any tool in its stat block.

### Artisan’s Tools
Artisan’s Tools are each focused on crafting items and pursuing a trade. Each of these tools requires a separate proficiency.

#### Alchemist’s Supplies (50 GP)
**Ability:** Intelligence **Weight:** 8 lb.
**Utilize:** Identify a substance (DC 15), or start a fire (DC 15)
**Craft:** Acid, Alchemist’s Fire, Component Pouch, Oil, Paper, Perfume

#### Brewer’s Supplies (20 GP)
**Ability:** Intelligence **Weight:** 9 lb.
**Utilize:** Detect poisoned drink (DC 15), or identify alcohol (DC 10)
**Craft:** Antitoxin

#### Calligrapher’s Supplies (10 GP)
**Ability:** Dexterity **Weight:** 5 lb.
**Utilize:** Write text with impressive flourishes that guard against forgery (DC 15)
**Craft:** Ink, Spell Scroll

#### Carpenter’s Tools (8 GP)
**Ability:** Strength **Weight:** 6 lb.
**Utilize:** Seal or pry open a door or container (DC 20)
**Craft:** Club, Greatclub, Quarterstaff, Barrel, Chest, Ladder, Pole, Portable Ram, Torch

#### Cartographer’s Tools (15 GP)
**Ability:** Wisdom **Weight:** 6 lb.
**Utilize:** Draft a map of a small area (DC 15)
**Craft:** Map

#### Cobbler’s Tools (5 GP)
**Ability:** Dexterity **Weight:** 5 lb.
**Utilize:** Modify footwear to give Advantage on the wearer’s next Dexterity (Acrobatics) check (DC 10)
**Craft:** Climber’s Kit

#### Cook’s Utensils (1 GP)
**Ability:** Wisdom **Weight:** 8 lb.
**Utilize:** Improve food’s flavor (DC 10), or detect spoiled or poisoned food (DC 15)
**Craft:** Rations

#### Glassblower’s Tools (30 GP)
**Ability:** Intelligence **Weight:** 5 lb.
**Utilize:** Discern what a glass object held in the past 24 hours (DC 15)
**Craft:** Glass Bottle, Magnifying Glass, Spyglass, Vial

#### Jeweler’s Tools (25 GP)
**Ability:** Intelligence **Weight:** 2 lb.
**Utilize:** Discern a gem’s value (DC 15)
**Craft:** Arcane Focus, Holy Symbol

#### Leatherworker’s Tools (5 GP)
**Ability:** Dexterity **Weight:** 5 lb.
**Utilize:** Add a design to a leather item (DC 10)
**Craft:** Sling, Whip, Hide Armor, Leather Armor, Studded Leather Armor, Backpack, Crossbow Bolt Case, Map or Scroll Case, Parchment, Pouch, Quiver, Waterskin

#### Mason’s Tools (10 GP)
**Ability:** Strength **Weight:** 8 lb.
**Utilize:** Chisel a symbol or hole in stone (DC 10)
**Craft:** Block and Tackle

#### Painter’s Supplies (10 GP)
**Ability:** Wisdom **Weight:** 5 lb.
**Utilize:** Paint a recognizable image of something you’ve seen (DC 10)
**Craft:** Druidic Focus, Holy Symbol

#### Potter’s Tools (10 GP)
**Ability:** Intelligence **Weight:** 3 lb.
**Utilize:** Discern what a ceramic object held in the past 24 hours (DC 15)
**Craft:** Jug, Lamp

#### Smith’s Tools (20 GP)
**Ability:** Strength **Weight:** 8 lb.
**Utilize:** Pry open a door or container (DC 20)
**Craft:** Any Melee weapon (except Club, Greatclub, Quarterstaff, and Whip), Medium armor (except Hide), Heavy armor, Ball Bearings, Bucket, Caltrops, Chain, Crowbar, Firearm Bullets, Grappling Hook, Iron Pot, Iron Spikes, Sling Bullets

#### Tinker’s Tools (50 GP)
**Ability:** Dexterity **Weight:** 10 lb.
**Utilize:** Assemble a Tiny item composed of scrap, which falls apart in 1 minute (DC 20)
**Craft:** Musket, Pistol, Bell, Bullseye Lantern, Flask, Hooded Lantern, Hunting Trap, Lock, Manacles, Mirror, Shovel, Signal Whistle, Tinderbox

#### Weaver’s Tools (1 GP)
**Ability:** Dexterity **Weight:** 5 lb.
**Utilize:** Mend a tear in clothing (DC 10), or sew a Tiny design (DC 10)
**Craft:** Padded Armor, Basket, Bedroll, Blanket, Fine Clothes, Net, Robe, Rope, Sack, String, Tent, Traveler’s Clothes

#### Woodcarver’s Tools (1 GP)
**Ability:** Dexterity **Weight:** 5 lb.
**Utilize:** Carve a pattern in wood (DC 10)
**Craft:** Club, Greatclub, Quarterstaff, Ranged weapons (except Pistol, Musket, and Sling), Arcane Focus, Arrows, Bolts, Druidic Focus, Ink Pen, Needles

### Other Tools

#### Disguise Kit (25 GP)
**Ability:** Charisma **Weight:** 3 lb.
**Utilize:** Apply makeup (DC 10)
**Craft:** Costume

#### Forgery Kit (15 GP)
**Ability:** Dexterity **Weight:** 5 lb.
**Utilize:** Mimic 10 or fewer words of someone else’s handwriting (DC 15), or duplicate a wax seal (DC 20)

#### Gaming Set (Varies)
**Ability:** Wisdom **Weight:** —
**Utilize:** Discern whether someone is cheating (DC 10), or win the game (DC 20)
**Variants:** Dice (1 SP), dragonchess (1 GP), playing cards (5 SP), three-dragon ante (1 GP)

#### Herbalism Kit (5 GP)
**Ability:** Intelligence **Weight:** 3 lb.
**Utilize:** Identify a plant (DC 10)
**Craft:** Antitoxin, Candle, Healer’s Kit, Potion of Healing

#### Musical Instrument (Varies)
**Ability:** Charisma **Weight:** Varies
**Utilize:** Play a known tune (DC 10), or improvise a song (DC 15)
**Variants:** Bagpipes (30 GP, 6 lb.), drum (6 GP, 3 lb.), dulcimer (25 GP, 10 lb.), flute (2 GP, 1 lb.), horn (3 GP, 2 lb.), lute (35 GP, 2 lb.), lyre (30 GP, 2 lb.), pan flute (12 GP, 2 lb.), shawm (2 GP, 1 lb.), viol (30 GP, 1 lb.)

#### Navigator’s Tools (25 GP)
**Ability:** Wisdom **Weight:** 2 lb.
**Utilize:** Plot a course (DC 10), or determine position by stargazing (DC 15)

#### Poisoner’s Kit (50 GP)
**Ability:** Intelligence **Weight:** 2 lb.
**Utilize:** Detect a poisoned object (DC 10)
**Craft:** Basic Poison

#### Thieves’ Tools (25 GP)
**Ability:** Dexterity **Weight:** 1 lb.
**Utilize:** Pick a lock (DC 15), or disarm a trap (DC 15)

## Adventuring Gear
The Adventuring Gear table in this section includes gear that adventurers often find useful. These items are described here in alphabetical order, with an item’s price appearing after its name.

### Acid (25 GP)
When you take the Attack action, you can replace one of your attacks with throwing a vial of Acid. Target one creature or object you can see within 20 feet of yourself. The target must succeed on a Dexterity saving throw (DC 8 plus your Dexterity modifier and Proficiency Bonus) or take 2d6 Acid damage.

### Alchemist’s Fire (50 GP)
When you take the Attack action, you can replace one of your attacks with throwing a flask of Alchemist’s Fire. Target one creature or object you can see within 20 feet of yourself. The target must succeed on a Dexterity saving throw (DC 8 plus your Dexterity modifier and Proficiency Bonus) or take 1d4 Fire damage and start burning (see “Rules Glossary”).

### Ammunition (Varies)
Ammunition is required by a weapon that has the Ammunition property. A weapon’s description specifies the type of ammunition used by the weapon. The Ammunition table lists the different types and the amount you get when you buy them. The table also lists the item that is typically used to store each type; storage must be bought separately.

### Adventuring Gear Table

| Item | Weight | Cost |
| :--- | :--- | :--- |
| Acid | 1 lb. | 25 GP |
| Alchemist’s Fire | 1 lb. | 50 GP |
| Ammunition | Varies | Varies |
| Antitoxin | — | 50 GP |
| Arcane Focus | Varies | Varies |
| Backpack | 5 lb. | 2 GP |
| Ball Bearings | 2 lb. | 1 GP |
| Barrel | 70 lb. | 2 GP |
| Basket | 2 lb. | 4 SP |
| Bedroll | 7 lb. | 1 GP |
| Bell | | 1 GP |
| Blanket | 3 lb. | 5 SP |
| Block and Tackle | 5 lb. | 1 GP |
| Book | 5 lb. | 25 GP |
| Bottle, Glass | 2 lb. | 2 GP |
| Bucket | 2 lb. | 5 CP |
| Burglar’s Pack | 42 lb. | 16 GP |
| Caltrops | 2 lb. | 1 GP |
| Candle | — | 1 CP |
| Case, Crossbow Bolt | 1 lb. | 1 GP |
| Case, Map or Scroll | 1 lb. | 1 GP |
| Chain | 10 lb. | 5 GP |
| Chest | 25 lb. | 5 GP |
| Climber’s Kit | 12 lb. | 25 GP |
| Clothes, Fine | 6 lb. | 15 GP |
| Clothes, Traveler’s | 4 lb. | 2 GP |
| Component Pouch | 2 lb. | 25 GP |
| Costume | 4 lb. | 5 GP |
| Crowbar | 5 lb. | 2 GP |
| Diplomat’s Pack | 39 lb. | 39 GP |
| Druidic Focus | Varies | Varies |
| Dungeoneer’s Pack | 55 lb. | 12 GP |
| Entertainer’s Pack | 58½ lb. | 40 GP |
| Explorer’s Pack | 55 lb. | 10 GP |
| Flask | 1 lb. | 2 CP |
| Grappling Hook | 4 lb. | 2 GP |
| Healer’s Kit | 3 lb. | 5 GP |
| Holy Symbol | Varies | Varies |
| Holy Water | 1 lb. | 25 GP |
| Hunting Trap | 25 lb. | 5 GP |
| Ink | — | 10 GP |
| Ink Pen | | 2 CP |
| Jug | 4 lb. | 2 CP |
| Ladder | 25 lb. | 1 SP |
| Lamp | 1 lb. | 5 SP |
| Lantern, Bullseye | 2 lb. | 10 GP |
| Lantern, Hooded | 2 lb. | 5 GP |
| Lock | 1 lb. | 10 GP |
| Magnifying Glass | — | 100 GP |
| Manacles | 6 lb. | 2 GP |
| Map | — | 1 GP |
| Mirror | 1/2 lb. | 5 GP |
| Net | 3 lb. | 1 GP |
| Oil | 1 lb. | 1 SP |
| Paper | — | 2 SP |
| Parchment | — | 1 SP |
| Perfume | — | 5 GP |
| Poison, Basic | — | 100 GP |
| Pole | 7 lb. | 5 CP |
| Pot, Iron | 10 lb. | 2 GP |
| Potion of Healing | 1/2 lb. | 50 GP |
| Pouch | 1 lb. | 5 SP |
| Priest’s Pack | 29 lb. | 33 GP |
| Quiver | 1 lb. | 1 GP |
| Ram, Portable | 35 lb. | 4 GP |
| Rations | 2 lb. | 5 SP |
| Robe | 4 lb. | 1 GP |
| Rope | 5 lb. | 1 GP |
| Sack | 1/2 lb. | 1 CP |
| Scholar’s Pack | 22 lb. | 40 GP |
| Shovel | 5 lb. | 2 GP |
| Signal Whistle | — | 5 CP |
| Spell Scroll (Cantrip) | — | 30 GP |
| Spell Scroll (Level 1) | — | 50 GP |
| Spikes, Iron | 5 lb. | 1 GP |
| Spyglass | 1 lb. | 1,000 GP |
| String | — | 1 SP |
| Tent | 20 lb. | 2 GP |
| Tinderbox | 1 lb. | 5 SP |
| Torch | 1 lb. | 1 CP |
| Vial | — | 1 GP |
| Waterskin | 5 lb. (full) | 2 SP |

### Ammunition
| Type | Amount | Storage | Weight | Cost |
| :--- | :--- | :--- | :--- | :--- |
| Arrows | 20 | Quiver | 1 lb. | 1 GP |
| Bolts | 20 | Case | 1½ lb. | 1 GP |
| Bullets, Firearm | 10 | Pouch | 2 lb. | 3 GP |
| Bullets, Sling | 20 | Pouch | 1½ lb. | 4 CP |
| Needles | 50 | Pouch | 1 lb. | 1 GP |

### Antitoxin (50 GP)
As a Bonus Action, you can drink a vial of Antitoxin to gain Advantage on saving throws to avoid or end the Poisoned condition for 1 hour.

### Arcane Focus (Varies)
An Arcane Focus takes one of the forms in the Arcane Focuses table and is bejeweled or carved to channel arcane magic. A Sorcerer, Warlock, or Wizard can use such an item as a Spellcasting Focus.

#### Arcane Focuses
| Focus | Weight | Cost |
| :--- | :--- | :--- |
| Crystal | 1 lb. | 10 GP |
| Orb | 3 lb. | 20 GP |
| Rod | 2 lb. | 10 GP |
| Staff (also a Quarterstaff) | 4 lb. | 5 GP |
| Wand | 1 lb. | 10 GP |

### Backpack (2 GP)
A Backpack holds up to 30 pounds within 1 cubic foot. It can also serve as a saddlebag.

### Ball Bearings (1 GP)
As a Utilize action, you can spill Ball Bearings from their pouch. They spread to cover a level, 10-footsquare area within 10 feet of yourself. A creature that enters this area for the first time on a turn must succeed on a DC 10 Dexterity saving throw or have the Prone condition. It takes 10 minutes to recover the Ball Bearings.

### Barrel (2 GP)
A Barrel holds up to 40 gallons of liquid or up to 4 cubic feet of dry goods.

### Basket (4 SP)
A Basket holds up to 40 pounds within 2 cubic feet.

### Bedroll (1 GP)
A Bedroll sleeps one Small or Medium creature. While in a Bedroll, you automatically succeed on saving throws against extreme cold (see “Gameplay Toolbox”).

### Bell (1 GP)
When rung as a Utilize action, a Bell produces a sound that can be heard up to 60 feet away.

### Blanket (5 SP)
While wrapped in a blanket, you have Advantage on saving throws against extreme cold (see “Gameplay Toolbox”).

### Block and Tackle (1 GP)
A Block and Tackle allows you to hoist up to four times the weight you can normally lift.

### Book (25 GP)
A Book contains fiction or nonfiction. If you consult an accurate nonfiction Book about its topic, you gain a +5 bonus to Intelligence (Arcana, History, Nature, or Religion) checks you make about that topic.

### Bottle, Glass (2 GP)
A Glass Bottle holds up to 1½ pints.

### Bucket (5 CP)
A Bucket holds up to half a cubic foot of contents.

### Burglar’s Pack (16 GP)
A Burglar’s Pack contains the following items: Backpack, Ball Bearings, Bell, 10 Candles, Crowbar, Hooded Lantern, 7 flasks of Oil, 5 days of Rations, Rope, Tinderbox, and Waterskin.

### Caltrops (1 GP)
As a Utilize action, you can spread Caltrops from their bag to cover a 5-foot-square area within 5 feet of yourself. A creature that enters this area for the first time on a turn must succeed on a DC 15 Dexterity saving throw or take 1 Piercing damage and have its Speed reduced to 0 until the start of its next turn. It takes 10 minutes to recover the Caltrops.

### Candle (1 CP)
For 1 hour, a lit Candle sheds Bright Light in a 5-foot radius and Dim Light for an additional 5 feet.

### Case, Crossbow Bolt (1 GP)
A Crossbow Bolt Case holds up to 20 Bolts.

### Case, Map or Scroll (1 GP)
A Map or Scroll Case holds up to 10 sheets of paper or 5 sheets of parchment.

### Chain (5 GP)
As a Utilize action, you can wrap a Chain around an unwilling creature within 5 feet of yourself that has the Grappled, Incapacitated, or Restrained condition if you succeed on a DC 13 Strength (Athletics) check. If the creature’s legs are bound, the creature has the Restrained condition until it escapes. Escaping the Chain requires the creature to make a successful DC 18 Dexterity (Acrobatics) check as an action. Bursting the Chain requires a successful DC 20 Strength (Athletics) check as an action.

### Chest (5 GP)
A Chest holds up to 12 cubic feet of contents.

### Climber’s Kit (25 GP)
A Climber’s Kit includes boot tips, gloves, pitons, and a harness. As a Utilize action, you can use the Climber’s Kit to anchor yourself; when you do, you can’t fall more than 25 feet from the anchor point, and you can’t move more than 25 feet from there without undoing the anchor as a Bonus Action.

### Clothes, Fine (15 GP)
Fine Clothes are made of expensive fabrics and adorned with expertly crafted details. Some events and locations admit only people wearing these clothes.

### Clothes, Traveler’s (2 GP)
Traveler’s Clothes are resilient garments designed for travel in various environments.

### Component Pouch (25 GP)
A Component Pouch is watertight and filled with compartments that hold all the free Material components of your spells.

### Costume (5 GP)
While wearing a Costume, you have Advantage on any ability check you make to impersonate the person or type of person it represents.

### Crowbar (2 GP)
Using a Crowbar gives you Advantage on Strength checks where the Crowbar’s leverage can be applied.

### Diplomat’s Pack (39 GP)
A Diplomat’s Pack contains the following items: Chest, Fine Clothes, Ink, 5 Ink Pens, Lamp, 2 Map or Scroll Cases, 4 flasks of Oil, 5 sheets of Paper, 5 sheets of Parchment, Perfume, and Tinderbox.

### Druidic Focus (Varies)
A Druidic Focus takes one of the forms in the Druidic Focuses table and is carved, tied with ribbon, or painted to channel primal magic. A Druid or Ranger can use such an object as a Spellcasting Focus.

#### Druidic Focuses
| Focus | Weight | Cost |
| :--- | :--- | :--- |
| Sprig of mistletoe | — | 1 GP |
| Wooden staff (also a Quarterstaff) | 4 lb. | 5 GP |
| Yew wand | 1 lb. | 10 GP |

### Dungeoneer’s Pack (12 GP)
A Dungeoneer’s Pack contains the following items: Backpack, Caltrops, Crowbar, 2 flasks of Oil, 10 days of Rations, Rope, Tinderbox, 10 Torches, and Waterskin.

### Entertainer’s Pack (40 GP)
An Entertainer’s Pack contains the following items: Backpack, Bedroll, Bell, Bullseye Lantern, 3 Costumes, Mirror, 8 flasks of Oil, 9 days of Rations, Tinderbox, and Waterskin.

### Explorer’s Pack (10 GP)
An Explorer’s Pack contains the following items: Backpack, Bedroll, 2 flasks of Oil, 10 days of Rations, Rope, Tinderbox, 10 Torches, and Waterskin.

### Flask (2 CP)
A Flask holds up to 1 pint.

### Grappling Hook (2 GP)
As a Utilize action, you can throw the Grappling Hook at a railing, a ledge, or another catch within 50 feet of yourself, and the hook catches on if you succeed on a DC 13 Dexterity (Acrobatics) check. If you tied a Rope to the hook, you can then climb it.

### Healer’s Kit (5 GP)
A Healer’s Kit has ten uses. As a Utilize action, you can expend one of its uses to stabilize an Unconscious creature that has 0 Hit Points without needing to make a Wisdom (Medicine) check.

### Holy Symbol (Varies)
A Holy Symbol takes one of the forms in the Holy Symbol table and is bejeweled or painted to channel divine magic. A Cleric or Paladin can use a Holy Symbol as a Spellcasting Focus.

The table indicates whether a Holy Symbol needs to be held, worn, or borne on fabric (such as a tabard or banner) or a Shield.

#### Holy Symbols
| Symbol | Weight | Cost |
| :--- | :--- | :--- |
| Amulet (worn or held) | 1 lb. | 5 GP |
| Emblem (borne on fabric or a Shield) | — | 5 GP |
| Reliquary (held) | 2 lb. | 5 GP |

### Holy Water (25 GP)
When you take the Attack action, you can replace one of your attacks with throwing a flask of Holy Water. Target one creature you can see within 20 feet of yourself. The target must succeed on a Dexterity saving throw (DC 8 plus your Dexterity modifier and Proficiency Bonus) or take 2d8 Radiant damage if it is a Fiend or an Undead.

### Hunting Trap (5 GP)
As a Utilize action, you can set a Hunting Trap, which is a sawtooth steel ring that snaps shut when a creature steps on a pressure plate in the center. The trap is affixed by a heavy chain to an immobile object, such as a tree or a spike driven into the ground. A creature that steps on the plate must succeed on a DC 13 Dexterity saving throw or take 1d4 Piercing damage and have its Speed reduced to 0 until the start of its next turn. Thereafter, until the creature breaks free of the trap, its movement is limited by the length of the chain (typically 3 feet). A creature can use its action to make a DC 13 Strength (Athletics) check, freeing itself or another creature within its reach on a success. Each failed check deals 1 Piercing damage to the trapped creature.

### Ink (10 GP)
Ink comes in a 1-ounce bottle, which provides enough ink to write about 500 pages.

### Ink Pen (2 CP)
Using Ink, an Ink Pen is used to write or draw.

### Jug (2 CP)
A Jug holds up to 1 gallon.

### Ladder (1 SP)
A Ladder is 10 feet tall. You must climb to move up or down it.

### Lamp (5 SP)
A Lamp burns Oil as fuel to cast Bright Light in a 15-foot radius and Dim Light for an additional 30 feet.

### Lantern, Bullseye (10 GP)
A Bullseye Lantern burns Oil as fuel to cast Bright Light in a 60-foot Cone and Dim Light for an additional 60 feet.

### Lantern, Hooded (5 GP)
A Hooded Lantern burns Oil as fuel to cast Bright Light in a 30-foot radius and Dim Light for an additional 30 feet. As a Bonus Action, you can lower the hood, reducing the light to Dim Light in a 5-foot radius, or raise it again.

### Lock (10 GP)
A Lock comes with a key. Without the key, a creature can use Thieves’ Tools to pick this Lock with a successful DC 15 Dexterity (Sleight of Hand) check.

### Magnifying Glass (100 GP)
A Magnifying Glass grants Advantage on any ability check made to appraise or inspect a highly detailed item. Lighting a fire with a Magnifying Glass requires light as bright as sunlight to focus, tinder to ignite, and about 5 minutes for the fire to ignite.

### Manacles (2 GP)
As a Utilize action, you can use Manacles to bind an unwilling Small or Medium creature within 5 feet of yourself that has the Grappled, Incapacitated, or Restrained condition if you succeed on a DC 13 Dexterity (Sleight of Hand) check. While bound, a creature has Disadvantage on attack rolls, and the creature is Restrained if the Manacles are attached to a chain or hook that is fixed in place. Escaping the Manacles requires a successful DC 20 Dexterity (Sleight of Hand) check as an action. Bursting them requires a successful DC 25 Strength (Athletics) check as an action.

Each set of Manacles comes with a key. Without the key, a creature can use Thieves’ Tools to pick the Manacles’ lock with a successful DC 15 Dexterity (Sleight of Hand) check.

### Map (1 GP)
If you consult an accurate Map, you gain a +5 bonus to Wisdom (Survival) checks you make to find your way in the place represented on it.

### Mirror (5 GP)
A handheld steel Mirror is useful for personal cosmetics but also for peeking around corners and reflecting light as a signal.

### Net (1 GP)
When you take the Attack action, you can replace one of your attacks with throwing a Net. Target a creature you can see within 15 feet of yourself. The target must succeed on a Dexterity saving throw (DC 8 plus your Dexterity modifier and Proficiency Bonus) or have the Restrained condition until it escapes. The target succeeds automatically if it is Huge or larger.

To escape, the target or a creature within 5 feet of it must take an action to make a DC 10 Strength (Athletics) check, freeing the Restrained creature on a success. Destroying the Net (AC 10; 5 HP; Immunity to Bludgeoning, Poison, and Psychic damage) also frees the target, ending the effect.

### Oil (1 SP)
You can douse a creature, object, or space with Oil or use it as fuel, as detailed below.

**Dousing a Creature or an Object.** When you take the Attack action, you can replace one of your attacks with throwing an Oil flask. Target one creature or object within 20 feet of yourself. The target must succeed on a Dexterity saving throw (DC 8 plus your Dexterity modifier and Proficiency Bonus) or be covered in oil. If the target takes Fire damage before the oil dries (after 1 minute), the target takes an extra 5 Fire damage from burning oil.

**Dousing a Space.** You can take the Utilize action to pour an Oil flask on level ground to cover a 5-foot-square area within 5 feet of yourself. If lit, the oil burns until the end of the turn 2 rounds from when the oil was lit (or 12 seconds) and deals 5 Fire damage to any creature that enters the area or ends its turn there. A creature can take this damage only once per turn.

**Fuel.** Oil serves as fuel for Lamps and Lanterns. Once lit, a flask of Oil burns for 6 hours in a Lamp or Lantern. That duration doesn’t need to be consecutive; you can extinguish the burning Oil (as a Utilize action) and rekindle it again until it has burned for a total of 6 hours.

### Paper (2 SP)
One sheet of Paper can hold about 250 handwritten words.

### Parchment (1 SP)
One sheet of Parchment can hold about 250 handwritten words.

### Perfume (5 GP)
Perfume comes in a 4-ounce vial. For 1 hour after applying Perfume to yourself, you have Advantage on Charisma (Persuasion) checks made to influence an Indifferent Humanoid within 5 feet of yourself.

### Poison, Basic (100 GP)
As a Bonus Action, you can use a vial of Basic Poison to coat one weapon or up to three pieces of ammunition. A creature that takes Piercing or Slashing damage from the poisoned weapon or ammunition takes an extra 1d4 Poison damage. Once applied, the poison retains potency for 1 minute or until its damage is dealt, whichever comes first.

### Pole (5 CP)
A Pole is 10 feet long. You can use it to touch something up to 10 feet away. If you must make a Strength (Athletics) check as part of a High or Long Jump, you can use the Pole to vault, giving yourself Advantage on the check.

### Pot, Iron (2 GP)
An Iron Pot holds up to 1 gallon.

### Potion of Healing (50 GP)
This potion is a magic item. As a Bonus Action, you can drink it or administer it to another creature within 5 feet of yourself. The creature that drinks the magical red fluid in this vial regains 2d4 + 2 Hit Points.

### Pouch (5 SP)
A Pouch holds up to 6 pounds within one-fifth of a cubic foot.

### Priest’s Pack (33 GP)
A Priest’s Pack contains the following items: Backpack, Blanket, Holy Water, Lamp, 7 days of Rations, Robe, and Tinderbox.

### Quiver (1 GP)
A Quiver holds up to 20 Arrows.

### Ram, Portable (4 GP)
You can use a Portable Ram to break down doors. When doing so, you gain a +4 bonus to the Strength check. One other character can help you use the ram, giving you Advantage on this check.

### Rations (5 SP)
Rations consist of travel-ready food, including jerky, dried fruit, hardtack, and nuts. See “Malnutrition” in “Rules Glossary” for the risks of not eating.

### Robe (1 GP)
A Robe has vocational or ceremonial significance. Some events and locations admit only people wearing a Robe bearing certain colors or symbols.

### Rope (1 GP)
As a Utilize action, you can tie a knot with Rope if you succeed on a DC 10 Dexterity (Sleight of Hand) check. The Rope can be burst with a successful DC 20 Strength (Athletics) check.

You can bind an unwilling creature with the Rope only if the creature has the Grappled, Incapacitated, or Restrained condition. If the creature’s legs are bound, the creature has the Restrained condition until it escapes. Escaping the Rope requires the creature to make a successful DC 15 Dexterity (Acrobatics) check as an action.

### Sack (1 CP)
A Sack holds up to 30 pounds within 1 cubic foot.

### Scholar’s Pack (40 GP)
A Scholar’s Pack contains the following items: Backpack, Book, Ink, Ink Pen, Lamp, 10 flasks of Oil, 10 sheets of Parchment, and Tinderbox.

### Shovel (2 GP)
Working for 1 hour, you can use a Shovel to dig a hole that is 5 feet on each side in soil or similar material.

### Signal Whistle (5 CP)
When blown as a Utilize action, a Signal Whistle produces a sound that can be heard up to 600 feet away.

### Spell Scroll (Cantrip, 30 GP; Level 1, 50 GP)
A Spell Scroll (Cantrip) or Spell Scroll (Level 1) is a magic item that bears the words of a cantrip or level 1 spell, respectively, determined by the scroll’s creator. If the spell is on your class’s spell list, you can read the scroll and cast the spell using its normal casting time and without providing any Material components.

If the spell requires a saving throw or an attack roll, the spell save DC is 13, and the attack bonus is +5. The scroll disintegrates when the casting is completed.

### Spikes, Iron (1 GP)
Iron Spikes come in bundles of ten. As a Utilize action, you can use a blunt object, such as a Light Hammer, to hammer a spike into wood, earth, or a similar material. You can do so to jam a door shut or to then tie a Rope or Chain to the Spike.

### Spyglass (1,000 GP)
Objects viewed through a Spyglass are magnified to twice their size.

### String (1 SP)
String is 10 feet long. You can tie a knot in it as a Utilize action.

### Tent (2 GP)
A Tent sleeps up to two Small or Medium creatures.

### Tinderbox (5 SP)
A Tinderbox is a small container holding flint, fire steel, and tinder (usually dry cloth soaked in light oil) used to kindle a fire. Using it to light a Candle, Lamp, Lantern, or Torch—or anything else with exposed fuel—takes a Bonus Action. Lighting any other fire takes 1 minute.

### Torch (1 CP)
A Torch burns for 1 hour, casting Bright Light in a 20-foot radius and Dim Light for an additional 20 feet. When you take the Attack action, you can attack with the Torch, using it as a Simple Melee weapon. On a hit, the target takes 1 Fire damage.

### Vial (1 GP)
A Vial holds up to 4 ounces.

### Waterskin (2 SP)
A Waterskin holds up to 4 pints. If you don’t drink sufficient water, you risk dehydration (see “Rules Glossary”).

## Mounts and Vehicles
A mount can help you move more quickly through the wilderness, but its primary purpose is to carry gear that would otherwise slow you down. The Mounts and Other Animals table shows each animal’s carrying capacity. See “Monsters” for the animals’ stat blocks.

### Mounts and Cargo
An animal pulling a carriage, cart, chariot, sled, or wagon can move weight up to five times its base carrying capacity, including the weight of the vehicle. If multiple animals pull the same vehicle, add their carrying capacities together.

### Barding
Barding is armor designed for a mount. Any type of armor on the Armor table in “Equipment” can be purchased as barding. The cost is four times the normal cost, and it weighs twice as much.

### Saddles
A saddle comes with a bit, a bridle, reins, and any other equipment needed to use the saddle. A Military Saddle gives Advantage on any ability check you make to remain mounted. An Exotic Saddle is required for riding an aquatic or a flying mount.

#### Mounts and Other Animals
| Item | Carrying Capacity | Cost |
| :--- | :--- | :--- |
| Camel | 450 lb. | 50 GP |
| Elephant | 1,320 lb. | 200 GP |
| Horse, Draft | 540 lb. | 50 GP |
| Horse, Riding | 480 lb. | 75 GP |
| Mastiff | 195 lb. | 25 GP |
| Mule | 420 lb. | 8 GP |
| Pony | 225 lb. | 30 GP |
| Warhorse | 540 lb. | 400 GP |

#### Tack, Harness, and Drawn Vehicles
| Item | Weight | Cost |
| :--- | :--- | :--- |
| Carriage | 600 lb. | 100 GP |
| Cart | 200 lb. | 15 GP |
| Chariot | 100 lb. | 250 GP |
| Feed per day | 10 lb. | 5 CP |
| **Saddle** | | |
| Exotic | 40 lb. | 60 GP |
| Military | 30 lb. | 20 GP |
| Riding | 25 lb. | 10 GP |
| Sled | 300 lb. | 20 GP |
| Stabling per day | — | 5 SP |
| Wagon | 400 lb. | 35 GP |

## Large Vehicles
The Airborne and Waterborne Vehicles table provides statistics for various types of large vehicles. The following notes apply.

### Speed
A ship sailing against a strong wind moves at half speed. In a dead calm (no wind), waterborne ships can’t move under sail and must be rowed. Keelboats and Rowboats are used on lakes and rivers. If going downstream, add the speed of the current (typically 3 miles per hour) to the speed of the vehicle. These vehicles can’t be rowed against any significant current, but they can be pulled upstream by draft animals on the shores. A Rowboat can be carried and weighs 100 pounds.

### Airborne and Waterborne Vehicles
| Ship | Speed | Crew | Passengers | Cargo (Tons) | AC | HP | Damage Threshold | Cost |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Airship | 8 mph | 10 | 20 | 1 | 13 | 300 | — | 40,000 GP |
| Galley | 4 mph | 80 | — | 150 | 15 | 500 | 20 | 30,000 GP |
| Keelboat | 1 mph | 1 | 6 | 1/2 | 15 | 100 | 10 | 3,000 GP |
| Longship | 3 mph | 40 | 150 | 10 | 15 | 300 | 15 | 10,000 GP |
| Rowboat | 1½ mph | 1 | 3 | — | 11 | 50 | — | 50 GP |
| Sailing Ship | 2 mph | 20 | 20 | 100 | 15 | 300 | 15 | 10,000 GP |
| Warship | 2½ mph | 60 | 60 | 200 | 15 | 500 | 20 | 25,000 GP |

### Crew
A ship larger than a Keelboat or Rowboat needs a crew of skilled hirelings (see “Hirelings” later in “Equipment”) to function. The minimum number of skilled hirelings needed to crew a ship depends on the type of ship, as shown in the table.

### Passengers
The table lists the number of Small and Medium passengers the ship can accommodate using hammocks. A ship outfitted with private accommodations can carry one-fifth as many passengers. A passenger usually pays 5 SP per day for a hammock, but prices can vary from ship to ship. A small private cabin usually costs 2 GP per day.

### Damage Threshold
If a vehicle has a damage threshold (see “Rules Glossary”), it’s noted in the table.

### Ship Repair
Repairs to a damaged ship can be made while the vessel is berthed. Repairing 1 Hit Point of damage requires 1 day and costs 20 GP for materials and labor. If the repairs are made in a location where supplies and skilled labor are abundant, such as a city shipyard, the repair time and cost are halved.

## Lifestyle Expenses
Lifestyle expenses summarize the cost of living in a fantasy world. They cover lodging, food, equipment maintenance, and other necessities.

At the start of each week or month (GM’s choice), choose a lifestyle below—Wretched, Squalid, Poor, Modest, Comfortable, Wealthy, or Aristocratic—and pay the price to sustain that lifestyle.

Lifestyles have no inherent consequences, but the GM might take them into account when determining risks or how others perceive your character.

### Wretched (Free)
You survive via chance and charity. You’re often exposed to natural dangers as a result of sleeping outside.

### Squalid (1 SP per Day)
You spend the bare minimum for your necessities. You might be exposed to unhealthy conditions and opportunistic criminals.

### Poor (2 SP per Day)
You spend frugally for your necessities.

### Modest (1 GP per Day)
You support yourself at an average level.

### Comfortable (2 GP per Day)
You spend modestly for your necessities and enjoy a few luxuries.

### Wealthy (4 GP per Day)
You’re accustomed to the finer things in life and might have servants.

### Aristocratic (10 GP per Day)
You pay for the best and might have a staff that supports your lifestyle. Others notice your wealth and might encourage you to share it, either legally or otherwise.

## Food, Drink, and Lodging
The Food, Drink, and Lodging table gives prices for food and a single night’s lodging. Prices for daily lodging and meals are included in your lifestyle’s expenses.

### Food, Drink, and Lodging
| Item | Cost |
| :--- | :--- |
| Ale (mug) | 4 CP |
| Bread (loaf) | 2 CP |
| Cheese (wedge) | 1 SP |
| **Inn Stay per Day** | |
| Squalid | 7 CP |
| Poor | 1 SP |
| Modest | 5 SP |

| Item | Cost |
| :--- | :--- |
| Comfortable | 8 SP |
| Wealthy | 2 GP |
| Aristocratic | 4 GP |
| **Meal** | |
| Squalid | 1 CP |
| Poor | 2 CP |
| Modest | 1 SP |

| Item | Cost |
| :--- | :--- |
| Comfortable | 2 SP |
| Wealthy | 3 SP |
| Aristocratic | 6 SP |

| Item | Cost |
| :--- | :--- |
| **Wine (bottle)** | |
| Common | 2 SP |
| Fine | 10 GP |

## Hirelings
Skilled hirelings include anyone hired to perform a service that involves a proficiency (including weapon, tool, or skill): a mercenary, an artisan, a scribe, or the like. The pay shown on the Hirelings table is a minimum; some expert hirelings require more pay. Untrained hirelings are hired for work that requires no particular proficiencies; they include laborers and porters.

### Hirelings
| Service | Cost |
| :--- | :--- |
| Skilled hireling | 2 GP per day |
| Untrained hireling | 2 SP per day |
| Messenger | 2 CP per mile |

## Spellcasting
Most settlements contain individuals who are willing to cast spells in exchange for payment. If a spell has expensive components, add the cost of those components to the cost listed in the Spellcasting Services table. The higher the level of a desired spell, the harder it is to find someone to cast it.

### Spellcasting Services
| Spell Level | Availability | Cost |
| :--- | :--- | :--- |
| Cantrip | Village, town, or city | 30 GP |
| 1 | Village, town, or city | 50 GP |
| 2 | Village, town, or city | 200 GP |
| 3 | Town or city only | 300 GP |
| 4–5 | Town or city only | 2,000 GP |
| 6–8 | City only | 20,000 GP |
| 9 | City only | 100,000 GP |

## Magic Items
Adventures hold the promise—but not a guarantee—of finding magic items. Hundreds of magic items are detailed in “Magic Items” later in this document. Here’s what you need to know about using magic items.

### Identifying a Magic Item
Some magic items are indistinguishable from their nonmagical counterparts, while others are conspicuously magical. Handling a magic item is enough to give you a sense that it is extraordinary, but learning a magic item’s properties isn’t automatic.

The *Identify* spell is the fastest way to reveal an item’s properties. Alternatively, you can focus on one magic item during a Short Rest while being in physical contact with the item. At the end of the rest, you learn its properties and how to use them (but not any curse the item might bear).

Sometimes a magic item carries a clue to its properties. The command word to activate a ring might be etched inside the band, or a feathered design might hint that it’s a *Ring of Feather Falling*.

Wearing or experimenting with an item can also offer hints about its properties. In the specific case of Potions, a little taste is enough to tell the taster what a potion does. Other items might require more experimentation. For example, if your character puts on a *Ring of Swimming*, the GM might say, “Your movement feels strangely fluid.” Perhaps you then dive into a river to see what happens. The GM would then say you swim unexpectedly well.

### Attunement
Some magic items require a creature to form a bond—called Attunement—with them before the creature can use an item’s magical properties. Without becoming attuned to an item that requires Attunement, you gain only its nonmagical benefits unless its description states otherwise. For example, a magic Shield that requires Attunement provides the benefits of a normal Shield if you aren’t attuned to it, but none of its magical properties.

#### Attune during a Short Rest
Attuning to an item requires you to spend a Short Rest focused on only that item while being in physical contact with it (this can’t be the same Short Rest used to learn the item’s properties). This focus can take the form of weapon practice (for a Weapon), meditation (for a Wand), or some other appropriate activity. If the Short Rest is interrupted, the Attunement attempt fails. Otherwise, at the end of the Short Rest, you’re attuned to the magic item and can access its full magical capabilities.

#### No More Than Three Items
You can be attuned to no more than three magic items at a time. Any attempt to attune to a fourth item fails; you must end your Attunement to an item first. Additionally, you can’t attune to more than one copy of an item. For example, you can’t attune to more than one *Ring of Protection* at a time.

#### Ending Attunement
Your Attunement to an item ends if you no longer satisfy the prerequisites for Attunement, if the item has been more than 100 feet away for at least 24 hours, if you die, or if another creature attunes to the item. You can also voluntarily end Attunement by spending another Short Rest focused on the item unless the item is cursed.

### Wearing and Wielding Items
Using a magic item’s properties might mean wearing or wielding it. A magic item meant to be worn must be donned in the intended fashion: boots go on feet, gloves on hands, hats and helmets on a head, and rings on a finger. Magic armor must be donned, a Shield strapped to the arm, a cloak fastened about the shoulders. A weapon must be held.

In most cases, a magic item that’s meant to be worn can fit a creature regardless of size or build. Magic garments are made to be easily adjustable, or they magically adjust themselves to the wearer.

### Multiple Items of the Same Kind
You can’t wear more than one of certain magic items. You can’t normally wear more than one pair of footwear, one pair of gloves or gauntlets, one pair of bracers, one suit of armor, one item of headwear, or one cloak. The GM might make exceptions.

### Paired Items
Items that come in pairs—such as boots, bracers, gauntlets, and gloves—impart their benefits only if both items of the pair are worn. For example, a character wearing a *Boot of Striding and Springing* on one foot and a *Boot of Elvenkind* on the other foot gains no benefit from either.

## Crafting Nonmagical Items
To craft a nonmagical item, you need tools, raw materials, and time, each of which is detailed below. If you meet the requirements, you make the item, and you can use it or sell it at its normal price.

### Tools
The “Tools” section of “Equipment” lists which tools are required to make certain items. The GM assigns required tools for items not listed there.
You must use the required tool to make an item and have proficiency with that tool. Anyone who helps you must also have proficiency with it.

### Raw Materials
To make an item, you need raw materials worth half its purchase cost (round down). For example, you need 750 GP of raw materials to make Plate Armor, which sells for 1,500 GP. The GM determines whether appropriate raw materials are available.

### Time
To determine how many days (working 8 hours a day) it takes to make an item, divide its purchase cost in GP by 10 (round a fraction up to a day). For example, you need 5 days to make a Heavy Crossbow, which sells for 50 GP.

If an item requires multiple days, the days needn’t be consecutive.

Characters can combine their efforts to shorten the crafting time. Divide the time needed to create an item by the number of characters working on it. Normally, only one other character can assist you, but the GM might allow more assistants.

## Brewing Potions of Healing
A character who has proficiency with the Herbalism Kit can create a *Potion of Healing*. Doing so requires using that kit and 25 GP of raw material over the course of 1 day (8 hours of work).

## Scribing Spell Scrolls
A spellcaster can transfer a spell to a scroll and create a *Spell Scroll*, using the rules below.

### Time and Cost
Scribing a scroll takes an amount of time and money based on the level of the spell, as shown in the Spell Scroll Costs table. For each day of inscription, you must work for 8 hours. If a scroll requires multiple days, those days needn’t be consecutive.

### Prerequisites for the Scribe
To scribe a scroll, you must have proficiency in the Arcana skill or with Calligrapher’s Supplies and have the spell prepared on each day of the inscription. You must also have at hand any Material components required by the spell; if the spell consumes its Material components, they are consumed only when you complete the scroll. The scroll’s spell uses your spell save DC and spell attack bonus.

### Cantrips
If the scribed spell is a cantrip, the version on the scroll works as if the caster were your level.

#### Spell Scroll Costs
| Spell Level | Time | Cost |
| :--- | :--- | :--- |
| Cantrip | 1 day | 15 GP |
| 1 | 1 day | 25 GP |
| 2 | 3 days | 100 GP |
| 3 | 5 days | 150 GP |
| 4 | 10 days | 1,000 GP |
| 5 | 25 days | 1,500 GP |
| 6 | 40 days | 10,000 GP |
| 7 | 50 days | 12,500 GP |
| 8 | 60 days | 15,000 GP |
| 9 | 120 days | 50,000 GP |