# Spells

## Gaining Spells
Before you can cast a spell, you must have the spell prepared in your mind or have access to the spell from a magic item, such as a *Spell Scroll*. Your features specify which spells you have access to, if any; whether you always have certain spells prepared; and whether you can change the list of spells you have prepared.

### Preparing Spells
If you have a list of level 1+ spells you prepare, your spellcasting feature specifies when you can change the list and the number of spells you can change, as summarized in the Spell Preparation by Class table.

**Spell Preparation by Class**
| Class | Change When You | Number of Spells |
| :--- | :--- | :--- |
| Bard | Gain a level | One |
| Cleric | Finish a Long Rest | Any |
| Druid | Finish a Long Rest | Any |
| Paladin | Finish a Long Rest | One |
| Ranger | Finish a Long Rest | One |
| Sorcerer | Gain a level | One |
| Warlock | Gain a level | One |
| Wizard | Finish a Long Rest | Any |

Most spellcasting monsters don't change their lists of prepared spells, but the GM is free to alter them.

### Always-Prepared Spells
Certain features might give you a spell that you always have prepared. If you also have a list of prepared spells that you can change, a spell that you always have prepared doesn't count against the number of spells on that list.

## Casting Spells
Each spell description has a series of entries that provide the details needed to cast the spell. The following sections explain each of those entries, which follow a spell's name.

> **CASTING IN ARMOR**
> You must have training with any armor you are wearing to cast spells while wearing it. You are otherwise too hampered by the armor for spellcasting.

## Spell Level
Every spell has a level from 0 to 9, which is indicated in a spell's description. A spell's level is an indicator of how powerful it is. Cantrips—simple spells that can be cast almost by rote—are level 0. The rules for each spellcasting class say when its members gain access to spells of certain levels.

## Spell Slots
Spellcasting is taxing, so a spellcaster can cast only a limited number of level 1+ spells before resting. Spell slots are the main way a spellcaster's magical potential is represented. Each spellcasting class gives its members a limited number of spell slots of certain spell levels. For example, a level 3 Wizard has four level 1 spell slots and two level 2 slots.
When you cast a spell, you expend a slot of that spell's level or higher, effectively "filling” a slot with the spell. Imagine a spell slot is a groove of a certain size—small for a level 1 slot and larger for a higher-level spell. A level 1 spell fits into a slot of any size, but a level 2 spell fits only into a slot that's at least level 2. So when a level 3 Wizard casts *Magic Missile*, a level 1 spell, that Wizard spends one of four level 1 slots and has three remaining.
Finishing a Long Rest restores any expended spell slots.

## Casting without Slots
There are several ways to cast a spell without expending a spell slot:

**Cantrips.** A cantrip is cast without a spell slot.
**Rituals.** Certain spells have the Ritual tag in the Casting Time entry. Such a spell can be cast following the normal rules for spellcasting, or it can be cast as a Ritual. The Ritual version of a spell takes 10 minutes longer to cast than normal, but it doesn't expend a spell slot. To cast a spell as a Ritual, a spellcaster must have it prepared.
**Special Abilities.** Some characters and monsters have special abilities that allow them to cast specific spells without a spell slot. This casting is usually limited in another way, such as being able to cast the spell a limited number of times per day.
**Magic Items.** *Spell Scrolls* and some other magic items contain spells that can be cast without a spell slot. The description of such an item specifies how many times a spell can be cast from it.

## Using a Higher-Level Spell Slot
When a spellcaster casts a spell using a slot that is of a higher level than the spell, the spell takes on the higher level for that casting. For instance, if a Wizard casts *Magic Missile* using a level 2 slot, that *Magic Missile* is level 2. Effectively, the spell expands to fill the slot it is put into.

Some spells, such as *Magic Missile* and *Cure Wounds*, have more powerful effects when cast at a higher level, as detailed in a spell's description.

---
*104 System Reference Document 5.2.1*
---
## School of Magic
Each spell belongs to a school of magic. The schools are listed in the Schools of Magic table. These categories help describe spells but have no rules of their own, although some other rules refer to them.

**Schools of Magic**
| School | Typical Effects |
| :--- | :--- |
| Abjuration | Prevents or reverses harmful effects |
| Conjuration | Transports creatures or objects |
| Divination | Reveals information |
| Enchantment | Influences minds |
| Evocation | Channels energy to create effects that are often destructive |
| Illusion | Deceives the mind or senses |
| Necromancy | Manipulates life and death |
| Transmutation | Transforms creatures or objects |

## Class Spell Lists
If a spell is on a class's spell list, the class's name appears in parentheses after the spell's school of magic. Some features add a spell to a character's spell list even if the character isn't a member of a class in the parentheses.

## Casting Time
Most spells require the Magic action to cast, but some spells require a Bonus Action, a Reaction, or 1 minute or more. A spell's Casting Time entry specifies which of those is required.

### One Spell with a Spell Slot per Turn
On a turn, you can expend only one spell slot to cast a spell. This rule means you can't, for example, cast a spell with a spell slot using the Magic action and another one using a Bonus Action on the same turn.

### Reaction and Bonus Action Triggers
A spell that has a casting time of a Reaction is cast in response to a trigger that is defined in the spell's Casting Time entry. Some spells that have a casting time of a Bonus Action are also cast in response to a trigger defined in the spell.

### Longer Casting Times
Certain spells—including a spell cast as a Ritual—require more time to cast: minutes or even hours. While you cast a spell with a casting time of 1 minute or more, you must take the Magic action on each of your turns, and you must maintain Concentration (see "Rules Glossary") while you do so. If your Concentration is broken, the spell fails, but you don't expend a spell slot. To cast the spell again, you must start over.

## Range
A spell's range indicates how far from the spellcaster the spell's effect can originate, and the spell's description specifies which part of the effect is limited by the range.
A range usually takes one of the following forms:

**Distance.** The range is expressed in feet.
**Touch.** The spell's effect originates on something, as defined by the spell, that the spellcaster must touch within their reach.
**Self.** The spell is cast on the spellcaster or emanates from them, as specified in the spell.

If a spell has movable effects, they aren't restricted by its range unless the spell's description says otherwise.

## Components
A spell's components are physical requirements the spellcaster must meet to cast the spell. Each spell's description indicates whether it requires Verbal (V), Somatic (S), or Material (M) components. If the spellcaster can't provide one or more of a spell's components, the spellcaster can't cast the spell.

### Verbal (V)
A Verbal component is the chanting of esoteric words that sound like nonsense to the uninitiated. The words must be uttered in a normal speaking voice. The words themselves aren't the source of the spell's power; rather, the particular combination of sounds, with specific pitch and resonance, sets the threads of magic in motion. Thus, a creature who is gagged or in an area of magical silence can't cast a spell with a Verbal component.

### Somatic (S)
A Somatic component is a forceful gesticulation or an intricate set of gestures. A spellcaster must use at least one of their hands to perform these movements.

### Material (M)
A Material component is a particular material used in a spell's casting, as specified in parentheses in the Components entry. These materials aren't consumed by the spell unless the spell's description states otherwise. The spellcaster must have a hand free to access them, but it can be the same hand used to perform Somatic components, if any.
If a spell doesn't consume its materials and doesn't specify a cost for them, a spellcaster can use a Component Pouch (see "Equipment”) instead of providing the materials specified in the spell, or the spellcaster can substitute a Spellcasting Focus if the caster has a feature that allows that substitution. To use a Component Pouch, you must have a hand free to reach into it, and to use a Spellcasting Focus, you must hold it unless its description says otherwise (see "Equipment" for descriptions).

---
*105 System Reference Document 5.2.1*
---
## Duration
A spell's duration is the length of time the spell persists after it is cast. A duration typically takes one of the following forms:

**Concentration.** A duration that requires Concentration follows the Concentration rules (see "Rules Glossary").
**Instantaneous.** An instantaneous duration means the spell's magic appears only for a moment and then disappears.
**Time Span.** A duration that provides a time span specifies how long the spell lasts in rounds, minutes, hours, or the like. For example, a Duration entry might say "1 minute,” meaning the spell ends after 1 minute has passed. While a time-span spell that you cast is ongoing, you can dismiss it (no action required) if you don't have the Incapacitated condition.

## Effects
The effects of a spell are detailed after its duration entry. Those details present exactly what the spell does, which ignores mundane physical laws; any outcomes beyond those effects are under the GM's purview. Whatever the effects, they typically deal with targets, saving throws, attack rolls, or all three, each of which is detailed below.

## Targets
A typical spell requires the caster to pick one or more targets to be affected by the spell's magic. A spell's description says whether the spell targets creatures, objects, or something else.
**A Clear Path to the Target.** To target something with a spell, a caster must have a clear path to it, so it can't be behind Total Cover.
**Targeting Yourself.** If a spell targets a creature of your choice, you can choose yourself unless the creature must be Hostile or specifically a creature other than you.
**Areas of Effect.** Some spells, such as *Thunderwave*, cover an area called an area of effect, which is defined in "Rules Glossary." The area determines what the spell targets. The description of a spell specifies whether it has an area of effect, which is typically one of these shapes: Cone, Cube, Cylinder, Emanation, Line, or Sphere.
**Awareness of Being Targeted.** Unless a spell has a perceptible effect, a creature doesn't know it was targeted by the spell. An effect like lightning is obvious, but a more subtle effect, such as an attempt to read thoughts, goes unnoticed unless a spell's description says otherwise.
**Invalid Targets.** If you cast a spell on someone or something that can't be affected by it, nothing happens to that target, but if you used a spell slot to cast the spell, the slot is still expended.
If the spell normally has no effect on a target that succeeds on a saving throw, the invalid target appears to have succeeded on its saving throw, even though it didn't attempt one (giving no hint that the creature is an invalid target). Otherwise, you perceive that the spell did nothing to the target.

## Saving Throws
Many spells specify that a target makes a saving throw to avoid some or all of a spell's effects. The spell specifies the ability that the target uses for the save and what happens on a success or failure. Here's how to calculate the DC for your spells:

> Spell save DC = 8 + your spellcasting ability modifier + your Proficiency Bonus

## Attack Rolls
Some spells require the caster to make an attack roll to determine whether the spell hits a target. Here's how to calculate the attack modifier for your spells:

> Spell attack modifier = your spellcasting ability modifier + your Proficiency Bonus

## Combining Spell Effects
The effects of different spells add together while their durations overlap. In contrast, the effects of the same spell cast multiple times don't combine. Instead, the most potent effect—such as the highest bonus—from those castings applies while their durations overlap. The most recent effect applies if the castings are equally potent and their durations overlap. For example, if two Clerics cast *Bless* on the same target, that target gains the spell's benefit only once; the target doesn't receive two bonus dice. But if the durations of the spells overlap, the effect continues until the duration of the second *Bless* ends.

> **IDENTIFYING AN ONGOING SPELL**
> You can try to identify a non-instantaneous spell by its observable effects if its duration is ongoing. To identify it, you must take the Study action and succeed on a DC 15 Intelligence (Arcana) check.

---
*106 System Reference Document 5.2.1*
---

# Spell Descriptions

### Acid Arrow
*Level 2 Evocation (Wizard)*
**Casting Time:** Action
**Range:** 90 feet
**Components:** V, S, M (powdered rhubarb leaf)
**Duration:** Instantaneous

A shimmering green arrow streaks toward a target within range and bursts in a spray of acid. Make a ranged spell attack against the target. On a hit, the target takes 4d4 Acid damage and 2d4 Acid damage at the end of its next turn. On a miss, the arrow splashes the target with acid for half as much of the initial damage only.
***Using a Higher-Level Spell Slot.*** The damage (both initial and later) increases by 1d4 for each spell slot level above 2.

### ACID SPLASH
*Evocation Cantrip (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

You create an acidic bubble at a point within range, where it explodes in a 5-foot-radius Sphere. Each creature in that Sphere must succeed on a Dexterity saving throw or take 1d6 Acid damage.
***Cantrip Upgrade.*** The damage increases by 1d6 when you reach levels 5 (2d6), 11 (3d6), and 17 (4d6).

### Aid
*Level 2 Abjuration (Bard, Cleric, Druid, Paladin, Ranger)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a strip of white cloth)
**Duration:** 8 hours

Choose up to three creatures within range. Each target's Hit Point maximum and current Hit Points increase by 5 for the duration.
***Using a Higher-Level Spell Slot.*** Each target's Hit Points increase by 5 for each spell slot level above 2.

### Alarm
*Level 1 Abjuration (Ranger, Wizard)*
**Casting Time:** 1 minute or Ritual
**Range:** 30 feet
**Components:** V, S, M (a bell and silver wire)
**Duration:** 8 hours

You set an alarm against intrusion. Choose a door, a window, or an area within range that is no larger than a 20-foot Cube. Until the spell ends, an alarm alerts you whenever a creature touches or enters the warded area. When you cast the spell, you can designate creatures that won't set off the alarm. You also choose whether the alarm is audible or mental:

**Audible Alarm.** The alarm produces the sound of a handbell for 10 seconds within 60 feet of the warded area.
**Mental Alarm.** You are alerted by a mental ping if you are within 1 mile of the warded area. This ping awakens you if you're asleep.

### Alter Self
*Level 2 Transmutation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 hour

You alter your physical form. Choose one of the following options. Its effects last for the duration, during which you can take a Magic action to replace the option you chose with a different one.
**Aquatic Adaptation.** You sprout gills and grow webs between your fingers. You can breathe underwater and gain a Swim Speed equal to your Speed.
**Change Appearance.** You alter your appearance. You decide what you look like, including your height, weight, facial features, sound of your voice, hair length, coloration, and other distinguishing characteristics. You can make yourself appear as a member of another species, though none of your statistics change. You can't appear as a creature of a different size, and your basic shape stays the same; if you're bipedal, you can't use this spell to become quadrupedal, for instance. For the duration, you can take a Magic action to change your appearance in this way again.
**Natural Weapons.** You grow claws (Slashing), fangs (Piercing), horns (Piercing), or hooves (Bludgeoning). When you use your Unarmed Strike to deal damage with that new growth, it deals 1d6 damage of the type in parentheses instead of dealing the normal damage for your Unarmed Strike, and you use your spellcasting ability modifier for the attack and damage rolls rather than using Strength.

### Animal Friendship
*Level 1 Enchantment (Bard, Druid, Ranger)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a morsel of food)
**Duration:** 24 hours

Target a Beast that you can see within range. The target must succeed on a Wisdom saving throw or have the Charmed condition for the duration. If you or one of your allies deals damage to the target, the spell ends.
***Using a Higher-Level Spell Slot.*** You can target one additional Beast for each spell slot level above 1.

---
*107 System Reference Document 5.2.1*
---
### Animal Messenger
*Level 2 Enchantment (Bard, Druid, Ranger)*
**Casting Time:** Action or Ritual
**Range:** 30 feet
**Components:** V, S, M (a morsel of food)
**Duration:** 24 hours

A Tiny Beast of your choice that you can see within range must succeed on a Charisma saving throw, or it attempts to deliver a message for you (if the target's Challenge Rating isn't 0, it automatically succeeds). You specify a location you have visited and a recipient who matches a general description, such as "a person dressed in the uniform of the town guard” or “a red-haired dwarf wearing a pointed hat." You also communicate a message of up to twenty-five words. The Beast travels for the duration toward the specified location, covering about 25 miles per 24 hours or 50 miles if the Beast can fly.
When the Beast arrives, it delivers your message to the creature that you described, mimicking your communication. If the Beast doesn't reach its destination before the spell ends, the message is lost, and the Beast returns to where you cast the spell.
***Using a Higher-Level Spell Slot.*** The spell's duration increases by 48 hours for each spell slot level above 2.

### Animal Shapes
*Level 8 Transmutation (Druid)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** 24 hours

Choose any number of willing creatures that you can see within range. Each target shape-shifts into a Large or smaller Beast of your choice that has a Challenge Rating of 4 or lower. You can choose a different form for each target. On later turns, you can take a Magic action to transform the targets again.
A target's game statistics are replaced by the chosen Beast's statistics, but the target retains its creature type; Hit Points; Hit Point Dice; alignment; ability to communicate; and Intelligence, Wisdom, and Charisma scores. The target's actions are limited by the Beast form's anatomy, and it can't cast spells. The target's equipment melds into the new form, and the target can't use any of that equipment while in that form.
The target gains a number of Temporary Hit Points equal to the Hit Points of the first form into which it shape-shifts. These Temporary Hit Points vanish if any remain when the spell ends. The transformation lasts for the duration or until the target ends it as a Bonus Action.

### Animate Dead
*Level 3 Necromancy (Cleric, Wizard)*
**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, S, M (a drop of blood, a piece of flesh, and a pinch of bone dust)
**Duration:** Instantaneous

Choose a pile of bones or a corpse of a Medium or Small Humanoid within range. The target becomes an Undead creature: a Skeleton if you chose bones or a Zombie if you chose a corpse (see "Monsters” for the stat blocks).
On each of your turns, you can take a Bonus Action to mentally command any creature you made with this spell if the creature is within 60 feet of you (if you control multiple creatures, you can command any of them at the same time, issuing the same command to each one). You decide what action the creature will take and where it will move on its next turn, or you can issue a general command, such as to guard a chamber or corridor. If you issue no commands, the creature takes the Dodge action and moves only to avoid harm. Once given an order, the creature continues to follow it until its task is complete.
The creature is under your control for 24 hours, after which it stops obeying any command you've given it. To maintain control of the creature for another 24 hours, you must cast this spell on the creature again before the current 24-hour period ends. This use of the spell reasserts your control over up to four creatures you have animated with this spell rather than animating a new creature.
***Using a Higher-Level Spell Slot.*** You animate or reassert control over two additional Undead creatures for each spell slot level above 3. Each of the creatures must come from a different corpse or pile of bones.

### Animate Objects
*Level 5 Transmutation (Bard, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Objects animate at your command. Choose a number of nonmagical objects within range that aren't being worn or carried, aren't fixed to a surface, and aren't Gargantuan. The maximum number of objects is equal to your spellcasting ability modifier; for this number, a Medium or smaller target counts as one object, a Large target counts as two, and a Huge target counts as three.
Each target animates, sprouts legs, and becomes a Construct that uses the **Animated Object** stat block; this creature is under your control until the spell ends or until it is reduced to 0 Hit Points. Each creature you make with this spell is an ally to you and your allies. In combat, it shares your Initiative count and takes its turn immediately after yours.
Until the spell ends, you can take a Bonus Action to mentally command any creature you made with this spell if the creature is within 500 feet of you (if you control multiple creatures, you can command any of them at the same time, issuing the same command to each one). If you issue no commands, the creature takes the Dodge action and moves only to avoid harm. When the creature drops to 0 Hit Points, it reverts to its object form, and any remaining damage carries over to that form.
***Using a Higher-Level Spell Slot.*** The creature's Slam damage increases by 1d4 (Medium or smaller), 1d6 (Large), or 1d12 (Huge) for each spell slot level above 5.

---
*108 System Reference Document 5.2.1*
---

> **Animated Object**
> *Huge or Smaller Construct, Unaligned*
> 
> **AC** 15
> **HP** 10 (Medium or smaller), 20 (Large), 40 (Huge)
> **Speed** 30 ft.
> 
> | | MOD | SAVE | | MOD | SAVE | | MOD | SAVE |
> | :-: | :-: | :-: | :-: | :-: | :-: | :-: | :-: | :-: |
> | **STR** 16 | +3 | +3 | **DEX** 10 | +0 | +0 | **CON** 10 | +0 | +0 |
> | **INT** 3 | -4 | -4 | **WIS** 3 | -4 | -4 | **CHA** 1 | -5 | -5 |
> 
> **Immunities** Poison, Psychic; Charmed, Exhaustion, Frightened, Paralyzed, Poisoned
> **Senses** Blindsight 30 ft.; Passive Perception 6
> **Languages** Understands the languages you know
> **CR** None (XP 0; PB equals your Proficiency Bonus)
> 
> **Actions**
> **Slam.** *Melee Attack Roll:* Bonus equals your spell attack modifier, reach 5 ft. *Hit:* Force damage equal to 1d4 + 3 (Medium or smaller), 2d6 + 3 + your spellcasting ability modifier (Large), or 2d12 + 3 + your spellcasting ability modifier (Huge).

### Antilife Shell
*Level 5 Abjuration (Druid)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 hour

An aura extends from you in a 10-foot Emanation for the duration. The aura prevents creatures other than Constructs and Undead from passing or reaching through it. An affected creature can cast spells or make attacks with Ranged or Reach weapons through the barrier.
If you move so that an affected creature is forced to pass through the barrier, the spell ends.

### Antimagic Field
*Level 8 Abjuration (Cleric, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (iron filings)
**Duration:** Concentration, up to 1 hour

An aura of antimagic surrounds you in 10-foot Emanation. No one can cast spells, take Magic actions, or create other magical effects inside the aura, and those things can't target or otherwise affect anything inside it. Magical properties of magic items don't work inside the aura or on anything inside it.
Areas of effect created by spells or other magic can't extend into the aura, and no one can teleport into or out of it or use planar travel there. Portals close temporarily while in the aura.
Ongoing spells, except those cast by an Artifact or a deity, are suppressed in the area. While an effect is suppressed, it doesn't function, but the time it spends suppressed counts against its duration.
*Dispel Magic* has no effect on the aura, and the auras created by different *Antimagic Field* spells don't nullify each other.

### Antipathy/Sympathy
*Level 8 Enchantment (Bard, Druid, Wizard)*
**Casting Time:** 1 hour
**Range:** 60 feet
**Components:** V, S, M (a mix of vinegar and honey)
**Duration:** 10 days

As you cast the spell, choose whether it creates antipathy or sympathy, and target one creature or object that is Huge or smaller. Then specify a kind of creature, such as red dragons, goblins, or vampires.
A creature of the chosen kind makes a Wisdom saving throw when it comes within 120 feet of the target. Your choice of antipathy or sympathy determines what happens to a creature when it fails that save:

**Antipathy.** The creature has the Frightened condition. The Frightened creature must use its movement on its turns to get as far away as possible from the target, moving by the safest route.
**Sympathy.** The creature has the Charmed condition. The Charmed creature must use its movement on its turns to get as close as possible to the target, moving by the safest route. If the creature is within 5 feet of the target, the creature can't willingly move away. If the target damages the Charmed creature, that creature can make a Wisdom saving throw to end the effect, as described below.

---
*109 System Reference Document 5.2.1*
---
***Ending the Effect.*** If the Frightened or Charmed creature ends its turn more than 120 feet away from the target, the creature makes a Wisdom saving throw. On a successful save, the creature is no longer affected by the target. A creature that successfully saves against this effect is immune to it for 1 minute, after which it can be affected again.

### Arcane Eye
*Level 4 Divination (Wizard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a bit of bat fur)
**Duration:** Concentration, up to 1 hour

You create an Invisible, invulnerable eye within range that hovers for the duration. You mentally receive visual information from the eye, which can see in every direction. It also has Darkvision with a range of 30 feet.
As a Bonus Action, you can move the eye up to 30 feet in any direction. A solid barrier blocks the eye's movement, but the eye can pass through an opening as small as 1 inch in diameter.

### Arcane Hand
*Level 5 Evocation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S, M (an eggshell and a glove)
**Duration:** Concentration, up to 1 minute

You create a Large hand of shimmering magical energy in an unoccupied space that you can see within range. The hand lasts for the duration, and it moves at your command, mimicking the movements of your own hand.
The hand is an object that has AC 20 and Hit Points equal to your Hit Point maximum. If it drops to 0 Hit Points, the spell ends. The hand doesn't occupy its space.
When you cast the spell and as a Bonus Action on your later turns, you can move the hand up to 60 feet and then cause one of the following effects:

**Clenched Fist.** The hand strikes a target within 5 feet of it. Make a melee spell attack. On a hit, the target takes 5d8 Force damage.
**Forceful Hand.** The hand attempts to push a Huge or smaller creature within 5 feet of it. The target must succeed on a Strength saving throw, or the hand pushes the target up to 5 feet plus a number of feet equal to five times your spellcasting ability modifier. The hand moves with the target, remaining within 5 feet of it.
**Grasping Hand.** The hand attempts to grapple a Huge or smaller creature within 5 feet of it. The target must succeed on a Dexterity saving throw, or the target has the Grappled condition, with an escape DC equal to your spell save DC. While the hand grapples the target, you can take a Bonus Action to cause the hand to crush it, dealing Bludgeoning damage to the target equal to 4d6 plus your spellcasting ability modifier.
**Interposing Hand.** The hand grants you Half Cover against attacks and other effects that originate from its space or that pass through it. In addition, its space counts as Difficult Terrain for your enemies.

***Using a Higher-Level Spell Slot.*** The damage of the Clenched Fist increases by 2d8 and the damage of the Grasping Hand increases by 2d6 for each spell slot level above 5.

### Arcane Lock
*Level 2 Abjuration (Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (gold dust worth 25+ GP, which the spell consumes)
**Duration:** Until dispelled

You touch a closed door, window, gate, container, or hatch and magically lock it for the duration. This lock can't be unlocked by any nonmagical means. You and any creatures you designate when you cast the spell can open and close the object despite the lock. You can also set a password that, when spoken within 5 feet of the object, unlocks it for 1 minute.

### Arcane Sword
*Level 7 Evocation (Bard, Wizard)*
**Casting Time:** Action
**Range:** 90 feet
**Components:** V, S, M (a miniature sword worth 250+ GP)
**Duration:** Concentration, up to 1 minute

You create a spectral sword that hovers within range. It lasts for the duration.
When the sword appears, you make a melee spell attack against a target within 5 feet of the sword. On a hit, the target takes Force damage equal to 4d12 plus your spellcasting ability modifier.
On your later turns, you can take a Bonus Action to move the sword up to 30 feet to a spot you can see and repeat the attack against the same target or a different one.

### Arcanist's Magic Aura
*Level 2 Illusion (Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a small square of silk)
**Duration:** 24 hours

With a touch, you place an illusion on a willing creature or an object that isn't being worn or carried. A creature gains the Mask effect below, and an object gains the False Aura effect below. The effect lasts for the duration. If you cast the spell on the same target every day for 30 days, the illusion lasts until dispelled.
**Mask (Creature).** Choose a creature type other than the target's actual type. Spells and other magical effects treat the target as if it were a creature of the chosen type.
**False Aura (Object).** You change the way the target appears to spells and magical effects that detect magical auras, such as *Detect Magic*. You can make a nonmagical object appear magical, make a magic item appear nonmagical, or change the object's aura so that it appears to belong to a school of magic you choose.

---
*110 System Reference Document 5.2.1*
---
### Astral Projection
*Level 9 Necromancy (Cleric, Warlock, Wizard)*
**Casting Time:** 1 hour
**Range:** 10 feet
**Components:** V, S, M (for each of the spell's targets, one jacinth worth 1,000+ GP and one silver bar worth 100+ GP, all of which the spell consumes)
**Duration:** Until dispelled

You and up to eight willing creatures within range project your astral bodies into the Astral Plane (the spell ends instantly if you are already on that plane). Each target's body is left behind in a state of suspended animation; it has the Unconscious condition, doesn't need food or air, and doesn't age.
A target's astral form resembles its body in almost every way, replicating its game statistics and possessions. The principal difference is the addition of a silvery cord that trails from between the shoulder blades of the astral form. The cord fades from view after 1 foot. If the cord is cut—which happens only when an effect states that it does so—the target's body and astral form both die.
A target's astral form can travel through the Astral Plane. The moment an astral form leaves that plane, the target's body and possessions travel along the silver cord, causing the target to re-enter its body on the new plane.
Any damage or other effects that apply to an astral form have no effect on the target's body and vice versa. If a target's body or astral form drops to 0 Hit Points, the spell ends for that target. The spell ends for all the targets if you take a Magic action to dismiss it.
When the spell ends for a target who isn't dead, the target reappears in its body and exits the state of suspended animation.

### Augury
*Level 2 Divination (Cleric, Druid, Wizard)*
**Casting Time:** 1 minute or Ritual
**Range:** Self
**Components:** V, S, M (specially marked sticks, bones, cards, or other divinatory tokens worth 25+ GP)
**Duration:** Instantaneous

You receive an omen from an otherworldly entity about the results of a course of action that you plan to take within the next 30 minutes. The GM chooses the omen from the Omens table.

**Omens**
| Omen | For Results That Will Be ... |
| :--- | :--- |
| Weal | Good |
| Woe | Bad |
| Weal and woe | Good and bad |
| Indifference | Neither good nor bad |

The spell doesn't account for circumstances, such as other spells, that might change the results.
If you cast the spell more than once before finishing a Long Rest, there is a cumulative 25 percent chance for each casting after the first that you get no answer.

### Aura of Life
*Level 4 Abjuration (Cleric, Paladin)*
**Casting Time:** Action
**Range:** Self
**Components:** V
**Duration:** Concentration, up to 10 minutes

An aura radiates from you in a 30-foot Emanation for the duration. While in the aura, you and your allies have Resistance to Necrotic damage, and your Hit Point maximums can't be reduced. If an ally with 0 Hit Points starts its turn in the aura, that ally regains 1 Hit Point.

### Awaken
*Level 5 Transmutation (Bard, Druid)*
**Casting Time:** 8 hours
**Range:** Touch
**Components:** V, S, M (an agate worth 1,000+ GP, which the spell consumes)
**Duration:** Instantaneous

You spend the casting time tracing magical pathways within a precious gemstone, and then touch the target. The target must be either a Beast or Plant creature with an Intelligence of 3 or less or a natural plant that isn't a creature. The target gains an Intelligence of 10 and the ability to speak one language you know. If the target is a natural plant, it becomes a Plant creature and gains the ability to move its limbs, roots, vines, creepers, and so forth, and it gains senses similar to a human's. The GM chooses statistics appropriate for the awakened Plant, such as the statistics for the **Awakened Shrub** or **Awakened Tree** in "Monsters."
The awakened target has the Charmed condition for 30 days or until you or your allies deal damage to it. When that condition ends, the awakened creature chooses its attitude toward you.

---
*111 System Reference Document 5.2.1*
---
### Bane
*Level 1 Enchantment (Bard, Cleric, Warlock)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a drop of blood)
**Duration:** Concentration, up to 1 minute

Up to three creatures of your choice that you can see within range must each make a Charisma saving throw. Whenever a target that fails this save makes an attack roll or a saving throw before the spell ends, the target must subtract 1d4 from the attack roll or save.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 1.

### Banishment
*Level 4 Abjuration (Cleric, Paladin, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a pentacle)
**Duration:** Concentration, up to 1 minute

One creature that you can see within range must succeed on a Charisma saving throw or be transported to a harmless demiplane for the duration. While there, the target has the Incapacitated condition. When the spell ends, the target reappears in the space it left or in the nearest unoccupied space if that space is occupied.
If the target is an Aberration, a Celestial, an Elemental, a Fey, or a Fiend, the target doesn't return if the spell lasts for 1 minute. The target is instead transported to a random location on a plane (GM's choice) associated with its creature type.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 4.

### Barkskin
*Level 2 Transmutation (Druid, Ranger)*
**Casting Time:** Bonus Action
**Range:** Touch
**Component:** V, S, M (a handful of bark)
**Duration:** 1 hour

You touch a willing creature. Until the spell ends, the target's skin assumes a bark-like appearance, and the target has an Armor Class of 17 if its AC is lower than that.

### Beacon of Hope
*Level 3 Abjuration (Cleric)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Choose any number of creatures within range. For the duration, each target has Advantage on Wisdom saving throws and Death Saving Throws and regains the maximum number of Hit Points possible from any healing.

### Befuddlement
*Level 8 Enchantment (Bard, Druid, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 150 feet
**Components:** V, S, M (a key ring with no keys)
**Duration:** Instantaneous

You blast the mind of a creature that you can see within range. The target makes an Intelligence saving throw.
On a failed save, the target takes 10d12 Psychic damage and can't cast spells or take the Magic action. At the end of every 30 days, the target repeats the save, ending the effect on a success. The effect can also be ended by the *Greater Restoration*, *Heal*, or *Wish* spell.
On a successful save, the target takes half as much damage only.

### Bestow Curse
*Level 3 Necromancy (Bard, Cleric, Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You touch a creature, which must succeed on a Wisdom saving throw or become cursed for the duration. Until the curse ends, the target suffers one of the following effects of your choice:

*   Choose one ability. The target has Disadvantage on ability checks and saving throws made with that ability.
*   The target has Disadvantage on attack rolls against you.
*   In combat, the target must succeed on a Wisdom saving throw at the start of each of its turns or be forced to take the Dodge action on that turn.
*   If you deal damage to the target with an attack roll or a spell, the target takes an extra 1d8 Necrotic damage.

***Using a Higher-Level Spell Slot.*** If you cast this spell using a level 4 spell slot, you can maintain Concentration on it for up to 10 minutes. If you use a level 5+ spell slot, the spell doesn't require Concentration, and the duration becomes 8 hours (level 5–6 slot) or 24 hours (level 7–8 slot). If you use a level 9 spell slot, the spell lasts until dispelled.

---
*112 System Reference Document 5.2.1*
---
### Black Tentacles
*Level 4 Conjuration (Wizard)*
**Casting Time:** Action
**Range:** 90 feet
**Components:** V, S, M (a tentacle)
**Duration:** Concentration, up to 1 minute

Squirming, ebony tentacles fill a 20-foot square on ground that you can see within range. For the duration, these tentacles turn the ground in that area into Difficult Terrain.
Each creature in that area makes a Strength saving throw. On a failed save, it takes 3d6 Bludgeoning damage, and it has the Restrained condition until the spell ends. A creature also makes that save if it enters the area or ends its turn there. A creature makes that save only once per turn.
A Restrained creature can take an action to make a Strength (Athletics) check against your spell save DC, ending the condition on itself on a success.

### Blade Barrier
*Level 6 Evocation (Cleric)*
**Casting Time:** Action
**Range:** 90 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You create a wall of whirling blades made of magical energy. The wall appears within range and lasts for the duration. You make a straight wall up to 100 feet long, 20 feet high, and 5 feet thick, or a ringed wall up to 60 feet in diameter, 20 feet high, and 5 feet thick. The wall provides Three-Quarters Cover, and its space is Difficult Terrain.
Any creature in the wall's space makes a Dexterity saving throw, taking 6d10 Force damage on a failed save or half as much damage on a successful one. A creature also makes that save if it enters the wall's space or ends its turn there. A creature makes that save only once per turn.

### Bless
*Level 1 Enchantment (Cleric, Paladin)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a Holy Symbol worth 5+ GP)
**Duration:** Concentration, up to 1 minute

You bless up to three creatures within range. Whenever a target makes an attack roll or a saving throw before the spell ends, the target adds 1d4 to the attack roll or save.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 1.

### Blight
*Level 4 Necromancy (Druid, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

A creature that you can see within range makes a Constitution saving throw, taking 8d8 Necrotic damage on a failed save or half as much damage on a successful one. A Plant creature automatically fails the save.
Alternatively, target a nonmagical plant that isn't a creature, such as a tree or shrub. It doesn't make a save; it simply withers and dies.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 4.

### Blindness/Deafness
*Level 2 Transmutation (Bard, Cleric, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V
**Duration:** 1 minute

One creature that you can see within range must succeed on a Constitution saving throw, or it has the Blinded or Deafened condition (your choice) for the duration. At the end of each of its turns, the target repeats the save, ending the spell on itself on a success.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 2.

### Blink
*Level 3 Transmutation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** 1 minute

Roll 1d6 at the end of each of your turns for the duration. On a roll of 4–6, you vanish from your current plane of existence and appear in the Ethereal Plane (the spell ends instantly if you are already on that plane). While on the Ethereal Plane, you can perceive the plane you left, which is cast in shades of gray, but you can't see anything there more than 60 feet away. You can affect and be affected only by other creatures on the Ethereal Plane, and creatures on the other plane can't perceive you unless they have a special ability that lets them perceive things on the Ethereal Plane.
You return to the other plane at the start of your next turn and when the spell ends if you are on the Ethereal Plane. You return to an unoccupied space of your choice that you can see within 10 feet of the space you left. If no unoccupied space is available within that range, you appear in the nearest unoccupied space.

---
*113 System Reference Document 5.2.1*
---
### Blur
*Level 2 Illusion (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V
**Duration:** Concentration, up to 1 minute

Your body becomes blurred. For the duration, any creature has Disadvantage on attack rolls against you. An attacker is immune to this effect if it perceives you with Blindsight or Truesight.

### Burning Hands
*Level 1 Evocation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Instantaneous

A thin sheet of flames shoots forth from you. Each creature in a 15-foot Cone makes a Dexterity saving throw, taking 3d6 Fire damage on a failed save or half as much damage on a successful one.
Flammable objects in the Cone that aren't being worn or carried start burning.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 1.

### Call Lightning
*Level 3 Conjuration (Druid)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

A storm cloud appears at a point within range that you can see above yourself. It takes the shape of a Cylinder that is 10 feet tall with a 60-foot radius.
When you cast the spell, choose a point you can see under the cloud. A lightning bolt shoots from the cloud to that point. Each creature within 5 feet of that point makes a Dexterity saving throw, taking 3d10 Lightning damage on a failed save or half as much damage on a successful one.
Until the spell ends, you can take a Magic action to call down lightning in that way again, targeting the same point or a different one.
If you're outdoors in a storm when you cast this spell, the spell gives you control over that storm instead of creating a new one. Under such conditions, the spell's damage increases by 1d10.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d10 for each spell slot level above 3.

### Calm Emotions
*Level 2 Enchantment (Bard, Cleric)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Each Humanoid in a 20-foot-radius Sphere centered on a point you choose within range must succeed on a Charisma saving throw or be affected by one of the following effects (choose for each creature):

*   The creature has Immunity to the Charmed and Frightened conditions until the spell ends. If the creature was already Charmed or Frightened, those conditions are suppressed for the duration.
*   The creature becomes Indifferent about creatures of your choice that it's Hostile toward. This indifference ends if the target takes damage or witnesses its allies taking damage. When the spell ends, the creature's attitude returns to normal.

### Chain Lightning
*Level 6 Evocation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 150 feet
**Components:** V, S, M (three silver pins)
**Duration:** Instantaneous

You launch a lightning bolt toward a target you can see within range. Three bolts then leap from that target to as many as three other targets of your choice, each of which must be within 30 feet of the first target. A target can be a creature or an object and can be targeted by only one of the bolts.
Each target makes a Dexterity saving throw, taking 10d8 Lightning damage on a failed save or half as much damage on a successful one.
***Using a Higher-Level Spell Slot.*** One additional bolt leaps from the first target to another target for each spell slot level above 6.

### Charm Monster
*Level 4 Enchantment (Bard, Druid, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** 1 hour

One creature you can see within range makes a Wisdom saving throw. It does so with Advantage if you or your allies are fighting it. On a failed save, the target has the Charmed condition until the spell ends or until you or your allies damage it. The Charmed creature is Friendly to you. When the spell ends, the target knows it was Charmed by you.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 4.

---
*114 System Reference Document 5.2.1*
---
### Charm Person
*Level 1 Enchantment (Bard, Druid, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** 1 hour

One Humanoid you can see within range makes a Wisdom saving throw. It does so with Advantage if you or your allies are fighting it. On a failed save, the target has the Charmed condition until the spell ends or until you or your allies damage it. The Charmed creature is Friendly to you. When the spell ends, the target knows it was Charmed by you.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 1.

### Chill Touch
*Necromancy Cantrip (Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

Channeling the chill of the grave, make a melee spell attack against a target within reach. On a hit, the target takes 1d10 Necrotic damage, and it can't regain Hit Points until the end of your next turn.
***Cantrip Upgrade.*** The damage increases by 1d10 when you reach levels 5 (2d10), 11 (3d10), and 17 (4d10).

### Chromatic Orb
*Level 1 Evocation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 90 feet
**Components:** V, S, M (a diamond worth 50+ GP)
**Duration:** Instantaneous

You hurl an orb of energy at a target within range. Choose Acid, Cold, Fire, Lightning, Poison, or Thunder for the type of orb you create, and then make a ranged spell attack against the target. On a hit, the target takes 3d8 damage of the chosen type.
If you roll the same number on two or more of the d8s, the orb leaps to a different target of your choice within 30 feet of the target. Make an attack roll against the new target, and make a new damage roll. The orb can't leap again unless you cast the spell with a level 2+ spell slot.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 1. The orb can leap a maximum number of times equal to the level of the slot expended, and a creature can be targeted only once by each casting of this spell.

### Circle of Death
*Level 6 Necromancy (Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 150 feet
**Components:** V, S, M (the powder of a crushed black pearl worth 500+ GP)
**Duration:** Instantaneous

Negative energy ripples out in a 60-foot-radius Sphere from a point you choose within range. Each creature in that area makes a Constitution saving throw, taking 8d8 Necrotic damage on a failed save or half as much damage on a successful one.
***Using a Higher-Level Spell Slot.*** The damage increases by 2d8 for each spell slot level above 6.

### Clairvoyance
*Level 3 Divination (Bard, Cleric, Sorcerer, Wizard)*
**Casting Time:** 10 minutes
**Range:** 1 mile
**Components:** V, S, M (a focus worth 100+ GP, either a jeweled horn for hearing or a glass eye for seeing)
**Duration:** Concentration, up to 10 minutes

You create an Invisible sensor within range in a location familiar to you (a place you have visited or seen before) or in an obvious location that is unfamiliar to you (such as behind a door, around a corner, or in a grove of trees). The intangible, invulnerable sensor remains in place for the duration.
When you cast the spell, choose seeing or hearing. You can use the chosen sense through the sensor as if you were in its space. As a Bonus Action, you can switch between seeing and hearing.
A creature that sees the sensor (such as a creature benefiting from *See Invisibility* or Truesight) sees a luminous orb about the size of your fist.

### Clone
*Level 8 Necromancy (Wizard)*
**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (a diamond worth 1,000+ GP, which the spell consumes, and a sealable vessel worth 2,000+ GP that is large enough to hold the creature being cloned)
**Duration:** Instantaneous

You touch a creature or at least 1 cubic inch of its flesh. An inert duplicate of that creature forms inside the vessel used in the spell's casting and finishes growing after 120 days; you choose whether the finished clone is the same age as the creature or younger. The clone remains inert and endures indefinitely while its vessel remains undisturbed.
If the original creature dies after the clone finishes forming, the creature's soul transfers to the clone if the soul is free and willing to return. The clone is physically identical to the original and has the same personality, memories, and abilities, but none of the original's equipment. The creature's original remains, if any, become inert and can't be revived, since the creature's soul is elsewhere.

---
*115 System Reference Document 5.2.1*
---
### Cloudkill
*Level 5 Conjuration (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You create a 20-foot-radius Sphere of yellow-green fog centered on a point within range. The fog lasts for the duration or until strong wind (such as the one created by *Gust of Wind*) disperses it, ending the spell. Its area is Heavily Obscured.
Each creature in the Sphere makes a Constitution saving throw, taking 5d8 Poison damage on a failed save or half as much damage on a successful one. A creature must also make this save when the Sphere moves into its space and when it enters the Sphere or ends its turn there. A creature makes this save only once per turn.
The Sphere moves 10 feet away from you at the start of each of your turns.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 5.

### Color Spray
*Level 1 Illusion (Bard, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a pinch of colorful sand)
**Duration:** Instantaneous

You launch a dazzling array of flashing, colorful light. Each creature in a 15-foot Cone originating from you must succeed on a Constitution saving throw or have the Blinded condition until the end of your next turn.

### Command
*Level 1 Enchantment (Bard, Cleric, Paladin)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

You speak a one-word command to a creature you can see within range. The target must succeed on a Wisdom saving throw or follow the command on its next turn. Choose the command from these options:
**Approach.** The target moves toward you by the shortest and most direct route, ending its turn if it moves within 5 feet of you.
**Drop.** The target drops whatever it is holding and then ends its turn.
**Flee.** The target spends its turn moving away from you by the fastest available means.
**Grovel.** The target has the Prone condition and then ends its turn.
**Halt.** On its turn, the target doesn't move and takes no action or Bonus Action.
***Using a Higher-Level Spell Slot.*** You can affect one additional creature for each spell slot level above 1.

### Commune
*Level 5 Divination (Cleric)*
**Casting Time:** 1 minute or Ritual
**Range:** Self
**Components:** V, S, M (incense)
**Duration:** 1 minute

You contact a deity or a divine proxy and ask up to three questions that can be answered with yes or no. You must ask your questions before the spell ends. You receive a correct answer for each question.
Divine beings aren't necessarily omniscient, so you might receive “unclear” as an answer if a question pertains to information that lies beyond the deity's knowledge. In a case where a one-word answer could be misleading or contrary to the deity's interests, the GM might offer a short phrase as an answer instead.
If you cast the spell more than once before finishing a Long Rest, there is a cumulative 25 percent chance for each casting after the first that you get no answer.

### Commune with Nature
*Level 5 Divination (Druid, Ranger)*
**Casting Time:** 1 minute or Ritual
**Range:** Self
**Components:** V, S
**Duration:** Instantaneous

You commune with nature spirits and gain knowledge of the surrounding area. In the outdoors, the spell gives you knowledge of the area within 3 miles of you. In caves and other natural underground settings, the radius is limited to 300 feet. The spell doesn't function where nature has been replaced by construction, such as in castles and settlements.
Choose three of the following facts; you learn those facts as they pertain to the spell's area:

*   Locations of settlements
*   Locations of portals to other planes of existence
*   Location of one Challenge Rating 10+ creature (GM's choice) that is a Celestial, an Elemental, a Fey, a Fiend, or an Undead
*   The most prevalent kind of plant, mineral, or Beast (you choose which to learn)
*   Locations of bodies of water

For example, you could determine the location of a powerful monster in the area, the locations of bodies of water, and the locations of any towns.

---
*116 System Reference Document 5.2.1*
---
### Comprehend Languages
*Level 1 Divination (Bard, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action or Ritual
**Range:** Self
**Components:** V, S, M (a pinch of soot and salt)
**Duration:** 1 hour

For the duration, you understand the literal meaning of any language that you hear or see signed. You also understand any written language that you see, but you must be touching the surface on which the words are written. It takes about 1 minute to read one page of text. This spell doesn't decode symbols or secret messages.

### Compulsion
*Level 4 Enchantment (Bard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Each creature of your choice that you can see within range must succeed on a Wisdom saving throw or have the Charmed condition until the spell ends.
For the duration, you can take a Bonus Action to designate a direction that is horizontal to you. Each Charmed target must use as much of its movement as possible to move in that direction on its next turn, taking the safest route. After moving in this way, a target repeats the save, ending the spell on itself on a success.

### Cone of Cold
*Level 5 Evocation (Druid, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a small crystal or glass cone)
**Duration:** Instantaneous

You unleash a blast of cold air. Each creature in a 60-foot Cone originating from you makes a Constitution saving throw, taking 8d8 Cold damage on a failed save or half as much damage on a successful one. A creature killed by this spell becomes a frozen statue until it thaws.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 5.

### Confusion
*Level 4 Enchantment (Bard, Druid, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 90 feet
**Components:** V, S, M (three nut shells)
**Duration:** Concentration, up to 1 minute

Each creature in a 10-foot-radius Sphere centered on a point you choose within range must succeed on a Wisdom saving throw, or that target can't take Bonus Actions or Reactions and must roll 1d10 at the start of each of its turns to determine its behavior for that turn, consulting the table below.

| 1d10 | Behavior for the Turn |
| :--- | :--- |
| 1 | The target doesn't take an action, and it uses all its movement to move. Roll 1d4 for the direction: 1, north; 2, east; 3, south; or 4, west. |
| 2–6 | The target doesn't move or take actions. |
| 7–8 | The target doesn't move, and it takes the Attack action to make one melee attack against a random creature within reach. If none are within reach, the target takes no action. |
| 9–10 | The target chooses its behavior. |

At the end of each of its turns, an affected target repeats the save, ending the spell on itself on a success.
***Using a Higher-Level Spell Slot.*** The Sphere's radius increases by 5 feet for each spell slot level above 4.

### Conjure Animals
*Level 3 Conjuration (Druid, Ranger)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You conjure nature spirits that appear as a Large pack of spectral, intangible animals in an unoccupied space you can see within range. The pack lasts for the duration, and you choose the spirits' animal form, such as wolves, serpents, or birds.
You have Advantage on Strength saving throws while you're within 5 feet of the pack, and when you move on your turn, you can also move the pack up to 30 feet to an unoccupied space you can see.
Whenever the pack moves within 10 feet of a creature you can see and whenever a creature you can see enters a space within 10 feet of the pack or ends its turn there, you can force that creature to make a Dexterity saving throw. On a failed save, the creature takes 3d10 Slashing damage. A creature makes this save only once per turn.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d10 for each spell slot level above 3.

---
*117 System Reference Document 5.2.1*
---
### Conjure Celestial
*Level 7 Conjuration (Cleric)*
**Casting Time:** Action
**Range:** 90 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You conjure a spirit from the Upper Planes, which manifests as a pillar of light in a 10-foot-radius, 40-foot-high Cylinder centered on a point within range. For each creature you can see in the Cylinder, choose which of these lights shines on it:

**Healing Light.** The target regains Hit Points equal to 4d12 plus your spellcasting ability modifier.
**Searing Light.** The target makes a Dexterity saving throw, taking 6d12 Radiant damage on a failed save or half as much damage on a successful one.

Until the spell ends, Bright Light fills the Cylinder, and when you move on your turn, you can also move the Cylinder up to 30 feet.
Whenever the Cylinder moves into the space of a creature you can see and whenever a creature you can see enters the Cylinder or ends its turn there, you can bathe it in one of the lights. A creature can be affected by this spell only once per turn.
***Using a Higher-Level Spell Slot.*** The healing and damage increase by 1d12 for each spell slot level above 7.

### Conjure Elemental
*Level 5 Conjuration (Druid, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You conjure a Large, intangible spirit from the Elemental Planes that appears in an unoccupied space within range. Choose the spirit's element, which determines its damage type: air (Lightning), earth (Thunder), fire (Fire), or water (Cold). The spirit lasts for the duration.
Whenever a creature you can see enters the spirit's space or starts its turn within 5 feet of the spirit, you can force that creature to make a Dexterity saving throw if the spirit has no creature Restrained. On failed save, the target takes 8d8 damage of the spirit's type, and the target has the Restrained condition until the spell ends. At the start of each of its turns, the Restrained target repeats the save. On a failed save, the target takes 4d8 damage of the spirit's type. On a successful save, the target isn't Restrained by the spirit.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 5.

### Conjure Fey
*Level 6 Conjuration (Druid)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You conjure a Medium spirit from the Feywild in an unoccupied space you can see within range. The spirit lasts for the duration, and it looks like a Fey creature of your choice. When the spirit appears, you can make one melee spell attack against a creature within 5 feet of it. On a hit, the target takes Psychic damage equal to 3d12 plus your spellcasting ability modifier, and the target has the Frightened condition until the start of your next turn, with both you and the spirit as the source of the fear.
As a Bonus Action on your later turns, you can teleport the spirit to an unoccupied space you can see within 30 feet of the space it left and make the attack against a creature within 5 feet of it.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d12 for each spell slot level above 6.

### Conjure Minor Elementals
*Level 4 Conjuration (Druid, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You conjure spirits from the Elemental Planes that flit around you in a 15-foot Emanation for the duration. Until the spell ends, any attack you make deals an extra 2d8 damage when you hit a creature in the Emanation. This damage is Acid, Cold, Fire, or Lightning (your choice when you make the attack).
In addition, the ground in the Emanation is Difficult Terrain for your enemies.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 4.

### Conjure Woodland Beings
*Level 4 Conjuration (Druid, Ranger)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You conjure nature spirits that flit around you in a 10-foot Emanation for the duration. Whenever the Emanation enters the space of a creature you can see and whenever a creature you can see enters the Emanation or ends its turn there, you can force that creature to make a Wisdom saving throw. The creature takes 5d8 Force damage on a failed save or half as much damage on a successful one. A creature makes this save only once per turn.
In addition, you can take the Disengage action as a Bonus Action for the spell's duration.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 4.

---
*118 System Reference Document 5.2.1*
---
### Contact Other Plane
*Level 5 Divination (Warlock, Wizard)*
**Casting Time:** 1 minute or Ritual
**Range:** Self
**Components:** V
**Duration:** 1 minute

You mentally contact a demigod, the spirit of a long-dead sage, or some other knowledgeable entity from another plane. Contacting this otherworldly intelligence can break your mind. When you cast this spell, make a DC 15 Intelligence saving throw. On a successful save, you can ask the entity up to five questions. You must ask your questions before the spell ends. The GM answers each question with one word, such as "yes,” “no,” “maybe,” “never," "irrelevant," or "unclear" (if the entity doesn't know the answer to the question). If a one-word answer would be misleading, the GM might instead offer a short phrase as an answer.
On a failed save, you take 6d6 Psychic damage and have the Incapacitated condition until you finish a Long Rest. A *Greater Restoration* spell cast on you ends this effect.

### Contagion
*Level 5 Necromancy (Cleric, Druid)*
**Casting Time:** Action
**Range:** Touch
**Component:** V, S
**Duration:** 7 days

Your touch inflicts a magical contagion. The target must succeed on a Constitution saving throw or take 11d8 Necrotic damage and have the Poisoned condition. Also, choose one ability when you cast the spell. While Poisoned, the target has Disadvantage on saving throws made with the chosen ability.
The target must repeat the saving throw at the end of each of its turns until it gets three successes or failures. If the target succeeds on three of these saves, the spell ends on the target. If the target fails three of the saves, the spell lasts for 7 days on it.
Whenever the Poisoned target receives an effect that would end the Poisoned condition, the target must succeed on a Constitution saving throw, or the Poisoned condition doesn't end on it.

### Contingency
*Level 6 Abjuration (Wizard)*
**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, S, M (a gem-encrusted statuette of yourself worth 1,500+ GP)
**Duration:** 10 days

Choose a spell of level 5 or lower that you can cast, that has a casting time of an action, and that can target you. You cast that spell—called the contingent spell—as part of casting *Contingency*, expending spell slots for both, but the contingent spell doesn't come into effect. Instead, it takes effect when a certain trigger occurs. You describe that trigger when you cast the two spells. For example, a *Contingency* cast with *Water Breathing* might stipulate that *Water Breathing* comes into effect when you are engulfed in water or a similar liquid.
The contingent spell takes effect immediately after the trigger occurs for the first time, whether or not you want it to, and then *Contingency* ends.
The contingent spell takes effect only on you, even if it can normally target others. You can use only one *Contingency* spell at a time. If you cast this spell again, the effect of another *Contingency* spell on you ends. Also, *Contingency* ends on you if its material component is ever not on your person.

### Continual Flame
*Level 2 Evocation (Cleric, Druid, Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (ruby dust worth 50+ GP, which the spell consumes)
**Duration:** Until dispelled

A flame springs from an object that you touch. The effect casts Bright Light in a 20-foot radius and Dim Light for an additional 20 feet. It looks like a regular flame, but it creates no heat and consumes no fuel. The flame can be covered or hidden but not smothered or quenched.

### Control Water
*Level 4 Transmutation (Cleric, Druid, Wizard)*
**Casting Time:** Action
**Range:** 300 feet
**Components:** V, S, M (a mixture of water and dust)
**Duration:** Concentration, up to 10 minutes

Until the spell ends, you control any water inside an area you choose that is a Cube up to 100 feet on a side, using one of the following effects. As a Magic action on your later turns, you can repeat the same effect or choose a different one.
**Flood.** You cause the water level of all standing water in the area to rise by as much as 20 feet. If you choose an area in a large body of water, you instead create a 20-foot tall wave that travels from one side of the area to the other and then crashes. Any Huge or smaller vehicles in the wave's path are carried with it to the other side. Any Huge or smaller vehicles struck by the wave have a 25 percent chance of capsizing.
The water level remains elevated until the spell ends or you choose a different effect. If this effect produced a wave, the wave repeats on the start of your next turn while the flood effect lasts.
**Part Water.** You part water in the area and create a trench. The trench extends across the spell's area, and the separated water forms a wall to either side. The trench remains until the spell ends or you choose a different effect. The water then slowly fills in the trench over the course of the next round until the normal water level is restored.
**Redirect Flow.** You cause flowing water in the area to move in a direction you choose, even if the water has to flow over obstacles, up walls, or in other unlikely directions. The water in the area moves as you direct it, but once it moves beyond the spell's area, it resumes its flow based on the terrain. The water continues to move in the direction you chose until the spell ends or you choose a different effect.
**Whirlpool.** You cause a whirlpool to form in the center of the area, which must be at least 50 feet square and 25 feet deep. The whirlpool lasts until you choose a different effect or the spell ends. The whirlpool is 5 feet wide at the base, up to 50 feet wide at the top, and 25 feet tall. Any creature in the water and within 25 feet of the whirlpool is pulled 10 feet toward it. When a creature enters the whirlpool for the first time on a turn or ends its turn there, it makes a Strength saving throw. On a failed save, the creature takes 2d8 Bludgeoning damage. On a successful save, the creature takes half as much damage. A creature can swim away from the whirlpool only if it first takes an action to pull away and succeeds on a Strength (Athletics) check against your spell save DC.

---
*119 System Reference Document 5.2.1*
---
### Control Weather
*Level 8 Transmutation (Cleric, Druid, Wizard)*
**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, S, M (burning incense)
**Duration:** Concentration, up to 8 hours

You take control of the weather within 5 miles of you for the duration. You must be outdoors to cast this spell, and it ends early if you go indoors.
When you cast the spell, you change the current weather conditions, which are determined by the GM. You can change precipitation, temperature, and wind. It takes 1d4 × 10 minutes for the new conditions to take effect. Once they do so, you can change the conditions again. When the spell ends, the weather gradually returns to normal.
When you change the weather conditions, find a current condition on the following tables and change its stage by one, up or down. When changing the wind, you can change its direction.

**Precipitation**
| Stage | Condition |
| :--- | :--- |
| 1 | Clear |
| 2 | Light clouds |
| 3 | Overcast or ground fog |
| 4 | Rain, hail, or snow |
| 5 | Torrential rain, driving hail, or blizzard |

**Temperature**
| Stage | Condition |
| :--- | :--- |
| 1 | Heat wave |
| 2 | Hot |
| 3 | Warm |
| 4 | Cool |
| 5 | Cold |
| 6 | Freezing |

**Wind**
| Stage | Condition |
| :--- | :--- |
| 1 | Calm |
| 2 | Moderate wind |
| 3 | Strong wind |
| 4 | Gale |
| 5 | Storm |

### Counterspell
*Level 3 Abjuration (Sorcerer, Warlock, Wizard)*
**Casting Time:** Reaction, which you take when you see a creature within 60 feet of yourself casting a spell with Verbal, Somatic, or Material components
**Range:** 60 feet
**Components:** S
**Duration:** Instantaneous

You attempt to interrupt a creature in the process of casting a spell. The creature makes a Constitution saving throw. On a failed save, the spell dissipates with no effect, and the action, Bonus Action, or Reaction used to cast it is wasted. If that spell was cast with a spell slot, the slot isn't expended.

### Create Food and Water
*Level 3 Conjuration (Cleric, Paladin)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

You create 45 pounds of food and 30 gallons of fresh water on the ground or in containers within range—both useful in fending off the hazards of malnutrition and dehydration. The food is bland but nourishing and looks like a food of your choice, and the water is clean. The food spoils after 24 hours if uneaten.

---
*120 System Reference Document 5.2.1*
---