### Page 121

## Create or Destroy Water
*Level 1 Transmutation (Cleric, Druid)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a mix of water and sand)
**Duration:** Instantaneous

You do one of the following:

**Create Water.** You create up to 10 gallons of clean water within range in an open container. Alternatively, the water falls as rain in a 30-foot Cube within range, extinguishing exposed flames there.

**Destroy Water.** You destroy up to 10 gallons of water in an open container within range. Alternatively, you destroy fog in a 30-foot Cube within range.

***Using a Higher-Level Spell Slot.*** You create or destroy 10 additional gallons of water, or the size of the Cube increases by 5 feet, for each spell slot level above 1.

## Create Undead
*Level 6 Necromancy (Cleric, Warlock, Wizard)*
**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, S, M (one 150+ GP black onyx stone for each corpse)
**Duration:** Instantaneous

You can cast this spell only at night. Choose up to three corpses of Medium or Small Humanoids within range. Each one becomes a **Ghoul** under your control (see "Monsters” for its stat block).

As a Bonus Action on each of your turns, you can mentally command any creature you animated with this spell if the creature is within 120 feet of you (if you control multiple creatures, you can command any of them at the same time, issuing the same command to them). You decide what action the creature will take and where it will move on its next turn, or you can issue a general command, such as to guard a particular place. If you issue no commands, the creature takes the Dodge action and moves only to avoid harm. Once given an order, the creature continues to follow the order until its task is complete.

The creature is under your control for 24 hours, after which it stops obeying any command you've given it. To maintain control of the creature for another 24 hours, you must cast this spell on the creature before the current 24-hour period ends. This use of the spell reasserts your control over up to three creatures you have animated with this spell rather than animating new ones.

***Using a Higher-Level Spell Slot.*** If you use a level 7 spell slot, you can animate or reassert control over four **Ghouls**. If you use a level 8 spell slot, you can animate or reassert control over five **Ghouls** or two **Ghasts** or **Wights**. If you use a level 9 spell slot, you can animate or reassert control over six **Ghouls**, three **Ghasts** or **Wights**, or two **Mummies**. See "Monsters" for these stat blocks.

## Creation
*Level 5 Illusion (Sorcerer, Wizard)*
**Casting Time:** 1 minute
**Range:** 30 feet
**Components:** V, S, M (a paintbrush)
**Duration:** Special

You pull wisps of shadow material from the Shadowfell to create an object within range. It is either an object of vegetable matter (soft goods, rope, wood, and the like) or mineral matter (stone, crystal, metal, and the like). The object must be no larger than a 5-foot Cube, and the object must be of a form and material that you have seen.

The spell's duration depends on the object's material, as shown in the Materials table. If the object is composed of multiple materials, use the shortest duration. Using any object created by this spell as another spell's Material component causes the other spell to fail.

### Materials
| Material | Duration |
| :--- | :--- |
| Vegetable matter | 24 hours |
| Stone or crystal | 12 hours |
| Precious metals | 1 hour |
| Gems | 10 minutes |
| Adamantine or mithral | 1 minute |

***Using a Higher-Level Spell Slot.*** The Cube increases by 5 feet for each spell slot level above 5.

## Cure Wounds
*Level 1 Abjuration (Bard, Cleric, Druid, Paladin, Ranger)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

A creature you touch regains a number of Hit Points equal to 2d8 plus your spellcasting ability modifier.

***Using a Higher-Level Spell Slot.*** The healing increases by 2d8 for each spell slot level above 1.

## Dancing Lights
*Illusion Cantrip (Bard, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S, M (a bit of phosphorus)
**Duration:** Concentration, up to 1 minute

---
121
System Reference Document 5.2.1

### Page 122

You create up to four torch-size lights within range, making them appear as torches, lanterns, or glowing orbs that hover for the duration. Alternatively, you combine the four lights into one glowing Medium form that is vaguely humanlike. Whichever form you choose, each light sheds Dim Light in a 10-foot radius.

As a Bonus Action, you can move the lights up to 60 feet to a space within range. A light must be within 20 feet of another light created by this spell, and a light vanishes if it exceeds the spell's range.

## Darkness
*Level 2 Evocation (Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, M (bat fur and a piece of coal)
**Duration:** Concentration, up to 10 minutes

For the duration, magical Darkness spreads from a point within range and fills a 15-foot-radius Sphere. Darkvision can't see through it, and nonmagical light can't illuminate it.

Alternatively, you cast the spell on an object that isn't being worn or carried, causing the Darkness to fill a 15-foot Emanation originating from that object. Covering that object with something opaque, such as a bowl or helm, blocks the Darkness.

If any of this spell's area overlaps with an area of Bright Light or Dim Light created by a spell of level 2 or lower, that other spell is dispelled.

## Darkvision
*Level 2 Transmutation (Druid, Ranger, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a dried carrot)
**Duration:** 8 hours

For the duration, a willing creature you touch has Darkvision with a range of 150 feet.

## Daylight
*Level 3 Evocation (Cleric, Druid, Paladin, Ranger, Sorcerer)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** 1 hour

For the duration, sunlight spreads from a point within range and fills a 60-foot-radius Sphere. The sunlight's area is Bright Light and sheds Dim Light for an additional 60 feet.

Alternatively, you cast the spell on an object that isn't being worn or carried, causing the sunlight to fill a 60-foot Emanation originating from that object. Covering that object with something opaque, such as a bowl or helm, blocks the sunlight.

If any of this spell's area overlaps with an area of Darkness created by a spell of level 3 or lower, that other spell is dispelled.

## Death Ward
*Level 4 Abjuration (Cleric, Paladin)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S
**Duration:** 8 hours

You touch a creature and grant it a measure of protection from death. The first time the target would drop to 0 Hit Points before the spell ends, the target instead drops to 1 Hit Point, and the spell ends.

If the spell is still in effect when the target is subjected to an effect that would kill it instantly without dealing damage, that effect is negated against the target, and the spell ends.

## Delayed Blast Fireball
*Level 7 Evocation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 150 feet
**Components:** V, S, M (a ball of bat guano and sulfur)
**Duration:** Concentration, up to 1 minute

A beam of yellow light flashes from you, then condenses at a chosen point within range as a glowing bead for the duration. When the spell ends, the bead explodes, and each creature in a 20-foot-radius Sphere centered on that point makes a Dexterity saving throw. A creature takes Fire damage equal to the total accumulated damage on a failed save or half as much damage on a successful one.

The spell's base damage is 12d6, and the damage increases by 1d6 whenever your turn ends and the spell hasn't ended.

If a creature touches the glowing bead before the spell ends, that creature makes a Dexterity saving throw. On a failed save, the spell ends, causing the bead to explode. On a successful save, the creature can throw the bead up to 40 feet. If the thrown bead enters a creature's space or collides with a solid object, the spell ends, and the bead explodes.

When the bead explodes, flammable objects in the explosion that aren't being worn or carried start burning.

***Using a Higher-Level Spell Slot.*** The base damage increases by 1d6 for each spell slot level above 7.

## Demiplane
*Level 8 Conjuration (Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** S
**Duration:** 1 hour

---
122
System Reference Document 5.2.1

### Page 123

You create a shadowy Medium door on a flat solid surface that you can see within range. This door can be opened and closed, and it leads to a demiplane that is an empty room 30 feet in each dimension, made of wood or stone (your choice).

When the spell ends, the door vanishes, and any objects inside the demiplane remain there. Any creatures inside also remain unless they opt to be shunted through the door as it vanishes, landing with the Prone condition in the unoccupied spaces closest to the door's former space.

Each time you cast this spell, you can create a new demiplane or connect the shadowy door to a demiplane you created with a previous casting of this spell. Additionally, if you know the nature and contents of a demiplane created by a casting of this spell by another creature, you can connect the shadowy door to that demiplane instead.

## Detect Evil and Good
*Level 1 Divination (Cleric, Paladin)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

For the duration, you sense the location of any Aberration, Celestial, Elemental, Fey, Fiend, or Undead within 30 feet of yourself. You also sense whether the *Hallow* spell is active there and, if so, where.

The spell is blocked by 1 foot of stone, dirt, or wood; 1 inch of metal; or a thin sheet of lead.

## Detect Magic
*Level 1 Divination (Bard, Cleric, Druid, Paladin, Ranger, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action or Ritual
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

For the duration, you sense the presence of magical effects within 30 feet of yourself. If you sense such effects, you can take the Magic action to see a faint aura around any visible creature or object in the area that bears the magic, and if an effect was created by a spell, you learn the spell's school of magic.

The spell is blocked by 1 foot of stone, dirt, or wood; 1 inch of metal; or a thin sheet of lead.

## Detect Poison and Disease
*Level 1 Divination (Cleric, Druid, Paladin, Ranger)*
**Casting Time:** Action or Ritual
**Range:** Self
**Components:** V, S, M (a yew leaf)
**Duration:** Concentration, up to 10 minutes

For the duration, you sense the location of poisons, poisonous or venomous creatures, and magical contagions within 30 feet of yourself. You sense the kind of poison, creature, or contagion in each case.

The spell is blocked by 1 foot of stone, dirt, or wood; 1 inch of metal; or a thin sheet of lead.

## Detect Thoughts
*Level 2 Divination (Bard, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (1 Copper Piece)
**Duration:** Concentration, up to 1 minute

You activate one of the effects below. Until the spell ends, you can activate either effect as a Magic action on your later turns.

**Sense Thoughts.** You sense the presence of thoughts within 30 feet of yourself that belong to creatures that know languages or are telepathic. You don't read the thoughts, but you know that a thinking creature is present.

The spell is blocked by 1 foot of stone, dirt, or wood; 1 inch of metal; or a thin sheet of lead.

**Read Thoughts.** Target one creature you can see within 30 feet of yourself or one creature within 30 feet of yourself that you detected with the Sense Thoughts option. You learn what is most on the target's mind right now. If the target doesn't know any languages and isn't telepathic, you learn nothing.

As a Magic action on your next turn, you can try to probe deeper into the target's mind. If you probe deeper, the target makes a Wisdom saving throw. On a failed save, you discern the target's reasoning, emotions, and something that looms large in its mind (such as a worry, love, or hate). On a successful save, the spell ends. Either way, the target knows that you are probing into its mind, and until you shift your attention away from the target's mind, the target can take an action on its turn to make an Intelligence (Arcana) check against your spell save DC, ending the spell on a success.

## Dimension Door
*Level 4 Conjuration (Bard, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 500 feet
**Components:** V
**Duration:** Instantaneous

You teleport to a location within range. You arrive at exactly the spot desired. It can be a place you can see, one you can visualize, or one you can describe by stating distance and direction, such as "200 feet straight downward" or "300 feet upward to the northwest at a 45-degree angle."

You can also teleport one willing creature. The creature must be within 5 feet of you when you teleport, and it teleports to a space within 5 feet of your destination space.

---
123
System Reference Document 5.2.1

### Page 124

If you, the other creature, or both would arrive in a space occupied by a creature or completely filled by one or more objects, you and any creature traveling with you each take 4d6 Force damage, and the teleportation fails.

## Disguise Self
*Level 1 Illusion (Bard, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** 1 hour

You make yourself—including your clothing, armor, weapons, and other belongings on your person—look different until the spell ends. You can seem 1 foot shorter or taller and can appear heavier or lighter. You must adopt a form that has the same basic arrangement of limbs as you have. Otherwise, the extent of the illusion is up to you.

The changes wrought by this spell fail to hold up to physical inspection. For example, if you use this spell to add a hat to your outfit, objects pass through the hat, and anyone who touches it would feel nothing.

To discern that you are disguised, a creature must take the Study action to inspect your appearance and succeed on an Intelligence (Investigation) check against your spell save DC.

## Disintegrate
*Level 6 Transmutation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a lodestone and dust)
**Duration:** Instantaneous

You launch a green ray at a target you can see within range. The target can be a creature, a non-magical object, or a creation of magical force, such as the wall created by *Wall of Force*.

A creature targeted by this spell makes a Dexterity saving throw. On a failed save, the target takes 10d6 + 40 Force damage. If this damage reduces it to 0 Hit Points, it and everything nonmagical it is wearing and carrying are disintegrated into gray dust. The target can be revived only by a *True Resurrection* or a *Wish* spell.

This spell automatically disintegrates a Large or smaller nonmagical object or a creation of magical force. If such a target is Huge or larger, this spell disintegrates a 10-foot-Cube portion of it.

***Using a Higher-Level Spell Slot.*** The damage increases by 3d6 for each spell slot level above 6.

## Dispel Evil and Good
*Level 5 Abjuration (Cleric, Paladin)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (powdered silver and iron)
**Duration:** Concentration, up to 1 minute

For the duration, Celestials, Elementals, Fey, Fiends, and Undead have Disadvantage on attack rolls against you. You can end the spell early by using either of the following special functions.

**Break Enchantment.** As a Magic action, you touch a creature that is possessed by or has the Charmed or Frightened condition from one or more creatures of the types above. The target is no longer possessed, Charmed, or Frightened by such creatures.

**Dismissal.** As a Magic action, you target one creature you can see within 5 feet of you that has one of the creature types above. The target must succeed on a Charisma saving throw or be sent back to its home plane if it isn't there already. If they aren't on their home plane, Undead are sent to the Shadowfell, and Fey are sent to the Feywild.

## Dispel Magic
*Level 3 Abjuration (Bard, Cleric, Druid, Paladin, Ranger, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

Choose one creature, object, or magical effect within range. Any ongoing spell of level 3 or lower on the target ends. For each ongoing spell of level 4 or higher on the target, make an ability check using your spellcasting ability (DC 10 plus that spell's level). On a successful check, the spell ends.

***Using a Higher-Level Spell Slot.*** You automatically end a spell on the target if the spell's level is equal to or less than the level of the spell slot you use.

## Dissonant Whispers
*Level 1 Enchantment (Bard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

One creature of your choice that you can see within range hears a discordant melody in its mind. The target makes a Wisdom saving throw. On a failed save, it takes 3d6 Psychic damage and must immediately use its Reaction, if available, to move as far away from you as it can, using the safest route. On a successful save, the target takes half as much damage only.

***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 1.

---
124
System Reference Document 5.2.1

### Page 125

## Divination
*Level 4 Divination (Cleric, Druid, Wizard)*
**Casting Time:** Action or Ritual
**Range:** Self
**Components:** V, S, M (incense worth 25+ GP, which the spell consumes)
**Duration:** Instantaneous

This spell puts you in contact with a god or a god's servants. You ask one question about a specific goal, event, or activity to occur within 7 days. The GM offers a truthful reply, which might be a short phrase or cryptic rhyme. The spell doesn't account for circumstances that might change the answer, such as the casting of other spells.

If you cast the spell more than once before finishing a Long Rest, there is a cumulative 25 percent chance for each casting after the first that you get no answer.

## Divine Favor
*Level 1 Transmutation (Paladin)*
**Casting Time:** Bonus Action
**Range:** Self
**Components:** V, S
**Duration:** 1 minute

Until the spell ends, your attacks with weapons deal an extra 1d4 Radiant damage on a hit.

## Divine Smite
*Level 1 Evocation (Paladin)*
**Casting Time:** Bonus Action, which you take immediately after hitting a target with a Melee weapon or an Unarmed Strike
**Range:** Self
**Component:** V
**Duration:** Instantaneous

The target takes an extra 2d8 Radiant damage from the attack. The damage increases by 1d8 if the target is a Fiend or an Undead.

***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 1.

## Divine Word
*Level 7 Evocation (Cleric)*
**Casting Time:** Bonus Action
**Range:** 30 feet
**Components:** V
**Duration:** Instantaneous

You utter a word imbued with power from the Upper Planes. Each creature of your choice in range makes a Charisma saving throw. On a failed save, a target that has 50 Hit Points or fewer suffers an effect based on its current Hit Points, as shown in the Divine Word Effects table. Regardless of its Hit Points, a Celestial, an Elemental, a Fey, or a Fiend target that fails its save is forced back to its plane of origin (if it isn't there already) and can't return to the current plane for 24 hours by any means short of a *Wish* spell.

### Divine Word Effects
| Hit Points | Effect |
| :--- | :--- |
| 0–20 | The target dies. |
| 21–30 | The target has the Blinded, Deafened, and Stunned conditions for 1 hour. |
| 31–40 | The target has the Blinded and Deafened conditions for 10 minutes. |
| 41–50 | The target has the Deafened condition for 1 minute. |

## Dominate Beast
*Level 4 Enchantment (Druid, Ranger, Sorcerer)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

One Beast you can see within range must succeed on a Wisdom saving throw or have the Charmed condition for the duration. The target has Advantage on the save if you or your allies are fighting it. Whenever the target takes damage, it repeats the save, ending the spell on itself on a success.

You have a telepathic link with the Charmed target while the two of you are on the same plane of existence. On your turn, you can use this link to issue commands to the target (no action required), such as "Attack that creature," "Move over there," or "Fetch that object." The target does its best to obey on its turn. If it completes an order and doesn't receive further direction from you, it acts and moves as it likes, focusing on protecting itself.

You can command the target to take a Reaction but must take your own Reaction to do so.

***Using a Higher-Level Spell Slot.*** Your Concentration can last longer with a spell slot of level 5 (up to 10 minutes), 6 (up to 1 hour), or 7+ (up to 8 hours).

## Dominate Monster
*Level 8 Enchantment (Bard, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 hour

One creature you can see within range must succeed on a Wisdom saving throw or have the Charmed condition for the duration. The target has Advantage on the save if you or your allies are fighting it. Whenever the target takes damage, it repeats the save, ending the spell on itself on a success.

---
125
System Reference Document 5.2.1

### Page 126

You have a telepathic link with the Charmed target while the two of you are on the same plane of existence. On your turn, you can use this link to issue commands to the target (no action required), such as "Attack that creature,” “Move over there," or "Fetch that object." The target does its best to obey on its turn. If it completes an order and doesn't receive further direction from you, it acts and moves as it likes, focusing on protecting itself.

You can command the target to take a Reaction but must take your own Reaction to do so.

***Using a Higher-Level Spell Slot.*** Your Concentration can last longer with a level 9 spell slot (up to 8 hours).

## Dominate Person
*Level 5 Enchantment (Bard, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

One Humanoid you can see within range must succeed on a Wisdom saving throw or have the Charmed condition for the duration. The target has Advantage on the save if you or your allies are fighting it. Whenever the target takes damage, it repeats the save, ending the spell on itself on a success.

You have a telepathic link with the Charmed target while the two of you are on the same plane of existence. On your turn, you can use this link to issue commands to the target (no action required), such as "Attack that creature,” “Move over there," or "Fetch that object." The target does its best to obey on its turn. If it completes an order and doesn't receive further direction from you, it acts and moves as it likes, focusing on protecting itself.

You can command the target to take a Reaction but must take your own Reaction to do so.

***Using a Higher-Level Spell Slot.*** Your Concentration can last longer with a spell slot of level 6 (up to 10 minutes), 7 (up to 1 hour), or 8+ (up to 8 hours).

## Dragon's Breath
*Level 2 Transmutation (Sorcerer, Wizard)*
**Casting Time:** Bonus Action
**Range:** Touch
**Components:** V, S, M (a hot pepper)
**Duration:** Concentration, up to 1 minute

You touch one willing creature, and choose Acid, Cold, Fire, Lightning, or Poison. Until the spell ends, the target can take a Magic action to exhale a 15-foot Cone. Each creature in that area makes a Dexterity saving throw, taking 3d6 damage of the chosen type on a failed save or half as much damage on a successful one.

***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 2.

## Dream
*Level 5 Illusion (Bard, Warlock, Wizard)*
**Casting Time:** 1 minute
**Range:** Special
**Components:** V, S, M (a handful of sand)
**Duration:** 8 hours

You target a creature you know on the same plane of existence. You or a willing creature you touch enters a trance state to act as a dream messenger. While in the trance, the messenger is Incapacitated and has a Speed of 0.

If the target is asleep, the messenger appears in the target's dreams and can converse with the target as long as it remains asleep, through the spell's duration. The messenger can also shape the dream's environment, creating landscapes, objects, and other images. The messenger can emerge from the trance at any time, ending the spell. The target recalls the dream perfectly upon waking.

If the target is awake when you cast the spell, the messenger knows it and can either end the trance (and the spell) or wait for the target to sleep, at which point the messenger enters its dreams.

You can make the messenger terrifying to the target. If you do so, the messenger can deliver a message of no more than ten words, and then the target makes a Wisdom saving throw. On a failed save, the target gains no benefit from its rest, and it takes 3d6 Psychic damage when it wakes up.

## Druidcraft
*Transmutation Cantrip (Druid)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

Whispering to the spirits of nature, you create one of the following effects within range.

**Weather Sensor.** You create a Tiny, harmless sensory effect that predicts what the weather will be at your location for the next 24 hours. The effect might manifest as a golden orb for clear skies, a cloud for rain, falling snowflakes for snow, and so on. This effect persists for 1 round.

**Bloom.** You instantly make a flower blossom, a seed pod open, or a leaf bud bloom.

**Sensory Effect.** You create a harmless sensory effect, such as falling leaves, spectral dancing fairies, a gentle breeze, the sound of an animal, or the faint odor of skunk. The effect must fit in a 5-foot Cube.

**Fire Play.** You light or snuff out a candle, a torch, or a campfire.

---
126
System Reference Document 5.2.1

### Page 127

## Earthquake
*Level 8 Transmutation (Cleric, Druid, Sorcerer)*
**Casting Time:** Action
**Range:** 500 feet
**Components:** V, S, M (a fractured rock)
**Duration:** Concentration, up to 1 minute

Choose a point on the ground that you can see within range. For the duration, an intense tremor rips through the ground in a 100-foot-radius circle centered on that point. The ground there is Difficult Terrain.

When you cast this spell and at the end of each of your turns for the duration, each creature on the ground in the area makes a Dexterity saving throw. On a failed save, a creature has the Prone condition, and its Concentration is broken.

You can also cause the effects below.

**Fissures.** A total of 1d6 fissures open in the spell's area at the end of the turn you cast it. You choose the fissures' locations, which can't be under structures. Each fissure is 1d10 × 10 feet deep and 10 feet wide, and it extends from one edge of the spell's area to another edge. A creature in the same space as a fissure must succeed on a Dexterity saving throw or fall in. A creature that successfully saves moves with the fissure's edge as it opens.

**Structures.** The tremor deals 50 Bludgeoning damage to any structure in contact with the ground in the area when you cast the spell and at the end of each of your turns until the spell ends. If a structure drops to 0 Hit Points, it collapses.

A creature within a distance from a collapsing structure equal to half the structure's height makes a Dexterity saving throw. On a failed save, the creature takes 12d6 Bludgeoning damage, has the Prone condition, and is buried in the rubble, requiring a DC 20 Strength (Athletics) check as an action to escape. On a successful save, the creature takes half as much damage only.

## Eldritch Blast
*Evocation Cantrip (Warlock)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You hurl a beam of crackling energy. Make a ranged spell attack against one creature or object in range. On a hit, the target takes 1d10 Force damage.

***Cantrip Upgrade.*** The spell creates two beams at level 5, three beams at level 11, and four beams at level 17. You can direct the beams at the same target or at different ones. Make a separate attack roll for each beam.

## Elementalism
*Transmutation Cantrip (Druid, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

You exert control over the elements, creating one of the following effects within range.

**Beckon Air.** You create a breeze strong enough to ripple cloth, stir dust, rustle leaves, and close open doors and shutters, all in a 5-foot Cube. Doors and shutters being held open by someone or something aren't affected.

**Beckon Earth.** You create a thin shroud of dust or sand that covers surfaces in a 5-foot-square area, or you cause a single word to appear in your handwriting in a patch of dirt or sand.

**Beckon Fire.** You create a thin cloud of harmless embers and colored, scented smoke in a 5-foot Cube. You choose the color and scent, and the embers can light candles, torches, or lamps in that area. The smoke's scent lingers for 1 minute.

**Beckon Water.** You create a spray of cool mist that lightly dampens creatures and objects in a 5-foot Cube. Alternatively, you create 1 cup of clean water either in an open container or on a surface, and the water evaporates in 1 minute.

**Sculpt Element.** You cause dirt, sand, fire, smoke, mist, or water that can fit in a 1-foot Cube to assume a crude shape (such as that of a creature) for 1 hour.

## Enhance Ability
*Level 2 Transmutation (Bard, Cleric, Druid, Ranger, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (fur or a feather)
**Duration:** Concentration, up to 1 hour

You touch a creature and choose Strength, Dexterity, Intelligence, Wisdom, or Charisma. For the duration, the target has Advantage on ability checks using the chosen ability.

***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 2. You can choose a different ability for each target.

## Enlarge/Reduce
*Level 2 Transmutation (Bard, Druid, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a pinch of powdered iron)
**Duration:** Concentration, up to 1 minute

For the duration, the spell enlarges or reduces a creature or an object you can see within range (see

---
127
System Reference Document 5.2.1

### Page 128

the chosen effect below). A targeted object must be neither worn nor carried. If the target is an unwilling creature, it can make a Constitution saving throw. On a successful save, the spell has no effect.

Everything that a targeted creature is wearing and carrying changes size with it. Any item it drops returns to normal size at once. A thrown weapon or piece of ammunition returns to normal size immediately after it hits or misses a target.

**Enlarge.** The target's size increases by one category—from Medium to Large, for example. The target also has Advantage on Strength checks and Strength saving throws. The target's attacks with its enlarged weapons or Unarmed Strikes deal an extra 1d4 damage on a hit.

**Reduce.** The target's size decreases by one category—from Medium to Small, for example. The target also has Disadvantage on Strength checks and Strength saving throws. The target's attacks with its reduced weapons or Unarmed Strikes deal 1d4 less damage on a hit (this can't reduce the damage below 1).

## Ensnaring Strike
*Level 1 Conjuration (Ranger)*
**Casting Time:** Bonus Action, which you take immediately after hitting a creature with a weapon
**Range:** Self
**Components:** V
**Duration:** Concentration, up to 1 minute

As you hit the target, grasping vines appear on it, and it makes a Strength saving throw. A Large or larger creature has Advantage on this save. On a failed save, the target has the Restrained condition until the spell ends. On a successful save, the vines shrivel away, and the spell ends.

While Restrained, the target takes 1d6 Piercing damage at the start of each of its turns. The target or a creature within reach of it can take an action to make a Strength (Athletics) check against your spell save DC. On a success, the spell ends.

***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 1.

## Entangle
*Level 1 Conjuration (Druid, Ranger)*
**Casting Time:** Action
**Range:** 90 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Grasping plants sprout from the ground in a 20-foot square within range. For the duration, these plants turn the ground in the area into Difficult Terrain. They disappear when the spell ends.

Each creature (other than you) in the area when you cast the spell must succeed on a Strength saving throw or have the Restrained condition until the spell ends. A Restrained creature can take an action to make a Strength (Athletics) check against your spell save DC. On a success, it frees itself from the grasping plants and is no longer Restrained by them.

## Enthrall
*Level 2 Enchantment (Bard, Warlock)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You weave a distracting string of words, causing creatures of your choice that you can see within range to make a Wisdom saving throw. Any creature you or your companions are fighting automatically succeeds on this save. On a failed save, a target has a –10 penalty to Wisdom (Perception) checks and Passive Perception until the spell ends.

## Etherealness
*Level 7 Conjuration (Bard, Cleric, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Up to 8 hours

You step into the border regions of the Ethereal Plane, where it overlaps with your current plane. You remain in the Border Ethereal for the duration. During this time, you can move in any direction. If you move up or down, every foot of movement costs an extra foot. You can perceive the plane you left, which looks gray, and you can't see anything there more than 60 feet away.

While on the Ethereal Plane, you can affect and be affected only by creatures, objects, and effects on that plane. Creatures that aren't on the Ethereal Plane can't perceive or interact with you unless a feature gives them the ability to do so.

When the spell ends, you return to the plane you left in the spot that corresponds to your space in the Border Ethereal. If you appear in an occupied space, you are shunted to the nearest unoccupied space and take Force damage equal to twice the number of feet you are moved.

This spell ends instantly if you cast it while you are on the Ethereal Plane or a plane that doesn't border it, such as one of the Outer Planes.

***Using a Higher-Level Spell Slot.*** You can target up to three willing creatures (including yourself) for each spell slot level above 7. The creatures must be within 10 feet of you when you cast the spell.

---
128
System Reference Document 5.2.1

### Page 129

## Expeditious Retreat
*Level 1 Transmutation (Sorcerer, Warlock, Wizard)*
**Casting Time:** Bonus Action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You take the Dash action, and until the spell ends, you can take that action again as a Bonus Action.

## Eyebite
*Level 6 Necromancy (Bard, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 minute

For the duration, your eyes become an inky void. One creature of your choice within 60 feet of you that you can see must succeed on a Wisdom saving throw or be affected by one of the following effects of your choice for the duration.

On each of your turns until the spell ends, you can take a Magic action to target another creature but can't target a creature again if it has succeeded on a save against this casting of the spell.

**Asleep.** The target has the Unconscious condition. It wakes up if it takes any damage or if another creature takes an action to shake it awake.

**Panicked.** The target has the Frightened condition. On each of its turns, the Frightened target must take the Dash action and move away from you by the safest and shortest route available. If the target moves to a space at least 60 feet away from you where it can't see you, this effect ends.

**Sickened.** The target has the Poisoned condition.

## Fabricate
*Level 4 Transmutation (Wizard)*
**Casting Time:** 10 minutes
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You convert raw materials into products of the same material. For example, you can fabricate a wooden bridge from a clump of trees, a rope from a patch of hemp, or clothes from flax or wool.

Choose raw materials that you can see within range. You can fabricate a Large or smaller object (contained within a 10-foot Cube or eight connected 5-foot Cubes) given a sufficient quantity of material. If you're working with metal, stone, or another mineral substance, however, the fabricated object can be no larger than Medium (contained within a 5-foot Cube). The quality of any fabricated objects is based on the quality of the raw materials.

Creatures and magic items can't be created by this spell. You also can't use it to create items that require a high degree of skill—such as weapons and armor—unless you have proficiency with the type of Artisan's Tools used to craft such objects.

## Faerie Fire
*Level 1 Evocation (Bard, Druid)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V
**Duration:** Concentration, up to 1 minute

Objects in a 20-foot Cube within range are outlined in blue, green, or violet light (your choice). Each creature in the Cube is also outlined if it fails a Dexterity saving throw. For the duration, objects and affected creatures shed Dim Light in a 10-foot radius and can't benefit from the Invisible condition.

Attack rolls against an affected creature or object have Advantage if the attacker can see it.

## Faithful Hound
*Level 4 Conjuration (Wizard)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a silver whistle)
**Duration:** 8 hours

You conjure a phantom watchdog in an unoccupied space that you can see within range. The hound remains for the duration or until the two of you are more than 300 feet apart from each other.

No one but you can see the hound, and it is intangible and invulnerable. When a Small or larger creature comes within 30 feet of it without first speaking the password that you specify when you cast this spell, the hound starts barking loudly. The hound has Truesight with a range of 30 feet.

At the start of each of your turns, the hound attempts to bite one enemy within 5 feet of it. That enemy must succeed on a Dexterity saving throw or take 4d8 Force damage.

On your later turns, you can take a Magic action to move the hound up to 30 feet.

## False Life
*Level 1 Necromancy (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a drop of alcohol)
**Duration:** Instantaneous

You gain 2d4 + 4 Temporary Hit Points.

***Using a Higher-Level Spell Slot.*** You gain 5 additional Temporary Hit Points for each spell slot level above 1.

---
129
System Reference Document 5.2.1

### Page 130

## Fear
*Level 3 Illusion (Bard, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a white feather)
**Duration:** Concentration, up to 1 minute

Each creature in a 30-foot Cone must succeed on a Wisdom saving throw or drop whatever it is holding and have the Frightened condition for the duration.

A Frightened creature takes the Dash action and moves away from you by the safest route on each of its turns unless there is nowhere to move. If the creature ends its turn in a space where it doesn't have line of sight to you, the creature makes a Wisdom saving throw. On a successful save, the spell ends on that creature.

## Feather Fall
*Level 1 Transmutation (Bard, Sorcerer, Wizard)*
**Casting Time:** Reaction, which you take when you or a creature you can see within 60 feet of you falls
**Range:** 60 feet
**Components:** V, M (a small feather or piece of down)
**Duration:** 1 minute

Choose up to five falling creatures within range. A falling creature's rate of descent slows to 60 feet per round until the spell ends. If a creature lands before the spell ends, the creature takes no damage from the fall, and the spell ends for that creature.

## Find Familiar
*Level 1 Conjuration (Wizard)*
**Casting Time:** 1 hour or Ritual
**Range:** 10 feet
**Components:** V, S, M (burning incense worth 10+ GP, which the spell consumes)
**Duration:** Instantaneous

You gain the service of a familiar, a spirit that takes an animal form you choose: **Bat, Cat, Frog, Hawk, Lizard, Octopus, Owl, Rat, Raven, Spider, Weasel,** or another Beast that has a Challenge Rating of 0. Appearing in an unoccupied space within range, the familiar has the statistics of the chosen form (see "Monsters"), though it is a Celestial, Fey, or Fiend (your choice) instead of a Beast. Your familiar acts independently of you, but it obeys your commands.

**Telepathic Connection.** While your familiar is within 100 feet of you, you can communicate with it telepathically. Additionally, as a Bonus Action, you can see through the familiar's eyes and hear what it hears until the start of your next turn, gaining the benefits of any special senses it has.

Finally, when you cast a spell with a range of touch, your familiar can deliver the touch. Your familiar must be within 100 feet of you, and it must take a Reaction to deliver the touch when you cast the spell.

**Combat.** The familiar is an ally to you and your allies. It rolls its own Initiative and acts on its own turn. A familiar can't attack, but it can take other actions as normal.

**Disappearance of the Familiar.** When the familiar drops to 0 Hit Points, it disappears. It reappears after you cast this spell again. As a Magic action, you can temporarily dismiss the familiar to a pocket dimension. Alternatively, you can dismiss it forever. As a Magic action while it is temporarily dismissed, you can cause it to reappear in an unoccupied space within 30 feet of you. Whenever the familiar drops to 0 Hit Points or disappears into the pocket dimension, it leaves behind in its space anything it was wearing or carrying.

**One Familiar Only.** You can't have more than one familiar at a time. If you cast this spell while you have a familiar, you instead cause it to adopt a new eligible form.

## Find Steed
*Level 2 Conjuration (Paladin)*
**Casting Time:** Action
**Range:** 30 feet
**Component:** V, S
**Duration:** Instantaneous

You summon an otherworldly being that appears as a loyal steed in an unoccupied space of your choice within range. This creature uses the **Otherworldly Steed** stat block. If you already have a steed from this spell, the steed is replaced by the new one.

The steed resembles a Large, rideable animal of your choice, such as a horse, a camel, a dire wolf, or an elk. Whenever you cast the spell, choose the steed's creature type—Celestial, Fey, or Fiend—which determines certain traits in the stat block.

**Combat.** The steed is an ally to you and your allies. In combat, it shares your Initiative count, and it functions as a controlled mount while you ride it (as defined in the rules on mounted combat). If you have the Incapacitated condition, the steed takes its turn immediately after yours and acts independently, focusing on protecting you.

**Disappearance of the Steed.** The steed disappears if it drops to 0 Hit Points or if you die. When it disappears, it leaves behind anything it was wearing or carrying. If you cast this spell again, you decide whether you summon the steed that disappeared or a different one.

***Using a Higher-Level Spell Slot.*** Use the spell slot's level for the spell's level in the stat block.

---
130
System Reference Document 5.2.1

### Page 131

> ## Otherworldly Steed
> *Large Celestial, Fey, or Fiend (Your Choice), Neutral*
> ___
> **AC** 10 + 1 per spell level
> **HP** 5 + 10 per spell level (the steed has a number of Hit Dice [d10s] equal to the spell's level)
> **Speed** 60 ft., Fly 60 ft. (requires level 4+ spell)
> ___
>| | STR | DEX | CON | INT | WIS | CHA |
>| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
>| **MOD** | 18 +4 | 12 +1 | 14 +2 | 6 –2 | 12 +1 | 8 –1 |
>| **SAVE** | +4 | +1 | +2 | –2 | +1 | –1 |
> ___
> **Senses** Passive Perception 11
> **Languages** Telepathy 1 mile (works only with you)
> **CR** None (XP 0; PB equals your Proficiency Bonus)
> ___
> ### Traits
> **Life Bond.** When you regain Hit Points from a level 1+ spell, the steed regains the same number of Hit Points if you're within 5 feet of it.
> ### Actions
> **Otherworldly Slam.** *Melee Attack Roll:* Bonus equals your spell attack modifier, reach 5 ft. *Hit:* 1d8 plus the spell's level of Radiant (Celestial), Psychic (Fey), or Necrotic (Fiend) damage.
> ### Bonus Actions
> **Fell Glare (Fiend Only; Recharges after a Long Rest).** *Wisdom Saving Throw:* DC equals your spell save DC, one creature within 60 feet the steed can see. *Failure:* The target has the Frightened condition until the end of your next turn.
>
> **Fey Step (Fey Only; Recharges after a Long Rest).** The steed teleports, along with its rider, to an unoccupied space of your choice up to 60 feet away from itself.
>
> **Healing Touch (Celestial Only; Recharges after a Long Rest).** One creature within 5 feet of the steed regains a number of Hit Points equal to 2d8 plus the spell's level.

## Find the Path
*Level 6 Divination (Bard, Cleric, Druid)*
**Casting Time:** 1 minute
**Range:** Self
**Components:** V, S, M (a set of divination tools—such as cards or runes—worth 100+ GP)
**Duration:** Concentration, up to 1 day

You magically sense the most direct physical route to a location you name. You must be familiar with the location, and the spell fails if you name a destination on another plane of existence, a moving destination (such as a mobile fortress), or an unspecific destination (such as "a green dragon's lair").

For the duration, as long as you are on the same plane of existence as the destination, you know how far it is and in what direction it lies. Whenever you face a choice of paths along the way there, you know which path is the most direct.

## Find Traps
*Level 2 Divination (Cleric, Druid, Ranger)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You sense any trap within range that is within line of sight. A trap, for the purpose of this spell, includes any object or mechanism that was created to cause damage or other danger. Thus, the spell would sense the *Alarm* or *Glyph of Warding* spell or a mechanical pit trap, but it wouldn't reveal a natural weakness in the floor, an unstable ceiling, or a hidden sinkhole.

This spell reveals that a trap is present but not its location. You do learn the general nature of the danger posed by a trap you sense.

## Finger of Death
*Level 7 Necromancy (Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

You unleash negative energy toward a creature you can see within range. The target makes a Constitution saving throw, taking 7d8 + 30 Necrotic damage on a failed save or half as much damage on a successful one.

A Humanoid killed by this spell rises at the start of your next turn as a **Zombie** (see "Monsters") that follows your verbal orders.

## Fireball
*Level 3 Evocation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 150 feet
**Components:** V, S, M (a ball of bat guano and sulfur)
**Duration:** Instantaneous

A bright streak flashes from you to a point you choose within range and then blossoms with a low roar into a fiery explosion. Each creature in a 20-foot-radius Sphere centered on that point makes a Dexterity saving throw, taking 8d6 Fire damage on a failed save or half as much damage on a successful one.

Flammable objects in the area that aren't being worn or carried start burning.

***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 3.

---
131
System Reference Document 5.2.1

### Page 132

## Fire Bolt
*Evocation Cantrip (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You hurl a mote of fire at a creature or an object within range. Make a ranged spell attack against the target. On a hit, the target takes 1d10 Fire damage. A flammable object hit by this spell starts burning if it isn't being worn or carried.

***Cantrip Upgrade.*** The damage increases by 1d10 when you reach levels 5 (2d10), 11 (3d10), and 17 (4d10).

## Fire Shield
*Level 4 Evocation (Druid, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a bit of phosphorus or a firefly)
**Duration:** 10 minutes

Wispy flames wreathe your body for the duration, shedding Bright Light in a 10-foot radius and Dim Light for an additional 10 feet.

The flames provide you with a warm shield or a chill shield, as you choose. The warm shield grants you Resistance to Cold damage, and the chill shield grants you Resistance to Fire damage.

In addition, whenever a creature within 5 feet of you hits you with a melee attack roll, the shield erupts with flame. The attacker takes 2d8 Fire damage from a warm shield or 2d8 Cold damage from a chill shield.

## Fire Storm
*Level 7 Evocation (Cleric, Druid, Sorcerer)*
**Casting Time:** Action
**Range:** 150 feet
**Components:** V, S
**Duration:** Instantaneous

A storm of fire appears within range. The area of the storm consists of up to ten 10-foot Cubes, which you arrange as you like. Each Cube must be contiguous with at least one other Cube. Each creature in the area makes a Dexterity saving throw, taking 7d10 Fire damage on a failed save or half as much damage on a successful one.

Flammable objects in the area that aren't being worn or carried start burning.

## Flame Blade
*Level 2 Evocation (Druid, Sorcerer)*
**Casting Time:** Bonus Action
**Range:** Self
**Components:** V, S, M (a sumac leaf)
**Duration:** Concentration, up to 10 minutes

You evoke a fiery blade in your free hand. The blade is similar in size and shape to a scimitar, and it lasts for the duration. If you let go of the blade, it disappears, but you can evoke it again as a Bonus Action.

As a Magic action, you can make a melee spell attack with the fiery blade. On a hit, the target takes Fire damage equal to 3d6 plus your spellcasting ability modifier.

The flaming blade sheds Bright Light in a 10-foot radius and Dim Light for an additional 10 feet.

***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 2.

## Flame Strike
*Level 5 Evocation (Cleric)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a pinch of sulfur)
**Duration:** Instantaneous

A vertical column of brilliant fire roars down from above. Each creature in a 10-foot-radius, 40-foot-high Cylinder centered on a point within range makes a Dexterity saving throw, taking 5d6 Fire damage and 5d6 Radiant damage on a failed save or half as much damage on a successful one.

***Using a Higher-Level Spell Slot.*** The Fire damage and the Radiant damage increase by 1d6 for each spell slot level above 5.

## Flaming Sphere
*Level 2 Conjuration (Druid, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a ball of wax)
**Duration:** Concentration, up to 1 minute

You create a 5-foot-diameter sphere of fire in an unoccupied space on the ground within range. It lasts for the duration. Any creature that ends its turn within 5 feet of the sphere makes a Dexterity saving throw, taking 2d6 Fire damage on a failed save or half as much damage on a successful one.

As a Bonus Action, you can move the sphere up to 30 feet, rolling it along the ground. If you move the sphere into a creature's space, that creature makes the save against the sphere, and the sphere stops moving for the turn.

When you move the sphere, you can direct it over barriers up to 5 feet tall and jump it across pits up to 10 feet wide. Flammable objects that aren't being worn or carried start burning if touched by the sphere, and it sheds Bright Light in a 20-foot radius and Dim Light for an additional 20 feet.

***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 2.

---
132
System Reference Document 5.2.1

### Page 133

## Flesh to Stone
*Level 6 Transmutation (Druid, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a cockatrice feather)
**Duration:** Concentration, up to 1 minute

You attempt to turn one creature that you can see within range into stone. The target makes a Constitution saving throw. On a failed save, it has the Restrained condition for the duration. On a successful save, its Speed is 0 until the start of your next turn. Constructs automatically succeed on the save.

A Restrained target makes another Constitution saving throw at the end of each of its turns. If it successfully saves against this spell three times, the spell ends. If it fails its saves three times, it is turned to stone and has the Petrified condition for the duration. The successes and failures needn't be consecutive; keep track of both until the target collects three of a kind.

If you maintain your Concentration on this spell for the entire possible duration, the target is Petrified until the condition is ended by *Greater Restoration* or similar magic.

## Floating Disk
*Level 1 Conjuration (Wizard)*
**Casting Time:** Action or Ritual
**Range:** 30 feet
**Components:** V, S, M (a drop of mercury)
**Duration:** 1 hour

This spell creates a circular, horizontal plane of force, 3 feet in diameter and 1 inch thick, that floats 3 feet above the ground in an unoccupied space of your choice that you can see within range. The disk remains for the duration and can hold up to 500 pounds. If more weight is placed on it, the spell ends, and everything on the disk falls to the ground.

The disk is immobile while you are within 20 feet of it. If you move more than 20 feet away from it, the disk follows you so that it remains within 20 feet of you. It can move across uneven terrain, up or down stairs, slopes and the like, but it can't cross an elevation change of 10 feet or more. For example, the disk can't move across a 10-foot-deep pit, nor could it leave such a pit if it was created at the bottom.

If you move more than 100 feet from the disk (typically because it can't move around an obstacle to follow you), the spell ends.

## Fly
*Level 3 Transmutation (Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a feather)
**Duration:** Concentration, up to 10 minutes

You touch a willing creature. For the duration, the target gains a Fly Speed of 60 feet and can hover. When the spell ends, the target falls if it is still aloft unless it can stop the fall.

***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 3.

## Fog Cloud
*Level 1 Conjuration (Druid, Ranger, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 1 hour

You create a 20-foot-radius Sphere of fog centered on a point within range. The Sphere is Heavily Obscured. It lasts for the duration or until a strong wind (such as one created by *Gust of Wind*) disperses it.

***Using a Higher-Level Spell Slot.*** The fog's radius increases by 20 feet for each spell slot level above 1.

## Forbiddance
*Level 6 Abjuration (Cleric)*
**Casting Time:** 10 minutes or Ritual
**Range:** Touch
**Components:** V, S, M (ruby dust worth 1,000+ GP)
**Duration:** 1 day

You create a ward against magical travel that protects up to 40,000 square feet of floor space to a height of 30 feet above the floor. For the duration, creatures can't teleport into the area or use portals, such as those created by the *Gate* spell, to enter the area. The spell proofs the area against planar travel, and therefore prevents creatures from accessing the area by way of the Astral Plane, the Ethereal Plane, the Feywild, the Shadowfell, or the *Plane Shift* spell.

In addition, the spell damages types of creatures that you choose when you cast it. Choose one or more of the following: Aberrations, Celestials, Elementals, Fey, Fiends, and Undead. When a creature of a chosen type enters the spell's area for the first time on a turn or ends its turn there, the creature takes 5d10 Radiant or Necrotic damage (your choice when you cast this spell).

You can designate a password when you cast the spell. A creature that speaks the password as it enters the area takes no damage from the spell.

The spell's area can't overlap with the area of another *Forbiddance* spell. If you cast *Forbiddance* every day for 30 days in the same location, the spell lasts until it is dispelled, and the Material components are consumed on the last casting.

---
133
System Reference Document 5.2.1

### Page 134

## Forcecage
*Level 7 Evocation (Bard, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 100 feet
**Components:** V, S, M (ruby dust worth 1,500+ GP, which the spell consumes)
**Duration:** Concentration, up to 1 hour

An immobile, Invisible, Cube-shaped prison composed of magical force springs into existence around an area you choose within range. The prison can be a cage or a solid box, as you choose.

A prison in the shape of a cage can be up to 20 feet on a side and is made from 1/2-inch diameter bars spaced 1/2 inch apart. A prison in the shape of a box can be up to 10 feet on a side, creating a solid barrier that prevents any matter from passing through it and blocking any spells cast into or out from the area.

When you cast the spell, any creature that is completely inside the cage's area is trapped. Creatures only partially within the area, or those too large to fit inside it, are pushed away from the center of the area until they are completely outside it.

A creature inside the cage can't leave it by non-magical means. If the creature tries to use teleportation or interplanar travel to leave, it must first make a Charisma saving throw. On a successful save, the creature can use that magic to exit the cage. On a failed save, the creature doesn't exit the cage and wastes the spell or effect. The cage also extends into the Ethereal Plane, blocking ethereal travel.

This spell can't be dispelled by *Dispel Magic*.

## Foresight
*Level 9 Divination (Bard, Druid, Warlock, Wizard)*
**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (a hummingbird feather)
**Duration:** 8 hours

You touch a willing creature and bestow a limited ability to see into the immediate future. For the duration, the target has Advantage on D20 Tests, and other creatures have Disadvantage on attack rolls against it. The spell ends early if you cast it again.

## Freedom of Movement
*Level 4 Abjuration (Bard, Cleric, Druid, Ranger)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a leather strap)
**Duration:** 1 hour

You touch a willing creature. For the duration, the target's movement is unaffected by Difficult Terrain, and spells and other magical effects can neither reduce the target's Speed nor cause the target to have the Paralyzed or Restrained conditions. The target also has a Swim Speed equal to its Speed.

In addition, the target can spend 5 feet of movement to automatically escape from nonmagical restraints, such as manacles or a creature imposing the Grappled condition on it.

***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 4.

## Freezing Sphere
*Level 6 Evocation (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 300 feet
**Components:** V, S, M (a miniature crystal sphere)
**Duration:** Instantaneous

A frigid globe streaks from you to a point of your choice within range, where it explodes in a 60-foot-radius Sphere. Each creature in that area makes a Constitution saving throw, taking 10d6 Cold damage on failed save or half as much damage on a successful one.

If the globe strikes a body of water, it freezes the water to a depth of 6 inches over an area 30 feet square. This ice lasts for 1 minute. Creatures that were swimming on the surface of frozen water are trapped in the ice and have the Restrained condition. A trapped creature can take an action to make a Strength (Athletics) check against your spell save DC to break free.

You can refrain from firing the globe after completing the spell's casting. If you do so, a globe about the size of a sling bullet, cool to the touch, appears in your hand. At any time, you or a creature you give the globe to can throw the globe (to a range of 40 feet) or hurl it with a sling (to the sling's normal range). It shatters on impact, with the same effect as a normal casting of the spell. You can also set the globe down without shattering it. After 1 minute, if the globe hasn't already shattered, it explodes.

***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 6.

## Gaseous Form
*Level 3 Transmutation (Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a bit of gauze)
**Duration:** Concentration, up to 1 hour

A willing creature you touch shape-shifts, along with everything it's wearing and carrying, into a misty cloud for the duration. The spell ends on the target if it drops to 0 Hit Points or if it takes a Magic action to end the spell on itself.

---
134
System Reference Document 5.2.1

### Page 135

While in this form, the target's only method of movement is a Fly Speed of 10 feet, and it can hover. The target can enter and occupy the space of another creature. The target has Resistance to Bludgeoning, Piercing, and Slashing damage; it has Immunity to the Prone condition; and it has Advantage on Strength, Dexterity, and Constitution saving throws. The target can pass through narrow openings, but it treats liquids as though they were solid surfaces.

The target can't talk or manipulate objects, and any objects it was carrying or holding can't be dropped, used, or otherwise interacted with. Finally, the target can't attack or cast spells.

***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 3.

## Gate
*Level 9 Conjuration (Cleric, Sorcerer, Warlock, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a diamond worth 5,000+ GP)
**Duration:** Concentration, up to 1 minute

You conjure a portal linking an unoccupied space you can see within range to a precise location on a different plane of existence. The portal is a circular opening, which you can make 5 to 20 feet in diameter. You can orient the portal in any direction you choose. The portal lasts for the duration, and the portal's destination is visible through it.

The portal has a front and a back on each plane where it appears. Travel through the portal is possible only by moving through its front. Anything that does so is instantly transported to the other plane, appearing in the unoccupied space nearest to the portal.

Deities and other planar rulers can prevent portals created by this spell from opening in their presence or anywhere within their domains.

When you cast this spell, you can speak the name of a specific creature (a pseudonym, title, or nickname doesn't work). If that creature is on a plane other than the one you are on, the portal opens next to the named creature and transports it to the nearest unoccupied space on your side of the portal. You gain no special power over the creature, and it is free to act as the GM deems appropriate. It might leave, attack you, or help you.

## Geas
*Level 5 Enchantment (Bard, Cleric, Druid, Paladin, Wizard)*
**Casting Time:** 1 minute
**Range:** 60 feet
**Components:** V
**Duration:** 30 days

You give a verbal command to a creature that you can see within range, ordering it to carry out some service or refrain from an action or a course of activity as you decide. The target must succeed on a Wisdom saving throw or have the Charmed condition for the duration. The target automatically succeeds if it can't understand your command.

While Charmed, the creature takes 5d10 Psychic damage if it acts in a manner directly counter to your command. It takes this damage no more than once each day.

You can issue any command you choose, short of an activity that would result in certain death. Should you issue a suicidal command, the spell ends.

A *Remove Curse*, *Greater Restoration*, or *Wish* spell ends this spell.

***Using a Higher-Level Spell Slot.*** If you use a level 7 or 8 spell slot, the duration is 365 days. If you use a level 9 spell slot, the spell lasts until it is ended by one of the spells mentioned above.

## Gentle Repose
*Level 2 Necromancy (Cleric, Paladin, Wizard)*
**Casting Time:** Action or Ritual
**Range:** Touch
**Components:** V, S, M (2 Copper Pieces, which the spell consumes)
**Duration:** 10 days

You touch a corpse or other remains. For the duration, the target is protected from decay and can't become Undead.

The spell also effectively extends the time limit on raising the target from the dead, since days spent under the influence of this spell don't count against the time limit of spells such as *Raise Dead*.

## Giant Insect
*Level 4 Conjuration (Druid)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You summon a giant centipede, spider, or wasp (chosen when you cast the spell). It manifests in an unoccupied space you can see within range and uses the **Giant Insect** stat block. The form you choose determines certain details in its stat block. The creature disappears when it drops to 0 Hit Points or when the spell ends.

The creature is an ally to you and your allies. In combat, the creature shares your Initiative count, but it takes its turn immediately after yours. It obeys your verbal commands (no action required by you). If you don't issue any, it takes the Dodge action and uses its movement to avoid danger.

---
135
System Reference Document 5.2.1

### Page 136

***Using a Higher-Level Spell Slot.*** Use the spell slot's level for the spell's level in the stat block.

> ## Giant Insect
> *Large Beast, Unaligned*
> ___
> **AC** 11 + the spell's level
> **HP** 30 + 10 for each spell level above 4
> **Speed** 40 ft., Climb 40 ft., Fly 40 ft. (Wasp only)
> ___
>| | STR | DEX | CON | INT | WIS | CHA |
>| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
>| **MOD** | 17 +3 | 13 +1 | 15 +2 | 4 –3 | 14 +2 | 3 –4 |
>| **SAVE** | +3 | +1 | +2 | –3 | +2 | –4 |
> ___
> **Senses** Darkvision 60 ft.; Passive Perception 12
> **Languages** Understands the languages you know
> **CR** None (XP 0; PB equals your Proficiency Bonus)
> ___
> ### Traits
> **Spider Climb.** The insect can climb difficult surfaces, including along ceilings, without needing to make an ability check.
> ### Actions
> **Multiattack.** The insect makes a number of attacks equal to half this spell's level (round down).
>
> **Poison Jab.** *Melee Attack Roll:* Bonus equals your spell attack modifier, reach 10 ft. *Hit:* 1d6 + 3 plus the spell's level Piercing damage plus 1d4 Poison damage.
>
> **Web Bolt (Spider Only).** *Ranged Attack Roll:* Bonus equals your spell attack modifier, range 60 ft. *Hit:* 1d10 + 3 plus the spell's level Bludgeoning damage, and the target's Speed is reduced to 0 until the start of the insect's next turn.
> ### Bonus Actions
> **Venomous Spew (Centipede Only).** *Constitution Saving Throw:* Your spell save DC, one creature the insect can see within 10 feet. *Failure:* The target has the Poisoned condition until the start of the insect's next turn.

## Glibness
*Level 8 Enchantment (Bard, Warlock)*
**Casting Time:** Action
**Range:** Self
**Components:** V
**Duration:** 1 hour

Until the spell ends, when you make a Charisma check, you can replace the number you roll with a 15. Additionally, no matter what you say, magic that would determine if you are telling the truth indicates that you are being truthful.

## Globe of Invulnerability
*Level 6 Abjuration (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a glass bead)
**Duration:** Concentration, up to 1 minute

An immobile, shimmering barrier appears in a 10-foot Emanation around you and remains for the duration.

Any spell of level 5 or lower cast from outside the barrier can't affect anything within it. Such a spell can target creatures and objects within the barrier, but the spell has no effect on them. Similarly, the area within the barrier is excluded from areas of effect created by such spells.

***Using a Higher-Level Spell Slot.*** The barrier blocks spells of 1 level higher for each spell slot level above 6.

## Glyph of Warding
*Level 3 Abjuration (Bard, Cleric, Wizard)*
**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (powdered diamond worth 200+ GP, which the spell consumes)
**Duration:** Until dispelled or triggered

You inscribe a glyph that later unleashes a magical effect. You inscribe it either on a surface (such as a table or a section of floor) or within an object that can be closed (such as a book or chest) to conceal the glyph. The glyph can cover an area no larger than 10 feet in diameter. If the surface or object is moved more than 10 feet from where you cast this spell, the glyph is broken, and the spell ends without being triggered.

The glyph is nearly imperceptible and requires a successful Wisdom (Perception) check against your spell save DC to notice.

When you inscribe the glyph, you set its trigger and choose whether it's an explosive rune or a spell glyph, as explained below.

**Set the Trigger.** You decide what triggers the glyph when you cast the spell. For glyphs inscribed on a surface, common triggers include touching or stepping on the glyph, removing another object covering it, or approaching within a certain distance of it. For glyphs inscribed within an object, common triggers include opening that object or seeing the glyph. Once a glyph is triggered, this spell ends.

You can refine the trigger so that only creatures of certain types activate it (for example, the glyph could be set to affect Aberrations). You can also set conditions for creatures that don't trigger the glyph, such as those who say a certain password.

**Explosive Rune.** When triggered, the glyph erupts with magical energy in a 20-foot-radius Sphere centered on the glyph. Each creature in the area makes a Dexterity saving throw. A creature takes 5d8 Acid, Cold, Fire, Lightning, or Thunder damage (your

---
136
System Reference Document 5.2.1

### Page 137

choice when you create the glyph) on a failed save or half as much damage on a successful one.

**Spell Glyph.** You can store a prepared spell of level 3 or lower in the glyph by casting it as part of creating the glyph. The spell must target a single creature or an area. The spell being stored has no immediate effect when cast in this way.

When the glyph is triggered, the stored spell takes effect. If the spell has a target, it targets the creature that triggered the glyph. If the spell affects an area, the area is centered on that creature. If the spell summons Hostile creatures or creates harmful objects or traps, they appear as close as possible to the intruder and attack it. If the spell requires Concentration, it lasts until the end of its full duration.

***Using a Higher-Level Spell Slot.*** The damage of an explosive rune increases by 1d8 for each spell slot level above 3. If you create a spell glyph, you can store any spell of up to the same level as the spell slot you use for the *Glyph of Warding*.

## Goodberry
*Level 1 Conjuration (Druid, Ranger)*
**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a sprig of mistletoe)
**Duration:** 24 hours

Ten berries appear in your hand and are infused with magic for the duration. A creature can take a Bonus Action to eat one berry. Eating a berry restores 1 Hit Point, and the berry provides enough nourishment to sustain a creature for one day.

Uneaten berries disappear when the spell ends.

## Grease
*Level 1 Conjuration (Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a bit of pork rind or butter)
**Duration:** 1 minute

Nonflammable grease covers the ground in a 10-foot square centered on a point within range and turns it into Difficult Terrain for the duration.

When the grease appears, each creature standing in its area must succeed on a Dexterity saving throw or have the Prone condition. A creature that enters the area or ends its turn there must also succeed on that save or fall Prone.

## Greater Invisibility
*Level 4 Illusion (Bard, Sorcerer, Wizard)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 minute

A creature you touch has the Invisible condition until the spell ends.

## Greater Restoration
*Level 5 Abjuration (Bard, Cleric, Druid, Paladin, Ranger)*
**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (diamond dust worth 100+ GP, which the spell consumes)
**Duration:** Instantaneous

You touch a creature and magically remove one of the following effects from it:
* 1 Exhaustion level
* The Charmed or Petrified condition
* A curse, including the target's Attunement to a cursed magic item
* Any reduction to one of the target's ability scores
* Any reduction to the target's Hit Point maximum

## Guardian of Faith
*Level 4 Conjuration (Cleric)*
**Casting Time:** Action
**Range:** 30 feet
**Components:** V
**Duration:** 8 hours

A Large spectral guardian appears and hovers for the duration in an unoccupied space that you can see within range. The guardian occupies that space and is invulnerable, and it appears in a form appropriate for your deity or pantheon.

Any enemy that moves to a space within 10 feet of the guardian for the first time on a turn or starts its turn there makes a Dexterity saving throw, taking 20 Radiant damage on a failed save or half as much damage on a successful one. The guardian vanishes when it has dealt a total of 60 damage.

## Guards and Wards
*Level 6 Abjuration (Bard, Wizard)*
**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (a silver rod worth 10+ GP)
**Duration:** 24 hours

You create a ward that protects up to 2,500 square feet of floor space. The warded area can be up to 20 feet tall, and you shape it as one 50-foot square, one hundred 5-foot squares that are contiguous, or twenty-five 10-foot squares that are contiguous.

When you cast this spell, you can specify individuals that are unaffected by the spell's effects. You can also specify a password that, when spoken aloud within 5 feet of the warded area, makes the speaker immune to its effects.

---
137
System Reference Document 5.2.1