This is a multi-page document. The transcription for each page is provided below.

***

### Page 1

The spell creates the effects below within the warded area. *Dispel Magic* has no effect on *Guards and Wards* itself, but each of the following effects can be dispelled. If all four are dispelled, *Guards and Wards* ends. If you cast the spell every day for 365 days on the same area, the spell thereafter lasts until all its effects are dispelled.
**Corridors.** Fog fills all the warded corridors, making them Heavily Obscured. In addition, at each intersection or branching passage offering a choice of direction, there is a 50 percent chance that a creature other than you believes it is going in the opposite direction from the one it chooses.
**Doors.** All doors in the warded area are magically locked, as if sealed by the *Arcane Lock* spell. In addition, you can cover up to ten doors with an illusion to make them appear as plain sections of wall.
**Stairs.** Webs fill all stairs in the warded area from top to bottom, as in the *Web* spell. These strands regrow in 10 minutes if they are destroyed while *Guards and Wards* lasts.
**Other Spell Effect.** Place one of the following magical effects within the warded area:

*   *Dancing Lights* in four corridors, with a simple program that the lights repeat as long as *Guards and Wards* lasts
*   *Magic Mouth* in two locations
*   *Stinking Cloud* in two locations (the vapors return within 10 minutes if dispersed while *Guards and Wards* lasts)
*   *Gust of Wind* in one corridor or room (the wind blows continuously while the spell lasts)
*   *Suggestion* in one 5-foot square; any creature that enters that square receives the suggestion mentally

### Guidance
*Divination Cantrip (Cleric, Druid)*

**Casting Time:** Action
**Range:** Touch
**Component:** V, S
**Duration:** Concentration, up to 1 minute

You touch a willing creature and choose a skill. Until the spell ends, the creature adds 1d4 to any ability check using the chosen skill.

### Guiding Bolt
*Level 1 Evocation (Cleric)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** 1 round

You hurl a bolt of light toward a creature within range. Make a ranged spell attack against the target. On a hit, it takes 4d6 Radiant damage, and the next attack roll made against it before the end of your next turn has Advantage.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 1.

### Gust of Wind
*Level 2 Evocation (Druid, Ranger, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a legume seed)
**Duration:** Concentration, up to 1 minute

A Line of strong wind 60 feet long and 10 feet wide blasts from you in a direction you choose for the duration. Each creature in the Line must succeed on a Strength saving throw or be pushed 15 feet away from you in a direction following the Line. A creature that ends its turn in the Line must make the same save.
Any creature in the Line must spend 2 feet of movement for every 1 foot it moves when moving closer to you.
The gust disperses gas or vapor, and it extinguishes candles and similar unprotected flames in the area. It causes protected flames, such as those of lanterns, to dance wildly and has a 50 percent chance to extinguish them.
As a Bonus Action on your later turns, you can change the direction in which the Line blasts from you.

### Hallow
*Level 5 Abjuration (Cleric)*

**Casting Time:** 24 hours
**Range:** Touch
**Components:** V, S, M (incense worth 1,000+ GP, which the spell consumes)
**Duration:** Until dispelled

You touch a point and infuse an area around it with holy or unholy power. The area can have a radius up to 60 feet, and the spell fails if the radius includes an area already under the effect of *Hallow*. The affected area has the following effects.
**Hallowed Ward.** Choose any of these creature types: Aberration, Celestial, Elemental, Fey, Fiend, or Undead. Creatures of the chosen types can't willingly enter the area, and any creature that is possessed by or that has the Charmed or Frightened condition from such creatures isn't possessed, Charmed, or Frightened by them while in the area.
**Extra Effect.** You bind an extra effect to the area from the list below:
**Courage.** Creatures of any types you choose can't gain the Frightened condition while in the area.
**Darkness.** Darkness fills the area. Normal light, as well as magical light created by spells of a level lower than this spell, can't illuminate the area.

***
138 | System Reference Document 5.2.1
***

### Page 2

**Daylight.** Bright light fills the area. Magical Darkness created by spells of a level lower than this spell can't extinguish the light.
**Peaceful Rest.** Dead bodies interred in the area can't be turned into Undead.
**Extradimensional Interference.** Creatures of any types you choose can't enter or exit the area using teleportation or interplanar travel.
**Fear.** Creatures of any types you choose have the Frightened condition while in the area.
**Resistance.** Creatures of any types you choose have Resistance to one damage type of your choice while in the area.
**Silence.** No sound can emanate from within the area, and no sound can reach into it.
**Tongues.** Creatures of any types you choose can communicate with any other creature in the area even if they don't share a common language.
**Vulnerability.** Creatures of any types you choose have Vulnerability to one damage type of your choice while in the area.

### Hallucinatory Terrain
*Level 4 Illusion (Bard, Druid, Warlock, Wizard)*

**Casting Time:** 10 minutes
**Range:** 300 feet
**Components:** V, S, M (a mushroom)
**Duration:** 24 hours

You make natural terrain in a 150-foot Cube in range look, sound, and smell like another sort of natural terrain. Thus, open fields or a road can be made to resemble a swamp, hill, crevasse, or some other difficult or impassable terrain. A pond can be made to seem like a grassy meadow, a precipice like a gentle slope, or a rock-strewn gully like a wide and smooth road. Manufactured structures, equipment, and creatures within the area aren't changed.
The tactile characteristics of the terrain are unchanged, so creatures entering the area are likely to notice the illusion. If the difference isn't obvious by touch, a creature examining the illusion can take the Study action to make an Intelligence (Investigation) check against your spell save DC to disbelieve it. If a creature discerns that the terrain is illusory, the creature sees a vague image superimposed on the real terrain.

### Harm
*Level 6 Necromancy (Cleric)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

You unleash virulent magic on a creature you can see within range. The target makes a Constitution saving throw. On a failed save, it takes 14d6 Necrotic damage, and its Hit Point maximum is reduced by an amount equal to the Necrotic damage it took. On a successful save, it takes half as much damage only. This spell can't reduce a target's Hit Point maximum below 1.

### Haste
*Level 3 Transmutation (Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a shaving of licorice root)
**Duration:** Concentration, up to 1 minute

Choose a willing creature that you can see within range. Until the spell ends, the target's Speed is doubled, it gains a +2 bonus to Armor Class, it has Advantage on Dexterity saving throws, and it gains an additional action on each of its turns. That action can be used to take only the Attack (one attack only), Dash, Disengage, Hide, or Utilize action.
When the spell ends, the target is Incapacitated and has a Speed of 0 until the end of its next turn, as a wave of lethargy washes over it.

### Heal
*Level 6 Abjuration (Cleric, Druid)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

Choose a creature that you can see within range. Positive energy washes through the target, restoring 70 Hit Points. This spell also ends the Blinded, Deafened, and Poisoned conditions on the target.
***Using a Higher-Level Spell Slot.*** The healing increases by 10 for each spell slot level above 6.

### Healing Word
*Level 1 Abjuration (Bard, Cleric, Druid)*

**Casting Time:** Bonus Action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

A creature of your choice that you can see within range regains Hit Points equal to 2d4 plus your spellcasting ability modifier.
***Using a Higher-Level Spell Slot.*** The healing increases by 2d4 for each spell slot level above 1.

### Heat Metal
*Level 2 Transmutation (Bard, Druid)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a piece of iron and a flame)
**Duration:** Concentration, up to 1 minute

***
139 | System Reference Document 5.2.1
***

### Page 3

Choose a manufactured metal object, such as a metal weapon or a suit of Heavy or Medium metal armor, that you can see within range. You cause the object to glow red-hot. Any creature in physical contact with the object takes 2d8 Fire damage when you cast the spell. Until the spell ends, you can take a Bonus Action on each of your later turns to deal this damage again if the object is within range.
If a creature is holding or wearing the object and takes the damage from it, the creature must succeed on a Constitution saving throw or drop the object if it can. If it doesn't drop the object, it has Disadvantage on attack rolls and ability checks until the start of your next turn.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 2.

### Hellish Rebuke
*Level 1 Evocation (Warlock)*

**Casting Time:** Reaction, which you take in response to taking damage from a creature that you can see within 60 feet of yourself
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

The creature that damaged you is momentarily surrounded by green flames. It makes a Dexterity saving throw, taking 2d10 Fire damage on a failed save or half as much damage on a successful one.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d10 for each spell slot level above 1.

### Heroes' Feast
*Level 6 Conjuration (Bard, Cleric, Druid)*

**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, S, M (a gem-encrusted bowl worth 1,000+ GP, which the spell consumes)
**Duration:** Instantaneous

You conjure a feast that appears on a surface in an unoccupied 10-foot Cube next to you. The feast takes 1 hour to consume and disappears at the end of that time, and the beneficial effects don't set in until this hour is over. Up to twelve creatures can partake of the feast.
A creature that partakes gains several benefits, which last for 24 hours. The creature has Resistance to Poison damage, and it has Immunity to the Frightened and Poisoned conditions. Its Hit Point maximum also increases by 2d10, and it gains the same number of Hit Points.

### Heroism
*Level 1 Enchantment (Bard, Paladin)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 minute

A willing creature you touch is imbued with bravery. Until the spell ends, the creature is immune to the Frightened condition and gains Temporary Hit Points equal to your spellcasting ability modifier at the start of each of its turns.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 1.

### Hex
*Level 1 Enchantment (Warlock)*

**Casting Time:** Bonus Action
**Range:** 90 feet
**Components:** V, S, M (the petrified eye of a newt)
**Duration:** Concentration, up to 1 hour

You place a curse on a creature that you can see within range. Until the spell ends, you deal an extra 1d6 Necrotic damage to the target whenever you hit it with an attack roll. Also, choose one ability when you cast the spell. The target has Disadvantage on ability checks made with the chosen ability.
If the target drops to 0 Hit Points before this spell ends, you can take a Bonus Action on a later turn to curse a new creature.
***Using a Higher-Level Spell Slot.*** Your Concentration can last longer with a spell slot of level 2 (up to 4 hours), 3–4 (up to 8 hours), or 5+ (24 hours).

### Hideous Laughter
*Level 1 Enchantment (Bard, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a tart and a feather)
**Duration:** Concentration, up to 1 minute

One creature of your choice that you can see within range makes a Wisdom saving throw. On a failed save, it has the Prone and Incapacitated conditions for the duration. During that time, it laughs uncontrollably if it’s capable of laughter, and it can’t end the Prone condition on itself.
At the end of each of its turns and each time it takes damage, it makes another Wisdom saving throw. The target has Advantage on the save if the save is triggered by damage. On a successful save, the spell ends.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 1.

### Hold Monster
*Level 5 Enchantment (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 90 feet

***
140 | System Reference Document 5.2.1
***

### Page 4

**Components:** V, S, M (a straight piece of iron)
**Duration:** Concentration, up to 1 minute

Choose a creature that you can see within range. The target must succeed on a Wisdom saving throw or have the Paralyzed condition for the duration. At the end of each of its turns, the target repeats the save, ending the spell on itself on a success.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 5.

### Hold Person
*Level 2 Enchantment (Bard, Cleric, Druid, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a straight piece of iron)
**Duration:** Concentration, up to 1 minute

Choose a Humanoid that you can see within range. The target must succeed on a Wisdom saving throw or have the Paralyzed condition for the duration. At the end of each of its turns, the target repeats the save, ending the spell on itself on a success.
***Using a Higher-Level Spell Slot.*** You can target one additional Humanoid for each spell slot level above 2.

### Holy Aura
*Level 8 Abjuration (Cleric)*

**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a reliquary worth 1,000+ GP)
**Duration:** Concentration, up to 1 minute

For the duration, you emit an aura in a 30-foot Emanation. While in the aura, creatures of your choice have Advantage on all saving throws, and other creatures have Disadvantage on attack rolls against them. In addition, when a Fiend or an Undead hits an affected creature with a melee attack roll, the attacker must succeed on a Constitution saving throw or have the Blinded condition until the end of its next turn.

### Hunter's Mark
*Level 1 Divination (Ranger)*

**Casting Time:** Bonus Action
**Range:** 90 feet
**Components:** V
**Duration:** Concentration, up to 1 hour

You magically mark one creature you can see within range as your quarry. Until the spell ends, you deal an extra 1d6 Force damage to the target whenever you hit it with an attack roll. You also have Advantage on any Wisdom (Perception or Survival) check you make to find it.
If the target drops to 0 Hit Points before this spell ends, you can take a Bonus Action to move the mark to a new creature you can see within range.
***Using a Higher-Level Spell Slot.*** Your Concentration can last longer with a spell slot of level 3–4 (up to 8 hours) or 5+ (up to 24 hours).

### Hypnotic Pattern
*Level 3 Illusion (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** S, M (a pinch of confetti)
**Duration:** Concentration, up to 1 minute

You create a twisting pattern of colors in a 30-foot Cube within range. The pattern appears for a moment and vanishes. Each creature in the area who can see the pattern must succeed on a Wisdom saving throw or have the Charmed condition for the duration. While Charmed, the creature has the Incapacitated condition and a Speed of 0.
The spell ends for an affected creature if it takes any damage or if someone else uses an action to shake the creature out of its stupor.

### Ice Knife
*Level 1 Conjuration (Druid, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** S, M (a drop of water or a piece of ice)
**Duration:** Instantaneous

You create a shard of ice and fling it at one creature within range. Make a ranged spell attack against the target. On a hit, the target takes 1d10 Piercing damage. Hit or miss, the shard then explodes. The target and each creature within 5 feet of it must succeed on a Dexterity saving throw or take 2d6 Cold damage.
***Using a Higher-Level Spell Slot.*** The Cold damage increases by 1d6 for each spell slot level above 1.

### Ice Storm
*Level 4 Evocation (Druid, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 300 feet
**Components:** V, S, M (a mitten)
**Duration:** Instantaneous

Hail falls in a 20-foot-radius, 40-foot-high Cylinder centered on a point within range. Each creature in the Cylinder makes a Dexterity saving throw. A creature takes 2d10 Bludgeoning damage and 4d6 Cold damage on a failed save or half as much damage on a successful one.
Hailstones turn ground in the Cylinder into Difficult Terrain until the end of your next turn.

***
141 | System Reference Document 5.2.1
***

### Page 5

***Using a Higher-Level Spell Slot.*** The Bludgeoning damage increases by 1d10 for each spell slot level above 4.

### Identify
*Level 1 Divination (Bard, Wizard)*

**Casting Time:** 1 minute or Ritual
**Range:** Touch
**Components:** V, S, M (a pearl worth 100+ GP)
**Duration:** Instantaneous

You touch an object throughout the spell's casting. If the object is a magic item or some other magical object, you learn its properties and how to use them, whether it requires Attunement, and how many charges it has, if any. You learn whether any ongoing spells are affecting the item and what they are. If the item was created by a spell, you learn that spell's name.
If you instead touch a creature throughout the casting, you learn which ongoing spells, if any, are currently affecting it.

### Illusory Script
*Level 1 Illusion (Bard, Warlock, Wizard)*

**Casting Time:** 1 minute or Ritual
**Range:** Touch
**Components:** S, M (ink worth 10+ GP, which the spell consumes)
**Duration:** 10 days

You write on parchment, paper, or another suitable material and imbue it with an illusion that lasts for the duration. To you and any creatures you designate when you cast the spell, the writing appears normal, seems to be written in your hand, and conveys whatever meaning you intended when you wrote the text. To all others, the writing appears as if it were written in an unknown or magical script that is unintelligible. Alternatively, the illusion can alter the meaning, handwriting, and language of the text, though the language must be one you know.
If the spell is dispelled, the original script and the illusion both disappear.
A creature that has Truesight can read the hidden message.

### Imprisonment
*Level 9 Abjuration (Warlock, Wizard)*

**Casting Time:** 1 minute
**Range:** 30 feet
**Components:** V, S, M (a statuette of the target worth 5,000+ GP)
**Duration:** Until dispelled

You create a magical restraint to hold a creature that you can see within range. The target must make a Wisdom saving throw. On a successful save, the target is unaffected, and it is immune to this spell for the next 24 hours. On a failed save, the target is imprisoned. While imprisoned, the target doesn't need to breathe, eat, or drink, and it doesn't age. Divination spells can't locate or perceive the imprisoned target, and the target can't teleport.
Until the spell ends, the target is also affected by one of the following effects of your choice:
**Burial.** The target is entombed beneath the earth in a hollow globe of magical force that is just large enough to contain the target. Nothing can pass into or out of the globe.
**Chaining.** Chains firmly rooted in the ground hold the target in place. The target has the Restrained condition and can't be moved by any means.
**Hedged Prison.** The target is trapped in a demiplane that is warded against teleportation and planar travel. The demiplane is your choice of a labyrinth, a cage, a tower, or the like.
**Minimus Containment.** The target becomes 1 inch tall and is trapped inside an indestructible gemstone or a similar object. Light can pass through the gemstone (allowing the target to see out and other creatures to see in), but nothing else can pass through by any means.
**Slumber.** The target has the Unconscious condition and can't be awoken.

**Ending the Spell.** When you cast the spell, specify a trigger that will end it. The trigger can be as simple or as elaborate as you choose, but the GM must agree that it has a high likelihood of happening within the next decade. The trigger must be an observable action, such as someone making a particular offering at the temple of your god, saving your true love, or defeating a specific monster.
A *Dispel Magic* spell can end the spell only if it is cast with a level 9 spell slot, targeting either the prison or the component used to create it.

### Incendiary Cloud
*Level 8 Conjuration (Druid, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 150 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

A swirling cloud of embers and smoke fills a 20-foot-radius Sphere centered on a point within range. The cloud's area is Heavily Obscured. It lasts for the duration or until a strong wind (like that created by *Gust of Wind*) disperses it.
When the cloud appears, each creature in it makes a Dexterity saving throw, taking 10d8 Fire damage on a failed save or half as much damage on a successful one. A creature must also make this save when the Sphere moves into its space and when it enters the Sphere or ends its turn there. A creature makes this save only once per turn.

***
142 | System Reference Document 5.2.1
***

### Page 6

The cloud moves 10 feet away from you in a direction you choose at the start of each of your turns.

### Inflict Wounds
*Level 1 Necromancy (Cleric)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

A creature you touch makes a Constitution saving throw, taking 2d10 Necrotic damage on a failed save or half as much damage on a successful one.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d10 for each spell slot level above 1.

### Insect Plague
*Level 5 Conjuration (Cleric, Druid, Sorcerer)*

**Casting Time:** Action
**Range:** 300 feet
**Components:** V, S, M (a locust)
**Duration:** Concentration, up to 10 minutes

Swarming locusts fill a 20-foot-radius Sphere centered on a point you choose within range. The Sphere remains for the duration, and its area is Lightly Obscured and Difficult Terrain.
When the swarm appears, each creature in it makes a Constitution saving throw, taking 4d10 Piercing damage on a failed save or half as much damage on a successful one. A creature also makes this save when it enters the spell's area for the first time on a turn or ends its turn there. A creature makes this save only once per turn.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d10 for each spell slot level above 5.

### Instant Summons
*Level 6 Conjuration (Wizard)*

**Casting Time:** 1 minute or Ritual
**Range:** Touch
**Components:** V, S, M (a sapphire worth 1,000+ GP)
**Duration:** Until dispelled

You touch the sapphire used in the casting and an object weighing 10 pounds or less whose longest dimension is 6 feet or less. The spell leaves an Invisible mark on that object and invisibly inscribes the object's name on the sapphire. Each time you cast this spell, you must use a different sapphire.
Thereafter, you can take a Magic action to speak the object's name and crush the sapphire. The object instantly appears in your hand regardless of physical or planar distances, and the spell ends.
If another creature is holding or carrying the object, crushing the sapphire doesn't transport it, but instead you learn who that creature is and where that creature is currently located.

### Irresistible Dance
*Level 6 Enchantment (Bard, Wizard)*

**Casting Time:** Action
**Range:** 30 feet
**Components:** V
**Duration:** Concentration, up to 1 minute

One creature that you can see within range must make a Wisdom saving throw. On a successful save, the target dances comically until the end of its next turn, during which it must spend all its movement to dance in place.
On a failed save, the target has the Charmed condition for the duration. While Charmed, the target dances comically, must use all its movement to dance in place, and has Disadvantage on Dexterity saving throws and attack rolls, and other creatures have Advantage on attack rolls against it. On each of its turns, the target can take an action to collect itself and repeat the save, ending the spell on itself on a success.

### Invisibility
*Level 2 Illusion (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (an eyelash in gum arabic)
**Duration:** Concentration, up to 1 hour

A creature you touch has the Invisible condition until the spell ends. The spell ends early immediately after the target makes an attack roll, deals damage, or casts a spell.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 2.

### Jump
*Level 1 Transmutation (Druid, Ranger, Sorcerer, Wizard)*

**Casting Time:** Bonus Action
**Range:** Touch
**Component:** V, S, M (a grasshopper's hind leg)
**Duration:** 1 minute

You touch a willing creature. Once on each of its turns until the spell ends, that creature can jump up to 30 feet by spending 10 feet of movement.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 1.

### Knock
*Level 2 Transmutation (Bard, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

***
143 | System Reference Document 5.2.1
***

### Page 7

Choose an object that you can see within range. The object can be a door, a box, a chest, a set of manacles, a padlock, or another object that contains a mundane or magical means that prevents access.
A target that is held shut by a mundane lock or that is stuck or barred becomes unlocked, unstuck, or unbarred. If the object has multiple locks, only one of them is unlocked.
If the target is held shut by *Arcane Lock*, that spell is suppressed for 10 minutes, during which time the target can be opened and closed.
When you cast the spell, a loud knock, audible up to 300 feet away, emanates from the target.

### Legend Lore
*Level 5 Divination (Bard, Cleric, Wizard)*

**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, S, M (incense worth 250+ GP, which the spell consumes, and four ivory strips worth 50+ GP each)
**Duration:** Instantaneous

Name or describe a famous person, place, or object. The spell brings to your mind a brief summary of the significant lore about that famous thing, as described by the GM.
The lore might consist of important details, amusing revelations, or even secret lore that has never been widely known. The more information you already know about the thing, the more precise and detailed the information you receive is. That information is accurate but might be couched in figurative language or poetry, as determined by the GM.
If the famous thing you chose isn't actually famous, you hear sad musical notes played on a trombone, and the spell fails.

### Lesser Restoration
*Level 2 Abjuration (Bard, Cleric, Druid, Paladin, Ranger)*

**Casting Time:** Bonus Action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

You touch a creature and end one condition on it: Blinded, Deafened, Paralyzed, or Poisoned.

### Levitate
*Level 2 Transmutation (Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a metal spring)
**Duration:** Concentration, up to 10 minutes

One creature or loose object of your choice that you can see within range rises vertically up to 20 feet and remains suspended there for the duration. The spell can levitate an object that weighs up to 500 pounds. An unwilling creature that succeeds on a Constitution saving throw is unaffected.
The target can move only by pushing or pulling against a fixed object or surface within reach (such as a wall or a ceiling), which allows it to move as if it were climbing. You can change the target's altitude by up to 20 feet in either direction on your turn. If you are the target, you can move up or down as part of your move. Otherwise, you can take a Magic action to move the target, which must remain within the spell's range.
When the spell ends, the target floats gently to the ground if it is still aloft.

### Light
*Evocation Cantrip (Bard, Cleric, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, M (a firefly or phosphorescent moss)
**Duration:** 1 hour

You touch one Large or smaller object that isn't being worn or carried by someone else. Until the spell ends, the object sheds Bright Light in a 20-foot radius and Dim Light for an additional 20 feet. The light can be colored as you like.
Covering the object with something opaque blocks the light. The spell ends if you cast it again.

### Lightning Bolt
*Level 3 Evocation (Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a bit of fur and a crystal rod)
**Duration:** Instantaneous

A stroke of lightning forming a 100-foot-long, 5-foot-wide Line blasts out from you in a direction you choose. Each creature in the Line makes a Dexterity saving throw, taking 8d6 Lightning damage on a failed save or half as much damage on a successful one.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d6 for each spell slot level above 3.

### Locate Animals or Plants
*Level 2 Divination (Bard, Druid, Ranger)*

**Casting Time:** Action or Ritual
**Range:** Self
**Components:** V, S, M (fur from a bloodhound)
**Duration:** Instantaneous

Describe or name a specific kind of Beast, Plant creature, or nonmagical plant. You learn the direction and distance to the closest creature or plant of that kind within 5 miles, if any are present.

***
144 | System Reference Document 5.2.1
***

### Page 8

### Locate Creature
*Level 4 Divination (Bard, Cleric, Druid, Paladin, Ranger, Wizard)*

**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (fur from a bloodhound)
**Duration:** Concentration, up to 1 hour

Describe or name a creature that is familiar to you. You sense the direction to the creature's location if that creature is within 1,000 feet of you. If the creature is moving, you know the direction of its movement.
The spell can locate a specific creature known to you or the nearest creature of a specific kind (such as a human or a unicorn) if you have seen such a creature up close—within 30 feet—at least once. If the creature you described or named is in a different form, such as under the effects of a *Flesh to Stone* or *Polymorph* spell, this spell doesn't locate the creature.
This spell can't locate a creature if any thickness of lead blocks a direct path between you and the creature.

### Locate Object
*Level 2 Divination (Bard, Cleric, Druid, Paladin, Ranger, Wizard)*

**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (a forked twig)
**Duration:** Concentration, up to 10 minutes

Describe or name an object that is familiar to you. You sense the direction to the object's location if that object is within 1,000 feet of you. If the object is in motion, you know the direction of its movement.
The spell can locate a specific object known to you if you have seen it up close—within 30 feet—at least once. Alternatively, the spell can locate the nearest object of a particular kind, such as a certain kind of apparel, jewelry, furniture, tool, or weapon.
This spell can't locate an object if any thickness of lead blocks a direct path between you and the object.

### Longstrider
*Level 1 Transmutation (Bard, Druid, Ranger, Wizard)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a pinch of dirt)
**Duration:** 1 hour

You touch a creature. The target's Speed increases by 10 feet until the spell ends.
***Using a Higher-Level Spell Slot.*** You can target one additional creature for each spell slot level above 1.

### Mage Armor
*Level 1 Abjuration (Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a piece of cured leather)
**Duration:** 8 hours

You touch a willing creature who isn't wearing armor. Until the spell ends, the target's base AC becomes 13 plus its Dexterity modifier. The spell ends early if the target dons armor.

### Mage Hand
*Conjuration Cantrip (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** 1 minute

A spectral, floating hand appears at a point you choose within range. The hand lasts for the duration. The hand vanishes if it is ever more than 30 feet away from you or if you cast this spell again.
When you cast the spell, you can use the hand to manipulate an object, open an unlocked door or container, stow or retrieve an item from an open container, or pour the contents out of a vial.
As a Magic action on your later turns, you can control the hand thus again. As part of that action, you can move the hand up to 30 feet.
The hand can't attack, activate magic items, or carry more than 10 pounds.

### Magic Circle
*Level 3 Abjuration (Cleric, Paladin, Warlock, Wizard)*

**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, S, M (salt and powdered silver worth 100+ GP, which the spell consumes)
**Duration:** 1 hour

You create a 10-foot-radius, 20-foot-tall Cylinder of magical energy centered on a point on the ground that you can see within range. Glowing runes appear wherever the Cylinder intersects with the floor or other surface.
Choose one or more of the following types of creatures: Celestials, Elementals, Fey, Fiends, or Undead. The circle affects a creature of the chosen type in the following ways:

*   The creature can't willingly enter the Cylinder by nonmagical means. If the creature tries to use teleportation or interplanar travel to do so, it must first succeed on a Charisma saving throw.
*   The creature has Disadvantage on attack rolls against targets within the Cylinder.

***
145 | System Reference Document 5.2.1
***

### Page 9

*   Targets within the Cylinder can't be possessed by or gain the Charmed or Frightened condition from the creature.

Each time you cast this spell, you can cause its magic to operate in the reverse direction, preventing a creature of the specified type from leaving the Cylinder and protecting targets outside it.
***Using a Higher-Level Spell Slot.*** The duration increases by 1 hour for each spell slot level above 3.

### Magic Jar
*Level 6 Necromancy (Wizard)*

**Casting Time:** 1 minute
**Range:** Self
**Components:** V, S, M (a gem, crystal, or reliquary worth 500+ GP)
**Duration:** Until dispelled

Your body falls into a catatonic state as your soul leaves it and enters the container you used for the spell's Material component. While your soul inhabits the container, you are aware of your surroundings as if you were in the container's space. You can't move or take Reactions. The only action you can take is to project your soul up to 100 feet out of the container, either returning to your living body (and ending the spell) or attempting to possess a Humanoid's body.
You can attempt to possess any Humanoid within 100 feet of you that you can see (creatures warded by a *Protection from Evil and Good* or *Magic Circle* spell can't be possessed). The target makes a Charisma saving throw. On a failed save, your soul enters the target's body, and the target's soul becomes trapped in the container. On a successful save, the target resists your efforts to possess it, and you can't attempt to possess it again for 24 hours.
Once you possess a creature's body, you control it. Your Hit Points, Hit Point Dice, Strength, Dexterity, Constitution, Speed, and senses are replaced by the creature's. You otherwise keep your game statistics.
Meanwhile, the possessed creature's soul can perceive from the container using its own senses, but it can't move and it is Incapacitated.
While possessing a body, you can take a Magic action to return from the host body to the container if it is within 100 feet of you, returning the host creature's soul to its body. If the host body dies while you're in it, the creature dies, and you make a Charisma saving throw against your own spellcasting DC. On a success, you return to the container if it is within 100 feet of you. Otherwise, you die.
If the container is destroyed or the spell ends, your soul returns to your body. If your body is more than 100 feet away from you or if your body is dead, you die. If another creature's soul is in the container when it is destroyed, the creature's soul returns to its body if the body is alive and within 100 feet. Otherwise, that creature dies.
When the spell ends, the container is destroyed.

### Magic Missile
*Level 1 Evocation (Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You create three glowing darts of magical force. Each dart strikes a creature of your choice that you can see within range. A dart deals 1d4 + 1 Force damage to its target. The darts all strike simultaneously, and you can direct them to hit one creature or several.
***Using a Higher-Level Spell Slot.*** The spell creates one more dart for each spell slot level above 1.

### Magic Mouth
*Level 2 Illusion (Bard, Wizard)*

**Casting Time:** 1 minute or Ritual
**Range:** 30 feet
**Components:** V, S, M (jade dust worth 10+ GP, which the spell consumes)
**Duration:** Until dispelled

You implant a message within an object in range—a message that is uttered when a trigger condition is met. Choose an object that you can see and that isn't being worn or carried by another creature. Then speak the message, which must be 25 words or fewer, though it can be delivered over as long as 10 minutes. Finally, determine the circumstance that will trigger the spell to deliver your message.
When that trigger occurs, a magical mouth appears on the object and recites the message in your voice and at the same volume you spoke. If the object you chose has a mouth or something that looks like a mouth (for example, the mouth of a statue), the magical mouth appears there, so the words appear to come from the object's mouth. When you cast this spell, you can have the spell end after it delivers its message, or it can remain and repeat its message whenever the trigger occurs.
The trigger can be as general or as detailed as you like, though it must be based on visual or audible conditions that occur within 30 feet of the object. For example, you could instruct the mouth to speak when any creature moves within 30 feet of the object or when a silver bell rings within 30 feet of it.

### Magic Weapon
*Level 2 Transmutation (Paladin, Ranger, Sorcerer, Wizard)*

**Casting Time:** Bonus Action
**Range:** Touch

***
146 | System Reference Document 5.2.1
***

### Page 10

**Components:** V, S
**Duration:** 1 hour

You touch a nonmagical weapon. Until the spell ends, that weapon becomes a magic weapon with a +1 bonus to attack rolls and damage rolls. The spell ends early if you cast it again.
***Using a Higher-Level Spell Slot.*** The bonus increases to +2 with a level 3–5 spell slot. The bonus increases to +3 with a level 6+ spell slot.

### Magnificent Mansion
*Level 7 Conjuration (Bard, Wizard)*

**Casting Time:** 1 minute
**Range:** 300 feet
**Components:** V, S, M (a miniature door worth 15+ GP)
**Duration:** 24 hours

You conjure a shimmering door in range that lasts for the duration. The door leads to an extradimensional dwelling and is 5 feet wide and 10 feet tall. You and any creature you designate when you cast the spell can enter the extradimensional dwelling as long as the door remains open. You can open or close it (no action required) if you are within 30 feet of it. While closed, the door is imperceptible.
Beyond the door is a magnificent foyer with numerous chambers beyond. The dwelling's atmosphere is clean, fresh, and warm.
You can create any floor plan you like for the dwelling, but it can't exceed 50 contiguous 10-foot Cubes. The place is furnished and decorated as you choose. It contains sufficient food to serve a nine-course banquet for up to 100 people. Furnishings and other objects created by this spell dissipate into smoke if removed from it.
A staff of 100 near-transparent servants attends all who enter. You determine the appearance of these servants and their attire. They are invulnerable and obey your commands. Each servant can perform tasks that a human could perform, but they can't attack or take any action that would directly harm another creature. Thus the servants can fetch things, clean, mend, fold clothes, light fires, serve food, pour wine, and so on. The servants can't leave the dwelling.
When the spell ends, any creatures or objects left inside the extradimensional space are expelled into the unoccupied spaces nearest to the entrance.

### Major Image
*Level 3 Illusion (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S, M (a bit of fleece)
**Duration:** Concentration, up to 10 minutes

You create the image of an object, a creature, or some other visible phenomenon that is no larger than a 20-foot Cube. The image appears at a spot that you can see within range and lasts for the duration. It seems real, including sounds, smells, and temperature appropriate to the thing depicted, but it can't deal damage or cause conditions.
If you are within range of the illusion, you can take a Magic action to cause the image to move to any other spot within range. As the image changes location, you can alter its appearance so that its movements appear natural for the image. For example, if you create an image of a creature and move it, you can alter the image so that it appears to be walking. Similarly, you can cause the illusion to make different sounds at different times, even making it carry on a conversation, for example.
Physical interaction with the image reveals it to be an illusion, for things can pass through it. A creature that takes a Study action to examine the image can determine that it is an illusion with a successful Intelligence (Investigation) check against your spell save DC. If a creature discerns the illusion for what it is, the creature can see through the image, and its other sensory qualities become faint to the creature.
***Using a Higher-Level Spell Slot.*** The spell lasts until dispelled, without requiring Concentration, if cast with a level 4+ spell slot.

### Mass Cure Wounds
*Level 5 Abjuration (Bard, Cleric, Druid)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

A wave of healing energy washes out from a point you can see within range. Choose up to six creatures in a 30-foot-radius Sphere centered on that point. Each target regains Hit Points equal to 5d8 plus your spellcasting ability modifier.
***Using a Higher-Level Spell Slot.*** The healing increases by 1d8 for each spell slot level above 5.

### Mass Heal
*Level 9 Abjuration (Cleric)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

A flood of healing energy flows from you into creatures around you. You restore up to 700 Hit Points, divided as you choose among any number of creatures that you can see within range. Creatures healed by this spell also have the Blinded, Deafened, and Poisoned conditions removed from them.

***
147 | System Reference Document 5.2.1
***

### Page 11

### Mass Healing Word
*Level 3 Abjuration (Bard, Cleric)*

**Casting Time:** Bonus Action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

Up to six creatures of your choice that you can see within range regain Hit Points equal to 2d4 plus your spellcasting ability modifier.
***Using a Higher-Level Spell Slot.*** The healing increases by 1d4 for each spell slot level above 3.

### Mass Suggestion
*Level 6 Enchantment (Bard, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, M (a snake's tongue)
**Duration:** 24 hours

You suggest a course of activity—described in no more than 25 words—to twelve or fewer creatures you can see within range that can hear and understand you. The suggestion must sound achievable and not involve anything that would obviously deal damage to any of the targets or their allies. For example, you could say, “Walk to the village down that road, and help the villagers there harvest crops until sunset." Or you could say, "Now is not the time for violence. Drop your weapons, and dance! Stop in an hour."
Each target must succeed on a Wisdom saving throw or have the Charmed condition for the duration or until you or your allies deal damage to the target. Each Charmed target pursues the suggestion to the best of its ability. The suggested activity can continue for the entire duration, but if the suggested activity can be completed in a shorter time, the spell ends for a target upon completing it.
***Using a Higher-Level Spell Slot.*** The duration is longer with a spell slot of level 7 (10 days), 8 (30 days), or 9 (366 days).

### Maze
*Level 8 Conjuration (Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You banish a creature that you can see within range into a labyrinthine demiplane. The target remains there for the duration or until it escapes the maze.
The target can take a Study action to try to escape. When it does so, it makes a DC 20 Intelligence (Investigation) check. If it succeeds, it escapes, and the spell ends.
When the spell ends, the target reappears in the space it left or, if that space is occupied, in the nearest unoccupied space.

### Meld into Stone
*Level 3 Transmutation (Cleric, Druid, Ranger)*

**Casting Time:** Action or Ritual
**Range:** Touch
**Components:** V, S
**Duration:** 8 hours

You step into a stone object or surface large enough to fully contain your body, merging yourself and your equipment with the stone for the duration. You must touch the stone to do so. Nothing of your presence remains visible or otherwise detectable by nonmagical senses.
While merged with the stone, you can't see what occurs outside it, and any Wisdom (Perception) checks you make to hear sounds outside it are made with Disadvantage. You remain aware of the passage of time and can cast spells on yourself while merged in the stone. You can use 5 feet of movement to leave the stone where you entered it, which ends the spell. You otherwise can't move.
Minor physical damage to the stone doesn't harm you, but its partial destruction or a change in its shape (to the extent that you no longer fit within it) expels you and deals 6d6 Force damage to you. The stone's complete destruction (or transmutation into a different substance) expels you and deals 50 Force damage to you. If expelled, you move into an unoccupied space closest to where you first entered and have the Prone condition.

### Mending
*Transmutation Cantrip (Bard, Cleric, Druid, Sorcerer, Wizard)*

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (two lodestones)
**Duration:** Instantaneous

This spell repairs a single break or tear in an object you touch, such as a broken chain link, two halves of a broken key, a torn cloak, or a leaking wineskin. As long as the break or tear is no larger than 1 foot in any dimension, you mend it, leaving no trace of the former damage.
This spell can physically repair a magic item, but it can't restore magic to such an object.

### Message
*Transmutation Cantrip (Bard, Druid, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** S, M (a copper wire)
**Duration:** 1 round

***
148 | System Reference Document 5.2.1
***

### Page 12

You point toward a creature within range and whisper a message. The target (and only the target) hears the message and can reply in a whisper that only you can hear.
You can cast this spell through solid objects if you are familiar with the target and know it is beyond the barrier. Magical silence; 1 foot of stone, metal, or wood; or a thin sheet of lead blocks the spell.

### Meteor Swarm
*Level 9 Evocation (Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 1 mile
**Components:** V, S
**Duration:** Instantaneous

Blazing orbs of fire plummet to the ground at four different points you can see within range. Each creature in a 40-foot-radius Sphere centered on each of those points makes a Dexterity saving throw. A creature takes 20d6 Fire damage and 20d6 Bludgeoning damage on a failed save or half as much damage on a successful one. A creature in the area of more than one fiery Sphere is affected only once.
A nonmagical object that isn't being worn or carried also takes the damage if it's in the spell's area, and the object starts burning if it's flammable.

### Mind Blank
*Level 8 Abjuration (Bard, Wizard)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, S
**Duration:** 24 hours

Until the spell ends, one willing creature you touch has Immunity to Psychic damage and the Charmed condition. The target is also unaffected by anything that would sense its emotions or alignment, read its thoughts, or magically detect its location, and no spell—not even *Wish*—can gather information about the target, observe it remotely, or control its mind.

### Mind Spike
*Level 2 Divination (Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** S
**Duration:** Concentration, up to 1 hour

You drive a spike of psionic energy into the mind of one creature you can see within range. The target makes a Wisdom saving throw, taking 3d8 Psychic damage on a failed save or half as much damage on a successful one. On a failed save, you also always know the target's location until the spell ends, but only while the two of you are on the same plane of existence. While you have this knowledge, the target can't become hidden from you, and if it has the Invisible condition, it gains no benefit from that condition against you.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d8 for each spell slot level above 2.

### Minor Illusion
*Illusion Cantrip (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 30 feet
**Components:** S, M (a bit of fleece)
**Duration:** 1 minute

You create a sound or an image of an object within range that lasts for the duration. See the descriptions below for the effects of each. The illusion ends if you cast this spell again.
If a creature takes a Study action to examine the sound or image, the creature can determine that it is an illusion with a successful Intelligence (Investigation) check against your spell save DC. If a creature discerns the illusion for what it is, the illusion becomes faint to the creature.
**Sound.** If you create a sound, its volume can range from a whisper to a scream. It can be your voice, someone else's voice, a lion's roar, a beating of drums, or any other sound you choose. The sound continues unabated throughout the duration, or you can make discrete sounds at different times before the spell ends.
**Image.** If you create an image of an object—such as a chair, muddy footprints, or a small chest—it must be no larger than a 5-foot Cube. The image can't create sound, light, smell, or any other sensory effect. Physical interaction with the image reveals it to be an illusion, since things can pass through it.

### Mirage Arcane
*Level 7 Illusion (Bard, Druid, Wizard)*

**Casting Time:** 10 minutes
**Range:** Sight
**Components:** V, S
**Duration:** 10 days

You make terrain in an area up to 1 mile square look, sound, smell, and even feel like some other sort of terrain. Open fields or a road could be made to resemble a swamp, hill, crevasse, or some other rough or impassable terrain. A pond can be made to seem like a grassy meadow, a precipice like a gentle slope, or a rock-strewn gully like a wide and smooth road.
Similarly, you can alter the appearance of structures or add them where none are present. The spell doesn't disguise, conceal, or add creatures.
The illusion includes audible, visual, tactile, and olfactory elements, so it can turn clear ground

***
149 | System Reference Document 5.2.1
***

### Page 13

into Difficult Terrain (or vice versa) or otherwise impede movement through the area. Any piece of the illusory terrain (such as a rock or stick) that is removed from the spell's area disappears immediately.
Creatures with Truesight can see through the illusion to the terrain's true form; however, all other elements of the illusion remain, so while the creature is aware of the illusion's presence, the creature can still physically interact with the illusion.

### Mirror Image
*Level 2 Illusion (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** 1 minute

Three illusory duplicates of yourself appear in your space. Until the spell ends, the duplicates move with you and mimic your actions, shifting position so it's impossible to track which image is real.
Each time a creature hits you with an attack roll during the spell's duration, roll a d6 for each of your remaining duplicates. If any of the d6s rolls a 3 or higher, one of the duplicates is hit instead of you, and the duplicate is destroyed. The duplicates otherwise ignore all other damage and effects. The spell ends when all three duplicates are destroyed.
A creature is unaffected by this spell if it has the Blinded condition, Blindsight, or Truesight.

### Mislead
*Level 5 Illusion (Bard, Warlock, Wizard)*

**Casting Time:** Action
**Range:** Self
**Components:** S
**Duration:** Concentration, up to 1 hour

You gain the Invisible condition at the same time that an illusory double of you appears where you are standing. The double lasts for the duration, but the invisibility ends immediately after you make an attack roll, deal damage, or cast a spell.
As a Magic action, you can move the illusory double up to twice your Speed and make it gesture, speak, and behave in whatever way you choose. It is intangible and invulnerable.
You can see through its eyes and hear through its ears as if you were located where it is.

### Misty Step
*Level 2 Conjuration (Sorcerer, Warlock, Wizard)*

**Casting Time:** Bonus Action
**Range:** Self
**Components:** V
**Duration:** Instantaneous

Briefly surrounded by silvery mist, you teleport up to 30 feet to an unoccupied space you can see.

### Modify Memory
*Level 5 Enchantment (Bard, Wizard)*

**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You attempt to reshape another creature's memories. One creature that you can see within range makes a Wisdom saving throw. If you are fighting the creature, it has Advantage on the save. On a failed save, the target has the Charmed condition for the duration. While Charmed in this way, the target also has the Incapacitated condition and is unaware of its surroundings, though it can hear you. If it takes any damage or is targeted by another spell, this spell ends, and no memories are modified.
While this charm lasts, you can affect the target's memory of an event that it experienced within the last 24 hours and that lasted no more than 10 minutes. You can permanently eliminate all memory of the event, allow the target to recall the event with perfect clarity, change its memory of the event's details, or create a memory of some other event.
You must speak to the target to describe how its memories are affected, and it must be able to understand your language for the modified memories to take root. Its mind fills in any gaps in the details of your description. If the spell ends before you finish describing the modified memories, the creature's memory isn't altered. Otherwise, the modified memories take hold when the spell ends.
A modified memory doesn't necessarily affect how a creature behaves, particularly if the memory contradicts the creature's natural inclinations, alignment, or beliefs. An illogical modified memory, such as a false memory of how much the creature enjoyed swimming in acid, is dismissed as a bad dream. The GM might deem a modified memory too nonsensical to affect a creature.
A *Remove Curse* or *Greater Restoration* spell cast on the target restores the creature's true memory.
***Using a Higher-Level Spell Slot.*** You can alter the target's memories of an event that took place up to 7 days ago (level 6 spell slot), 30 days ago (level 7 spell slot), 365 days ago (level 8 spell slot), or any time in the creature's past (level 9 spell slot).

### Moonbeam
*Level 2 Evocation (Druid)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S, M (a moonseed leaf)
**Duration:** Concentration, up to 1 minute

***
150 | System Reference Document 5.2.1
***

### Page 14

A silvery beam of pale light shines down in a 5-foot-radius, 40-foot-high Cylinder centered on a point within range. Until the spell ends, Dim Light fills the Cylinder, and you can take a Magic action on later turns to move the Cylinder up to 60 feet.
When the Cylinder appears, each creature in it makes a Constitution saving throw. On a failed save, a creature takes 2d10 Radiant damage, and if the creature is shape-shifted (as a result of the *Polymorph* spell, for example), it reverts to its true form and can't shape-shift until it leaves the Cylinder.
On a successful save, a creature takes half as much damage only. A creature also makes this save when the spell's area moves into its space and when it enters the spell's area or ends its turn there. A creature makes this save only once per turn.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d10 for each spell slot level above 2.

### Move Earth
*Level 6 Transmutation (Druid, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S, M (a miniature shovel)
**Duration:** Concentration, up to 2 hours

Choose an area of terrain no larger than 40 feet on a side within range. You can reshape dirt, sand, or clay in the area in any manner you choose for the duration. You can raise or lower the area's elevation, create or fill in a trench, erect or flatten a wall, or form a pillar. The extent of any such changes can't exceed half the area's largest dimension. For example, if you affect a 40-foot square, you can create a pillar up to 20 feet high, raise or lower the square's elevation by up to 20 feet, dig a trench up to 20 feet deep, and so on. It takes 10 minutes for these changes to complete. Because the terrain's transformation occurs slowly, creatures in the area can't usually be trapped or injured by the ground's movement.
At the end of every 10 minutes you spend concentrating on the spell, you can choose a new area of terrain to affect within range.
This spell can't manipulate natural stone or stone construction. Rocks and structures shift to accommodate the new terrain. If the way you shape the terrain would make a structure unstable, it might collapse.
Similarly, this spell doesn't directly affect plant growth. The moved earth carries any plants along with it.

### Nondetection
*Level 3 Abjuration (Bard, Ranger, Wizard)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a pinch of diamond dust worth 25+ GP, which the spell consumes)
**Duration:** 8 hours

For the duration, you hide a target that you touch from Divination spells. The target can be a willing creature, or it can be a place or an object no larger than 10 feet in any dimension. The target can't be targeted by any Divination spell or perceived through magical scrying sensors.

### Passwall
*Level 5 Transmutation (Wizard)*

**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S, M (a pinch of sesame seeds)
**Duration:** 1 hour

A passage appears at a point that you can see on a wooden, plaster, or stone surface (such as a wall, ceiling, or floor) within range and lasts for the duration. You choose the opening's dimensions: up to 5 feet wide, 8 feet tall, and 20 feet deep. The passage creates no instability in a structure surrounding it.
When the opening disappears, any creatures or objects still in the passage created by the spell are safely ejected to an unoccupied space nearest to the surface on which you cast the spell.

### Pass without Trace
*Level 2 Abjuration (Druid, Ranger)*

**Casting Time:** Action
**Range:** Self
**Components:** V, S, M (ashes from burned mistletoe)
**Duration:** Concentration, up to 1 hour

You radiate a concealing aura in a 30-foot Emanation for the duration. While in the aura, you and each creature you choose have a +10 bonus to Dexterity (Stealth) checks and leave no tracks.

### Phantasmal Force
*Level 2 Illusion (Bard, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a bit of fleece)
**Duration:** Concentration, up to 1 minute

You attempt to craft an illusion in the mind of a creature you can see within range. The target makes an Intelligence saving throw. On a failed save, you create a phantasmal object, creature, or other phenomenon that is no larger than a 10-foot Cube and that is perceivable only to the target for the duration. The phantasm includes sound, temperature, and other stimuli.
The target can take a Study action to examine the phantasm with an Intelligence (Investigation) check against your spell save DC. If the check succeeds,

***
151 | System Reference Document 5.2.1
***

### Page 15

the target realizes that the phantasm is an illusion, and the spell ends.
While affected by the spell, the target treats the phantasm as if it were real and rationalizes any illogical outcomes from interacting with it. For example, if the target steps through a phantasmal bridge and survives the fall, it believes the bridge exists and something else caused it to fall.
An affected target can even take damage from the illusion if the phantasm represents a dangerous creature or hazard. On each of your turns, such a phantasm can deal 2d8 Psychic damage to the target if it is in the phantasm's area or within 5 feet of the phantasm. The target perceives the damage as a type appropriate to the illusion.

### Phantasmal Killer
*Level 4 Illusion (Bard, Wizard)*

**Casting Time:** Action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You tap into the nightmares of a creature you can see within range and create an illusion of its deepest fears, visible only to that creature. The target makes a Wisdom saving throw. On a failed save, the target takes 4d10 Psychic damage and has Disadvantage on ability checks and attack rolls for the duration. On a successful save, the target takes half as much damage, and the spell ends.
For the duration, the target makes a Wisdom saving throw at the end of each of its turns. On a failed save, it takes the Psychic damage again. On a successful save, the spell ends.
***Using a Higher-Level Spell Slot.*** The damage increases by 1d10 for each spell slot level above 4.

### Phantom Steed
*Level 3 Illusion (Wizard)*

**Casting Time:** 1 minute or Ritual
**Range:** 30 feet
**Components:** V, S
**Duration:** 1 hour

A Large, quasi-real, horselike creature appears on the ground in an unoccupied space of your choice within range. You decide the creature's appearance, and it is equipped with a saddle, bit, and bridle. Any of the equipment created by the spell vanishes in a puff of smoke if it is carried more than 10 feet away from the steed.
For the duration, you or a creature you choose can ride the steed. The steed uses the Riding Horse stat block (see "Monsters”), except it has a Speed of 100 feet and can travel 13 miles in an hour. When the spell ends, the steed gradually fades, giving the rider 1 minute to dismount. The spell ends early if the steed takes any damage.

### Planar Ally
*Level 6 Conjuration (Cleric)*

**Casting Time:** 10 minutes
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

You beseech an otherworldly entity for aid. The being must be known to you: a god, a demon prince, or some other being of cosmic power. That entity sends a Celestial, an Elemental, or a Fiend loyal to it to aid you, making the creature appear in an unoccupied space within range. If you know a specific creature's name, you can speak that name when you cast this spell to request that creature, though you might get a different creature anyway (GM's choice).
When the creature appears, it is under no compulsion to behave a particular way. You can ask it to perform a service in exchange for payment, but it isn't obliged to do so. The requested task could range from simple (fly us across the chasm, or help us fight a battle) to complex (spy on our enemies, or protect us during our foray into the dungeon). You must be able to communicate with the creature to bargain for its services.
Payment can take a variety of forms. A Celestial might require a sizable donation of gold or magic items to an allied temple, while a Fiend might demand a living sacrifice or a gift of treasure. Some creatures might exchange their service for a quest undertaken by you.
A task that can be measured in minutes requires a payment worth 100 GP per minute. A task measured in hours requires 1,000 GP per hour. And a task measured in days (up to 10 days) requires 10,000 GP per day. The GM can adjust these payments based on the circumstances under which you cast the spell. If the task is aligned with the creature's ethos, the payment might be halved or even waived. Nonhazardous tasks typically require only half the suggested payment, while especially dangerous tasks might require a greater gift. Creatures rarely accept tasks that seem suicidal.
After the creature completes the task, or when the agreed-upon duration of service expires, the creature returns to its home plane after reporting back to you if possible. If you are unable to agree on a price for the creature's service, the creature immediately returns to its home plane.

### Planar Binding
*Level 5 Abjuration (Bard, Cleric, Druid, Warlock, Wizard)*

**Casting Time:** 1 hour
**Range:** 60 feet
**Components:** V, S, M (a jewel worth 1,000+ GP, which the spell consumes)
**Duration:** 24 hours

***
152 | System Reference Document 5.2.1
***

### Page 16

You attempt to bind a Celestial, an Elemental, a Fey, or a Fiend to your service. The creature must be within range for the entire casting of the spell. (Typically, the creature is first summoned into the center of the inverted version of the *Magic Circle* spell to trap it while this spell is cast.) At the completion of the casting, the target must succeed on a Charisma saving throw or be bound to serve you for the duration. If the creature was summoned or created by another spell, that spell's duration is extended to match the duration of this spell.
A bound creature must follow your commands to the best of its ability. You might command the creature to accompany you on an adventure, to guard a location, or to deliver a message. If the creature is Hostile, it strives to twist your commands to achieve its own objectives. If the creature carries out your commands completely before the spell ends, it travels to you to report this fact if you are on the same plane of existence. If you are on a different plane, it returns to the place where you bound it and remains there until the spell ends.
***Using a Higher-Level Spell Slot.*** The duration increases with a spell slot of level 6 (10 days), 7 (30 days), 8 (180 days), and 9 (366 days).

### Plane Shift
*Level 7 Conjuration (Cleric, Druid, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** Touch
**Components:** V, S, M (a forked, metal rod worth 250+ GP and attuned to a plane of existence)
**Duration:** Instantaneous

You and up to eight willing creatures who link hands in a circle are transported to a different plane of existence. You can specify a target destination in general terms, such as a specific city on the Elemental Plane of Fire or palace on the second level of the Nine Hells, and you appear in or near that destination, as determined by the GM.
Alternatively, if you know the sigil sequence of a teleportation circle on another plane of existence, this spell can take you to that circle. If the teleportation circle is too small to hold all the creatures you transported, they appear in the closest unoccupied spaces next to the circle.

### Plant Growth
*Level 3 Transmutation (Bard, Druid, Ranger)*

**Casting Time:** Action (Overgrowth) or 8 hours (Enrichment)
**Range:** 150 feet
**Components:** V, S
**Duration:** Instantaneous

This spell channels vitality into plants. The casting time you use determines whether the spell has the Overgrowth or the Enrichment effect below.
**Overgrowth.** Choose a point within range. All normal plants in a 100-foot-radius Sphere centered on that point become thick and overgrown. A creature moving through that area must spend 4 feet of movement for every 1 foot it moves. You can exclude one or more areas of any size within the spell's area from being affected.
**Enrichment.** All plants in a half-mile radius centered on a point within range become enriched for 365 days. The plants yield twice the normal amount of food when harvested. They can benefit from only one *Plant Growth* per year.

### Poison Spray
*Necromancy Cantrip (Druid, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

You spray toxic mist at a creature within range. Make a ranged spell attack against the target. On a hit, the target takes 1d12 Poison damage.
***Cantrip Upgrade.*** The damage increases by 1d12 when you reach levels 5 (2d12), 11 (3d12), and 17 (4d12).

### Polymorph
*Level 4 Transmutation (Bard, Druid, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V, S, M (a caterpillar cocoon)
**Duration:** Concentration, up to 1 hour

You attempt to transform a creature that you can see within range into a Beast. The target must succeed on a Wisdom saving throw or shape-shift into a Beast form for the duration. That form can be any Beast you choose that has a Challenge Rating equal to or less than the target's (or the target's level if it doesn't have a Challenge Rating). The target's game statistics are replaced by the stat block of the chosen Beast, but the target retains its alignment, personality, creature type, Hit Points, and Hit Point Dice. See the "Animals" section of "Monsters" for a sample of Beast stat blocks.
The target gains a number of Temporary Hit Points equal to the Hit Points of the Beast form. These Temporary Hit Points vanish if any remain when the spell ends. The spell ends early on the target if it has no Temporary Hit Points left.
The target is limited in the actions it can perform by the anatomy of its new form, and it can't speak or cast spells.

***
153 | System Reference Document 5.2.1
***

### Page 17

The target's gear melds into the new form. The creature can't use or otherwise benefit from any of that equipment.

### Power Word Heal
*Level 9 Enchantment (Bard, Cleric)*

**Casting Time:** Action
**Range:** 60 feet
**Component:** V
**Duration:** Instantaneous

A wave of healing energy washes over one creature you can see within range. The target regains all its Hit Points. If the creature has the Charmed, Frightened, Paralyzed, Poisoned, or Stunned condition, the condition ends. If the creature has the Prone condition, it can use its Reaction to stand up.

### Power Word Kill
*Level 9 Enchantment (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Component:** V
**Duration:** Instantaneous

You compel one creature you can see within range to die. If the target has 100 Hit Points or fewer, it dies. Otherwise, it takes 12d12 Psychic damage.

### Power Word Stun
*Level 8 Enchantment (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

You overwhelm the mind of one creature you can see within range. If the target has 150 Hit Points or fewer, it has the Stunned condition. Otherwise, its Speed is 0 until the start of your next turn.
The Stunned target makes a Constitution saving throw at the end of each of its turns, ending the condition on itself on a success.

### Prayer of Healing
*Level 2 Abjuration (Cleric, Paladin)*

**Casting Time:** 10 minutes
**Range:** 30 feet
**Components:** V
**Duration:** Instantaneous

Up to five creatures of your choice who remain within range for the spell's entire casting gain the benefits of a Short Rest and also regain 2d8 Hit Points. A creature can't be affected by this spell again until that creature finishes a Long Rest.
***Using a Higher-Level Spell Slot.*** The healing increases by 1d8 for each spell slot level above 2.

### Prestidigitation
*Transmutation Cantrip (Bard, Sorcerer, Warlock, Wizard)*

**Casting Time:** Action
**Range:** 10 feet
**Components:** V, S
**Duration:** Up to 1 hour

You create a magical effect within range. Choose the effect from the options below. If you cast this spell multiple times, you can have up to three of its non-instantaneous effects active at a time.
**Sensory Effect.** You create an instantaneous, harmless sensory effect, such as a shower of sparks, a puff of wind, faint musical notes, or an odd odor.
**Fire Play.** You instantaneously light or snuff out a candle, a torch, or a small campfire.
**Clean or Soil.** You instantaneously clean or soil an object no larger than 1 cubic foot.
**Minor Sensation.** You chill, warm, or flavor up to 1 cubic foot of nonliving material for 1 hour.
**Magic Mark.** You make a color, a small mark, or a symbol appear on an object or a surface for 1 hour.
**Minor Creation.** You create a nonmagical trinket or an illusory image that can fit in your hand. It lasts until the end of your next turn. A trinket can deal no damage and has no monetary worth.

### Prismatic Spray
*Level 7 Evocation (Bard, Sorcerer, Wizard)*

**Casting Time:** Action
**Range:** Self
**Components:** V, S
**Duration:** Instantaneous

Eight rays of light flash from you in a 60-foot Cone. Each creature in the Cone makes a Dexterity saving throw. For each target, roll 1d8 to determine which color ray affects it, consulting the Prismatic Rays table.

**Prismatic Rays**
| 1d8 | Ray |
|:---:|:----|
| 1 | **Red.** Failed Save: 12d6 Fire damage. Successful Save: Half as much damage. |
| 2 | **Orange.** Failed Save: 12d6 Acid damage. Successful Save: Half as much damage. |
| 3 | **Yellow.** Failed Save: 12d6 Lightning damage. Successful Save: Half as much damage. |
| 4 | **Green.** Failed Save: 12d6 Poison damage. Successful Save: Half as much damage. |

***
154 | System Reference Document 5.2.1