# Rules Glossary

## Glossary Conventions

The glossary uses the following conventions:

**Tags in Brackets.** Some entries have a tag in brackets after the entry's name, as in "Attack [Action]." A tag—Action, Area of Effect, Attitude, Condition, or Hazard—indicates that a rule is part of a family of rules. The tags also have glossary entries.

**"You."** The game's rules—in this glossary and elsewhere—often talk about something happening to you in the game world. That "you" refers to the creature or object that the rule applies to in a particular moment of play. For example, the "you" in the Prone condition is a creature that currently has that condition.

**"See Also.”** Some glossary entries include a *See also* section that points to other entries in the glossary, to other parts of this document, or both.

**No Obsolete Terms.** The glossary contains definitions of current rules terms only. If you're looking for a term from an earlier version of the fifth edition rules, consult the index.

**Abbreviations.** The abbreviations listed below appear in this glossary and elsewhere in the rules.

| Abbr. | Meaning | Abbr. | Meaning | Abbr. | Meaning |
| :--- | :--- | :--- | :--- | :--- | :--- |
| **AC** | Armor Class | **M** | Material component | **PB** | Proficiency Bonus |
| **C** | Concentration | **N** | Neutral | **PP** | Platinum Piece(s) |
| **CE** | Chaotic Evil | **NE** | Neutral Evil | **R** | Ritual |
| **CG** | Chaotic Good | **NG** | Neutral Good | **S** | Somatic component |
| **Cha.** | Charisma | **NPC** | Nonplayer character | **SP** | Silver Piece(s) |
| **CN** | Chaotic Neutral | **Str.** | Strength |
| **Con.** | Constitution | **PB** | Proficiency Bonus | **V** | Verbal component |
| **CP** | Copper Piece(s) | **PP** | Platinum Piece(s) | **Wis.** | Wisdom |
| **CR** | Challenge Rating | **R** | Ritual | **XP** | Experience Point(s) |
| **DC** | Difficulty Class | **S** | Somatic component | | |
| **Dex.** | Dexterity | **SP** | Silver Piece(s) | | |
| **EP** | Electrum Piece(s) | **Str.** | Strength | | |
| **GM** | Game Master | **V** | Verbal component | | |
| **GP** | Gold Piece(s) | **Wis.** | Wisdom | | |
| **HP** | Hit Point(s) | **XP** | Experience Point(s) | | |
| **Int.** | Intelligence | | | | |
| **LE** | Lawful Evil | | | | |
| **LG** | Lawful Good | | | | |
| **LN** | Lawful Neutral | | | | |

## Rules Definitions

Here are definitions of various rules.

### Ability Check
An ability check is a D20 Test that represents using one of the six abilities—or a specific skill associated with an ability—to overcome a challenge. See also "Playing the Game" ("D20 Tests" and "Proficiency").

### Ability Score and Modifier
A creature has six ability scores—Strength, Dexterity, Constitution, Intelligence, Wisdom, and Charisma—each of which has a corresponding modifier. Add the modifier when you make a D20 Test with the corresponding ability or when a rule asks you to do so. See also "Playing the Game" ("The Six Abilities").

### Action
On your turn, you can take one action. Choose which action to take from those below or from the special actions provided by your features. See also “Playing the Game" ("Actions”). These actions are defined elsewhere in this glossary:

| | | | |
| :--- | :--- | :--- | :--- |
| Attack | Dodge | Influence | Search |
| Dash | Help | Magic | Study |
| Disengage | Hide | Ready | Utilize |

### Advantage
If you have Advantage on a D20 Test, roll two d20s, and use the higher roll. A roll can't be affected by more than one Advantage, and Advantage and Disadvantage on the same roll cancel each other. See also "Playing the Game” (“D20 Tests").

### Adventure
An adventure is a series of encounters. A story emerges through playing them. See also "Encounter."

### Alignment
A creature's alignment broadly describes its ethical attitudes and ideals. Alignment is a combination of two factors: one identifies morality (good, evil, or neutral), and the other describes attitudes toward order (lawful, chaotic, or neutral). These factors allow for nine possible combinations, such as Lawful Good and Neutral Evil. See also "Character Creation" ("Create Your Character").

### Ally
A creature is your ally if it is a member of your adventuring party, your friend, on your side in combat, or a creature that the rules or the GM designates as your ally.

### Area of Effect
The descriptions of many spells and other features specify that they have an area of effect, which typically has one of six shapes. These shapes are defined elsewhere in this glossary:

| | |
| :--- | :--- |
| Cone | Cylinder |
| Cube | Emanation |
| Line | Sphere |

An area of effect has a point of origin, a location from which the effect's energy erupts. The rules for each shape specify how to position its point of origin. If all straight lines extending from the point of origin to a location in the area of effect are blocked, that location isn't included in the area of effect. To block a line, an obstruction must provide Total Cover. See also "Cover."

If the creator of an area of effect places it at an unseen point and an obstruction—such as a wall—is between the creator and that point, the point of origin comes into being on the near side of the obstruction.

### Armor Class
An Armor Class (AC) is the target number for an attack roll. AC represents how difficult it is to hit a target.

Your base AC calculation is 10 plus your Dexterity modifier. If a rule gives you another base AC calculation, you choose which calculation to use; you can't use more than one. See also "Attack Roll."

### Armor Training
Armor training allows you to use armor of a certain category without the following drawbacks. If you wear Light, Medium, or Heavy armor and lack training with it, you have Disadvantage on any D20 Test that involves Strength or Dexterity, and you can't cast spells. If you use a Shield and lack training with it, you don't gain its AC bonus. See also "Disadvantage" and "Equipment” (“Armor").

### Attack [Action]
When you take the Attack action, you can make one attack roll with a weapon or an Unarmed Strike.

**Equipping and Unequipping Weapons.** You can either equip or unequip one weapon when you make an attack as part of this action. You do so either before or after the attack. If you equip a weapon before an attack, you don't need to use it for that attack. Equipping a weapon includes drawing it from a sheath or picking it up. Unequipping a weapon includes sheathing, stowing, or dropping it.

**Moving between Attacks.** If you move on your turn and have a feature, such as Extra Attack, that gives you more than one attack as part of the Attack action, you can use some or all of that movement to move between those attacks.

### Attack Roll
An attack roll is a D20 Test that represents making an attack with a weapon, an Unarmed Strike, or a spell. See also "Playing the Game” (“D20 Tests").

### Attitude
A monster has a starting attitude toward a player character: Friendly, Hostile, or Indifferent. See also "Friendly," "Hostile,” “Indifferent," and "Influence.”

### Attunement
Some magic items require a creature to form a bond—called Attunement—with them before the creature can use an item's magical properties. A creature can have Attunement with no more than three magic items at a time. See also "Equipment" ("Magic Items").

### Blinded [Condition]
While you have the Blinded condition, you experience the following effects.

**Can't See.** You can't see and automatically fail any ability check that requires sight.

**Attacks Affected.** Attack rolls against you have Advantage, and your attack rolls have Disadvantage.

### Blindsight
If you have Blindsight, you can see within a specific range without relying on physical sight. Within that range, you can see anything that isn't behind Total Cover even if you have the Blinded condition or are in Darkness. Moreover, in that range, you can see something that has the Invisible condition.

### Bloodied
A creature is Bloodied while it has half its Hit Points or fewer remaining.

### Bonus Action
A Bonus Action is a special action that you can take on the same turn that you take an action. You can't take more than one Bonus Action on a turn, and you have a Bonus Action to take only if a rule explicitly says so. See also "Playing the Game" ("Actions").

### Breaking Objects
Objects can be harmed by attacks and by some spells, using the rules below. If an object is exceedingly fragile, the GM may allow a creature to break it automatically with the Attack or Utilize action.

**Armor Class.** The Object Armor Class table suggests ACs for various substances.

| AC | Substance | AC | Substance |
| :--- | :--- | :--- | :--- |
| 11 | Cloth, paper, rope | 19 | Iron, steel |
| 13 | Crystal, glass, ice | 21 | Mithral |
| 15 | Wood | 23 | Adamantine |
| 17 | Stone | | |

**Hit Points.** An object is destroyed when it has 0 Hit Points. The Object Hit Points table suggests Hit Points for fragile and resilient objects that are Large or smaller. To track Hit Points for a Huge or Gargantuan object, divide it into Large or smaller sections, and track each section's Hit Points separately. The GM determines whether destroying part of an object causes the whole thing to collapse.

**Object Hit Points**
| Size | Fragile | Resilient |
| :--- | :--- | :--- |
| Tiny (bottle, lock) | 2 (1d4) | 5 (2d4) |
| Small (chest, lute) | 3 (1d6) | 10 (3d6) |
| Medium (barrel, chandelier) | 4 (1d8) | 18 (4d8) |
| Large (cart, dining table) | 5 (1d10) | 27 (5d10) |

**Damage Types and Objects.** Objects have Immunity to Poison and Psychic damage. The GM might decide that some damage types are more or less effective against an object. For example, Bludgeoning damage works well for smashing things but not for cutting. Paper or cloth objects might have Vulnerability to Fire damage.

**Damage Threshold.** Big objects, such as castle walls, often have extra resilience represented by a damage threshold. See also "Damage Threshold."

**No Ability Scores.** An object lacks ability scores unless a rule assigns scores to the object. Without ability scores, an object can't make ability checks, and it fails all saving throws.

### Bright Light
Bright Light is normal illumination. See also "Playing the Game" ("Exploration").

### Burning [Hazard]
A burning creature or object takes 1d4 Fire damage at the start of each of its turns. As an action, you can extinguish fire on yourself by giving yourself the Prone condition and rolling on the ground. The fire also goes out if it is doused, submerged, or suffocated.

### Burrow Speed
A creature that has a Burrow Speed can use that speed to move through sand, earth, mud, or ice. The creature can't burrow through solid rock unless the creature has a trait that allows it to do so. See also "Speed."

### Campaign
A campaign is a series of adventures. See also "Adventure."

### Cantrip
A cantrip is a level 0 spell, which is cast without a spell slot. See also "Spells."

### Carrying Capacity
Your size and Strength score determine the maximum weight in pounds that you can carry, as shown in the Carrying Capacity table. The table also shows the maximum weight you can drag, lift, or push.

While dragging, lifting, or pushing weight in excess of the maximum weight you can carry, your Speed can be no more than 5 feet.

**Carrying Capacity**
| Creature Size | Carry | Drag/Lift/Push |
| :--- | :--- | :--- |
| Tiny | Str. × 7.5 lb. | Str. × 15 lb. |
| Small/Medium | Str. × 15 lb. | Str. × 30 lb. |
| Large | Str. × 30 lb. | Str. × 60 lb. |
| Huge | Str. × 60 lb. | Str. × 120 lb. |
| Gargantuan | Str. × 120 lb. | Str. × 240 lb. |

### Challenge Rating
Challenge Rating (CR) summarizes the threat a monster poses to a group of four player characters. Compare a monster's CR to the characters' level. If the CR is higher, the monster is likely a danger. If the CR is lower, the monster likely poses little threat. But circumstances and the number of player characters can significantly alter how threatening a monster is in actual play. "Gameplay Toolbox” (“Combat Encounters") provides guidance to the GM on using CR while planning potential combat encounters. See also "Stat Block."

### Character Sheet
A character sheet is a paper or digital record that you use to track your character's information. See also "Character Creation."

### Charmed [Condition]
While you have the Charmed condition, you experience the following effects.

**Can't Harm the Charmer.** You can't attack the charmer or target the charmer with damaging abilities or magical effects.

**Social Advantage.** The charmer has Advantage on any ability check to interact with you socially.

### Climbing
While you're climbing, each foot of movement costs 1 extra foot (2 extra feet in Difficult Terrain). You ignore this extra cost if you have a Climb Speed and use it to climb.

At the GM's option, climbing a slippery surface or one with few handholds might require a successful DC 15 Strength (Athletics) check.

### Climb Speed
A Climb Speed can be used in place of Speed to traverse a vertical surface without expending the extra movement normally associated with climbing. See also "Climbing" and "Speed."

### Concentration
Some spells and other effects require Concentration to remain active, as specified in their descriptions. If the effect's creator loses Concentration, the effect ends. If the effect has a maximum duration, the effect's description specifies how long the creator can concentrate on it: up to 1 minute, 1 hour, or some other duration. The creator can end Concentration at any time (no action required). The following factors break Concentration.

**Another Concentration Effect.** You lose Concentration on an effect the moment you start casting a spell that requires Concentration or activate another effect that requires Concentration.

**Damage.** If you take damage, you must succeed on a Constitution saving throw to maintain Concentration. The DC equals 10 or half the damage taken (round down), whichever number is higher, up to a maximum DC of 30.

**Incapacitated or Dead.** Your Concentration ends if you have the Incapacitated condition or you die.

### Condition
A condition is a temporary game state. The definition of a condition says how it affects its recipient, and various rules define how to end a condition. This glossary defines these conditions:

| | | |
| :--- | :--- | :--- |
| Blinded | Grappled | Poisoned |
| Charmed | Incapacitated | Prone |
| Deafened | Invisible | Restrained |
| Exhaustion | Paralyzed | Stunned |
| Frightened | Petrified | Unconscious |

A condition doesn't stack with itself; a recipient either has a condition or doesn't. The Exhaustion condition is an exception to that rule.

### Cone [Area of Effect]
A Cone is an area of effect that extends in straight lines from a point of origin in a direction its creator chooses. A Cone's width at any point along its length is equal to that point's distance from the point of origin. For example, a Cone is 15 feet wide at a point along its length that is 15 feet from the point of origin. The effect that creates a Cone specifies its maximum length.
A Cone's point of origin isn't included in the area of effect unless its creator decides otherwise.

### Cover
Cover provides a degree of protection to a target behind it. There are three degrees of cover, each of which provides a different benefit to a target: Half Cover (+2 bonus to AC and Dexterity saving throws), Three-Quarters Cover (+5 bonus to AC and Dexterity saving throws), and Total Cover (can't be targeted directly). If behind more than one degree of cover, a target benefits only from the most protective degree. See also "Playing the Game” (“Combat”).

### Crawling
While you're crawling, each foot of movement costs 1 extra foot (2 extra feet in Difficult Terrain). See also "Speed."

### Creature
Any being in the game, including a player's character, is a creature. See also "Creature Type."

### Creature Type
Every creature, including every player character, has a tag in the rules that identifies the type of creature it is. Most player characters are of the Humanoid type. These are the game's creature types:

| | | |
| :--- | :--- | :--- |
| Aberration | Elemental | Monstrosity |
| Beast | Fey | Ooze |
| Celestial | Fiend | Plant |
| Construct | Giant | Undead |
| Dragon | Humanoid | |

The types don't have rules themselves, but some rules in the game affect creatures of certain types in different ways.

### Critical Hit
If you roll a 20 on the d20 for an attack roll, you score a Critical Hit, and the attack hits regardless of any modifiers or the target's AC. A Critical Hit lets you roll extra dice for the attack's damage against the target. Roll all of the attack's damage dice twice and add them together. Then add any relevant modifiers. See also “Playing the Game” (“Damage and Healing").

### Cube [Area of Effect]
A Cube is an area of effect that extends in straight lines from a point of origin located anywhere on a face of the Cube. The effect that creates a Cube specifies its size, which is the length of each side.
A Cube's point of origin isn't included in the area of effect unless its creator decides otherwise.

### Curses
Some game effects curse a creature or an object. The effect that confers a curse defines what the curse does. Curses can be removed by the *Remove Curse* and *Greater Restoration* spells or other magic that explicitly ends curses.

### Cylinder [Area of Effect]
A Cylinder is an area of effect that extends in straight lines from a point of origin located at the center of the circular top or bottom of the Cylinder. The effect that creates a Cylinder specifies the radius of the Cylinder's base and the Cylinder's height.
A Cylinder's point of origin is included in the area of effect.

### D20 Test
D20 Tests encompass the three main d20 rolls of the game: ability checks, attack rolls, and saving throws. If something in the game affects D20 Tests, it affects all three of these rolls. The GM determines whether a D20 Test is warranted in a given circumstance. See also "Playing the Game" ("D20 Tests").

### Damage
Damage represents harm that causes a creature or an object to lose Hit Points.

### Damage Roll
A damage roll is a die roll, adjusted by any applicable modifiers, that deals damage to a target. See also "Playing the Game" ("Damage and Healing”).

### Damage Threshold
A creature or an object that has a damage threshold has Immunity to all damage unless it takes an amount of damage from a single attack or effect equal to or greater than its damage threshold, in which case it takes that entire instance of damage. Any damage that fails to meet or exceed the damage threshold is superficial and doesn't reduce Hit Points. For example, if an object has a damage threshold of 10, the object takes no damage if 9 damage is dealt to it, since that damage fails to exceed the threshold. If the same object is dealt 11 damage, it takes all of that damage.

### Damage Types
Attacks and other harmful effects deal different types of damage. Damage types have no rules of their own, but other rules, such as Resistance, rely on the types. The Damage Types table offers examples to help a GM assign a type to a new effect.

| Type | Examples |
| :--- | :--- |
| **Damage Types** | |
| Acid | Corrosive liquids, digestive enzymes |
| Bludgeoning | Blunt objects, constriction, falling |
| Cold | Freezing water, icy blasts |
| Fire | Flames, unbearable heat |
| Force | Pure magical energy |
| Lightning | Electricity |
| Necrotic | Life-draining energy |
| Piercing | Fangs, puncturing objects |
| Poison | Toxic gas, venom |
| Psychic | Mind-rending energy |
| Radiant | Holy energy, searing radiation |
| Slashing | Claws, cutting objects |
| Thunder | Concussive sound |

### Darkness
An area of Darkness is Heavily Obscured. See also "Heavily Obscured" and "Playing the Game" ("Exploration").

### Darkvision
If you have Darkvision, you can see in Dim Light within a specified range as if it were Bright Light and in Darkness within that range as if it were Dim Light. You discern colors in that Darkness only as shades of gray. See also "Playing the Game" ("Exploration").

### Dash [Action]
When you take the Dash action, you gain extra movement for the current turn. The increase equals your Speed after applying any modifiers. With a Speed of 30 feet, for example, you can move up to 60 feet on your turn if you Dash. If your Speed of 30 feet is reduced to 15 feet, you can move up to 30 feet this turn if you Dash.

If you have a special speed, such as a Fly Speed or Swim Speed, you can use that speed instead of your Speed when you take this action. You choose which speed to use each time you take it. See also "Speed."

### Dead
A dead creature has no Hit Points and can't regain them unless it is first revived by magic such as the *Raise Dead* or *Revivify* spell. When such a spell is cast, the spirit knows who is casting it and can refuse. The spirit of a dead creature has left the body and departed for the Outer Planes, and reviving the creature requires calling the spirit back.

If the creature returns to life, the revival effect determines the creature's current Hit Points. Unless otherwise stated, the creature returns to life with any conditions, magical contagions, or curses that were affecting it at death if the durations of those effects are still ongoing. If the creature died with any Exhaustion levels, it returns with 1 fewer level. If the creature had Attunement to one or more magic items, it is no longer attuned to them.

### Deafened [Condition]
While you have the Deafened condition, you experience the following effect.

**Can't Hear.** You can't hear and automatically fail any ability check that requires hearing.

### Death Saving Throw
A player character must make a Death Saving Throw (also called a Death Save) if they start their turn with 0 Hit Points. See also "Playing the Game" ("Damage and Healing").

### Dehydration [Hazard]
A creature requires an amount of water per day based on its size, as shown in the Water Needs per Day table. A creature that drinks less than half the required water for a day gains 1 Exhaustion level at the day's end. Exhaustion caused by dehydration can't be removed until the creature drinks the full amount of water required for a day. See also "Exhaustion."

**Water Needs per Day**
| Size | Water | Size | Water |
| :--- | :--- | :--- | :--- |
| Tiny | 1/4 gallon | Large | 4 gallons |
| Small | 1 gallon | Huge | 16 gallons |
| Medium | 1 gallon | Gargantuan | 64 gallons |

### Difficult Terrain
If a space is Difficult Terrain, every foot of movement in that space costs 1 extra foot. For example, moving 5 feet through Difficult Terrain costs 10 feet of movement. Difficult Terrain isn't cumulative; either a space is Difficult Terrain or it isn't.

A space is Difficult Terrain if the space contains any of the following or something similar:

*   A creature that isn't Tiny or your ally
*   Furniture that is sized for creatures of your size or larger
*   Heavy snow, ice, rubble, or undergrowth
*   Liquid that's between shin- and waist-deep
*   A narrow opening sized for a creature one size smaller than you
*   A slope of 20 degrees or more

### Difficulty Class
A Difficulty Class (DC) is the target number for an ability check or a saving throw. See also "Playing the Game" ("D20 Tests").

### Dim Light
An area with Dim Light is Lightly Obscured. See also "Lightly Obscured" and "Playing the Game" ("Exploration”).

### Disadvantage
If you have Disadvantage on a D20 Test, roll two d20s and use the lower roll. A roll can't be affected by more than one Disadvantage, and Advantage and Disadvantage on the same roll cancel each other. See also "Playing the Game" ("D20 Tests").

### Disengage [Action]
If you take the Disengage action, your movement doesn't provoke Opportunity Attacks for the rest of the current turn.

### Dodge [Action]
If you take the Dodge action, you gain the following benefits: until the start of your next turn, any attack roll made against you has Disadvantage if you can see the attacker, and you make Dexterity saving throws with Advantage.

You lose these benefits if you have the Incapacitated condition or if your Speed is 0.

### Emanation [Area of Effect]
An Emanation is an area of effect that extends in straight lines from a creature or an object in all directions. The effect that creates an Emanation specifies the distance it extends.

An Emanation moves with the creature or object that is its origin unless it is an instantaneous or a stationary effect.

An Emanation's origin (creature or object) isn't included in the area of effect unless its creator decides otherwise.

### Encounter
An encounter is a scene in an adventure that is part of at least one of the game's three pillars: social interaction, exploration, or combat. See also "Playing the Game" ("Social Interaction,” “Exploration," and "Combat").

### Enemy
A creature is your enemy if it fights against you in combat, actively works to harm you, or is designated as your enemy by the rules or GM.

### Exhaustion [Condition]
While you have the Exhaustion condition, you experience the following effects.

**Exhaustion Levels.** This condition is cumulative. Each time you receive it, you gain 1 Exhaustion level. You die if your Exhaustion level is 6.

**D20 Tests Affected.** When you make a D20 Test, the roll is reduced by 2 times your Exhaustion level.

**Speed Reduced.** Your Speed is reduced by a number of feet equal to 5 times your Exhaustion level.

**Removing Exhaustion Levels.** Finishing a Long Rest removes 1 of your Exhaustion levels. When your Exhaustion level reaches 0, the condition ends.

### Experience Points
As they overcome challenges and complete adventures, characters earn Experience Points (XP), which are awarded by the Game Master. When a character's XP total crosses certain thresholds, the character's level increases. See also "Level Advancement."

### Expertise
Expertise is a feature that enhances your use of a skill proficiency. When you make an ability check with a skill proficiency in which you have Expertise, your Proficiency Bonus is doubled for that check unless the bonus is doubled by another feature.

If you gain Expertise, you gain it in one skill in which you have proficiency. You can't have Expertise in the same skill proficiency more than once. See also "Playing the Game" ("Proficiency").

### Falling [Hazard]
A creature that falls takes 1d6 Bludgeoning damage at the end of the fall for every 10 feet it fell, to a maximum of 20d6. When the creature lands, it has the Prone condition unless it avoids taking any damage from the fall.

A creature that falls into water or another liquid can use its Reaction to make a DC 15 Strength (Athletics) or Dexterity (Acrobatics) check to hit the surface head or feet first. On a successful check, any damage resulting from the fall is halved.

### Flying
A variety of effects allow a creature to fly. While flying, you fall if you have the Incapacitated or Prone condition or your Fly Speed is reduced to 0. You can stay aloft in those circumstances if you can hover. See also "Falling" and "Fly Speed."

### Fly Speed
A Fly Speed can be used to travel through the air. While you have a Fly Speed, you can stay aloft until you land, fall, or die. See also "Flying” and “Speed.”

### Friendly [Attitude]
A Friendly creature views you favorably. You have Advantage on an ability check to influence a Friendly creature. See also "Influence."

### Frightened [Condition]
While you have the Frightened condition, you experience the following effects.

**Ability Checks and Attacks Affected.** You have Disadvantage on ability checks and attack rolls while the source of fear is within line of sight.

**Can't Approach.** You can't willingly move closer to the source of fear.

### Grappled [Condition]
While you have the Grappled condition, you experience the following effects.

**Speed 0.** Your Speed is 0 and can't increase.

**Attacks Affected.** You have Disadvantage on attack rolls against any target other than the grappler.

**Movable.** The grappler can drag or carry you when it moves, but every foot of movement costs it 1 extra foot unless you are Tiny or two or more sizes smaller than it.

### Grappling
A creature can grapple another creature. Characters typically grapple by using an Unarmed Strike. Many monsters have special attacks that allow them to quickly grapple prey. However a grapple is initiated, it follows these rules. See also "Unarmed Strike" and "Grappled."

**Grappled Condition.** Successfully grappling a creature gives it the Grappled condition.

**One Grapple per Hand.** A creature must have a hand free to grapple another creature. Some stat blocks and game effects allow a creature to grapple using a tentacle, a maw, or another body part. Whatever part a grappler uses, it can grapple only one creature at a time with that part, and the grappler can't use that part to target another creature unless it ends the grapple.

**Ending a Grapple.** A Grappled creature can use its action to make a Strength (Athletics) or Dexterity (Acrobatics) check against the grapple's escape DC, ending the condition on itself on a success. The condition also ends if the grappler has the Incapacitated condition or if the distance between the Grappled target and the grappler exceeds the grapple's range. In addition, the grappler can release the target at any time (no action required).

### Hazard
A hazard is an environmental danger. See also "Burning," "Dehydration,” “Falling,” “Malnutrition,” and "Suffocation."

### Healing
Healing is how you regain Hit Points. See also "Playing the Game" ("Damage and Healing").

### Heavily Obscured
You have the Blinded condition while trying to see something in a Heavily Obscured space. See also "Blinded," "Darkness,” and “Playing the Game" ("Exploration").

### Help [Action]
When you take the Help action, you do one of the following.

**Assist an Ability Check.** Choose one of your skill or tool proficiencies and one ally who is near enough for you to assist verbally or physically when they make an ability check. That ally has Advantage on the next ability check they make with the chosen skill or tool. This benefit expires if the ally doesn't use it before the start of your next turn. The GM has final say on whether your assistance is possible.

**Assist an Attack Roll.** You momentarily distract an enemy within 5 feet of you, giving Advantage to the next attack roll by one of your allies against that enemy. This benefit expires at the start of your next turn.

### Heroic Inspiration
If you (a player character) have Heroic Inspiration, you can expend it to reroll any die immediately after rolling it, and you must use the new roll.

If you gain Heroic Inspiration but already have it, it's lost unless you give it to a player character who lacks it.

### Hide [Action]
With the Hide action, you try to hide yourself. To do so, you must succeed on a DC 15 Dexterity (Stealth) check while you're Heavily Obscured or behind Three-Quarters Cover or Total Cover, and you must be out of any enemy's line of sight; if you can see a creature, you can discern whether it can see you.

On a successful check, you have the Invisible condition while hidden. Make note of your check's total, which is the DC for a creature to find you with a Wisdom (Perception) check.

You stop being hidden immediately after any of the following occurs: you make a sound louder than a whisper, an enemy finds you, you make an attack roll, or you cast a spell with a Verbal component.

### High Jump
When you make a High Jump, you leap into the air a number of feet equal to 3 plus your Strength modifier (minimum of 0 feet) if you move at least 10 feet on foot immediately before the jump. When you make a standing High Jump, you can jump only half that distance. Either way, each foot of the jump costs a foot of movement.

You can extend your arms half your height above yourself during the jump. Thus, you can reach a distance equal to the height of the jump plus 1½ times your height.

### Hit Point Dice
Hit Point Dice, or Hit Dice for short, help determine a player character's Hit Point maximum, as explained in "Character Creation.” Most monsters also have Hit Dice. A creature can spend Hit Dice during a Short Rest to regain Hit Points. See also "Short Rest."

### Hit Points
Hit Points (HP) are a measure of how difficult it is to kill or destroy a creature or an object. Damage reduces Hit Points, and healing restores them. You can't have more Hit Points than your Hit Point maximum, and you can't have less than 0. See also "Breaking Objects” and “Playing the Game" ("Damage and Healing").

### Hostile [Attitude]
A Hostile creature views you unfavorably. You have Disadvantage on an ability check to influence a Hostile creature. See also "Influence."

### Hover
Some creatures can hover, as noted in their stat blocks, and some spells and other effects grant the ability to hover. Hovering while flying prevents you from falling in certain circumstances. See also "Flying."

### Illusions
Spells and other effects sometimes create magical illusions. Such an effect defines what the illusion does and which senses or mental faculties it deceives.

If an illusion manifests in space, the illusion is insubstantial and weightless, yet it seems to be affected by the environment as if the illusion were real unless the effect that created it specifies otherwise. For example, a visual illusion of a creature casts shadows and reflections, and wind appears to affect the illusory creature. Similarly, an audible illusion echoes in an echoey space.

### Immunity
If you have Immunity to a damage type or a condition, it doesn't affect you in any way.

### Improvised Weapons
An improvised weapon is an object wielded as a makeshift weapon, such as broken glass, a table leg, or a frying pan. A Simple or Martial weapon also counts as an improvised weapon if it's wielded in a way contrary to its design; if you use a Ranged weapon to make a melee attack or throw a Melee weapon that lacks the Thrown property, the weapon counts as an improvised weapon. An improvised weapon follows the rules below.

**Proficiency.** Don't add your Proficiency Bonus to attack rolls with an improvised weapon.

**Damage.** On a hit, the weapon deals 1d4 damage of a type the GM thinks is appropriate for the object.

**Range.** If you throw the weapon, it has a normal range of 20 feet and a long range of 60 feet.

**Weapon Equivalents.** If an improvised weapon resembles a Simple or Martial weapon, the GM may say it functions as that weapon and uses that weapon's rules. For example, the GM could treat a table leg as a Club.

### Incapacitated [Condition]
While you have the Incapacitated condition, you experience the following effects.

**Inactive.** You can't take any action, Bonus Action, or Reaction.

**No Concentration.** Your Concentration is broken.

**Speechless.** You can't speak.

**Surprised.** If you're Incapacitated when you roll Initiative, you have Disadvantage on the roll.

### Indifferent [Attitude]
An Indifferent creature has no desire to help or hinder you. Indifferent is the default attitude of a monster. See also "Influence."

### Influence [Action]
With the Influence action, you urge a monster to do something. Describe or roleplay how you're communicating with the monster. Are you trying to deceive, intimidate, amuse, or gently persuade? The GM then determines whether the monster feels willing, unwilling, or hesitant due to your interaction; this determination establishes whether an ability check is necessary, as explained below.

**Willing.** If your urging aligns with the monster's desires, no ability check is necessary; the monster fulfills your request in a way it prefers.

**Unwilling.** If your urging is repugnant to the monster or counter to its alignment, no ability check is necessary; it doesn't comply.

**Hesitant.** If you urge the monster to do something that it is hesitant to do, you must make an ability check, which is affected by the monster's attitude: Indifferent, Friendly, or Hostile, each of which is defined in this glossary. The Influence Checks table suggests which ability check to make based on how you're interacting with the monster. The GM chooses the check, which has a default DC equal to 15 or the monster's Intelligence score, whichever is higher. On a successful check, the monster does as urged. On a failed check, you must wait 24 hours (or a duration set by the GM) before urging it in the same way again.

**Influence Checks**
| Ability Check | Interaction |
| :--- | :--- |
| Charisma (Deception) | Deceiving a monster that understands you |
| Charisma (Intimidation) | Intimidating a monster |
| Charisma (Performance) | Amusing a monster |
| Charisma (Persuasion) | Persuading a monster that understands you |
| Wisdom (Animal Handling) | Gently coaxing a Beast or Monstrosity |

### Initiative
Initiative determines the order of turns during combat. The combat rules in "Playing the Game" explain how to roll Initiative.

Sometimes a GM might have combatants use their Initiative scores instead of rolling Initiative. Your Initiative score equals 10 plus your Dexterity modifier. If you have Advantage on Initiative rolls, increase your Initiative score by 5. If you have Disadvantage on those rolls, decrease that score by 5. See also "Playing the Game" ("Combat").

### Invisible [Condition]
While you have the Invisible condition, you experience the following effects.

**Surprise.** If you're Invisible when you roll Initiative, you have Advantage on the roll.

**Concealed.** You aren't affected by any effect that requires its target to be seen unless the effect's creator can somehow see you. Any equipment you are wearing or carrying is also concealed.

**Attacks Affected.** Attack rolls against you have Disadvantage, and your attack rolls have Advantage. If a creature can somehow see you, you don't gain this benefit against that creature.

### Jumping
When you jump, you make either a Long Jump (horizontal) or a High Jump (vertical). See also “Long Jump" and "High Jump."

### Knocking Out a Creature
When you would reduce a creature to 0 Hit Points with a melee attack, you can instead reduce the creature to 1 Hit Point. The creature then has the Unconscious condition and starts a Short Rest.

The creature remains Unconscious until it regains any Hit Points or until someone uses an action to administer first aid to it, which requires a successful DC 10 Wisdom (Medicine) check.

### Lightly Obscured
You have Disadvantage on Wisdom (Perception) checks to see something in a Lightly Obscured space. See also "Dim Light" and "Playing the Game" ("Exploration").

### Line [Area of Effect]
A Line is an area of effect that extends from a point of origin in a straight path along its length and covers an area defined by its width. The effect that creates a Line specifies its length and width.
A Line's point of origin isn't included in the area of effect unless its creator decides otherwise.

### Long Jump
When you make a Long Jump, you leap horizontally a number of feet up to your Strength score if you move at least 10 feet immediately before the jump. When you make a standing Long Jump, you can leap only half that distance. Either way, each foot you jump costs a foot of movement.

If you land in Difficult Terrain, you must succeed on a DC 10 Dexterity (Acrobatics) check or have the Prone condition.

This Long Jump rule assumes that the height of the jump doesn't matter, such as a jump across a stream or chasm. At your GM's option, you must succeed on a DC 10 Strength (Athletics) check to clear a low obstacle (no taller than a quarter of the jump's distance), such as a hedge or low wall. Otherwise, you hit the obstacle.

### Long Rest
A Long Rest is a period of extended downtime—at least 8 hours—available to any creature. During a Long Rest, you sleep for at least 6 hours and perform no more than 2 hours of light activity, such as reading, talking, eating, or standing watch.

During sleep, you have the Unconscious condition. After you finish a Long Rest, you must wait at least 16 hours before starting another one.

**Benefits of the Rest.** To start a Long Rest, you must have at least 1 Hit Point. When you finish the rest, you gain the following benefits:

**Regain All HP.** You regain all lost Hit Points and all spent Hit Point Dice. If your Hit Point maximum was reduced, it returns to normal.

**Ability Scores Restored.** If any of your ability scores were reduced, they return to normal.

**Exhaustion Reduced.** If you have the Exhaustion condition, its level decreases by 1.

**Special Feature.** Some features are recharged by a Long Rest. If you have such a feature, it recharges in the way specified in its description.

**Interrupting the Rest.** A Long Rest is stopped by the following interruptions:
* Rolling Initiative
* Casting a spell other than a cantrip
* Taking any damage
* 1 hour of walking or other physical exertion

If you rested at least 1 hour before the interruption, you gain the benefits of a Short Rest. See also "Short Rest."

You can resume a Long Rest immediately after an interruption. If you do so, the rest requires 1 additional hour per interruption to finish.

### Magic [Action]
When you take the Magic action, you cast a spell that has a casting time of an action or use a feature or magic item that requires a Magic action to be activated.
If you cast a spell that has a casting time of 1 minute or longer, you must take the Magic action on each turn of that casting, and you must maintain Concentration while you do so. If your Concentration is broken, the spell fails, but you don't expend a spell slot. See also "Concentration."

### Magical Effect
An effect is magical if it is created by a spell, a magic item, or a phenomenon that a rule labels as magical.

### Malnutrition [Hazard]
A creature needs an amount of food per day based on its size, as shown in the Food Needs per Day table. A creature that eats but consumes less than half the required food for a day must succeed on a DC 10 Constitution saving throw or gain 1 Exhaustion level at the day's end. A creature that eats nothing for 5 days automatically gains 1 Exhaustion level at the end of the fifth day as well as an additional level at the end of each subsequent day without food.

Exhaustion caused by malnutrition can't be removed until the creature eats the full amount of food required for a day. See also "Exhaustion."

**Food Needs per Day**
| Size | Food | Size | Food |
| :--- | :--- | :--- | :--- |
| Tiny | 1/4 pound | Large | 4 pounds |
| Small | 1 pound | Huge | 16 pounds |
| Medium | 1 pound | Gargantuan | 64 pounds |

### Monster
A monster is a creature controlled by the GM, even if the creature is benevolent. See also "Creature" and "NPC."

### Nonplayer Character
A nonplayer character (NPC) is a monster that has a personal name and a distinct personality. See also "Monster."

### Object
An object is a nonliving, distinct thing. Composite things, like buildings, comprise more than one object. See also "Breaking Objects."

### Occupied Space
A space is occupied if a creature is in it or if it is completely filled by objects.

### Opportunity Attacks
You can make an Opportunity Attack when a creature that you can see leaves your reach using its action, its Bonus Action, its Reaction, or one of its speeds. To make the Opportunity Attack, take a Reaction to make one melee attack with a weapon or an Unarmed Strike against the provoking creature. The attack occurs right before the creature leaves your reach. See also "Playing the Game" ("Combat").

### Paralyzed [Condition]
While you have the Paralyzed condition, you experience the following effects.

**Incapacitated.** You have the Incapacitated condition.

**Speed 0.** Your Speed is 0 and can't increase.

**Saving Throws Affected.** You automatically fail Strength and Dexterity saving throws.

**Attacks Affected.** Attack rolls against you have Advantage.

**Automatic Critical Hits.** Any attack roll that hits you is a Critical Hit if the attacker is within 5 feet of you.

### Passive Perception
Passive Perception is a score that reflects a creature's general awareness of its surroundings. The GM uses this score when determining whether a creature notices something without consciously making a Wisdom (Perception) check.

A creature's Passive Perception equals 10 plus the creature's Wisdom (Perception) check bonus. If the creature has Advantage on such checks, increase the score by 5. If the creature has Disadvantage on them, decrease the score by 5. For example, a level 1 character with a Wisdom of 15 and proficiency in Perception has a Passive Perception of 14 (10 + 2 + 2). If that character has Advantage on Wisdom (Perception) checks, the score becomes 19.

### Per Day
If a rule says you can use something a certain number of times per day, that means you must finish a Long Rest to use it again after you run out of uses.

### Petrified [Condition]
While you have the Petrified condition, you experience the following effects.

**Turned to Inanimate Substance.** You are transformed, along with any nonmagical objects you are wearing and carrying, into a solid inanimate substance (usually stone). Your weight increases by a factor of ten, and you cease aging.

**Incapacitated.** You have the Incapacitated condition.

**Speed 0.** Your Speed is 0 and can't increase.

**Attacks Affected.** Attack rolls against you have Advantage.

**Saving Throws Affected.** You automatically fail Strength and Dexterity saving throws.

**Resist Damage.** You have Resistance to all damage.

**Poison Immunity.** You have Immunity to the Poisoned condition.

### Player Character
A player character is a character controlled by a player. See also "Character Creation."

### Poisoned [Condition]
While you have the Poisoned condition, you experience the following effect.

**Ability Checks and Attacks Affected.** You have Disadvantage on attack rolls and ability checks.

### Possession
Some effects cause a creature to be possessed by another creature or entity. A possessing effect defines how the possession operates. Possession can be prevented by the *Protection from Evil and Good* spell and ended by the *Dispel Evil and Good* spell.

### Proficiency
If you have proficiency with something, you can add your Proficiency Bonus to any D20 Test you make using that thing. A creature might have proficiency in a skill or saving throw or with a weapon or tool. See also "Playing the Game” (“Proficiency”).

### Prone [Condition]
While you have the Prone condition, you experience the following effects.

**Restricted Movement.** Your only movement options are to crawl or to spend an amount of movement equal to half your Speed (round down) to right yourself and thereby end the condition. If your Speed is 0, you can't right yourself.

**Attacks Affected.** You have Disadvantage on attack rolls. An attack roll against you has Advantage if the attacker is within 5 feet of you. Otherwise, that attack roll has Disadvantage.

### Reach
A creature has a reach of 5 feet unless a rule says otherwise.

### Reaction
A Reaction is a special action taken in response to a trigger defined in the Reaction's description. You can take a Reaction on another creature's turn, and if you take it on your turn, you can do so even if you also take an action, a Bonus Action, or both. Once you take a Reaction, you can't take another one until the start of your next turn. The Opportunity Attack is a Reaction available to all creatures. See also "Opportunity Attacks" and "Playing the Game" ("Actions").

### Ready [Action]
You take the Ready action to wait for a particular circumstance before you act. To do so, you take this action on your turn, which lets you act by taking a Reaction before the start of your next turn.

First, you decide what perceivable circumstance will trigger your Reaction. Then, you choose the action you will take in response to that trigger, or you choose to move up to your Speed in response to it. Examples include "If the cultist steps on the trapdoor, I'll pull the lever that opens it," and "If the zombie steps next to me, I move away."

When the trigger occurs, you can either take your Reaction right after the trigger finishes or ignore the trigger.

When you Ready a spell, you cast it as normal (expending any resources used to cast it) but hold its energy, which you release with your Reaction when the trigger occurs. To be readied, a spell must have a casting time of an action, and holding on to the spell's magic requires Concentration, which you can maintain up to the start of your next turn. If your Concentration is broken, the spell dissipates without taking effect.

### Resistance
If you have Resistance to a damage type, damage of that type is halved against you (round down). Resistance is applied only once to an instance of damage. See also "Playing the Game" ("Damage and Healing").

### Restrained [Condition]
While you have the Restrained condition, you experience the following effects.

**Speed 0.** Your Speed is 0 and can't increase.

**Attacks Affected.** Attack rolls against you have Advantage, and your attack rolls have Disadvantage.

**Saving Throws Affected.** You have Disadvantage on Dexterity saving throws.

### Ritual
If you have a spell prepared that has the Ritual tag, you can cast that spell as a Ritual. The Ritual version of a spell takes 10 minutes longer to cast than normal. It also doesn't expend a spell slot, which means the ritual version of a spell can't be cast at a higher level. See also "Spells."

### Round Down
Whenever you divide or multiply a number in the game, round down if you end up with a fraction, even if the fraction is one-half or greater. Some rules make an exception and tell you to round up.

### Save
Save is another name for a saving throw. See also "Saving Throw."

### Saving Throw
A saving throw—also called a save—represents an attempt to avoid or resist a threat. You normally make a saving throw only when a rule requires you to do so, but you can decide to fail the save without rolling. The result of a save is detailed in the effect that allowed it. If a target is forced to make a save and lacks the ability score used by it, the target automatically fails. See also "Playing the Game" ("D20 Tests").

### Search [Action]
When you take the Search action, you make a Wisdom check to discern something that isn't obvious. The Search table suggests which skills are applicable when you take this action, depending on what you're trying to detect.

**Search**
| Skill | Thing to Detect |
| :--- | :--- |
| Insight | Creature's state of mind |
| Medicine | Creature's ailment or cause of death |
| Perception | Concealed creature or object |
| Survival | Tracks or food |

### Shape-Shifting
If an effect, such as Wild Shape or the *Polymorph* spell, lets you shape-shift, its description specifies what happens to you. Unless that description says otherwise, any ongoing effects on you—conditions, spells, curses, and the like—carry over from one form to the other. You revert to your true form if you die.

### Short Rest
A Short Rest is a 1-hour period of downtime, during which a creature does nothing more strenuous than reading, talking, eating, or standing watch. To start a Short Rest, you must have at least 1 Hit Point.

**Benefits of the Rest.** When you finish the rest, you gain the following benefits:

**Spend Hit Point Dice.** You can spend one or more of your Hit Point Dice to regain Hit Points. For each Hit Point Die you spend in this way, roll the die and add your Constitution modifier to it. You regain Hit Points equal to the total (minimum of 1 Hit Point). You can decide to spend an additional Hit Point Die after each roll.

**Special Feature.** Some features are recharged by a Short Rest. If you have such a feature, it recharges in the way specified in its description.

**Interrupting the Rest.** A Short Rest is stopped by the following interruptions:

* Rolling Initiative
* Casting a spell other than a cantrip
* Taking any damage

An interrupted Short Rest confers no benefits.

### Simultaneous Effects
If two or more things happen at the same time on a turn, the person at the game table—player or GM—whose turn it is decides the order in which those things happen. For example, if two effects occur at the start of a player character's turn, the player decides which of the effects happens first.

### Size
A creature or an object belongs to a size category: Tiny, Small, Medium, Large, Huge, or Gargantuan. A creature's size determines how much space the creature occupies in combat. An object's size affects its Hit Points. See also "Breaking Objects" and "Playing the Game" ("Combat").

### Skill
A skill is an area of specialization associated with an ability check. If you have proficiency in a skill, you can add your Proficiency Bonus when you make an ability check associated with that skill. See also "Playing the Game" ("Proficiency").

### Speed
A creature has a Speed, which is the distance in feet the creature can cover when it moves on its turn. See also "Climbing,” “Crawling,” “Flying,” “Jumping," "Swimming" and "Playing the Game" ("Combat").

**Special Speeds.** Some creatures have special speeds, such as a Burrow Speed, Climb Speed, Fly Speed, or Swim Speed, each of which is defined in this glossary. If you have more than one speed, choose which one to use when you move; you can switch between the speeds during your move. Whenever you switch, subtract the distance already moved from the new speed. The result determines how much farther you can move. If the result is 0 or less, you can't use the new speed during the current move. For example, if you have a Speed of 30 and a Fly Speed of 40, you could fly 10 feet, walk 10 feet, and leap into the air to fly 20 feet more.

**Changes to Your Speeds.** If an effect increases or decreases your Speed for a time, any special speed you have increases or decreases by an equal amount for the same duration. For example, if your Speed is reduced to 0 and you have a Climb Speed, your Climb Speed is also reduced to 0. Similarly, if your Speed is halved and you have a Fly Speed, your Fly Speed is also halved.

### Spell
A spell is a magical effect that has the characteristics described in "Spells."

### Spell Attack
A spell attack is an attack roll made as part of a spell or another magical effect. See also "Spells" ("Casting Spells").

### Spellcasting Focus
A Spellcasting Focus is an object that certain creatures can use in place of a spell's Material components if those materials aren't consumed by the spell and don't have a cost specified. Some classes allow its members to use certain types of Spellcasting Focuses. See also "Spells” (“Casting Spells").

### Sphere [Area of Effect]
A Sphere is an area of effect that extends in straight lines from a point of origin outward in all directions. The effect that creates a Sphere specifies the distance it extends as the radius of the Sphere.
A Sphere's point of origin is included in the Sphere's area of effect.

### Stable
A creature is Stable if it has 0 Hit Points but isn't required to make Death Saving Throws. See also "Playing the Game" ("Damage and Healing").

### Stat Block
A stat block contains the game statistics of a monster. Each stat block includes the following information presented after the monster's name.

**Size.** A monster is Tiny, Small, Medium, Large, Huge, or Gargantuan. See also “Size.”

**Creature Type.** This entry notes the family of beings a monster belongs to, along with any descriptive tags. See also "Creature Type."

**Alignment.** An alignment is suggested for the monster, with the GM determining its actual alignment. See also "Alignment."

**AC, Initiative, and HP.** These entries give the monster's Armor Class, Initiative, and Hit Points, which are detailed in “Playing the Game.” In parentheses after the Hit Points, the monster's Hit Point Dice are provided, along with the contribution of its Constitution, if any, to its Hit Points. Following the Initiative modifier is an Initiative score. Some creatures that are created by magic lack Hit Dice and Initiative information.

**Speed.** Here the monster's Speed is provided, along with any special speeds. See also "Burrow Speed," "Climb Speed," "Fly Speed," and "Swim Speed."

**Ability Scores.** A table provides the monster's ability scores, modifiers, and saving throw modifiers, all of which are detailed in "Playing the Game."

**Skills.** This entry lists the monster's skill proficiencies, if any. See also "Playing the Game" ("Proficiency").

**Resistances and Vulnerabilities.** These entries list the monster's Resistances and Vulnerabilities, if any. See also "Resistance" and "Vulnerability.”

**Immunities.** This section lists the monster's damage and condition Immunities, if any. See also "Immunity."

**Gear.** If the monster has any equipment that can be given away or retrieved, it's listed in this entry.

**Senses.** This entry lists the monster's special senses, such as Darkvision, and its Passive Perception. See also “Passive Perception."

**Languages.** This entry lists any languages the monster knows.

**CR.** Challenge Rating summarizes the threat a monster poses and is detailed in “Monsters." The Experience Points characters receive for defeating a monster and its Proficiency Bonus follow. Some creatures that are created by magic have no CR. See also "Challenge Rating" and "Experience Points."

**Traits.** The monster's traits, if any, are features that are active at all times or in certain situations.

**Actions.** The monster can take these actions in addition to those detailed in this glossary. See also "Playing the Game" ("Actions").

**Bonus Actions.** If the monster has Bonus Action options, they are listed in this section.

**Reactions.** If the monster can take special Reactions, those are listed in this section.

**Attack Notation.** The entry for a monster's attack starts by identifying whether the attack is a melee or a ranged attack and then provides the attack roll's bonus, its reach or range, and what happens on a hit. An attack is against one target unless its entry says otherwise.

**Saving Throw Effect Notation.** If an effect forces a saving throw, the effect's entry starts by identifying the kind of saving throw required and then provides the save's DC, a description of which creatures must make the save, and what happens on a failed or a successful save.

**Damage Notation.** A stat block usually provides both a static number and a die expression for each instance of damage. For example, an attack might deal 4 (1d4 + 2) damage on a hit. The GM determines whether you use the static number or the die expression in parentheses; you don't use both.

### Study [Action]
When you take the Study action, you make an Intelligence check to study your memory, a book, a clue, or another source of knowledge and call to mind an important piece of information about it.

The Areas of Knowledge table suggests which skills are applicable to various areas of knowledge.

**Areas of Knowledge**
| Skill | Areas |
| :--- | :--- |
| Arcana | Spells, magic items, eldritch symbols, magical traditions, planes of existence, and certain creatures (Aberrations, Constructs, Elementals, Fey, and Monstrosities) |
| History | Historic events and people, ancient civilizations, wars, and certain creatures (Giants and Humanoids) |
| Investigation | Traps, ciphers, riddles, and gadgetry |
| Nature | Terrain, flora, weather, and certain creatures (Beasts, Dragons, Oozes, and Plants) |
| Religion | Deities, religious hierarchies and rites, holy symbols, cults, and certain creatures (Celestials, Fiends, and Undead) |

### Stunned [Condition]
While you have the Stunned condition, you experience the following effects.

**Incapacitated.** You have the Incapacitated condition.

**Saving Throws Affected.** You automatically fail Strength and Dexterity saving throws.

**Attacks Affected.** Attack rolls against you have Advantage.

### Suffocation [Hazard]
A creature can hold its breath for a number of minutes equal to 1 plus its Constitution modifier (minimum of 30 seconds) before suffocation begins. When a creature runs out of breath or is choking, it gains 1 Exhaustion level at the end of each of its turns. When a creature can breathe again, it removes all levels of Exhaustion it gained from suffocating.

### Surprise
If a creature is caught unawares by the start of combat, that creature is surprised, which causes it to have Disadvantage on its Initiative roll. See also "Playing the Game" ("Combat").

### Swimming
While you're swimming, each foot of movement costs 1 extra foot (2 extra feet in Difficult Terrain). You ignore this extra cost if you have a Swim Speed and use it to swim. At the GM's option, moving any distance in rough water might require a successful DC 15 Strength (Athletics) check.

### Swim Speed
A Swim Speed can be used to swim without expending the extra movement normally associated with swimming. See also "Swimming" and "Speed."

### Target
A target is the creature or object targeted by an attack roll, forced to make a saving throw by an effect, or selected to receive the effects of a spell or another phenomenon.

### Telepathy
Telepathy is a magical ability that allows a creature to communicate mentally with another creature within a specified range. Unless a rule states otherwise, the contacted creature doesn't need to share a language with the telepath to understand this communication, but the contacted creature must be able to understand at least one language or be telepathic itself to understand.

A telepath doesn't need to see a contacted creature, and the telepath can start or end the telepathic contact at any time (no action required). Telepathic contact can't be initiated and is immediately broken if either the telepath or the other creature has the Incapacitated condition. Telepathic contact is also broken if the contacted creature is no longer within the telepathy's range or if the telepath contacts a different creature within range.

A creature without telepathy can receive telepathic messages but can't initiate a telepathic conversation. Once a telepathic conversation starts, the non-telepath can communicate mentally to the telepath until the telepathic connection ends.

### Teleportation
Teleportation is a special kind of magical transportation. If you teleport, you disappear and reappear elsewhere instantly, without moving through the intervening space. This transportation doesn't expend movement unless a rule tells you otherwise, and teleportation never provokes Opportunity Attacks.

When you teleport, all the equipment you're wearing and carrying teleports with you. If you're touching another creature when you teleport, that creature doesn't teleport with you unless the teleportation effect says otherwise.

If the destination space of your teleportation is occupied by another creature or blocked by a solid obstacle, you instead appear in the nearest unoccupied space of your choice.

The description of a teleportation effect tells you if you must see the teleportation's destination.

### Temporary Hit Points
Temporary Hit Points are granted by certain effects and act as a buffer against losing real Hit Points. See also "Playing the Game" ("Damage and Healing").

### Tremorsense
A creature with Tremorsense can pinpoint the location of creatures and moving objects within a specific range, provided that the creature with Tremorsense and anything it is detecting are both in contact with the same surface (such as the ground, a wall, or a ceiling) or the same liquid.

Tremorsense can't detect creatures or objects in the air, and it doesn't count as a form of sight.

### Truesight
If you have Truesight, your vision is enhanced within a specified range. Within that range, your vision pierces through the following:

**Darkness.** You can see in normal and magical Darkness.

**Invisibility.** You see creatures and objects that have the Invisible condition.

**Visual Illusions.** Visual illusions appear transparent to you, and you automatically succeed on saving throws against them.

**Transformations.** You discern the true form of any creature or object you see that has been transformed by magic.

**Ethereal Plane.** You see into the Ethereal Plane.

### Unarmed Strike
Instead of using a weapon to make a melee attack, you can use a punch, kick, headbutt, or similar forceful blow. In game terms, this is an Unarmed Strike—a melee attack that involves you using your body to damage, grapple, or shove a target within 5 feet of you.

Whenever you use your Unarmed Strike, choose one of the following options for its effect.

**Damage.** You make an attack roll against the target. Your bonus to the roll equals your Strength modifier plus your Proficiency Bonus. On a hit, the target takes Bludgeoning damage equal to 1 plus your Strength modifier.

**Grapple.** The target must succeed on a Strength or Dexterity saving throw (it chooses which), or it has the Grappled condition. The DC for the saving throw and any escape attempts equals 8 plus your Strength modifier and Proficiency Bonus. This grapple is possible only if the target is no more than one size larger than you and if you have a hand free to grab it. See also "Grappling."

**Shove.** The target must succeed on a Strength or Dexterity saving throw (it chooses which), or you either push it 5 feet away or cause it to have the Prone condition. The DC for the saving throw equals 8 plus your Strength modifier and Proficiency Bonus. This shove is possible only if the target is no more than one size larger than you.

### Unconscious [Condition]
While you have the Unconscious condition, you experience the following effects.

**Inert.** You have the Incapacitated and Prone conditions, and you drop whatever you're holding. When this condition ends, you remain Prone.

**Speed 0.** Your Speed is 0 and can't increase.

**Attacks Affected.** Attack rolls against you have Advantage.

**Saving Throws Affected.** You automatically fail Strength and Dexterity saving throws.

**Automatic Critical Hits.** Any attack roll that hits you is a Critical Hit if the attacker is within 5 feet of you.

**Unaware.** You're unaware of your surroundings.

### Unoccupied Space
A space is unoccupied if no creatures are in it and it isn't completely filled by objects.

### Utilize [Action]
You normally interact with an object while doing something else, such as when you draw a sword as part of the Attack action. When an object requires an action for its use, you take the Utilize action.

### Vulnerability
If you have Vulnerability to a damage type, damage of that type is doubled against you. Vulnerability is applied only once to an instance of damage. See also "Playing the Game" ("Damage and Healing”).

### Weapon
A weapon is an object that is in the Simple or Martial weapon category. See also "Equipment" ("Weapons").

### Weapon Attack
A weapon attack is an attack roll made with a weapon. See also "Weapon.”