# Gameplay Toolbox

## Travel Pace
A group of characters can travel overland at a Normal, Fast, or Slow pace, as described in "Playing the Game." During any journey stage, the predominant terrain determines the characters' maximum travel pace, as shown in the Maximum Pace column of the Travel Terrain table. Certain factors can affect a group's travel pace.

### Good Roads
The presence of a good road increases the group's maximum pace by one step (from Slow to Normal or from Normal to Fast).

### Slower Travelers
The group must move at a Slow pace if any group member's Speed is reduced to half or less of normal.

### Extended Travel
Characters can push themselves to travel for more than 8 hours per day, at the risk of tiring. At the end of each additional hour of travel beyond 8 hours, each character must succeed on a Constitution saving throw or gain 1 Exhaustion level. The DC is 10 plus 1 for each hour past 8 hours.

### Special Movement
If a party can travel at a high Speed for an extended time, as with a spell such as *Wind Walk* or a magic item such as a *Carpet of Flying*, translate the party's Speed into travel rates using these rules:

**Miles per hour** = Speed ÷ 10
**Miles per day (Normal pace)** = Miles per hour × number of hours traveled (typically 8)
**Fast pace** = Miles per day × 1⅓ (round down)
**Slow pace** = Miles per day × ⅔ (round down)

If the characters are flying or their special movement allows them to ignore Difficult Terrain, they can move at a Fast pace regardless of the terrain.

### Vehicles
Characters traveling in a vehicle use the vehicle's speed in miles per hour (as shown in "Equipment") to determine their rate of travel, and they don't choose a travel pace.

## Creating a Background
A character's background represents what the character did prior to becoming an adventurer. Creating a unique background or customizing an existing one can reflect the particular theme of your campaign or elements of your world. You can also create a background to help a player craft the story they have in mind for their character.

This section describes, step by step, how you can create backgrounds tailored for your world and the heroes in it.

### 1: Choose Abilities
Choose three abilities that seem appropriate for the background:

**Strength or Dexterity.** These abilities are ideal for a background involving physical exertion.
**Constitution.** This ability is ideal for a background that involves endurance or long hours of activity.

| Travel Terrain | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| **Terrain** | **Maximum Pace** | **Encounter Distance** | **Foraging DC** | **Navigation DC** | **Search DC** |
| Arctic | Fast* | 6d6 × 10 feet | 20 | 10 | 10 |
| Coastal | Normal | 2d10 × 10 feet | 10 | 5 | 15 |
| Desert | Normal | 6d6 × 10 feet | 20 | 10 | 10 |
| Forest | Normal | 2d8 × 10 feet | 10 | 15 | 15 |
| Grassland | Fast | 6d6 × 10 feet | 15 | 5 | 15 |
| Hill | Normal | 2d10 × 10 feet | 15 | 10 | 15 |
| Mountain | Slow | 4d10 × 10 feet | 20 | 15 | 20 |
| Swamp | Slow | 2d8 × 10 feet | 10 | 15 | 20 |
| Underdark | Normal | 2d6 × 10 feet | 20 | 10 | 20 |
| Urban | Normal | 2d6 × 10 feet | 20 | 15 | 15 |
| Waterborne | Special† | 6d6 × 10 feet | 15 | 10 | 15 |

*Appropriate equipment (such as skis) is necessary to keep up a Fast pace in Arctic terrain.
†Characters’ rate of travel while waterborne depends on the vehicle carrying them; see “Vehicles.”

---
192 System Reference Document 5.2.1
***
**Intelligence or Wisdom.** One or both abilities are ideal for a background that focuses on cerebral or spiritual matters.
**Charisma.** This ability is ideal for a background that involves performance or social interaction.

### 2: Choose a Feat
Choose one feat from the Origin category. See "Origin Feats" for examples of Origin feats.

### 3: Choose Skill Proficiencies
Choose two skills appropriate for the background. There needn't be a relationship between the skill proficiencies a background grants and the ability scores it increases.

### 4: Choose a Tool Proficiency
Choose one tool used in the practice of the background or often associated with it.

### 5: Choose Equipment
Assemble a package of equipment worth 50 GP (including unspent gold). Don't include Martial weapons or armor, as characters get them from their class choices.

## Curses and Magical Contagions
A curse is a magical burden that lasts for a specified time or until it is ended by some means. A magical contagion is an adverse effect of magical origin that is contagious by definition.
The following sections discuss curses and magical contagions in detail.

### Curses
A curse typically takes one of the forms detailed below.

#### Bestow Curse
The simplest curses are created by the *Bestow Curse* spell. The effects of such curses are limited and can be ended by the *Remove Curse* spell.
*Bestow Curse* provides useful benchmarks for gauging the potency of other curses. A curse that lasts for 1 minute equates to a level 3 spell, while one that lasts until dispelled equates to a level 9 spell.

#### Cursed Creatures
Some monsters are associated with curses, whether as part of their origins or due to their ability to spread curses—werewolves being a prime example. You decide how a spell like *Remove Curse* affects a creature with accursed origins. For example, you might decide that a mummy was created through a curse and it can be destroyed permanently only by casting *Remove Curse* on its corpse.

#### Cursed Magic Items
Cursed magic items are created deliberately or originate as the result of supernatural events. Such items are detailed in “Magic Items.”

#### Narrative Curses
A curse might manifest during an adventure when a creature's violation of a taboo warrants supernatural punishment, such as breaking a vow, defiling a tomb, or murdering an innocent. Such a curse can have any effects you design, or it might be a customized version of another type of curse discussed in this section.
A creature affected by such a curse should know why they're being punished and be able to learn how to end their curse, likely by symbolically righting the wrong they committed. How a spell like *Remove Curse* affects a curse that's part of your adventure is up to you—the spell might merely suppress the effects of the curse for a time. Regardless, narrative curses should feel like rare, potent magic rooted in the lore of your campaign.

#### Environmental Curses
Some locations are so suffused with evil that anyone who lingers there is burdened with a curse. Demonic Possession is one example of an environmental curse.
**Demonic Possession.** Demonic Possession arises from the chaos and evil of the Abyss and commonly besets creatures that interact with demonic objects or linger in desecrated locations, where demonic spirits await victims.
A creature that becomes the target of Demonic Possession must succeed on a DC 15 Charisma saving throw or be possessed by a bodiless demonic entity. Whenever the possessed creature rolls a 1 on a D20 Test, the demonic entity takes control of the creature and determines the creature's behavior thereafter. At the end of each of the possessed creature's later turns, the creature makes a DC 15 Charisma saving throw, regaining control of itself on a success.
After finishing a Long Rest, a creature with Demonic Possession makes a DC 15 Charisma saving throw. On a successful save, the effect ends on the creature. A *Dispel Evil and Good* spell or any magic that removes a curse also ends the effect on it.

---
193 System Reference Document 5.2.1
***
## Magical Contagions
Alchemists, potion brewers, and areas of wild magic are credited with creating the first magical contagions. An outbreak of such a contagion can form the basis of an adventure as characters search for a cure and try to stop the contagion's spread.

### Rest and Recuperation
If a creature infected with a magical contagion spends 3 days recuperating—engaging in no activities that would interrupt a Long Rest—the creature makes a DC 15 Constitution saving throw at the end of the recuperation period. On a successful save, the creature has Advantage on saving throws to fight off the magical contagion for the next 24 hours.

### Example Contagions
The following examples show how magical contagions can work. Feel free to alter the saving throw DCs, effects, and other characteristics of these contagions to suit your campaign.

#### Cackle Fever
*Magical Contagion*
Cheaply made potions and elixirs are sometimes tainted by Cackle Fever, which affects Humanoids only (gnomes are strangely immune). A creature suffers the following effects 1d4 days after infection:
**Fever.** The creature gains 1 Exhaustion level, which lasts until the contagion ends on the creature.
**Uncontrollable Laughter.** While the creature has the Exhaustion condition, the creature makes a DC 13 Constitution saving throw each time it takes damage other than Psychic damage. On a failed save, the creature takes 5 (1d10) Psychic damage and has the Incapacitated condition as it laughs uncontrollably. At the end of each of its turns, the creature repeats the save, ending the effect on itself on a success. After 1 minute, it succeeds automatically.

**Fighting the Contagion.** At the end of each Long Rest, an infected creature makes a DC 13 Constitution saving throw. After the creature succeeds on three of these saves, the contagion ends on it, and the creature is immune to Cackle Fever for 1 year.
**Spreading the Contagion.** Any Humanoid (other than a gnome) that starts its turn within a 10-foot Emanation originating from a creature infected with Cackle Fever must succeed on a DC 10 Constitution saving throw or also become infected with the contagion. On a successful save, the Humanoid can't catch the contagion from that particular infected creature for the next 24 hours.

#### Sewer Plague
*Magical Contagion*
Fouled potions and alchemical waste can give rise to Sewer Plague, which incubates in sewers and refuse heaps and is sometimes transmitted by creatures that dwell in such areas, including otyughs and rats. Any Humanoid that is wounded by a creature that carries the contagion or that comes into contact with contaminated filth or offal must succeed on a DC 11 Constitution saving throw or become infected with Sewer Plague. A creature suffers the following effects 1d4 days after infection:
**Fatigue.** The creature gains 1 Exhaustion level.
**Weakness.** While the creature has any Exhaustion levels, it regains only half the normal number of Hit Points from spending Hit Point Dice.
**Restlessness.** While the creature has any Exhaustion levels, finishing a Long Rest neither restores lost Hit Points nor reduces the creature's Exhaustion level.

**Fighting the Contagion.** Daily at dawn, an infected creature makes a DC 11 Constitution saving throw. On a failed save, the creature gains 1 Exhaustion level as its fatigue worsens. On a successful save, the creature's Exhaustion level decreases by 1. If the creature's Exhaustion level is reduced to 0, the contagion ends on the creature.

#### Sight Rot
*Magical Contagion*
Any Beast or Humanoid that drinks water tainted by Sight Rot must succeed on a DC 15 Constitution saving throw or have the Blinded condition until the contagion ends.
**Fighting the Contagion.** Magic such as a *Heal* or *Lesser Restoration* spell ends the contagion immediately. A character who is proficient with an Herbalism Kit can use it to create one dose of nonmagical ointment, which takes 1 hour. When applied to the eyes of a creature suffering from Sight Rot, the ointment suppresses the contagion on that creature for 24 hours. If the contagion is suppressed in this way for a total of 72 hours (requiring three doses and applications of the ointment), the contagion ends on the creature.
**Spreading the Contagion.** Any Humanoid that makes skin contact with a creature infected with Sight Rot must succeed on a DC 15 Constitution saving throw or also become infected with the contagion. On a successful save, the Humanoid can't catch the contagion from that particular infected creature for the next 24 hours.

---
194 System Reference Document 5.2.1
***
## Environmental Effects
### Deep Water
Swimming through deep water (more than 100 feet deep) presents additional challenges because of the water's pressure and cold temperature. After each hour of swimming in deep water, a creature that lacks a Swim Speed must succeed on a DC 10 Constitution saving throw or gain 1 Exhaustion level.

### Extreme Cold
When the temperature is 0 degrees Fahrenheit or lower, a creature exposed to the extreme cold must succeed on a DC 10 Constitution saving throw at the end of each hour or gain 1 Exhaustion level. Creatures that have Resistance or Immunity to Cold damage automatically succeed on the save.

### Extreme Heat
When the temperature is 100 degrees Fahrenheit or higher, a creature exposed to the extreme heat and without access to drinkable water must succeed on a Constitution saving throw at the end of each hour or gain 1 Exhaustion level. The DC is 5 for the first hour and increases by 1 for each additional hour. Creatures wearing Medium or Heavy armor have Disadvantage on the save. Creatures that have Resistance or Immunity to Fire damage automatically succeed on the save.

### Frigid Water
A creature can be immersed in frigid water for a number of minutes equal to its Constitution score before suffering any ill effects. Each additional minute spent in frigid water requires the creature to succeed on a DC 10 Constitution saving throw or gain 1 Exhaustion level. Creatures with Resistance or Immunity to Cold damage automatically succeed on the save, as do creatures that are naturally adapted to living in ice-cold water.

### Heavy Precipitation
Everything within an area of heavy rain or heavy snowfall is Lightly Obscured, and creatures in the area have Disadvantage on all Wisdom (Perception) checks. Heavy rain also extinguishes open flames.

### High Altitude
Traveling at altitudes of 10,000 feet or higher above sea level is taxing for most creatures because of the reduced amount of oxygen in the air. Each hour such a creature spends traveling at high altitude counts as 2 hours for the purpose of determining how long that creature can travel (see "Travel Pace").
Creatures can become acclimated to a high altitude by spending 30 days or more at this elevation. Creatures can't become acclimated to elevations above 20,000 feet unless they are native to such environments.

### Slippery Ice
Slippery ice is Difficult Terrain. A creature that moves onto slippery ice for the first time on a turn or starts its turn there must succeed on a DC 10 Dexterity saving throw or have the Prone condition.

### Strong Wind
Strong wind imposes Disadvantage on ranged attack rolls with weapons. It also extinguishes open flames and disperses fog. A flying creature in a strong wind must land at the end of its turn or fall.
A strong wind in a desert can create a sandstorm that imposes Disadvantage on Wisdom (Perception) checks.

### Thin Ice
Thin ice has a weight tolerance of 3d10 × 10 pounds per 10-foot-square area. Whenever the total weight on an area of thin ice exceeds its tolerance, the ice in that area breaks. All creatures on broken ice fall through. Below the ice is frigid water (see “Frigid Water” above).

---
195 System Reference Document 5.2.1
***
## Fear and Mental Stress
Due to the nature of their vocation, adventurers tend to be less susceptible to fear and mental stress than common folk. Whereas a farmer might flee in terror from a bear or an apparition, adventurers are made of sterner stuff. That said, certain creatures and game effects can terrify or fray the mind of even the most stalwart adventurer.
If you plan to use any of these rules, discuss them with your players at the start of the campaign.

### Fear Effects
Whenever the characters encounter something that is supernaturally frightful, use the Frightened condition as the baseline effect. Fear effects typically require a Wisdom saving throw, with a save DC based on how terrifying the situation is. The Sample Fear DCs table provides some examples.

**Sample Fear DCs**
| Example | Save DC |
| :--- | :--- |
| When the characters open a sarcophagus, a harmless yet terrifying apparition appears. | 10 |
| A character triggers a magical trap that creates an illusory manifestation of that character's worst fears, visible only to that character. | 15 |
| A portal to the Abyss opens, revealing a nightmarish realm of torment and slaughter. | 20 |

Typically, a Frightened creature repeats the saving throw at the end of each of its turns, ending the effect on itself on a success.
At your discretion, a Frightened creature might be subject to other effects as long as the Frightened condition lasts. Consider these examples:

*   The Frightened creature must take the Dash action on each of its turns and uses its movement to get farther away from the source of its fear.
*   Attack rolls against the Frightened creature have Advantage.
*   The Frightened creature can do only one of the following on each of its turns: move, take an action, or take a Bonus Action.

### Mental Stress Effects
When a character is subjected to an effect that causes intense mental stress, Psychic damage is the best way to emulate that effect.
The Sample Mental Stress Effects table provides a few examples of such effects, with suggested saving throw DCs and damage. Mental stress can usually be resisted with a successful Wisdom save, but sometimes an Intelligence or Charisma save is more appropriate. On a successful save, a character might take half as much damage instead of no damage, at your discretion.

**Sample Mental Stress Effects**
| Example | Save DC | Psychic Damage |
| :--- | :--- | :--- |
| A character ingests a hallucinogenic substance that distorts the character's perception of reality. | 10 | 1d6 |
| A character touches a fiendish idol that tears at the character's mind, threatening to shatter it. | 15 | 3d6 |
| A magical trap flings a character into the Far Realm until the end of that character's next turn. | 20 | 9d6 |

### Prolonged Effects
Exposure to mental stress can cause prolonged effects. Consider the following possibilities.
**Short-Term Effects.** The character has the Frightened, Incapacitated, or Stunned condition for 1d10 minutes. This condition might be accompanied by alarming behavior or hallucinations. These effects can be suppressed with the *Calm Emotions* spell or removed by the *Lesser Restoration* spell.
**Long-Term Effects.** The character has Disadvantage on some or all ability checks for 1d10 × 10 hours, stemming from an unwillingness or inability to exert a particular set of abilities. The character might feel enervated and unable to exert much Strength, for example, or become so suspicious of others that Charisma checks are more difficult. These effects can be suppressed with the *Calm Emotions* spell or removed by the *Lesser Restoration* spell.
**Indefinite Effects.** An indefinite effect is a long-term effect (see above) that lasts until removed by a *Greater Restoration* spell. It can be suppressed by a *Calm Emotions* spell.

---
196 System Reference Document 5.2.1
***
## Poison
Given their insidious and deadly nature, poisons are a favorite tool among assassins and evil creatures.
Poisons come in the following four types:

**Contact.** Contact poison can be smeared on an object and remains potent until it is touched or washed off. A creature that touches contact poison with exposed skin suffers its effects.
**Ingested.** A creature must swallow an entire dose of ingested poison to suffer its effects. The dose can be delivered in food or a liquid. You may decide that a partial dose has a reduced effect, such as allowing Advantage on the saving throw or dealing only half as much damage on a failed save.
**Inhaled.** Poisonous powders and gases take effect when inhaled. Blowing the powder or releasing the gas subjects creatures in a 5-foot Cube to its effect. The resulting cloud dissipates immediately afterward. Holding one's breath is ineffective against inhaled poisons, as they affect nasal membranes, tear ducts, and other parts of the body.
**Injury.** Injury poison can be applied as a Bonus Action to a weapon, a piece of ammunition, or similar object. The poison remains potent until delivered through a wound or washed off. A creature that takes Piercing or Slashing damage from an object coated with the poison is exposed to its effects.

### Purchasing Poison
In some settings, laws prohibit the possession and use of poison, but an illicit dealer or unscrupulous apothecary might keep a hidden stash. Characters with criminal contacts might be able to acquire poison easily. Other characters might have to make extensive inquiries and pay bribes before they acquire the poison they seek.

### Harvesting Poison
A character can attempt to harvest poison from a venomous creature that is dead or has the Incapacitated condition. The effort takes 1d6 minutes, after which the character makes a DC 20 Intelligence (Nature) check using a Poisoner's Kit. On a successful check, the character harvests enough poison for a single dose, and no additional poison can be harvested from that creature. On a failed check, the character is unable to extract any poison. If the character fails the check by 5 or more, the character is subjected to the creature's poison.

### Sample Poisons
Example poisons are detailed here in alphabetical order. Each poison's description includes the suggested price for a single dose of the poison, its type (contact, ingested, inhaled, or injury), and a description of the poison's debilitating effects.

#### Assassin's Blood (150 GP)
*Ingested Poison*
A creature subjected to Assassin's Blood makes a DC 10 Constitution saving throw. On a failed save, the creature takes 6 (1d12) Poison damage and has the Poisoned condition for 24 hours. On a successful save, the creature takes half as much damage only.

#### Burnt Othur Fumes (500 GP)
*Inhaled Poison*
A creature subjected to Burnt Othur Fumes must succeed on a DC 13 Constitution saving throw or take 10 (3d6) Poison damage, and it must repeat the save at the start of each of its turns. On each successive failed save, the creature takes 3 (1d6) Poison damage. After three successful saves, the poison ends.

#### Crawler Mucus (200 GP)
*Contact Poison*
A creature subjected to Crawler Mucus must succeed on a DC 13 Constitution saving throw or have the Poisoned condition for 1 minute. The creature also has the Paralyzed condition while Poisoned in this way. The creature repeats the save at the end of each of its turns, ending the effect on itself on a success.

#### Essence of Ether (300 GP)
*Inhaled Poison*
A creature subjected to Essence of Ether must succeed on a DC 15 Constitution saving throw or have the Poisoned condition for 8 hours. The creature also has the Unconscious condition while Poisoned in this way. The creature wakes up if it takes damage or if another creature takes an action to shake it awake.

#### Malice (250 GP)
*Inhaled Poison*
A creature subjected to Malice must succeed on a DC 15 Constitution saving throw or have the Poisoned condition for 1 hour. The creature also has the Blinded condition while Poisoned in this way.

#### Midnight Tears (1,500 GP)
*Ingested Poison*
A creature that ingests Midnight Tears suffers no effect until the stroke of midnight. Any effect that

---
197 System Reference Document 5.2.1
***
ends the Poisoned condition neutralizes this poison. If the poison hasn't been neutralized before midnight, the creature makes a DC 17 Constitution saving throw, taking 31 (9d6) Poison damage on a failed save or half as much damage on a successful one.

#### Oil of Taggit (400 GP)
*Contact Poison*
A creature subjected to Oil of Taggit must succeed on a DC 13 Constitution saving throw or have the Poisoned condition for 24 hours. The creature also has the Unconscious condition while Poisoned in this way. It wakes up if it takes damage.

#### Pale Tincture (250 GP)
*Ingested Poison*
A creature subjected to Pale Tincture must succeed on a DC 16 Constitution saving throw or take 3 (1d6) Poison damage and have the Poisoned condition. The Poisoned creature repeats the save every 24 hours, taking 3 (1d6) Poison damage on a failed save. The damage the poison deals can't be healed by any means while the creature remains Poisoned. After seven successful saves against the poison, the creature is no longer Poisoned.

#### Purple Worm Poison (2,000 GP)
*Injury Poison*
A creature subjected to Purple Worm Poison makes a DC 21 Constitution saving throw, taking 35 (10d6) Poison damage on a failed save or half as much damage on a successful one.

#### Serpent Venom (200 GP)
*Injury Poison*
A creature subjected to Serpent Venom must succeed on a DC 11 Constitution saving throw, taking 10 (3d6) Poison damage on a failed save or half as much damage on a successful one.

#### Spider's Sting (200 GP)
*Injury Poison*
A creature subjected to Spider's Sting must succeed on a DC 13 Constitution saving throw or have the Poisoned condition for 1 hour. If the creature fails the save by 5 or more, the creature also has the Unconscious condition while Poisoned in this way. The creature wakes up if it takes damage or if another creature takes an action to shake it awake.

#### Torpor (600 GP)
*Ingested Poison*
A creature subjected to Torpor poison must succeed on a DC 15 Constitution saving throw or have the Poisoned condition for 4d6 hours. The creature's Speed is halved while the creature is Poisoned in this way.

#### Truth Serum (150 GP)
*Ingested Poison*
A creature subjected to Truth Serum must succeed on a DC 11 Constitution saving throw or have the Poisoned condition for 1 hour. The Poisoned creature can't knowingly communicate a lie.

#### Wyvern Poison (1,200 GP)
*Injury Poison*
A creature subjected to Wyvern Poison makes a DC 14 Constitution saving throw, taking 24 (7d6) Poison damage on a failed save or half as much damage on a successful one.

---
198 System Reference Document 5.2.1
***
## Traps
Traps should be used sparingly, lest they lose their charm. A hidden pit can be a fun surprise, but too many traps in an adventure can lead players to become overly cautious, which slows down the game.
The best traps are fleeting distractions that skilled characters can overcome in a short amount of time or deadly puzzles that require quick thinking and teamwork to overcome. Traps that are undetectable and inescapable are rarely fun.

### Parts of a Trap
The description of a trap includes the following parts after the trap's name:
**Severity and Levels.** A trap is designated as a nuisance or as deadly for characters of certain levels. A nuisance trap is unlikely to seriously harm characters of the indicated levels, whereas a deadly trap can grievously damage characters of the indicated levels.
**Trigger.** Traps are often set to go off when a creature enters an area or touches an object. Examples of triggers include stepping on a pressure plate, crossing a trip wire, turning a doorknob, or using the wrong key in a lock.
**Duration.** Some traps have durations expressed in rounds, minutes, or hours. Others specify that their effects last until the trap is destroyed or dispelled. If a trap's duration is instantaneous, its effect is resolved instantly. If a trap resets after activating, that fact is noted in this entry. A trap is otherwise inert after activation.

Use caution when introducing a trap to characters of a level lower than the trap's level range. A trap that is a nuisance at one level range could be deadly to characters of a lower level range.

### Example Traps
Traps are presented in alphabetical order.

#### Collapsing Roof
*Deadly Trap (Levels 1–4)*
**Trigger:** A creature crosses a trip wire
**Duration:** Instantaneous

This trap uses a trip wire to collapse an unstable section of ceiling. The trip wire is 3 inches off the ground and stretches between two weak supports that topple when the trip wire is pulled.
The first creature that crosses the trip wire causes the supports to topple and the unstable section of ceiling to collapse. Each creature beneath the unstable section of ceiling must succeed on a DC 13 Dexterity saving throw, taking 11 (2d10) Bludgeoning damage on a failed save or half as much damage on a successful one. Rubble from the collapse turns the trapped area into Difficult Terrain.
**Detect and Disarm.** As a Search action, a creature can examine the trapped area and make a DC 11 Wisdom (Perception) check, detecting the trip wire and the unstable section of ceiling on a successful check. Once detected, the trip wire can be easily cut or avoided (no ability check required).
**At Higher Levels.** You can scale the trap for higher levels by increasing the damage and the save DC, as shown in the following table.

| Levels | Bludgeoning Damage | Save DC |
| :--- | :--- | :--- |
| 5–10 | 22 (4d10) | 15 |
| 11–16 | 55 (10d10) | 17 |
| 17–20 | 99 (18d10) | 19 |

#### Falling Net
*Nuisance Trap (Levels 1–4)*
**Trigger:** A creature crosses a trip wire
**Duration:** Instantaneous

A falling net trap uses a trip wire to release a weighted, 10-foot-square Net suspended from the ceiling. The trip wire is 3 inches off the ground and stretches between two columns or trees.
The first creature that crosses the trip wire causes the Net to fall on it. The target must succeed on a DC 10 Dexterity saving throw or have the Restrained condition until it escapes. The target succeeds automatically if it's Huge or larger. A creature can take an action to make a DC 10 Strength (Athletics) check, freeing itself or another creature within its reach from the Net on a successful check.
**Detect and Disarm.** As a Search action, a creature can examine the trapped area and make a DC 11 Wisdom (Perception) check, detecting the trip wire and the suspended Net on a successful check. Once detected, the trip wire can be easily cut or avoided (no ability check required).
**Destroy the Net.** Reducing the Net to 0 Hit Points frees any creature trapped in it (see "Adventuring Gear" for the Net's statistics).
**Set the Trap.** A creature that has Thieves' Tools and all the trap's components (including a Net) can try to set a falling net trap, doing so with a successful DC 13 Dexterity (Sleight of Hand) check. Each attempt to set this trap takes 10 minutes.
**At Higher Levels.** You can scale the trap for higher levels by increasing the weight of the Net, which increases the save DC and the DC of the Strength (Athletics) check as follows: DC 12 at levels 5–10, DC 14 at levels 11–16, or DC 16 at levels 17–20.

#### Fire-Casting Statue
*Deadly Trap (Levels 1–4)*
**Trigger:** A creature moves onto a pressure plate

---
199 System Reference Document 5.2.1
***
**Duration:** Instantaneous, and the trap resets at the start of the next turn

When a creature moves onto this trap's pressure plate for the first time on a turn or starts its turn there, a nearby statue exhales a 15-foot Cone of magical flame. The statue can look like anything, such as a dragon or a wizard. Each creature in the Cone must succeed on a DC 15 Dexterity saving throw, taking 11 (2d10) Fire damage on a failed save or half as much damage on a successful one.
**Detect and Disarm.** A *Detect Magic* spell reveals an aura of Evocation magic around the statue. As a Search action, a creature within 5 feet of the statue can examine it and make a DC 10 Wisdom (Perception) check, detecting a tiny glyph on the statue on a successful check. Once the glyph is found, a character can take a Study action to examine it and make a DC 15 Intelligence (Arcana) check, ascertaining that the glyph means "fire” on a successful check. As an action, a character can use a sharp tool to deface the glyph, which disarms the trap.
As a Search action, a creature can examine the section of floor that forms the pressure plate and make a DC 15 Wisdom (Perception) check, detecting the pressure plate on a successful check. Wedging an Iron Spike or similar object under the pressure plate prevents the trap from triggering.
**At Higher Levels.** You can scale the trap for higher levels by increasing the damage and the area of effect, as shown in the following table.

| Levels | Fire Damage | Area of Effect |
| :--- | :--- | :--- |
| 5–10 | 22 (4d10) | 30-foot Cone |
| 11–16 | 55 (10d10) | 60-foot Cone |
| 17–20 | 99 (18d10) | 120-foot Cone |

#### Hidden Pit
*Nuisance Trap (Levels 1–4)*
**Trigger:** A creature moves onto the pit's lid
**Duration:** Instantaneous

This 10-foot-deep pit has a hinged lid constructed from material identical to the surrounding floor. When a creature moves onto the lid, it swings open like a trapdoor, causing the creature to fall into the pit. The lid remains open thereafter.
A creature that falls into the pit takes 3 (1d6) Bludgeoning damage from the fall.
**Detect and Disarm.** As a Study action, a creature can examine the section of floor that forms the pit's lid and make a DC 15 Intelligence (Investigation) check, detecting the pit on a successful check. Once the pit is detected, an Iron Spike or a similar object can be wedged between the pit's lid and the surrounding floor to prevent the lid from opening, thereby making it safe to cross. The cover can also be held shut using *Arcane Lock* or similar magic.
**Escape.** A creature needs a Climb Speed, climbing gear, or magic such as *Spider Climb* to scale the pit's smooth walls. You can make the pit easier to escape by adding cracks in the walls big enough to serve as handholds and footholds.
**At Higher Levels.** You can scale the trap for higher levels by increasing the pit's depth and damage, as shown in the following table.

| Levels | Pit Depth | Bludgeoning Damage |
| :--- | :--- | :--- |
| 5–10 | 30 feet | 10 (3d6) |
| 11–16 | 60 feet | 21 (6d6) |
| 17–20 | 120 feet | 42 (12d6) |

#### Poisoned Darts
*Deadly Trap (Levels 1–4)*
**Trigger:** A creature moves onto a pressure plate
**Duration:** Instantaneous, and the trap resets at the start of the next turn if it has activated fewer than three times

When a creature moves onto this trap's pressure plate for the first time on a turn, poisoned darts shoot from tubes embedded in the surrounding walls. The holes that house these tubes are obscured by dust and cobwebs or skillfully hidden amid bas-reliefs, murals, or frescoes.
Each creature in the darts' path must succeed on a DC 13 Dexterity saving throw or be struck by 1d3 darts, taking 3 (1d6) Poison damage per dart.
**Detect and Disarm.** As a Search action, a creature can examine the walls and make a DC 15 Wisdom (Perception) check, detecting the holes on a successful check. Plugging all the holes with wax, cloth, or detritus prevents the darts from firing.
As a Search action, a creature can examine the section of floor that forms the pressure plate and make a DC 15 Wisdom (Perception) check, detecting the pressure plate on a successful check. Wedging an Iron Spike or a similar object under the pressure plate prevents the trap from triggering.
**At Higher Levels.** You can scale the trap for higher levels by increasing each dart's Poison damage as follows: 7 (2d6) at levels 5–10, 14 (4d6) at levels 11–16, or 24 (7d6) at levels 17–20.

#### Poisoned Needle
*Nuisance Trap (Levels 1–4)*
**Trigger:** A creature opens the trap's lock improperly or fails to disarm the trap
**Duration:** Instantaneous

A poisoned needle is hidden in a lock. When a creature opens the lock with any object other than the proper key, the needle springs out and stabs the creature. The creature makes a DC 11 Constitution saving throw. On a failed save, the creature takes 5 (1d10) Poison damage and has the Poisoned

---
200 System Reference Document 5.2.1
***
condition for 1 hour. On a successful save, the creature takes half as much damage only.
**Avoid.** The trap doesn't trigger if the lock is opened using a *Knock* spell or similar magic.
**Detect and Disarm.** As a Search action, a creature can examine the trapped lock and make a DC 15 Wisdom (Perception) check, detecting the needle on a successful check. Once the trap is detected, a character can take an action to try to disarm the trap, doing so with a successful DC 15 Dexterity (Sleight of Hand) check. On a failed check, the creature triggers the trap.
**At Higher Levels.** You can scale the trap for higher levels by increasing the damage and the save DC, as shown in the following table.

| Levels | Poison Damage | Save DC |
| :--- | :--- | :--- |
| 5–10 | 11 (2d10) | 13 |
| 11–16 | 22 (4d10) | 15 |
| 17–20 | 55 (10d10) | 17 |

#### Rolling Stone
*Deadly Trap (Levels 11–16) or Nuisance Trap (Levels 17–20)*
**Trigger:** A creature moves onto a pressure plate
**Duration:** Until the stone stops rolling

When a creature moves onto a hidden pressure plate, a 5-foot-radius orb of solid stone is released from a secret compartment and begins to roll. The stone and all creatures nearby roll Initiative; the stone gets a +8 bonus on its Initiative roll.
On its turn, the stone moves 60 feet in one direction, changing course if redirected by an obstacle. The stone can move through creatures' spaces, and creatures can move through the stone's space, treating it as Difficult Terrain. Whenever the stone enters a creature's space for the first time on a turn or a creature enters the stone's space while the stone is rolling, that creature must succeed on a DC 15 Dexterity saving throw or take 55 (10d10) Bludgeoning damage and have the Prone condition.
The stone stops when it hits a wall or similar barrier. It can't go around corners, but creative dungeon builders incorporate curving turns into nearby passages that allow the stone to keep moving.
**Detect and Disarm.** As a Study action, a creature can examine the section of floor that forms the pressure plate and make a DC 15 Intelligence (Investigation) check, deducing the pressure plate's function on a successful check. Wedging an Iron Spike or a similar object under the pressure plate prevents the trap from triggering.
**Destroy the Stone.** The stone is a Large object that has AC 17, HP 100, a Damage Threshold of 10, and Immunity to Poison and Psychic damage.
**Slow the Stone.** As an action, a creature can try to slow down the stone with a DC 20 Strength (Athletics) check. If the check is successful, the distance the stone moves on its turn is reduced by 15 feet. If that distance drops to 0, it stops moving and is no longer a threat.

#### Spiked Pit
*Deadly Trap (Levels 1–4)*
**Trigger:** A creature moves onto the pit's lid
**Duration:** Instantaneous

A 10-foot-deep pit has a hinged lid constructed from material identical to the surrounding floor. When a creature moves onto the lid, it swings open like a trapdoor, causing the creature to fall into the pit, which has sharpened wooden or metal spikes at the bottom. The lid remains open thereafter.
A creature that falls into the pit lands at the bottom and takes 3 (1d6) Bludgeoning damage from the fall plus 9 (2d8) Piercing damage from the spikes.
**Detect and Disarm.** As a Study action, a creature can examine the section of floor that forms the pit's lid and make a DC 15 Intelligence (Investigation) check, detecting the pit on a successful check. Once the hidden pit is detected, an Iron Spike or a similar object can be wedged between the pit's lid and the surrounding floor to prevent the lid from opening, thereby making it safe to cross. The cover can also be held shut using an *Arcane Lock* spell or similar magic.
**Escape.** A creature needs a Climb Speed, climbing gear, or magic such as a *Spider Climb* spell to scale the pit's smooth walls. You can make the pit easier to escape by adding cracks in the walls big enough to serve as handholds and footholds.
**At Higher Levels.** You can scale the trap for higher levels by increasing the pit's depth and damage, as shown in the following table.

| Levels | Pit Depth | Damage |
| :--- | :--- | :--- |
| 5–10 | 30 feet | 10 (3d6) Bludgeoning plus 13 (3d8) Piercing |
| 11–16 | 60 feet | 21 (6d6) Bludgeoning plus 36 (8d8) Piercing |
| 17–20 | 120 feet | 42 (12d6) Bludgeoning plus 57 (13d8) Piercing |

---
201 System Reference Document 5.2.1
***
## Combat Encounters
The following features can make a combat encounter more interesting or challenging:
**Changes in Elevation.** Terrain features that provide a change of elevation (such as stacks of empty crates, ledges, and balconies) reward clever positioning and encourage characters to jump, climb, fly, or teleport.
**Defensive Positions.** Enemies in hard-to-reach locations or defensive positions force characters who normally attack at range to move around.
**Mixed Monster Groups.** When different types of monsters work together, they can combine their abilities—just like characters with different classes and origins. A diverse force is more powerful.
**Reasons to Move.** Use features that encourage characters and their enemies to move around, such as chandeliers, kegs of gunpowder or oil, and rolling stone traps.

### Combat Encounter Difficulty
Use the following guidelines to create a combat encounter of a desired level of difficulty.

#### Step 1: Choose a Difficulty
Three categories describe the range of encounter difficulty:
**Low Difficulty.** An encounter of low difficulty is likely to have one or two scary moments for the players, but their characters should emerge victorious with no casualties. One or more of them might need to use healing resources, however. As a rough guideline, a single monster generally presents a low-difficulty challenge for a party of four characters whose level equals the monster's Challenge Rating.
**Moderate Difficulty.** Absent healing and other resources, an encounter of moderate difficulty could go badly for the adventurers. Weaker characters might get taken out of the fight, and there's a slim chance that one or more characters might die.
**High Difficulty.** A high-difficulty encounter could be lethal for one or more characters. To survive it, the characters will need smart tactics, quick thinking, and maybe even a little luck.

#### Step 2: Determine Your XP Budget
Using the XP Budget per Character table, cross-reference the party's level with the desired encounter difficulty. Multiply the number in the table by the number of characters in the party to get your XP budget for the encounter.

| XP Budget per Character | | | |
| :--- | :--- | :--- | :--- |
| **Party's Level** | **Encounter Difficulty** | | |
| | **Low** | **Moderate** | **High** |
| 1 | 50 | 75 | 100 |
| 2 | 100 | 150 | 200 |
| 3 | 150 | 225 | 400 |
| 4 | 250 | 375 | 500 |
| 5 | 500 | 750 | 1,100 |
| 6 | 600 | 1,000 | 1,400 |
| 7 | 750 | 1,300 | 1,700 |
| 8 | 1,000 | 1,700 | 2,100 |
| 9 | 1,300 | 2,000 | 2,600 |
| 10 | 1,600 | 2,300 | 3,100 |
| 11 | 1,900 | 2,900 | 4,100 |
| 12 | 2,200 | 3,700 | 4,700 |
| 13 | 2,600 | 4,200 | 5,400 |
| 14 | 2,900 | 4,900 | 6,200 |
| 15 | 3,300 | 5,400 | 7,800 |
| 16 | 3,800 | 6,100 | 9,800 |
| 17 | 4,500 | 7,200 | 11,700 |
| 18 | 5,000 | 8,700 | 14,200 |
| 19 | 5,500 | 10,700 | 17,200 |
| 20 | 6,400 | 13,200 | 22,000 |

#### Step 3: Spend Your Budget
Every creature has an XP value in its stat block. When you add a creature to your combat encounter, deduct its XP from your XP budget to determine how many XP you have left to spend. Spend as much of your XP budget as you can without going over. It's OK if you have a few unspent XP left over. Examples are given below:

**Example 1.** A low-difficulty encounter for four level 1 characters has an XP budget of 50 × 4, for a total of 200 XP. With that, you could build any of the following encounters:
*   1 Bugbear Warrior (200 XP)
*   2 Giant Wasps (100 XP each), for 200 XP total
*   6 Giant Rats (25 XP each), for 150 XP total

**Example 2.** A moderate-difficulty encounter for five level 3 characters has an XP budget of 225 × 5, for a total of 1,125 XP. With that, you could build either of these encounters:
*   2 Druids (450 XP each) and 9 Stirges (25 XP each), for 1,125 XP total
*   1 Wight (700 XP), 1 Warhorse Skeleton (100 XP), and 6 Skeletons (50 XP each), for 1,100 XP total

---
202 System Reference Document 5.2.1
***
**Example 3.** A high-difficulty encounter for six level 15 characters has an XP budget of 7,800 × 6, for a total of 46,800 XP. With that, you could build this encounter:
*   2 Adult Red Dragons (18,000 XP each) and 2 Fire Giants (5,000 XP each), for 46,000 XP total

### Troubleshooting
When creating and running combat encounters, keep the following in mind.

#### Many Creatures
The more creatures in an encounter, the higher the risk that a lucky streak on their part could deal more damage to the characters than you expect. If your encounter includes more than two creatures per character, include fragile creatures that can be defeated quickly. This guideline is especially important for characters of level 1 or 2.

#### Adjustments
A player's absence might warrant removing creatures from an encounter to keep it at the intended difficulty. Also, die rolls and other factors can result in an encounter being easier or harder than intended. You can adjust an encounter on the fly, such as by having creatures flee (making the encounter easier) or adding reinforcements (making the encounter harder).

#### CR 0 Creatures
Creatures that have a CR of 0, particularly ones that are worth 0 XP, should be used sparingly. If you want to include many CR 0 critters in an encounter, use swarms instead.

#### Number of Stat Blocks
The best combat encounters often pair one kind of creature with another, such as fire giants paired with hell hounds. Be mindful of the number of stat blocks you need to run the encounter. Referencing more than two or three stat blocks for a single encounter can be daunting, particularly if the creatures are complex.

#### Powerful Creatures
If your combat encounter includes a creature whose CR is higher than the party's level, be aware that such a creature might deal enough damage with a single action to take out one or more characters. For example, an Ogre (CR 2) can kill a level 1 Wizard with a single blow.

#### Unusual Features
If a monster has a feature that lower-level characters can't easily overcome, consider not adding that monster to an encounter for characters whose level is lower than the monster's Challenge Rating.

---
203 System Reference Document 5.2.1