204

# Magic Items

Magic items are gleaned from the hoards of felled monsters or discovered in long-lost vaults. Such items grant capabilities a character could rarely have otherwise, or they complement their owner's capabilities in wondrous ways.

## Magic Item Categories

Every magic item belongs to a category. The Magic Item Categories table lists the nine categories and provides examples. Rules for the categories appear after the table.

**Magic Item Categories**

| Category | Examples |
| :--- | :--- |
| Armor | *+1 Leather Armor*, *+1 Shield* |
| Potions | *Potion of Healing* |
| Rings | *Ring of Invisibility* |
| Rods | *Immovable Rod* |
| Scrolls | *Spell Scroll* |
| Staffs | *Staff of Striking* |
| Wands | *Wand of Fireballs* |
| Weapons | *+1 Ammunition*, *+1 Longsword* |
| Wondrous Items | *Bag of Holding*, *Boots of Elvenkind* |

### Armor

An item in the Armor category is typically a magical version of armor from "Equipment." Unless an armor's description notes otherwise, the armor must be worn for its magic to function.
Some suits of magic armor specify the type of armor they are, such as Chain Mail or Plate Armor. If no type is specified, choose the type or determine it randomly.

### Potions

An item in the Potion category might be a magical brew that must be imbibed or an oil that must be applied to a creature or an object. A typical potion consists of 1 ounce of liquid in a vial.

**Using a Potion.** Potions are consumable items. Drinking a potion or administering it to another creature requires a Bonus Action. Applying an oil might take longer as specified in its description. Once used, a potion takes effect immediately, and it is used up.

**Mixing Potions.** A character might drink one potion while still under the effects of another or pour several potions into a single container. The strange ingredients used in creating potions can result in unpredictable interactions.

When a character mixes two potions together, roll on the Potion Miscibility table. If more than two are combined, roll again for each subsequent potion, combining the results. Unless the effects are immediately obvious, reveal them only when they become evident.

**Potion Miscibility**

| 1d100 | Result |
| :--- | :--- |
| 01 | Both potions lose their effects, and the mixture creates a magical explosion in a 5-foot-radius Sphere centered on itself. Each creature in that area takes 4d10 Force damage. |
| 02–08 | Both potions lose their effects, and the mixture becomes an ingested poison of your choice (see "Poison" in “Gameplay Toolbox”). |
| 09–15 | Both potions lose their effects. |
| 16–25 | One potion loses its effect. |
| 26–35 | Both potions work, but with their numerical effects and durations halved. If a potion has no numerical effect and no duration, it instead loses its effect. |
| 36–90 | Both potions work normally. |
| 91–99 | Both potions work, but the numerical effects and duration of one potion are doubled. If neither potion has anything to double in this way, they work normally. |
| 00 | Only one potion works, but its effects are permanent. Choose the simplest effect to make permanent or the one that seems the most fun. For example, a *Potion of Healing* might increase the drinker's Hit Point maximum by 2d4 + 2, or a *Potion of Invisibility* might give the drinker the Invisible condition indefinitely. At your discretion, a *Dispel Magic* spell or similar magic might end this lasting effect. |

### Rings

For its magic to function, an item in the Ring category must be worn on a finger or a similar digit unless its description notes otherwise.

### Rods

An item in the Rod category is a scepter usually made of metal, wood, or bone. A typical rod weighs 2 to 5 pounds.
Unless its description notes otherwise, a rod can be used as an Arcane Focus.

System Reference Document 5.2.1

***

205

### Scrolls

An item in the Scroll category is a roll of paper or parchment, sometimes attached to wooden rods and typically kept safe in a tube of ivory, jade, leather, metal, or wood. The most prevalent scroll is the *Spell Scroll*, a spell stored in written form.

**Using a Scroll.** Scrolls are consumable items. Unleashing the magic in a scroll requires the user to read the scroll. When its magic has been invoked, the scroll can't be used again. Its words fade, or it crumbles into dust.
Any creature that can understand a written language can read a scroll and attempt to activate it unless its description notes otherwise.

### Staffs

Items in the Staff category vary widely in appearance: some are of nearly equal diameter throughout and smooth, others are gnarled and twisted, some are made of wood, and others are composed of polished metal or crystal. A staff weighs between 2 and 7 pounds and serves well as a walking stick or cane.
Unless its description notes otherwise, a staff can be used as a nonmagical Quarterstaff and an Arcane Focus.

### Wands

An item in the Wand category is typically 12 to 15 inches long and crafted of metal, bone, or wood. It is tipped with metal, crystal, stone, or some other material.
Unless its description notes otherwise, a wand can be used as an Arcane Focus.

### Weapons

A magic weapon is typically a magical version of a weapon from "Equipment.” Some magic weapons specify the type of weapon they are in their descriptions, such as a Longsword or Longbow. If no weapon type is specified, you may choose the type or determine it randomly.

**Ammunition.** If a magic weapon has the Ammunition property, ammunition fired from it is considered magical for the purpose of any rule that cares whether a weapon is magical or not.

### Wondrous Items

Wondrous Items include wearable items such as boots, belts, capes, amulets, brooches, and circlets. Bags, carpets, figurines, horns, musical instruments, and more also fall into this category.

> **MAGIC ITEM RULES**
> Rules for identifying, attuning to, and using magic items appear in "Equipment." Additional rules are presented below.
> **Attunement Prerequisites.** If a magic item has a class prerequisite, a creature must be a member of that class to attune to the item. If a creature must be a spellcaster to attune to an item, the creature qualifies if it can cast at least one spell using its traits or features, not by using a magic item or the like.
> **Items Made for Specific Creatures.** Magic items that are meant to be worn tend to magically adjust themselves to the wearer. However, you can decide that a magic item doesn't adjust its size to fit any wearer. For example, a particular armorer might make items usable only by folk who are sized and shaped like dwarves.
> **Unusual Anatomy.** Use your discretion to decide whether a creature can wear an item not made for its anatomy. A ring placed on a tentacle might work, but a yuan-ti with a snakelike tail instead of legs can't wear magic boots.
> **Paired Items.** You can allow exceptions to the rule that paired items must both be worn. For example, a character with only one arm might be able to use a single *Glove of Missile Snaring* so long as the matching glove is on their person.

## Magic Item Rarity

Every magic item has a rarity, which provides a rough measure of an item's power relative to other magic items. The rarities are shown in the Magic Item Rarities and Values table.
Common magic items, such as a *Potion of Healing*, are the most plentiful. Artifacts, such as the *Dragon Orb*, are priceless, unique, and difficult to acquire.

### Magic Item Values by Rarity

Common magic items can often be bought in a town or city. Uncommon and Rare magic items are usually found only in cities, and rarer magic items might be sold only in wondrous locations, such as a city on another plane of existence. If you allow characters to buy and sell magic items in your campaign, rarity can help you set prices for those items. Gold Piece values are provided in the Magic Item Rarities and Values table, though a seller might ask for a service rather than coin as payment.
If a magic item incorporates an item that has a purchase cost in “Equipment” (such as a weapon or a suit of armor), add that item's cost to the magic item's value. For example, *+1 Armor* (Plate Armor)

System Reference Document 5.2.1

***

206

has a value of 5,500 GP, which is the sum of a Rare magic item's value (4,000 GP) and the cost of Plate Armor (1,500 GP).

**Magic Item Rarities and Values**

| Rarity | Value* | Rarity | Value* |
| :--- | :--- | :--- | :--- |
| Common | 100 GP | Very Rare | 40,000 GP |
| Uncommon | 400 GP | Legendary | 200,000 GP |
| Rare | 4,000 GP | Artifact | Priceless |

*\*Halve the value for a consumable item other than a Spell Scroll. The value of a Spell Scroll is double what it costs to scribe the scroll (as specified in the "Scribing Spell Scrolls" section of "Equipment").*

## Activating a Magic Item

It usually takes a Magic action to activate a magic item. The item's user might also need to do something special. The description of each item category or individual item details how an item is activated. Certain items use the following rules for their activation.

### Command Word

A command word is a word or short phrase that must be spoken or signed for an item to work. Spoken command words must be audible and fail to work in areas where all sound is suppressed, as in the area of the *Silence* spell.

### Consumable Items

Some items are consumed—used up, in other words—when they are activated. A *Potion of Healing* must be swallowed, for example, while the writing vanishes from a scroll when it is read. Once used, a consumable item loses its magic.

### Spells Cast from Items

Some magic items allow the user to cast a spell from the item. The spell is cast at the lowest possible spell and caster level, doesn't expend any of the user's spell slots, and requires no components unless the item's description notes otherwise. The spell uses its normal casting time, range, and duration, and the user of the item must concentrate if the spell requires Concentration. Many items, such as Potions, bypass the casting of a spell and confer the spell's effects with its usual duration. Certain items make exceptions to these rules, changing the casting time, duration, or other parts of a spell.
A magic item may require the user to use their own spellcasting ability when casting a spell from the item. If the user has more than one spellcasting ability, the user chooses which one to use with the item. If the user doesn't have a spellcasting ability, their spellcasting ability modifier is +0 for the item, and the user's Proficiency Bonus applies.

### Charges

Some magic items have charges that must be expended to activate their properties. The number of charges an item has remaining is revealed when the *Identify* spell is cast on it. A creature attuned to an item knows how many charges the item has and how many it regains.

### "The Next Dawn"

Magic items often have charges or properties that recharge at the next dawn or some other specified time. If such an item is on a world or plane of existence where the specified event doesn't occur, the GM determines when the item recharges.

### Cursed Items

A magic item's description specifies whether it bears a curse. Most methods of identifying items, including the *Identify* spell, fail to reveal such a curse.
Attunement to a cursed item can't be ended voluntarily unless the curse is broken first, such as with a *Remove Curse* spell.

### Magic Item Resilience

A magic item is at least as durable as a nonmagical item of its kind. Most magic items, other than Potions and Scrolls, have Resistance to all damage.
An Artifact can be destroyed only in some special way. Otherwise, it is impervious to damage. Learning how to destroy an Artifact usually requires research or the completion of a quest.

## Crafting Magic Items

"Equipment” contains rules on brewing *Potions of Healing* and scribing *Spell Scrolls*. To create other magic items, follow the rules below. In these rules, "you" refers to the character crafting the magic item.

### Arcana Proficiency

To craft a magic item, you and any assistants must have proficiency in the Arcana skill.

### Tools

The Magic Item Tools table lists which tool is required to make a magic item of each category. You must use the required tool to make an item and have proficiency with that tool. Any assistants must also have proficiency with it. For more information on the tools, see "Equipment."

System Reference Document 5.2.1

***

207

**Magic Item Tools**

| Item Category | Required Tool |
| :--- | :--- |
| **Armor** | Leatherworker's Tools, Smith's Tools, or Weaver's Tools depending on the kind of armor as noted in the tools' descriptions |
| **Potion** | Alchemist's Supplies or Herbalism Kit |
| **Ring** | Jeweler's Tools |
| **Rod** | Woodcarver's Tools |
| **Scroll** | Calligrapher's Supplies |
| **Staff** | Woodcarver's Tools |
| **Wand** | Woodcarver's Tools |
| **Weapon** | Leatherworker's Tools, Smith's Tools, or Woodcarver's Tools depending on the kind of weapon as noted in the tools' descriptions |
| **Wondrous Item** | Tinker's Tools or the tool required to make the nonmagical item on which the magic item is based |

### Spells

If a magic item allows its user to cast any spells from it, you must have all those spells prepared every day you spend crafting the item.

### Time and Cost

Crafting a magic item takes an amount of time and money based on the item's rarity as shown in the Magic Item Crafting Time and Cost table.

**Work per Day.** For each day of crafting, you must work for 8 hours. If an item requires multiple days, those days needn't be consecutive.

**Assistants.** Characters can combine their efforts to shorten the crafting time. Divide the time needed to create an item by the number of characters working on it. Normally, only one other character can assist you, but the GM might allow more assistants.

**Raw Materials.** The cost in the table represents the raw materials needed to make a magic item. The GM determines whether appropriate raw materials are available. In a city, there is a 75 percent chance that the materials are available, and in any other settlement, that chance is 25 percent. If materials aren't available, you must wait at least 7 days before checking on the availability again.
If a magic item incorporates an item that has a purchase cost (such as a weapon or a suit of armor), you must also pay that entire cost or craft that item using the rules in "Equipment." For example, to make *+1 Armor* (Plate Armor), you must pay 3,500 GP or pay 2,000 GP and craft the armor.

**Magic Item Crafting Time and Cost**

| Item Rarity | Time\* | Cost\* |
| :--- | :--- | :--- |
| Common | 5 days | 50 GP |
| Uncommon | 10 days | 200 GP |
| Rare | 50 days | 2,000 GP |
| Very Rare | 125 days | 20,000 GP |
| Legendary | 250 days | 100,000 GP |

*\*The time and cost are halved for a consumable item other than a Spell Scroll, whose crafting time and cost are given in "Equipment."*

## Sentient Magic Items

Some magic items have sentience and personality. Such an item might be possessed, haunted by the spirit of a previous owner, or self-aware thanks to the magic used to create it. A sentient item might be a cherished ally to its wielder or a continual thorn in the side.
Most sentient items are weapons, but other kinds of items can manifest sentience. Single-use items such as potions and scrolls are never sentient.
The GM controls sentient magic items and their activated properties. A bearer who maintains a good relationship with the item can access those properties. If the relationship is strained, a conflict can ensue (see “Conflict” below).

### Sentient Magic Item Traits

When you make a sentient magic item, you create the item's persona much as you would create an NPC, with these exceptions.

#### Abilities

A sentient magic item has Intelligence, Wisdom, and Charisma scores. Choose the item's abilities, or determine them randomly as follows: roll 4d6 for each one, dropping the lowest roll and totaling the rest.

#### Alignment

A sentient magic item has an alignment. Its creator or nature might suggest an alignment. Otherwise, pick an alignment or roll on the Sentient Item's Alignment table.

#### Communication

A sentient item communicates by sharing its emotions, broadcasting its thoughts telepathically, or speaking aloud. You can choose how it communicates or roll on the Sentient Item's Communication table.

#### Senses

A sentient item can perceive its surroundings out to a limited range. You can choose its senses or roll on the Sentient Item's Senses table.

System Reference Document 5.2.1

***

208

### Special Purpose

You can give a sentient item an objective it pursues, perhaps to the exclusion of all else. As long as the wielder's use of the item aligns with that special purpose, the item remains cooperative. Deviating from this course might cause conflict between the wielder and the item (see "Conflict” below). You can pick a special purpose or roll on the Sentient Item's Special Purpose table.

**Sentient Item's Alignment**

| 1d100 | Alignment | 1d100 | Alignment |
| :--- | :--- | :--- | :--- |
| 01–15 | Lawful Good | 74–85 | Chaotic Neutral |
| 16–35 | Neutral Good | 86–89 | Lawful Evil |
| 36–50 | Chaotic Good | 90–96 | Neutral Evil |
| 51–63 | Lawful Neutral | 97–00 | Chaotic Evil |
| 64–73 | Neutral | | |

**Sentient Item's Communication**

| 1d10 | Communication |
| :--- | :--- |
| 1–6 | The item communicates by transmitting emotion to the creature carrying or wielding it. |
| 7–9 | The item speaks one or more languages. |
| 10 | The item speaks one or more languages. In addition, the item can communicate telepathically with any creature that carries or wields it. |

**Sentient Item's Senses**

| 1d4 | Senses |
| :--- | :--- |
| 1 | Hearing and standard vision out to 30 feet |
| 2 | Hearing and standard vision out to 60 feet |
| 3 | Hearing and standard vision out to 120 feet |
| 4 | Hearing and Darkvision out to 120 feet |

**Sentient Item's Special Purpose**

| 1d10 | Special Purpose |
| :--- | :--- |
| 1 | **Aligned.** The item seeks to defeat or destroy those of a diametrically opposed alignment. Such an item is never Neutral. |
| 2 | **Bane.** The item seeks to thwart or destroy creatures of a particular type, such as Constructs, Fiends, or Undead. |
| 3 | **Creator Seeker.** The item seeks its creator and wants to understand why it was created. |
| 4 | **Destiny Seeker.** The item believes it and its bearer have key roles to play in future events. |
| 5 | **Destroyer.** The item craves destruction and goads its user to fight arbitrarily. |
| 6 | **Glory Seeker.** The item seeks renown as the greatest magic item in the world by winning fame or notoriety for its user. |
| 7 | **Lore Seeker.** The item craves knowledge or is determined to solve a mystery, learn a secret, or unravel a cryptic prophecy. |
| 8 | **Protector.** The item seeks to defend a particular kind of creature, such as elves or werewolves. |
| 9 | **Soulmate Seeker.** The item seeks another sentient magic item, perhaps one that is similar to itself. |
| 10 | **Templar.** The item seeks to defend the servants and interests of a particular deity. |

### Conflict

When the bearer of a sentient item acts in a manner opposed to the item's alignment or purpose, conflict can arise. When such a conflict occurs, the item's bearer makes a Charisma saving throw (DC 12 plus the item's Charisma modifier). On a failed save, the item makes one or more of the following demands:

**Chase My Dreams.** The item demands that its bearer pursue the item's goals to the exclusion of all other goals.
**Get Rid of It.** The item demands that its bearer dispose of anything the item finds repugnant.
**It's Time for a Change.** The item demands to be given to someone else.
**Keep Me Close.** The item insists on being carried or worn at all times.

If its bearer refuses to comply with the item's demands, the item can do any of the following:

*   Make it impossible for its bearer to attune to it.
*   Suppress one or more of its activated properties.
*   Attempt to take control of its bearer, whereupon the bearer makes a Charisma saving throw (DC 12 plus the item's Charisma modifier). On a failed save, the bearer has the Charmed condition for 1d12 hours. While Charmed in this way, the bearer must try to follow the item's commands. If the bearer takes damage, it repeats the save, ending the effect on a success. Whether or not the attempt to control its bearer succeeds, the item can't use this power again until the next dawn.

System Reference Document 5.2.1

***

209

# Magic Items A–Z

Magic items are presented in alphabetical order.
If a magic item description capitalizes a creature's name and presents it in **bold type**, that's a visual cue pointing you to the creature's stat block. Unless the text states otherwise, the stat block is in "Monsters." How to read and use a stat block is explained in "Monsters."

### Adamantine Armor

*Armor (Any Medium or Heavy, Except Hide Armor), Uncommon*

This suit of armor is reinforced with adamantine, one of the hardest substances in existence. While you're wearing it, any Critical Hit against you becomes a normal hit.

### Ammunition, +1, +2, or +3

*Weapon (Any Ammunition), Uncommon (+1), Rare (+2), or Very Rare (+3)*

You have a bonus to attack rolls and damage rolls made with this piece of magic ammunition. The bonus is determined by the rarity of the ammunition. Once it hits a target, the ammunition is no longer magical.
This ammunition is typically found or sold in quantities of ten or twenty pieces. Ten pieces of this ammunition are equivalent in value to a potion of the same rarity.

### Ammunition of Slaying

*Weapon (Any Ammunition), Very Rare*

This magic ammunition is meant to slay creatures of a particular type, which the GM chooses or determines randomly by rolling on the table below. If a creature of that type takes damage from the ammunition, the creature makes a DC 17 Constitution saving throw, taking an extra 6d10 Force damage on a failed save or half as much extra damage on a successful one.
After dealing its extra damage to a creature, the ammunition becomes nonmagical.

| 1d100 | Creature Type | 1d100 | Creature Type |
| :--- | :--- | :--- | :--- |
| 01–10 | Aberrations | 51–60 | Fey |
| 11–15 | Beasts | 61–70 | Fiends |
| 16–20 | Celestials | 71–75 | Giants |
| 21–25 | Constructs | 76–80 | Monstrosities |
| 26–35 | Dragons | 81–85 | Oozes |
| 36–45 | Elementals | 86–90 | Plants |
| 46–50 | Humanoids | 91–00 | Undead |

### Amulet of Health

*Wondrous Item, Rare (Requires Attunement)*

Your Constitution is 19 while you wear this amulet. It has no effect on you if your Constitution is 19 or higher without it.

### Amulet of Proof against Detection and Location

*Wondrous Item, Uncommon (Requires Attunement)*

While wearing this amulet, you can't be targeted by Divination spells or perceived through magical scrying sensors unless you allow it.

### Amulet of the Planes

*Wondrous Item, Very Rare (Requires Attunement)*

While wearing this amulet, you can take a Magic action to name a location that you are familiar with on another plane of existence. Then make a DC 15 Intelligence (Arcana) check. On a successful check, you cast *Plane Shift*. On a failed check, you and each creature and object within 15 feet of you travel to a random destination determined by rolling 1d100 and consulting the following table.

| 1d100 | Destination |
| :--- | :--- |
| 01–60 | Random location on the plane you named |
| 61–70 | Random location on an Inner Plane determined by rolling 1d6: on a 1, the Plane of Air; on a 2, the Plane of Earth; on a 3, the Plane of Fire; on a 4, the Plane of Water; on a 5, the Feywild; on a 6, the Shadowfell |
| 71–80 | Random location on an Outer Plane determined by rolling 1d8: on a 1, Arborea; on a 2, Arcadia; on a 3, the Beastlands; on a 4, Bytopia; on a 5, Elysium; on a 6, Mechanus; on a 7, Mount Celestia; on an 8, Ysgard |
| 81–90 | Random location on an Outer Plane determined by rolling 1d8: on a 1, the Abyss; on a 2, Acheron; on a 3, Carceri; on a 4, Gehenna; on a 5, Hades; on a 6, Limbo; on a 7, the Nine Hells; on an 8, Pandemonium |
| 91–00 | Random location on the Astral Plane |

### Animated Shield

*Armor (Shield), Very Rare (Requires Attunement)*

While holding this Shield, you can take a Bonus Action to cause it to animate. The Shield leaps into the air and hovers in your space to protect you as if you were wielding it, leaving your hands free. The Shield remains animate for 1 minute, until you take a Bonus Action to end this effect, or until you die or have the Incapacitated condition, at which point the Shield falls to the ground or into your hand if you have one free.

System Reference Document 5.2.1

***

210

### Apparatus of the Crab

*Wondrous Item, Legendary*

This item first appears to be a sealed iron barrel weighing 500 pounds. The barrel has a hidden catch, which can be found with a successful DC 20 Intelligence (Investigation) check. Releasing the catch unlocks a hatch at one end of the barrel, allowing two Medium or smaller creatures to crawl inside. Ten levers are set in a row at the far end, each in a neutral position, able to move up or down. When certain levers are used, the apparatus transforms to resemble a giant lobster.
The *Apparatus of the Crab* is a Large object with the following statistics: AC 20; HP 200; Speed 30 ft., Swim 30 ft. (or 0 ft. for both if the legs aren't extended); Immunity to Poison and Psychic damage.
To be used as a vehicle, the apparatus requires one pilot. While the apparatus's hatch is closed, the compartment is airtight and watertight. The compartment holds enough air for 10 hours of breathing, divided by the number of breathing creatures inside.
The apparatus floats on water. It can also go underwater to a depth of 900 feet. Below that, the vehicle takes 2d6 Bludgeoning damage each minute from pressure.
A creature in the compartment can take a Utilize action to move as many as two of the apparatus's levers up or down. After each use, a lever goes back to its neutral position. Each lever, from left to right, functions as shown in the Apparatus of the Crab Levers table.

**Apparatus of the Crab Levers**

| Lever | Up | Down |
| :--- | :--- | :--- |
| 1 | Legs extend, allowing the apparatus to walk and swim. | Legs retract, reducing the apparatus's Speed and Swim Speed to 0 and making it unable to benefit from bonuses to speed. |
| 2 | Forward window shutter opens. | Forward window shutter closes. |
| 3 | Side window shutters open (two per side). | Side window shutters close (two per side). |
| 4 | Two claws extend from the front side of the apparatus. | The claws retract. |
| 5 | Each extended claw makes the following melee attack: +8 to hit, reach 5 ft. Hit: 7 (2d6) Bludgeoning damage. | Each extended claw makes the following melee attack: +8 to hit, reach 5 ft. Hit: The target has the Grappled condition (escape DC 15). |
| 6 | The apparatus walks or swims forward provided its legs are extended. | The apparatus walks or swims backward provided its legs are extended. |
| 7 | The apparatus turns 90 degrees counterclockwise provided its legs are extended. | The apparatus turns 90 degrees clockwise provided its legs are extended. |
| 8 | Eyelike fixtures emit Bright Light in a 30-foot radius and Dim Light for an additional 30 feet. | The light turns off. |
| 9 | The apparatus sinks up to 20 feet if it's in liquid. | The apparatus rises up to 20 feet if it's in liquid. |
| 10 | The rear hatch unseals and opens. | The rear hatch closes and seals. |

### Armor, +1, +2, or +3

*Armor (Any Light, Medium, or Heavy), Rare (+1), Very Rare (+2), or Legendary (+3)*

You have a bonus to Armor Class while wearing this armor. The bonus is determined by its rarity.

### Armor of Invulnerability

*Armor (Plate Armor), Legendary (Requires Attunement)*

You have Resistance to Bludgeoning, Piercing, and Slashing damage while you wear this armor.
**Metal Shell.** You can take a Magic action to give yourself Immunity to Bludgeoning, Piercing, and Slashing damage for 10 minutes or until you are no longer wearing the armor. Once this property is used, it can't be used again until the next dawn.

### Armor of Resistance

*Armor (Any Light, Medium, or Heavy), Rare (Requires Attunement)*

You have Resistance to one type of damage while you wear this armor. The GM chooses the type or determines it randomly by rolling on the following table.

| 1d10 | Damage Type | 1d10 | Damage Type |
| :--- | :--- | :--- | :--- |
| 1 | Acid | 6 | Necrotic |
| 2 | Cold | 7 | Poison |
| 3 | Fire | 8 | Psychic |
| 4 | Force | 9 | Radiant |
| 5 | Lightning | 10 | Thunder |

System Reference Document 5.2.1

***

211

### Armor of Vulnerability

*Armor (Any Light, Medium, or Heavy), Rare (Requires Attunement)*

While wearing this armor, you have Resistance to one of the following damage types: Bludgeoning, Piercing, or Slashing. The GM chooses the type or determines it randomly.
**Curse.** This armor is cursed, a fact that is revealed only when the *Identify* spell is cast on the armor or you attune to it. Attuning to the armor curses you until you are targeted by a *Remove Curse* spell or similar magic; removing the armor fails to end the curse. While cursed, you have Vulnerability to two of the three damage types associated with the armor (not the one to which it grants Resistance).

### Arrow-Catching Shield

*Armor (Shield), Rare (Requires Attunement)*

You gain a +2 bonus to Armor Class against ranged attack rolls while you wield this Shield. This bonus is in addition to the Shield's normal bonus to AC.
Whenever an attacker makes a ranged attack roll against a target within 5 feet of you, you can take a Reaction to become the target of the attack instead.

### Bag of Beans

*Wondrous Item, Rare*

This heavy cloth bag contains 3d4 dry beans when found. The bag weighs half a pound regardless of how many beans it contains and becomes a nonmagical item when it no longer contains any beans.
If you dump one or more beans out of the bag, they explode in a 10-foot-radius Sphere centered on them. All the dumped beans are destroyed in the explosion, and each creature in the Sphere, including you, makes a DC 15 Dexterity saving throw, taking 5d4 Force damage on a failed save or half as much damage on a successful one.
If you remove a bean from the bag, plant it in dirt or sand, and then water it, the bean disappears as it produces an effect 1 minute later from the ground where it was planted. The GM can choose an effect from the following table or determine it randomly.

| 1d100 | Effect |
| :--- | :--- |
| 01 | 5d4 toadstools sprout. If a creature eats a toadstool, roll any die. On an odd roll, the eater must succeed on a DC 15 Constitution saving throw or take 5d6 Poison damage and have the Poisoned condition for 1 hour. On an even roll, the eater gains 5d6 Temporary Hit Points for 1 hour. |
| 02–10 | A geyser erupts and spouts water, beer, mayonnaise, tea, vinegar, wine, or oil (GM's choice) 30 feet into the air for 1d4 minutes. |
| 11–20 | A **Treant** sprouts. Roll any die. On an odd roll, the treant is Chaotic Evil. On an even roll, the treant is Chaotic Good. |
| 21–30 | An animate but immobile stone statue in your likeness rises and makes verbal threats against you. If you leave it and others come near, it describes you as the most heinous of villains and directs the newcomers to find and attack you. If you are on the same plane of existence as the statue, it knows where you are. The statue becomes inanimate after 24 hours. |
| 31–40 | A campfire with green flames springs forth and burns for 24 hours or until it is extinguished. |
| 41–50 | Three **Shrieker Fungi** sprout. |
| 51–60 | 1d4 + 4 bright-pink toads crawl forth. Whenever a toad is touched, it transforms into a Large or smaller monster of the GM's choice that acts in accordance with its alignment and nature. The monster remains for 1 minute, then disappears in a puff of bright-pink smoke. |
| 61–70 | A hungry **Bulette** burrows up and attacks. |
| 71–80 | A fruit tree grows. It has 1d10 + 20 fruit, 1d8 of which act as randomly determined potions. The tree vanishes after 1 hour. Picked fruit remains, retaining any magic for 30 days. |
| 81–90 | A nest of 1d4 + 3 rainbow-colored eggs springs up. Any creature that eats an egg makes a DC 20 Constitution saving throw. On a successful save, a creature permanently increases its lowest ability score by 1, randomly choosing among equally low scores. On a failed save, the creature takes 10d6 Force damage from an internal explosion. |
| 91–95 | A pyramid with a 60-foot-square base bursts upward. Inside is a burial chamber containing a **Mummy**, a **Mummy Lord**, or some other Undead of the GM's choice. Its sarcophagus contains treasure of the GM's choice. |
| 96–00 | A giant beanstalk sprouts, growing to a height of the GM's choice. The top leads where the GM chooses, such as to a great view, a cloud giant's castle, or another plane of existence. |

System Reference Document 5.2.1

***

212

### Bag of Devouring

*Wondrous Item, Very Rare*

This bag resembles a *Bag of Holding* but is a feeding orifice for a gigantic extradimensional creature. Turning the bag inside out closes the orifice.
The extradimensional creature attached to the bag can sense whatever is placed inside the bag. Animal or vegetable matter placed wholly in the bag is devoured and lost forever. When part of a living creature is placed in the bag, as happens when someone reaches inside it, there is a 50 percent chance that the creature is pulled inside the bag. A creature inside the bag can take an action to try to escape, doing so with a successful DC 15 Strength (Athletics) check. Another creature can take an action to reach into the bag to pull a creature out, doing so with a successful DC 20 Strength (Athletics) check, provided the puller isn't pulled inside the bag first. Any creature that starts its turn inside the bag is devoured, its body destroyed.
Inanimate objects can be stored in the bag, which can hold a cubic foot of such material. However, once each day, the bag swallows any objects inside it and spits them out into another plane of existence. The GM determines the time and plane.
If the bag is pierced or torn, it is destroyed, and anything contained within it is transported to a random location on the Astral Plane.

### Bag of Holding

*Wondrous Item, Uncommon*

This bag has an interior space considerably larger than its outside dimensions—roughly 2 feet square and 4 feet deep on the inside. The bag can hold up to 500 pounds, not exceeding a volume of 64 cubic feet. The bag weighs 5 pounds, regardless of its contents. Retrieving an item from the bag requires a Utilize action.
If the bag is overloaded, pierced, or torn, it is destroyed, and its contents are scattered in the Astral Plane. If the bag is turned inside out, its contents spill forth unharmed, but the bag must be put right before it can be used again. The bag holds enough air for 10 minutes of breathing, divided by the number of breathing creatures inside.
Placing a *Bag of Holding* inside an extradimensional space created by a *Handy Haversack*, *Portable Hole*, or similar item instantly destroys both items and opens a gate to the Astral Plane. The gate originates where the one item was placed inside the other. Any creature within a 10-foot-radius Sphere centered on the gate is sucked through it to a random location on the Astral Plane. The gate then closes. The gate is one-way and can't be reopened.

### Bag of Tricks

*Wondrous Item, Uncommon*

This bag made from gray, rust, or tan cloth appears empty. Reaching inside the bag, however, reveals the presence of a small, fuzzy object.
You can take a Magic action to pull the fuzzy object from the bag and throw it up to 20 feet. When the object lands, it transforms into a creature you determine by rolling on the table that corresponds to the bag's color. See "Monsters" for the creature's stat block. The creature vanishes at the next dawn or when it is reduced to 0 Hit Points.
The creature is Friendly to you and your allies, and it acts immediately after you on your Initiative count. You can take a Bonus Action to command how the creature moves and what action it takes on its next turn, such as attacking an enemy. In the absence of such orders, the creature acts in a fashion appropriate to its nature.
Once three fuzzy objects have been pulled from the bag, the bag can't be used again until the next dawn.

**Gray Bag of Tricks**

| 1d8 | Creature | 1d8 | Creature |
| :--- | :--- | :--- | :--- |
| 1 | **Weasel** | 5 | **Panther** |
| 2 | **Giant Rat** | 6 | **Giant Badger** |
| 3 | **Badger** | 7 | **Dire Wolf** |
| 4 | **Boar** | 8 | **Giant Elk** |

**Rust Bag of Tricks**

| 1d8 | Creature | 1d8 | Creature |
| :--- | :--- | :--- | :--- |
| 1 | **Rat** | 5 | **Giant Goat** |
| 2 | **Owl** | 6 | **Giant Boar** |
| 3 | **Mastiff** | 7 | **Lion** |
| 4 | **Goat** | 8 | **Brown Bear** |

**Tan Bag of Tricks**

| 1d8 | Creature | 1d8 | Creature |
| :--- | :--- | :--- | :--- |
| 1 | **Jackal** | 5 | **Black Bear** |
| 2 | **Ape** | 6 | **Giant Weasel** |
| 3 | **Baboon** | 7 | **Giant Hyena** |
| 4 | **Axe Beak** | 8 | **Tiger** |

### Bead of Force

*Wondrous Item, Rare*

This small black sphere measures 3/4 of an inch in diameter and weighs an ounce. Typically, 1d4 + 4 *Beads of Force* are found together.
You can take a Magic action to throw the bead up to 60 feet. The bead explodes in a 10-foot-radius Sphere on impact and is destroyed. Each creature

System Reference Document 5.2.1

***

213

in the Sphere must succeed on a DC 15 Dexterity saving throw or take 5d4 Force damage. A sphere of transparent force then encloses the area for 1 minute. Any creature that failed the save and is completely within the area is trapped inside this sphere. Creatures that succeeded on the save or are partially within the area are pushed away from the center of the sphere until they are no longer inside it. Only breathable air can pass through the sphere's wall. No attack or other effect can pass through.
An enclosed creature can take a Utilize action to push against the sphere's wall, moving the sphere up to half the creature's Speed. The sphere can be picked up, and its magic causes it to weigh only 1 pound, regardless of the weight of creatures inside.

### Bead of Nourishment

*Wondrous Item, Common*

This flavorless, gelatinous bead dissolves on your tongue and provides as much nourishment as 1 day of Rations.

### Belt of Dwarvenkind

*Wondrous Item, Rare (Requires Attunement)*

While wearing this belt, you gain the following benefits:
**Dwarvish.** You know Dwarvish.
**Friend of Dwarvenkind.** You have Advantage on Charisma (Persuasion) checks made to interact with dwarves and duergar.
**Toughness.** Your Constitution increases by 2, to a maximum of 20.
In addition, while attuned to the belt, you have a 50 percent chance each day at dawn of growing a full beard if you can grow one, or a thicker beard if you already have one.
If you aren't a dwarf or duergar, you gain the following additional benefits while wearing the belt:
**Darkvision.** You have Darkvision with a range of 60 feet.
**Resilience.** You have Resistance to Poison damage. You also have Advantage on saving throws you make to avoid or end the Poisoned condition.

### Belt of Giant Strength

*Wondrous Item, Rarity Varies (Requires Attunement)*

While wearing this belt, your Strength changes to a score granted by the belt. The type of giant determines the score (see the table below). The item has no effect on you if your Strength without the belt is equal to or greater than the belt's score.

| Belt | Str. | Rarity |
| :--- | :--- | :--- |
| Belt of Giant Strength (hill) | 21 | Rare |
| Belt of Giant Strength (frost or stone) | 23 | Very Rare |
| Belt of Giant Strength (fire) | 25 | Very Rare |
| Belt of Giant Strength (cloud) | 27 | Legendary |
| Belt of Giant Strength (storm) | 29 | Legendary |

### Berserker Axe

*Weapon (Battleaxe, Greataxe, or Halberd), Rare (Requires Attunement)*

You gain a +1 bonus to attack rolls and damage rolls made with this magic weapon. In addition, while you are attuned to this weapon, your Hit Point maximum increases by 1 for each level you have attained.
**Curse.** This weapon is cursed, and becoming attuned to it extends the curse to you. As long as you remain cursed, you are unwilling to part with the weapon, keeping it within reach at all times. You also have Disadvantage on attack rolls with weapons other than this one.
Whenever another creature damages you while the weapon is in your possession, you must succeed on a DC 15 Wisdom saving throw or go berserk. This berserk state ends when you start your turn and there are no creatures within 60 feet of you that you can see or hear.
While berserk, you regard the creature nearest to you that you can see or hear as your enemy. If there are multiple possible creatures, choose one at random. On each of your turns, you must move as close to the creature as possible and take the Attack action, targeting the creature. If you're unable to get close enough to the creature to attack it with the weapon, your turn ends after you've used up all your available movement. If the creature dies or can no longer be seen or heard by you, the next nearest creature that you can see or hear becomes your new target.

### Boots of Elvenkind

*Wondrous Item, Uncommon*

While you wear these boots, your steps make no sound, regardless of the surface you are moving across. You also have Advantage on Dexterity (Stealth) checks.

### Boots of Levitation

*Wondrous Item, Rare (Requires Attunement)*

While you wear these boots, you can cast *Levitate* on yourself.

System Reference Document 5.2.1

***

214

### Boots of Speed

*Wondrous Item, Rare (Requires Attunement)*

While you wear these boots, you can take a Bonus Action to click the boots' heels together. If you do, the boots double your Speed, and any creature that makes an Opportunity Attack against you has Disadvantage on the attack roll. If you click your heels together again, you end the effect.
When you've used the boots' property for a total of 10 minutes, the magic ceases to function for you until you finish a Long Rest.

### Boots of Striding and Springing

*Wondrous Item, Uncommon (Requires Attunement)*

While you wear these boots, your Speed becomes 30 feet unless your Speed is higher, and your Speed isn't reduced by you carrying weight in excess of your carrying capacity or wearing Heavy Armor.
Once on each of your turns, you can jump up to 30 feet by spending only 10 feet of movement.

### Boots of the Winterlands

*Wondrous Item, Uncommon (Requires Attunement)*

These furred boots are snug and feel warm. While wearing them, you gain the following benefits.
**Cold Resistance.** You have Resistance to Cold damage and can tolerate temperatures of 0 degrees Fahrenheit or lower without any additional protection.
**Winter Strider.** You ignore Difficult Terrain created by ice or snow.

### Bowl of Commanding Water Elementals

*Wondrous Item, Rare*

While this bowl is filled with water and you are within 5 feet of it, you can take a Magic action to summon a **Water Elemental**. The elemental appears in an unoccupied space as close to the bowl as possible, understands your languages, obeys your commands, and takes its turn immediately after you on your Initiative count. The elemental disappears after 1 hour, when it dies, or when you dismiss it as a Bonus Action. The bowl can't be used this way again until the next dawn.
The bowl is about 1 foot in diameter and half as deep. It holds about 3 gallons.

### Bracers of Archery

*Wondrous Item, Uncommon (Requires Attunement)*

While wearing these bracers, you have proficiency with the Longbow and Shortbow, and you gain a +2 bonus to damage rolls made with such weapons.

### Bracers of Defense

*Wondrous Item, Rare (Requires Attunement)*

While wearing these bracers, you gain a +2 bonus to Armor Class if you are wearing no armor and using no Shield.

### Brazier of Commanding Fire Elementals

*Wondrous Item, Rare*

While you are within 5 feet of this brazier, you can take a Magic action to summon a **Fire Elemental**. The elemental appears in an unoccupied space as close to the brazier as possible, understands your languages, obeys your commands, and takes its turn immediately after you on your Initiative count. The elemental disappears after 1 hour, when it dies, or when you dismiss it as a Bonus Action. The brazier can't be used this way again until the next dawn.

### Brooch of Shielding

*Wondrous Item, Uncommon (Requires Attunement)*

While wearing this brooch, you have Resistance to Force damage, and you have Immunity to damage from the *Magic Missile* spell.

### Broom of Flying

*Wondrous Item, Uncommon (Requires Attunement)*

This wooden broom functions like a mundane broom until you stand astride it and take a Magic action to make it hover beneath you, at which time it can be ridden in the air. It has a Fly Speed of 50 feet. It can carry up to 400 pounds, but its Fly Speed becomes 30 feet while carrying over 200 pounds. The broom stops hovering when you land or when you're no longer riding it.
As a Magic action, you can send the broom to travel alone to a destination within 1 mile of you if you name the location and are familiar with it. The broom comes back to you when you take a Magic action and use a command word if the broom is still within 1 mile of you.

### Candle of Invocation

*Wondrous Item, Very Rare (Requires Attunement)*

This candle's magic is activated when the candle is lit, which requires a Magic action. After burning for 4 hours, the candle is destroyed. You can snuff it out early for use at a later time. Deduct the time it burned in increments of 1 minute from its total burn time.
While lit, the candle sheds Dim Light in a 30-foot radius. While you are within that light, you have Advantage on D20 Tests. In addition, a Cleric or Druid in the light can cast level 1 spells they have prepared without expending spell slots.
Alternatively, when you light the candle for the first time, you can cast *Gate* with it. Doing so destroys the candle. The portal created by the spell

System Reference Document 5.2.1

***

215

links to a particular Outer Plane chosen by the GM or determined by rolling on the following table.

| 1d100 | Outer Plane | 1d100 | Outer Plane |
| :--- | :--- | :--- | :--- |
| 01–05 | Abyss | 55–59 | Gehenna |
| 06–10 | Acheron | 60–64 | Hades |
| 11–17 | Arborea | 65–69 | Limbo |
| 18–25 | Arcadia | 70–77 | Mechanus |
| 26–33 | Beastlands | 78–85 | Mount Celestia |
| 34–41 | Bytopia | 86–90 | Nine Hells |
| 42–46 | Carceri | 91–95 | Pandemonium |
| 47–54 | Elysium | 96–00 | Ysgard |

### Cape of the Mountebank

*Wondrous Item, Rare*

This cape smells faintly of brimstone. While wearing it, you can use it to cast *Dimension Door* as a Magic action. This property can't be used again until the next dawn.
When you teleport with that spell, you leave behind a cloud of smoke. The space you left is Lightly Obscured by that smoke until the end of your next turn.

### Carpet of Flying

*Wondrous Item, Very Rare*

You can make this carpet hover and fly by taking a Magic action and using the carpet's command word. It moves according to your directions if you are within 30 feet of it.
Four sizes of *Carpet of Flying* exist. The GM chooses the size of a given carpet or determines it randomly by rolling on the following table. A carpet can carry up to twice the weight shown on the table, but its Fly Speed is halved if it carries more than its normal capacity.

| 1d100 | Size | Capacity | Fly Speed |
| :--- | :--- | :--- | :--- |
| 01–20 | 3 ft. × 5 ft. | 200 lb. | 80 feet |
| 21–55 | 4 ft. × 6 ft. | 400 lb. | 60 feet |
| 56–80 | 5 ft. × 7 ft. | 600 lb. | 40 feet |
| 81–00 | 6 ft. × 9 ft. | 800 lb. | 30 feet |

### Censer of Controlling Air Elementals

*Wondrous Item, Rare*

While gently swinging this censer, you can take a Magic action to summon an **Air Elemental**. The elemental appears in an unoccupied space as close to the censer as possible, understands your languages, obeys your commands, and takes its turn immediately after you on your Initiative count. The elemental disappears after 1 hour, when it dies, or when you dismiss it as a Bonus Action. The censer can't be used this way again until the next dawn.

### Chime of Opening

*Wondrous Item, Rare*

This hollow metal tube measures about 1 foot long and weighs 1 pound. As a Magic action, you can strike the chime to cast *Knock*. The spell's customary knocking sound is replaced by the clear, ringing tone of the chime, which is audible out to 300 feet.
The chime can be used 10 times. After the tenth time, it cracks and becomes useless.

### Circlet of Blasting

*Wondrous Item, Uncommon*

While wearing this circlet, you can cast *Scorching Ray* with it (+5 to hit). The circlet can't cast this spell again until the next dawn.

### Cloak of Arachnida

*Wondrous Item, Very Rare (Requires Attunement)*

This fine garment is made of black silk interwoven with faint, silvery threads. While wearing it, you gain the following benefits.
**Poison Resistance.** You have Resistance to Poison damage.
**Spider Climb.** You have a Climb Speed equal to your Speed and can move up, down, and across vertical surfaces and along ceilings, while leaving your hands free.
**Spider Walk.** You can't be caught in webs of any sort and can move through webs as if they were Difficult Terrain.
**Web.** You can cast *Web* (save DC 13). The web created by the spell fills twice its normal area. Once used, this property can't be used again until the next dawn.

### Cloak of Displacement

*Wondrous Item, Rare (Requires Attunement)*

While you wear this cloak, it magically projects an illusion that makes you appear to be standing in a place near your actual location, causing any creature to have Disadvantage on attack rolls against you. If you take damage, the property ceases to function until the start of your next turn. This property is suppressed while your Speed is 0.

### Cloak of Elvenkind

*Wondrous Item, Uncommon (Requires Attunement)*

While you wear this cloak, Wisdom (Perception) checks made to perceive you have Disadvantage, and you have Advantage on Dexterity (Stealth) checks.

### Cloak of Invisibility

*Wondrous Item, Legendary (Requires Attunement)*

This cloak has 3 charges and regains 1d3 expended charges daily at dawn. While wearing the cloak, you can take a Magic action to pull its hood over your

System Reference Document 5.2.1

***

216

head and expend 1 charge to give yourself the Invisible condition for 1 hour. The effect ends early if you pull the hood down (no action required) or cease wearing the cloak.

### Cloak of Protection

*Wondrous Item, Uncommon (Requires Attunement)*

You gain a +1 bonus to Armor Class and saving throws while you wear this cloak.

### Cloak of the Bat

*Wondrous Item, Rare (Requires Attunement)*

While wearing this cloak, you have Advantage on Dexterity (Stealth) checks. In an area of Dim Light or Darkness, you can grip the edges of the cloak and use it to gain a Fly Speed of 40 feet. If you ever fail to grip the cloak's edges while flying in this way, or if you are no longer in Dim Light or Darkness, you lose this Fly Speed.
While wearing the cloak in an area of Dim Light or Darkness, you can cast *Polymorph* on yourself, shape-shifting into a **Bat**. While in that form, you retain your Intelligence, Wisdom, and Charisma scores. The cloak can't be used this way again until the next dawn.

### Cloak of the Manta Ray

*Wondrous Item, Uncommon (Requires Attunement)*

While wearing this cloak, you can breathe underwater, and you have a Swim Speed of 60 feet.

### Crystal Ball

*Wondrous Item, Very Rare (Requires Attunement)*

While touching this crystal orb, you can cast *Scrying* (save DC 17) with it.

### Crystal Ball of Mind Reading

*Wondrous Item, Legendary (Requires Attunement)*

While touching this crystal orb, you can cast *Scrying* (save DC 17) with it. In addition, you can cast *Detect Thoughts* (save DC 17) targeting creatures you can see within 30 feet of the spell's sensor. You don't need to concentrate on this *Detect Thoughts* spell to maintain it during its duration, but it ends if the *Scrying* spell ends.

### Crystal Ball of Telepathy

*Wondrous Item, Legendary (Requires Attunement)*

While touching this crystal orb, you can cast *Scrying* (save DC 17) with it. In addition, you can communicate telepathically with creatures you can see within 30 feet of the spell's sensor. You can also cast *Suggestion* (save DC 17) through the sensor on one of those creatures. You don't need to concentrate on this *Suggestion* to maintain it during its duration, but it ends if *Scrying* ends. You can't cast *Suggestion* in this way again until the next dawn.

### Crystal Ball of True Seeing

*Wondrous Item, Legendary (Requires Attunement)*

While touching this crystal orb, you can cast *Scrying* (save DC 17) with it. In addition, you have Truesight with a range of 120 feet centered on the spell's sensor.

### Cube of Force

*Wondrous Item, Rare (Requires Attunement)*

This cube is about an inch across. Each face has a distinct marking on it. You can press one of those faces, expend the number of charges required for it, and thereby cast the spell associated with it (save DC 17), as shown in the Cube of Force Faces table.
The cube starts with 10 charges, and it regains 1d6 expended charges daily at dawn.

**Cube of Force Faces**

| Spell | Charge Cost |
| :--- | :--- |
| *Mage Armor* | 1 |
| *Shield* | 1 |
| *Tiny Hut* | 3 |
| *Private Sanctum* | 4 |
| *Resilient Sphere* | 4 |
| *Wall of Force* | 5 |

### Cubic Gate

*Wondrous Item, Legendary*

This cube is 3 inches across and radiates palpable magical energy. The six sides of the cube are each keyed to a different plane of existence, one of which is the Material Plane. The other sides are linked to planes determined by the GM.
The cube has 3 charges and regains 1d3 expended charges daily at dawn. As a Magic action, you can expend 1 of the cube's charges to cast one of the following spells using the cube.
**Gate.** Pressing one side of the cube, you cast *Gate*, opening a portal to the plane of existence keyed to that side.
**Plane Shift.** Pressing one side of the cube twice, you cast *Plane Shift*, transporting the targets to the plane of existence keyed to that side.

### Dagger of Venom

*Weapon (Dagger), Rare*

You gain a +1 bonus to attack rolls and damage rolls made with this magic weapon.
You can take a Bonus Action to magically coat the blade with poison. The poison remains for 1 minute or until an attack using this weapon hits a creature. That creature must succeed on a DC 15 Constitution saving throw or take 2d10 Poison damage and have the Poisoned condition for 1 minute. The weapon can't be used this way again until the next dawn.

System Reference Document 5.2.1

***

217

### Dancing Sword

*Weapon (Greatsword, Longsword, Rapier, Scimitar, or Shortsword), Very Rare (Requires Attunement)*

You can take a Bonus Action to toss this magic weapon into the air. When you do so, the weapon begins to hover, flies up to 30 feet, and attacks one creature of your choice within 5 feet of itself. The weapon uses your attack roll and adds your ability modifier to damage rolls.
While the weapon hovers, you can take a Bonus Action to cause it to fly up to 30 feet to another spot within 30 feet of you. As part of the same Bonus Action, you can cause the weapon to attack one creature within 5 feet of the weapon.
After the hovering weapon attacks for the fourth time, it flies back to you and tries to return to your hand. If you have no hand free, the weapon falls to the ground in your space. If the weapon has no unobstructed path to you, it moves as close to you as it can and then falls to the ground. It also ceases to hover if you grasp it or are more than 30 feet away from it.

### Decanter of Endless Water

*Wondrous Item, Uncommon*

This stoppered flask sloshes when shaken, as if it contains water. The decanter weighs 2 pounds.
You can take a Magic action to remove the stopper and issue one of three command words, whereupon an amount of fresh water or salt water (your choice) pours out of the flask. The water stops pouring out at the start of your next turn. Choose from the following command words:

**Splash.** The decanter produces 1 gallon of water.
**Fountain.** The decanter produces 5 gallons of water.
**Geyser.** The decanter produces 30 gallons of water that gushes forth in a Line 30 feet long and 1 foot wide. If you're holding the decanter, you can aim the geyser in one direction (no action required). One creature of your choice in the Line must succeed on a DC 13 Strength saving throw or take 1d4 Bludgeoning damage and have the Prone condition. Instead of a creature, you can target one object in the Line that isn't being worn or carried and that weighs no more than 200 pounds. The object is knocked over by the geyser.

### Deck of Illusions

*Wondrous Item, Uncommon*

This box contains a set of cards. A full deck has 34 cards: 32 depicting specific creatures and two with a mirrored surface. A deck found as treasure is usually missing 1d20 − 1 cards.
The magic of the deck functions only if its cards are drawn at random. You can take a Magic action to draw a card at random from the deck and throw it to the ground at a point within 30 feet of yourself.
An illusion of a creature, determined by rolling on the Deck of Illusions table, forms over the thrown card and remains until dispelled. The illusory creature created by the card looks and behaves like a real creature of its kind, except that it can do no harm. While you are within 120 feet of the illusory creature and can see it, you can take a Magic action to move it anywhere within 30 feet of its card.
Any physical interaction with the illusory creature reveals it to be false, because objects pass through it. A creature that takes a Study action to visually inspect the illusory creature identifies it as an illusion with a successful DC 15 Intelligence (Investigation) check. The illusion lasts until its card is moved or the illusion is dispelled (using a *Dispel Magic* spell or a similar effect). When the illusion ends, the image on its card disappears, and that card can't be used again.

**Deck of Illusions**

| 1d100 | Illusion\* |
| :--- | :--- |
| 01–03 | **Adult Red Dragon** |
| 04–06 | **Archmage** |
| 07–09 | **Assassin** |
| 10–12 | **Bandit Captain** |
| 13–15 | **Basilisk** |
| 16–18 | **Berserker** |
| 19–21 | **Bugbear Warrior** |
| 22–24 | **Cloud Giant** |
| 25–27 | **Druid** |
| 28–30 | **Erinyes** |
| 31–33 | **Ettin** |
| 34–36 | **Fire Giant** |
| 37–39 | **Frost Giant** |
| 40–42 | **Gnoll Warrior** |
| 43–45 | **Goblin Warrior** |
| 46–48 | **Guardian Naga** |
| 49–51 | **Hill Giant** |
| 52–54 | **Hobgoblin Warrior** |
| 55–57 | **Incubus** |
| 58–60 | **Iron Golem** |
| 61–63 | **Knight** |
| 64–66 | **Kobold Warrior** |
| 67–69 | **Lich** |
| 70–72 | **Medusa** |
| 73–75 | **Night Hag** |
| 76–78 | **Ogre** |
| 79–81 | **Oni** |

System Reference Document 5.2.1

***

218

| 1d100 | Illusion\* |
| :--- | :--- |
| 82–84 | **Priest** |
| 85–87 | **Succubus** |
| 88–90 | **Troll** |
| 91–93 | **Veteran Warrior** |
| 94–96 | **Wyvern** |
| 97–00 | The card drawer |

*\*Stat blocks for these creatures (except the card drawer) appear in "Monsters."*

### Defender

*Weapon (Any Melee Weapon), Legendary (Requires Attunement)*

You gain a +3 bonus to attack rolls and damage rolls made with this magic weapon.
The first time you attack with the weapon on each of your turns, you can transfer some or all of the weapon's bonus to your Armor Class. For example, you could reduce the bonus to your attack rolls and damage rolls to +1 and gain a +2 bonus to Armor Class. The adjusted bonuses remain in effect until the start of your next turn, although you must hold the weapon to gain a bonus to AC from it.

### Demon Armor

*Armor (Any Light, Medium, or Heavy), Very Rare (Requires Attunement)*

While wearing this armor, you gain a +1 bonus to Armor Class, and you know Abyssal. In addition, the armor's clawed gauntlets allow your Unarmed Strikes to deal 1d8 Slashing damage instead of the usual Bludgeoning damage, and you gain a +1 bonus to the attack and damage rolls of your Unarmed Strikes.
**Curse.** Once you don this cursed armor, you can't doff it unless you are targeted by a *Remove Curse* spell or similar magic. While wearing the armor, you have Disadvantage on attack rolls against demons and on saving throws against their spells and special abilities.

### Dimensional Shackles

*Wondrous Item, Rare*

You can take a Utilize action to place these shackles on a creature that has the Incapacitated condition. The shackles adjust to fit a creature of Small to Large size. The shackles prevent a creature bound by them from using any method of extradimensional movement, including teleportation or travel to a different plane of existence. They don't prevent the creature from passing through an interdimensional portal.
You and any creature you designate when you use the shackles can take a Utilize action to remove them. Once every 30 days, the bound creature can make a DC 30 Strength (Athletics) check. On a successful check, the creature breaks free and destroys the shackles.

### Dragon Orb

*Wondrous Item, Artifact (Requires Attunement)*

An orb is an etched crystal globe about 10 inches in diameter. When used, it grows to about 20 inches in diameter, and mist swirls inside it.
While attuned to an orb, you can take a Magic action to peer into the orb's depths. You must then make a DC 15 Charisma saving throw. On a successful save, you control the orb for as long as you remain attuned to it. On a failed save, the orb imposes the Charmed condition on you for as long as you remain attuned to it.
While you are Charmed by the orb, you can't voluntarily end your Attunement to it, and the orb casts *Suggestion* on you at will (save DC 18), urging you to work toward the evil ends it desires. The dragon essence within the orb might want many things: the annihilation of a particular society or organization, freedom from the orb, to spread suffering in the world, to advance the worship of Tiamat, or something else the GM decides.
**Spells.** The orb has 7 charges and regains 1d4 + 3 expended charges daily at dawn. If you control the orb, you can cast one of the spells on the following table from it. The table indicates how many charges you must expend to cast the spell.

| Spell | Charge Cost |
| :--- | :--- |
| *Cure Wounds* (level 9 version) | 4 |
| *Daylight* | 1 |
| *Death Ward* | 2 |
| *Detect Magic* | 0 |
| *Scrying* (save DC 18) | 3 |

**Call Dragons.** While you control the orb, you can take a Magic action to cause the orb to issue a telepathic call that extends in all directions for 40 miles. Chromatic dragons in range feel compelled to come to the orb as soon as possible by the most direct route. Dragon deities such as Tiamat are unaffected by this call. Chromatic dragons drawn to the orb might be Hostile toward you for compelling them against their will. Once you have used this property, it can't be used again for 1 hour.
**Destroying an Orb.** A *Dragon Orb* has AC 20 and is destroyed if it takes damage from a +3 Weapon or a *Disintegrate* spell. Nothing else can harm it.

### Dragon Scale Mail

*Armor (Scale Mail), Very Rare (Requires AttunEMENT)*

*Dragon Scale Mail* is made of the scales of one kind of dragon. Sometimes dragons collect their cast-off

System Reference Document 5.2.1

***

219

scales and gift them. Other times, hunters carefully preserve the hide of a dead dragon. In either case, *Dragon Scale Mail* is highly valued.
While wearing this armor, you gain a +1 bonus to Armor Class, you have Advantage on saving throws against the breath weapons of Dragons, and you have Resistance to one damage type determined by the kind of dragon that provided the scales (see the accompanying table).
Additionally, you can focus your senses as a Magic action to discern the distance and direction to the closest dragon within 30 miles of yourself that is of the same type as the armor. This action can't be used again until the next dawn.

| Dragon | Resistance | Dragon | Resistance |
| :--- | :--- | :--- | :--- |
| Black | Acid | Gold | Fire |
| Blue | Lightning | Green | Poison |
| Brass | Fire | Red | Fire |
| Bronze | Lightning | Silver | Cold |
| Copper | Acid | White | Cold |

### Dragon Slayer

*Weapon (Any Simple or Martial), Rare*

You gain a +1 bonus to attack rolls and damage rolls made with this magic weapon.
The weapon deals an extra 3d6 damage of the weapon's type if the target is a Dragon.

### Dust of Disappearance

*Wondrous Item, Uncommon*

This powder resembles fine sand. There is enough of it for one use. When you take a Utilize action to throw the dust into the air, you and each creature and object within a 10-foot Emanation originating from you have the Invisible condition for 2d4 minutes. The duration is the same for all subjects, and the dust is consumed when its magic takes effect. Immediately after an affected creature makes an attack roll, deals damage, or casts a spell, the Invisible condition ends for that creature.

### Dust of Dryness

*Wondrous Item, Uncommon*

This small packet contains 1d6 + 4 pinches of dust. As a Utilize action, you can sprinkle a pinch of the dust over water, turning up to a 15-foot Cube of water into one marble-sized pellet, which floats or rests near where the dust was sprinkled. The pellet's weight is negligible. A creature can take a Utilize action to smash the pellet against a hard surface, causing the pellet to shatter and release the water the dust absorbed. Doing so destroys the pellet and ends its magic.
As a Utilize action, you can sprinkle a pinch of the dust on an Elemental within 5 feet of yourself that is composed mostly of water (such as a **Water Elemental**). Such a creature exposed to a pinch of the dust makes a DC 13 Constitution saving throw, taking 10d6 Necrotic damage on a failed save or half as much damage on a successful one.

### Dust of Sneezing and Choking

*Wondrous Item, Uncommon*

Found in a small container, this powder resembles *Dust of Disappearance*, and *Identify* reveals it to be such. There is enough of it for one use.
As a Utilize action, you can throw the dust into the air, forcing yourself and every creature in a 30-foot Emanation originating from you to make a DC 15 Constitution saving throw. Constructs, Elementals, Oozes, Plants, and Undead succeed on the save automatically.
On a failed save, a creature begins sneezing uncontrollably; it has the Incapacitated condition and is suffocating. The creature repeats the save at the end of each of its turns, ending the effect on itself on a success. The effect also ends on any creature targeted by a *Lesser Restoration* spell.

### Dwarven Plate

*Armor (Half Plate Armor or Plate Armor), Very Rare*

While wearing this armor, you gain a +2 bonus to Armor Class. In addition, if an effect moves you against your will along the ground, you can take a Reaction to reduce the distance you are moved by up to 10 feet.

### Dwarven Thrower

*Weapon (Warhammer), Very Rare (Requires Attunement by a Dwarf or a Creature Attuned to a Belt of Dwarvenkind)*

You gain a +3 bonus to attack rolls and damage rolls made with this magic weapon. It has the Thrown property with a normal range of 20 feet and a long range of 60 feet. When you hit with a ranged attack using this weapon, it deals an extra 1d8 Force damage, or an extra 2d8 Force damage if the target is a Giant. Immediately after hitting or missing, the weapon flies back to your hand.

### Efficient Quiver

*Wondrous Item, Uncommon*

Each of the quiver's three compartments connects to an extradimensional space that allows the quiver to hold numerous items while never weighing more than 2 pounds. The shortest compartment can hold up to 60 Arrows, Bolts, or similar objects. The midsize compartment holds up to 18 Javelins or similar objects. The longest compartment holds up to 6 long objects, such as bows, Quarterstaffs, or Spears.
You can draw any item the quiver contains as if doing so from a regular quiver or scabbard.

System Reference Document 5.2.1

***

220

### Efreeti Bottle

*Wondrous Item, Very Rare*

When you take a Magic action to remove the stopper of this painted brass bottle, a cloud of thick smoke flows out of it. At the end of your turn, the smoke disappears with a flash of harmless fire, and an **Efreeti** appears in an unoccupied space within 30 feet of you.
The first time the bottle is opened, the GM rolls on the following table to determine what happens.

| 1d10 | Effect |
| :--- | :--- |
| 1 | The efreeti attacks you. After fighting for 5 rounds, the efreeti disappears, and the bottle loses its magic. |
| 2–9 | The efreeti understands your languages and obeys your commands for 1 hour, after which it returns to the bottle, and a new stopper contains it. The stopper can't be removed for 24 hours. The next two times the bottle is opened, the same effect occurs. If the bottle is opened a fourth time, the efreeti escapes and disappears, and the bottle loses its magic. |
| 10 | The efreeti understands your languages and can cast *Wish* once for you. It disappears when it grants the wish or after 1 hour, and the bottle loses its magic. |

### Elemental Gem

*Wondrous Item, Uncommon*

This gem contains a mote of elemental energy. When you take a Utilize action to break the gem, an elemental is summoned (see "Monsters" for its stat block), and the gem ceases to be magical. The elemental appears in an unoccupied space as close to the broken gem as possible, understands your languages, obeys your commands, and takes its turn immediately after you on your Initiative count. The elemental disappears after 1 hour, when it dies, or when you dismiss it as a Bonus Action. The type of gem determines the elemental, as shown in the following table.

| Gem | Summoned Elemental |
| :--- | :--- |
| Blue sapphire | Air Elemental |
| Emerald | Water Elemental |
| Red corundum | Fire Elemental |
| Yellow diamond | Earth Elemental |

### Elixir of Health

*Potion, Rare*

When you drink this potion, you are cured of all magical contagions. In addition, the following conditions end on you: Blinded, Deafened, Paralyzed, and Poisoned.
The clear, red liquid has tiny bubbles of light in it.

### Elven Chain

*Armor (Chain Mail or Chain Shirt), Rare*

You gain a +1 bonus to Armor Class while you wear this armor. You are considered trained with this armor even if you lack training with Medium or Heavy armor.

### Energy Bow

*Weapon (Longbow or Shortbow), Very Rare (Requires Attunement)*

You gain a +1 bonus to attack rolls and damage rolls made with this magic weapon, which has no string. Each time you pull your arm back in a firing motion, a magical arrow made of golden energy appears nocked and ready to fire. An arrow produced by this weapon deals Force damage instead of Piercing damage on a hit, and it disappears after it hits or misses its target. Until it disappears, the arrow emits Bright Light in a 20-foot radius and Dim Light for an additional 20 feet.
This weapon has the following additional properties.
**Arrow of Restraint.** Whenever you use this weapon to make a ranged attack against a creature, you can try to restrain the target instead of dealing damage to it. If the arrow hits, the target must succeed on a DC 15 Strength saving throw or have the Restrained condition for 1 minute. As an action, a creature Restrained by an arrow can make a DC 20 Strength (Athletics) check to try to break the restraint, ending the effect on itself on a successful check.
**Arrow of Transport.** As a Magic action, you can fire one energy arrow from this weapon at a target you can see within 60 feet of yourself. The target can be either a willing Medium or smaller creature or an object that isn't being worn or carried, provided the object is small enough to fit inside a 5-foot Cube. The arrow teleports the target to an unoccupied space you can see within 10 feet of you.
**Energy Ladder.** As a Magic action, you can loose a flurry of energy arrows from this weapon at a wall up to 60 feet away from yourself. The arrows become glowing rungs that stick out of the wall, forming a magical ladder up to 60 feet long on the wall. This ladder lasts for 1 minute before disappearing.

### Eversmoking Bottle

*Wondrous Item, Uncommon*

As a Magic action, you can open or close this bottle.
Opening the bottle causes thick smoke to billow out, forming a cloud that fills a 60-foot Emanation originating from the bottle. The area within the smoke is Heavily Obscured.
Each minute the bottle remains open, the size of the Emanation increases by 10 feet until it reaches its maximum size of 120 feet.

System Reference Document 5.2.1

***

221

Closing the bottle causes the cloud to become fixed in place until it disperses after 10 minutes. A strong wind (such as that created by the *Gust of Wind* spell) disperses the cloud after 1 minute.

### Eyes of Charming

*Wondrous Item, Uncommon (Requires Attunement)*

These crystal lenses fit over the eyes. They have 3 charges. While wearing them, you can expend 1 or more charges to cast *Charm Person* (save DC 13). For 1 charge, you cast the level 1 version of the spell. You increase the spell's level by one for each additional charge you expend. The lenses regain all expended charges daily at dawn.

### Eyes of Minute Seeing

*Wondrous Item, Uncommon*

These crystal lenses fit over the eyes. While wearing them, your vision improves significantly out to a range of 1 foot, granting you Darkvision within that range and Advantage on Intelligence (Investigation) checks made to examine something within that range.

### Eyes of the Eagle

*Wondrous Item, Uncommon*

These crystal lenses fit over the eyes. While wearing them, you have Advantage on Wisdom (Perception) checks that rely on sight. In conditions of clear visibility, you can make out details of even extremely distant creatures and objects as small as 2 feet across.

### Feather Token

*Wondrous Item, Rarity Varies*

This object looks like a feather. Different types of feather tokens exist, each with a different single-use effect. The GM chooses the kind of token or determines it randomly by rolling on the Feather Tokens table. The type of token determines its rarity.
**Anchor (Uncommon).** You can take a Magic action to touch the token to a boat or ship. For the next 24 hours, the vessel can't be moved by any means. Touching the token to the vessel again ends the effect. When the effect ends, the token disappears.
**Bird (Rare).** You can take a Magic action to toss the token 5 feet into the air. The token disappears and an enormous, multicolored bird takes its place. The bird has the statistics of a **Roc**, but it can't attack. It obeys your simple commands and can carry up to 500 pounds while flying at its maximum speed (16 miles per hour for a maximum of 144 miles per day, with a 1-hour rest for every 3 hours of flying) or 1,000 pounds at half that speed. The bird disappears after flying its maximum distance for a day or if it drops to 0 Hit Points. You can dismiss the bird as a Magic action.
**Fan (Uncommon).** If you are on a boat or ship, you can take a Magic action to toss the token up to 10 feet in the air. The token disappears, and a giant flapping fan takes its place. The fan floats and creates a strong wind. This wind can fill the sails of one ship, increasing its speed by 5 miles per hour for 8 hours. You can dismiss the fan as a Magic action.
**Swan Boat (Rare).** You can take a Magic action to touch the token to a body of water at least 60 feet in diameter. The token disappears, and a 50-footlong, 20-foot-wide boat shaped like a swan takes its place. The boat is self-propelled and moves across water at a speed of 6 miles per hour. You can take a Magic action while on the boat to command it to move or to turn up to 90 degrees. The boat remains for 24 hours and then disappears. You can dismiss the boat as a Magic action.
**Tree (Uncommon).** You must be outdoors to use this token. You can take a Magic action to touch it to an unoccupied space on the ground. The token disappears, and in its place a nonmagical oak tree springs into existence. The tree is 60 feet tall and has a 5-foot-diameter trunk, and its branches at the top spread out in a 20-foot radius.
**Whip (Rare).** You can take a Magic action to throw the token to a point within 10 feet of yourself. The token disappears, and a floating whip takes its place. You can then take a Bonus Action to make a melee spell attack against a creature within 10 feet of the whip, with an attack bonus of +9. On a hit, the target takes 1d6 + 5 Force damage.
As a Bonus Action, you can direct the whip to fly up to 20 feet and repeat the attack against a creature within 10 feet of the whip. The whip disappears after 1 hour, when you take a Magic action to dismiss it, or when you die or have the Incapacitated condition.

**Feather Tokens**

| 1d100 | Token | Rarity |
| :--- | :--- | :--- |
| 01–20 | Anchor | Uncommon |
| 21–35 | Bird | Rare |
| 36–50 | Fan | Uncommon |
| 51–65 | Swan boat | Rare |
| 66–90 | Tree | Uncommon |
| 91–00 | Whip | Rare |

### Figurine of Wondrous Power

*Wondrous Item, Rarity Varies*

A *Figurine of Wondrous Power* is a statuette small enough to fit in a pocket. If you take a Magic action to throw the figurine to a point on the ground within 60 feet of yourself, the figurine becomes a living creature specified in the figurine's description below. If the space where the creature would appear is occupied by other creatures or objects, or

System Reference Document 5.2.1

***

222

if there isn't enough space for the creature, the figurine doesn't become a creature.
The creature is Friendly to you and your allies. It understands your languages, obeys your commands, and takes its turn immediately after you on your Initiative count. If you issue no commands, the creature defends itself but takes no other actions.
The creature exists for a duration specific to each figurine. At the end of the duration, the creature reverts to its figurine form. It reverts to a figurine early if its creature form drops to 0 Hit Points or if you take a Magic action while touching the creature to make it revert to figurine form. When the creature becomes a figurine again, its property can't be used again until a certain amount of time has passed, as specified in the figurine's description.
**Bronze Griffon (Rare).** This bronze statuette is of a griffon rampant. It can become a **Griffon** for up to 6 hours. Once it has been used, it can't be used again until 5 days have passed.
**Ebony Fly (Rare).** This ebony statuette, carved in the likeness of a horsefly, can become a **Giant Fly** (see the accompanying stat block) for up to 12 hours and can be ridden as a mount. Once it has been used, it can't be used again until 2 days have passed.

> ### Giant Fly
> *Large Beast, Unaligned*
> **AC** 11
> **Initiative** +1 (11)
> **HP** 19 (3d10 + 3)
> **Speed** 30 ft., Fly 60 ft.
>
| MOD | SAVE | MOD | SAVE | MOD | SAVE |
| :--- | :--- | :--- | :--- | :--- | :--- |
| **STR** 14 +2 | +2 | **DEX** 13 +1 | +1 | **CON** 13 +1 | +1 |
| **INT** 2 -4 | -4 | **WIS** 10 +0 | +0 | **CHA** 3 -4 | -4 |
>
> **Senses** Darkvision 60 ft., Passive Perception 10
> **Languages** None
> **CR** 0 (XP 0; PB +2)

**Golden Lions (Rare).** These gold statuettes of lions are always created in pairs. You can use one figurine or both simultaneously. Each can become a **Lion** for up to 1 hour. Once a lion has been used, it can't be used again until 7 days have passed.
**Ivory Goats (Rare).** These ivory statuettes of goats are always created in sets of three. Each goat looks unique and functions differently from the others. Their properties are as follows:
**Goat of Terror.** This figurine can become a **Giant Goat** for up to 3 hours. The goat can't attack, but you can (harmlessly) remove its horns and use them as weapons. One horn becomes a *+1 Lance*, and the other becomes a *+2 Longsword*. Removing a horn requires a Magic action, and the weapons disappear and the horns return when the goat reverts to figurine form. While you ride the goat, any Hostile creature that starts its turn within a 30-foot Emanation originating from the goat must succeed on a DC 15 Wisdom saving throw or have the Frightened condition for 1 minute, until you are no longer riding the goat, or until the goat reverts to figurine form. The Frightened creature repeats the save at the end of each of its turns, ending the effect on itself on a success. Once it succeeds on the save, a creature is immune to this effect for the next 24 hours. Once the figurine has been used, it can't be used again until 15 days have passed.
**Goat of Traveling.** This figurine can become a Large goat with the same statistics as a **Riding Horse**. It has 24 charges, and each hour or portion thereof it spends in goat form costs 1 charge. While it has charges, you can use it as often as you wish. When it runs out of charges, it reverts to a figurine and can't be used again until 7 days have passed, when it regains all expended charges.
**Goat of Travail.** This figurine can become a **Giant Goat** for up to 3 hours. Once it has been used, it can't be used again until 30 days have passed.
**Marble Elephant (Rare).** This marble statuette resembles a trumpeting elephant. It can become an **Elephant** for up to 24 hours. Once it has been used, it can't be used again until 7 days have passed.
**Obsidian Steed (Very Rare).** This polished obsidian horse can become a **Nightmare** for up to 24 hours. The nightmare fights only to defend itself. Once it has been used, it can't be used again until 5 days have passed.
The figurine has a 10 percent chance each time you use it to ignore your orders, including a command to revert to figurine form. If you mount the nightmare while it is ignoring your orders, you and the nightmare are instantly transported to a random location on the plane of Hades, where the nightmare reverts to figurine form.
**Onyx Dog (Rare).** This onyx statuette of a dog can become a **Mastiff** for up to 6 hours. The mastiff has an Intelligence of 8 and can speak Common. It also has Blindsight with a range of 60 feet. Once it has been used, it can't be used again until 7 days have passed.
**Serpentine Owl (Rare).** This serpentine statuette of an owl can become a **Giant Owl** for up to 8 hours. The owl can communicate telepathically with you at any range if you and it are on the same plane of existence. Once it has been used, it can't be used again until 2 days have passed.
**Silver Raven (Uncommon).** This silver statuette of a raven can become a **Raven** for up to 12 hours. Once it has been used, it can't be used again until 2 days have passed. While in raven form, the figurine grants you the ability to cast *Animal Messenger* on it.

System Reference Document 5.2.1

***

223

### Flame Tongue

*Weapon (Any Melee Weapon), Rare (Requires Attunement)*

While holding this magic weapon, you can take a Bonus Action and use a command word to cause flames to engulf the damage-dealing part of the weapon. These flames shed Bright Light in a 40-foot radius and Dim Light for an additional 40 feet. While the weapon is ablaze, it deals an extra 2d6 Fire damage on a hit. The flames last until you take a Bonus Action to issue the command again or until you drop, stow, or sheathe the weapon.

### Folding Boat

*Wondrous Item, Rare*

This object appears as a wooden box that measures 12 inches long, 6 inches wide, and 6 inches deep. It weighs 4 pounds and floats. It can be opened to store items inside. This item also has three command words, each requiring a Magic action to use:
**First Command Word.** The box unfolds into a Rowboat.
**Second Command Word.** The box unfolds into a Keelboat.
**Third Command Word.** The *Folding Boat* folds back into a box if no creatures are aboard. Any objects in the vessel that can't fit inside the box remain outside the box as it folds. Any objects in the vessel that can fit inside the box do so.
When the box becomes a vessel, its weight becomes that of a normal vessel its size, and anything that was stored in the box remains in the boat.
Statistics for the Rowboat and Keelboat appear in "Equipment.” If either vessel is reduced to 0 Hit Points, the *Folding Boat* is destroyed.

### Frost Brand

*Weapon (Glaive, Greatsword, Longsword, Rapier, Scimitar, or Shortsword), Very Rare (Requires Attunement)*

When you hit with an attack roll using this magic weapon, the target takes an extra 1d6 Cold damage.
In addition, while you hold the weapon, you have Resistance to Fire damage.
In freezing temperatures, the weapon sheds Bright Light in a 10-foot radius and Dim Light for an additional 10 feet.
When you draw this weapon, you can extinguish all nonmagical flames within 30 feet of yourself. Once used, this property can't be used again for 1 hour.

### Gauntlets of Ogre Power

*Wondrous Item, Uncommon (Requires Attunement)*

Your Strength is 19 while you wear these gauntlets. They have no effect on you if your Strength is 19 or higher without them.

### Gem of Brightness

*Wondrous Item, Uncommon*

This prism has 50 charges. While you are holding it, you can take a Magic action and use one of three command words to cause one of the following effects:
**First Command Word.** The gem sheds Bright Light in a 30-foot radius and Dim Light for an additional 30 feet. This effect doesn't expend a charge. It lasts until you take a Bonus Action to repeat the command word or until you use another function of the gem.
**Second Command Word.** You expend 1 charge and cause the gem to fire a brilliant beam of light at one creature you can see within 60 feet of yourself. The creature must succeed on a DC 15 Constitution saving throw or have the Blinded condition for 1 minute. The creature repeats the save at the end of each of its turns, ending the effect on itself on a success.
**Third Command Word.** You expend 5 charges and cause the gem to flare with intense light in a 30-foot Cone. Each creature in the Cone makes a saving throw as if struck by the beam created with the second command word.
When all of the gem's charges are expended, the gem becomes a nonmagical jewel worth 50 GP.

### Gem of Seeing

*Wondrous Item, Rare (Requires Attunement)*

This gem has 3 charges. As a Magic action, you can expend 1 charge. For the next 10 minutes, you have Truesight out to 120 feet when you peer through the gem.
The gem regains 1d3 expended charges daily at dawn.

### Giant Slayer

*Weapon (Any Simple or Martial), Rare*

You gain a +1 bonus to attack rolls and damage rolls made with this magic weapon.
When you hit a Giant with this weapon, the Giant takes an extra 2d6 damage of the weapon's type and must succeed on a DC 15 Strength saving throw or have the Prone condition.

### Glamoured Studded Leather

*Armor (Studded Leather Armor), Rare*

While wearing this armor, you gain a +1 bonus to Armor Class. You can also take a Bonus Action to

System Reference Document 5.2.1

***

224

cause the armor to assume the appearance of a normal set of clothing or some other kind of armor. You decide what it looks like—including color, style, and accessories—but the armor retains its normal bulk and weight. The illusory appearance lasts until you use this property again or doff the armor.

### Gloves of Missile Snaring

*Wondrous Item, Uncommon (Requires Attunement)*

If you're hit by an attack roll made with a Ranged or Thrown weapon while wearing these gloves, you can take a Reaction to reduce the damage by 1d10 plus your Dexterity modifier if you have a free hand. If you reduce the damage to 0, you can catch the ammunition or weapon if it is small enough for you to hold in that hand.

### Gloves of Swimming and Climbing

*Wondrous Item, Uncommon (Requires Attunement)*

While wearing these gloves, you have a Climb Speed and a Swim Speed equal to your Speed, and you gain a +5 bonus to Strength (Athletics) checks made to climb or swim.

### Gloves of Thievery

*Wondrous Item, Uncommon*

These gloves are imperceptible while worn. While wearing them, you gain a +5 bonus to Dexterity (Sleight of Hand) checks.

### Goggles of Night

*Wondrous Item, Uncommon*

While wearing these dark lenses, you have Darkvision out to 60 feet. If you already have Darkvision, wearing the goggles increases its range by 60 feet.

### Hammer of Thunderbolts

*Weapon (Maul or Warhammer), Legendary (Requires Attunement)*

You gain a +1 bonus to attack rolls and damage rolls made with this magic weapon.
The weapon has 5 charges. You can expend 1 charge and make a ranged attack with the weapon, hurling it as if it had the Thrown property with a normal range of 20 feet and a long range of 60 feet. If the attack hits, the weapon unleashes a thunderclap audible out to 300 feet. The target and every creature within 30 feet of it other than you must succeed on a DC 17 Constitution saving throw or have the Stunned condition until the end of your next turn. Immediately after hitting or missing, the weapon flies back to your hand. The weapon regains 1d4 + 1 expended charges daily at dawn.
**Giant's Bane.** While you are attuned to the weapon and wearing either a *Belt of Giant Strength* or *Gauntlets of Ogre Power* to which you are also attuned, you gain the following benefits:
**Giants' Bane.** When you roll a 20 on the d20 for an attack roll made with this weapon against a Giant, the creature must succeed on a DC 17 Constitution saving throw or die.
**Might of Giants.** The Strength score bestowed by your *Belt of Giant Strength* or *Gauntlets of Ogre Power* increases by 4, to a maximum of 30.

### Handy Haversack

*Wondrous Item, Rare*

This backpack has a central pouch and two side pouches, each of which is an extradimensional space. Each side pouch can hold up to 200 pounds of material, not exceeding a volume of 25 cubic feet. The central pouch can hold up to 500 pounds of material, not exceeding a volume of 64 cubic feet. The haversack always weighs 5 pounds, regardless of its contents.
Retrieving an item from the haversack requires a Utilize action or a Bonus Action (your choice). When you reach into the haversack for a specific item, the item is always magically on top.
If any of its pouches is overloaded, pierced, or torn, the haversack ruptures and is destroyed. If the haversack is destroyed, its contents are lost forever, although an Artifact always turns up again somewhere. If the haversack is turned inside out, its contents spill forth unharmed, and the haversack must be put right before it can be used again.
Each pouch of the haversack holds enough air for 10 minutes of breathing, divided by the number of breathing creatures inside.
Placing the haversack inside an extradimensional space created by a *Bag of Holding*, *Portable Hole*, or similar item instantly destroys both items and opens a gate to the Astral Plane. The gate originates where the one item was placed inside the other. Any creature within 10 feet of the gate and not behind Total Cover is sucked through it and deposited in a random location on the Astral Plane. The gate then closes. The gate is one-way only and can't be reopened.

### Hat of Disguise

*Wondrous Item, Uncommon (Requires Attunement)*

While wearing this hat, you can cast the *Disguise Self* spell. The spell ends if the hat is removed.

### Hat of Many Spells

*Wondrous Item, Very Rare (Requires Attunement by a Wizard)*

This pointed hat has the following properties.
**Spellcasting Focus.** While holding the hat, you can use it as a Spellcasting Focus for your Wizard spells. Any spell you cast using the hat gains a special Somatic component: you must reach into the hat and "pull" the spell out of it.

System Reference Document 5.2.1

***

225

**Unknown Spell.** While holding the hat, you can try to cast a level 1+ spell you don't know. The spell must be on the Wizard spell list, it must be of a level you can cast, and it can't have Material components costing more than 1,000 GP. Once you decide on the spell, you must expend a spell slot of the spell's level. Then, to determine whether you cast the spell, make an Intelligence (Arcana) check (DC 10 plus the spell's level). On a successful check, you cast the spell using its normal casting time, and you can't use this property again until you finish a Short or Long Rest. On a failed check, you fail to cast the spell and a random effect occurs instead, determined by rolling on the following table.
Any spell you cast from the hat uses your spell save DC and spell attack bonus.

| 1d100 | Effect |
| :--- | :--- |
| 01–50 | You cast a random spell determined by rolling 1d10: on a 1, *Enlarge/Reduce* (enlarge effect); on a 2, *Enlarge/Reduce* (reduce effect); on a 3, *Faerie Fire*; on a 4, *Fireball*; on a 5, *Gust of Wind*; on a 6, *Invisibility* (cast on yourself); on a 7, *Lightning Bolt*; on an 8, *Phantasmal Force*; on a 9, *Polymorph*; on a 10, *Stinking Cloud*. |
| 51–55 | You have the Stunned condition until the end of your next turn, believing something awesome just happened. |
| 56–60 | A harmless swarm of butterflies fills a 10-foot Cube within 30 feet of yourself. The swarm disperses after 1 minute. |
| 61–65 | You pull a nonmagical object out of the hat. Roll 1d4 to determine the object: on a 1, a vial of Acid; on a 2, a flask of Alchemist's Fire; on a 3, a Crowbar; on a 4, a lit Torch. |
| 66–70 | You suffer a bout of "magic sickness" and have the Poisoned condition for 1 hour. |
| 71–75 | You have the Petrified condition until the end of your next turn. |
| 76–80 | You pull a nonmagical object out of the hat. Roll 1d4 to determine the object: on a 1, a Dagger; on a 2, a Rope with a Grappling Hook tied to one end; on a 3, a bag of Caltrops; on a 4, a gem worth 50 GP. |
| 81–85 | A creature appears in an unoccupied space as close to you as possible. The creature isn't under your control and acts as it normally would, and it disappears after 1 hour or when it drops to 0 Hit Points. Roll 1d4 to determine the creature: on a 1, a **Camel**; on a 2, a **Constrictor Snake**; on a 3, an **Elephant**; on a 4, a **Mule**. |
| 86–90 | A Hostile **Swarm of Bats** flies out of the hat, occupies your space, and attacks you. |
| 91–95 | A vertical, 10-foot-diameter, two-way portal to another plane of existence opens in an unoccupied space within 30 feet of you and remains open until the end of your next turn. The GM determines where it leads. |
| 96–00 | You pull a magic item out of the hat. Roll 1d6 to determine the item's rarity: on a 1–3, Common; on a 4–5, Uncommon; on a 6, Rare. The GM chooses the item, which disappears after 1 hour if it's not consumed or destroyed before then. |

### Headband of Intellect

*Wondrous Item, Uncommon (Requires Attunement)*

Your Intelligence is 19 while you wear this headband. It has no effect on you if your Intelligence is 19 or higher without it.

### Helm of Brilliance

*Wondrous Item, Very Rare (Requires Attunement)*

This helm is set with 1d10 diamonds, 2d10 rubies, 3d10 fire opals, and 4d10 opals. Any gem pried from the helm crumbles to dust. When all the gems are removed or destroyed, the helm loses its magic.
You gain the following benefits while wearing the helm.
**Diamond Light.** As long as it has at least one diamond, the helm emits a 30-foot Emanation. When at least one Undead is within that area, the Emanation is filled with Dim Light. Any Undead that starts its turn in that area takes 1d6 Radiant damage.
**Fire Opal Flames.** As long as the helm has at least one fire opal, you can take a Magic action to cause one weapon you are holding to burst into flames. The flames emit Bright Light in a 10-foot radius and Dim Light for an additional 10 feet. The flames are harmless to you and the weapon. When you hit with an attack using the blazing weapon, the target takes an extra 1d6 Fire damage. The flames last until you take a Bonus Action to extinguish them or until you drop or stow the weapon.
**Ruby Resistance.** As long as the helm has at least one ruby, you have Resistance to Fire damage.
**Spells.** You can cast one of the following spells (save DC 18), using one of the helm's gems of the specified type as a component: *Daylight* (opal), *Fireball* (fire opal), *Prismatic Spray* (diamond), or *Wall of Fire* (ruby). The gem is destroyed when the spell is cast and disappears from the helm.
**Taking Fire Damage.** Roll 1d20 if you are wearing the helm and take Fire damage as a result of failing

System Reference Document 5.2.1

***

226

a saving throw against a spell. On a roll of 1, the helm emits beams of light from its remaining gems and is then destroyed. Each creature within a 60-foot Emanation originating from you must succeed on a DC 17 Dexterity saving throw or be struck by a beam, taking Radiant damage equal to the number of gems in the helm.

### Helm of Comprehending Languages

*Wondrous Item, Uncommon*

While wearing this helm, you can cast *Comprehend Languages* from it.

### Helm of Telepathy

*Wondrous Item, Uncommon (Requires Attunement)*

While wearing this helm, you have telepathy with a range of 30 feet, and you can cast *Detect Thoughts* or *Suggestion* (save DC 13) from the helm. Once either spell is cast from the helm, that spell can't be cast from it again until the next dawn.

### Helm of Teleportation

*Wondrous Item, Rare (Requires Attunement)*

This helm has 3 charges. While wearing it, you can expend 1 charge to cast *Teleport* from it. The helm regains 1d3 expended charges daily at dawn.

### Holy Avenger

*Weapon (Any Simple or Martial), Legendary (Requires Attunement by a Paladin)*

You gain a +3 bonus to attack rolls and damage rolls made with this magic weapon. When you hit a Fiend or an Undead with it, that creature takes an extra 2d10 Radiant damage.
While you hold the drawn weapon, it creates a 10-foot Emanation originating from you. You and all creatures Friendly to you in the Emanation have Advantage on saving throws against spells and other magical effects. If you have 17 or more levels in the Paladin class, the size of the Emanation increases to 30 feet.

### Horn of Blasting

*Wondrous Item, Rare*

You can take a Magic action to blow the horn, which emits a thunderous blast in a 30-foot Cone that is audible out to 600 feet. Each creature in the Cone makes a DC 15 Constitution saving throw. On a failed save, a creature takes 5d8 Thunder damage and has the Deafened condition for 1 minute. On a successful save, a creature takes half as much damage only. Glass or crystal objects in the Cone that aren't being worn or carried take 10d8 Thunder damage.
Each use of the horn's magic has a 20 percent chance of causing the horn to explode. The explosion deals 10d6 Force damage to the user and destroys the horn.

### Horn of Valhalla

*Wondrous Item, Rare (Silver or Brass), Very Rare (Bronze), or Legendary (Iron)*

You can take a Magic action to blow this horn. In response, warrior spirits from the plane of Ysgard appear in unoccupied spaces within 60 feet of you. Each spirit uses the **Berserker** stat block and returns to Ysgard after 1 hour or when it drops to 0 Hit Points. The spirits look like living, breathing warriors, and they have Immunity to the Charmed and Frightened conditions. Once you use the horn, it can't be used again until 7 days have passed.
Four types of *Horn of Valhalla* are known to exist, each made of a different metal. The horn's type determines how many spirits it summons, as well as the requirement for its use. The GM chooses the horn's type or determines it randomly by rolling on the following table.
If you blow the horn without meeting its requirement, the summoned spirits attack you. If you meet the requirement, they are Friendly to you and your allies and follow your commands.

| 1d100 | Horn Type | Spirits | Requirement |
| :--- | :--- | :--- | :--- |
| 01–40 | Silver | 2 | None |
| 41–75 | Brass | 3 | Proficiency with all Simple weapons |
| 76–90 | Bronze | 4 | Training with all Medium armor |
| 91–00 | Iron | 5 | Proficiency with all Martial weapons |

### Horseshoes of a Zephyr

*Wondrous Item, Very Rare*

These horseshoes come in a set of four. As a Magic action, you can touch one of the horseshoes to the hoof of a horse or similar creature, whereupon the horseshoe affixes itself to the hoof. Removing a horseshoe also takes a Magic action.
While all four shoes are affixed to the hooves of a horse or similar creature, they allow the creature to move normally while floating 4 inches above a surface. This effect means the creature can cross or stand above nonsolid or unstable surfaces, such as water or lava. The creature leaves no tracks and ignores Difficult Terrain. In addition, the creature can travel for up to 12 hours a day without gaining Exhaustion levels from extended travel.

System Reference Document 5.2.1

***

227

### Horseshoes of Speed

*Wondrous Item, Rare*

These horseshoes come in a set of four. As a Magic action, you can touch one of the horseshoes to the hoof of a horse or similar creature, whereupon the horseshoe affixes itself to the hoof. Removing a horseshoe also takes a Magic action.
While all four horseshoes are attached to the same creature, its Speed is increased by 30 feet.

### Immovable Rod

*Rod, Uncommon*

This iron rod has a button on one end. You can take a Utilize action to press the button, which causes the rod to become magically fixed in place. Until you or another creature takes a Utilize action to push the button again, the rod doesn't move, even if it defies gravity. The rod can hold up to 8,000 pounds of weight. More weight causes the rod to deactivate and fall. A creature can take a Utilize action to make a DC 30 Strength (Athletics) check, moving the fixed rod up to 10 feet on a successful check.

### Instant Fortress

*Wondrous Item, Rare (Requires Attunement)*

As a Magic action, you can place this 1-inch adamantine statuette on the ground and, using a command word, cause it to grow rapidly into a square adamantine tower. Repeating the command word causes the tower to revert to statuette form, which works only if the tower is empty. Each creature in the area where the tower appears is pushed to an unoccupied space outside but next to the tower. Objects in the area that aren't being worn or carried are also pushed clear of the tower.
The tower is 20 feet on a side and 30 feet high, with arrow slits on all sides and a battlement atop it. Its interior is divided into two floors, with a ladder, staircase, or ramp (your choice) connecting them. This ladder, staircase, or ramp ends at a trapdoor leading to the roof. When created, the tower has a single door at ground level on the side facing you. The door opens only at your command, which you can issue as a Bonus Action. It is immune to the *Knock* spell and similar magic.
Magic prevents the tower from being tipped over. The roof, the door, and the walls each have AC 20; HP 100; Immunity to Bludgeoning, Piercing, and Slashing damage except that which is dealt by siege equipment; and Resistance to all other damage. Shrinking the tower back down to statuette form doesn't repair damage to the tower. Only a *Wish* spell can repair the tower (this use of the spell counts as replicating a spell of level 8 or lower). Each casting of *Wish* causes the tower to regain all its Hit Points.

### Ioun Stone

*Wondrous Item, Rarity Varies (Requires Attunement)*

Roughly marble sized, *Ioun Stones* are named after Ioun, a god of knowledge and prophecy revered on some worlds. Many types of *Ioun Stones* exist, each type a distinct combination of shape and color.
When you take a Magic action to toss an *Ioun Stone* into the air, the stone orbits your head at a distance of 1d3 feet, conferring its benefit to you while doing so. You can have up to three *Ioun Stones* orbiting your head at the same time.
Each *Ioun Stone* orbiting your head is considered to be an object you are wearing. The orbiting stone avoids contact with other creatures and objects, adjusting its orbit to avoid collisions and thwarting all attempts by other creatures to attack or snatch it.
As a Utilize action, you can seize and stow any number of *Ioun Stones* orbiting your head. If your Attunement to an *Ioun Stone* ends while it's orbiting your head, the stone falls as though you had dropped it.
The type of stone determines its rarity and effects.
**Absorption (Very Rare).** While this pale lavender ellipsoid orbits your head, you can take a Reaction to cancel a spell of level 4 or lower cast by a creature you can see. A canceled spell has no effect, and any resources used to cast it are wasted. Once the stone has canceled 20 levels of spells, it burns out, turns dull gray, and loses its magic.
**Agility (Very Rare).** Your Dexterity increases by 2, to a maximum of 20, while this deep-red sphere orbits your head.
**Awareness (Rare).** While this dark-blue rhomboid orbits your head, you have Advantage on Initiative rolls and Wisdom (Perception) checks.
**Fortitude (Very Rare).** Your Constitution increases by 2, to a maximum of 20, while this pink rhomboid orbits your head.
**Greater Absorption (Legendary).** While this marbled lavender and green ellipsoid orbits your head, you can take a Reaction to cancel a spell of level 8 or lower cast by a creature you can see. A canceled spell has no effect, and any resources used to cast it are wasted. Once the stone has canceled 20 levels of spells, it burns out, turns dull gray, and loses its magic.
**Insight (Very Rare).** Your Wisdom increases by 2, to a maximum of 20, while this incandescent blue sphere orbits your head.
**Intellect (Very Rare).** Your Intelligence increases by 2, to a maximum of 20, while this marbled scarlet and blue sphere orbits your head.
**Leadership (Very Rare).** Your Charisma increases by 2, to a maximum of 20, while this marbled pink and green sphere orbits your head.

System Reference Document 5.2.1

***

228

**Mastery (Legendary).** Your Proficiency Bonus increases by 1 while this pale green prism orbits your head.
**Protection (Rare).** You gain a +1 bonus to Armor Class while this dusty-rose prism orbits your head.
**Regeneration (Legendary).** You regain 15 Hit Points at the end of each hour this pearly white spindle orbits your head if you have at least 1 Hit Point.
**Reserve (Rare).** This vibrant purple prism stores spells cast into it, holding them until you use them. The stone can store up to 4 levels of spells at a time. When found, it contains 1d4 levels of stored spells chosen by the GM.
Any creature can cast a spell of level 1 through 4 into the stone by touching it as the spell is cast. The spell has no effect, other than to be stored in the stone. If the stone can't hold the spell, the spell is expended without effect. The level of the slot used to cast the spell determines how much space it uses.
While this stone orbits your head, you can cast any spell stored in it. The spell uses the slot level, spell save DC, spell attack bonus, and spellcasting ability of the original caster but is otherwise treated as if you cast the spell. The spell cast from the stone is no longer stored in it, freeing up space.
**Strength (Very Rare).** Your Strength increases by 2, to a maximum of 20, while this pale blue rhomboid orbits your head.
**Sustenance (Rare).** You don't need to eat or drink while this clear spindle orbits your head.

### Iron Bands

*Wondrous Item, Rare*

This rusty iron sphere measures 3 inches in diameter and weighs 1 pound. You can take a Magic action to throw the sphere at a Huge or smaller creature you can see within 60 feet of yourself. As the sphere moves through the air, it opens into a tangle of metal bands.
Make a ranged attack roll with an attack bonus equal to your Dexterity modifier plus your Proficiency Bonus. On a hit, the target has the Restrained condition until you take a Bonus Action to issue a command that releases it. Doing so or missing with the attack causes the bands to contract and become a sphere once more.
A creature that can touch the bands, including the one Restrained, can take an action to make a DC 20 Strength (Athletics) check to break the iron bands. On a successful check, the item is destroyed, and the Restrained creature is freed. On a failed check, any further attempts made by that creature automatically fail until 24 hours have elapsed.
Once the bands are used, they can't be used again until the next dawn.

### Iron Flask

*Wondrous Item, Legendary*

While holding this brass-stoppered iron flask, you can take a Magic action to target a creature that you can see within 60 feet of yourself. If the flask is empty and the target is native to a plane of existence other than the one you're on, the target must succeed on a DC 17 Wisdom saving throw or be trapped in the flask. If the target has been trapped by the flask before, it has Advantage on the save. Once trapped, a creature remains in the flask until released. The flask can hold only one creature at a time. A creature trapped in the flask doesn't age and doesn't need to breathe, eat, or drink.
You can take a Magic action to remove the flask's stopper and release the creature in the flask. The creature then obeys your commands for 1 hour, understanding those commands even if it doesn't know the language in which the commands are given. If you issue no commands or give the creature a command that is likely to result in its death or imprisonment, it defends itself but otherwise takes no actions. At the end of the duration, the creature acts in accordance with its normal disposition and alignment.
An *Identify* spell reveals if the flask contains a creature, but the only way to determine the type of creature is to open the flask. A newly discovered *Iron Flask* might already contain a creature chosen by the GM.

### Javelin of Lightning

*Weapon (Javelin), Uncommon*

Each time you make an attack roll with this magic weapon and hit, you can have it deal Lightning damage instead of Piercing damage.
**Lightning Bolt.** When you throw this weapon at a target no farther than 120 feet from you, you can forgo making a ranged attack roll and instead turn the weapon into a bolt of lightning. This bolt forms a 5-foot-wide Line between you and the target. The target and each other creature in the Line (excluding you) makes a DC 13 Dexterity saving throw, taking 4d6 Lightning damage on a failed save or half as much damage on a successful one. Immediately after dealing this damage, the weapon reappears in your hand. This property can't be used again until the next dawn.

### Lantern of Revealing

*Wondrous Item, Uncommon*

While lit, this hooded lantern burns for 6 hours on 1 pint of oil, shedding Bright Light in a 30-foot radius and Dim Light for an additional 30 feet. Invisible creatures and objects are visible as long as they are in the lantern's Bright Light. You can take a Utilize

System Reference Document 5.2.1

***

229

action to lower the hood, reducing the lantern's light to Dim Light in a 5-foot radius.

### Luck Blade

*Weapon (Glaive, Greatsword, Longsword, Rapier, Scimitar, Sickle, or Shortsword), Legendary (Requires Attunement)*

You gain a +1 bonus to attack rolls and damage rolls made with this magic weapon. While the weapon is on your person, you also gain a +1 bonus to saving throws.
**Luck.** If the weapon is on your person, you can call on its luck (no action required) to reroll one failed D20 Test if you don't have the Incapacitated condition. You must use the second roll. Once used, this property can't be used again until the next dawn.
**Wish.** The weapon has 1d3 charges. While holding it, you can expend 1 charge and cast *Wish* from it. Once used, this property can't be used again until the next dawn. The weapon loses this property if it has no charges.

### Mace of Disruption

*Weapon (Mace), Rare (Requires Attunement)*

When you hit a Fiend or an Undead with this magic weapon, that creature takes an extra 2d6 Radiant damage. If the target has 25 Hit Points or fewer after taking this damage, it must succeed on a DC 15 Wisdom saving throw or be destroyed. On a successful save, the creature has the Frightened condition until the end of your next turn.
**Light.** While you hold this weapon, it sheds Bright Light in a 20-foot radius and Dim Light for an additional 20 feet.

### Mace of Smiting

*Weapon (Mace), Rare*

You gain a +1 bonus to attack rolls and damage rolls made with this magic weapon. The bonus increases to +3 when you use the weapon to attack a Construct.
When you roll a 20 on an attack roll made with this weapon, the target takes an extra 7 Bludgeoning damage, or 14 Bludgeoning damage if it's a Construct. If a Construct has 25 Hit Points or fewer after taking this damage, it is destroyed.

### Mace of Terror

*Weapon (Mace), Rare (Requires Attunement)*

This magic weapon has 3 charges and regains 1d3 expended charges daily at dawn. While holding the weapon, you can take a Magic action and expend 1 charge to release a wave of terror from it. Each creature of your choice within 30 feet of you must succeed on a DC 15 Wisdom saving throw or have the Frightened condition for 1 minute. While Frightened in this way, a creature must spend its turns trying to move as far away from you as it can, and it can't make Opportunity Attacks. For its action, it can use only the Dash action or try to escape from an effect that prevents it from moving. If it has nowhere it can move, the creature can take the Dodge action. At the end of each of its turns, a creature repeats the save, ending the effect on itself on a success.

### Mantle of Spell Resistance

*Wondrous Item, Rare (Requires Attunement)*

You have Advantage on saving throws against spells while you wear this cloak.

### Manual of Bodily Health

*Wondrous Item, Very Rare*

This book contains health and nutrition tips, and its words are charged with magic. If you spend 48 hours over a period of 6 days or fewer studying the book's contents and practicing its guidelines, your Constitution increases by 2, to a maximum of 30. The manual then loses its magic but regains it in a century.

### Manual of Gainful Exercise

*Wondrous Item, Very Rare*

This book describes fitness exercises, and its words are charged with magic. If you spend 48 hours over a period of 6 days or fewer studying the book's contents and practicing its guidelines, your Strength increases by 2, to a maximum of 30. The manual then loses its magic but regains it in a century.

### Manual of Golems

*Wondrous Item, Very Rare*

This tome contains information and incantations necessary to make a particular type of golem. The GM chooses the type or determines it randomly by rolling on the accompanying table. To decipher and use the manual, you must be a spellcaster with at least two level 5 spell slots. A creature that can't use a *Manual of Golems* and attempts to read it takes 6d6 Psychic damage.
To create a golem, you must spend the time shown on the table, working without interruption with the manual at hand and resting no more than 8 hours per day. You must also pay the specified cost to purchase supplies.
Once you finish creating the golem, the book is consumed in eldritch flames. The golem becomes animate when the ashes of the manual are sprinkled on it. See "Monsters" for the golem's stat block. The golem is under your control, and it understands and obeys your commands.

System Reference Document 5.2.1