# Page 1

### Weapon, +1, +2, or +3
*Weapon (Any Simple or Martial), Uncommon (+1), Rare (+2), or Very Rare (+3)*

You have a bonus to attack rolls and damage rolls made with this magic weapon. The bonus is determined by the weapon's rarity.

### Weapon of Warning
*Weapon (Any Simple or Martial), Uncommon (Requires Attunement)*

As long as this weapon is within your reach and you are attuned to it, you and allies within 30 feet of you gain the following benefits.

**Alarm.** The weapon magically awakens each subject who is sleeping naturally when combat begins. This benefit doesn't wake a subject from magically induced sleep.

**Supernatural Readiness.** Each subject has Advantage on its Initiative rolls.

### Well of Many Worlds
*Wondrous Item, Legendary*

This fine black cloth, soft as silk, is folded up to the dimensions of a handkerchief. It unfolds into a circular sheet 6 feet in diameter.

You can take a Magic action to unfold the Well of Many Worlds and place it on a solid surface, whereupon it forms a two-way, 6-foot-diameter, circular portal to another world or plane of existence. Each time the item opens a portal, the GM decides where it leads. The portal remains open until a creature within 5 feet of it takes a Magic action to close it by taking hold of the edges of the cloth and folding it up.

Once the Well of Many Worlds has opened a portal, it can't do so again for 1d8 hours.

### Wind Fan
*Wondrous Item, Uncommon*

While holding this fan, you can cast *Gust of Wind* (save DC 13) from it. Each subsequent time the fan is used before the next dawn, it has a cumulative 20 percent chance of not working; if the fan fails to work, it tears into useless, nonmagical tatters.

### Winged Boots
*Wondrous Item, Uncommon (Requires Attunement)*

These boots have 4 charges and regain 1d4 expended charges daily at dawn. While wearing the boots, you can take a Magic action to expend 1 charge, gaining a Fly Speed of 30 feet for 1 hour. If you are flying when the duration expires, you descend at a rate of 30 feet per round until you land.

### Wings of Flying
*Wondrous Item, Rare (Requires Attunement)*

While wearing this cloak, you can take a Magic action to turn the cloak into a pair of wings on your back. The wings lasts for 1 hour or until you end the effect early as a Magic action. The wings give you a Fly Speed of 60 feet. If you are aloft when the wings disappear, you fall. When the wings disappear, you can't use them again for 1d12 hours.

---
253 System Reference Document 5.2.1

# Page 2

# Monsters

## Stat Block Overview
A monster has a stat block that contains the rules necessary to use it in the game. Stat blocks are divided into the following parts:

**Name and General Details.** The name of the monster is followed by its size, creature type (along with any descriptive tags), and alignment.

**Combat Highlights.** Armor Class, Hit Points, Speed, and Initiative are provided here.

**Ability Scores.** A monster's ability scores, ability modifiers, and saving throws are listed here.

**Other Details.** The monster's Senses, Languages, and CR entries appear here. Additional details appear in some monsters, such as skill proficiencies, Resistances, Immunities, and Gear. If a monster lacks those details, entries for them don't appear.

**Traits.** Monster characteristics that are active at all times or during certain situations appear here.

**Actions.** The monster can take the actions here in addition to those in "Playing the Game."

**Bonus Actions.** This section provides a monster's Bonus Actions, if any.

**Reactions and Legendary Actions.** These sections provide Reactions and Legendary Actions, if any.

## Parts of a Stat Block
The rules for a stat block are detailed in "Rules Glossary" and in this section.

### Size
A monster is Tiny, Small, Medium, Large, Huge, or Gargantuan. If size options are presented, you choose the creature's size from those options. See "Playing the Game" for information on size.

### Creature Type
Each monster has a tag that identifies the type of creature it is. Certain spells, magic items, class features, and other effects in the game interact in special ways with creatures of a particular type.

The game includes the following creature types, which have no rules of their own:

**Aberrations** are utterly alien beings, such as aboleths and cloakers.

**Beasts** are non-Humanoid natural creatures, like horses and wolves, as well as most giant animals.

**Celestials** are magical creatures, such as angels and pegasi, with ties to the Upper Planes.

**Constructs** are magically created creatures such as homunculi and shield guardians.

**Dragons** are scaly beings of ancient origin, such as red dragons and wyverns.

**Elementals** are beings from the Elemental Planes, such as efreet and water elementals.

**Fey** are creatures tied to the Feywild or the forces of nature, such as dryads and goblins.

**Fiends** are creatures tied to terrifying Lower Planes, such as balors and hell hounds.

**Giants** are towering beings with humanlike shapes, like fire giants and trolls.

**Humanoids** are people defined by their roles and professions, such as mages, pirates, and warriors. They include members of varied species.

**Monstrosities** are unnatural creatures with strange origins, such as mimics and owlbears.

**Oozes** are gelatinous creatures, including black puddings and gelatinous cubes.

**Plants** are sentient vegetation and fungal monsters, such as shambling mounds and treants.

**Undead** are spirits and the reanimated dead, such as ghosts, vampires, and zombies.

### Descriptive Tags
A monster might have one or more tags in parentheses following its type. Such tags provide additional categorization and have no rules of their own, but certain game effects might refer to them.

### Alignment
The alignment specified in a monster's stat block is a default suggestion of how to roleplay the monster, inspired by its traditional role in the game or real-world folklore. Change a monster's alignment to suit your storytelling needs. The Neutral alignment, in particular, is an invitation for you to consider whether an individual leans toward one of the other alignments.

"Character Creation" describes the nine alignments and unaligned creatures.

### Armor Class
A monster's Armor Class (AC) includes its natural armor, Dexterity, gear, and other defenses. See "Playing the Game" for information on Armor Class.

### Initiative
The Initiative entry specifies the monster's Initiative modifier followed by the monster's Initiative score in parentheses. Use the modifier when you roll to determine a monster's Initiative. A monster's Initiative modifier is typically equal to its Dexterity modifier, but some monsters have additional modifiers, such as Proficiency Bonus, applied to that number.

If you don't want to roll a monster's Initiative, use the Initiative score as the monster's Initiative in combat. Initiative is further detailed in “Playing the Game."

---
254 System Reference Document 5.2.1

# Page 3

### Hit Points
A monster's Hit Points are presented as a number followed by parentheses, where the monster's Hit Point Dice are provided, along with any contribution from its Constitution. Either use the number for the monster's Hit Points or roll the die expression in parentheses to determine the monster's Hit Points randomly; don't use both.

A monster's size typically determines the die used to calculate its Hit Points, as shown in the Hit Dice by Size table.

**Hit Dice by Size**
| Monster Size | Hit Die | Average HP per Die |
| :--- | :--- | :--- |
| Tiny | d4 | 2½ |
| Small | d6 | 3½ |
| Medium | d8 | 4½ |
| Large | d10 | 5½ |
| Huge | d12 | 6½ |
| Gargantuan | d20 | 10½ |

A monster's Constitution modifier is multiplied by the number of Hit Dice it possesses, and the result is added to its Hit Points. For example, if a monster has a Constitution of 12 (+1 modifier) and 2d8 Hit Dice, it has 2d8 + 2 Hit Points (average 11).

For more on Hit Points, see "Playing the Game."

### Speed
The Speed entry specifies a monster's Speed. Some monsters have one or more of the following speeds: Burrow, Climb, Fly, Swim. Rules for Speed and these specials speeds appear in "Rules Glossary."

### Ability Scores
Every monster has six ability scores along with corresponding ability score modifiers and saving throw modifiers. For more information on ability scores and saving throws, see "Playing the Game."

### Skills
The Skills entry specifies a monster's skill proficiencies, if any. For example, a monster that is very perceptive and stealthy might have bonuses to Wisdom (Perception) and Dexterity (Stealth) checks. A skill bonus is the sum of a monster's relevant ability modifier and its Proficiency Bonus. Other modifiers might apply.

### Resistances and Vulnerabilities
These entries list a monster's Resistances and Vulnerabilities, if any. See "Playing the Game" for more information.

> **RUNNING A MONSTER**
> To ensure a monster acts in accordance with its Challenge Rating, follow these rules during combat:
>
> **Special Abilities.** If the monster has a special ability that deals a lot of damage but has a limited number of uses, such as a recharging breath weapon or a spell it can cast only once per day, have it use that special ability as quickly and as often as possible.
>
> **Multiattack.** If the monster has Multiattack, have it use Multiattack on any of its turns in which it's not using one of its more powerful abilities.
>
> **Bonus Actions, Reactions, Legendary Actions.** If the monster has Bonus Actions, Reactions, or Legendary Actions in its stat block, make sure it uses them as often as it can.

### Immunities
This entry lists the monster's Immunities, if any. If the monster has damage and condition Immunities, the damage types are listed before the conditions. See "Playing the Game" for details.

### Gear
Monsters have proficiency with their equipment. If a monster has equipment that can be given away or retrieved, the items are listed in the Gear entry. The monster's stat block might include special flourishes that happen when the monster uses an item, and the stat block might ignore the rules in "Equipment" for that item. When used by someone else, a retrievable item uses its “Equipment” rules, ignoring any special flourishes in the stat block.

The Gear entry doesn't necessarily list all of a monster's equipment. For example, a monster that wears clothes is assumed to be dressed appropriately, and those clothes aren't in this entry.

Equipment mentioned outside the Gear entry is considered to be supernatural or highly specialized, and it is unusable when the monster is defeated.

### Ammunition and Ranged Attacks
A monster that requires ammunition to make ranged attacks carries the necessary ammunition.

### Equipping a Monster with Other Items
You may equip monsters with additional gear however you like, using the items in “Equipment” for inspiration. You decide how much of a monster's equipment is recoverable after the creature is slain and whether any of that equipment is still usable.

Beware of giving a monster combat-oriented magic items, since those might alter the monster's Challenge Rating. If you do give a monster a magic item, the monster can have Attunement with magic items as noted in "Equipment." A monster with

---
255 System Reference Document 5.2.1

# Page 4

a class tag after its creature type is considered a member of that class for Attunement purposes.

### Senses
The Senses entry specifies a monster's Passive Perception score, as well as any special senses the monster possesses. Passive Perception and special senses are described in "Rules Glossary."

### Languages
This entry lists languages that the monster can use to communicate. Sometimes a monster can understand a language but can't communicate with it, which is noted in its entry. “None” indicates that a creature doesn't comprehend any language.

**Telepathy**
Telepathy is a magical ability that allows a creature to communicate mentally with another creature within a specified range. See "Rules Glossary" for more information.

### Challenge Rating
Challenge Rating is defined in "Rules Glossary," while guidance on using CR to plan potential combat encounters is in “Gameplay Toolbox."

**Experience Points**
The number of Experience Points (XP) a monster is worth is based on its CR, as detailed in the Experience Points by Challenge Rating table. XP is awarded for defeating the monster in combat or otherwise neutralizing it.

Unless a rule says otherwise, a monster summoned by a spell or another magical ability is worth the XP noted in its stat block.

**Experience Points by Challenge Rating**
| CR | XP | CR | XP | CR | XP | CR | XP |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| 0 | 0 or 10 | 14 | 11,500 | 11 | 7,200 | 28 | 120,000 |
| 1/8 | 25 | 15 | 13,000 | 12 | 8,400 | 29 | 135,000 |
| 1/4 | 50 | 16 | 15,000 | 13 | 10,000 | 30 | 155,000 |
| 1/2 | 100 | 17 | 18,000 |
| 1 | 200 | 18 | 20,000 |
| 2 | 450 | 19 | 22,000 |
| 3 | 700 | 20 | 25,000 |
| 4 | 1,100 | 21 | 33,000 |
| 5 | 1,800 | 22 | 41,000 |
| 6 | 2,300 | 23 | 50,000 |
| 7 | 2,900 | 24 | 62,000 |
| 8 | 3,900 | 25 | 75,000 |
| 9 | 5,000 | 26 | 90,000 |
| 10 | 5,900 | 27 | 105,000 |

### Proficiency Bonus
A monster's Proficiency Bonus (PB) is determined by its CR, as shown in the Proficiency Bonus by Challenge Rating table, and is reflected in saving throws, skills, and other statistics where the monster's exceptional aptitude is a factor.

**Proficiency Bonus by Challenge Rating**
| CR | PB | CR | PB |
| :--- | :--- | :--- | :--- |
| 0–4 | +2 | 17–20 | +6 |
| 5–8 | +3 | 21–24 | +7 |
| 9–12 | +4 | 25–28 | +8 |
| 13–16 | +5 | 29–30 | +9 |

### Traits
A monster's traits, if any, are features that are active at all times or in certain situations.

### Actions
A monster can take the actions in this section or take one of the actions available to all creatures, as described in "Playing the Game."

**Attack Notation**
The entry for a monster's attack identifies whether the attack is a melee or a ranged attack and then provides the attack roll's bonus, its reach or range, and what happens on a hit. An attack is against one target unless its entry says otherwise. For details on different kinds of attacks, see "Playing the Game" and "Spells."

**Hit.** Any damage dealt or other effects that occur as a result of an attack hitting a target are described after the "Hit:" notation.

**Miss.** If an attack has an effect that occurs on a miss, that information follows the “Miss:" notation.

**Hit or Miss.** If an attack has an effect that occurs regardless of whether it hits or misses its target, that information follows the "Hit or Miss:" notation.

**Saving Throw Effect Notation**
If an effect forces a saving throw, the effect identifies the kind of save required and then provides the save's DC, a description of which creatures make the save, and an explanation of what happens on a failed or successful save.

"Half damage only" on a successful save means the target takes half as much damage (round down) as targets that fail the save, while also ignoring all other parts of the effect.

---
256 System Reference Document 5.2.1

# Page 5

### Damage Notation
A stat block usually provides both a number and a die expression for each instance of damage. For example, an attack might deal 4 (1d4 + 2) damage on a hit. You decide whether to use the number or the die expression in parentheses; don't use both.

### Multiattack
Some creatures can make more than one attack when they take the Attack action. Such creatures have the Multiattack entry in the "Actions" section of their stat block. This entry details the attacks a creature can make, as well as any additional abilities it can use, as part of the Attack action.

### Spellcasting
If a monster can cast any spells, its stat block lists the spells and provides the monster's spellcasting ability, spell save DC (if any spells require a saving throw), and spell attack bonus (if any spells require an attack roll). Unless noted otherwise, a spell of level 1 or higher is always cast at its lowest possible level and can't be cast at a higher level.

A monster's spell can have special rules or restrictions. For example, a green hag can cast the *Invisibility* spell, but the spell has a "self only" restriction, which means the spell affects only the hag.

**Spell Components.** The Spellcasting trait notes whether the monster's spellcasting ignores the need for certain spell components. If any spell components are required, describe the monster's use of Verbal, Somatic, or Material components to signal to characters that it is casting a spell. A monster that requires Material components has them.

**Casting Times of 1+ Minutes.** If a spell has a casting time of 1 minute or more yet is listed in a spellcasting action, the monster doesn't cast the spell in just one action unless the action's description states otherwise; the monster must take the Magic action on each of its turns and maintain Concentration to cast the spell, as described in "Rules Glossary."

### Bonus Action
If a monster has Bonus Action options, they are listed in this section. See “Playing the Game" for details on Bonus Actions.

### Reactions
If the monster has Reaction options, those are listed in this section along with their triggers. See "Playing the Game" for details on Reactions.

### Legendary Actions
If the monster has Legendary Action options, those are listed in this section. A Legendary Action is an action that a monster can take immediately after another creature's turn. Only one of these actions can be taken at a time and only after another creature's turn ends. The monster can't take a Legendary Action if it has the Incapacitated condition or is otherwise unable to take actions.

The monster has a limited number of Legendary Action uses, and that number is specified in the stat block. The monster expends one use whenever it takes a Legendary Action, and it regains all expended uses at the start of each of its turns.

### Limited Usage
Some parts of a stat block have restrictions on the number of times they can be used. Here are the most common ways that usage is limited:

**X/Day.** This notation means the stat block part can be used a certain number of times (represented by X) and that a monster must finish a Long Rest to regain expended uses. For example, a Reaction that includes "1/Day" means the Reaction can be taken once and that the monster must finish a Long Rest to take it again.

**Recharge X–Y.** This notation means a monster can use the stat block part once. At the start of each of the monster's turns, roll 1d6. If the roll is within the number range given in the notation (represented by X-Y), the monster regains the use of that part, which also recharges when the monster finishes a Short or Long Rest. For example, "Recharge 5–6" in an action means a monster can take the action once. Then, at the start of each of the monster's turns, it regains the use of that action if it rolls a 5 or 6 on 1d6.

**Recharge after a Short or Long Rest.** This notation means the monster can use the stat block part once and must then finish a Short or Long Rest to use it again.

---
257 System Reference Document 5.2.1

# Page 6

# Monsters A–Z
## Aboleth
> ### Aboleth
> *Large Aberration, Lawful Evil*
> ___
> **AC** 17
> **HP** 150 (20d10 + 40)
> **Speed** 10 ft., Swim 40 ft.
> **Initiative** +7 (17)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 21 (+5) | +5   DEX 9  (-1) | +3   CON 15 (+2) | +6
> INT 18 (+4) | +8   WIS 15 (+2) | +6   CHA 18 (+4) | +4
> ```
> ___
> **Skills** History +12, Perception +10
> **Senses** Darkvision 120 ft.; Passive Perception 20
> **Languages** Deep Speech; telepathy 120 ft.
> **CR** 10 (XP 5,900, or 7,200 in lair; PB +4)
> ### Traits
> **Amphibious.** The aboleth can breathe air and water.
>
> **Eldritch Restoration.** If destroyed, the aboleth gains a new body in 5d10 days, reviving with all its Hit Points in the Far Realm or another location chosen by the GM.
>
> **Legendary Resistance (3/Day, or 4/Day in Lair).** If the aboleth fails a saving throw, it can choose to succeed instead.
>
> **Mucus Cloud.** While underwater, the aboleth is surrounded by mucus. *Constitution Saving Throw:* DC 14, each creature in a 5-foot Emanation originating from the aboleth at the end of the aboleth's turn. *Failure:* The target is cursed. Until the curse ends, the target's skin becomes slimy, the target can breathe air and water, and it can't regain Hit Points unless it is underwater.
> While the cursed creature is outside a body of water, the creature takes 6 (1d12) Acid damage at the end of every 10 minutes unless moisture is applied to its skin before those minutes have passed.
>
> **Probing Telepathy.** If a creature the aboleth can see communicates telepathically with the aboleth, the aboleth learns the creature's greatest desires.
> ### Actions
> **Multiattack.** The aboleth makes two Tentacle attacks and uses either Consume Memories or Dominate Mind if available.
>
> **Tentacle.** *Melee Attack Roll:* +9, reach 15 ft. *Hit:* 12 (2d6 + 5) Bludgeoning damage. If the target is a Large or smaller creature, it has the Grappled condition (escape DC 14) from one of four tentacles.
>
> **Consume Memories.** *Intelligence Saving Throw:* DC 16, one creature within 30 feet that is Charmed or Grappled by the aboleth. *Failure:* 10 (3d6) Psychic damage. *Success:* Half damage. *Failure or Success:* The aboleth gains the target's memories if the target is a Humanoid and is reduced to 0 Hit Points by this action.
>
> **Dominate Mind (2/Day).** *Wisdom Saving Throw:* DC 16, one creature the aboleth can see within 30 feet. *Failure:* The target has the Charmed condition until the aboleth dies or is on a different plane of existence from the target. While Charmed, the target acts as an ally to the aboleth and is under its control while within 60 feet of it. In addition, the aboleth and the target can communicate telepathically with each other over any distance.
> The target repeats the save whenever it takes damage as well as after every 24 hours it spends at least 1 mile away from the aboleth, ending the effect on itself on a success.
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the aboleth can expend a use to take one of the following actions. The aboleth regains all expended uses at the start of each of its turns.
>
> **Lash.** The aboleth makes one Tentacle attack.
>
> **Psychic Drain.** If the aboleth has at least one creature Charmed or Grappled, it uses Consume Memories and regains 5 (1d10) Hit Points.

## Air Elemental
> ### Air Elemental
> *Large Elemental, Neutral*
> ___
> **AC** 15
> **HP** 90 (12d10 + 24)
> **Speed** 10 ft., Fly 90 ft. (hover)
> **Initiative** +5 (15)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 14 (+2) | +2   DEX 20 (+5) | +5   CON 14 (+2) | +2
> INT 6  (-2) | -2   WIS 10 (+0) | +0   CHA 6  (-2) | -2
> ```
> ___
> **Resistances** Bludgeoning, Lightning, Piercing, Slashing
> **Immunities** Poison, Thunder; Exhaustion, Grappled, Paralyzed, Petrified, Poisoned, Prone, Restrained, Unconscious
> **Senses** Darkvision 60 ft.; Passive Perception 10
> **Languages** Primordial (Auran)
> **CR** 5 (XP 1,800; PB +3)
> ### Traits
> **Air Form.** The elemental can enter a creature's space and stop there. It can move through a space as narrow as 1 inch without expending extra movement to do so.
> ### Actions
> **Multiattack.** The elemental makes two Thunderous Slam attacks.
>
> **Thunderous Slam.** *Melee Attack Roll:* +8, reach 10 ft. *Hit:* 14 (2d8 + 5) Thunder damage.

---
258 System Reference Document 5.2.1

# Page 7

> **Whirlwind (Recharge 4–6).** *Strength Saving Throw:* DC 13, one Medium or smaller creature in the elemental's space. *Failure:* 24 (4d10 + 2) Thunder damage, and the target is pushed up to 20 feet straight away from the elemental and has the Prone condition. *Success:* Half damage only.

## Animated Objects
> ### Animated Armor
> *Medium Construct, Unaligned*
> ___
> **AC** 18
> **HP** 33 (6d8 + 6)
> **Speed** 25 ft.
> **Initiative** +2 (12)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 14 (+2) | +2   DEX 11 (+0) | +0   CON 13 (+1) | +1
> INT 1  (-5) | -5   WIS 3  (-4) | -4   CHA 1  (-5) | -5
> ```
> ___
> **Immunities** Poison, Psychic; Charmed, Deafened, Exhaustion, Frightened, Paralyzed, Petrified, Poisoned
> **Senses** Blindsight 60 ft.; Passive Perception 6
> **Languages** None
> **CR** 1 (XP 200; PB +2)
> ### Actions
> **Multiattack.** The armor makes two Slam attacks.
>
> **Slam.** *Melee Attack Roll:* +4, reach 5 ft. *Hit:* 5 (1d6 + 2) Bludgeoning damage.
>
> ### Animated Flying Sword
> *Small Construct, Unaligned*
> ___
> **AC** 17
> **HP** 14 (4d6)
> **Speed** 5 ft., Fly 50 ft. (hover)
> **Initiative** +4 (14)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 12 (+1) | +1   DEX 15 (+2) | +4   CON 11 (+0) | +0
> INT 1  (-5) | -5   WIS 5  (-3) | -3   CHA 1  (-5) | -5
> ```
> ___
> **Immunities** Poison, Psychic; Charmed, Deafened, Exhaustion, Frightened, Paralyzed, Petrified, Poisoned
> **Senses** Blindsight 60 ft.; Passive Perception 7
> **Languages** None
> **CR** 1/4 (XP 50; PB +2)
> ### Actions
> **Slash.** *Melee Attack Roll:* +4, reach 5 ft. *Hit:* 6 (1d8 + 2) Slashing damage.
>
> ### Animated Rug of Smothering
> *Large Construct, Unaligned*
> ___
> **AC** 12
> **HP** 27 (5d10)
> **Speed** 10 ft.
> **Initiative** +4 (14)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 17 (+3) | +3   DEX 14 (+2) | +2   CON 10 (+0) | +0
> INT 1  (-5) | -5   WIS 3  (-4) | -4   CHA 1  (-5) | -5
> ```
> ___
> **Immunities** Poison, Psychic; Charmed, Deafened, Exhaustion, Frightened, Paralyzed, Petrified, Poisoned
> **Senses** Blindsight 60 ft.; Passive Perception 6
> **Languages** None
> **CR** 2 (XP 450; PB +2)
> ### Actions
> **Smother.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 10 (2d6 + 3) Bludgeoning damage. If the target is a Medium or smaller creature, the rug can give it the Grappled condition (escape DC 13) instead of dealing damage. Until the grapple ends, the target has the Blinded and Restrained conditions, is suffocating, and takes 10 (2d6 + 3) Bludgeoning damage at the start of each of its turns. The rug can smother only one creature at a time.
> While grappling the target, the rug can't take this action, the rug halves the damage it takes (round down), and the target takes the same amount of damage.

## Ankheg
> ### Ankheg
> *Large Monstrosity, Unaligned*
> ___
> **AC** 14
> **HP** 45 (6d10 + 12)
> **Speed** 30 ft., Burrow 10 ft.
> **Initiative** +0 (10)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 17 (+3) | +3   DEX 11 (+0) | +0   CON 14 (+2) | +2
> INT 1  (-5) | -5   WIS 13 (+1) | +1   CHA 6  (-2) | -2
> ```
> ___
> **Senses** Darkvision 60 ft., Tremorsense 60 ft.; Passive Perception 11
> **Languages** None
> **CR** 2 (XP 450; PB +2)
> ### Traits
> **Tunneler.** The ankheg can burrow through solid rock at half its Burrow Speed and leaves a 10-foot-diameter tunnel in its wake.
> ### Actions
> **Bite.** *Melee Attack Roll:* +5 (with Advantage if the target is Grappled by the ankheg), reach 5 ft. *Hit:* 10 (2d6 + 3) Slashing damage plus 3 (1d6) Acid damage. If the target is a Large or smaller creature, it has the Grappled condition (escape DC 13).
>
> **Acid Spray (Recharge 6).** *Dexterity Saving Throw:* DC 12, each creature in a 30-foot-long, 5-foot-wide Line. *Failure:* 14 (4d6) Acid damage. *Success:* Half damage.

---
259 System Reference Document 5.2.1

# Page 8

## Assassin
> ### Assassin
> *Medium or Small Humanoid, Neutral*
> ___
> **AC** 16
> **HP** 97 (15d8 + 30)
> **Speed** 30 ft.
> **Initiative** +10 (20)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 11 (+0) | +0   DEX 18 (+4) | +7   CON 14 (+2) | +2
> INT 16 (+3) | +6   WIS 11 (+0) | +0   CHA 10 (+0) | +0
> ```
> ___
> **Skills** Acrobatics +7, Perception +6, Stealth +10
> **Resistances** Poison
> **Gear** Light Crossbow, Shortsword, Studded Leather Armor
> **Senses** Passive Perception 16
> **Languages** Common, Thieves' Cant
> **CR** 8 (XP 3,900; PB +3)
> ### Traits
> **Evasion.** If the assassin is subjected to an effect that allows it to make a Dexterity saving throw to take only half damage, the assassin instead takes no damage if it succeeds on the save and only half damage if it fails. It can't use this trait if it has the Incapacitated condition.
> ### Actions
> **Multiattack.** The assassin makes three attacks, using Shortsword or Light Crossbow in any combination.
>
> **Shortsword.** *Melee Attack Roll:* +7, reach 5 ft. *Hit:* 7 (1d6 + 4) Piercing damage plus 17 (5d6) Poison damage, and the target has the Poisoned condition until the start of the assassin's next turn.
>
> **Light Crossbow.** *Ranged Attack Roll:* +7, range 80/320 ft. *Hit:* 8 (1d8 + 4) Piercing damage plus 21 (6d6) Poison damage.
> ### Bonus Actions
> **Cunning Action.** The assassin takes the Dash, Disengage, or Hide action.

## Awakened Plants
> ### Awakened Shrub
> *Small Plant, Neutral*
> ___
> **AC** 9
> **HP** 10 (3d6)
> **Speed** 20 ft.
> **Initiative** -1 (9)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 3  (-4) | -4   DEX 8  (-1) | -1   CON 11 (+0) | +0
> INT 10 (+0) | +0   WIS 10 (+0) | +0   CHA 6  (-2) | -2
> ```
> ___
> **Vulnerabilities** Fire
> **Resistances** Piercing
> **Senses** Passive Perception 10
> **Languages** Common plus one other language
> **CR** 0 (XP 10; PB +2)
> ### Actions
> **Rake.** *Melee Attack Roll:* +1, reach 5 ft. *Hit:* 1 Slashing damage.
>
> ### Awakened Tree
> *Huge Plant, Neutral*
> ___
> **AC** 13
> **HP** 59 (7d12 + 14)
> **Speed** 20 ft.
> **Initiative** -2 (8)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 19 (+4) | +4   DEX 6  (-2) | -2   CON 15 (+2) | +2
> INT 10 (+0) | +0   WIS 10 (+0) | +0   CHA 7  (-2) | -2
> ```
> ___
> **Vulnerabilities** Fire
> **Resistances** Bludgeoning, Piercing
> **Senses** Passive Perception 10
> **Languages** Common plus one other language
> **CR** 2 (XP 450; PB +2)
> ### Actions
> **Slam.** *Melee Attack Roll:* +6, reach 10 ft. *Hit:* 14 (3d6 + 4) Bludgeoning damage.

## Axe Beak
> ### Axe Beak
> *Large Monstrosity, Unaligned*
> ___
> **AC** 11
> **HP** 19 (3d10 + 3)
> **Speed** 50 ft.
> **Initiative** +1 (11)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 14 (+2) | +2   DEX 12 (+1) | +1   CON 12 (+1) | +1
> INT 2  (-4) | -4   WIS 10 (+0) | +0   CHA 5  (-3) | -3
> ```
> ___
> **Senses** Passive Perception 10
> **Languages** None
> **CR** 1/4 (XP 50; PB +2)
> ### Actions
> **Beak.** *Melee Attack Roll:* +4, reach 5 ft. *Hit:* 6 (1d8 + 2) Slashing damage.

---
260 System Reference Document 5.2.1

# Page 9

## Azer
> ### Azer Sentinel
> *Medium Elemental, Lawful Neutral*
> ___
> **AC** 17
> **HP** 39 (6d8 + 12)
> **Speed** 30 ft.
> **Initiative** +1 (11)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 17 (+3) | +3   DEX 12 (+1) | +1   CON 15 (+2) | +4
> INT 12 (+1) | +1   WIS 13 (+1) | +1   CHA 10 (+0) | +0
> ```
> ___
> **Immunities** Fire, Poison; Poisoned
> **Senses** Passive Perception 11
> **Languages** Primordial (Ignan)
> **CR** 2 (XP 450; PB +2)
> ### Traits
> **Fire Aura.** At the end of each of the azer's turns, each creature of the azer's choice in a 5-foot Emanation originating from the azer takes 5 (1d10) Fire damage unless the azer has the Incapacitated condition.
>
> **Illumination.** The azer sheds Bright Light in a 10-foot radius and Dim Light for an additional 10 feet.
> ### Actions
> **Burning Hammer.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 8 (1d10 + 3) Bludgeoning damage plus 3 (1d6) Fire damage.

## Balor
> ### Balor
> *Huge Fiend (Demon), Chaotic Evil*
> ___
> **AC** 19
> **HP** 287 (23d12 + 138)
> **Speed** 40 ft., Fly 80 ft.
> **Initiative** +14 (24)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 26 (+8) | +8   DEX 15 (+2) | +2   CON 22 (+6) | +12
> INT 20 (+5) | +5   WIS 16 (+3) | +9   CHA 22 (+6) | +6
> ```
> ___
> **Skills** Perception +9
> **Resistances** Cold, Lightning
> **Immunities** Fire, Poison; Charmed, Frightened, Poisoned
> **Senses** Truesight 120 ft.; Passive Perception 19
> **Languages** Abyssal; telepathy 120 ft.
> **CR** 19 (XP 22,000; PB +6)
> ### Traits
> **Death Throes.** The balor explodes when it dies. *Dexterity Saving Throw:* DC 20, each creature in a 30-foot Emanation originating from the balor. *Failure:* 31 (9d6) Fire damage plus 31 (9d6) Force damage. *Success:* Half damage. *Failure or Success:* If the balor dies outside the Abyss, it gains a new body instantly, reviving with all its Hit Points somewhere in the Abyss.
> **Fire Aura.** At the end of each of the balor's turns, each creature in a 5-foot Emanation originating from the balor takes 13 (3d8) Fire damage.
>
> **Legendary Resistance (3/Day).** If the balor fails a saving throw, it can choose to succeed instead.
>
> **Magic Resistance.** The balor has Advantage on saving throws against spells and other magical effects.
> ### Actions
> **Multiattack.** The balor makes one Flame Whip attack and one Lightning Blade attack.
>
> **Flame Whip.** *Melee Attack Roll:* +14, reach 30 ft. *Hit:* 18 (3d6 + 8) Force damage plus 17 (5d6) Fire damage. If the target is a Huge or smaller creature, the balor pulls the target up to 25 feet straight toward itself, and the target has the Prone condition.
>
> **Lightning Blade.** *Melee Attack Roll:* +14, reach 10 ft. *Hit:* 21 (3d8 + 8) Force damage plus 22 (4d10) Lightning damage, and the target can't take Reactions until the start of the balor's next turn.
> ### Bonus Actions
> **Teleport.** The balor teleports itself or a willing demon within 10 feet of itself up to 60 feet to an unoccupied space the balor can see.

## Bandits
> ### Bandit
> *Medium or Small Humanoid, Neutral*
> ___
> **AC** 12
> **HP** 11 (2d8 + 2)
> **Speed** 30 ft.
> **Initiative** +1 (11)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 11 (+0) | +0   DEX 12 (+1) | +1   CON 12 (+1) | +1
> INT 10 (+0) | +0   WIS 10 (+0) | +0   CHA 10 (+0) | +0
> ```
> ___
> **Gear** Leather Armor, Light Crossbow, Scimitar
> **Senses** Passive Perception 10
> **Languages** Common, Thieves' Cant
> **CR** 1/8 (XP 25; PB +2)
> ### Actions
> **Scimitar.** *Melee Attack Roll:* +3, reach 5 ft. *Hit:* 4 (1d6 + 1) Slashing damage.
>
> **Light Crossbow.** *Ranged Attack Roll:* +3, range 80/320 ft. *Hit:* 5 (1d8 + 1) Piercing damage.
>
> ### Bandit Captain
> *Medium or Small Humanoid, Neutral*
> ___
> **AC** 15
> **HP** 52 (8d8 + 16)
> **Speed** 30 ft.
> **Initiative** +3 (13)

---
261 System Reference Document 5.2.1

# Page 10

> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 15 (+2) | +4   DEX 16 (+3) | +5   CON 14 (+2) | +2
> INT 14 (+2) | +2   WIS 11 (+0) | +2   CHA 14 (+2) | +2
> ```
> ___
> **Skills** Athletics +4, Deception +4
> **Gear** Pistol, Scimitar, Studded Leather Armor
> **Senses** Passive Perception 10
> **Languages** Common, Thieves' Cant
> **CR** 2 (XP 450; PB +2)
> ### Actions
> **Multiattack.** The bandit makes two attacks, using Scimitar and Pistol in any combination.
>
> **Scimitar.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 6 (1d6 + 3) Slashing damage.
>
> **Pistol.** *Ranged Attack Roll:* +5, range 30/90 ft. *Hit:* 8 (1d10 + 3) Piercing damage.
> ### Reactions
> **Parry.** *Trigger:* The bandit is hit by a melee attack roll while holding a weapon. *Response:* The bandit adds 2 to its AC against that attack, possibly causing it to miss.

## Barbed Devil
> ### Barbed Devil
> *Medium Fiend (Devil), Lawful Evil*
> ___
> **AC** 15
> **HP** 110 (13d8 + 52)
> **Speed** 30 ft., Climb 30 ft.
> **Initiative** +3 (13)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 16 (+3) | +6   DEX 17 (+3) | +3   CON 18 (+4) | +7
> INT 12 (+1) | +1   WIS 14 (+2) | +5   CHA 14 (+2) | +5
> ```
> ___
> **Skills** Deception +5, Insight +5, Perception +8
> **Resistances** Cold
> **Immunities** Fire, Poison; Poisoned
> **Senses** Darkvision 120 ft. (unimpeded by magical Darkness); Passive Perception 18
> **Languages** Infernal; telepathy 120 ft.
> **CR** 5 (XP 1,800; PB +3)
> ### Traits
> **Barbed Hide.** At the start of each of its turns, the devil deals 5 (1d10) Piercing damage to any creature it is grappling or any creature grappling it.
>
> **Diabolical Restoration.** If the devil dies outside the Nine Hells, its body disappears in sulfurous smoke, and it gains a new body instantly, reviving with all its Hit Points somewhere in the Nine Hells.
>
> **Magic Resistance.** The devil has Advantage on saving throws against spells and other magical effects.
> ### Actions
> **Multiattack.** The devil makes one Claws attack and one Tail attack, or it makes two Hurl Flame attacks.
> **Claws.** *Melee Attack Roll:* +6, reach 5 ft. *Hit:* 10 (2d6 + 3) Piercing damage. If the target is a Large or smaller creature, it has the Grappled condition (escape DC 13) from both claws.
>
> **Tail.** *Melee Attack Roll:* +6, reach 10 ft. *Hit:* 14 (2d10 + 3) Slashing damage.
>
> **Hurl Flame.** *Ranged Attack Roll:* +5, range 150 ft. *Hit:* 17 (5d6) Fire damage. If the target is a flammable object that isn't being worn or carried, it starts burning.

## Basilisk
> ### Basilisk
> *Medium Monstrosity, Unaligned*
> ___
> **AC** 15
> **HP** 52 (8d8 + 16)
> **Speed** 20 ft.
> **Initiative** -1 (9)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 16 (+3) | +3   DEX 8  (-1) | -1   CON 15 (+2) | +2
> INT 2  (-4) | -4   WIS 8  (-1) | -1   CHA 7  (-2) | -2
> ```
> ___
> **Senses** Darkvision 60 ft.; Passive Perception 9
> **Languages** None
> **CR** 3 (XP 700; PB +2)
> ### Actions
> **Bite.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 10 (2d6 + 3) Piercing damage plus 7 (2d6) Poison damage.
> ### Bonus Actions
> **Petrifying Gaze (Recharge 4–6).** *Constitution Saving Throw:* DC 12, each creature in a 30-foot Cone. If the basilisk sees its reflection in the Cone, the basilisk must make this save. *First Failure:* The target has the Restrained condition and repeats the save at the end of its next turn if it is still Restrained, ending the effect on itself on a success. *Second Failure:* The target has the Petrified condition instead of the Restrained condition.

## Bearded Devil
> ### Bearded Devil
> *Medium Fiend (Devil), Lawful Evil*
> ___
> **AC** 13
> **HP** 58 (9d8 + 18)
> **Speed** 30 ft.
> **Initiative** +2 (12)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 16 (+3) | +5   DEX 15 (+2) | +2   CON 15 (+2) | +4
> INT 9  (-1) | -1   WIS 11 (+0) | +0   CHA 14 (+2) | +4
> ```
> ___
> **Resistances** Cold
> **Immunities** Fire, Poison; Frightened, Poisoned
> **Senses** Darkvision 120 ft. (unimpeded by magical Darkness); Passive Perception 10
> **Languages** Infernal; telepathy 120 ft.
> **CR** 3 (XP 700; PB +2)

---
262 System Reference Document 5.2.1

# Page 11

> ### Traits
> **Magic Resistance.** The devil has Advantage on saving throws against spells and other magical effects.
> ### Actions
> **Multiattack.** The devil makes one Beard attack and one Infernal Glaive attack.
>
> **Beard.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 7 (1d8 + 3) Piercing damage, and the target has the Poisoned condition until the start of the devil's next turn. Until this poison ends, the target can't regain Hit Points.
>
> **Infernal Glaive.** *Melee Attack Roll:* +5, reach 10 ft. *Hit:* 8 (1d10 + 3) Slashing damage. If the target is a creature and doesn't already have an infernal wound, it is subjected to the following effect. *Constitution Saving Throw:* DC 12. *Failure:* The target receives an infernal wound. While wounded, the target loses 5 (1d10) Hit Points at the start of each of its turns. The wound closes after 1 minute, after a spell restores Hit Points to the target, or after the target or a creature within 5 feet of it takes an action to stanch the wound, doing so by succeeding on a DC 12 Wisdom (Medicine) check.

## Behir
> ### Behir
> *Huge Monstrosity, Neutral Evil*
> ___
> **AC** 17
> **HP** 168 (16d12 + 64)
> **Speed** 50 ft., Climb 50 ft.
> **Initiative** +3 (13)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 23 (+6) | +6   DEX 16 (+3) | +3   CON 18 (+4) | +4
> INT 7  (-2) | -2   WIS 14 (+2) | +2   CHA 12 (+1) | +1
> ```
> ___
> **Skills** Perception +6, Stealth +7
> **Immunities** Lightning
> **Senses** Darkvision 90 ft.; Passive Perception 16
> **Languages** Draconic
> **CR** 11 (XP 7,200; PB +4)
> ### Actions
> **Multiattack.** The behir makes one Bite attack and uses Constrict.
>
> **Bite.** *Melee Attack Roll:* +10, reach 10 ft. *Hit:* 19 (2d12 + 6) Piercing damage plus 11 (2d10) Lightning damage.
>
> **Constrict.** *Strength Saving Throw:* DC 18, one Large or smaller creature the behir can see within 5 feet. *Failure:* 28 (5d8 + 6) Bludgeoning damage. The target has the Grappled condition (escape DC 16), and it has the Restrained condition until the grapple ends.
>
> **Lightning Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 16, each creature in a 90-foot-long, 5-foot-wide Line. *Failure:* 66 (12d10) Lightning damage. *Success:* Half damage.
> ### Bonus Actions
> **Swallow.** *Dexterity Saving Throw:* DC 18, one Large or smaller creature Grappled by the behir (the behir can have only one creature swallowed at a time). *Failure:* The behir swallows the target, which is no longer Grappled. While swallowed, a creature has the Blinded and Restrained conditions, has Total Cover against attacks and other effects outside the behir, and takes 21 (6d6) Acid damage at the start of each of the behir's turns.
> If the behir takes 30 damage or more on a single turn from the swallowed creature, the behir must succeed on a DC 14 Constitution saving throw at the end of that turn or regurgitate the creature, which falls in a space within 10 feet of the behir and has the Prone condition. If the behir dies, a swallowed creature is no longer Restrained and can escape from the corpse by using 15 feet of movement, exiting Prone.

## Berserker
> ### Berserker
> *Medium or Small Humanoid, Neutral*
> ___
> **AC** 13
> **HP** 67 (9d8 + 27)
> **Speed** 30 ft.
> **Initiative** +1 (11)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 16 (+3) | +3   DEX 12 (+1) | +1   CON 17 (+3) | +3
> INT 9  (-1) | -1   WIS 11 (+0) | +0   CHA 9  (-1) | -1
> ```
> ___
> **Gear** Greataxe, Hide Armor
> **Senses** Passive Perception 10
> **Languages** Common
> **CR** 2 (XP 450; PB +2)
> ### Traits
> **Bloodied Frenzy.** While Bloodied, the berserker has Advantage on attack rolls and saving throws.
> ### Actions
> **Greataxe.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 9 (1d12 + 3) Slashing damage.

## Black Dragons
> ### Black Dragon Wyrmling
> *Medium Dragon (Chromatic), Chaotic Evil*
> ___
> **AC** 17
> **HP** 33 (6d8 + 6)
> **Speed** 30 ft., Fly 60 ft., Swim 30 ft.
> **Initiative** +4 (14)

---
263 System Reference Document 5.2.1

# Page 12

> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 15 (+2) | +2   DEX 14 (+2) | +4   CON 13 (+1) | +1
> INT 10 (+0) | +0   WIS 11 (+0) | +2   CHA 13 (+1) | +1
> ```
> ___
> **Skills** Perception +4, Stealth +4
> **Immunities** Acid
> **Senses** Blindsight 10 ft., Darkvision 60 ft.; Passive Perception 14
> **Languages** Draconic
> **CR** 2 (XP 450; PB +2)
> ### Traits
> **Amphibious.** The dragon can breathe air and water.
> ### Actions
> **Multiattack.** The dragon makes two Rend attacks.
>
> **Rend.** *Melee Attack Roll:* +4, reach 5 ft. *Hit:* 5 (1d6 + 2) Slashing damage plus 2 (1d4) Acid damage.
>
> **Acid Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 11, each creature in a 15-foot-long, 5-foot-wide Line. *Failure:* 22 (5d8) Acid damage. *Success:* Half damage.
>
> ### Young Black Dragon
> *Large Dragon (Chromatic), Chaotic Evil*
> ___
> **AC** 18
> **HP** 127 (15d10 + 45)
> **Speed** 40 ft., Fly 80 ft., Swim 40 ft.
> **Initiative** +5 (15)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 19 (+4) | +4   DEX 14 (+2) | +5   CON 17 (+3) | +3
> INT 12 (+1) | +1   WIS 11 (+0) | +3   CHA 15 (+2) | +2
> ```
> ___
> **Skills** Perception +6, Stealth +5
> **Immunities** Acid
> **Senses** Blindsight 30 ft., Darkvision 120 ft.; Passive Perception 16
> **Languages** Common, Draconic
> **CR** 7 (XP 2,900; PB +3)
> ### Traits
> **Amphibious.** The dragon can breathe air and water.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks.
>
> **Rend.** *Melee Attack Roll:* +7, reach 10 ft. *Hit:* 9 (2d4 + 4) Slashing damage plus 3 (1d6) Acid damage.
>
> **Acid Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 14, each creature in a 30-foot-long, 5-foot-wide Line. *Failure:* 49 (14d6) Acid damage. *Success:* Half damage.

> ### Adult Black Dragon
> *Huge Dragon (Chromatic), Chaotic Evil*
> ___
> **AC** 19
> **HP** 195 (17d12 + 85)
> **Speed** 40 ft., Fly 80 ft., Swim 40 ft.
> **Initiative** +12 (22)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 23 (+6) | +6   DEX 14 (+2) | +7   CON 21 (+5) | +5
> INT 14 (+2) | +2   WIS 13 (+1) | +6   CHA 19 (+4) | +4
> ```
> ___
> **Skills** Perception +11, Stealth +7
> **Immunities** Acid
> **Senses** Blindsight 60 ft., Darkvision 120 ft.; Passive Perception 21
> **Languages** Common, Draconic
> **CR** 14 (XP 11,500, or 13,000 in lair; PB +5)
> ### Traits
> **Amphibious.** The dragon can breathe air and water.
>
> **Legendary Resistance (3/Day, or 4/Day in Lair).** If the dragon fails a saving throw, it can choose to succeed instead.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of Spellcasting to cast *Acid Arrow* (level 3 version).
>
> **Rend.** *Melee Attack Roll:* +11, reach 10 ft. *Hit:* 13 (2d6 + 6) Slashing damage plus 4 (1d8) Acid damage.
>
> **Acid Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 18, each creature in a 60-foot-long, 5-foot-wide Line. *Failure:* 54 (12d8) Acid damage. *Success:* Half damage.
>
> **Spellcasting.** The dragon casts one of the following spells, requiring no Material components and using Charisma as the spellcasting ability (spell save DC 17, +9 to hit with spell attacks):
>
> **At Will:** *Acid Arrow* (level 3 version), *Detect Magic, Fear*
> **1/Day Each:** *Speak with Dead, Vitriolic Sphere*
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the dragon can expend a use to take one of the following actions. The dragon regains all expended uses at the start of each of its turns.
>
> **Cloud of Insects.** *Dexterity Saving Throw:* DC 17, one creature the dragon can see within 120 feet. *Failure:* 22 (4d10) Poison damage, and the target has Disadvantage on saving throws to maintain Concentration until the end of its next turn. *Failure or Success:* The dragon can't take this action again until the start of its next turn.
>
> **Frightful Presence.** The dragon uses Spellcasting to cast *Fear*. The dragon can't take this action again until the start of its next turn.
>
> **Pounce.** The dragon moves up to half its Speed, and it makes one Rend attack.

---
264 System Reference Document 5.2.1

# Page 13

> ### Ancient Black Dragon
> *Gargantuan Dragon (Chromatic), Chaotic Evil*
> ___
> **AC** 22
> **HP** 367 (21d20 + 147)
> **Speed** 40 ft., Fly 80 ft., Swim 40 ft.
> **Initiative** +16 (26)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 27 (+8) | +8   DEX 14 (+2) | +9   CON 25 (+7) | +7
> INT 16 (+3) | +3   WIS 15 (+2) | +9   CHA 22 (+6) | +6
> ```
> ___
> **Skills** Perception +16, Stealth +9
> **Immunities** Acid
> **Senses** Blindsight 60 ft., Darkvision 120 ft.; Passive Perception 26
> **Languages** Common, Draconic
> **CR** 21 (XP 33,000, or 41,000 in lair; PB +7)
> ### Traits
> **Amphibious.** The dragon can breathe air and water.
>
> **Legendary Resistance (4/Day, or 5/Day in Lair).** If the dragon fails a saving throw, it can choose to succeed instead.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of Spellcasting to cast *Acid Arrow* (level 4 version).
>
> **Rend.** *Melee Attack Roll:* +15, reach 15 ft. *Hit:* 17 (2d8 + 8) Slashing damage plus 9 (2d8) Acid damage.
>
> **Acid Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 22, each creature in a 90-foot-long, 10-foot-wide Line. *Failure:* 67 (15d8) Acid damage. *Success:* Half damage.
>
> **Spellcasting.** The dragon casts one of the following spells, requiring no Material components and using Charisma as the spellcasting ability (spell save DC 21, +13 to hit with spell attacks):
>
> **At Will:** *Acid Arrow* (level 4 version), *Detect Magic, Fear*
> **1/Day Each:** *Create Undead, Speak with Dead, Vitriolic Sphere* (level 5 version)
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the dragon can expend a use to take one of the following actions. The dragon regains all expended uses at the start of each of its turns.
>
> **Cloud of Insects.** *Dexterity Saving Throw:* DC 21, one creature the dragon can see within 120 feet. *Failure:* 33 (6d10) Poison damage, and the target has Disadvantage on saving throws to maintain Concentration until the end of its next turn. *Failure or Success:* The dragon can't take this action again until the start of its next turn.
>
> **Frightful Presence.** The dragon uses Spellcasting to cast *Fear*. The dragon can't take this action again until the start of its next turn.
>
> **Pounce.** The dragon moves up to half its Speed, and it makes one Rend attack.

## Black Pudding
> ### Black Pudding
> *Large Ooze, Unaligned*
> ___
> **AC** 7
> **HP** 68 (8d10 + 24)
> **Speed** 20 ft., Climb 20 ft.
> **Initiative** –3 (7)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 16 (+3) | +3   DEX 5  (-3) | -3   CON 16 (+3) | +3
> INT 1  (-5) | -5   WIS 6  (-2) | -2   CHA 1  (-5) | -5
> ```
> ___
> **Immunities** Acid, Cold, Lightning, Slashing; Charmed, Deafened, Exhaustion, Frightened, Grappled, Prone, Restrained
> **Senses** Blindsight 60 ft.; Passive Perception 8
> **Languages** None
> **CR** 4 (XP 1,100; PB +2)
> ### Traits
> **Amorphous.** The pudding can move through a space as narrow as 1 inch without expending extra movement to do so.
>
> **Corrosive Form.** A creature that hits the pudding with a melee attack roll takes 4 (1d8) Acid damage. Nonmagical ammunition is destroyed immediately after hitting the pudding and dealing any damage. Any nonmagical weapon takes a cumulative –1 penalty to attack rolls immediately after dealing damage to the pudding and coming into contact with it. The weapon is destroyed if the penalty reaches –5. The penalty can be removed by casting the *Mending* spell on the weapon.
> In 1 minute, the pudding can eat through 2 feet of nonmagical wood or metal.
>
> **Spider Climb.** The pudding can climb difficult surfaces, including along ceilings, without needing to make an ability check.
> ### Actions
> **Dissolving Pseudopod.** *Melee Attack Roll:* +5, reach 10 ft. *Hit:* 17 (4d6 + 3) Acid damage. Nonmagical armor worn by the target takes a -1 penalty to the AC it offers. The armor is destroyed if the penalty reduces its AC to 10. The penalty can be removed by casting the *Mending* spell on the armor.
> ### Reactions
> **Split.** *Trigger:* While the pudding is Large or Medium and has 10+ Hit Points, it becomes Bloodied or is subjected to Lightning or Slashing damage. *Response:* The pudding splits into two new **Black Puddings**. Each new pudding is one size smaller than the original pudding and acts on its Initiative. The original pudding's Hit

---
265 System Reference Document 5.2.1

# Page 14

> Points are divided evenly between the new puddings (round down).

## Blink Dog
> ### Blink Dog
> *Medium Fey, Lawful Good*
> ___
> **AC** 13
> **HP** 22 (4d8 + 4)
> **Speed** 40 ft.
> **Initiative** +3 (13)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 12 (+1) | +1   DEX 17 (+3) | +3   CON 12 (+1) | +1
> INT 10 (+0) | +0   WIS 13 (+1) | +1   CHA 11 (+0) | +0
> ```
> ___
> **Skills** Perception +5, Stealth +5
> **Senses** Darkvision 60 ft.; Passive Perception 15
> **Languages** Blink Dog; understands Elvish and Sylvan but can't speak them
> **CR** 1/4 (XP 50; PB +2)
> ### Actions
> **Bite.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 5 (1d4 + 3) Piercing damage.
> ### Bonus Actions
> **Teleport (Recharge 4–6).** The dog teleports up to 40 feet to an unoccupied space it can see.

## Blue Dragons
> ### Blue Dragon Wyrmling
> *Medium Dragon (Chromatic), Lawful Evil*
> ___
> **AC** 17
> **HP** 65 (10d8 + 20)
> **Speed** 30 ft., Burrow 15 ft., Fly 60 ft.
> **Initiative** +2 (12)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 17 (+3) | +3   DEX 10 (+0) | +2   CON 15 (+2) | +2
> INT 12 (+1) | +1   WIS 11 (+0) | +2   CHA 15 (+2) | +2
> ```
> ___
> **Skills** Perception +4, Stealth +2
> **Immunities** Lightning
> **Senses** Blindsight 10 ft., Darkvision 60 ft.; Passive Perception 14
> **Languages** Draconic
> **CR** 3 (XP 700; PB +2)
> ### Actions
> **Multiattack.** The dragon makes two Rend attacks.
>
> **Rend.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 8 (1d10 + 3) Slashing damage plus 3 (1d6) Lightning damage.
>
> **Lightning Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 12, each creature in a 30-foot-long, 5-foot-wide Line. *Failure:* 21 (6d6) Lightning damage. *Success:* Half damage.

> ### Young Blue Dragon
> *Large Dragon (Chromatic), Lawful Evil*
> ___
> **AC** 18
> **HP** 152 (16d10 + 64)
> **Speed** 40 ft., Burrow 20 ft., Fly 80 ft.
> **Initiative** +4 (14)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 21 (+5) | +5   DEX 10 (+0) | +4   CON 19 (+4) | +4
> INT 14 (+2) | +2   WIS 13 (+1) | +5   CHA 17 (+3) | +3
> ```
> ___
> **Skills** Perception +9, Stealth +4
> **Immunities** Lightning
> **Senses** Blindsight 30 ft., Darkvision 120 ft.; Passive Perception 19
> **Languages** Common, Draconic
> **CR** 9 (XP 5,000; PB +4)
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks.
>
> **Rend.** *Melee Attack Roll:* +9, reach 10 ft. *Hit:* 12 (2d6 + 5) Slashing damage plus 5 (1d10) Lightning damage.
>
> **Lightning Breath (Recharge 5-6).** *Dexterity Saving Throw:* DC 16, each creature in a 60-foot-long, 5-foot-wide Line. *Failure:* 55 (10d10) Lightning damage. *Success:* Half damage.
>
> ### Adult Blue Dragon
> *Huge Dragon (Chromatic), Lawful Evil*
> ___
> **AC** 19
> **HP** 212 (17d12 + 102)
> **Speed** 40 ft., Burrow 30 ft., Fly 80 ft.
> **Initiative** +10 (20)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 25 (+7) | +7   DEX 10 (+0) | +5   CON 23 (+6) | +6
> INT 16 (+3) | +3   WIS 15 (+2) | +7   CHA 20 (+5) | +5
> ```
> ___
> **Skills** Perception +12, Stealth +5
> **Immunities** Lightning
> **Senses** Blindsight 60 ft., Darkvision 120 ft.; Passive Perception 22
> **Languages** Common, Draconic
> **CR** 16 (XP 15,000, or 18,000 in lair; PB +5)
> ### Traits
> **Legendary Resistance (3/Day, or 4/Day in Lair).** If the dragon fails a saving throw, it can choose to succeed instead.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of Spellcasting to cast Shatter.
>
> **Rend.** *Melee Attack Roll:* +12, reach 10 ft. *Hit:* 16 (2d8 + 7) Slashing damage plus 5 (1d10) Lightning damage.
>
> **Lightning Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 19, each creature in a 90-foot-long, 5-foot-

---
266 System Reference Document 5.2.1

# Page 15

> wide Line. *Failure:* 60 (11d10) Lightning damage. *Success:* Half damage.
>
> **Spellcasting.** The dragon casts one of the following spells, requiring no Material components and using Charisma as the spellcasting ability (spell save DC 18):
>
> **At Will:** *Detect Magic, Invisibility, Mage Hand, Shatter*
> **1/Day Each:** *Scrying, Sending*
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the dragon can expend a use to take one of the following actions. The dragon regains all expended uses at the start of each of its turns.
>
> **Cloaked Flight.** The dragon uses Spellcasting to cast *Invisibility* on itself, and it can fly up to half its Fly Speed. The dragon can't take this action again until the start of its next turn.
>
> **Sonic Boom.** The dragon uses Spellcasting to cast *Shatter*. The dragon can't take this action again until the start of its next turn.
>
> **Tail Swipe.** The dragon makes one Rend attack.

> ### Ancient Blue Dragon
> *Gargantuan Dragon (Chromatic), Lawful Evil*
> ___
> **AC** 22
> **HP** 481 (26d20 + 208)
> **Speed** 40 ft., Burrow 40 ft., Fly 80 ft.
> **Initiative** +14 (24)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 29 (+9) | +9   DEX 10 (+0) | +7   CON 27 (+8) | +8
> INT 18 (+4) | +4   WIS 17 (+3) | +10  CHA 25 (+7) | +7
> ```
> ___
> **Skills** Perception +17, Stealth +7
> **Immunities** Lightning
> **Senses** Blindsight 60 ft., Darkvision 120 ft.; Passive Perception 27
> **Languages** Common, Draconic
> **CR** 23 (XP 50,000, or 62,000 in lair; PB +7)
> ### Traits
> **Legendary Resistance (4/Day, or 5/Day in Lair).** If the dragon fails a saving throw, it can choose to succeed instead.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of Spellcasting to cast *Shatter* (level 3 version).
>
> **Rend.** *Melee Attack Roll:* +16, reach 15 ft. *Hit:* 18 (2d8 + 9) Slashing damage plus 11 (2d10) Lightning damage.
>
> **Lightning Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 23, each creature in a 120-foot-long, 10-foot-wide Line. *Failure:* 88 (16d10) Lightning damage. *Success:* Half damage.
> **Spellcasting.** The dragon casts one of the following spells, requiring no Material components and using Charisma as the spellcasting ability (spell save DC 22):
>
> **At Will:** *Detect Magic, Invisibility, Mage Hand, Shatter* (level 3 version)
> **1/Day Each:** *Scrying, Sending*
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the dragon can expend a use to take one of the following actions. The dragon regains all expended uses at the start of each of its turns.
>
> **Cloaked Flight.** The dragon uses Spellcasting to cast *Invisibility* on itself, and it can fly up to half its Fly Speed. The dragon can't take this action again until the start of its next turn.
>
> **Sonic Boom.** The dragon uses Spellcasting to cast *Shatter* (level 3 version). The dragon can't take this action again until the start of its next turn.
>
> **Tail Swipe.** The dragon makes one Rend attack.

## Bone Devil
> ### Bone Devil
> *Large Fiend (Devil), Lawful Evil*
> ___
> **AC** 16
> **HP** 161 (17d10 + 68)
> **Speed** 40 ft., Fly 40 ft.
> **Initiative** +7 (17)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 18 (+4) | +8   DEX 16 (+3) | +3   CON 18 (+4) | +4
> INT 13 (+1) | +5   WIS 14 (+2) | +6   CHA 16 (+3) | +7
> ```
> ___
> **Skills** Deception +7, Insight +6
> **Resistances** Cold
> **Immunities** Fire, Poison; Poisoned
> **Senses** Darkvision 120 ft. (unimpeded by magical Darkness); Passive Perception 12
> **Languages** Infernal; telepathy 120 ft.
> **CR** 9 (XP 5,000; PB +4)
> ### Traits
> **Diabolical Restoration.** If the devil dies outside the Nine Hells, its body disappears in sulfurous smoke, and it gains a new body instantly, reviving with all its Hit Points somewhere in the Nine Hells.
>
> **Magic Resistance.** The devil has Advantage on saving throws against spells and other magical effects.
> ### Actions
> **Multiattack.** The devil makes two Claw attacks and one Infernal Sting attack.
>
> **Claw.** *Melee Attack Roll:* +8, reach 10 ft. *Hit:* 13 (2d8 + 4) Slashing damage.
>
> **Infernal Sting.** *Melee Attack Roll:* +8, reach 10 ft. *Hit:* 15 (2d10 + 4) Piercing damage plus 18 (4d8) Poison

---
267 System Reference Document 5.2.1

# Page 16

> damage, and the target has the Poisoned condition until the start of the devil's next turn. While Poisoned, the target can't regain Hit Points.

## Brass Dragons
> ### Brass Dragon Wyrmling
> *Medium Dragon (Metallic), Chaotic Good*
> ___
> **AC** 15
> **HP** 22 (4d8 + 4)
> **Speed** 30 ft., Burrow 15 ft., Fly 60 ft.
> **Initiative** +2 (12)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 15 (+2) | +2   DEX 10 (+0) | +2   CON 13 (+1) | +1
> INT 10 (+0) | +0   WIS 11 (+0) | +2   CHA 13 (+1) | +1
> ```
> ___
> **Skills** Perception +4, Stealth +2
> **Immunities** Fire
> **Senses** Blindsight 10 ft., Darkvision 60 ft.; Passive Perception 14
> **Languages** Draconic
> **CR** 1 (XP 200; PB +2)
> ### Actions
> **Rend.** *Melee Attack Roll:* +4, reach 5 ft. *Hit:* 7 (1d10 + 2) Slashing damage.
>
> **Fire Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 11, each creature in a 20-foot-long, 5-foot-wide Line. *Failure:* 14 (4d6) Fire damage. *Success:* Half damage.
>
> **Sleep Breath.** *Constitution Saving Throw:* DC 11, each creature in a 15-foot Cone. *Failure:* The target has the Incapacitated condition until the end of its next turn, at which point it repeats the save. *Second Failure:* The target has the Unconscious condition for 1 minute. This effect ends for the target if it takes damage or a creature within 5 feet of it takes an action to wake it.
>
> ### Young Brass Dragon
> *Large Dragon (Metallic), Chaotic Good*
> ___
> **AC** 17
> **HP** 110 (13d10 + 39)
> **Speed** 40 ft., Burrow 20 ft., Fly 80 ft.
> **Initiative** +3 (13)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 19 (+4) | +4   DEX 10 (+0) | +3   CON 17 (+3) | +3
> INT 12 (+1) | +1   WIS 11 (+0) | +3   CHA 15 (+2) | +2
> ```
> ___
> **Skills** Perception +6, Persuasion +5, Stealth +3
> **Immunities** Fire
> **Senses** Blindsight 30 ft., Darkvision 120 ft.; Passive Perception 16
> **Languages** Common, Draconic
> **CR** 6 (XP 2,300; PB +3)
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace two attacks with a use of Sleep Breath.
> **Rend.** *Melee Attack Roll:* +7, reach 10 ft. *Hit:* 15 (2d10 + 4) Slashing damage.
>
> **Fire Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 14, each creature in a 40-foot-long, 5-foot-wide Line. *Failure:* 38 (11d6) Fire damage. *Success:* Half damage.
>
> **Sleep Breath.** *Constitution Saving Throw:* DC 14, each creature in a 30-foot Cone. *Failure:* The target has the Incapacitated condition until the end of its next turn, at which point it repeats the save. *Second Failure:* The target has the Unconscious condition for 1 minute. This effect ends for the target if it takes damage or a creature within 5 feet of it takes an action to wake it.
>
> ### Adult Brass Dragon
> *Huge Dragon (Metallic), Chaotic Good*
> ___
> **AC** 18
> **HP** 172 (15d12 + 75)
> **Speed** 40 ft., Burrow 30 ft., Fly 80 ft.
> **Initiative** +10 (20)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 23 (+6) | +6   DEX 10 (+0) | +5   CON 21 (+5) | +5
> INT 14 (+2) | +2   WIS 13 (+1) | +6   CHA 17 (+3) | +3
> ```
> ___
> **Skills** History +7, Perception +11, Persuasion +8, Stealth +5
> **Immunities** Fire
> **Senses** Blindsight 60 ft., Darkvision 120 ft.; Passive Perception 21
> **Languages** Common, Draconic
> **CR** 13 (XP 10,000, or 11,500 in lair; PB +5)
> ### Traits
> **Legendary Resistance (3/Day, or 4/Day in Lair).** If the dragon fails a saving throw, it can choose to succeed instead.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of (A) Sleep Breath or (B) Spellcasting to cast *Scorching Ray*.
>
> **Rend.** *Melee Attack Roll:* +11, reach 10 ft. *Hit:* 17 (2d10 + 6) Slashing damage plus 4 (1d8) Fire damage.
>
> **Fire Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 18, each creature in a 60-foot-long, 5-foot-wide Line. *Failure:* 45 (10d8) Fire damage. *Success:* Half damage.
>
> **Sleep Breath.** *Constitution Saving Throw:* DC 18, each creature in a 60-foot Cone. *Failure:* The target has the Incapacitated condition until the end of its next turn, at which point it repeats the save. *Second Failure:* The target has the Unconscious condition for 10 minutes. This effect ends for the target if it takes damage or a creature within 5 feet of it takes an action to wake it.

---
268 System Reference Document 5.2.1

# Page 17

> **Spellcasting.** The dragon casts one of the following spells, requiring no Material components and using Charisma as the spellcasting ability (spell save DC 16):
>
> **At Will:** *Detect Magic, Minor Illusion, Scorching Ray, Shapechange* (Beast or Humanoid form only, no Temporary Hit Points gained from the spell, and no Concentration or Temporary Hit Points required to maintain the spell), *Speak with Animals*
> **1/Day Each:** *Detect Thoughts, Control Weather*
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the dragon can expend a use to take one of the following actions. The dragon regains all expended uses at the start of each of its turns.
>
> **Blazing Light.** The dragon uses Spellcasting to cast *Scorching Ray*.
>
> **Pounce.** The dragon moves up to half its Speed, and it makes one Rend attack.
>
> **Scorching Sands.** *Dexterity Saving Throw:* DC 16, one creature the dragon can see within 120 feet. *Failure:* 27 (6d8) Fire damage, and the target's Speed is halved until the end of its next turn. *Failure or Success:* The dragon can't take this action again until the start of its next turn.
>
> ### Ancient Brass Dragon
> *Gargantuan Dragon (Metallic), Chaotic Good*
> ___
> **AC** 20
> **HP** 332 (19d20 + 133)
> **Speed** 40 ft., Burrow 40 ft., Fly 80 ft.
> **Initiative** +12 (22)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 27 (+8) | +8   DEX 10 (+0) | +6   CON 25 (+7) | +7
> INT 16 (+3) | +3   WIS 15 (+2) | +8   CHA 22 (+6) | +6
> ```
> ___
> **Skills** History +9, Perception +14, Persuasion +12, Stealth +6
> **Immunities** Fire
> **Senses** Blindsight 60 ft., Darkvision 120 ft.; Passive Perception 24
> **Languages** Common, Draconic
> **CR** 20 (XP 25,000, or 33,000 in lair; PB +6)
> ### Traits
> **Legendary Resistance (4/Day, or 5/Day in Lair).** If the dragon fails a saving throw, it can choose to succeed instead.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of (A) Sleep Breath or (B) Spellcasting to cast *Scorching Ray* (level 3 version).
>
> **Rend.** *Melee Attack Roll:* +14, reach 15 ft. *Hit:* 19 (2d10 + 8) Slashing damage plus 7 (2d6) Fire damage.
> **Fire Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 21, each creature in a 90-foot-long, 5-foot-wide Line. *Failure:* 58 (13d8) Fire damage. *Success:* Half damage.
>
> **Sleep Breath.** *Constitution Saving Throw:* DC 21, each creature in a 90-foot Cone. *Failure:* The target has the Incapacitated condition until the end of its next turn, at which point it repeats the save. *Second Failure:* The target has the Unconscious condition for 10 minutes. This effect ends for the target if it takes damage or a creature within 5 feet of it takes an action to wake it.
>
> **Spellcasting.** The dragon casts one of the following spells, requiring no Material components and using Charisma as the spellcasting ability (spell save DC 20):
>
> **At Will:** *Detect Magic, Minor Illusion, Scorching Ray* (level 3 version), *Shapechange* (Beast or Humanoid form only, no Temporary Hit Points gained from the spell, and no Concentration or Temporary Hit Points required to maintain the spell), *Speak with Animals*
> **1/Day Each:** *Control Weather, Detect Thoughts*
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the dragon can expend a use to take one of the following actions. The dragon regains all expended uses at the start of each of its turns.
>
> **Blazing Light.** The dragon uses Spellcasting to cast *Scorching Ray* (level 3 version).
>
> **Pounce.** The dragon moves up to half its Speed, and it makes one Rend attack.
>
> **Scorching Sands.** *Dexterity Saving Throw:* DC 20, one creature the dragon can see within 120 feet. *Failure:* 36 (8d8) Fire damage, and the target's Speed is halved until the end of its next turn. *Failure or Success:* The dragon can't take this action again until the start of its next turn.

## Bronze Dragons
> ### Bronze Dragon Wyrmling
> *Medium Dragon (Metallic), Lawful Good*
> ___
> **AC** 15
> **HP** 39 (6d8 + 12)
> **Speed** 30 ft., Fly 60 ft., Swim 30 ft.
> **Initiative** +2 (12)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 17 (+3) | +3   DEX 10 (+0) | +2   CON 15 (+2) | +2
> INT 12 (+1) | +1   WIS 11 (+0) | +2   CHA 15 (+2) | +2
> ```
> ___
> **Skills** Perception +4, Stealth +2
> **Immunities** Lightning
> **Senses** Blindsight 10 ft., Darkvision 60 ft.; Passive Perception 14
> **Languages** Draconic
> **CR** 2 (XP 450; PB +2)

---
269 System Reference Document 5.2.1

# Page 18

> ### Traits
> **Amphibious.** The dragon can breathe air and water.
> ### Actions
> **Multiattack.** The dragon makes two Rend attacks.
>
> **Rend.** *Melee Attack Roll:* +5, reach 5 ft. *Hit:* 8 (1d10 + 3) Slashing damage.
>
> **Lightning Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 12, each creature in a 40-foot-long, 5-foot-wide Line. *Failure:* 16 (3d10) Lightning damage. *Success:* Half damage.
>
> **Repulsion Breath.** *Strength Saving Throw:* DC 12, each creature in a 30-foot Cone. *Failure:* The target is pushed up to 30 feet straight away from the dragon and has the Prone condition.
>
> ### Young Bronze Dragon
> *Large Dragon (Metallic), Lawful Good*
> ___
> **AC** 17
> **HP** 142 (15d10 + 60)
> **Speed** 40 ft., Fly 80 ft., Swim 40 ft.
> **Initiative** +3 (13)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 21 (+5) | +5   DEX 10 (+0) | +3   CON 19 (+4) | +4
> INT 14 (+2) | +2   WIS 13 (+1) | +4   CHA 17 (+3) | +3
> ```
> ___
> **Skills** Insight +4, Perception +7, Stealth +3
> **Immunities** Lightning
> **Senses** Blindsight 30 ft., Darkvision 120 ft.; Passive Perception 17
> **Languages** Common, Draconic
> **CR** 8 (XP 3,900; PB +3)
> ### Traits
> **Amphibious.** The dragon can breathe air and water.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of Repulsion Breath.
>
> **Rend.** *Melee Attack Roll:* +8, reach 10 ft. *Hit:* 16 (2d10 + 5) Slashing damage.
>
> **Lightning Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 15, each creature in a 60-foot-long, 5-foot-wide Line. *Failure:* 49 (9d10) Lightning damage. *Success:* Half damage.
>
> **Repulsion Breath.** *Strength Saving Throw:* DC 15, each creature in a 30-foot Cone. *Failure:* The target is pushed up to 40 feet straight away from the dragon and has the Prone condition.
>
> ### Adult Bronze Dragon
> *Huge Dragon (Metallic), Lawful Good*
> ___
> **AC** 18
> **HP** 212 (17d12 + 102)
> **Speed** 40 ft., Fly 80 ft., Swim 40 ft.
> **Initiative** +10 (20)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 25 (+7) | +7   DEX 10 (+0) | +5   CON 23 (+6) | +6
> INT 16 (+3) | +3   WIS 15 (+2) | +7   CHA 20 (+5) | +5
> ```
> ___
> **Skills** Insight +7, Perception +12, Stealth +5
> **Immunities** Lightning
> **Senses** Blindsight 60 ft., Darkvision 120 ft.; Passive Perception 22
> **Languages** Common, Draconic
> **CR** 15 (XP 13,000, or 15,000 in lair; PB +5)
> ### Traits
> **Amphibious.** The dragon can breathe air and water.
>
> **Legendary Resistance (3/Day, or 4/Day in Lair).** If the dragon fails a saving throw, it can choose to succeed instead.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of (A) Repulsion Breath or (B) Spellcasting to cast *Guiding Bolt* (level 2 version).
>
> **Rend.** *Melee Attack Roll:* +12, reach 10 ft. *Hit:* 16 (2d8 + 7) Slashing damage plus 5 (1d10) Lightning damage.
>
> **Lightning Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 19, each creature in a 90-foot-long, 5-foot-wide Line. *Failure:* 55 (10d10) Lightning damage. *Success:* Half damage.
>
> **Repulsion Breath.** *Strength Saving Throw:* DC 19, each creature in a 30-foot Cone. *Failure:* The target is pushed up to 60 feet straight away from the dragon and has the Prone condition.
>
> **Spellcasting.** The dragon casts one of the following spells, requiring no Material components and using Charisma as the spellcasting ability (spell save DC 17, +10 to hit with spell attacks):
>
> **At Will:** *Detect Magic, Guiding Bolt* (level 2 version), *Shapechange* (Beast or Humanoid form only, no Temporary Hit Points gained from the spell, and no Concentration or Temporary Hit Points required to maintain the spell), *Speak with Animals, Thaumaturgy*
> **1/Day Each:** *Detect Thoughts, Water Breathing*
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the dragon can expend a use to take one of the following actions. The dragon regains all expended uses at the start of each of its turns.
>
> **Guiding Light.** The dragon uses Spellcasting to cast *Guiding Bolt* (level 2 version).
>
> **Pounce.** The dragon moves up to half its Speed, and it makes one Rend attack.
>
> **Thunderclap.** *Constitution Saving Throw:* DC 17, each creature in a 20-foot-radius Sphere centered on a point the dragon can see within 90 feet. *Failure:* 10 (3d6)

---
270 System Reference Document 5.2.1

# Page 19

> Thunder damage, and the target has the Deafened condition until the end of its next turn.

> ### Ancient Bronze Dragon
> *Gargantuan Dragon (Metallic), Lawful Good*
> ___
> **AC** 22
> **HP** 444 (24d20 + 192)
> **Speed** 40 ft., Fly 80 ft., Swim 40 ft.
> **Initiative** +14 (24)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 29 (+9) | +9   DEX 10 (+0) | +7   CON 27 (+8) | +8
> INT 18 (+4) | +4   WIS 17 (+3) | +10  CHA 25 (+7) | +7
> ```
> ___
> **Skills** Insight +10, Perception +17, Stealth +7
> **Immunities** Lightning
> **Senses** Blindsight 60 ft., Darkvision 120 ft.; Passive Perception 27
> **Languages** Common, Draconic
> **CR** 22 (XP 41,000, or 50,000 in lair; PB +7)
> ### Traits
> **Amphibious.** The dragon can breathe air and water.
>
> **Legendary Resistance (4/Day, or 5/Day in Lair).** If the dragon fails a saving throw, it can choose to succeed instead.
> ### Actions
> **Multiattack.** The dragon makes three Rend attacks. It can replace one attack with a use of (A) Repulsion Breath or (B) Spellcasting to cast *Guiding Bolt* (level 2 version).
>
> **Rend.** *Melee Attack Roll:* +16, reach 15 ft. *Hit:* 18 (2d8 + 9) Slashing damage plus 9 (2d8) Lightning damage.
>
> **Lightning Breath (Recharge 5–6).** *Dexterity Saving Throw:* DC 23, each creature in a 120-foot-long, 10-foot-wide Line. *Failure:* 82 (15d10) Lightning damage. *Success:* Half damage.
>
> **Repulsion Breath.** *Strength Saving Throw:* DC 23, each creature in a 30-foot Cone. *Failure:* The target is pushed up to 60 feet straight away from the dragon and has the Prone condition.
>
> **Spellcasting.** The dragon casts one of the following spells, requiring no Material components and using Charisma as the spellcasting ability (spell save DC 22, +14 to hit with spell attacks):
>
> **At Will:** *Detect Magic, Guiding Bolt* (level 2 version), *Shapechange* (Beast or Humanoid form only, no Temporary Hit Points gained from the spell, and no Concentration or Temporary Hit Points required to maintain the spell), *Speak with Animals, Thaumaturgy*
> **1/Day Each:** *Detect Thoughts, Control Water, Scrying, Water Breathing*
> ### Legendary Actions
> **Legendary Action Uses:** 3 (4 in Lair). Immediately after another creature's turn, the dragon can expend a use to take one of the following actions. The dragon regains all expended uses at the start of each of its turns.
>
> **Guiding Light.** The dragon uses Spellcasting to cast *Guiding Bolt* (level 2 version).
>
> **Pounce.** The dragon moves up to half its Speed, and it makes one Rend attack.
>
> **Thunderclap.** *Constitution Saving Throw:* DC 22, each creature in a 20-foot-radius Sphere centered on a point the dragon can see within 120 feet. *Failure:* 13 (3d8) Thunder damage, and the target has the Deafened condition until the end of its next turn.

## Bugbears
> ### Bugbear Stalker
> *Medium Fey (Goblinoid), Chaotic Evil*
> ___
> **AC** 15
> **HP** 65 (10d8 + 20)
> **Speed** 30 ft.
> **Initiative** +2 (12)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 17 (+3) | +3   DEX 14 (+2) | +2   CON 14 (+2) | +4
> INT 11 (+0) | +0   WIS 12 (+1) | +3   CHA 11 (+0) | +0
> ```
> ___
> **Skills** Stealth +6, Survival +3
> **Gear** Chain Shirt, Javelins (6), Morningstar
> **Senses** Darkvision 60 ft.; Passive Perception 11
> **Languages** Common, Goblin
> **CR** 3 (XP 700; PB +2)
> ### Traits
> **Abduct.** The bugbear needn't spend extra movement to move a creature it is grappling.
> ### Actions
> **Multiattack.** The bugbear makes two Javelin or Morningstar attacks.
>
> **Javelin.** *Melee or Ranged Attack Roll:* +5, reach 10 ft. or range 30/120 ft. *Hit:* 13 (3d6 + 3) Piercing damage.
>
> **Morningstar.** *Melee Attack Roll:* +5 (with Advantage if the target is Grappled by the bugbear), reach 10 ft. *Hit:* 12 (2d8 + 3) Piercing damage.
> ### Bonus Actions
> **Quick Grapple.** *Dexterity Saving Throw:* DC 13, one Medium or smaller creature the bugbear can see within 10 feet. *Failure:* The target has the Grappled condition (escape DC 13).

---
271 System Reference Document 5.2.1

# Page 20

> ### Bugbear Warrior
> *Medium Fey (Goblinoid), Chaotic Evil*
> ___
> **AC** 14
> **HP** 33 (6d8 + 6)
> **Speed** 30 ft.
> **Initiative** +2 (12)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 15 (+2) | +2   DEX 14 (+2) | +2   CON 13 (+1) | +1
> INT 8  (-1) | -1   WIS 11 (+0) | +0   CHA 9  (-1) | -1
> ```
> ___
> **Skills** Stealth +6, Survival +2
> **Gear** Hide Armor, Light Hammers (3)
> **Senses** Darkvision 60 ft.; Passive Perception 10
> **Languages** Common, Goblin
> **CR** 1 (XP 200; PB +2)
> ### Traits
> **Abduct.** The bugbear needn't spend extra movement to move a creature it is grappling.
> ### Actions
> **Grab.** *Melee Attack Roll:* +4, reach 10 ft. *Hit:* 9 (2d6 + 2) Bludgeoning damage. If the target is a Medium or smaller creature, it has the Grappled condition (escape DC 12).
>
> **Light Hammer.** *Melee or Ranged Attack Roll:* +4 (with Advantage if the target is Grappled by the bugbear), reach 10 ft. or range 20/60 ft. *Hit:* 9 (3d4 + 2) Bludgeoning damage.

## Bulette
> ### Bulette
> *Large Monstrosity, Unaligned*
> ___
> **AC** 17
> **HP** 94 (9d10 + 45)
> **Speed** 40 ft., Burrow 40 ft.
> **Initiative** +0 (10)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 19 (+4) | +4   DEX 11 (+0) | +0   CON 21 (+5) | +5
> INT 2  (-4) | -4   WIS 10 (+0) | +0   CHA 5  (-3) | -3
> ```
> ___
> **Skills** Perception +6
> **Senses** Darkvision 60 ft., Tremorsense 120 ft.; Passive Perception 16
> **Languages** None
> **CR** 5 (XP 1,800; PB +3)
> ### Actions
> **Multiattack.** The bulette makes two Bite attacks.
>
> **Bite.** *Melee Attack Roll:* +7, reach 5 ft. *Hit:* 17 (2d12 + 4) Piercing damage.
>
> **Deadly Leap.** The bulette spends 5 feet of movement to jump to a space within 15 feet that contains one or more Large or smaller creatures. *Dexterity Saving Throw:* DC 15, each creature in the bulette's destination space. *Failure:* 19 (3d12) Bludgeoning damage, and the target has the Prone condition. *Success:* Half damage, and the target is pushed 5 feet straight away from the bulette.
> ### Bonus Actions
> **Leap.** The bulette jumps up to 30 feet by spending 10 feet of movement.

## Centaur
> ### Centaur Trooper
> *Large Fey, Neutral Good*
> ___
> **AC** 16
> **HP** 45 (6d10 + 12)
> **Speed** 50 ft.
> **Initiative** +2 (12)
> ___
> ```
>               MOD  SAVE         MOD  SAVE         MOD  SAVE
> STR 18 (+4) | +4   DEX 14 (+2) | +2   CON 14 (+2) | +2
> INT 9  (-1) | -1   WIS 13 (+1) | +1   CHA 11 (+0) | +0
> ```
> ___
> **Skills** Athletics +6, Perception +3
> **Gear** Breastplate, Longbow, Pike
> **Senses** Passive Perception 13
> **Languages** Elvish, Sylvan
> **CR** 2 (XP 450; PB +2)
> ### Actions
> **Multiattack.** The centaur makes two attacks, using Pike or Longbow in any combination.
>
> **Pike.** *Melee Attack Roll:* +6, reach 10 ft. *Hit:* 9 (1d10 + 4) Piercing damage.
>
> **Longbow.** *Ranged Attack Roll:* +4, range 150/600 ft. *Hit:* 6 (1d8 + 2) Piercing damage.
> ### Bonus Actions
> **Trampling Charge (Recharge 5–6).** The centaur moves up to its Speed without provoking Opportunity Attacks and can move through the spaces of Medium or smaller creatures. Each creature whose space the centaur enters is targeted once by the following effect. *Strength Saving Throw:* DC 14. *Failure:* 7 (1d6 + 4) Bludgeoning damage, and the target has the Prone condition.

## Chain Devil
> ### Chain Devil
> *Medium Fiend (Devil), Lawful Evil*
> ___
> **AC** 15
> **HP** 85 (10d8 + 40)
> **Speed** 30 ft.
> **Initiative** +5 (15)

---
272 System Reference Document 5.2.1