# 竞品分析检查清单

## 分析前检查 (Pre-Analysis)

### 1. 仓库准备
- [ ] 仓库 URL 是否正确？
- [ ] 已创建产品竞品目录 `~/Workspace/competitors/{product}/`
- [ ] 已成功克隆仓库到本地
- [ ] 运行 `git pull` 确保代码最新
- [ ] 记录当前 commit: `git log -1 --format="%h %s"`

### 2. 基础文件确认
- [ ] README.md 存在且可读
- [ ] 配置文件存在 (package.json / Cargo.toml / pyproject.toml)
- [ ] LICENSE 文件存在
- [ ] 源码目录结构清晰 (src/ 或等效目录)

---

## 分析中检查 (During Analysis)

### 3. 技术栈验证
- [ ] 框架版本来自配置文件，已标注行号
- [ ] 依赖列表来自配置文件，已标注行号
- [ ] 入口文件已确认并读取

### 4. 核心模块分析
- [ ] 已识别核心模块/helper 文件
- [ ] 已读取关键实现代码
- [ ] 代码片段标注了文件路径和行号

### 5. 来源标注
- [ ] 每个版本号都有 (来源: file:行号)
- [ ] 每个技术细节都有来源
- [ ] 引用 README 内容标注了行号
- [ ] 对比表中竞品数据都有来源列

---

## 分析后检查 (Post-Analysis)

### 6. 禁止词汇检查
在分析文档中搜索以下词汇，如果存在必须修改或删除：

```bash
grep -E "(推测|可能|应该|大概|似乎|或许|未知|未披露|未公开)" profile.md
```

- [ ] 无"推测"
- [ ] 无"可能"
- [ ] 无"应该"
- [ ] 无"大概"/"似乎"/"或许"
- [ ] 无"未知"/"未披露"/"未公开" (改为"待验证"并说明原因)

### 7. 来源完整性检查

```bash
# 检查是否有未标注来源的技术细节
grep -E "^- |^\| " profile.md | grep -v "(来源:|待验证)"
```

- [ ] 所有列表项都有来源或标记为待验证
- [ ] 所有表格数据都有来源列

### 8. 文件引用验证
确认分析中引用的文件确实存在：

```bash
# 提取所有引用的文件路径
grep -oE "[a-zA-Z0-9_/]+\.(js|ts|py|rs|json|toml|md):[0-9]+" profile.md
```

- [ ] 所有引用的文件都存在于仓库中
- [ ] 行号在文件范围内

---

## 常见错误修复

### 错误 1: 使用了推测性语言

**修复前**:
```markdown
## 架构设计（推测版）
可能使用了微服务架构...
```

**修复后**:
```markdown
## 架构设计 (来源: 代码结构分析)
基于 src/ 目录结构，项目采用模块化设计：
- helpers/ 包含 30 个工具模块 (来源: `ls src/helpers/ | wc -l`)
- services/ 包含业务逻辑 (来源: 目录结构)
```

### 错误 2: 对比表无来源

**修复前**:
```markdown
| 维度 | 竞品 | 我们 |
|------|------|------|
| Stars | 920 | 100 |
```

**修复后**:
```markdown
| 维度 | 竞品 | 来源 | 我们 | 来源 |
|------|------|------|------|------|
| Stars | 920 | GitHub 2026-01-29 | 100 | GitHub 2026-01-29 |
```

### 错误 3: 版本号无来源

**修复前**:
```markdown
使用 React 19 和 Electron 36
```

**修复后**:
```markdown
使用 React 19.1.0 (package.json:96) 和 Electron 36.9.5 (package.json:68)
```

---

## 质量评分

完成分析后，按以下标准自评：

| 维度 | 权重 | 评分标准 |
|------|------|----------|
| 数据来源 | 40% | 100% 技术细节有来源 = 满分 |
| 无推测语言 | 30% | 0 个禁止词汇 = 满分 |
| 代码分析深度 | 20% | 读取 5+ 核心文件 = 满分 |
| 对比完整性 | 10% | 对比表 5+ 维度 = 满分 |

**目标**: 总分 >= 90%
