# Formatting Rules

Use these rules to enforce strict report formatting.

## Headings
- Use H2 for top-level sections
- Use H3 for subsections
- Keep heading titles consistent with the report spec

## Section Order
- Follow the report spec order exactly
- Do not add or remove sections without approval

## Bullets and Tables
- Use bullets for lists of findings and actions
- Use tables for comparisons, metrics, or timelines
- Keep tables compact and label all columns

## Citations
- Use the citation style defined in the report spec
- Place citations immediately after the claim
- If a claim has multiple sources, list all relevant sources

## Terminology
- Define key terms once and reuse consistently
- Preserve technical terms in English

## Formatting Hygiene
- Avoid mixed numbering styles in the same section
- Avoid inline URLs in prose unless the spec requires it
- Do not embed new assets unless requested
