# Domain Theories for Prompt Enhancement

## Purpose

When enhancing prompts, grounding the solution in established domain theories provides:
- Proven methodologies and frameworks
- Industry best practices
- Credibility and rigor
- Structured problem-solving approaches

## Common Domain Theory Mappings

### Productivity & Time Management

**Applicable for:** Task management apps, productivity tools, scheduling systems

**Relevant Theories:**
1. **Getting Things Done (GTD)** - David Allen
   - Capture, Clarify, Organize, Reflect, Engage
   - Next action principle
   - Context-based task organization

2. **Pomodoro Technique** - Francesco Cirillo
   - 25-minute focused work intervals
   - Regular breaks
   - Distraction management

3. **Eisenhower Matrix**
   - Urgent/Important prioritization
   - Four quadrants for task classification

4. **Pareto Principle (80/20 Rule)**
   - Focus on high-impact activities
   - Effort vs. outcome optimization

5. **Timeboxing**
   - Fixed time allocations
   - Deadline-driven focus

### Behavior Change & Habit Formation

**Applicable for:** Health apps, learning platforms, goal-tracking systems

**Relevant Theories:**
1. **BJ Fogg Behavior Model (B=MAT)**
   - Behavior = Motivation × Ability × Trigger
   - Tiny habits principle
   - Behavioral chains

2. **Atomic Habits** - James Clear
   - 1% improvement philosophy
   - Habit stacking
   - Identity-based habits

3. **Operant Conditioning**
   - Positive/negative reinforcement
   - Reward schedules
   - Immediate feedback loops

4. **Self-Determination Theory**
   - Autonomy, competence, relatedness
   - Intrinsic vs. extrinsic motivation

### User Experience & Interface Design

**Applicable for:** UI/UX projects, web applications, mobile apps

**Relevant Theories:**
1. **Hick's Law**
   - Choice overload reduction
   - Decision time optimization

2. **Fitts's Law**
   - Target size and distance relationship
   - Touch target optimization

3. **Miller's Law (7±2)**
   - Cognitive load management
   - Chunking information

4. **Jakob's Law**
   - Familiar design patterns
   - User expectations

5. **Progressive Disclosure**
   - Layered information architecture
   - Complexity management

6. **Gestalt Principles**
   - Proximity, similarity, closure
   - Visual hierarchy

### Gamification & Engagement

**Applicable for:** Learning apps, fitness trackers, social platforms

**Relevant Theories:**
1. **Octalysis Framework** - Yu-kai Chou
   - 8 core drives of gamification
   - White hat vs. black hat mechanics

2. **Self-Determination Theory in Games**
   - Challenge and mastery
   - Social connection
   - Autonomy in gameplay

3. **Flow Theory** - Mihaly Csikszentmihalyi
   - Skill-challenge balance
   - Immediate feedback
   - Clear goals

4. **Variable Reward Schedules**
   - Unpredictability and anticipation
   - Dopamine-driven engagement

### Learning & Education

**Applicable for:** E-learning platforms, training systems, educational apps

**Relevant Theories:**
1. **Bloom's Taxonomy**
   - Knowledge → Comprehension → Application → Analysis → Synthesis → Evaluation
   - Learning objective hierarchy

2. **Spaced Repetition**
   - Forgetting curve optimization
   - Long-term memory consolidation

3. **Active Recall**
   - Retrieval practice
   - Testing effect

4. **Cognitive Load Theory**
   - Intrinsic, extraneous, germane load
   - Working memory limitations

5. **Zone of Proximal Development**
   - Scaffolding
   - Guided learning

### Data Visualization & Analytics

**Applicable for:** Dashboard design, reporting tools, analytics platforms

**Relevant Theories:**
1. **Tufte's Principles**
   - Data-ink ratio
   - Chartjunk elimination
   - Small multiples

2. **Gestalt Principles for Data**
   - Pre-attentive attributes
   - Visual encoding

3. **Information Scent**
   - Navigation cues
   - Progressive exploration

### E-commerce & Conversion

**Applicable for:** Online stores, checkout flows, landing pages

**Relevant Theories:**
1. **Cialdini's Principles of Persuasion**
   - Reciprocity, commitment, social proof
   - Scarcity, authority, liking

2. **AIDA Model**
   - Attention → Interest → Desire → Action
   - Conversion funnel optimization

3. **Paradox of Choice**
   - Option limitation
   - Decision fatigue reduction

### Information Architecture

**Applicable for:** Content-heavy sites, knowledge bases, documentation

**Relevant Theories:**
1. **Information Foraging Theory**
   - Scent trails
   - Cost-benefit of navigation

2. **Card Sorting Principles**
   - User mental models
   - Category optimization

3. **LATCH Framework** (Location, Alphabet, Time, Category, Hierarchy)
   - Information organization patterns

### Security & Trust

**Applicable for:** Authentication systems, privacy-sensitive apps, financial platforms

**Relevant Theories:**
1. **Zero Trust Architecture**
   - Never trust, always verify
   - Least privilege access

2. **Defense in Depth**
   - Layered security controls
   - Multiple fail-safes

3. **Privacy by Design**
   - Proactive privacy measures
   - User control over data

### Accessibility

**Applicable for:** Inclusive design, government services, public platforms

**Relevant Theories:**
1. **WCAG Principles** (POUR)
   - Perceivable, Operable, Understandable, Robust

2. **Universal Design**
   - Equitable use
   - Flexibility in use
   - Simple and intuitive

## How to Select Theories

1. **Identify the domain** from user requirements
2. **Match to primary objective** (engagement, learning, conversion, etc.)
3. **Select 2-4 relevant theories** that complement each other
4. **Apply principles** to specific features and workflows
5. **Cite theories** in enhanced prompts to add credibility

## Example Theory Selection

**Requirement:** "Build a habit tracker app"

**Domain:** Behavior Change & Habit Formation

**Selected Theories:**
- BJ Fogg Behavior Model (for trigger design)
- Atomic Habits (for habit stacking)
- Gamification (for motivation and rewards)

**Application:**
- Use tiny habits to lower barrier to entry
- Implement trigger notifications at optimal times
- Add streak tracking and badges for engagement
- Enable habit chains for compound behavior
