# Teams Channel Post Writing Guidelines

## Purpose
These posts are internal educational content to help team members learn effective Claude Code usage patterns and best practices.

## Tone and Style

- **Educational and helpful**: Focus on teaching concepts, not just announcing features
- **Professional but approachable**: Conversational without being too casual
- **Action-oriented**: Include concrete examples and calls-to-action
- **Concise**: Keep posts scannable - use short paragraphs and bullet points

## Structure Principles

### 1. Start with Context
- Always include release date or timing information when relevant
- Lead with what the feature/tool is and why it matters

### 2. Show, Don't Just Tell
- Use "Normal vs Better" comparisons instead of "Wrong vs Correct"
- Include 3+ concrete example prompts users can adapt
- Provide realistic use cases from actual development workflows

### 3. Explain the "Why"
- Connect features to broader best practices (e.g., context engineering)
- Use analogies to make technical concepts relatable
- Link to authoritative external resources when applicable

### 4. Make it Actionable
- Be explicit about how to invoke features
- Specify any options, settings, or parameters
- End with a clear call-to-action

## Content Patterns

### Feature Announcements
```
1. What is it? (with release date)
2. Why use it? (principles/benefits)
3. How to use it (with examples)
4. Key options/settings
5. Call-to-action + learn more
```

### Best Practices/Tips
```
1. The challenge/problem
2. The solution/approach
3. Why it works (principles)
4. How to implement (examples)
5. When to use it
6. Related resources
```

## Formatting Standards

- **Emojis**: Use sparingly and only in titles (🔍 🎯 💡 ⚡)
- **Bold**: Use for emphasis on key terms and section headers
- **Code blocks**: Use for example prompts (triple backticks or quotes)
- **Lists**: Use bullets for benefits/features, numbers for sequential steps
- **Comparisons**: Use 📝 for "Normal" and ⭐ for "Better"

## Research Requirements

Before writing any post:
1. **Verify release dates**: Use official documentation or changelog
2. **Test the feature**: Ensure examples work as described
3. **Find authoritative sources**: Link to official docs or reputable technical blogs
4. **Check for updates**: Ensure information is current

## Quality Checklist

- [ ] Includes specific release date or timing
- [ ] Explains the "why" with principles or best practices
- [ ] Provides 3+ concrete, realistic examples
- [ ] Uses "Normal/Better" pattern (not "Wrong/Correct")
- [ ] Includes clear call-to-action
- [ ] Links to additional learning resources
- [ ] Uses professional, educational tone
- [ ] Is scannable with clear structure
- [ ] All facts verified against official sources