# Comms/PR Specialist — Reference Guide

Deep reference for messaging, persuasion, and copywriting techniques.

**For core frameworks (SUCCESs, Cialdini, AIDA, etc.) see:** [`communication-frameworks.md`](communication-frameworks.md)
**For checklists see:** [`checklists.md`](checklists.md)

---

## 1. Hey Whipple: Advertising Copywriting
*Luke Sullivan*

**Core philosophy:** Advertising is saying one thing brilliantly, not many things adequately.

### Headline Rules
- The headline does 80% of the work. Spend 80% of your time on it.
- Promise a benefit, deliver news, or recognize a problem
- Be specific: percentages, time, dollars saved
- Short and punchy beats clever and long

### Body Copy Rules
- Write like one human being talking to another
- Short sentences. Short paragraphs. Plain words.
- Long copy sells when the stakes are high
- Every word must earn its place

### Concept Development
- Go 180° against common sense — that's where viral ideas live
- Authenticity: figure out how to say it *believably*
- Simplicity: figure out how to say it *quickly*
- Conflict creates faster ideas

### The Whipple Test
Named after Mr. Whipple (annoying but effective Charmin ads):
- Bad ads sometimes work. Great ads sometimes fail.
- But great ads that work are built on truth about the product.

---

## 4. David Ogilvy: Classic Copywriting Wisdom

**On Headlines:**
> "On average, five times as many people read the headline as read the body copy. When you have written your headline, you have spent eighty cents out of your dollar."

- Promise a benefit
- Include the brand name when possible
- Use "How to" — it works
- Make it specific and unique (not claimable by competitors)

**On Body Copy:**
- Write to one person, second person singular
- Research your product exhaustively before writing
- Selling is the priority — include calls to action
- Long copy outsells short copy for high-stakes decisions

**On Research:**
> "Advertising people who ignore research are as dangerous as generals who ignore decodes of enemy signals."

---

## 5. Propaganda Techniques
*Use ethically for awareness; recognize when they're used against you*

| Technique | Description | Ethical Use |
|-----------|-------------|-------------|
| **Bandwagon** | "Everyone is doing it" | Social proof for beneficial change |
| **Plain Folks** | "I'm just like you" | Authentic relatability |
| **Glittering Generalities** | Emotionally charged vague words | Replace with concrete specifics |
| **Card Stacking** | Selective presentation of facts | Acknowledge counterarguments |
| **Fear/Uncertainty/Doubt** | Create anxiety about alternatives | Honest risk communication |
| **Transfer** | Associate with respected symbols | Genuine alignment with values |
| **Testimonial** | Endorsement by respected figure | Authentic, relevant endorsers |

---

## 6. Rhetorical Devices

**Aristotle's Three Appeals:**
- **Ethos:** Credibility and character of the speaker
- **Logos:** Logical argument and evidence
- **Pathos:** Emotional appeal

**Useful Devices:**
- **Anaphora:** Repetition at start of phrases ("I have a dream...")
- **Tricolon:** Three-part list (liberty, equality, fraternity)
- **Antithesis:** Contrasting ideas in parallel structure
- **Rhetorical question:** Engages audience, implies answer

---

## Sources (Sections 1-4)

- [Hey Whipple, Squeeze This - Luke Sullivan](https://heywhipple.com/books/)
- [David Ogilvy Copywriting - Neil Patel](https://neilpatel.com/blog/david-ogilvy/)
- [Propaganda Techniques - Wikipedia](https://en.wikipedia.org/wiki/Propaganda_techniques)

---

## 5. Pricing Psychology
*For sales decks, investor pitches, pricing page presentations*

Pricing isn't just about numbers—it's about perception. These techniques address how audiences process and respond to prices.

### Core Pricing Principles

| Technique | Mechanism | Application |
|-----------|-----------|-------------|
| **Charm Pricing (Left-Digit Effect)** | $99 feels significantly cheaper than $100 because the brain anchors on the leftmost digit | Use .99/.95 endings for value-focused products; round numbers ($500) for premium positioning |
| **Rule of 100** | Under $100: percentages feel larger. Over $100: absolute amounts feel larger | $80 product: "20% off" beats "$16 off." $500 product: "$100 off" beats "20% off" |
| **Good-Better-Best** | People judge prices relative to options; middle tier seems reasonable | Three tiers where middle is your target; expensive tier anchors, cheap tier provides floor |
| **Mental Accounting** | Same price framed differently changes perception | "$3/day" feels cheaper than "$90/month" — "less than your morning coffee" reframes expense |
| **Anchoring Effect** | First number seen heavily influences subsequent judgments | Show higher price first (original price, competitor price, enterprise tier) |
| **Decoy Effect** | Adding inferior third option makes preferred option look better | "Decoy" tier that's clearly worse value makes target tier obvious choice |

### Price Presentation Rules

**For value positioning:**
- Use charm pricing (.99, .95)
- Show original/crossed-out price
- Emphasize savings in percentages (under $100) or dollars (over $100)
- Frame as daily/weekly cost for subscriptions

**For premium positioning:**
- Use round numbers ($500, $1000)
- Don't show discounts (signals desperation)
- Emphasize quality signals, not price comparisons
- Let price stand alone with value proposition

### Pricing Slides Checklist

- [ ] Anchor established before showing price (competitor price, value delivered, cost of problem)
- [ ] Price framing matches positioning (charm vs. round)
- [ ] "Compared to what?" is clear
- [ ] Mental accounting frame chosen (per day, per user, per outcome)
- [ ] Decoy or middle-tier strategy applied if multiple options

---

## 6. Behavior Change Models
*Why audiences do or don't take action — critical for CTA effectiveness*

Understanding behavior change explains why calls-to-action succeed or fail. These models should inform every action slide.

### BJ Fogg Behavior Model

**Formula:** Behavior = Motivation × Ability × Prompt

All three must be present simultaneously for action to occur.

| Component | What It Means | Why CTAs Fail |
|-----------|---------------|---------------|
| **Motivation** | Desire to act (pain, pleasure, hope, fear) | "They don't care enough" — deck hasn't built sufficient motivation |
| **Ability** | Ease of taking action | "Too hard" — friction is too high; first step isn't trivially easy |
| **Prompt** | Trigger at the right moment | "No clear ask" — CTA is buried, vague, or mistimed |

**Application:** Before designing CTA slides, audit all three:
1. Have we built sufficient motivation? (Pain → Aspiration → Urgency)
2. Is the action trivially easy? (One click, one call, one form field)
3. Is the prompt clear and well-timed?

### EAST Framework
*Behavioral Insights Team (UK)*

Make desired behaviors: **E**asy, **A**ttractive, **S**ocial, **T**imely

| Dimension | How to Apply |
|-----------|--------------|
| **Easy** | Reduce friction ruthlessly. Pre-fill forms. Provide templates. Make first step tiny. |
| **Attractive** | Make it appealing. Personalize. Highlight benefits visually. Use incentives. |
| **Social** | Show others doing it. Use social proof near CTA. "Join 2,847 teams" |
| **Timely** | Ask at the right moment. After peak engagement. When motivation is high. |

### Activation Energy

**Principle:** The initial energy required to start something. High activation energy prevents action even if the overall task is easy.

**Application:** Reduce starting friction obsessively.
- Don't ask for full signup — ask for email only
- Don't require a call — offer async demo
- Don't demand commitment — offer free trial
- Show quick wins immediately

**Bad CTA:** "Schedule a consultation with our team"
**Better CTA:** "See your results in 60 seconds" → then nurture to consultation

### Status-Quo Bias

**Principle:** People prefer current state. Change requires effort and feels risky.

**Application for change management decks:**
- Acknowledge what they'll lose by changing (show you understand)
- Make transition feel safe: "Import your data in one click"
- Emphasize continuity: "Everything you know, plus..."
- Reduce perceived risk: "Try for 30 days, full refund if not satisfied"

### Hyperbolic Discounting (Present Bias)

**Principle:** People strongly prefer immediate rewards over future ones, even when waiting is more rational.

**Application:**
- Emphasize immediate benefits: "Start saving time today"
- Avoid: "You'll see ROI in 6 months"
- Better: "See results in your first week"
- Provide instant gratification even in long-term plays

### Key Psychological Principles for Action Slides

| Principle | Mechanism | Application |
|-----------|-----------|-------------|
| **Loss Aversion** | Losses feel ~2x as painful as equivalent gains | Frame inaction as loss: "Every day without this costs you..." |
| **Endowment Effect** | People value things more once they own them | Free trials, samples let them "own" it before paying |
| **IKEA Effect** | People value things they helped create | Let them customize, configure, or build — investment increases commitment |
| **Zeigarnik Effect** | Unfinished tasks occupy the mind | "You're 80% there" creates pull to complete |
| **Regret Aversion** | People avoid actions that might cause regret | Address directly: "30-day guarantee" removes regret fear |

### CTA Audit Checklist

- [ ] Motivation built sufficiently before ask?
- [ ] First step trivially easy? (Activation energy minimized)
- [ ] Prompt clear and specific?
- [ ] Loss framing used? (What they lose by not acting)
- [ ] Risk reducers present? (Guarantee, trial, "no commitment")
- [ ] Social proof near CTA?
- [ ] Immediate benefit emphasized over future benefit?
- [ ] Status-quo addressed? (Why change is safe/necessary)

---

## 7. Psychological Mechanisms

These explain WHY narrative techniques work, enabling more intentional application.

### Why Mystery/Delayed Revelation Works

**Zeigarnik Effect:** Unfinished tasks and unanswered questions occupy mental resources until resolved. Opening a "mystery box" creates cognitive tension that demands closure.

**Application:** The Prestige and Mystery Box arcs leverage this by:
- Opening with an unanswered question (tension created)
- Providing clues that partially resolve but open new questions (tension maintained)
- Delivering reveal at ~60% (tension released, then new understanding crystallizes)

### Why S.T.A.R. Moments Work

**Peak-End Rule:** People judge experiences primarily by the peak (best or worst moment) and the ending, not by the sum or average.

**Application:**
- Design ONE intentional peak — this is your S.T.A.R. moment
- Invest disproportionate effort in the ending
- A mediocre middle is forgiven if peak and end are strong

### Why Transformation Narratives Work

**Identity-Based Persuasion:** People act consistently with who they believe they are. Transformation narratives (Hero's Journey) work because they offer a new identity.

**Application:**
- Frame the journey as identity transformation, not just behavior change
- "Become the kind of company that..." vs. "Do this thing"
- The "Return with Elixir" is an identity upgrade the audience can claim

### Why "Name the Game" Works

**Pattern Recognition:** The brain constantly seeks patterns to reduce cognitive load. When you name a previously invisible pattern, you provide a lens that makes complex situations suddenly legible.

**Application:** Game of the Scene arc works because:
- Pointing out the pattern feels like a gift (reciprocity)
- Once named, the pattern can't be unseen (stickiness)
- Audience feels smarter for understanding it (ego gratification)

---

## 8. Schwartz's 7 Copy Techniques
*From Breakthrough Advertising — the $3,000 copywriting bible*

Eugene Schwartz identified seven techniques for building persuasion in body copy. These transform adequate copy into breakthrough copy.

| Technique | Purpose | When to Use |
|-----------|---------|-------------|
| **Intensification** | Amplify desire with vivid, fresh fulfillments | S.T.A.R. moments, peak slides, benefit sections |
| **Identification** | Connect product to roles audience wants to play | Transformation slides, aspiration sections |
| **Gradualization** | Build belief through logical chain of acceptances | Overall deck argument structure |
| **Redefinition** | Remove objections by reframing before they arise | Limitations slides, objection handling |
| **Mechanization** | Explain HOW it works to satisfy skeptics | "How it works" sections, credibility building |
| **Concentration** | Direct comparison highlighting competitor weaknesses | Competitive positioning slides |
| **Camouflage** | Borrow trust by matching audience's communication style | Tone calibration, format selection |

### Technique Details

**Intensification** — The most important technique. Present multiple fresh, vivid fulfillments of the prospect's dominant desire. Don't just say "save time" — show what they'll do with that time, how it feels, what others will notice.

**Identification** — People buy products to play roles. Two approaches:
1. Product as *instrument* for achieving desired role ("This will make you the leader who...")
2. Product as *acknowledgment* that role is achieved ("For those who've already proven...")

**Gradualization** — Build a "bridge of belief" from what they already accept to your boldest claim:
- Start with easily-believed facts
- Layer progressively bolder claims
- Each claim rests on the foundation of the previous

**Redefinition** — Remove roadblocks before they become objections:
- High price? Redefine as "investment with 10x return"
- Complex product? Redefine as "the last tool you'll need"
- New category? Redefine familiar concepts to fit

**Mechanization** — Show the mechanism that delivers the promise:
- "Floats fat right out of your body" (mechanism in the headline)
- "Our AI scans 10,000 data points in 3 seconds" (specific mechanism)
- Satisfies the "but HOW?" question skeptics always have

**Concentration** — Direct competitive comparison:
- Name the old way's specific failures
- Show your specific advantages
- Best when audience is already solution-aware

**Camouflage** — Match the format people trust:
- Executive audience? Match McKinsey deck format
- Engineers? Match technical documentation style
- Consumers? Match editorial/magazine feel

---

## 9. The 13 Intensification Methods
*Schwartz's complete toolkit for amplifying desire*

Use this checklist when crafting key slides, S.T.A.R. moments, and benefit sections.

| # | Method | Application |
|---|--------|-------------|
| 1 | **Present product directly** | Specific, vivid description of product or the satisfaction it delivers |
| 2 | **Put claims in action** | Show exactly HOW it delivers — not just what, but the mechanism working |
| 3 | **Bring in the reader** | "On Day 1, you'll..." — make them the protagonist experiencing benefits |
| 4 | **Show how to test claims** | Let them visualize proving the product works themselves |
| 5 | **Stretch benefits in time** | Show benefits unfolding over weeks and months, not just the first hour |
| 6 | **Bring in other people** | Survey respondents, success stories, celebrities reacting to the product |
| 7 | **Feature expert validation** | Professionals and specialists registering sophisticated approval |
| 8 | **Comparative analysis** | Contrast old painful methods vs. your new approach |
| 9 | **Negative framing** | Vividly describe the pain BEFORE presenting the solution |
| 10 | **Emphasize ease** | Stress simplicity: price, usability, maintenance, getting started |
| 11 | **Use imaginative language** | Metaphors and analogies that make abstract benefits concrete |
| 12 | **Summary recap** | Consolidate benefits through bullets or engaging narrative |
| 13 | **Guarantee as climax** | Transform warranty into final benefit reinforcement, not fine print |

### Intensification Checklist for Key Slides

- [ ] Does the slide show what happens on Day 1 of "ownership"?
- [ ] Is there expert or social proof validating the claim?
- [ ] Does it contrast the old painful way vs. the new way?
- [ ] Are metaphors making abstract benefits tangible?
- [ ] Are benefits stretched across time (not just immediate)?
- [ ] Is there sensory language (feel, see, hear, experience)?
- [ ] Does the section end with reassurance/guarantee?

---

## 10. Headline Power Multipliers
*Schwartz's "Verbalization" — multiply headline power by 5-50x*

The same claim can be expressed thousands of ways. Verbalization is the art of finding the expression that multiplies impact.

### Three Functions of Verbalization

1. **Strengthen** — Enlarge, measure, make vivid
2. **Freshen** — Twist, change angle, narrate, challenge
3. **Pull** — Promise information, question them, reveal mechanism

### Verbalization Techniques

| Technique | Before | After |
|-----------|--------|-------|
| **Measure size** | "Lose weight" | "Lose 47 pounds" |
| **Measure speed** | "Get results fast" | "See results in 14 days" |
| **Measure comparison** | "Work faster" | "Work 3x faster than your competitors" |
| **Metaphorize** | "Remove fat" | "Melts away ugly fat" |
| **Sensitize (5 senses)** | "Feel better" | "Wake up feeling 20 years younger" |
| **Dramatize** | "Impress others" | "They'll accuse you of having a secret" |
| **Challenge** | "Learn to invest" | "Is it immoral to make money this easily?" |
| **Limit access** | "Anyone can do this" | "If you've already mastered X, don't read this" |
| **Direct address** | "For professionals" | "To the executive who refuses to settle for second" |
| **Reveal mechanism** | "Burns fat" | "Floats fat right out of your body" |

### The Verbalization Test

For every headline, ask: **"Can I make this same claim 5x more powerful by changing HOW I say it?"**

Try at least 3 verbalization techniques on your most important headlines before settling.

---

## 11. Master Headline Formulas
*Proven templates from Ogilvy, Halbert, Caples, and Schwartz*

### How-To Formulas
```
How to [achieve desired result]
How to [achieve result] without [pain point]
How to [achieve result] in [specific timeframe]
How [specific person] [achieved result] — and how you can too
```

### Question Formulas
```
Do you make these mistakes in [area]?
What would you do with [benefit]?
Who else wants [desired outcome]?
Are you [common mistake that resonates]?
```

### Secret/Reveal Formulas
```
The secret of [achieving result]
[Number] secrets [authority figures] don't want you to know
What [experts] know about [topic] that you don't
The hidden [thing] behind every [result]
```

### Number/List Formulas
```
[Number] ways to [achieve result]
[Number] reasons why [counterintuitive claim]
[Number] mistakes that [cause painful problem]
[Number] [things] every [audience] must know before [action]
```

### News/Announcement Formulas
```
Introducing: [new thing that solves problem]
Finally, a [solution] that [unique benefit]
At last: [solution to long-standing frustration]
New [product] makes [old painful way] obsolete
```

### Challenge/Provocative Formulas
```
Warning: [negative consequence of not reading]
[Counterintuitive claim] — here's why
Stop [common action] — it's [surprising reason]
The [topic] lie you've been told
```

### Story Formulas
```
They laughed when I [action] — but when I [result]...
I was [before state]. Then I discovered [thing]. Now I'm [after state].
[Specific person] went from [bad] to [good] in [time]. Here's how.
```

### The Halbert Interest Formula

**Interest = Benefit + Curiosity**

Every headline should deliver a clear benefit AND open a curiosity gap that demands resolution.

### Ogilvy's Headline Checklist

- [ ] Does it promise a benefit?
- [ ] Is it specific (numbers, timeframes, amounts)?
- [ ] Does it identify the target audience?
- [ ] Is it clear (not clever or punny)?
- [ ] Could a competitor claim the same thing? (If yes, make it more specific)
- [ ] Have you written at least 16 variations?

---

## 12. Bernays: Strategic Persuasion
*From the "father of public relations" — engineering consent through situation design*

Edward Bernays (1891–1995) pioneered the scientific technique of shaping public opinion by synthesizing Freud's unconscious desires, Le Bon's crowd psychology, and Lippmann's theories of stereotypes. His key insight: **people are not rational actors** — they're driven by unconscious desires and influenced through group dynamics.

### Create Circumstances, Not Arguments

> "The practice of creating circumstances and of creating pictures in the minds of millions of persons is very common."

Don't argue directly for your conclusion. Structure the deck so the audience reaches your conclusion themselves before you state it.

**Technique:**
- Instead of "You should adopt X because Y" at slide 12...
- Structure slides 1-11 so by slide 12, they've *already concluded* X
- Your reveal confirms what they're already thinking

**Test:** By the reveal slide, is your conclusion *surprising* or *inevitable*? Aim for inevitable — they should be nodding before you say it.

**Example:** Bernays sold pianos not by promoting pianos, but by "developing public acceptance of the idea of a music room in the home." The pianos sold themselves once the circumstance existed.

### High-Spotting for S.T.A.R. Moments

The most powerful S.T.A.R. moment is a **symbolic demonstration**, not just a reveal or statistic.

| Instead of... | Try... |
|---------------|--------|
| Explaining safety features | Elisha Otis cutting the elevator rope while standing inside |
| Listing efficiency gains | One dramatic before/after with specific numbers |
| Describing transformation | Showing a single person's journey in vivid detail |

**Principle:** One dramatic symbolic action > many rational arguments

**Application:** When designing your S.T.A.R. moment, ask: "Can this be a *demonstration* rather than an explanation?"

### The Bernays Question (for Audience Analysis)

Beyond stated needs, ask: **"What do they *really* want that they can't admit?"**

| Stated Need | Hidden Desire |
|-------------|---------------|
| "We need better tools" | Not looking incompetent to peers |
| "We want efficiency" | Permission to stop doing things they hate |
| "We need data" | Cover for a decision they've already made |
| "We want innovation" | Status as forward-thinking leaders |
| "We need buy-in" | Not being blamed if it fails |

**Application:** The Audience Advocate should probe for hidden desires, not just stated requirements. Decks that address hidden desires create "they really get us" resonance.

### Win the Leader, Win the Group

Society functions as overlapping groups. Rather than persuading individuals, identify group leaders and secure their endorsement — followers naturally align.

**Application:**
- Who does your audience look up to or trust?
- Can you quote/reference those authorities?
- Can you show those leaders have already adopted your position?

**Example:** Bernays got 5,000 physicians to endorse hearty breakfasts. Headlines about the study sold more bacon than any ad could.

---

## Sources (Sections 8-12)

- [Breakthrough Advertising - Eugene Schwartz](https://breakthroughadvertisingbook.com/)
- [38 Headline Techniques - Breakthrough Marketing Secrets](https://www.breakthroughmarketingsecrets.com/blog/382-ways-to-strengthen-your-headline-from-the-great-gene-schwartz/)
- [13 Ways to Intensify Desire - AWAI](https://www.awai.com/2011/02/thirteen-ways-to-increase-your-readers-desire/)
- [Gary Halbert's Headline Strategy - Medium](https://medium.com/@fullstackwriter/gary-halberts-secret-headline-writing-strategy)
- [David Ogilvy's Headline Rules - Shortform](https://www.shortform.com/blog/writing-headlines/)
- [John Caples Tested Advertising Methods](https://marketbold.com/how-to-get-better-at-copywriting/)
- [The Edward Bernays Reader - Ig Publishing](https://www.igpub.com/the-edward-bernays-reader/)
- [Engineering of Consent - Wikipedia](https://en.wikipedia.org/wiki/The_Engineering_of_Consent)
- [Propaganda Summary - Growth Summary](https://growthsummary.com/book-summary/propaganda/)
