# Content Expert — Reference Guide

Quick-reference for fact-checking, source evaluation, and logical validity.

---

## 1. IFCN Fact-Checking Methodology
*International Fact-Checking Network*

### Core Commitments

| Commitment | Application |
|------------|-------------|
| **Nonpartisanship** | Apply same standard to every claim, regardless of source |
| **Transparency of Sources** | Provide enough detail that readers can verify findings |
| **Transparency of Methodology** | Explain how claims are selected, researched, and rated |
| **Honest Corrections** | Acknowledge and correct errors openly |

### Verification Process

1. **Identify the claim** — What specifically is being asserted?
2. **Trace the source** — Where did this claim originate?
3. **Seek corroboration** — At least 2 independent sources for central claims
4. **Contact the claimant** — Burden of proof is on them
5. **Consult experts** — For technical or specialized claims
6. **Document everything** — Create audit trail

### Red Flags

- Claim made without source
- Source is circular (cites itself or derivative sources)
- Statistics without methodology or sample size
- Quotes without context or full transcript
- "Many people say" without specifics
- Dramatic claims from single study

---

## 2. Common Logical Fallacies

Detect these in deck claims:

### Fallacies of Relevance

| Fallacy | Description | Example in Decks |
|---------|-------------|------------------|
| **Ad Hominem** | Attack the person, not the argument | "Critics of this approach lack vision" |
| **Appeal to Authority** | Citing unqualified authority | "Einstein said..." (on non-physics topic) |
| **Appeal to Emotion** | Substituting emotion for evidence | Fear-based claims without data |
| **Bandwagon** | "Everyone believes it" | "Industry consensus" without citation |
| **Red Herring** | Distracting from the real issue | Impressive but irrelevant stats |

### Fallacies of Presumption

| Fallacy | Description | Example in Decks |
|---------|-------------|------------------|
| **False Dilemma** | Only two options presented | "Either we do this or we fail" |
| **Slippery Slope** | Assuming chain of consequences | "If we don't act now, X leads to Y leads to Z" |
| **Hasty Generalization** | Conclusion from insufficient evidence | One case study → universal claim |
| **False Cause** | Correlation ≠ causation | "After we launched X, revenue grew" |
| **Circular Reasoning** | Conclusion in the premise | "This works because it's effective" |

### Fallacies of Ambiguity

| Fallacy | Description | Example in Decks |
|---------|-------------|------------------|
| **Equivocation** | Shifting word meaning | Using "growth" to mean different things |
| **Straw Man** | Misrepresenting opponent's position | "Some say we should do nothing" |
| **Loaded Question** | Question assumes conclusion | "Why is this the best approach?" |

---

## 3. Source Evaluation: SIFT Method

| Step | Action |
|------|--------|
| **S — Stop** | Don't immediately believe or share. Pause. |
| **I — Investigate the source** | Who is behind this? What's their expertise? Agenda? |
| **F — Find better coverage** | What do other sources say? Is this corroborated? |
| **T — Trace claims** | Go to the original source. Read the actual study/quote. |

---

## 4. Confidence Rating Framework

Rate each major claim in the deck:

| Rating | Criteria |
|--------|----------|
| **HIGH** | Directly supported by source material; verifiable; properly contextualized |
| **MEDIUM** | Supported but requires inference; single source; minor extrapolation |
| **LOW** | Weak source; significant extrapolation; context unclear |
| **UNSUPPORTED** | No source; fabricated; contradicts source material |

---

## 5. Perplexity Search Protocol

**After reviewing the deck, conduct a Perplexity search to:**

1. **Find supporting evidence** — Search for data, studies, or examples that strengthen user's claims
2. **Identify context** — Background information the audience may need
3. **Discover related insights** — Adjacent findings that could enrich the narrative
4. **Verify statistics** — Confirm numbers, dates, and attributions

**Search prompts to use:**
- "[Topic] statistics 2024 2025"
- "[Claim] evidence research study"
- "[Industry/field] trends data"
- "Is it true that [specific claim]"

**Output format:**
```
### Supporting Research Found

**[Claim from deck]:**
- [Supporting evidence from search]
- Source: [URL/publication]
- Confidence: [High/Medium/Low]

**Additional context for user:**
- [Relevant finding that could strengthen the deck]
```

---

## 6. What to Flag

### Must Flag (Critical)
- Fabricated statistics or quotes
- Claims directly contradicted by source
- Logical fallacies in core argument
- Missing attribution for specific claims

### Should Flag (Important)
- Extrapolations beyond source material
- Claims that need caveats
- Single-source claims on contested topics
- Outdated data presented as current

### Consider Flagging (Minor)
- Imprecise language that could be tightened
- Missing context that sophisticated audiences might want
- Claims that are true but cherry-picked

---

## 7. Checklist for Content Review

- [ ] Every statistic has a source
- [ ] Quotes are accurate and in context
- [ ] Claims marked [GENERATED] are defensible
- [ ] No logical fallacies in core argument
- [ ] Caveats and limitations acknowledged
- [ ] Correlation not presented as causation
- [ ] Perplexity search completed for supporting evidence
- [ ] "Can every claim be defended if challenged?"

---

## Sources

- [IFCN Code of Principles - Poynter](https://ifcncodeofprinciples.poynter.org/)
- [Logical Fallacies - Purdue OWL](https://owl.purdue.edu/owl/general_writing/academic_writing/logic_in_argumentative_writing/fallacies.html)
- [List of Fallacies - Wikipedia](https://en.wikipedia.org/wiki/List_of_fallacies)
- [FactCheck.org Process](https://www.factcheck.org/our-process/)
- [SIFT Method - Mike Caulfield](https://hapgood.us/2019/06/19/sift-the-four-moves/)
