# Visual Designer — Reference Guide

Quick-reference for visual storytelling, data visualization, and visual metaphors.

---

## 1. Edward Tufte: Data Visualization Principles

### Core Principles

| Principle | Application |
|-----------|-------------|
| **Data-Ink Ratio** | Maximize ink used for data; minimize decorative ink. Every mark should inform. |
| **Chartjunk** | Eliminate: moiré patterns, heavy grids, 3D effects, decorative illustrations that obscure data |
| **Graphical Integrity** | No distortion. Represent numbers proportionally. Don't truncate axes deceptively. |
| **Small Multiples** | Series of similar charts showing comparison or change over time |
| **Layering & Separation** | Use visual hierarchy to distinguish data from labels from background |

### The Lie Factor
> Lie Factor = (Size of effect shown in graphic) / (Size of effect in data)

Lie Factor should equal 1.0. Above 1.05 is deceptive.

### Tufte's Critique of PowerPoint
- Bullet points fragment thought
- Low resolution limits data density
- Default templates encourage chartjunk
- **Counter:** Use slides as visual aids, not documents

---

## 2. Nancy Duarte: Presentation Design

### Slide:ology Principles

| Principle | Application |
|-----------|-------------|
| **3-Second Rule** | Slides are "glance media" — can you grasp it in 3 seconds? |
| **One Idea Per Slide** | Don't make audiences process multiple concepts simultaneously |
| **Visual Thinking** | Show, don't just tell. Transform words into images. |
| **Consistent Color Palette** | 3-5 colors max, used consistently throughout |
| **Whitespace** | Resist the urge to fill. Empty space creates focus. |

### S.T.A.R. Moments
*Something They'll Always Remember*

| Type | Description |
|------|-------------|
| **Memorable Dramatization** | Live demo, physical prop, unexpected action |
| **Repeatable Sound Bite** | Phrase designed to be quoted |
| **Evocative Visual** | Image that captures the thesis visually |
| **Emotive Story** | Personal narrative that humanizes data |
| **Shocking Statistic** | Number presented for maximum impact |

**Goal:** Design at least one S.T.A.R. moment per presentation — ideally at the reveal point.

---

## 3. Cognitive Load Considerations

### Working Memory Limits
- **Miller's Law:** 7±2 chunks of information
- **Practical limit for slides:** 3-5 elements per concept
- **Implication:** Group, simplify, sequence

### Dual Coding Theory
- Visuals and words processed in separate channels
- **Complementary** (not redundant): Image shows what words explain
- **Bad:** Reading bullet points aloud while they're on screen
- **Good:** Visual metaphor while narrating the insight

### Peak-End Rule
- People remember the **peak moment** and the **ending**
- Design your strongest visual for the reveal
- End with a powerful, clean final image

---

## 4. Visual Metaphor Framework

### Types of Visual Metaphors

| Type | Description | Example |
|------|-------------|---------|
| **Replacement** | Substitute one image for another | Heart = love; lightbulb = idea |
| **Fusion** | Blend two images into one | Melting clock = time distortion |
| **Juxtaposition** | Place contrasting images together | Before/after; old/new |

### Creating Visual Metaphors

1. **Identify the core concept** — What's the single idea?
2. **Abstract to quality** — Is it speed? Safety? Connection? Growth?
3. **List associations** — 20+ items associated with that quality
4. **Select the unexpected** — Avoid clichés; find fresh connections

**Example:** "Security" → seatbelt, parachute, guardian angel, fortress, cocoon, roots, anchor, insurance policy, safety net, bodyguard, vault, shell, harbor, umbrella...

### Metaphor Families (Choose One Per Deck)

| Family | Visual Vocabulary |
|--------|-------------------|
| **Journey** | Path, road, horizon, crossroads, compass, milestone, bridge, summit |
| **Architecture** | Foundation, pillars, building, blueprint, scaffolding, cornerstone |
| **Nature/Growth** | Seeds, roots, branches, seasons, ecosystem, cultivation, harvest |
| **Water** | Waves, currents, flow, confluence, depth, surface, streams, ocean |
| **Light** | Illumination, shadows, dawn, clarity, spotlight, spectrum |
| **Weaving/Fabric** | Threads, pattern, tapestry, warp/weft, texture, mesh |
| **Machinery** | Gears, engine, fuel, leverage, calibration, synchronization |
| **Weather** | Storms, clearing, pressure, climate, atmosphere, forecast |

**Rule:** Pick one family and stay consistent throughout the deck.

---

## 5. Iconography & Symbolism Reference

### Universal Symbols

| Symbol | Common Meanings |
|--------|-----------------|
| **Circle** | Unity, wholeness, infinity, protection |
| **Triangle** | Direction, stability (point up), instability (point down) |
| **Square** | Order, stability, equality, structure |
| **Arrow** | Direction, movement, progress, cause-effect |
| **Scale/Balance** | Justice, fairness, equilibrium |
| **Bridge** | Connection, transition, overcoming obstacles |
| **Door/Gate** | Opportunity, threshold, new beginnings |
| **Mirror** | Self-reflection, truth, duality |
| **Chain** | Connection (intact) or bondage (broken = freedom) |
| **Tree** | Growth, life, knowledge, family, interconnection |

### Cultural Considerations

Symbols vary by culture. Always consider:
- Color meanings (white = purity in West, mourning in East)
- Religious symbols (cross, crescent, om)
- Gestures (thumbs up, OK sign vary by region)
- Animals (owls = wisdom in West, bad omen in some cultures)

**Rule:** When presenting cross-culturally, research symbol meanings for the specific audience.

### Art Historical References

| Reference | Evokes |
|-----------|--------|
| **Vanitas (still life with skulls)** | Mortality, impermanence, urgency |
| **Renaissance perspective** | Order, rationality, mastery |
| **Impressionism** | Subjectivity, moment in time, light |
| **Surrealism (Dalí, Magritte)** | Subconscious, unexpected connections, dreams |
| **Minimalism** | Essence, clarity, focus |
| **Pop Art (Warhol, Lichtenstein)** | Mass culture, repetition, commerce |

### Reference Resources

- **ICONCLASS** — Comprehensive iconographical classification system
- **Index of Medieval Art** — Princeton's database of Christian iconography
- **Noun Project** — Modern icon library
- **Dictionary of Subjects and Symbols in Art** — James Hall
- **Signs & Symbols** — DK Publishing (visual encyclopedia)

---

## 6. Color Psychology

| Color | Associations | Use For |
|-------|--------------|---------|
| **Blue** | Trust, calm, professionalism | Corporate, finance, technology |
| **Red** | Urgency, passion, danger | Alerts, calls to action, energy |
| **Green** | Growth, nature, money | Environment, finance, health |
| **Yellow** | Optimism, caution, attention | Highlights, warnings |
| **Orange** | Energy, creativity, warmth | Innovation, enthusiasm |
| **Purple** | Luxury, wisdom, creativity | Premium, spiritual, imaginative |
| **Black** | Sophistication, power, elegance | Luxury, formality |
| **White** | Purity, simplicity, space | Clean, minimal, medical |

---

## 7. Checklist for Visual Review

- [ ] One metaphor family used consistently
- [ ] 3-second rule: each slide readable at a glance
- [ ] No chartjunk — every visual element earns its place
- [ ] S.T.A.R. moment designed for the reveal
- [ ] Data visualizations have graphical integrity
- [ ] Color palette consistent (3-5 colors max)
- [ ] Cultural appropriateness verified for audience
- [ ] Peak moment has strongest visual treatment
- [ ] Whitespace used intentionally

---

## Sources

- [Tufte's Data Visualization Principles - GeeksforGeeks](https://www.geeksforgeeks.org/data-visualization/mastering-tuftes-data-visualization-principles/)
- [Duarte Slide:ology](https://www.duarte.com/resources/books/slideology/)
- [Duarte Resonate - S.T.A.R. Moments](https://www.duarte.com/resources/books/resonate/)
- [Visual Metaphors - Study.com](https://study.com/learn/lesson/visual-metaphor-images-examples.html)
- [Art Iconography & Symbolism - UNT Libraries](https://guides.library.unt.edu/art-iconography)
- [Iconography - Humanities LibreTexts](https://human.libretexts.org/Bookshelves/Art/Book:_Introduction_to_Art_-_Design_Context_and_Meaning_(Sachant_et_al.)/05:_Meaning_in_Art/5.03:_SYMBOLISM_AND_ICONOGRAPHY)
