# Communication Frameworks Reference

Detailed structures for efficiency-optimized communication frameworks. These prioritize clarity, speed, and persuasion over engagement through mystery.

---

## Minto Pyramid Principle

**Source:** Barbara Minto (McKinsey)
**Best for:** Executive communication, consulting deliverables, board presentations
**Key principle:** Answer first, then support

### Structure

```
           ┌─────────────┐
           │   ANSWER    │  ← Lead with the "so what"
           │ (Thesis)    │
           └──────┬──────┘
                  │
     ┌────────────┼────────────┐
     ▼            ▼            ▼
┌─────────┐ ┌─────────┐ ┌─────────┐
│ Support │ │ Support │ │ Support │  ← MECE: Mutually Exclusive,
│   #1    │ │   #2    │ │   #3    │    Collectively Exhaustive
└────┬────┘ └────┬────┘ └────┬────┘
     │           │           │
     ▼           ▼           ▼
  Evidence    Evidence    Evidence
```

### Slide Allocation

| Section | Slides | Content |
|---------|--------|---------|
| Answer/Recommendation | 1-2 | Single clear thesis |
| Support #1 | 3-5 | First MECE argument + evidence |
| Support #2 | 3-5 | Second MECE argument + evidence |
| Support #3 | 3-5 | Third MECE argument + evidence |
| Implications/Next Steps | 1-2 | So what + action items |

### MECE Test

Arguments must be:
- **Mutually Exclusive:** No overlap between categories
- **Collectively Exhaustive:** Nothing important left out

Bad example: "Revenue, Customers, Sales" (Sales overlaps with Revenue)
Good example: "Revenue, Costs, Market Position" (distinct, complete)

---

## SCQA Framework

**Source:** Barbara Minto
**Best for:** Opening hooks, executive summaries, problem framing
**Use:** As a hook before Pyramid structure

### Structure

| Element | Purpose | Example |
|---------|---------|---------|
| **S**ituation | Establish common ground | "Dell pioneered direct-to-consumer PC sales" |
| **C**omplication | Introduce tension | "Asian manufacturers now undercut our costs by 30%" |
| **Q**uestion | The question this raises | "How can Dell regain competitive advantage?" |
| **A**nswer | Your recommendation | "Double down on enterprise services" |

### Variations

**SQA:** Skip Complication when audience already knows the problem
**CSA:** Lead with Complication when urgency is paramount
**QSA:** Lead with Question when it's the hook

---

## AIDA Framework

**Source:** Elmo Lewis (advertising)
**Best for:** Sales presentations, marketing pitches, fundraising
**Key principle:** Move audience through psychological stages

### Structure

| Stage | Purpose | Slide % | Techniques |
|-------|---------|---------|------------|
| **A**ttention | Break through noise | 5% | Startling statistic, provocative question, bold claim |
| **I**nterest | Create engagement | 50% | Storytelling, relevance to audience, facts |
| **D**esire | Build motivation | 30% | Benefits, social proof, emotional connection |
| **A**ction | Drive behavior | 15% | Clear CTA, remove friction, create urgency |

### Slide Allocation (20-slide deck)

- Attention: 1 slide
- Interest: 10 slides
- Desire: 6 slides
- Action: 3 slides

### Key Insight

**Interest** requires the most real estate. Most presenters under-invest here, jumping too quickly to Desire/Action.

---

## PAS Framework

**Source:** Direct response copywriting
**Best for:** Change management, selling to skeptics, overcoming inertia
**Key principle:** Agitate the pain before offering relief

### Structure

| Stage | Purpose | Slide % | Techniques |
|-------|---------|---------|------------|
| **P**roblem | Name the pain | 20% | Specific, relatable articulation |
| **A**gitation | Twist the knife | 40% | Consequences of inaction, emotional weight |
| **S**olution | Offer relief | 40% | Your answer + proof it works |

### The Agitation Gap

Most presenters under-invest in Agitation. They name the problem and jump to solution.

**Effective Agitation:**
- Describes negative feelings in audience's own words
- Shows cascading consequences
- Makes inaction feel untenable
- Creates emotional readiness for solution

**Example Agitation sequence:**
1. "Missed deadlines become the norm"
2. "Team morale drops as finger-pointing increases"  
3. "Your best people start looking elsewhere"
4. "Six months later, you're rebuilding a team and explaining to the board"

---

## Raskin's Greatest Sales Deck

**Source:** Andy Raskin (Zuora, Salesforce analysis)
**Best for:** B2B sales, category creation, evangelism pitches
**Key principle:** Never start with your product or "the problem"

### Structure

| Beat | Purpose | Slides | Notes |
|------|---------|--------|-------|
| 1. Name a Big Change | Establish undeniable shift | 2-3 | NOT your product; external force |
| 2. Show Winners/Losers | Create stakes | 2-3 | Companies adapting vs. not |
| 3. Tease Promised Land | Vision without product | 2-3 | Desirable future state |
| 4. Introduce Magic Gifts | Features as journey tools | 4-6 | How you help reach Promised Land |
| 5. Show Evidence | Proof you deliver | 3-4 | Case studies, metrics, logos |

### Why "Change First" Works

Starting with problems puts prospects on defensive ("we don't have that problem").
Starting with change is inarguable and creates urgency without accusation.

**Bad opening:** "Companies struggle with customer churn"
**Good opening:** "Subscription models have replaced ownership in every industry"

### The Promised Land

Describe the destination before introducing your vehicle:
- "Imagine knowing exactly which customers will churn 90 days before they do"
- Not: "Our AI predicts customer churn"

---

## Duarte Resonate

**Source:** Nancy Duarte (slide:ology, Resonate)
**Best for:** Keynotes, vision presentations, inspirational talks
**Key principle:** Oscillate between current reality and future possibility

### Structure (The Sparkline)

```
What Could Be ─────╱╲─────╱╲─────╱╲─────╱╲────── NEW BLISS
                  ╱  ╲   ╱  ╲   ╱  ╲   ╱  ╲
                 ╱    ╲ ╱    ╲ ╱    ╲ ╱    ╲
What Is ────────╱──────╲──────╲──────╲────────
               │                              │
             START                          S.T.A.R.
```

### Key Elements

**Constant Oscillation:** Don't stay too long in "what is" (depressing) or "what could be" (ungrounded). Alternate.

**S.T.A.R. Moment:** Something They'll Always Remember
- Design one intentional peak
- Bill Gates releasing mosquitoes during malaria talk
- Steve Jobs pulling MacBook Air from envelope

**New Bliss Ending:** Close in the transformed future state, not with logistics

### Slide Sequence Pattern

1. What Is (current pain)
2. What Could Be (possibility)
3. What Is (specific example of pain)
4. What Could Be (specific example of possibility)
5. [Repeat oscillation]
6. S.T.A.R. Moment
7. Call to Action
8. New Bliss (vision of transformed future)

---

## SUCCESs Framework

**Source:** Chip & Dan Heath (Made to Stick)
**Best for:** Quality-checking any presentation; ensuring memorability
**Key principle:** Ideas stick when they pass all six tests

### The Six Principles

| Principle | Test | Application |
|-----------|------|-------------|
| **S**imple | Can you state the core in one sentence? | Headlines should pass Commander's Intent test |
| **U**nexpected | Does it break a pattern? | Create curiosity gaps; violate expectations |
| **C**oncrete | Can you picture it? | "37g saturated fat" → "bacon-eggs + Big Mac + steak dinner" |
| **C**redible | Why should I believe it? | Anti-authority testimonials, Sinatra Tests |
| **E**motional | Do I feel something? | Individual > statistics; identity > generic benefits |
| **S**tories | Is there a narrative? | Challenge, Connection, or Creativity plots |

### The Commander's Intent Test

If your audience remembers only ONE thing, what should it be?
Write that as your core message. Everything else supports it.

### Making Statistics Concrete

**Abstract:** "The federal budget deficit is $8.3 trillion"
**Concrete:** "If you spent $1 million per day, it would take 22,000 years to spend $8.3 trillion"

### The Sinatra Test

One example so compelling it proves everything: "If I can make it there, I'll make it anywhere."

Find your Sinatra Test — the single case study, logo, or proof point that makes everything else believable.

---

## Cialdini's Seven Principles

**Source:** Robert Cialdini (Influence, Pre-Suasion)
**Best for:** Layering persuasion onto any framework
**Key principle:** Ethical influence through psychological principles

### Principle Application for Presentations

| Principle | Mechanism | Slide Application |
|-----------|-----------|-------------------|
| **Reciprocity** | Give before asking | Open with valuable insights, proprietary research, or frameworks |
| **Commitment** | Small yeses → big yes | Build micro-agreements through the deck |
| **Social Proof** | People like me do this | Testimonials from *relatable* peers (not just famous logos) |
| **Authority** | Expertise signals | Credentials, data sources, research citations |
| **Liking** | Similarity, compliments | Common ground, "we" language, acknowledge audience's challenges |
| **Scarcity** | Loss aversion | Cost of inaction, limited opportunity, closing windows |
| **Unity** | Shared identity | "We're in this together," family metaphors, in-group language |

### The Give-Give-Give-Ask Ratio

Reciprocity requires *genuine* giving first.
Structure: 3 valuable insights before any ask.

**Restaurant study:** Personalized, unexpected gifts increase tips 23%.
For presentations: Lead with something genuinely useful before requesting anything.

### Unity vs. Liking

**Liking:** "We have things in common" (surface)
**Unity:** "We are the same people" (identity)

Test: Can you legitimately use "we," "us," and "our"?

---

## Schwartz Awareness Levels

**Source:** Eugene Schwartz (Breakthrough Advertising)
**Best for:** Adapting messaging to audience state
**Key principle:** Meet audience where they are, not where you want them to be

### The Five Levels

| Level | Audience State | Open With | Avoid |
|-------|---------------|-----------|-------|
| **Unaware** | Don't know they have a problem | Emotion, stories, relatable scenarios | Product features, solutions |
| **Problem Aware** | Know the problem, not solutions | Empathetic problem articulation | Jumping to your solution |
| **Solution Aware** | Know solutions exist, not yours | Why YOUR approach differs | Generic category education |
| **Product Aware** | Know your product, evaluating | Features, pricing, objection handling | Vague claims |
| **Most Aware** | Ready to act | Irresistible offer, easy next step | Excessive re-education |

### Critical Insight

**Messaging that works for Product Aware audiences fails completely for Unaware audiences.**

Common mistake: Presenting like audience is Product Aware when they're actually Problem Aware.

### How to Assess Audience Level

- **Unaware:** New to the domain; don't recognize the problem
- **Problem Aware:** Actively experiencing pain; searching for solutions
- **Solution Aware:** Evaluating options; comparing approaches
- **Product Aware:** Know you specifically; have questions
- **Most Aware:** Past customers; ready to expand/renew

---

## Story Spine

**Source:** Kenn Adams (adopted by Pixar)
**Best for:** Case studies, origin stories, causal explanations
**Key principle:** Cause and effect create narrative logic

### Structure

```
Once upon a time... [Status quo]
Every day... [Routine/baseline]
But one day... [Disruption]
Because of that... [Consequence 1]
Because of that... [Consequence 2]
Because of that... [Consequence 3]
Until finally... [Resolution]
And ever since then... [New normal]
```

### Business Adaptation

```
Once upon a time... [We faced situation X]
Every day... [We did Y as workaround]
But one day... [We discovered/realized Z]
Because of that... [We changed A]
Because of that... [B happened]
Because of that... [C followed]
Until finally... [We achieved outcome]
And ever since then... [New reality]
```

### Example

"Once upon a time, customer support tickets averaged 200/day. Every day, agents manually triaged each one. But one day, we noticed 60% were the same 10 questions. Because of that, we built a FAQ bot. Because of that, ticket volume dropped 45%. Because of that, agents could focus on complex issues. Until finally, NPS increased 23 points. And ever since then, we've used AI for tier-1 support."

---

## Vonnegut's Story Shapes

**Source:** Kurt Vonnegut (validated by computational analysis)
**Best for:** Emotional arc planning
**Key principle:** Stories follow predictable emotional trajectories

### The Four Shapes

| Shape | Trajectory | Best For |
|-------|------------|----------|
| **Man in Hole** | Good → Bad → Better | Case studies, turnaround stories |
| **Cinderella** | Low → Rise → Fall → Higher | Startup pitches, fundraising |
| **Creation** | Chaos → Order | Platform development, company building |
| **Which Way Is Up** | Ambiguous → Clarity | Market uncertainty analysis |

### Man in Hole (Most Versatile)

```
          Start
            │
            ╰─╮
              │
              ▼ ← The Hole (problem/setback)
              │
            ╭─╯
            │
            ▼
          Better than Start
```

### Cinderella (The Million-Dollar Story)

```
Low ─────╮
         │
         ╰───╮ Rise
              │
              ╰───╮ Higher
                   │
              ╭────╯ Fall (midnight)
              │
         ╭────╯
         │
    ╭────╯ Highest (transformation)
    ▼
```

Perfect for investor pitches: humble origins → traction → setback → ultimate success

---

## Dan Harmon's Story Circle

**Source:** Dan Harmon (Community, Rick and Morty)
**Best for:** Making audience the hero; transformation narratives
**Key principle:** Every step serves the audience's journey

### The Eight Steps

| Step | Label | Audience Experience |
|------|-------|---------------------|
| 1 | YOU | "This is my world" — establish common ground |
| 2 | NEED | "I recognize this problem" — surface the pain |
| 3 | GO | "I'll learn something new" — cross into unfamiliar territory |
| 4 | SEARCH | "Let me evaluate this" — explore the solution |
| 5 | FIND | "This could work" — show proof/results |
| 6 | TAKE | "What's the cost?" — honest about investment |
| 7 | RETURN | "How does this apply to me?" — implementation |
| 8 | CHANGE | "I'm ready" — call to action |

### Key Insight

The **audience** is the hero, not your company/product.

Every slide should answer: "What does the audience need to experience next in their journey?"

Not: "What do we want to say next?"
