#!/usr/bin/env bash
# ABOUTME: Detect the technology stack of the current project
# ABOUTME: Outputs detected stacks as space-separated list

set -e

TARGET_DIR="${1:-.}"
cd "$TARGET_DIR"

STACKS=""

# TypeScript
if [[ -f "tsconfig.json" ]]; then
    STACKS="$STACKS typescript"
fi

# JavaScript (without TypeScript)
if [[ -f "package.json" ]] && [[ ! -f "tsconfig.json" ]]; then
    STACKS="$STACKS javascript"
fi

# Python
if [[ -f "requirements.txt" ]] || [[ -f "pyproject.toml" ]] || [[ -f "setup.py" ]] || [[ -f "Pipfile" ]]; then
    STACKS="$STACKS python"
fi

# Rust
if [[ -f "Cargo.toml" ]]; then
    STACKS="$STACKS rust"
fi

# Go
if [[ -f "go.mod" ]]; then
    STACKS="$STACKS go"
fi

# Java
if [[ -f "pom.xml" ]] || [[ -f "build.gradle" ]] || [[ -f "build.gradle.kts" ]]; then
    STACKS="$STACKS java"
fi

# Ruby
if [[ -f "Gemfile" ]]; then
    STACKS="$STACKS ruby"
fi

# PHP
if [[ -f "composer.json" ]]; then
    STACKS="$STACKS php"
fi

# Trim leading space and output
echo "${STACKS# }"
