<!-- ABOUTME: Brand token sheet for the white paper template. -->
<!-- ABOUTME: Fill these fields to keep papers consistent with the brand system. -->
# Brand Guidelines

## Core tokens

- Brand ink: `#0d1117` (primary text)
- Brand paper: `#ffffff` (page background)
- Paper deep: `#f7f7f7` (callouts, table headers)
- Accent: `#ff6b35` (headings, highlights)
- Secondary: `#93a77a` (supporting elements)
- Neutral: `#3a4654` (captions, metadata)

## Entity profiles

Add one entry per entity in `papers/brands.js`:

```js
window.WHITEPAPER_BRANDS = {
  mycompany: {
    label: "My Company",
    tokens: {
      "brand-ink": "#0d1117",
      "brand-ink-soft": "#18202a",
      "brand-paper": "#ffffff",
      "brand-paper-deep": "#f7f7f7",
      "brand-accent": "#ff6b35",
      "brand-accent-strong": "#ff4d1a",
      "brand-sage": "#93a77a",
      "brand-slate": "#3a4654",
      "brand-line": "rgba(13, 17, 23, 0.12)",
      "brand-glow": "rgba(255, 107, 53, 0.35)"
    },
    fonts: {
      display: "\"Fraunces\", \"Iowan Old Style\", \"Palatino\", serif",
      body: "\"Space Grotesk\", \"Avenir Next\", \"Gill Sans\", sans-serif"
    },
    mediaPromptPrefix: "professional document style, clean minimal aesthetic"
  }
};
```

For per-section overrides, set `data-entity="mycompany"` on the section.

## Example entity baselines

### Northwind Labs (Tech)

Suggested tokens:
- Ink: `#1a1a2e`
- Paper: `#ffffff`
- Paper deep: `#f8f9fa`
- Accent: `#ed8936` (amber)
- Accent strong: `#dd6b20`
- Sage: `#00b5d8` (cyan)
- Slate: `#4a5568`

Style note: Modern tech palette, clean professional style, amber highlights

### Apex Consulting (Professional Services)

Suggested tokens:
- Ink: `#1a1a1a`
- Paper: `#ffffff`
- Paper deep: `#f9f7f4`
- Accent: `#b8956f` (brass)
- Accent strong: `#9a7a57`
- Sage: `#d4a574`
- Slate: `#666666`

Style note: Warm professional palette, refined corporate aesthetic

### Coastal Biotech (Life Sciences)

Suggested tokens:
- Ink: `#0e2841` (navy)
- Paper: `#ffffff`
- Paper deep: `#f6f8fa`
- Accent: `#156082` (teal)
- Accent strong: `#0f9ed5`
- Sage: `#196b24`
- Slate: `#0e2841`

Style note: Navy biotech palette, scientific clarity, teal accents

## Typography

- Display font: `Fraunces` (headings)
- Body font: `Space Grotesk` (paragraphs)
- Alternate: `Iowan Old Style` for display, `Avenir Next` for body
- Update the `@import` fonts in the template if you swap typefaces.

### Font sizes (print)

| Element | Size |
|---------|------|
| H1 (title) | 24pt |
| H2 (section) | 18pt |
| H3 (subsection) | 14pt |
| H4 | 12pt |
| Body | 11pt |
| Caption | 10pt |
| Footnote | 9pt |

## Logo usage

- Primary logo file: Place in `resources/assets/`
- Clear space rule: Maintain logo height as minimum margin
- Minimum size: 1 inch width on cover
- Cover placement: Centered, above title

## Image style

- Format: PNG or JPG, 300 DPI for print quality
- Composition: Clean backgrounds, consistent framing
- Charts/graphs: Use brand accent colors
- Avoid: Low resolution, busy backgrounds, clashing colors

## Diagram style

- Stroke weight: 2px
- Corners: 4-8px radius
- Labels: Sentence case, 9-10pt
- Colors: Use brand palette (ink, accent, sage)
- Icon style: Outline, no gradients

## Figure conventions

- Number figures sequentially (Figure 1, Figure 2, etc.)
- Place caption below the figure
- Reference in text before figure appears
- Use consistent sizing (full-width or half-width)

## Table conventions

- Header row: Background `brand-paper-deep`, uppercase labels
- Borders: Bottom borders only, subtle color
- Alignment: Text left, numbers right
- Caption: Above table, bold

## Voice and tone

- Voice: Authoritative, clear, evidence-based
- Do: Lead with insights, support with data
- Avoid: Jargon without explanation, hedging language
- Length: Concise paragraphs, 3-5 sentences max

## Page layout

- Paper size: US Letter (8.5 × 11 in)
- Margins: 1 inch all sides
- Content width: 6.5 inches
- Line length: 65-75 characters optimal

## Section conventions

| Section | Page break | Typical length |
|---------|------------|----------------|
| Cover | Always | 1 page |
| Executive Summary | Before | 1 page |
| Introduction | Before | 1-2 pages |
| Body sections | Optional | 2-10 pages |
| Conclusion | No | 0.5-1 page |
| Appendix | Before | As needed |
