<!-- ABOUTME: Narrative Engine checklists for deck review quality gates. -->
<!-- ABOUTME: Synced from nraford7/Narrative-Engine with ASCII normalization. -->

# Narrative Engine Checklists

Consolidated quality checklists for deck review. Use the relevant sections based on what you're checking.

---

## Master Quality Gates

Run on every deck before delivery:

- [ ] **Focal clarity:** Can you state the ONE point in one sentence?
- [ ] **Slide necessity:** Does every slide earn its place? (Could any be cut without loss?)
- [ ] **Headline power:** Vivid verb, concrete nouns, one idea, <=14 words
- [ ] **Spotlight quality:** <=60 words, specific, tied to headline, cited if sourced
- [ ] **Arc integrity:** Reveal at correct position (~55-65% for twist arcs); plants and callbacks present
- [ ] **Variety:** No three consecutive headlines share same pattern or verb
- [ ] **Balance:** Limitations/counterevidence get their own slides

---

## Headline Quality Sweeps

Run these sequential passes on all headlines. Each focuses on one dimension.

### Sweep 1: Clarity
Is every headline immediately understandable in <3 seconds?

- [ ] No jargon or insider language without context
- [ ] No ambiguous pronoun references
- [ ] Single idea per headline (not trying to say two things)
- [ ] Reader doesn't need to re-read to understand

**Fix pattern:** Ask "What am I actually trying to say?" and say that directly.

### Sweep 2: So What
Does every headline answer "why should I care?"

- [ ] Every feature connects to a benefit
- [ ] Every claim has consequences for the audience
- [ ] No impressive-sounding statements that don't land

**Test:** For each headline, literally ask "Okay, so what?" If no answer, rewrite.

### Sweep 3: Specificity
Replace vague words with concrete ones.

| Vague | Specific |
|-------|----------|
| Save time | Save 4 hours every week |
| Many customers | 2,847 teams |
| Fast results | Results in 14 days |
| Improve workflow | Cut reporting time in half |
| Great support | Response within 2 hours |
| Significant growth | 127% year-over-year |

- [ ] Vague adjectives replaced with numbers/specifics
- [ ] Time frames included where relevant
- [ ] Claims that can't be made specific removed (they're filler)

### Sweep 4: Emotion
Do headlines make the reader feel something?

- [ ] Key slides evoke feeling, not just convey information
- [ ] Pain points feel real and relatable
- [ ] Aspirations feel achievable and desirable

**Techniques:** Paint "before" state vividly, use sensory language, reference shared frustrations.

### Sweep 5: Proof
Can every headline be defended if challenged?

- [ ] Claims have supporting evidence in the spotlight
- [ ] Statistics have sources
- [ ] Superlatives are earned ("best" requires proof)
- [ ] No fabricated or exaggerated claims

### Sweep 6: Verbalization (Key Headlines Only)
Could the 3-5 most important headlines be 5x more powerful?

- [ ] Tried 3+ verbalization techniques on each key headline?
- [ ] Opening headline creates both benefit AND curiosity?
- [ ] Reveal headline lands with maximum dramatic impact?
- [ ] CTA headline makes saying "no" feel like a loss?

---

## Headline Banlist

Delete or replace these words:

| Banned | Why | Replace With |
|--------|-----|--------------|
| innovative | Meaningless; everyone claims it | Describe what's actually new |
| disruptive | Overused; rarely accurate | Describe the actual change |
| best-in-class | Unsubstantiated superlative | Cite specific ranking/award |
| leading | Vague positioning | "#1 in [specific metric]" |
| robust | Corporate jargon | Strong, reliable, handles X |
| scalable | Tech buzzword | "Handles 10x load without..." |
| world-class | Unprovable | Cite specific credential |
| cutting-edge | Cliche | Describe what's actually new |
| seamless | Overused | Smooth, automatic, invisible |
| leverage | Corporate-speak | Use |
| utilize | Pretentious | Use |
| synergy | Meaningless | Describe the actual benefit |
| holistic | Vague | Comprehensive, complete, end-to-end |
| paradigm | Academic jargon | Model, approach, framework |
| optimize | Often vague | Quantify: "reduce by 40%" |
| streamline | Often vague | "Cut steps from 7 to 2" |

---

## Intensification Checklist

For S.T.A.R. moments, reveal slides, and key benefit claims:

- [ ] Shows what happens on Day 1 of "ownership" (bring in the reader)
- [ ] Includes expert validation or social proof (authority)
- [ ] Contrasts old painful way vs. new approach (comparative analysis)
- [ ] Uses metaphor to make abstract benefits concrete (imaginative language)
- [ ] Stretches benefits across time -- weeks, months, not just immediate
- [ ] Contains sensory language -- how it feels, looks, sounds
- [ ] Section ends with reassurance or guarantee (climax)

---

## CTA Audit Checklist

For action slides and calls-to-action:

- [ ] Motivation built sufficiently before ask?
- [ ] First step trivially easy? (Activation energy minimized)
- [ ] Prompt clear and specific?
- [ ] Loss framing used? (What they lose by not acting)
- [ ] Risk reducers present? (Guarantee, trial, "no commitment")
- [ ] Social proof near CTA?
- [ ] Immediate benefit emphasized over future benefit?
- [ ] Status-quo addressed? (Why change is safe/necessary)

---

## Pricing Slides Checklist

For decks with pricing or investment asks:

- [ ] Anchor established before showing price (competitor price, value delivered, cost of problem)
- [ ] Price framing matches positioning (charm pricing for value, round numbers for premium)
- [ ] "Compared to what?" is clear
- [ ] Mental accounting frame chosen (per day, per user, per outcome)
- [ ] Decoy or middle-tier strategy applied if multiple options

---

## Factual Accuracy Checklist

For Content Expert review:

- [ ] Every statistic has a source
- [ ] Quotes are accurate and in context
- [ ] Claims marked [GENERATED] are defensible
- [ ] No logical fallacies in core argument
- [ ] Caveats and limitations acknowledged
- [ ] Correlation not presented as causation
- [ ] "Can every claim be defended if challenged?"

---

## Persuasion Overlay Checklist

Layer onto any deck:

- [ ] **Reciprocity:** Do we give value before asking?
- [ ] **Commitment:** Are there micro-agreements building?
- [ ] **Social Proof:** Are examples relatable to THIS audience?
- [ ] **Authority:** Are credentials and sources clear?
- [ ] **Liking:** Is there common ground and "we" language?
- [ ] **Scarcity:** Is cost of inaction clear?
- [ ] **Unity:** Does this feel like "us" not "us vs. them"?

---

## Common Copy Problems

Reference when reviewing:

| Problem | Symptom | Fix |
|---------|---------|-----|
| **Wall of Features** | Lists what product does without why it matters | Add "which means..." bridge to benefits |
| **Corporate Speak** | "Leverage synergies to optimize outcomes" | Ask "How would a human say this?" |
| **Weak Opening** | Starting with company history | Lead with audience's problem |
| **Buried CTA** | Ask comes after too much buildup | Make CTA obvious, early, repeated |
| **Generic Claims** | "We help businesses grow" | Specify who, how, by how much |
| **Mixed Audiences** | Copy speaks to everyone, resonates with no one | Pick ONE audience |
| **Feature Overload** | Lists every capability | Focus on 3-5 benefits for THIS audience |
| **No Proof** | "Customers love us" with no evidence | Add testimonials, numbers, cases |
| **Assumed Knowledge** | Jargon audience doesn't know | Define terms or use plain language |

---

## Compression Agent Checklist

Four lenses for every slide:

| Lens | Question | Kill If... |
|------|----------|------------|
| **Structure** | If I removed this slide, would the deck still work? | Redundant, padding, doesn't advance narrative |
| **Language** | Can this be said in fewer words? | Jargon, filler, passive voice, corporate bloat |
| **Clarity** | Can someone grasp this in 3 seconds? | Convoluted, unclear, sentences doing too much |
| **So What** | Why should the audience care? | Impressive-but-empty, features without benefits |

**Protected Species (do NOT cut):**
- Vivid metaphors that create memorability
- Emotional beats that build connection
- The surprising turn / reveal moment
- Specific details that make abstract concrete
- Creative language that creates atmosphere
- Callbacks and plants that pay off later

---

## Stress Test Panel Quick Reference

| Persona | Question | Use For |
|---------|----------|---------|
| **Engineer** | "How does this actually work?" | Technical proposals, product launches |
| **Skeptic** | "Why should I believe this?" | Any deck with bold claims |
| **Risk Officer** | "What could go wrong?" | Strategy, transformation, investment |
| **CFO** | "What are the numbers?" | Pitches, business cases, ROI claims |
| **Lawyer** | "What's the exposure?" | Policy, compliance, external-facing |
| **Conservative** | "Why change what's working?" | Change management, transformation |
| **COO** | "Would this actually work?" | Execution plans, go-to-market, ops |
