# Framework Selection Reference

Quick-reference tables for selecting the right narrative arc or communication framework based on context.

---

## Master Selection Matrix: By Content Type

| Content Type | Best Arc | Best Framework | Why |
|--------------|----------|----------------|-----|
| Counterintuitive research | Prestige (A) | SUCCESs (Unexpected) | Build to the "turn" that reframes |
| Investigative report | Mystery Box (B) or Columbo (H) | Pyramid (exec summary) | Mystery engages; Pyramid ensures clarity |
| Strategic plan | Heist (C) | Raskin Sales Deck | "Crew" = capabilities; "Vault" = goal |
| Scenario planning | Time Machine (D) | Schwartz Awareness | Future-back requires meeting audience where they are |
| Paradigm shift | Trojan Horse (E) | Cialdini (Commitment) | Small agreements → big reframe |
| Origin story | Hero's Journey (F) | Cinderella shape | Classic transformation + emotional peaks |
| Complex emotional narrative | Freytag (G) | Duarte Resonate | Dramatic structure + oscillation |
| Post-mortem | Columbo (H) | Story Spine | Outcome-first + causal chain |
| Pattern/insight | Game of Scene (I) | Hopkins Specificity | Heightening needs concrete examples |
| Multi-stakeholder | Rashomon (J) | Cialdini (Unity) | Multiple views need shared identity |
| Sales to executives | Heist (C) | Raskin + Pyramid | Goal-obstacles-solution + answer-first |
| Sales to skeptics | Trojan Horse (E) | PAS | Meet them, then reframe |
| Investor pitch | Hero's Journey (F) | Cinderella + AIDA | Origin → setback → triumph + ask |
| Board update | Columbo (H) | Pyramid (strict) | Outcome-first matches exec expectations |
| Keynote | Prestige (A) or Trojan Horse (E) | Duarte S.T.A.R. | Peak + reframe |
| Training | Game of Scene (I) | Cognitive Load | Pattern recognition + chunking |
| Change management | Hero's Journey (F) | Story Circle | Transformation + identity shift |
| Product launch (internal) | Heist (C) | Duarte Resonate | "How we win" energy |
| Product launch (external) | Trojan Horse (E) | Raskin | Reframe market, reveal solution |
| Case study | Columbo (H) or Hero's Journey (F) | Story Spine + Man in Hole | Outcome → how OR transformation |
| Data report | Mystery Box (B) | Pyramid + SUCCESs | Data as clues; headline finding |
| Policy recommendation | Rashomon (J) | SCQA + Pyramid | Multiple views → synthesis |
| Crisis communication | Columbo (H) | PAS | What happened → why → next |
| Vision/inspiration | Time Machine (D) | Duarte Resonate | Future-back + oscillation |

---

## By Audience Type

| Audience | Preferred Arcs | Preferred Frameworks | Avoid |
|----------|---------------|---------------------|-------|
| **C-Suite / Board** | Columbo (H), Heist (C) | Pyramid, SCQA | Long build-ups; Mystery Box |
| **Technical** | Columbo (H), Game of Scene (I) | Evidence-first, Specificity | Emotional arcs; Hero's Journey |
| **Sales / Marketing** | Trojan Horse (E), Prestige (A) | AIDA, Cialdini | Pyramid (too dry) |
| **Investors / VCs** | Hero's Journey (F), Heist (C) | Raskin, Cinderella | Rashomon (too balanced) |
| **General Public** | Prestige (A), Trojan Horse (E) | Duarte, SUCCESs | Pyramid; technical frameworks |
| **Skeptics** | Trojan Horse (E), Rashomon (J) | PAS, Commitment | Direct assault; Hero's Journey |
| **Mixed** | Heist (C), Rashomon (J) | Hub-and-spoke | Single-audience optimization |
| **Academic** | Mystery Box (B), Columbo (H) | Evidence layering | Emotional manipulation |

---

## By Purpose

| Purpose | Best Arc | Best Framework | Slides | Key Principle |
|---------|----------|----------------|--------|---------------|
| **Persuade to act** | Heist (C), Trojan Horse (E) | AIDA, Raskin | 15-25 | Single clear CTA |
| **Inform / educate** | Game of Scene (I), Columbo (H) | Cognitive Load | 25-40 | Chunk + complement |
| **Inspire / motivate** | Hero's Journey (F), Prestige (A) | Duarte, Cinderella | 20-35 | Peak + strong ending |
| **Align / consensus** | Rashomon (J), Heist (C) | Unity, SCQA | 20-30 | Acknowledge all views |
| **Report / update** | Columbo (H) | Pyramid | 10-20 | Answer-first |
| **Defend / justify** | Columbo (H), Rashomon (J) | Evidence + MECE | 15-25 | Anticipate objections |
| **Entertain** | Prestige (A), Game of Scene (I) | SUCCESs, Peak-end | 25-40 | Maximize surprise |

---

## By Tone

| Desired Tone | Best Arc | Framework Overlay | Headline Style |
|--------------|----------|-------------------|----------------|
| **Authoritative** | Columbo (H) | Specificity | Declarative; data-anchored |
| **Provocative** | Prestige (A), Trojan Horse (E) | SUCCESs (Unexpected) | Tension; counterintuitive |
| **Warm / Relatable** | Hero's Journey (F) | Liking, Unity | "We" language; personal |
| **Urgent** | Heist (C), Time Machine (D) | PAS, Scarcity | Active verbs; stakes |
| **Balanced** | Rashomon (J), Columbo (H) | MECE | Neutral; synthesis |
| **Visionary** | Time Machine (D), Hero's Journey (F) | Duarte | Future-tense; possibility |
| **Playful** | Game of Scene (I), Prestige (A) | SUCCESs (Stories) | Unexpected juxtapositions |

---

## Quick Decision Flowchart

```
START: What is your PRIMARY goal?

├── PERSUADE TO ACT
│   ├── Audience skeptical? → Trojan Horse (E) + PAS
│   ├── Audience time-constrained? → Heist (C) + Pyramid
│   └── Audience needs inspiration? → Hero's Journey (F) + AIDA
│
├── INFORM / EDUCATE
│   ├── Complex with surprise? → Mystery Box (B) + Cognitive Load
│   ├── Pattern/insight focus? → Game of Scene (I)
│   └── Straightforward report? → Columbo (H) + Pyramid
│
├── INSPIRE / ALIGN
│   ├── Transformation story? → Hero's Journey (F) + Cinderella
│   ├── Vision/future focus? → Time Machine (D) + Duarte
│   └── Multi-stakeholder? → Rashomon (J) + Unity
│
└── ENTERTAIN / KEYNOTE
    ├── Has genuine surprise? → Prestige (A) + SUCCESs
    ├── Paradigm shift? → Trojan Horse (E) + S.T.A.R.
    └── Pattern illumination? → Game of Scene (I) + Peak-end
```

---

## Hybrid Combinations

When two frameworks fit equally well:

| Hybrid | When to Use | How to Combine |
|--------|-------------|----------------|
| **Pyramid + Prestige** | Exec audience + material has twist | Answer-first, evidence as "Turn" |
| **Heist + Columbo** | Strategy explaining past success | Goal → how crew achieved it |
| **Trojan Horse + Rashomon** | Controversial reframe | Multiple views → reveal missing axis |
| **Time Machine + Heist** | Strategic planning + execution | Future-back → "crew assembly" |
| **Mystery Box + Pyramid** | Research for execs | SCQA mystery hook → Pyramid body |
| **Hero's Journey + Game of Scene** | Case study + pattern insight | Transformation → "name the game" |

---

## The Reveal Question

**Does the material contain a genuine surprise, counterintuitive finding, or reframe?**

| Answer | Framework Direction |
|--------|---------------------|
| **Yes — clear surprise** | Engagement arcs: Prestige, Mystery Box, Trojan Horse |
| **Yes — transformation** | Hero's Journey, Game of Scene |
| **No — straightforward** | Efficiency frameworks: Pyramid, AIDA, Columbo |
| **Uncertain** | Analyze for hidden patterns; often Game of Scene can surface them |

If forcing an engagement arc on material without genuine surprise, the reveal will feel manufactured. Better to use efficiency frameworks that deliver value directly.

---

## Framework vs. Arc: When to Use Which

### Use Narrative Arcs (A-J) When:
- Audience has time and attention
- Material contains genuine surprise or transformation
- Goal is thought leadership or paradigm shift
- Keynote or conference setting
- Building long-term influence over immediate action

### Use Communication Frameworks When:
- Audience is time-constrained
- Material is straightforward information delivery
- Goal is immediate decision or action
- Executive or board setting
- Clarity more important than engagement

### Use Hybrid When:
- Exec audience but material has surprise (Pyramid + Prestige)
- Need to persuade skeptics with data (Trojan Horse + Evidence)
- Multi-stakeholder alignment with action needed (Rashomon + Pyramid)

---

## Cognitive Considerations

Always apply regardless of framework:

| Principle | Application |
|-----------|-------------|
| **Working memory limit** | 3-5 items max per concept |
| **Peak-end rule** | Design one peak; craft strong ending |
| **Primacy effect** | Core thesis in opening |
| **Recency effect** | CTA and summary at close |
| **Dual coding** | Complementary (not redundant) visual + verbal |
| **3-second rule** | Slides are glance media; simplify |

---

## Persuasion Overlay Checklist

Layer onto any framework:

- [ ] **Reciprocity:** Do we give value before asking?
- [ ] **Commitment:** Are there micro-agreements building?
- [ ] **Social Proof:** Are examples relatable to THIS audience?
- [ ] **Authority:** Are credentials and sources clear?
- [ ] **Liking:** Is there common ground and "we" language?
- [ ] **Scarcity:** Is cost of inaction clear?
- [ ] **Unity:** Does this feel like "us" not "us vs. them"?
