<!-- ABOUTME: Narrative Engine framework selection guide for arcs and frameworks. -->
<!-- ABOUTME: Synced from nraford7/Narrative-Engine with ASCII normalization. -->

# Complete Framework Selection Guide
## Your 10 Narrative Arcs + Communication Frameworks Integrated

---

## PART 1: YOUR 10 NARRATIVE ARCS -- WHEN TO USE EACH

Your original document contains sophisticated narrative structures optimized for **surprise, revelation, and reframing**. Here's when each shines:

### Arc-by-Arc Analysis

| Arc | Core Mechanic | Best For | Avoid When |
|-----|---------------|----------|------------|
| **A) The Prestige** | Pledge -> Turn -> Prestige (magic trick structure) | Content with a counterintuitive reveal; debunking conventional wisdom; "everything you thought was wrong" presentations | Audience needs quick answers; no genuine surprise exists in the material |
| **B) Mystery Box** | Open loops -> False trails -> Click | Research findings with unexpected conclusions; investigative reports; "whodunit" style analyses | Time-constrained executives; material lacks genuine mystery |
| **C) The Heist** | Target -> Obstacles -> Crew -> Execution -> Getaway | Strategy presentations; project plans; "how we'll win" pitches; transformation roadmaps | Informational updates; situations where obstacles shouldn't be emphasized |
| **D) Time Machine** | Future-back -> Past-forward -> Fork | Scenario planning; strategic foresight; decision-point presentations; "two futures" framing | Historical analysis; content without genuine future uncertainty |
| **E) Trojan Horse** | Relatable scene -> Escalation -> Reframe -> Demo -> Button | Introducing paradigm shifts; getting skeptics to accept new frameworks; "aha moment" content | Audiences already bought in; technical deep-dives |
| **F) Hero's Journey** | Call -> Threshold -> Trials -> Ordeal -> Return | Origin stories; case studies of transformation; founder narratives; change management | Quick updates; data-heavy reports; skeptical technical audiences |
| **G) Freytag's Five-Act** | Exposition -> Rising -> Climax -> Falling -> Denouement | Complex narratives with clear build; literary/dramatic content; presentations that need emotional catharsis | Fast-paced business contexts; impatient audiences |
| **H) Columbo/Whydunit** | Outcome first -> Methodical rebuild -> Telltale -> Howdunit | Post-mortems; root cause analyses; "here's what happened and why" retrospectives | Forward-looking strategy; audiences who don't know the outcome |
| **I) Game of the Scene** | Base reality -> Unusual thing -> Name the game -> Heighten x3 | Pattern recognition content; "here's the hidden dynamic" reveals; cross-domain insight transfer | Straightforward how-to content; audiences wanting direct answers |
| **J) Rashomon** | Multi-view -> Missing axis -> Synthesis | Controversial topics; multi-stakeholder situations; "both sides" analyses; synthesis presentations | Single-perspective content; topics with clear right answers |

---

### Your Arcs vs. Classic Frameworks -- Key Differences

| Dimension | Your 10 Arcs | Classic Frameworks (Pyramid, AIDA, etc.) |
|-----------|--------------|------------------------------------------|
| **Primary goal** | Engagement through mystery, revelation, reframe | Efficiency, clarity, persuasion |
| **Information flow** | Delayed reveal; strategic withholding | Answer-first or linear progression |
| **Audience posture** | Active puzzle-solving; curiosity-driven | Passive reception; decision-focused |
| **Emotional peak** | Built toward ~55-65% (the reveal) | Varies (end for AIDA, start for Pyramid) |
| **Best for** | Thought leadership, keynotes, complex ideas | Sales, executive updates, training |
| **Risk** | Frustrates time-pressed audiences | Can feel flat or predictable |

**Key insight**: Your arcs are **engagement-optimized** (keeping attention through mystery/revelation), while classic frameworks are **efficiency-optimized** (delivering value quickly). The skill should choose based on context.

---

## PART 2: MASTER SELECTION TABLE -- ALL FRAMEWORKS BY CONTENT TYPE

### By Content/Message Type

| Content Type | Best Narrative Arc | Best Communication Framework | Why This Pairing |
|--------------|-------------------|------------------------------|------------------|
| **Counterintuitive research findings** | The Prestige (A) | SUCCESs (Unexpected + Concrete) | Build to the "turn" that reframes everything |
| **Investigative report / root cause** | Mystery Box (B) or Columbo (H) | Minto Pyramid (for exec summary) | Mystery engages; Pyramid ensures clarity |
| **Strategic plan / transformation roadmap** | The Heist (C) | Raskin Sales Deck | "Assembling the crew" maps to solution features |
| **Scenario planning / decision fork** | Time Machine (D) | Schwartz Awareness Levels | Future-back requires meeting audience where they are |
| **Paradigm shift / new mental model** | Trojan Horse (E) | Cialdini (Commitment/Consistency) | Small agreements -> big reframe |
| **Company/product origin story** | Hero's Journey (F) | Vonnegut Cinderella shape | Classic transformation arc with emotional peaks |
| **Complex narrative with emotional stakes** | Freytag's Five-Act (G) | Duarte Resonate (What is/What could be) | Dramatic structure needs oscillation |
| **Post-mortem / retrospective** | Columbo/Whydunit (H) | Story Spine (Because of that...) | Outcome-first + causal chain = clarity |
| **Pattern recognition / hidden dynamics** | Game of the Scene (I) | Hopkins Specificity | Heightening requires concrete examples |
| **Multi-stakeholder / controversial topic** | Rashomon (J) | Cialdini (Unity) | Multiple views need shared identity frame |
| **Sales pitch to executives** | The Heist (C) | Raskin + Pyramid | Goal-obstacle-solution + answer-first |
| **Sales pitch to skeptics** | Trojan Horse (E) | PAS (Problem-Agitation-Solution) | Meet them in their world, then reframe |
| **Investor pitch / fundraising** | Hero's Journey (F) | Vonnegut Cinderella + AIDA | Origin -> setback -> triumph + clear ask |
| **Board update / executive briefing** | Columbo (H) | Minto Pyramid (strict) | Outcome-first matches exec expectations |
| **Keynote / thought leadership** | The Prestige (A) or Trojan Horse (E) | Duarte S.T.A.R. moment | Needs memorable peak + reframe |
| **Training / educational** | Game of the Scene (I) | Cognitive Load + Dual Coding | Pattern recognition + chunked learning |
| **Change management** | Hero's Journey (F) | Story Circle (audience as hero) | Transformation narrative + identity shift |
| **Product launch (internal)** | The Heist (C) | Duarte Resonate | "Here's how we win" energy |
| **Product launch (external)** | Trojan Horse (E) | Raskin (change-first) | Reframe market, then reveal solution |
| **Case study** | Columbo (H) or Hero's Journey (F) | Story Spine + Man in Hole | Outcome -> how we got there OR transformation |
| **Data/analytics report** | Mystery Box (B) | Pyramid + SUCCESs (Concrete) | Data as clues; headline the finding |
| **Policy recommendation** | Rashomon (J) -> synthesis | SCQA + Pyramid | Multiple views -> integrated recommendation |
| **Crisis communication** | Columbo (H) | PAS (acknowledge agitation) | What happened -> why -> what's next |
| **Vision/inspiration** | Time Machine (D) | Duarte (What could be) | Future-back creates aspiration |

---

### By Audience Type

| Audience | Preferred Arcs | Preferred Frameworks | Avoid |
|----------|---------------|---------------------|-------|
| **C-Suite / Board** | Columbo (H), Heist (C) | Pyramid, SCQA | Long build-ups; Mystery Box; Freytag |
| **Technical / Engineering** | Columbo (H), Game of Scene (I) | Hopkins Specificity, Evidence-first | Emotional arcs; Hero's Journey |
| **Sales / Marketing** | Trojan Horse (E), Prestige (A) | AIDA, Cialdini | Pyramid (too dry); Columbo (no sell) |
| **Investors / VCs** | Hero's Journey (F), Heist (C) | Raskin, Cinderella shape | Rashomon (too balanced); Mystery Box (too slow) |
| **General public / Keynote** | Prestige (A), Trojan Horse (E) | Duarte Resonate, SUCCESs | Pyramid (boring); Technical frameworks |
| **Skeptics / Resisters** | Trojan Horse (E), Rashomon (J) | Cialdini (Commitment), PAS | Direct assault; Hero's Journey (feels like spin) |
| **Mixed / Cross-functional** | Heist (C), Rashomon (J) | Hub-and-spoke, layered depth | Single-audience optimization |
| **Academia / Research** | Mystery Box (B), Columbo (H) | Evidence layering, Citations | Emotional manipulation; Cinderella |

---

### By Presentation Purpose

| Purpose | Best Arc | Best Framework | Slide Count | Key Principle |
|---------|----------|----------------|-------------|---------------|
| **Persuade to act** | Heist (C), Trojan Horse (E) | AIDA, Raskin | 15-25 | End with clear, single CTA |
| **Inform / educate** | Game of Scene (I), Columbo (H) | Cognitive Load, Dual Coding | 25-40 | Chunk information; complement visual/verbal |
| **Inspire / motivate** | Hero's Journey (F), Prestige (A) | Duarte Resonate, Cinderella | 20-35 | Design emotional peaks; strong ending |
| **Align / build consensus** | Rashomon (J), Heist (C) | Unity principle, SCQA | 20-30 | Acknowledge all views; synthesize |
| **Report / update** | Columbo (H) | Pyramid | 10-20 | Answer-first; appendix for depth |
| **Defend / justify** | Columbo (H), Rashomon (J) | Evidence layering, MECE | 15-25 | Methodical rebuild; anticipate objections |
| **Entertain / engage** | Prestige (A), Game of Scene (I) | SUCCESs, Peak-end rule | 25-40 | Maximize surprise; memorable moments |

---

### By Tone/Attitude

| Desired Tone | Best Arc | Framework Overlay | Headline Style |
|--------------|----------|-------------------|----------------|
| **Authoritative / Expert** | Columbo (H), Pyramid structure | Hopkins Specificity | Declarative; data-anchored |
| **Provocative / Challenging** | Prestige (A), Trojan Horse (E) | SUCCESs (Unexpected) | Tension-laden; counterintuitive |
| **Warm / Relatable** | Hero's Journey (F), Story Spine | Cialdini (Liking, Unity) | Personal; "we" language |
| **Urgent / Action-oriented** | Heist (C), Time Machine (D) | PAS, Scarcity principle | Active verbs; stakes-focused |
| **Balanced / Objective** | Rashomon (J), Columbo (H) | MECE, Multi-view | Neutral framing; synthesis |
| **Visionary / Aspirational** | Time Machine (D), Hero's Journey (F) | Duarte (What could be) | Future-tense; possibility language |
| **Playful / Creative** | Game of Scene (I), Prestige (A) | SUCCESs (Stories) | Unexpected juxtapositions |

---

## PART 3: DECISION FLOWCHART

```
START: What is your PRIMARY goal?

+-- PERSUADE TO ACT
|   +-- Audience skeptical? -> Trojan Horse (E) + PAS
|   +-- Audience time-constrained? -> Heist (C) + Pyramid
|   +-- Audience needs inspiration? -> Hero's Journey (F) + AIDA
|
+-- INFORM / EDUCATE
|   +-- Complex with surprise? -> Mystery Box (B) + Cognitive Load
|   +-- Pattern/insight focus? -> Game of Scene (I) + Dual Coding
|   +-- Straightforward report? -> Columbo (H) + Pyramid
|
+-- INSPIRE / ALIGN
|   +-- Transformation story? -> Hero's Journey (F) + Cinderella
|   +-- Vision/future focus? -> Time Machine (D) + Duarte
|   +-- Multi-stakeholder? -> Rashomon (J) + Unity
|
+-- ENTERTAIN / KEYNOTE
    +-- Has genuine surprise? -> Prestige (A) + SUCCESs
    +-- Paradigm shift? -> Trojan Horse (E) + S.T.A.R.
    +-- Pattern illumination? -> Game of Scene (I) + Peak-end
```

---

## PART 4: HYBRID COMBINATIONS -- WHEN TO MIX

Sometimes the best deck borrows beats from multiple structures:

| Hybrid | When to Use | How to Combine |
|--------|-------------|----------------|
| **Pyramid + Prestige** | Exec audience but material has a twist | Lead with answer, but structure evidence as a "Turn" |
| **Heist + Columbo** | Strategy deck explaining past success | Show the "vault" (goal), then rebuild how crew achieved it |
| **Trojan Horse + Rashomon** | Controversial reframe | Present multiple views, then reveal the missing axis that reframes all |
| **Time Machine + Heist** | Strategic planning with execution focus | Future-back vision, then "crew assembly" for how to get there |
| **Mystery Box + Pyramid** | Research for execs | SCQA hook with mystery framing; Pyramid structure for body |
| **Hero's Journey + Game of Scene** | Case study with pattern insight | Transformation narrative, then "name the game" for transferable lesson |

---

## PART 5: QUICK REFERENCE -- THE 5 QUESTIONS TO ASK

The skill should gather these inputs to select the right combination:

1. **WHO is the audience?** (Executive / Technical / General / Mixed / Skeptical)
2. **WHAT are you trying to accomplish?** (Persuade / Inform / Inspire / Align / Entertain)
3. **WHAT is the content type?** (Research / Strategy / Case study / Vision / Update / etc.)
4. **WHAT tone do you want?** (Authoritative / Provocative / Warm / Urgent / Balanced / Visionary)
5. **Does the material have a genuine surprise/reveal?** (Yes -> engagement arcs / No -> efficiency frameworks)

---

## PART 6: FRAMEWORK GLOSSARY

### Your 10 Narrative Arcs (Engagement-Optimized)
- **A) The Prestige** -- Magic trick: setup, turn, reveal
- **B) Mystery Box** -- Clues, red herrings, click
- **C) The Heist** -- Goal, obstacles, crew, execution
- **D) Time Machine** -- Future-back, past-forward, decision fork
- **E) Trojan Horse** -- Relatable entry, escalation, paradigm reframe
- **F) Hero's Journey** -- Call, trials, ordeal, return transformed
- **G) Freytag's Five-Act** -- Exposition, rising, climax, falling, resolution
- **H) Columbo/Whydunit** -- Outcome-first, methodical reconstruction
- **I) Game of the Scene** -- Find the pattern, name it, heighten 3x
- **J) Rashomon** -- Multiple perspectives, missing axis, synthesis

### Communication Frameworks (Efficiency/Persuasion-Optimized)
- **Minto Pyramid** -- Answer-first, MECE supporting points
- **SCQA** -- Situation, Complication, Question, Answer (hook)
- **AIDA** -- Attention, Interest, Desire, Action
- **PAS** -- Problem, Agitation, Solution
- **Raskin Sales Deck** -- Change -> Stakes -> Vision -> Features -> Proof
- **Duarte Resonate** -- What is / What could be oscillation
- **SUCCESs** -- Simple, Unexpected, Concrete, Credible, Emotional, Stories
- **Cialdini 7** -- Reciprocity, Commitment, Social Proof, Authority, Liking, Scarcity, Unity
- **Schwartz Awareness** -- Unaware -> Problem -> Solution -> Product -> Most Aware
- **Story Spine** -- Once upon a time... Because of that... Until finally...
- **Vonnegut Shapes** -- Man in Hole, Cinderella, Creation, Which Way Is Up
- **Story Circle** -- Audience as hero; 8-step transformation
- **Cognitive Load** -- Limit to 3-5 items; reduce extraneous processing
- **Peak-End Rule** -- Memory = peak moments + ending

---

## PART 7: DETAILED FRAMEWORK DESCRIPTIONS

### Communication Frameworks Explained

#### Minto Pyramid Principle
**Structure:** Answer -> Supporting Arguments (MECE) -> Evidence
**Best for:** Executive communication, consulting deliverables, board presentations
**Key rule:** Lead with the "so what" -- busy audiences want conclusions first, reasoning second
**MECE:** Mutually Exclusive (no overlap), Collectively Exhaustive (nothing missing)

#### SCQA (Situation-Complication-Question-Answer)
**Structure:** 
- Situation: Establish common ground (what we all know)
- Complication: Introduce the tension (what changed/what's wrong)
- Question: The question this raises (explicit or implicit)
- Answer: Your recommendation/thesis
**Best for:** Opening hooks, executive summaries, problem-framing
**Example:** "Dell led direct-to-consumer [S]. Asian competitors emerged with lower costs [C]. How can Dell regain advantage? [Q] Double down on services [A]."

#### AIDA (Attention-Interest-Desire-Action)
**Structure:**
- Attention (5%): Hook, pattern interrupt, surprising fact
- Interest (50%): Story, facts, relevance to audience
- Desire (30%): Benefits, social proof, emotional connection
- Action (15%): Clear, single CTA
**Slide ratio for 20 slides:** 1:10:6:3
**Best for:** Sales presentations, marketing pitches, fundraising

#### PAS (Problem-Agitation-Solution)
**Structure:**
- Problem: Name the pain point
- Agitation: Twist the knife -- show consequences of inaction
- Solution: Present the relief
**Best for:** Skeptical audiences, change management, sales to problem-aware prospects
**Key insight:** Most presenters under-invest in Agitation. The emotional weight of consequences drives action.

#### Raskin's Greatest Sales Deck
**Structure:**
1. Name a big, relevant change in the world (NOT your product)
2. Show there will be winners and losers
3. Tease the "Promised Land" (desirable future state)
4. Introduce features as "magic gifts" that help reach Promised Land
5. Present evidence you can deliver
**Best for:** B2B sales, category creation, evangelism pitches
**Key insight:** Never start with your product or "the problem." Start with change.

#### Duarte Resonate
**Structure:** Oscillate between "What Is" (current reality) and "What Could Be" (future vision)
**Key elements:**
- Constant contrast creates tension and release
- S.T.A.R. moment: Something They'll Always Remember (design one)
- End in the "New Bliss" -- transformed future state
**Best for:** Keynotes, vision presentations, inspirational talks
**Research:** Analysis of MLK and Steve Jobs speeches shows constant oscillation, not linear progression

#### SUCCESs (Made to Stick)
**Checklist:**
- **Simple:** Commander's Intent -- what's the ONE thing?
- **Unexpected:** Create curiosity gaps; break patterns
- **Concrete:** Sensory details; "37g saturated fat" -> "bacon-eggs + Big Mac + steak dinner"
- **Credible:** Anti-authority testimonials, Sinatra Tests, testable claims
- **Emotional:** Individual > statistics; identity > generic benefits
- **Stories:** Challenge (inspire action), Connection (foster teamwork), Creativity (spark innovation)
**Best for:** Quality-checking any presentation; ensuring memorability

#### Cialdini's 7 Principles
| Principle | Mechanism | Presentation Application |
|-----------|-----------|-------------------------|
| Reciprocity | Give before asking | Lead with valuable insights, proprietary data |
| Commitment | Small yeses -> big yes | Build micro-agreements through the deck |
| Social Proof | "People like me do this" | Testimonials from relatable peers, logos |
| Authority | Expertise signals | Credentials, data sources, research citations |
| Liking | Similarity, compliments | Common ground, "we" language |
| Scarcity | Loss aversion | Limited time/availability, cost of inaction |
| Unity | Shared identity | "We're in this together," family metaphors |

#### Schwartz Awareness Levels
| Level | Audience State | Open With |
|-------|---------------|-----------|
| Unaware | Don't know they have a problem | Emotion, stories, relatable scenarios |
| Problem Aware | Know the problem, not solutions | Empathetic problem articulation |
| Solution Aware | Know solutions exist, not yours | Why YOUR solution differs |
| Product Aware | Know your product, evaluating | Features, pricing, objection handling |
| Most Aware | Ready to buy | Irresistible offer, easy conversion |

**Key insight:** Messaging that works for Product Aware audiences fails completely for Unaware audiences.

#### Story Spine (Kenn Adams / Pixar)
```
Once upon a time... [Status quo]
Every day... [Routine/baseline]
But one day... [Disruption]
Because of that... [Consequence 1]
Because of that... [Consequence 2]
Because of that... [Consequence 3]
Until finally... [Resolution]
And ever since then... [New normal]
```
**Best for:** Case studies, origin stories, causal explanations
**Business adaptation:** "Once upon a time, businesses struggled with [X]. Every day, they [workaround]. But then we discovered [insight]..."

#### Vonnegut's Story Shapes
| Shape | Arc | Best For |
|-------|-----|----------|
| Man in Hole | Good -> Bad -> Better | Case studies, turnaround stories |
| Cinderella | Low -> Rise -> Fall -> Higher | Startup pitches, fundraising |
| Creation | Chaos -> Order | Platform development, company building |
| Which Way Is Up | Ambiguous -> Clarity | Market uncertainty analysis |

**The Cinderella shape** -- Vonnegut's "million dollar story" -- works especially well for investor pitches.

#### Dan Harmon's Story Circle
| Step | Label | Audience Experience |
|------|-------|---------------------|
| 1 | YOU | "This is my world" -- establish common ground |
| 2 | NEED | "I recognize this problem" -- surface pain |
| 3 | GO | "I'll learn something new" -- introduce solution |
| 4 | SEARCH | "Let me evaluate this" -- walk through how it works |
| 5 | FIND | "This could solve my problem" -- show proof |
| 6 | TAKE | "What's the investment?" -- honest about costs |
| 7 | RETURN | "How would this work for me?" -- implementation |
| 8 | CHANGE | "I'm ready to act" -- call to action |

**Key insight:** Making the audience (not your company) the hero transforms every slide.

#### Cognitive Load Theory
**Core principle:** Working memory holds only 3-5 items. Overload kills learning.
**Three types of load:**
- Intrinsic: Inherent complexity of material
- Extraneous: Poor design adding unnecessary processing
- Germane: Mental effort toward actual learning

**Practical rules:**
- One idea per slide
- 3-second comprehension test (billboard rule)
- Complementary visual/verbal (don't read slides aloud)
- Eliminate decoration that doesn't support understanding

#### Peak-End Rule
**Research:** Kahneman found that experience memory depends on:
1. The emotional peak (highest intensity moment)
2. The ending
NOT the average or duration.

**Practical rules:**
- Design one intentional peak (S.T.A.R. moment)
- Place it in the middle third (not too early)
- Craft a powerful, memorable ending
- Don't let the deck fade out -- end with impact
