# Narrative Arcs Reference

Detailed beat-by-beat structures for all 10 narrative arcs. These are **engagement-optimized** — they use mystery, delayed revelation, and reframing to hold attention.

---

## A) The Prestige

**Source:** Magic trick structure (Pledge → Turn → Prestige)
**Best for:** Counterintuitive findings, debunking conventional wisdom, "everything you thought was wrong"
**Reveal position:** ~60%

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. Pledge | Establish ordinary world; what everyone believes | 2-3 |
| 2. Plant #1 | Subtle clue that will pay off later | 1 |
| 3. Deepening | More evidence supporting conventional view | 3-4 |
| 4. Plant #2 | Second subtle clue | 1 |
| 5. **Turn [REVEAL]** | Contradictory fact that reframes everything | 2-3 |
| 6. Misdirection addressed | Why we missed this before | 2 |
| 7. **Prestige** | The new understanding; what this means | 2-3 |
| 8. Consequences | Implications and applications | 2-3 |
| 9. Limits | Honest caveats and boundaries | 1-2 |
| 10. Action | What to do with this knowledge | 1-2 |
| 11. Callback | Return to opening with new eyes | 1 |

### Example Headlines by Beat

- Pledge: "Most managers believe hybrid work offers the best of both worlds"
- Plant #1: "Productivity metrics show curious variance in Tuesday data"
- Turn: "Fully remote workers outperform hybrid by 23% when we control for meeting load"
- Prestige: "The office isn't where work happens—it's where work gets interrupted"
- Callback: "Hybrid doesn't offer the best of both worlds—it combines the worst"

---

## B) Mystery Box

**Source:** J.J. Abrams storytelling philosophy
**Best for:** Research with unexpected conclusions, investigative reports, "whodunit" analyses
**Reveal position:** ~60%

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. The Riddle | Open with a compelling question or anomaly | 1-2 |
| 2. Clue #1 (True) | First piece of evidence | 2-3 |
| 3. Clue #2 (True) | Second piece of evidence | 2-3 |
| 4. Clue #3 (Decoy) | Red herring that seems to point somewhere | 2-3 |
| 5. Red Herring explored | Follow the false trail | 2-3 |
| 6. Failed Attempt | Why the obvious answer doesn't work | 2 |
| 7. Overlooked Clue | The detail everyone missed | 1-2 |
| 8. **Click [REVEAL]** | Everything snaps into place | 2-3 |
| 9. Re-interpretation | Re-read earlier evidence with new understanding | 2-3 |
| 10. Cross-domain use | How this applies elsewhere | 2 |
| 11. Limits | What we still don't know | 1-2 |
| 12. Takeaways | Actionable conclusions | 1-2 |
| 13. Tag | Final resonant thought | 1 |

### Example Headlines by Beat

- Riddle: "Why do 73% of customers abandon checkout at the payment screen?"
- Clue #1: "Payment processing takes 4.2 seconds—within industry norms"
- Red Herring: "Mobile users abandon at higher rates, suggesting UX issues"
- Click: "The culprit isn't speed or design—it's the moment of price finality"
- Re-interpretation: "Those mobile 'UX issues' were actually price comparison behavior"

---

## C) The Heist

**Source:** Heist film structure
**Best for:** Strategy presentations, transformation roadmaps, "how we'll win" pitches
**Reveal position:** ~75% (execution/payoff)

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. The Vault | What we're trying to achieve (the goal) | 2-3 |
| 2. Stakes | Why this matters; cost of failure | 2-3 |
| 3. Obstacles | What stands in our way | 3-4 |
| 4. Assemble the Crew | Methods, tools, capabilities we'll deploy | 4-6 |
| 5. The Plan | How these pieces fit together | 2-3 |
| 6. Dry Run | Early indicators, pilots, or proof points | 2 |
| 7. Setback | Complication or unexpected challenge | 1-2 |
| 8. Workaround | How we adapt | 1-2 |
| 9. **Execution [REVEAL]** | The actual approach in detail | 3-4 |
| 10. Payoff | Results, wins, outcomes | 2-3 |
| 11. Getaway | How we sustain/protect gains | 1-2 |
| 12. Epilogue Twist | Unexpected upside or next target | 1 |

### Example Headlines by Beat

- Vault: "We need to capture 15% market share in APAC within 18 months"
- Obstacles: "Three incumbents control 80% of distribution channels"
- Assemble Crew: "Our partnerships with Alibaba and JD unlock alternative routes"
- Setback: "Regulatory changes in Q2 blocked our original timeline"
- Payoff: "We reached 12% by month 14—ahead of pace despite setbacks"

---

## D) Time Machine

**Source:** Scenario planning, strategic foresight
**Best for:** Decision-point presentations, "two futures" framing, strategic planning
**Reveal position:** ~55% (the fork)

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. Future Headline | Start with a vivid future state | 1-2 |
| 2. Tiny Past Cause | Trace back to small decision that led there | 2 |
| 3. Side Analogy | Historical parallel or different domain example | 2 |
| 4. Present Decision | The choice point we face now | 2-3 |
| 5. Timeline A | First future if we choose path A | 3-4 |
| 6. Timeline B | Second future if we choose path B | 3-4 |
| 7. **Fork [REVEAL]** | The real nature of the choice becomes clear | 2-3 |
| 8. Levers | What factors we can control | 2-3 |
| 9. Limits | What we can't predict or control | 1-2 |
| 10. Now-cast | Immediate next steps | 2 |
| 11. Rewrite Future Headline | Close with revised/chosen future vision | 1 |

### Example Headlines by Beat

- Future Headline: "2027: The company that bet on AI tutoring owns education"
- Tiny Past Cause: "It started with one product manager's side experiment in 2024"
- Timeline A: "If we build: market leadership but 18-month investment"
- Timeline B: "If we partner: faster to market but dependent on vendor roadmap"
- Fork Reveal: "This isn't build vs. partner—it's own the intelligence vs. rent it"

---

## E) Trojan Horse Insight

**Source:** Improv comedy, paradigm shifts
**Best for:** Introducing new mental models, winning over skeptics, "aha moment" content
**Reveal position:** ~50% (the reframe)

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. Everyday Scene | Start with relatable, familiar situation | 2-3 |
| 2. Escalation #1 | First example showing the pattern | 2 |
| 3. Escalation #2 | Second example, higher stakes | 2 |
| 4. Escalation #3 | Third example, pattern now undeniable | 2 |
| 5. Wrong Frame | Name the assumption everyone's making | 2 |
| 6. **Reframe [REVEAL]** | Introduce the new lens | 2-3 |
| 7. 60-Second Demo | Quick proof the new frame works | 2-3 |
| 8. Social Proof | Others who've adopted this frame | 2 |
| 9. Limits | When this frame doesn't apply | 1-2 |
| 10. Two-Step Playbook | Simple actions to apply the insight | 2 |
| 11. **Button** | Memorable closing that cements the reframe | 1 |
| 12. Optional Arenas | Other domains where this applies | 1-2 |

### Example Headlines by Beat

- Everyday Scene: "Every morning, Sarah checks email before her first meeting"
- Escalation #1: "By 10am, she's responded to 47 messages but completed zero priorities"
- Wrong Frame: "We call this 'being responsive'—a professional virtue"
- Reframe: "Email isn't communication—it's other people's to-do lists for you"
- Button: "The most productive people aren't responsive—they're selectively unreachable"

---

## F) Hero's Journey (for Ideas)

**Source:** Joseph Campbell's monomyth, adapted for business
**Best for:** Origin stories, transformation cases, founder narratives, change management
**Reveal position:** ~65% (the ordeal)

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. Ordinary World | Status quo before the journey | 2 |
| 2. Stakes | What's at risk if nothing changes | 2 |
| 3. The Call | The opportunity or challenge that appeared | 2 |
| 4. Refusal/Skeptics | Initial resistance or doubt | 2 |
| 5. Mentor/New Frame | The insight or guide that changes perspective | 2-3 |
| 6. Crossing Threshold | Commitment to the new path | 1-2 |
| 7. Tests/Evidence A | First challenge and learning | 2 |
| 8. Tests/Evidence B | Second challenge and learning | 2 |
| 9. Tests/Evidence C | Third challenge and learning | 2 |
| 10. Approach | Building toward the decisive moment | 2 |
| 11. **Ordeal [REVEAL]** | The crucial test or transformation | 2-3 |
| 12. Reward/Reframe | What was gained; how understanding changed | 2 |
| 13. Road Back | Integrating the learning | 2 |
| 14. Resurrection | Final test proving transformation is real | 1-2 |
| 15. Return with Elixir | The gift brought back to share | 2 |

### Example Headlines by Beat

- Ordinary World: "In 2019, we were a traditional consulting firm billing by the hour"
- The Call: "A client asked: 'What if you only got paid when we succeeded?'"
- Refusal: "Our CFO calculated we'd lose 40% of revenue in year one"
- Ordeal: "Month 8: our biggest project failed, and we owed the client a refund"
- Return with Elixir: "Today, 70% of our revenue comes from success-based contracts"

---

## G) Freytag's Five-Act

**Source:** Gustav Freytag's dramatic structure
**Best for:** Complex narratives needing emotional catharsis, literary/dramatic content
**Reveal position:** ~60% (the climax)

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. Exposition | Context, characters, setting | 3-4 |
| 2. Inciting Incident | The event that sets everything in motion | 2 |
| 3. Rising Action A | First complication/evidence | 2-3 |
| 4. Rising Action B | Second complication, stakes increase | 2-3 |
| 5. Rising Action C | Third complication, tension peaks | 2-3 |
| 6. **Climax [REVEAL]** | The decisive turning point | 2-3 |
| 7. Falling Action A | First consequence of climax | 2 |
| 8. Falling Action B | Ripple effects spread | 2 |
| 9. Resolution | Synthesis of what happened | 2-3 |
| 10. Dénouement | Playbook, implications, humane close | 2-3 |
| 11. Button | Final resonant image or thought | 1 |

---

## H) Columbo / Whydunit

**Source:** Inverted detective story (outcome known, method revealed)
**Best for:** Post-mortems, root cause analyses, retrospectives
**Reveal position:** ~70% (the howdunit)

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. Cold Open Outcome | State the result upfront | 1-2 |
| 2. Baseline Theory | What most people assume caused it | 2 |
| 3. Mechanism Step 1 | First piece of the reconstruction | 2-3 |
| 4. Mechanism Step 2 | Second piece | 2-3 |
| 5. Mechanism Step 3 | Third piece | 2-3 |
| 6. Red Herrings | Factors that seemed important but weren't | 2 |
| 7. Telltale Detail | The overlooked clue that cracks it | 1-2 |
| 8. **How/Why [REVEAL]** | The actual mechanism explained | 2-3 |
| 9. Re-read Evidence | Earlier facts now make sense | 2 |
| 10. Transfer | How this applies to other situations | 2 |
| 11. Limits | Boundaries of the explanation | 1-2 |
| 12. Playbook | What to do differently | 2 |
| 13. Callback | Return to opening with full understanding | 1 |

### Example Headlines by Beat

- Cold Open: "Our product launch missed revenue targets by 34%"
- Baseline Theory: "Most assumed the marketing spend was insufficient"
- Telltale Detail: "One sales rep's notes mentioned 'customers asked about feature X'"
- How/Why Reveal: "We launched the wrong product—the market wanted integration, not features"

---

## I) Game of the Scene (UCB)

**Source:** Upright Citizens Brigade improv comedy
**Best for:** Pattern recognition, "here's the hidden dynamic," cross-domain insight transfer
**Reveal position:** ~65%

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. Base Reality | Establish the normal situation | 2 |
| 2. Unusual Thing | Something that doesn't fit the pattern | 2 |
| 3. **Name the Game** | Identify the underlying dynamic | 2-3 |
| 4. Heighten #1 (Domain A) | Show the game playing out in first context | 3-4 |
| 5. Heighten #2 (Domain B) | Same game, different context | 3-4 |
| 6. Heighten #3 (Domain C) | Same game, even more unexpected context | 3-4 |
| 7. Twist | Unexpected implication of the game | 2 |
| 8. **Why It Works [REVEAL]** | Deep explanation of the mechanism | 2-3 |
| 9. Anti-Game | When this pattern breaks down | 2 |
| 10. Simple Playbook | How to use this insight | 2 |
| 11. Tag | Memorable close | 1 |

### Example Headlines by Beat

- Base Reality: "Slack was supposed to reduce email"
- Unusual Thing: "But employees report checking Slack more than they ever checked email"
- Name the Game: "Every communication tool eventually becomes an anxiety delivery system"
- Heighten #1: "Email did it in the 2000s; notifications trained us to respond instantly"
- Heighten #2: "Slack did it faster; the green dot made presence a performance"
- Why It Works: "Async tools succeed by making us feel synchronously obligated"

---

## J) Rashomon Perspective Pivot

**Source:** Akira Kurosawa's film structure
**Best for:** Controversial topics, multi-stakeholder situations, synthesis presentations
**Reveal position:** ~70% (the integrative frame)

### Beat Structure

| Beat | Purpose | Slide Count |
|------|---------|-------------|
| 1. The Event/Claim | What happened or what's proposed | 2 |
| 2. View A | First perspective with its evidence | 3-4 |
| 3. View B | Second perspective with its evidence | 3-4 |
| 4. View C (optional) | Third perspective if relevant | 2-3 |
| 5. Cross-Examination | Where the views conflict | 2-3 |
| 6. Missing Dimension | The axis none of them considered | 2 |
| 7. **Integrative Frame [REVEAL]** | New understanding that accommodates all | 2-3 |
| 8. Re-read | How each view looks through new frame | 2-3 |
| 9. Consequences | What this integration implies | 2 |
| 10. Guardrails | When integration goes too far | 1-2 |
| 11. Both/And Playbook | How to act on the synthesis | 2 |
| 12. Callback | Return to opening claim, transformed | 1 |

### Example Headlines by Beat

- Event: "Should we build or buy our data infrastructure?"
- View A: "Engineering says build—we need customization and control"
- View B: "Finance says buy—faster ROI and lower risk"
- View C: "Product says hybrid—core features custom, commodity features purchased"
- Missing Dimension: "No one asked which capabilities are strategic vs. operational"
- Integrative Frame: "Build what differentiates us; buy everything that doesn't"
