#!/bin/bash
# ABOUTME: Simple HTTP server for previewing white papers locally.
# ABOUTME: Binds to 0.0.0.0 for Tailscale access.

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_DIR="$(dirname "$(dirname "$(dirname "$SCRIPT_DIR")")")"

PORT="${1:-8922}"

echo "Serving white papers from: $PROJECT_DIR"
echo "Open: http://localhost:$PORT/papers/"
echo "Press Ctrl+C to stop"
echo ""

cd "$PROJECT_DIR" && python3 -m http.server "$PORT" --bind 0.0.0.0
