# Documentation Progress Tracker

**Project**: [Project Name]
**Started**: [Date]
**Last Updated**: [Date]

## Overall Progress

```
Phase Progress:
[████████░░] Discovery    80%
[██████░░░░] Inventory    60%
[████░░░░░░] Analysis     40%
[██░░░░░░░░] Planning     20%
[░░░░░░░░░░] Execution     0%
[░░░░░░░░░░] Validation    0%
```

## Session Log

### Session [N]: [Date]

**Focus**: [What this session covers]
**Chunk**: [Chunk ID/Name]

**Completed**:
- [x] [Task 1]
- [x] [Task 2]

**In Progress**:
- [ ] [Task 3]

**Blocked**:
- [ ] [Task 4] - Reason: [why blocked]

**Documents Reviewed**:
| Document | Review Cycles | Final Status | Changes Made |
|----------|---------------|--------------|--------------|
| [doc.md] | [N] | ✅ Approved | [N] |

**Changes Logged This Session**:
- CL-XXX: [brief description]
- CL-XXX: [brief description]

**Cascades Triggered**: [N] new | [N] resolved

**Outputs Produced**:
- [file1.md]
- [file2.md]

**Memory Files Updated**:
- [x] change-log.md
- [x] cascade-tracker.md
- [x] terminology-registry.md
- [x] progress-tracker.md

**Carry-Forward Notes**:
- [Key decision or context for next session]
- [Open question needing resolution]
- [Pending cascades to address]

---

### Session [N-1]: [Date]

[Previous session details...]

---

## Chunk Progress

| Chunk | Description | Sources | Status | Notes |
|-------|-------------|---------|--------|-------|
| 1 | Foundation/Overview | SRC-01, SRC-02 | ⬜ Pending | |
| 2 | Core Reference | SRC-03, SRC-04 | ⬜ Pending | |
| 3 | Tutorials | SRC-05 | ⬜ Pending | Depends on Chunk 1 |
| 4 | How-To Guides | Multiple | ⬜ Pending | |
| 5 | Integration | Review all | ⬜ Pending | Final pass |

**Status Key**: ✅ Complete | 🔄 In Progress | ⬜ Pending | 🚫 Blocked

## WBS Item Status

### Priority 1 (Critical)

| WBS ID | Document | Status | Assigned | Notes |
|--------|----------|--------|----------|-------|
| WBS-001 | index.md | ⬜ | | |
| WBS-002 | quickstart.md | ⬜ | | |

### Priority 2 (Important)

| WBS ID | Document | Status | Assigned | Notes |
|--------|----------|--------|----------|-------|
| WBS-003 | installation.md | ⬜ | | |
| WBS-004 | first-project.md | ⬜ | | |

### Priority 3 (Nice to Have)

| WBS ID | Document | Status | Assigned | Notes |
|--------|----------|--------|----------|-------|
| WBS-010 | advanced-topics.md | ⬜ | | |

## Terminology Log

Terms established during processing (carry forward to each session):

| Term | Definition | Source |
|------|------------|--------|
| [Term 1] | [Definition] | [SRC-XX] |
| [Term 2] | [Definition] | [SRC-XX] |

## Decisions Log

| ID | Decision | Rationale | Date |
|----|----------|-----------|------|
| D-01 | [Decision] | [Why] | [Date] |
| D-02 | [Decision] | [Why] | [Date] |

## Open Questions

| ID | Question | Owner | Status | Resolution |
|----|----------|-------|--------|------------|
| Q-01 | [Question] | [Who] | Open | |
| Q-02 | [Question] | [Who] | Resolved | [Answer] |

## Assumptions Log

| ID | Assumption | Validation Approach | Risk if Wrong |
|----|------------|---------------------|---------------|
| A-01 | [Assumption] | [How to verify] | [Impact] |
| A-02 | [Assumption] | [How to verify] | [Impact] |

## Quality Metrics

| Metric | Target | Current | Status |
|--------|--------|---------|--------|
| Documents completed | [N] | [X] | [X/N]% |
| Quadrant coverage | 100% | [X]% | |
| Average quality score | 80/100 | [X]/100 | |
| Broken links | 0 | [X] | |
| Orphan pages | 0 | [X] | |

## Change Tracking Summary

**Total Changes This Project**: [N]
**Changes This Session**: [N]

### Recent Changes
| CL-ID | Document | Type | Cascade Impact |
|-------|----------|------|----------------|
| CL-XXX | [doc.md] | [type] | [None/Low/Med/High] |

### Cascade Status
| Metric | Count |
|--------|-------|
| Pending cascades (Priority 1) | [N] |
| Pending cascades (Priority 2) | [N] |
| Pending cascades (Priority 3) | [N] |
| Resolved this session | [N] |

**Cascade Queue**: See `cascade-tracker.md` for details

## Memory File Status

| File | Last Updated | Entries | Status |
|------|--------------|---------|--------|
| change-log.md | [timestamp] | [N] entries | ✅ Current |
| cascade-tracker.md | [timestamp] | [N] pending | ✅ Current |
| terminology-registry.md | [timestamp] | [N] terms | ✅ Current |
| progress-tracker.md | [timestamp] | - | ✅ Current |
| source-registry.md | [timestamp] | [N] sources | ✅ Current |

**Status Key**: ✅ Current | ⚠️ Needs Update | ❌ Out of Sync

## Next Session Plan

**Date**: [Planned date]
**Focus**: [What to work on]
**Prerequisites**: [What must be ready]

**Goals**:
- [ ] [Goal 1]
- [ ] [Goal 2]

**Pending Work to Address**:
- [ ] [N] pending cascades from cascade-tracker.md
- [ ] [Document in progress]

**Sources to Load**:
- [SRC-XX]: [Name]
- [Carry-forward notes from Session N]

**Memory Files to Load**:
- change-log.md (for context)
- cascade-tracker.md (for pending work)
- terminology-registry.md (for consistency)
- This progress-tracker.md
