# WBS Item: [WBS-XXX]

## Item Information

| Field | Value |
|-------|-------|
| **ID** | WBS-XXX |
| **Document** | [target-path.md] |
| **Diátaxis Quadrant** | [Tutorial / How-To / Reference / Explanation] |
| **Priority** | [1 - Critical / 2 - Important / 3 - Nice to Have] |
| **Estimated Effort** | [Low: 2hr / Medium: 4hr / High: 8hr] |
| **Status** | [Pending / In Progress / Complete / Blocked] |

## Purpose

[One paragraph describing what this document will accomplish and why it's needed]

## Target Audience

- **Primary**: [Role/persona] - Needs [what they need from this doc]
- **Secondary**: [Role/persona] - Needs [what they need from this doc]

## Dependencies

### Depends On (must complete first)

| WBS ID | Document | Reason |
|--------|----------|--------|
| [WBS-YYY] | [document] | [why needed first] |

### Depended On By (blocks these)

| WBS ID | Document | Reason |
|--------|----------|--------|
| [WBS-ZZZ] | [document] | [why this is needed first] |

## Source References

| ID | Source | Sections Used | Token Est. |
|----|--------|---------------|------------|
| [SRC-XX] | [Name] | [Lines/Sections] | ~[N] |
| [SRC-YY] | [Name] | [Lines/Sections] | ~[N] |

**Total Source Tokens**: ~[N]

## Content Requirements

### Required Sections

- [ ] [Section 1 - e.g., "Overview"]
- [ ] [Section 2 - e.g., "Prerequisites"]
- [ ] [Section 3 - e.g., "Steps"]
- [ ] [Section 4 - e.g., "Verification"]

### Required Elements

- [ ] [Element 1 - e.g., "Code example for X"]
- [ ] [Element 2 - e.g., "Diagram showing Y"]
- [ ] [Element 3 - e.g., "Link to reference doc"]

### Quality Criteria

Based on Diátaxis quadrant ([Quadrant]):

[For Tutorials:]
- [ ] Focuses on learning, not task completion
- [ ] Clear start and end points
- [ ] Visible results at each step
- [ ] Minimal explanation
- [ ] Repeatable

[For How-To:]
- [ ] Goal clear in title
- [ ] Assumes basic knowledge
- [ ] Problem-focused
- [ ] Actionable steps
- [ ] Troubleshooting included

[For Reference:]
- [ ] Organized by subject structure
- [ ] Complete and accurate
- [ ] Neutral tone
- [ ] Easy to navigate
- [ ] No tutorials/explanations mixed in

[For Explanation:]
- [ ] Provides context/background
- [ ] Explores "why" questions
- [ ] Multiple perspectives
- [ ] Connects concepts
- [ ] Builds mental model

## Implementation Notes

### Approach

[Describe the approach for creating this document]

### Key Decisions

| Decision | Choice | Rationale |
|----------|--------|-----------|
| [Decision 1] | [Choice] | [Why] |
| [Decision 2] | [Choice] | [Why] |

### Known Challenges

- [Challenge 1 - how to address]
- [Challenge 2 - how to address]

## Cross-References

### Links To (outgoing)

- [document.md]: [reason for link]
- [document2.md]: [reason for link]

### Links From (incoming)

- [document3.md]: [context for link]
- [document4.md]: [context for link]

## Completion Checklist

### Pre-Writing
- [ ] All source references reviewed
- [ ] Dependencies completed
- [ ] Structure outline approved

### Writing
- [ ] Content created
- [ ] Examples tested
- [ ] Cross-references added
- [ ] Quadrant checklist passed

### Post-Writing
- [ ] Spell/grammar check
- [ ] Link validation
- [ ] Source citations verified
- [ ] Status updated in progress tracker

## Notes

[Additional notes, concerns, or context for future reference]

---

## Work Log

| Date | Action | Notes |
|------|--------|-------|
| [Date] | [Created / Updated / Completed] | [Notes] |
