# Kepner-Tregoe Problem Solving and Decision Making

Conduct rigorous KT analysis using the four rational processes.

## Overview

Structured methodology comprising four interconnected processes for systematic problem-solving and decision-making. Emphasizes fact-based analysis over intuition.

## The Four Rational Processes

1. **Situation Appraisal (SA)**: What's going on? (Clarify, separate, prioritize)
2. **Problem Analysis (PA)**: Why did this happen? (IS/IS NOT specification)
3. **Decision Analysis (DA)**: What should we do? (MUSTS/WANTS evaluation)
4. **Potential Problem Analysis (PPA)**: What could go wrong? (Risk anticipation)

## Key Features

- **IS/IS NOT Specification Matrix**: 4-dimension analysis (What, Where, When, Extent)
- **Distinction Analysis**: Identify what's different, changed, peculiar, unique
- **MUSTS/WANTS Decision Criteria**: Weighted alternative evaluation
- **SUI Prioritization**: Seriousness, Urgency, Impact framework

## When to Use

Trigger phrases:
- "Kepner-Tregoe", "KT method"
- "IS/IS NOT", "specification analysis"
- "situation appraisal", "decision analysis"
- "MUSTS and WANTS", "potential problem analysis"
- "weighted decision", "alternative evaluation"

## Directory Structure
```text
kepner-tregoe-analysis/
├── SKILL.md
├── references/
│   ├── is-is-not-guide.md
│   ├── decision-analysis-guide.md
│   ├── quality-rubric.md
│   ├── common-pitfalls.md
│   └── examples.md
├── scripts/
└── assets/
```

## Version History

### v1.0.1
- Add path validation to generate_report.py
- Add Input Handling and Content Security section to SKILL.md

### v1.0.0 (Current)
- Initial release with all four KT processes
- IS/IS NOT specification matrix
- Decision Analysis weighted scoring
- Quality scoring system