# Kepner-Tregoe Quality Rubric

This rubric provides criteria for scoring the quality of a Kepner-Tregoe analysis. Use for self-assessment, peer review, or formal quality gate evaluation.

## Overall Scoring Scale

| Score | Rating | Description |
|-------|--------|-------------|
| 85-100 | Excellent | Rigorous analysis, well-documented, high confidence in conclusions |
| 70-84 | Acceptable | Sound analysis with minor gaps; conclusions supportable |
| 55-69 | Needs Revision | Significant gaps or weaknesses; revise before proceeding |
| <55 | Inadequate | Fundamental flaws; restart or significantly rework |

## Dimension Weights

| Dimension | Weight | Applicable Processes |
|-----------|--------|---------------------|
| Problem Specification | 20% | PA (primary), SA |
| Distinction Quality | 20% | PA |
| Cause-Specification Fit | 20% | PA |
| Decision Criteria Rigor | 15% | DA |
| Risk Analysis Depth | 15% | DA, PPA |
| Documentation Quality | 10% | All |

**Note**: Weight all dimensions for comprehensive KT analysis. For single-process work, re-weight applicable dimensions to 100%.

---

## Dimension 1: Problem Specification (20%)

Evaluates the quality of the deviation statement and IS/IS NOT matrix.

### Level 5 (Excellent) - 100%
- Deviation statement is specific, observable, and measurable
- Object clearly identified (model, type, serial number as applicable)
- Defect precisely described (symptom, not assumed cause)
- All four dimensions (WHAT, WHERE, WHEN, EXTENT) fully populated
- IS column contains factual, verified observations
- IS NOT column contains meaningful comparisons (similar items that could be affected)
- No assumed causes embedded in specification
- Data sources documented

### Level 4 (Good) - 80%
- Deviation statement is specific and observable
- Most dimensions completed with useful data
- IS NOT generally meaningful but some entries could be stronger
- Minor gaps in detail

### Level 3 (Adequate) - 60%
- Deviation statement is clear but could be more specific
- Three dimensions adequately covered
- Some IS NOT entries are weak or missing
- Some assumed causes may be present

### Level 2 (Needs Work) - 40%
- Deviation statement is vague or includes assumed cause
- Two or fewer dimensions adequately covered
- IS NOT column is mostly empty or trivial
- Limited factual basis

### Level 1 (Inadequate) - 20%
- Problem statement missing or completely vague
- IS/IS NOT matrix not attempted or meaningless
- Analysis cannot proceed

---

## Dimension 2: Distinction Quality (20%)

Evaluates the insights generated from IS/IS NOT comparison.

### Level 5 (Excellent) - 100%
- Distinctions identified for every IS/IS NOT pair
- Distinctions are specific, observable, and factual
- Distinctions focus on changes, differences, or unique factors
- Multiple meaningful distinctions generated
- Distinctions directly inform cause generation
- No vague or assumed distinctions

### Level 4 (Good) - 80%
- Most pairs have useful distinctions
- Distinctions are generally specific
- Good connection to cause generation
- Minor gaps or one or two weak distinctions

### Level 3 (Adequate) - 60%
- Distinctions present but some are vague or generic
- At least half of pairs have meaningful distinctions
- Some distinctions not clearly change-oriented
- Cause connection partially established

### Level 2 (Needs Work) - 40%
- Few distinctions identified
- Distinctions are mostly vague ("they're different")
- Limited connection to cause generation
- Change focus absent

### Level 1 (Inadequate) - 20%
- No distinctions identified
- Or distinctions are meaningless/invented

---

## Dimension 3: Cause-Specification Fit (20%)

Evaluates how well the identified cause(s) explain the specification data.

### Level 5 (Excellent) - 100%
- Possible causes generated from distinctions (traceable)
- All possible causes systematically tested against full specification
- Most probable cause explains EVERY IS dimension
- Most probable cause explains EVERY IS NOT dimension
- Verification plan identified and/or executed
- True cause confirmed with evidence

### Level 4 (Good) - 80%
- Causes mostly traceable to distinctions
- Causes tested against most specification elements
- Most probable cause explains most IS and IS NOT elements
- Minor unexplained elements acknowledged
- Verification planned

### Level 3 (Adequate) - 60%
- Some causes from distinctions, some from general brainstorming
- Cause testing incomplete
- Most probable cause explains IS but IS NOT partially addressed
- Verification approach identified

### Level 2 (Needs Work) - 40%
- Causes not traceable to distinctions
- Little or no systematic cause testing
- Cause accepted on intuition rather than specification fit
- Verification not addressed

### Level 1 (Inadequate) - 20%
- Causes assumed without analysis
- No cause testing performed
- Cause does not fit specification

---

## Dimension 4: Decision Criteria Rigor (15%)

Evaluates the quality of MUSTS/WANTS criteria and evaluation process.

### Level 5 (Excellent) - 100%
- Decision statement clear (action and outcome)
- MUSTS are truly mandatory, measurable, pass/fail
- MUSTS don't predetermine outcome (multiple options can pass)
- WANTS are comprehensive (all stakeholder concerns represented)
- WANTS clearly defined with direction (more/less is better)
- Weights assigned before scoring with documented rationale
- Scoring consistent across alternatives with defined anchors
- Calculation verified

### Level 4 (Good) - 80%
- Decision statement clear
- MUSTS appropriate but one may be questionable
- WANTS comprehensive with appropriate weights
- Scoring generally consistent
- Minor issues in weight rationale or scoring

### Level 3 (Adequate) - 60%
- Decision statement present but could be clearer
- Some MUSTS may be disguised WANTS
- WANTS present but may miss some concerns
- Weights assigned but rationale unclear
- Scoring has some inconsistencies

### Level 2 (Needs Work) - 40%
- Decision statement vague
- MUSTS clearly include preferences
- WANTS incomplete or poorly weighted
- Scoring inconsistent or biased
- Weights may have been adjusted post-scoring

### Level 1 (Inadequate) - 20%
- No clear decision statement
- No meaningful criteria structure
- Evaluation subjective and untraceable

---

## Dimension 5: Risk Analysis Depth (15%)

Evaluates adverse consequences assessment (DA) and Potential Problem Analysis (PPA).

### Level 5 (Excellent) - 100%
- Top alternatives (DA) assessed for adverse consequences
- OR Plan steps (PPA) systematically evaluated for risks
- Risks identified are specific and realistic
- Probability and Seriousness rated with rationale
- Preventive actions identified for HIGH/MEDIUM risks
- Contingent actions defined with specific triggers
- Responsibilities assigned

### Level 4 (Good) - 80%
- Risks identified for appropriate scope
- Most risks have P/S ratings
- Preventive/contingent actions for major risks
- Minor gaps in trigger definition or assignment

### Level 3 (Adequate) - 60%
- Risks identified but list may be incomplete
- Ratings present but rationale unclear
- Some preventive actions but coverage incomplete
- Contingencies vague

### Level 2 (Needs Work) - 40%
- Few risks identified
- No systematic rating approach
- Preventive actions missing or generic
- No contingency planning

### Level 1 (Inadequate) - 20%
- Risk assessment not performed
- Or risks identified are trivial/irrelevant

---

## Dimension 6: Documentation Quality (10%)

Evaluates the overall documentation and traceability.

### Level 5 (Excellent) - 100%
- All worksheets/templates completed
- Logic flow is traceable end-to-end
- Data sources documented
- Participants and dates recorded
- Assumptions explicitly stated
- Decisions and rationale captured
- Ready for audit or peer review

### Level 4 (Good) - 80%
- Most documentation complete
- Logic generally traceable
- Minor gaps in source documentation
- Key decisions captured

### Level 3 (Adequate) - 60%
- Basic documentation present
- Some traceability gaps
- Assumptions not all explicit
- Could not fully reproduce analysis from documentation alone

### Level 2 (Needs Work) - 40%
- Minimal documentation
- Conclusions stated without supporting evidence
- Cannot trace how conclusions reached

### Level 1 (Inadequate) - 20%
- No meaningful documentation
- Analysis cannot be understood or reviewed

---

## Calculating the Score

1. **Rate each applicable dimension** (1-5 scale → convert to percentage)
2. **Apply weights** to each dimension rating
3. **Sum weighted scores** for overall score

**Example Calculation:**

| Dimension | Weight | Rating | Score | Weighted |
|-----------|--------|--------|-------|----------|
| Problem Specification | 20% | 4 (Good) | 80% | 16.0 |
| Distinction Quality | 20% | 5 (Excellent) | 100% | 20.0 |
| Cause-Specification Fit | 20% | 3 (Adequate) | 60% | 12.0 |
| Decision Criteria Rigor | 15% | 4 (Good) | 80% | 12.0 |
| Risk Analysis Depth | 15% | 3 (Adequate) | 60% | 9.0 |
| Documentation Quality | 10% | 4 (Good) | 80% | 8.0 |
| **TOTAL** | 100% | | | **77.0** |

**Interpretation**: Score of 77 → Acceptable (70-84 range)

---

## Improvement Recommendations by Score Range

### 85-100 (Excellent)
- Document as best practice example
- Share methodology with others
- Minor refinements only

### 70-84 (Acceptable)
- Review any dimensions scored below 4
- Address minor gaps identified
- Proceed with appropriate confidence

### 55-69 (Needs Revision)
- Identify dimensions scored below 3
- Address significant gaps before proceeding
- Consider additional data gathering
- May need subject matter expert input

### <55 (Inadequate)
- Do not proceed based on this analysis
- Restart with proper methodology
- Consider training/coaching on KT process
- Identify root cause of analysis failure
