# 8D Quality Rubric

## Overview

This rubric provides objective scoring criteria for evaluating 8D investigation quality. Each dimension is rated 1-5, weighted, and combined for an overall quality score.

## Scoring Dimensions

### 1. Problem Definition Quality (Weight: 15%)

**5 - Excellent**
- Complete 5W2H with all fields populated from verified data
- IS/IS NOT analysis completed with meaningful distinctions
- Problem statement is specific, measurable, time-bounded
- No embedded cause or solution
- Extent quantified with population and percentage

**4 - Good**
- Most 5W2H fields populated
- IS/IS NOT analysis done with some distinctions
- Problem statement mostly specific
- Minor vagueness in one dimension
- Extent partially quantified

**3 - Adequate**
- Basic problem description present
- Some 5W2H elements missing or vague
- Limited IS/IS NOT analysis
- Problem statement understandable but not precise
- Extent estimated but not exact

**2 - Marginal**
- Vague problem description
- Multiple 5W2H elements missing
- No IS/IS NOT analysis
- Problem statement contains embedded cause or solution
- Extent unknown or not documented

**1 - Inadequate**
- No clear problem definition
- Description is just a complaint or symptom
- Multiple problems combined
- Cannot determine what is actually being investigated
- No scope boundaries

### 2. Team Composition (Weight: 10%)

**5 - Excellent**
- Cross-functional representation from all relevant functions
- Implementation owners included on team
- Champion actively engaged with appropriate authority
- Facilitator trained in RCA methodology
- All knowledge holders available

**4 - Good**
- Most relevant functions represented
- Implementation owner identified
- Champion assigned and responsive
- Facilitator designated
- Key SMEs available

**3 - Adequate**
- Basic cross-functional representation
- Some functions missing but gaps acknowledged
- Champion assigned
- Facilitator role filled
- Some SMEs consulted ad-hoc

**2 - Marginal**
- Limited representation (1-2 functions only)
- No implementation owner
- Champion uninvolved
- No facilitator or untrained facilitator
- Key SMEs not consulted

**1 - Inadequate**
- Single person investigation
- No cross-functional input
- No management support
- No structure to team effort
- Critical knowledge holders excluded

### 3. Containment Effectiveness (Weight: 10%)

**5 - Excellent**
- Containment actions implemented within 24-48 hours
- All inventory states considered (WIP, FG, shipped, field)
- Containment verified with documented results
- Customer protection confirmed
- Clear plan for containment removal

**4 - Good**
- Containment actions implemented promptly
- Most inventory states addressed
- Verification performed
- Customer largely protected
- Removal criteria defined

**3 - Adequate**
- Containment actions defined
- Primary inventory states addressed
- Some verification
- Basic customer protection
- Removal planned

**2 - Marginal**
- Containment delayed
- Limited scope (only current production)
- No verification
- Customer may still receive defective product
- No removal plan

**1 - Inadequate**
- No containment actions
- Customer not protected
- Problem continues to escape
- No awareness of inventory at risk
- Containment not considered

### 4. Root Cause Analysis Depth (Weight: 25%)

**5 - Excellent**
- Reached systemic/process level root cause
- Verification tests all passed
- Evidence documented for each causal link
- Appropriate tools used for problem type
- Multiple potential causes explored before converging

**4 - Good**
- Root cause at process level
- Most verification tests passed
- Good evidence basis
- Appropriate tool selection
- Key alternative causes considered

**3 - Adequate**
- Root cause identified
- Some process element
- Partial verification
- Basic tool usage
- Limited alternative exploration

**2 - Marginal**
- Cause identified but superficial
- Stopped at symptom level
- Limited or no verification
- Tool not appropriate or poorly applied
- Single-track thinking

**1 - Inadequate**
- No real root cause identified
- Person-blame or external attribution
- No verification
- No structured analysis
- Jumped to conclusions

### 5. Corrective Action Quality (Weight: 20%)

**5 - Excellent**
- All actions are SMART (Specific, Measurable, Assignable, Realistic, Time-bound)
- Actions directly address verified root cause
- Both prevention and detection controls improved
- Resource requirements identified
- Implementation risks considered

**4 - Good**
- Most actions are SMART
- Actions address root cause
- Prevention and/or detection improved
- Owners and dates assigned
- Implementation feasible

**3 - Adequate**
- Actions defined but some vague
- Actions relate to root cause
- Some improvement to controls
- Partial ownership
- General timeline

**2 - Marginal**
- Vague actions ("improve training")
- Actions may not address root cause
- No clear improvement mechanism
- Ownership unclear
- No timeline

**1 - Inadequate**
- No corrective actions
- Actions address symptoms only
- Actions are not implementable
- No ownership or accountability
- No relationship to root cause

### 6. Prevention & Systemic Improvement (Weight: 10%)

**5 - Excellent**
- Horizontal deployment plan with all similar products/processes
- FMEA/Control Plan updated
- Procedures/specifications revised
- Training materials updated
- Lessons learned captured and shared

**4 - Good**
- Horizontal deployment considered
- Key documents updated
- Training addressed
- Lessons captured
- Most systemic gaps addressed

**3 - Adequate**
- Some horizontal consideration
- Primary documents updated
- Basic lesson captured
- Limited systemic reach
- Focused on immediate scope

**2 - Marginal**
- No horizontal deployment
- Documents not updated
- No lesson captured
- Single product/process only
- Prevention not considered

**1 - Inadequate**
- No prevention actions
- No systemic changes
- No documentation updates
- No learning captured
- Problem likely to recur elsewhere

### 7. Verification & Closure (Weight: 10%)

**5 - Excellent**
- Verification period defined with statistical rationale
- Metrics match problem definition
- Data collected and analyzed
- Effectiveness confirmed with evidence
- Champion-approved closure with all criteria met

**4 - Good**
- Verification period defined
- Metrics tracked
- Data shows improvement
- Evidence-based closure
- Champion approval obtained

**3 - Adequate**
- Some verification performed
- Basic metrics
- Improvement indicated
- Reasonable closure justification
- Management acknowledgment

**2 - Marginal**
- Minimal verification
- No metrics defined
- Improvement assumed
- Premature closure
- No approval process

**1 - Inadequate**
- No verification
- Closed immediately after action
- No evidence of effectiveness
- Problem may have recurred
- No closure criteria

## Scoring Calculation

### Individual Dimension Score
Each dimension rated 1-5 based on criteria above.

### Overall Score Calculation
```
Overall Score = Σ(Dimension Score × Weight) × 20
```

### Example Calculation

| Dimension | Score | Weight | Weighted |
|-----------|-------|--------|----------|
| Problem Definition | 4 | 0.15 | 0.60 |
| Team Composition | 4 | 0.10 | 0.40 |
| Containment | 5 | 0.10 | 0.50 |
| Root Cause Depth | 4 | 0.25 | 1.00 |
| Corrective Actions | 3 | 0.20 | 0.60 |
| Prevention | 4 | 0.10 | 0.40 |
| Verification | 4 | 0.10 | 0.40 |
| **Total** | | | **3.90** |

Overall Score = 3.90 × 20 = **78 points**

### Score Interpretation

| Score Range | Rating | Meaning |
|-------------|--------|---------|
| 90-100 | Excellent | Industry-leading 8D; benchmark quality |
| 80-89 | Good | Solid investigation; effective corrective action |
| 70-79 | Acceptable | Meets minimum standards; some improvement opportunities |
| 60-69 | Marginal | Significant gaps; risk of recurrence |
| Below 60 | Inadequate | Major rework required; high recurrence risk |

## Critical Failures

Regardless of overall score, the following conditions trigger immediate remediation:

1. **No verified root cause** (Dimension 4 score = 1 or 2)
2. **Customer not protected** (Dimension 3 score = 1)
3. **No corrective actions** (Dimension 5 score = 1)
4. **Person-blame as root cause** (Automatic Dimension 4 cap at 2)

## Quality Gates

Use this rubric at key 8D milestones:

| Milestone | Minimum Requirement |
|-----------|---------------------|
| After D2 | Problem Definition score ≥ 4 |
| After D4 | Root Cause Depth score ≥ 3 |
| Before D8 | All dimensions ≥ 3; Overall score ≥ 70 |
| At closure | Champion approval with evidence |

## Audit Frequency

| 8D Type | Scoring Frequency |
|---------|-------------------|
| Customer complaint | 100% scored |
| Safety-related | 100% scored |
| Internal quality | Sample (20%) scored |
| Supplier corrective action | Sample (20%) scored |

## Scoring Notes

1. **Weighted priorities**: Root Cause Depth and Corrective Action Quality have highest weights because they most directly impact effectiveness.

2. **Evidence requirement**: For scores of 4 or 5, documented evidence must support the rating.

3. **External review**: For customer or safety-related 8Ds, consider independent scoring by someone not on the team.

4. **Continuous improvement**: Track average scores over time to measure organizational RCA capability maturity.
