# Team Formation Reference Guide

Detailed guidance for RCCA team composition based on problem domain and complexity.

## Core Principles

### Natural Team vs. Qualified Team

**Natural Team**: People directly connected to the problem
- Who owns the problem?
- Who has a stake in the outcome?
- Who knows the process (data and experience)?
- Who will implement and live with the corrective action?

**Qualified Team**: People with specialized expertise
- Subject Matter Experts (SMEs)
- Technical specialists
- Advisors and consultants
- Management sponsors

### Team Size Guidelines

| Complexity | Size | Rationale |
|------------|------|-----------|
| Simple | 3-4 | Quick coordination, focused |
| Moderate | 4-6 | Balance of perspectives |
| Complex | 6-8 | Comprehensive coverage |
| Critical | 6-10 | Regulatory compliance |

**Key Principle**: Scale team size to problem complexity. Cost of resources should be less than benefit of successful outcome.

---

## Role Definitions

### Team Leader
- Coordinates overall RCCA effort
- Manages schedule and logistics
- Ensures timely completion
- Communicates status

**Selection**: Organizational authority, project management skills, time availability

### Facilitator
- Leads analysis methodology
- Guides team through RCA tools
- Documents findings
- Prevents groupthink

**Selection**: Formal RCA training, methodology experience, neutral perspective

### Champion/Sponsor
- Provides management support
- Secures resources
- Removes barriers
- Approves solutions

**Selection**: Management authority, budget control, organizational influence

### Subject Matter Experts
- Provide technical expertise
- Validate findings
- Propose solutions

**Selection**: Deep knowledge in relevant technical areas

---

## Domain-Specific Recommendations

### Manufacturing/Production
**Core**: Production Supervisor, Quality Engineer, Process Engineer, Operator
**Extended**: Design Engineer, Maintenance Tech, Materials Engineer
**Size**: 4-6

### Field Failure/Customer Complaint
**Core**: Customer Service, Field Engineer, Product Engineer, Quality Engineer
**Extended**: Design Engineer, Reliability Engineer, Manufacturing Engineer
**Size**: 5-7

### Equipment/Machine Failure
**Core**: Maintenance Tech, Production Supervisor, Operator, Planner
**Extended**: OEM Rep, Reliability Engineer, Specialist (electrical/mechanical)
**Size**: 4-6

### Software/IT System Failure
**Core**: System Admin/DevOps, Developer, User/Customer, IT Lead
**Extended**: DBA, Network Engineer, Security Specialist
**Size**: 4-6

### Safety Incident
**Core**: EHS Manager, Area Supervisor, Employee(s), First Responder
**Extended**: Process Engineer, Maintenance, Medical Rep, Union Rep
**Size**: 6-8 (regulatory requirements may dictate)

### Supply Chain/Supplier Issue
**Core**: SQE, Procurement, Incoming Inspection, Production Rep
**Extended**: Supplier's Quality Rep, Design Engineer, Logistics
**Size**: 4-6 (may expand for joint investigation)

---

## Common Pitfalls

1. **Quality-only team**: Ensure cross-functional representation
2. **Selection by availability**: Select for ability to contribute
3. **Missing implementation owners**: Include those who will live with the fix
4. **Team too large**: Use core team + advisors model
5. **Blame culture**: Establish no-blame ground rules explicitly

---

## Ground Rules

Establish at kickoff:
1. No blame - focus on process improvement
2. All perspectives valid
3. Fact-based analysis
4. Confidentiality maintained
5. Respect all contributions
6. Active participation expected
7. Meet deadlines
