# Reference Documentation

This directory contains links to reference documentation for the HPK Parser skill.

## HPK Documentation

**HPK ADT Message Specification** (Internal)  
Location: `../../docs/hpk-adt-message.md`  
Description: Complete HPK message format specification including field definitions, message types (ID, MV, CV), modes (C, M, D), and business rules.

**HPK GEF Specification** (Internal)  
Location: `../../docs/specification-hpk-gef.md`  
Description: HPK GEF (Gestion des Événements de Flux) specification detailing workflow integration, event handling, and system architecture.

## Related Standards

While HPK is a proprietary format, understanding related healthcare messaging standards provides useful context:

**IHE Patient Administration Management (PAM) 2.10** (French)  
URL: https://github.com/Interop-Sante/ihe.iti.pam.fr  
Description: Official French IHE PAM specification - HPK messages are often mapped to HL7 IHE PAM format for interoperability.

**HL7 Version 2.5 Standard**  
URL: http://www.hl7.eu/HL7v2x/v25/std25/ch02.html  
Description: International HL7 v2.5 specification covering message structure, segments, and data types.

**IHE Patient Administration Management Profile** (International)  
URL: https://profiles.ihe.net/ITI/TF/Volume1/ch-14.html  
Description: International IHE PAM profile specification (English version).

## Internal Documentation

- [HPK ADT Message Specification](../../docs/hpk-adt-message.md)
- [HPK GEF Specification](../../docs/specification-hpk-gef.md)
- [HPK Parser User Guide](../../docs/hpk-parser.md)

## Quick Links

| Resource | Type | URL/Path |
|----------|------|----------|
| HPK ADT Spec | Internal | ../../docs/hpk-adt-message.md |
| HPK GEF Spec | Internal | ../../docs/specification-hpk-gef.md |
| User Guide | Internal | ../../docs/hpk-parser.md |
| IHE PAM 2.10 (FR) | External | https://github.com/Interop-Sante/ihe.iti.pam.fr |
| HL7 v2.5 Spec | External | http://www.hl7.eu/HL7v2x/v25/std25/ch02.html |

## Notes

- HPK is a proprietary healthcare message format used in French healthcare systems
- For complete field definitions and structures, see the HPK ADT Message Specification
- Related standards (HL7/IHE PAM) are provided for context on healthcare interoperability
