# [Feature/Task Name] Implementation Plan

## Overview
[Brief description of what we're implementing and why]

## Current State Analysis
[What exists now, what's missing, key constraints]

## Desired End State
[Specification of the desired end state and how to verify it]

### Key Discoveries:
- [Important finding with file:line reference]

## Quick Verification Reference

Common commands to verify the implementation:
- [Primary test command, e.g., `make test` or `npm test`]
- [Linting command, e.g., `make lint` or `npm run lint`]
- [Build command if applicable]

Key files to check:
- [Primary implementation file with path]
- [Test file(s) covering this feature]
- [Config files that may need updates]

## What We're NOT Doing
[Explicitly list out-of-scope items]

## Implementation Approach
[High-level strategy and reasoning]

---

## Phase 1: [Descriptive Name]

### Overview
[What this phase accomplishes]

### Changes Required:

#### 1. [Component/File Group]
**File**: `path/to/file.ext`
**Changes**: [Summary of changes]

### Success Criteria:

#### Automated Verification:
- [ ] Tests pass: `make test`
- [ ] Linting passes: `make lint`
- [ ] [Other automated check]: `command here`

#### Manual Verification:
- [ ] [Human testing step - e.g., "Feature X works as expected"]
- [ ] [Another manual check - e.g., "No regressions in Y"]

**Implementation Note**: After completing this phase, pause for manual confirmation. If commit-per-phase was requested, create commit after verification passes.

---

## Phase 2: [Descriptive Name]

### Overview
[What this phase accomplishes]

### Changes Required:

#### 1. [Component/File Group]
**File**: `path/to/file.ext`
**Changes**: [Summary of changes]

### Success Criteria:

#### Automated Verification:
- [ ] Tests pass: `make test`
- [ ] Linting passes: `make lint`

#### Manual Verification:
- [ ] [Human testing step]
- [ ] [Another manual check]

**Implementation Note**: After completing this phase, pause for manual confirmation. If commit-per-phase was requested, create commit after verification passes.

---

## Testing Strategy
[Unit tests, integration tests, manual testing steps]

## References
- Related research: `thoughts/<username|shared>/research/[relevant].md`
