# Sections (Angular 12-16)

This file defines all sections for Angular 12-16 with NgModule-based architecture and RxJS-centric state management.

---

## 1. Change Detection (change)

**Impact:** CRITICAL
**Description:** Change detection optimization with OnPush, NgZone, and RxJS-based reactive state management.

## 2. Bundle & Lazy Loading (bundle)

**Impact:** CRITICAL
**Description:** NgModule-based lazy loading and preload strategies to reduce initial bundle size.

## 3. RxJS Optimization (rxjs)

**Impact:** HIGH
**Description:** Proper RxJS patterns with async pipe, Subject-based cleanup, and efficient operators.

## 4. Template Performance (template)

**Impact:** HIGH
**Description:** Optimizing templates with *ngFor trackBy, pure pipes, and NgOptimizedImage (v15+).

## 5. Dependency Injection (di)

**Impact:** MEDIUM-HIGH
**Description:** Proper DI with providedIn, InjectionToken, and factory providers.

## 6. HTTP & Caching (http)

**Impact:** MEDIUM
**Description:** Class-based interceptors, TransferState for SSR, and caching strategies.

## 7. Forms Optimization (forms)

**Impact:** MEDIUM
**Description:** Reactive forms with typed controls (v14+) for better maintainability.

## 8. General Performance (perf)

**Impact:** LOW-MEDIUM
**Description:** Web Workers and additional optimization patterns.
