# GDPR Key Articles Reference

## Article 5: Principles of Personal Data Processing

### Article 5(1): Six Core Principles

Personal data must be:

1. **Lawfulness, fairness and transparency** - Processed lawfully, fairly and transparently in relation to the data subject
2. **Purpose limitation** - Collected for specified, explicit and legitimate purposes and not further processed in a manner incompatible with those purposes
3. **Data minimization** - Adequate, relevant and limited to what is necessary in relation to the purposes for which they are processed
4. **Accuracy** - Accurate and, where necessary, kept up to date; every reasonable step must be taken to ensure inaccurate data is erased or rectified without delay
5. **Storage limitation** - Kept in a form which permits identification of data subjects for no longer than is necessary for the purposes for which the personal data are processed
6. **Integrity and confidentiality** - Processed in a manner that ensures appropriate security of the personal data, including protection against unauthorised or unlawful processing and against accidental loss, destruction or damage, using appropriate technical or organisational measures

### Article 5(2): Accountability Principle

The controller shall be responsible for, and be able to demonstrate compliance with, the principles in Article 5(1) ('accountability').

## Article 6: Lawful Basis for Processing

At least one of these must apply:

1. **Consent** - Data subject has given clear consent
2. **Contract** - Processing necessary for contract performance
3. **Legal obligation** - Processing necessary to comply with legal obligation
4. **Vital interests** - Processing necessary to protect vital interests
5. **Public task** - Processing necessary for public interest or official authority
6. **Legitimate interests** - Processing necessary for legitimate interests (balancing test required)

## Article 7: Conditions for Consent

- Must be freely given, specific, informed and unambiguous
- Request must be clearly distinguishable and in plain language
- Easy to withdraw consent as it was to give
- Cannot be bundled with other terms
- Must keep proof of consent

## Article 9: Special Categories of Personal Data

Explicit consent or specific legal basis required for:

- Racial or ethnic origin
- Political opinions
- Religious or philosophical beliefs
- Trade union membership
- Genetic data
- Biometric data (for unique identification)
- Health data
- Sex life or sexual orientation

## Article 12: Transparent Information and Communication

- Concise, transparent, intelligible and easily accessible
- Clear and plain language
- Free of charge (unless requests manifestly unfounded or excessive)
- Within one month (extendable by two months if complex)

## Article 13-14: Information to be Provided

When collecting data, provide:

- Identity and contact details of controller
- Contact details of DPO (if applicable)
- Purposes and legal basis of processing
- Legitimate interests (if applicable)
- Recipients or categories of recipients
- Intention to transfer data internationally
- Retention period
- Rights (access, rectification, erasure, restriction, portability, objection)
- Right to withdraw consent
- Right to lodge complaint with supervisory authority
- Whether data provision is statutory/contractual requirement
- Existence of automated decision-making including profiling

## Article 15: Right of Access

Data subjects have the right to:

- Confirmation of whether data is being processed
- Access to personal data
- Information about processing (purposes, categories, recipients, retention, rights, etc.)
- Copy of data undergoing processing (first copy free)

## Article 16: Right to Rectification

Data subjects can request correction of inaccurate personal data and completion of incomplete data.

## Article 17: Right to Erasure ("Right to be Forgotten")

Data subjects can request deletion when:

- Data no longer necessary for original purpose
- Consent withdrawn and no other legal basis exists
- Data subject objects and no overriding legitimate grounds
- Data processed unlawfully
- Legal obligation requires deletion
- Data collected in relation to information society services (children)

Exceptions apply for legal obligations, public interest, legal claims, etc.

## Article 18: Right to Restriction of Processing

Data subjects can request restriction when:

- Accuracy of data is contested
- Processing is unlawful but deletion not wanted
- Data no longer needed but subject needs it for legal claims
- Objection raised pending verification of legitimate grounds

## Article 20: Right to Data Portability

Data subjects can:

- Receive personal data in structured, commonly used, machine-readable format
- Transmit data to another controller
- Have data transmitted directly between controllers (where technically feasible)

Applies when:
- Processing based on consent or contract
- Processing carried out by automated means

## Article 21: Right to Object

Data subjects can object to:

- Processing based on legitimate interests or public interest
- Direct marketing (absolute right)
- Scientific/historical research or statistical purposes

## Article 25: Data Protection by Design and by Default

- Implement appropriate technical and organizational measures
- Only process data necessary for each specific purpose
- Built-in privacy protection throughout data lifecycle
- Default settings must be privacy-protective

## Article 30: Records of Processing Activities

Controllers must maintain records including:

- Name and contact details of controller/DPO
- Purposes of processing
- Categories of data subjects and personal data
- Categories of recipients
- International transfers and safeguards
- Retention periods
- Security measures description

## Article 32: Security of Processing

Implement appropriate technical and organizational measures:

- Pseudonymization and encryption
- Confidentiality, integrity, availability and resilience
- Regular testing and evaluation of effectiveness
- Ability to restore availability after incident

Consider:
- State of the art
- Implementation costs
- Nature, scope, context and purposes of processing
- Risk to rights and freedoms

## Article 33-34: Data Breach Notification

**To Supervisory Authority (Article 33):**
- Within 72 hours of becoming aware
- Describe nature, categories, approximate numbers
- Contact details of DPO
- Likely consequences
- Measures taken or proposed

**To Data Subjects (Article 34):**
- Required when high risk to rights and freedoms
- Clear and plain language
- Same information as authority notification
- Not required if encrypted, subsequent measures taken, or disproportionate effort

## Article 35: Data Protection Impact Assessment (DPIA)

Required when processing likely to result in high risk, particularly:

- Systematic evaluation or scoring
- Large-scale processing of special categories
- Systematic monitoring of public areas at large scale

Must contain:
- Description of processing and purposes
- Necessity and proportionality assessment
- Risk assessment
- Mitigation measures

## Article 37: Data Protection Officer (DPO)

Required when:

- Public authority (except courts acting in judicial capacity)
- Core activities require regular and systematic monitoring at large scale
- Core activities involve large-scale processing of special categories or criminal data

## Article 44-50: International Data Transfers

Transfer to third countries only when:

- Adequacy decision exists (Article 45)
- Appropriate safeguards in place (Article 46): Standard Contractual Clauses, Binding Corporate Rules, approved codes of conduct, certification mechanisms
- Derogations apply (Article 49): Explicit consent, contract performance, important public interest, legal claims, vital interests

## Article 82: Liability and Right to Compensation

- Data subjects can receive compensation for material or non-material damage
- Controllers and processors liable for damages caused by non-compliance
- Can avoid liability by proving not responsible for damage event
