# Personal Data Categories

## What is Personal Data?

Personal data is any information relating to an identified or identifiable natural person ("data subject"). An identifiable person is one who can be identified, directly or indirectly.

## Identifiers

### Direct Identifiers
- **Name** - First name, last name, full name, maiden name
- **Identification numbers** - National ID, passport number, driver's license, SSN
- **Account numbers** - Customer ID, user ID, account number
- **Email address** - Personal or work email
- **Phone number** - Mobile, landline, fax

### Indirect Identifiers
- **IP address** - Can identify individual, especially static IPs
- **Cookie identifiers** - Tracking cookies, device IDs
- **Location data** - GPS coordinates, address, city
- **Device identifiers** - MAC address, IMEI, advertising ID
- **Biometric data** - Fingerprints, facial recognition, iris scans (when used for identification)

## Contact Information

- **Physical address** - Street, city, state, postal code, country
- **Email address** - Personal or work email
- **Phone numbers** - All types
- **Social media handles** - Usernames on social platforms
- **Messaging IDs** - WhatsApp, Telegram, Signal usernames

## Demographic Information

- **Date of birth** - Full date or year only
- **Age** - Exact age or age range
- **Gender** - Gender identity
- **Nationality** - Country of citizenship
- **Marital status** - Single, married, divorced, etc.
- **Language** - Spoken or preferred language
- **Education level** - Highest degree obtained
- **Occupation** - Job title, profession

## Financial Information

- **Bank account details** - Account numbers, IBAN, SWIFT
- **Credit/debit card information** - Card number, CVV, expiry date
- **Payment information** - Payment history, transaction details
- **Income data** - Salary, revenue, financial statements
- **Credit score** - Creditworthiness information
- **Tax information** - Tax ID, tax returns
- **Investment information** - Portfolio details, trading history

## Online Identifiers

- **IP addresses** - IPv4, IPv6
- **Cookie IDs** - Session cookies, tracking cookies
- **Device fingerprints** - Browser fingerprint, device signature
- **Session IDs** - Authentication tokens, session identifiers
- **User agent strings** - Browser and OS information
- **Advertising IDs** - IDFA (iOS), AAID (Android)

## Behavioral Data

- **Browsing history** - Websites visited, pages viewed
- **Search history** - Search queries, search patterns
- **Purchase history** - Items bought, transaction history
- **Usage patterns** - App usage, feature utilization
- **Preferences** - Product preferences, content preferences
- **Interactions** - Clicks, likes, shares, comments

## Employment Information

- **Job title** - Current or past positions
- **Employer** - Company name, employer details
- **Work history** - Employment timeline, previous employers
- **Salary information** - Current or historical compensation
- **Performance reviews** - Evaluation data, ratings
- **Benefits information** - Health insurance, pension details
- **Work location** - Office location, remote work data

## Special Categories of Personal Data (Article 9)

These require explicit consent or specific legal basis:

### Health Data
- **Medical records** - Diagnosis, treatments, prescriptions
- **Health history** - Past illnesses, surgeries, conditions
- **Genetic data** - DNA information, genetic tests
- **Mental health data** - Psychiatric records, therapy notes
- **Disability information** - Physical or mental disabilities
- **Insurance claims** - Health insurance information
- **Wearable device data** - Fitness tracker data, health metrics

### Biometric Data (for identification)
- **Fingerprints** - Fingerprint scans
- **Facial recognition** - Face scans, facial geometry
- **Iris/retina scans** - Eye biometrics
- **Voice prints** - Voice recognition data
- **Gait analysis** - Walking pattern recognition
- **Keystroke dynamics** - Typing patterns

### Sensitive Personal Information
- **Race or ethnic origin** - Racial/ethnic background
- **Political opinions** - Political affiliation, voting history
- **Religious beliefs** - Religious affiliation, practices
- **Philosophical beliefs** - Philosophical convictions
- **Trade union membership** - Union affiliation
- **Sex life** - Sexual activity, relationships
- **Sexual orientation** - Sexual preference, identity

### Criminal Data
- **Criminal convictions** - Conviction records
- **Offenses** - Criminal offense information
- **Proceedings** - Legal proceedings data

## Children's Data

Data of individuals under 16 (or younger depending on member state law) requires:

- Parental consent for processing
- Age verification mechanisms
- Simplified privacy notices
- Enhanced protection measures

Examples:
- School records
- Online activity data
- Location data
- Contact information
- Photos/videos of children

## Derived/Inferred Data

Data created from analyzing other data:

- **Profiles** - User profiles created from behavior
- **Predictions** - Predicted preferences, behaviors
- **Scores** - Credit scores, risk scores, propensity scores
- **Segments** - Marketing segments, audience groups
- **Recommendations** - Product recommendations based on history

## Professional Data

- **Business email** - Work email addresses (still personal data)
- **Job performance** - Metrics, evaluations, KPIs
- **Certifications** - Professional certifications, licenses
- **Publications** - Articles, papers, patents
- **Professional memberships** - Industry associations
- **Work samples** - Portfolio items, code repositories

## Communication Data

- **Email content** - Email messages, attachments
- **Chat messages** - Instant messages, SMS
- **Call logs** - Phone call records, duration
- **Video calls** - Video conference recordings
- **Letters/correspondence** - Physical or digital letters
- **Voice messages** - Voicemail recordings

## Location Data

- **GPS coordinates** - Precise location data
- **Check-ins** - Social media check-ins
- **Travel history** - Places visited, routes taken
- **Home address** - Residential location
- **Work location** - Office or workplace address
- **Geofencing data** - Location-based triggers

## Visual and Audio Data

- **Photographs** - Photos containing identifiable persons
- **Video recordings** - Videos showing individuals
- **Audio recordings** - Voice recordings, calls
- **CCTV footage** - Surveillance camera recordings
- **Screenshots** - Screen captures containing personal data

## Risk Classification

### High Risk Data (Requires Enhanced Protection)
- Special categories (Article 9)
- Financial information
- Authentication credentials
- Children's data
- Data revealing intimate details

### Medium Risk Data
- Contact information
- Demographic information
- Professional information
- Behavioral data
- Location data

### Lower Risk Data (Still Requires Protection)
- Preferences
- Non-sensitive demographics
- Public professional information
- Aggregated/anonymized data (if truly anonymous)

## Pseudonymized vs. Anonymized Data

**Pseudonymized** - Still personal data, reversible with additional information
- Example: User ID instead of name (but can be linked back)

**Anonymized** - No longer personal data, irreversible
- Cannot identify individual even with additional information
- Must be truly irreversible to fall outside GDPR scope

## Data Combinations

Consider that combinations of seemingly non-personal data can become personal:
- ZIP code + birth date + gender = 87% identifiable
- Multiple cookies + browsing patterns = identifiable profile
- Metadata alone can reveal identity

## Context Matters

Whether data is "personal" depends on context:
- Business email at work vs. used personally
- Public information vs. private collection
- Aggregated data that can be de-aggregated
- Data that seems anonymous but can be re-identified
