---
name: ip-attribution
description: A human-centered system for attributing creative contributions across any medium, where containers provide structure and conversations determine value
metadata:
  status: Active
  implementation: Core Philosophy
  last_updated: 2025-10-26
---

# IP Attribution System

> Attribution is a conversation between creators about contribution and intention.

## Overview

A human-centered system for attributing creative contributions across any medium, where containers provide structure and conversations determine value.

## The Deepest Why: Mattering Without Money

While this system enables fair payment, its deeper function is making creative contribution visible. A teenager making their first beat can see it travel the world, even if it never earns a cent. A grandmother sharing a family song can watch it inspire remixes across continents.

The system says: "Your creativity matters, here's the proof" - not through dollars but through visible connection and continuation.

## Core Beliefs

- **Humans declare contribution** - not algorithms
- **Anyone can be a contributor** - people, places, AI, communities, vibes
- **Attribution ≠ Payment** - credit everyone, pay who you can
- **Intentions guide remixing** - licensing as creative conversation
- **Communities shape the system** - not vice versa

## Essential Concepts

### Work
Something created that carries its story of creation.

### Attribution  
A declaration: "This contributed to this work."
- WHO: Any entity (person, place, thing, idea)
- WHAT: Their contribution (decided by creators)
- HOW MUCH: Their share (human judgment)

### TBD Attribution
Crediting someone not yet present in the system.
- Reserve their attribution
- Hold their share if any
- They can claim later
- Or it remains as historical record

### Intentions (Creative Licensing)
How creators hope their work lives on.
- "Free for all uses"
- "Sacred - please contact first"
- "No commercial use without discussion"
- "AI training OK with attribution"
- "Would love to hear what you make!"

These are conversations, not legal barriers.

### Inheritance
How new works relate to previous works.
- Default: 50/50 between original and new
- Always negotiable by humans
- Creates attribution chains/trees
- Respects original intentions

## The Mechanical Layer

### The 50/50 Split Principle
Every content type has two halves:
- IDEA (Composition/Concept) = 100% of idea pie
- IMPLEMENTATION (Recording/Execution) = 100% of implementation pie
- Each pie = 50% of that content type's total value

### Content Type Modularity
Works can contain multiple separable content types:
- Music (melody/lyrics + recording)
- Video (concept + filming/editing)
- Dance (choreography + performance)

Like TikTok - someone can take just your audio, or just your dance.

## The Two Economies: Creation vs Curation

### Economy 1: Transformation (Remixes)
- Sources contribute to new work's IP
- Creator gets commission (20%), not ownership
- IP inheritance flows through
- Pays license fee upfront

Example: Producer remixes two loops
- Original creators: 80% (40% each)
- Remix producer: 20% commission

### Economy 2: Curation (DJ Mixes, Playlists)
- NO IP inheritance
- Curator gets discovery commission (20%)
- Original creators keep 80%
- Can earn from ongoing discovery

Example: DJ creates fire mix
- When mix sells: DJ 20%, originals 80%
- When originals sell via discovery: DJ gets referral

### Why This Distinction Matters
- Creation = Making something new (deserves commission)
- Curation = Finding gems (deserves discovery fee)
- Both valuable, different contributions

## Emergent Business Models

### The Instant Record Label
Anyone can become a label through curation:
- Create account with label identity
- Curate playlists and artists
- Feature in your store
- Earn 20% on discoveries
- No contracts needed

### The Artist Strategy Flip
Old: Seek ONE label deal
New: Appear in MANY curator stores
- 10 stores = 10 audiences
- 10 revenue streams
- Keep all rights
- Cooperation over competition

## AI Collaboration

### AI as Contributor
Like any contributor, AI can be credited:
- Declare AI's contribution percentage
- Humans decide, not calculated
- Revenue typically stays with humans (who pay for AI)
- Attribution for transparency, not payment

### AI Training Permissions
Artists set preferences:
- "No AI training"
- "Training OK with attribution"
- "Training OK with fee"
- "Academic only"

### Why Attribute AI?
- Transparency (audiences deserve to know)
- Cultural documentation
- Legal protection
- Community norms emerge

## Templates (Conversation Starters)

### Creation
1. **Solo Creator** - "I made this"
2. **Equal Partners** - "We're all in this together"  
3. **Weighted** - "We contributed differently"
4. **Community + Individual** - "Traditional song, modern recording"
5. **AI Collaboration** - "Me and Claude made this"

### Intentions
1. **Open Garden** - "Plant seeds freely"
2. **Sacred Ground** - "Tread respectfully"
3. **Fair Trade** - "Share alike"
4. **Gift Economy** - "Keep creating, forget money"

## Real Examples

### The Restaurant
"Midnight Masala"
- Asha: 40% (melody, lyrics)
- Dev: 40% (production)  
- Indian Kitchen: 20% (where every hook was born)

### Sacred Remix
Traditional Lakota song:
- Marked: "Sacred - contact first"
- Remixer reaches out
- Agreement: 40% to Pine Ridge Foundation
- New work honors tradition

### The Vibe Credit
"Summer Sessions EP"
- Band: 80%
- Jamie: 10% (kept everyone laughing)
- Beach House: 10% (where we recorded)

## Platform Context

This attribution system is Layer 1 of a three-layer architecture:
- Layer 1: Attribution (this system)
- Layer 2: Visualization (see your impact)
- Layer 3: Creative toys (DJ mixer, cultural interfaces)

The attribution must be solid because everything builds on it.

## Key Principles

1. **Simplicity Over Complexity** - Basic containers, human decisions
2. **Attribution Over Calculation** - Declare, don't measure
3. **Conversation Over Contract** - Negotiate, don't dictate
4. **Evolution Over Perfection** - Let communities shape the system
5. **Everyone Matters** - From Navajo grandmother to 14-year-old in Canada

## Implementation Status

✅ **Built**: Gen 1 Remix System
- 50/50 IP inheritance
- Smart contract payment distribution
- Up to 7 contributors per side

📝 **Planned**: Curation Economy
- Playlists with 20% commission
- Discovery referral tracking
- Creator stores as labels

## Further Reading

- See `references/philosophy.md` for deeper exploration of human judgment vs algorithmic calculation
- See `references/examples.md` for detailed case studies
- See `references/ai-attribution.md` for AI collaboration patterns