# Detailed Attribution Examples

## The Restaurant Attribution Case Study

### The Story
Yoku and Sam were stuck on a melody for weeks. They kept meeting at Indian Kitchen, their local restaurant, ordering the same curry, sitting at the same table. One evening, the owner's daughter was practicing tabla in the back room. That rhythm unlocked everything. They wrote "Midnight Masala" that night.

### The Attribution Conversation

**Sam**: "It's basically 50/50 between us, right?"

**Yoku**: "What about Indian Kitchen? That tabla rhythm was everything."

**Sam**: "True. How about 40/40/20?"

**Owner** (when asked): "You made something beautiful here? Then we're part of it."

### The Final Attribution
- Yoku: 40% (melody, lyrics, production)
- Sam: 40% (arrangement, bass, production)
- Indian Kitchen: 20% (where the magic happened)

### How It Works Technically
- Spin up TBD wallet for Indian Kitchen
- They can claim it later if they want
- Or it remains as historical record
- Either way, they're credited

## The Sacred Song Remix Case Study

### The Story
A traditional Lakota sun dance song has been sung for over 100 years. Marcus, a producer from Denver, hears it in a documentary. He wants to create an electronic version that honors the tradition while bringing it to new audiences.

### The Attribution Conversation

**Marcus** reaches out to Pine Ridge Cultural Center.

**Elder**: "This song belongs to all Lakota people. It's sacred but not secret. If you honor it, you can work with it."

**Marcus**: "How should attribution work?"

**Elder**: "The song itself must be credited to Lakota tradition. Any money from that part should go to our language preservation program. Your new work is yours, but remember where it comes from."

### The Final Attribution

**Original Song Component** (50%):
- Lakota Traditional: 100% → Pine Ridge Foundation

**New Production Component** (50%):
- Marcus: 100%

**Effective Split**:
- Pine Ridge Foundation: 50%
- Marcus: 50%

### The Intention Setting
- Original marked: "Sacred - contact before commercial use"
- Remix marked: "Honors Lakota tradition - portion funds language preservation"

## The Bedroom Producer Discovery Case Study

### The Story
Aaliyah, 16, makes beats in her bedroom in Detroit. She uploads them to the platform marked "Open Garden - plant seeds freely." Jorge in Mexico City discovers one loop, uses it in his cumbia-electronica fusion. The track blows up on streaming platforms.

### The Attribution Flow

**Original Loop**:
- Aaliyah: 100%
- Intention: "Use freely, just credit me"

**Jorge's Remix**:
- Source attribution: Aaliyah 50%
- New work: Jorge 50%
- Jorge pays 1 STX license fee

**When Remix Succeeds**:
- Streaming revenue flows 50/50
- Aaliyah's profile rises
- More producers discover her loops
- She starts getting collaboration requests

### The Network Effect
- 10 other producers find Aaliyah through Jorge's remix
- Each creates something new
- Aaliyah now has income from 11 sources
- Never signed anything away

## The Multi-Modal Collaboration Case Study

### The Story
A work contains:
- Music by Chen and Priya
- Video by Sue and Nicolette
- Dance by Marcus
- AI visuals by Diego using Midjourney

### The Attribution Conversation

**For Music** (counts as one content type):
- Idea (composition): Chen 60%, Priya 40%
- Implementation (recording): Chen 40%, Priya 60%

**For Video** (separate content type):
- Idea (concept): Sue 50%, Nicolette 50%
- Implementation (filming): Sue 100%

**For Dance** (separate content type):
- Idea (choreography): Marcus 100%
- Implementation (performance): Marcus 100%

**For AI Visuals** (separate content type):
- Idea (prompts/curation): Diego 100%
- Implementation (generation): Diego 80%, Midjourney 20%
- Note: Midjourney's 20% burns to treasury since AI doesn't need payment

### How It Modularizes
Someone can:
- Use just the music for a podcast
- Use just the dance for a tutorial
- Use just the video for an installation
- Recombine differently

Each extraction maintains its attribution chain.

## The Curation Economy Case Study

### The Story
Grace is a DJ who discovers amazing Afrobeat loops from Lagos, combines them with Brazilian funk from São Paulo, creating 8-bar selections that showcase global groove. She doesn't create new music but her curation is fire.

### The Attribution Model

**For Her DJ Mix**:
- Original creators: 80%
- Grace (curator): 20%

**The Twist**:
When people discover the original loops through Grace and buy them:
- Grace gets 20% discovery commission
- Original creators get 80%

### The Economics
Month 1:
- Grace's mix sells 100 times at 2 STX = 200 STX
- Grace earns: 40 STX
- Original creators share: 160 STX

Month 2:
- People buy originals after discovery: 50 sales at 1 STX
- Grace earns additional: 10 STX
- Original creators earn: 40 STX

Grace builds reputation as tastemaker without exploiting creators.

## The AI Collaboration Case Study

### The Story
Jordan uses Claude to help write lyrics, Suno to generate a melody, then records their own vocals and production.

### The Attribution Declaration

**Jordan's Decision**:
- Lyrics: Jordan 70%, Claude 30%
- Melody: Suno 100%
- Vocals: Jordan 100%
- Production: Jordan 100%

**Overall Attribution**:
- Jordan: 75%
- Suno: 15%
- Claude: 10%

### The Revenue Flow
Since Jordan pays for both AI services:
- Jordan keeps 100% of revenue
- AI attribution is informational
- Audiences see the AI contribution
- Transparency without penalty

## The Failed Band Case Study

### The Story
Five friends start a band. They agree to equal splits on everything. Two years later, three members have contributed significantly more. They want to adjust splits. Two members disagree.

### The System Response

**The Beauty**: Everything already attributed
- Past works maintain original splits
- Future works can have new splits
- No retroactive changes needed
- History preserved

**The Resolution**:
- Old songs: Equal splits remain
- New songs: New agreement
- Some members focus on performance (curation income)
- Others focus on writing (creation income)
- Band continues with flexibility

## The Traditional + Modern Case Study

### The Story
A Moroccan gnawa musician collaborates with a London electronic producer. The traditional patterns are centuries old, the electronic production is brand new.

### The Attribution Philosophy

**The Question**: How do you value ancient knowledge vs modern skill?

**The Answer**: You ask the humans involved.

**Their Conversation**:
- "These patterns are my grandfather's grandfather's music"
- "But you're bringing them alive today"
- "Your production makes them travel the world"
- "Your knowledge makes them authentic"

**Their Decision**:
- Traditional patterns (idea): Gnawa musician 100%
- Modern production (implementation): London producer 100%
- Results in 50/50 overall

Both feel respected. Both profit. Culture preserved and evolved.

## Key Lessons from Examples

1. **Every situation is unique** - Templates start conversations
2. **Humans know fairness** - Let them decide
3. **Attribution is story** - Preserve the narrative
4. **Flexibility enables creativity** - Rigid rules kill collaboration
5. **Transparency builds trust** - Show everything
6. **Everyone can contribute** - From restaurants to AI to tradition