# LinkedIn Post: Moving Rainbow MicroPython Skill Announcement

---

🚀 **Excited to announce a new Claude Code skill for MicroPython LED programming!**

I've just created a specialized skill for the Moving Rainbow educational project that makes it easier than ever to generate MicroPython code for NeoPixel LED strips and Raspberry Pi Pico.

**What is it?**
The Moving Rainbow skill is a Claude Code extension that helps educators, students, and makers quickly generate clean, educational MicroPython programs for LED strip animations. It's designed specifically for the Raspberry Pi Pico with NeoPixel/WS2812B addressable LEDs.

**Key Features:**
✨ Generates complete, ready-to-run MicroPython code
🎨 Built-in patterns: rainbow cycles, comet tails, moving dots, candle flickers, and more
🎮 Button control integration with proper debouncing
📚 Educational focus with clear comments and progressive complexity
🔧 Hardware-agnostic through configuration files

**Perfect for:**
• Computer science educators teaching physical computing
• Students learning programming with tangible feedback
• Makers prototyping LED projects
• Anyone building interactive LED installations

**Example:** Just ask Claude: "Create a rainbow animation that cycles through colors with button controls" and get production-ready code that follows best practices for MicroPython and the Pico.

The skill is built using the Anthropic Skills framework and is open source as part of the Moving Rainbow educational project.

**Link to project:** https://github.com/dmccreary/moving-rainbow

This is what I love about modern AI-assisted development - we can create tools that not only help us code faster, but also help teach the next generation of programmers through clear, well-structured examples.

#MicroPython #RaspberryPiPico #LEDProgramming #EdTech #ComputationalThinking #MakerEducation #STEM #Claude #AI #OpenSource

---

**Optional additions based on your preference:**

**For more technical audience:**
The skill leverages Claude Code's progressive disclosure design - keeping lightweight metadata always available while loading detailed instructions and reference materials only when needed. This ensures fast performance even with comprehensive educational content.

**For educator-focused audience:**
Interested in using this for your classroom? The Moving Rainbow project includes complete lesson plans, hardware assembly guides, and a progressive curriculum from basic "blink" programs through advanced multi-mode animations.

**Call to action options:**
- Questions about using this in your classroom or project? Drop a comment!
- Check out the full documentation and examples in the GitHub repo
- Fellow educators: Would love to hear how you're teaching physical computing!

---

**Image suggestions for the post:**
1. Photo of an illuminated NeoPixel strip showing a rainbow animation
2. Screenshot of generated code with clear annotations
3. Raspberry Pi Pico with LED strip and buttons (the actual hardware setup)
4. Before/after comparison: user request → generated code
